@q  Copyright (c) 1990 The Regents of the University of California. @>
@q  All rights reserved. @>

@q  This code is derived from software contributed to Berkeley by @>
@q  Vern Paxson. @>

@q  The United States Government has rights in this work pursuant @>
@q  to contract no. DE-AC03-76SF00098 between the United States @>
@q  Department of Energy and the University of California. @>

@q  This file is part of SPLinT. @>

@q  Redistribution and use in source and binary forms, with or without @>
@q  modification, are permitted provided that the following conditions @>
@q  are met: @>

@q  1. Redistributions of source code must retain the above copyright @>
@q     notice, this list of conditions and the following disclaimer. @>
@q  2. Redistributions in binary form must reproduce the above copyright @>
@q     notice, this list of conditions and the following disclaimer in the @>
@q     documentation and/or other materials provided with the distribution. @>

@q  Neither the name of the University nor the names of its contributors @>
@q  may be used to endorse or promote products derived from this software @>
@q  without specific prior written permission. @>

@q  THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR @>
@q  IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED @>
@q  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR @>
@q  PURPOSE. @>

@**The lexer for \ifx\flex\UNDEFINED\.{flex}\else\flex\ \fi syntax.
\ifx\flex\UNDEFINED
    \input limbo.sty
    \input yystype.sty
    \input grabstates.sty
    \immediate\openout\stlist=fil_states.h
\fi
The original lexer for \flex\ grammar relies on a few rules that use `trailing context'.
The lexing mechanism implemented by \splint\ cannot process such rules properly in general.
The rules used by \flex\ match fixed-length trailing context only, which makes it possible
to replace them with ordinary patterns and use |yyless()| in the actions.
@(fil.ll@>=
@G
%{@> @<Preamble for \flex\ lexer@> @=%}
 @> @<Options for \flex\ input lexer@> @= 
 @> @<Output file for \flex\ input lexer@> @= 
 @> @<State definitions for \flex\ input lexer@> @= 
 @> @<Definitions for \flex\ input lexer@> @= 
%%
 @> @<Postamble for \flex\ input lexer@> @= 
 @> @<Common patterns for \flex\ lexer@> @= 
 @> @<Patterns for \flex\ lexer@> @= 
%%
 @> @<Auxilary code for \flex\ lexer@> @= 
@g

@ Bootstrap lexer.
@(ssfs.ll@>=
@G
%{@> @<Preamble for \flex\ lexer@> @=%}
 @> @<Options for \flex\ input lexer@> @= 
 @> @<Output file for the bootstrap \flex\ lexer@> @= 
 @> @<Definitions for \flex\ input lexer@> @= 
%%
 @> @<Common patterns for \flex\ lexer@> @= 
 @> @<Catchall rule for the bootstrap lexer@> @= 
%%
 @> @<Auxilary code for the bootstrap \flex\ lexer@> @= 
@g

@ @<Preamble for \flex\ lexer@>=

@ There are a few options that are necessary to ensure that the lexer
functions properly. Some of them (like \.{caseless}) directly
affect the behavior of the scanner, others (e.g.~\.{noyy\_top\_state})
prevent generation of unnecessary code.
@<Options for \flex\ input lexer@>=
@G(fs1)
%option caseless nodefault stack noyy_top_state
%option nostdinit
%option bison-bridge
%option noyywrap nounput noinput reentrant 
%option debug
%option stack

@ @<Output file for \flex\ input lexer@>=
@G(fs1)
%option outfile="fil.c"
@g

@ @<Output file for the bootstrap \flex\ lexer@>=
@G(fs1)
%option outfile="ssfs.c"
@g

@*1 Regular expression and state definitions.
The lexer uses a large number of states to control its operation. Both
section~1 and section~2 rules rely on the scanner being in the
appropriate state. Otherwise (see \.{symbols.sty} example) the lexer
may parse the same fragment in a wrong context.
@<State definitions for \flex\ input lexer@>=
@G(fs1)
%x SECT2 SECT2PROLOG SECT3 CODEBLOCK PICKUPDEF SC CARETISBOL NUM QUOTE
%x FIRSTCCL CCL ACTION RECOVER COMMENT ACTION_STRING PERCENT_BRACE_ACTION
%x OPTION LINEDIR CODEBLOCK_MATCH_BRACE
%x GROUP_WITH_PARAMS
%x GROUP_MINUS_PARAMS
%x EXTENDED_COMMENT
%x COMMENT_DISCARD

@ Somewhat counterintuitively, \flex\ definitions do not {\it always\/} have to be
fully formed regular expressions. For example, after
$$
\hbox to 3in{\flexrenstyle{BOGUS}\hfil\.{\^[a-}}
$$
one can form the following action:
$$
\hbox to 3in{\flexrenstyle{BOGUS}\.{t]}\hfil\.{;}}
$$
although without the `\.{\^}' in the definition of
`\flexrenstyle{BOGUS}' \flex\ would have put a `\.{)}' inside the
character class. We will assume such (rather counterproductive) tricks
are not used. If the definition is not a well-formed regular
expression the pretty printing will be suspended.
@<Definitions for \flex\ input lexer@>=
@G(fs1)
WS		[[:blank:]]+
OPTWS		[[:blank:]]*
NOT_WS		[^[:blank:]\r\n]

NL		\r?\n

NAME		([[:alpha:]_][[:alnum:]_-]*)
NOT_NAME	[^[:alpha:]_*\n]+

SCNAME		{NAME}

ESCSEQ		(\\([^\n]|[0-7]{1,3}|x[[:xdigit:]]{1,2}))

FIRST_CCL_CHAR	([^\\\n]|{ESCSEQ})
CCL_CHAR	([^\\\n\]]|{ESCSEQ})
CCL_EXPR	("[:"^?[[:alpha:]]+":]")

LEXOPT		[porkacne]

M4QSTART    "[["
M4QEND      "]]"

@ @<Postamble for \flex\ input lexer@>=

@*1 Regular expressions for \flex\ input scanner.
The code below treats \prodstyle{\%pointer} and \prodstyle{\%array} the same way it treats
\prodstyle{\%option} while typesetting.
@<Common patterns for \flex\ lexer@>=
@G(fs2)
<INITIAL>{
        ^{WS}              {@> @[TeX_( "/flindented@@codetrue/yyBEGIN{CODEBLOCK}/yylexnext" );@]@=}
        ^"/*"              {@> @[TeX_( "/yypushstate{COMMENT}/yylexnext" );@]@=}
        ^#{OPTWS}line{WS}  {@> @[TeX_( "/yypushstate{LINEDIR}/yylexnext" );@]@=}
        ^"%s"{NAME}?       {@> @[TeX_( "/yylexreturnptr{SCDECL}" );@]@=}
        ^"%x"{NAME}?       {@> @[TeX_( "/yylexreturnptr{XSCDECL}" );@]@=}
        ^"%{".*{NL}        {@> @<Start a \Cee\ code section@> @=}
        
    ^"%top"[[:blank:]]*"{"[[:blank:]]*{NL}    {@> @<Begin the \prodstyle{\%top} directive@> @=}
    ^"%top".*              {@> @[TeX_( "/yyfatal{malformed '/harmlesscomment top' directive}" );@] @=}

        {WS}               {@> @[;@]/* discard */ @=}

        ^"%%".*            {@> @<Start section 2@> @=}

        ^"%pointer".*{NL}  {@> @[TeX_( "/flinc@@linenum/yylexreturn{POINTER_OP}" );@]@=}
        ^"%array".*{NL}    {@> @[TeX_( "/flinc@@linenum/yylexreturn{ARRAY_OP}" );@]@=}

        ^"%option"         {@> @[TeX_( "/yyBEGIN{OPTION}/yylexreturn{OPTION_OP}" );@]@=}

        ^"%"{LEXOPT}{OPTWS}[[:digit:]]*{OPTWS}{NL} {@> @[TeX_( "/flinc@@linenum/yyflexoptreturn{OPT_DEPRECATED}" );@]@=}
        ^"%"{LEXOPT}{WS}.*{NL}                     {@> @[TeX_( "/flinc@@linenum/yyflexoptreturn{OPT_DEPRECATED}" );@]@=}

        ^"%"[^porksexcan{}].*   {@> @[TeX_( "/yyfatal{unrecognized '/harmlesscomment' directive: /the/yytext}" );@] @=}

        ^{NAME}            {@> @<Copy the name and start a definition@> @=}
        {SCNAME}            @> @[TeX_( "/RETURNNAME" );@] @= 
        ^{OPTWS}{NL}       {@> @[TeX_( "/flinc@@linenum/yylexnext" );@]/* allows blank lines in section 1 */@=}
        {OPTWS}{NL}        {@> @[TeX_( "/flinc@@linenum/yylexnext" );@]/* maybe end of comment line */@=}
}

@ @<Start a \Cee\ code section@>=
    @[TeX_( "/flinc@@linenum" );@]@;
    @[TeX_( "/flindented@@codefalse/yyBEGIN{CODEBLOCK}" );@]@;
    @[TeX_( "/yylexnext" );@]@;

@ Ignore setting |brace_start_line| as it is only used internally to report errors.
@<Begin the \prodstyle{\%top} directive@>=
    @[TeX_( "/flinc@@linenum" );@]@;
    @[TeX_( "/def/flbrace@@depth{1}" );@]@;
    @[TeX_( "/yypushstate{CODEBLOCK_MATCH_BRACE}/yylexnext" );@]@;

@ @<Start section 2@>=
    @[TeX_( "/def/flsectnum{2}/def/flbracelevel{0}" );@]@;
    @[TeX_( "/yyBEGIN{SECT2PROLOG}/yylexreturnptr{SECTEND}" );@]@;

@ @<Copy the name and start a definition@>=
    @[TeX_( "/fldidadeffalse/yyBEGIN{PICKUPDEF}" );@]@;
    @[TeX_( "/yylexreturnsym{DEF_OP}" );@]@;

@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<COMMENT>{
       "*/"     {@> @[TeX_( "/yypopstate/yylexnext" );@]@=}
        "*"     {@> @[TeX_( "/yylexnext" );@]@=}
 {M4QSTART}     {@> @[TeX_( "/yylexnext" );@]@=}
   {M4QEND}     {@> @[TeX_( "/yylexnext" );@]@=}
     [^*\n]     {@> @[TeX_( "/yylexnext" );@]@=}
       {NL}     {@> @[TeX_( "/flinc@@linenum/yylexnext" );@]@=}
}

/* This is the same as \flexsnstyle{COMMENT}, but is discarded rather than output. */
<COMMENT_DISCARD>{
       "*/"     {@> @[TeX_( "/yypopstate/yylexnext" );@]@=}
        "*"     {@> @[TeX_( "/yylexnext" );@]@=}
     [^*\n]     {@> @[TeX_( "/yylexnext" );@]@=}
       {NL}     {@> @[TeX_( "/flinc@@linenum/yylexnext" );@]@=}
}

<EXTENDED_COMMENT>{
        ")"     {@> @[TeX_( "/yypopstate/yylexnext" );@]@=}
   [^\n\)]+     {@> @[TeX_( "/yylexnext" );@]@=}
       {NL}     {@> @[TeX_( "/flinc@@linenum/yylexnext" );@]@=}
}

<LINEDIR>{
           \n   {@> @[TeX_( "/yypopstate/yylexnext" );@]@=}
 [[:digit:]]+   {@> @[TeX_( "/fllinenum=/number/the/yytext/yylexnext" );@]@=}
  \"[^"\n]*\"   {@> @[TeX_( "/yylexnext" );@] /* ignore the file name in the line directives */ @=}
        .       {@> @[TeX_( "/yylexnext" );@] /* ignore spurious characters */ @=}
}

<CODEBLOCK>{
  ^"%}".*{NL}   {@> @[TeX_( "/flinc@@linenum/yyBEGIN{INITIAL}/yylexnext" );@]@=}
   {M4QSTART}   {@> @[TeX_( "/yylexnext" );@]@=}
     {M4QEND}   {@> @[TeX_( "/yylexnext" );@]@=}
            .   {@> @[TeX_( "/yylexnext" );@]@=}
         {NL}   {@> @[TeX_( "/flinc@@linenum/ifflindented@@code/yyBEGIN{INITIAL}/fi/yylexnext" );@]@=}
}

<CODEBLOCK_MATCH_BRACE>{
    "}"         {@> @<Pop state if code braces match@> @=}
    "{"         {@> @[TeX_( "/flinc/flbrace@@depth/yylexnext" );@] @=}
    {NL}        {@> @[TeX_( "/flinc@@linenum/yylexnext" );@]@=}
    {M4QSTART}  {@> @[TeX_( "/yylexnext" );@]@=}
    {M4QEND}    {@> @[TeX_( "/yylexnext" );@]@=}
    [^{}\r\n]   {@> @[TeX_( "/yylexnext" );@]@=}
    <<EOF>>     {@> @[TeX_( "/yyfatal{Unmatched '/lbchar'}" );@] @=}
}

@ @<Pop state if code braces match@>=
    @[TeX_( "/fldec/flbrace@@depth" );@]@;
    @[TeX_( "/ifnum/flbrace@@depth=/z@@/relax" );@]@;
    @[TeX_( "    /yypopstate/yylexreturnxchar/n" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /yylexnext" );@]@;
    @[TeX_( "/fi" );@]@;

@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<PICKUPDEF>{
        {WS}      {@> @[TeX_( "/yylexnext" );@]@=}
 {NOT_WS}[^\r\n]* {@> @<Skip trailing whitespace, save the definition@> @=}
        {NL}      {@> @<Complain if not inside a definition, continue otherwise@> @=}
}

@ @<Skip trailing whitespace, save the definition@>=
    @[TeX_( "/edef/flnmdef{{/the/yytext}{/the/yytextpure}{/the/yyfmark}{/the/yysmark}}" );@]@;
    @[TeX_( "/fldidadeftrue/yylexnext" );@]@;

@ @<Complain if not inside a definition, continue otherwise@>=
    @[TeX_( "/iffldidadef" );@]@;
    @[TeX_( "    /yylval/expandafter{/flnmdef}" );@]@;
    @[TeX_( "    /yybreak{/flinc@@linenum/yyBEGIN{INITIAL}/yylexreturn{RE_DEF}}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /yybreak{/yyfatal{incomplete name definition}}" );@]@;
    @[TeX_( "/yycontinue" );@]@;

@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<OPTION>{
        {NL}            {@> @[TeX_( "/flinc@@linenum/yyBEGIN{INITIAL}/yylexnext" );@] @=}
        {WS}            {@> @[TeX_( "/floption@@sensetrue/yylexnext" );@] @=}

        "="             {@> @[TeX_( "/yylexreturnchar" );@]@=}

        no              {@> @<Toggle |option_sense|@> @=};

        7bit            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        8bit            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        align           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
   always-interactive   {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        array           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
    ansi-definitions    {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
    ansi-prototypes     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        backup          {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        batch           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
    bison-bridge        {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
    bison-locations     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        "c++"           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
 caseful|case-sensitive {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
 caseless|case-insensitive {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        debug           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        default         {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        ecs             {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        fast            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        full            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        input           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        interactive     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        lex-compat      {@> @<Set |lex_compat|@> @=}
        posix-compat    {@> @<Set |posix_compat|@> @=}
        main            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        meta-ecs        {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
  never-interactive     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        perf-report     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        pointer         {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        read            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
    reentrant           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        reject          {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        stack           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        stdinit         {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        stdout          {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
    unistd              {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        unput           {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        verbose         {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        warn            {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yylineno        {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yymore          {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yywrap          {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        yy_push_state   {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yy_pop_state    {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yy_top_state    {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        yy_scan_buffer  {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yy_scan_bytes   {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yy_scan_string  {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        yyalloc         {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyrealloc       {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyfree          {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        
        yyget_debug     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_debug     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_extra     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_extra     {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_leng      {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_text      {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_lineno    {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_lineno    {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_in        {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_in        {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_out       {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_out       {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_lval      {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_lval      {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyget_lloc      {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}
        yyset_lloc      {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        extra-type      {@> @[TeX_( "/yylexreturn{OPT_EXTRA_TYPE}" );@]@=}
        outfile         {@> @[TeX_( "/yylexreturn{OPT_OUTFILE}" );@]@=}
        prefix          {@> @[TeX_( "/yylexreturn{OPT_PREFIX}" );@]@=}
        yyclass         {@> @[TeX_( "/yylexreturn{OPT_YYCLASS}" );@]@=}
        header(-file)?  {@> @[TeX_( "/yylexreturn{OPT_HEADER}" );@]@=}
        tables-file     {@> @[TeX_( "/yylexreturn{OPT_TABLES}" );@]@=}
        tables-verify   {@> @[TeX_( "/yyflexoptreturn{OPT_OTHER}" );@]@=}

        \"[^"\n]*\"     {@> @[TeX_( "/edef/flnmstr{{/the/yytext}{/the/yytextpure}}/yylexreturnsym{NAME}" );@]@=}

 (([a-mo-z]|n[a-np-z])[[:alpha:]\-+]*)|. {@> @[TeX_( "/yyfatal{unrecognized /%option: /the/yytext}" );@]@=}
}

@ @<Toggle |option_sense|@>=
    @[TeX_( "/iffloption@@sense" );@]@;
    @[TeX_( "    /floption@@sensefalse" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /floption@@sensetrue" );@]@;   
    @[TeX_( "/fi/yylexnext" );@]@;

@ @<Set |lex_compat|@>=
    @[TeX_( "/iffloption@@sense" );@]@;
    @[TeX_( "    /fllex@@compattrue" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /fllex@@compatfalse" );@]@;
    @[TeX_( "/fi/yyflexoptreturn{OPT_OTHER}" );@]@;

@ @<Set |posix_compat|@>=
    @[TeX_( "/iffloption@@sense" );@]@;
    @[TeX_( "    /flposix@@compattrue" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /flposix@@compatfalse" );@]@;
    @[TeX_( "/fi/yyflexoptreturn{OPT_OTHER}" );@]@;

@ The \flexsnstyle{RECOVER} state is never used for typesetting and is only added for completeness.
@<Patterns for \flex\ lexer@>=
@G(fs2)
<RECOVER>.*{NL}      {@> @[TeX_( "/flinc@@linenum/yyBEGIN{INITIAL}/yylexnext" );@] @=}

@ Like \bison, \flex\ allows insertion of \Cee\ code in the middle of the input file.
@<Patterns for \flex\ lexer@>=
@G(fs2)
<SECT2PROLOG>{
        ^"%{".*      {@> @<Consume the brace and increment the brace level@> @=}
        ^"%}".*      {@> @<Consume the brace and decrement the brace level@> @=}

        ^{WS}.*      {@> @[TeX_( "/yylexnext" );@]@=}

        ^{NOT_WS}.*  {@> @<Begin section 2, prepare to reread, or ignore braced code@> @=}
        .            {@> @[TeX_( "/yylexnext" );@] @=}
        {NL}         {@> @[TeX_( "/flinc@@linenum/yylexnext" );@] @=}

        <<EOF>>      {@> @[TeX_( "/def/flsectnum{0}/yyterminate" );@] @=}
}

@ All the code inside is ignored.
@<Consume the brace and increment the brace level@>=
    @[TeX_( "/flinc/flbracelevel/yyless{2}/yylexnext" );@]@;

@ @<Consume the brace and decrement the brace level@>=
    @[TeX_( "/fldec/flbracelevel/yyless{2}/yylexnext" );@]@;

@ @<Begin section 2, prepare to reread, or ignore braced code@>=
    @[TeX_( "/ifnum/flbracelevel>/z@@" );@]@;
    @[TeX_( "    /yybreak/yylexnext" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /yybreak{/yysetbol{/@@ne}/yyBEGIN{SECT2}/yyless{0}/yylexnext}" );@]@;
    @[TeX_( "/yycontinue" );@]@;
    
@ A pattern below (for the character class processing) had to be broken into two lines.
A special symbol ($\odot$\gtextidx{$\odot$ separator, \flex}{0. separator, flex}{\flexidxdomain})
has been inserted to indicate that a break had occured.

The macros for \flex\
typesetting use a different mechanism from that of \bison\ macros and allow typographic
corrections to be applied to sections of the \flex\ code represented by various nonterminals.
These corrections can also be delayed. For the details, an interested reader may consult
\.{yyunion.sty}.
@<Patterns for \flex\ lexer@>=
@G(fs2)
<SECT2>{
        ^{OPTWS}{NL}    {@> @[TeX_( "/flinc@@linenum/yylexnext" );@] /* allow blank lines in section 2 */ @=}
        ^{OPTWS}"%{"    {@> @<Start braced code in section 2@> @=}
        ^{OPTWS}"<"     {@> @[TeX_( "/ifflsf@@skip@@ws/else/yyBEGIN{SC}/fi/yylexreturnraw<" );@] @=}
        ^{OPTWS}"^"     {@> @[TeX_( "/yylexreturnraw^" );@] @=}
        \"              {@> @[TeX_( "/yyBEGIN{QUOTE}/yylexreturnxchar/flquotechar" );@] @=}
        "{"[[:digit:]]  {@> @<Process a repeat pattern@> @=}
 "$"([[:blank:]]|{NL})  {@> @[TeX_( "/yyless{1}/yylexreturnraw/$" );@] @=}

        {WS}"%{"        {@> @<Process braced code in the middle of section 2@> @=}
        {WS}"|".*{NL}   {@> @<Process a deferred action@> @=}
        ^{WS}"/*"       {@> @<Process a comment inside a pattern@> @=}
        ^{WS}            @> ; /* allow indented rules */@= 
        {WS}            {@> @<Decide whether to start an action or skip whitespace inside a rule@> @=}

        {OPTWS}{NL}     {@> @<Finish the line and/or action@> @=}

        ^{OPTWS}"<<EOF>>"       |
        "<<EOF>>"       {@> @[TeX_( "/yylexreturnptr{EOF_OP}" );@] @=}

        ^"%%".*         {@> @<Start section 3@> @=}
@t}\vb{\insertraw{\insrulealign{\rulealigntemplate}{\cr\egroup\egroup}}}{@>
        "["@>@t}\vb{\insertraw{\insparensalign{&}{}}}{@>@=({FIRST_CCL_CHAR}|{CCL_EXPR})@>@t}\vb{\insertraw{\insparensalign{\rlap{$\odot$}\cr&}{}}}{@>@=({CCL_CHAR}|{CCL_EXPR})*  {@> @<Start processing a character class@> @=}

        "{-}"           {@> @[TeX_( "/yylexreturn{CCL_OP_DIFF}" );@] @=}
        "{+}"           {@> @[TeX_( "/yylexreturn{CCL_OP_UNION}" );@] @=}

        "{"{NAME}"}"[[:space:]]?  {@> @<Process a named expression after checking for whitespace at the end@> @=}

         "/*"           {@> @<Decide if this is a comment@> @=}
         "(?#"          {@> @<Determine if this is extended syntax or return a parenthesis@> @=}
         "(?"           {@> @<Determine if this is a parametric group or return a parenthesis@> @=}
         "("            {@> @[TeX_( "/flsf@@push/yylexreturnraw/(" );@] @=}
         ")"            {@> @[TeX_( "/flsf@@pop/yylexreturnraw/)" );@] @=}

        [/|*+?.(){}]    {@> @[TeX_( "/yylexreturnchar" );@] @=}
        .               {@> @[TeX_( "/RETURNCHAR" );@] @=}
}

@ @<Start braced code in section 2@>=
    @[TeX_( "/def/flbracelevel{1}" );@]@;
    @[TeX_( "/indented@@codefalse/doing@@codeblocktrue" );@]@;
    @[TeX_( "/yyBEGIN{PERCENT_BRACE_ACTION}" );@]@;
    @[TeX_( "/yylexnext" );@]@;

@ @<Process a repeat pattern@>=
    @[TeX_( "/yyless{1}/yyBEGIN{NUM}" );@]@;
    @[TeX_( "/iffllex@@compat" );@]@;
    @[TeX_( "    /yybreak{/yylexreturn{BEGIN_REPEAT_POSIX}}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /ifflposix@@compat" );@]@;
    @[TeX_( "        /yybreak@@{/yylexreturn{BEGIN_REPEAT_POSIX}}" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yybreak@@{/yylexreturn{BEGIN_REPEAT_FLEX}}" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "/yycontinue" );@]@;

@ @<Process braced code in the middle of section 2@>=
    @[TeX_( "/def/flbracelevel{1}" );@]@;
    @[TeX_( "/yyBEGIN{PERCENT_BRACE_ACTION}" );@]@;
    @[TeX_( "/ifflin@@rule" );@]@;
    @[TeX_( "    /fldoing@@rule@@actiontrue" );@]@;
    @[TeX_( "    /flin@@rulefalse" );@]@;
    @[TeX_( "    /yybreak{/yylexreturnxchar/n}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /yybreak/yylexnext" );@]@;
    @[TeX_( "/yycontinue" );@]@;
                        
@ This action has been changed to accomodate the new grammar. The separator (\.{\yl})
is treated as an ordinary (empty) action.
@<Process a deferred action@>=
    @[TeX_( "/ifflsf@@skip@@ws" );@]@;/* whitespace ignored, still inside a pattern */
    @[TeX_( "    /yylessafter{|}" );@]@;
    @[TeX_( "    /yybreak/yylexnext" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /flinc@@linenum" );@]@;
    @[TeX_( "    /fldoing@@rule@@actiontrue" );@]@;
    @[TeX_( "    /flin@@rulefalse" );@]@;
    @[TeX_( "    /flcontinued@@actiontrue" );@]@;
    @[TeX_( "    /unput{/n}" );@]@;
    @[TeX_( "    /yyBEGIN{ACTION}" );@]@;
    @[TeX_( "    /yybreak{/yylexreturnxchar/n}" );@]@;
    @[TeX_( "/yycontinue" );@]@;

@ @<Process a comment inside a pattern@>=
    @[TeX_( "/ifflsf@@skip@@ws" );@]@;
    @[TeX_( "    /yypushstate{COMMENT_DISCARD}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /unput{//*}" );@]@;
    @[TeX_( "    /def/flbracelevel{0}" );@]@;
    @[TeX_( "    /flcontinued@@actionfalse" );@]@;
    @[TeX_( "    /yyBEGIN{ACTION}" );@]@;
    @[TeX_( "/fi/yylexnext" );@]@;

@ @<Decide whether to start an action or skip whitespace inside a rule@>=
    @[TeX_( "/ifflsf@@skip@@ws" );@]@;
    @[TeX_( "    /yybreak/yylexnext" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /def/flbracelevel{0}" );@]@;
    @[TeX_( "    /flcontinued@@actionfalse" );@]@;
    @[TeX_( "    /yyBEGIN{ACTION}" );@]@;
    @[TeX_( "    /ifflin@@rule" );@]@;
    @[TeX_( "        /fldoing@@rule@@actiontrue" );@]@;
    @[TeX_( "        /flin@@rulefalse" );@]@;
    @[TeX_( "        /yybreak@@{/yylexreturnxchar/n}" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yybreak@@/yylexnext" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "/yycontinue" );@]@;

@ @<Finish the line and/or action@>=
    @[TeX_( "/ifflsf@@skip@@ws" );@]@;
    @[TeX_( "    /flinc@@linenum" );@]@;
    @[TeX_( "    /yybreak/yylexnext" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /def/flbracelevel{0}" );@]@;
    @[TeX_( "    /flcontinued@@actionfalse" );@]@;
    @[TeX_( "    /yyBEGIN{ACTION}" );@]@;
    @[TeX_( "    /unput{/n}" );@]@;
    @[TeX_( "    /ifflin@@rule" );@]@;
    @[TeX_( "        /fldoing@@rule@@actiontrue" );@]@;
    @[TeX_( "        /flin@@rulefalse" );@]@;
    @[TeX_( "        /yybreak@@{/yylexreturnxchar/n}" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yybreak@@/yylexnext" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "/yycontinue" );@]@;

@ @<Start section 3@>=
    @[TeX_( "/def/flsectnum{3}" );@]@;
    @[TeX_( "/yyBEGIN{SECT3}" );@]@;
    @[TeX_( "/yyterminate" );@]@;

@ @<Start processing a character class@>=
    @[TeX_( "/edef/flnmstr{/the/yytext}" );@]@;
    @[TeX_( "/yyless{1}" );@]@;
    @[TeX_( "/yyBEGIN{FIRSTCCL}" );@]@;
    @[TeX_( "/yylexreturnraw[" );@]@;

@ Return a special \prodstyle{CHAR} and return the whitespace back into the input.
The braces and the possible trailing whitespace will be dealt with by the typesetting code.
@<Process a named expression after checking for whitespace at the end@>=
    @[TeX_( "/edef/flend@@ch{/the/yytextlastchar}" );@]@;
    @[TeX_( "/ifnum/flend@@ch=`/}/relax" );@]@;
    @[TeX_( "    /flend@@is@@wsfalse" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /flend@@is@@wstrue" );@]@;
    @[TeX_( "/fi" );@]@;
    @[TeX_( "/toksa/expandafter{/astformat@@flnametok}" );@]@;
    @[TeX_( "/let/astformat@@flnametok/empty" );@]@;
    @[TeX_( "/edef/next{/yylval{{/nx/flnametok{/the/yytext}{/the/toksa}}{}{/the/yyfmark}{/the/yysmark}}}/next" );@]@;
    @[TeX_( "/ifflend@@is@@ws" );@]@;
    @[TeX_( "    /unput{ }" );@]@;
    @[TeX_( "/fi" );@]@;
    @[TeX_( "/yylexreturn{CHAR}" );@]@;

@ @<Decide if this is a comment@>=
    @[TeX_( "/ifflsf@@skip@@ws" );@]@;
    @[TeX_( "    /yypushstate{COMMENT_DISCARD}" );@]@;
    @[TeX_( "    /yylexnext" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /yyless{1}" );@]@;
    @[TeX_( "    /yylexreturnraw//" );@]@;
    @[TeX_( "/fi" );@]@;

@ @<Determine if this is extended syntax or return a parenthesis@>=
    @[TeX_( "/iffllex@@compat" );@]@;
    @[TeX_( "    /yybreak{/yyless{1}/flsf@@push/yylexreturnraw(}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /ifflposix@@compat" );@]@;
    @[TeX_( "        /yybreak@@{/yyless{1}/flsf@@push/yylexreturnraw(}" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yybreak@@{/yypushstate{EXTENDED_COMMENT}}" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "/yycontinue" );@]@;

@ @<Determine if this is a parametric group or return a parenthesis@>=
    @[TeX_( "/flsf@@push" );@]@;
    @[TeX_( "/iffllex@@compat" );@]@;
    @[TeX_( "    /yybreak{/yyless{1}}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /ifflposix@@compat" );@]@;
    @[TeX_( "        /yybreak@@{/yyless{1}}" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yybreak@@{/yyBEGIN{GROUP_WITH_PARAMS}}" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "/yycontinue" );@]@;
    @[TeX_( "/yylexreturnraw(" );@]@;
                
@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<SC>{
    {OPTWS}{NL}{OPTWS} {@> @[TeX_( "/flinc@@linenum" );@] /* allow blank lines and continuations */@+@=}@>
    [,*]               {@> @[TeX_( "/yylexreturnchar" );@] @=}@>
    ">"                {@> @[TeX_( "/yyBEGIN{SECT2}/yylexreturnchar" );@] @=}
    ">"^               {@> @[TeX_( "/yyBEGIN{CARETISBOL}/yyless{1}/yylexreturnraw>" );@] @=}
    {SCNAME}           {@> @[TeX_( "/RETURNNAME" );@] @=}
    .                  {@> @[TeX_( "/yyfatal{bad <start condition>: /the/yytext}" );@] @=}
}

<CARETISBOL>"^"        {@> @[TeX_( "/yyBEGIN{SECT2}/yylexreturnchar" );@] @=}

<QUOTE>{
        [^"\n]          {@> @[TeX_( "/RETURNCHAR" );@] @=}
        \"              {@> @[TeX_( "/yyBEGIN{SECT2}/yylexreturnxchar/flquotechar" );@] @=}

        {NL}            {@> @[TeX_( "/yyfatal{missing quote}" );@] @=}
}

<GROUP_WITH_PARAMS>{
    ":"                 {@> @[TeX_( "/yyBEGIN{SECT2}/yylexnext" );@] @=}
    "-"                 {@> @[TeX_( "/yyBEGIN{GROUP_MINUS_PARAMS}/yylexnext" );@] @=}
    i                   {@> @[TeX_( "/flsf@@case@@instrue/yylexnext" );@] @=}
    s                   {@> @[TeX_( "/flsf@@dot@@alltrue/yylexnext" );@] @=}
    x                   {@> @[TeX_( "/flsf@@skip@@wstrue/yylexnext" );@] @=}
}

<GROUP_MINUS_PARAMS>{
    ":"                 {@> @[TeX_( "/yyBEGIN{SECT2}/yylexnext" );@] @=}
    i                   {@> @[TeX_( "/flsf@@case@@insfalse/yylexnext" );@] @=}
    s                   {@> @[TeX_( "/flsf@@dot@@allfalse/yylexnext" );@] @=}
    x                   {@> @[TeX_( "/flsf@@skip@@wsfalse/yylexnext" );@] @=}
}

<FIRSTCCL>{
        "^"[^-\]\n]     {@> @[TeX_( "/yyBEGIN{CCL}/yyless{1}/yylexreturnraw^" );@] @=}
        "^"("-"|"]")    {@> @[TeX_( "/yyless{1}/yylexreturnraw^" );@] @=}
        .               {@> @[TeX_( "/yyBEGIN{CCL}/RETURNCHAR" );@] @=}
}

<CCL>{
        -[^\]\n]        {@> @[TeX_( "/yyless{1}/yylexreturnraw-" );@] @=}
        [^\]\n]         {@> @[TeX_( "/RETURNCHAR" );@] @=}
        "]"             {@> @[TeX_( "/yyBEGIN{SECT2}/yylexreturnchar" );@] @=}
        .|{NL}          {@> @[TeX_( "/yyfatal{bad character class}" );@] @=}
}

<FIRSTCCL,CCL>{
        "[:alnum:]"     {@> @[TeX_( "/xcclreturn{CCE_ALNUM}" );@] @=}
        "[:alpha:]"     {@> @[TeX_( "/xcclreturn{CCE_ALPHA}" );@] @=}
        "[:blank:]"     {@> @[TeX_( "/xcclreturn{CCE_BLANK}" );@] @=}
        "[:cntrl:]"     {@> @[TeX_( "/xcclreturn{CCE_CNTRL}" );@] @=}
        "[:digit:]"     {@> @[TeX_( "/xcclreturn{CCE_DIGIT}" );@] @=}
        "[:graph:]"     {@> @[TeX_( "/xcclreturn{CCE_GRAPH}" );@] @=}
        "[:lower:]"     {@> @[TeX_( "/xcclreturn{CCE_LOWER}" );@] @=}
        "[:print:]"     {@> @[TeX_( "/xcclreturn{CCE_PRINT}" );@] @=}
        "[:punct:]"     {@> @[TeX_( "/xcclreturn{CCE_PUNCT}" );@] @=}
        "[:space:]"     {@> @[TeX_( "/xcclreturn{CCE_SPACE}" );@] @=}
        "[:upper:]"     {@> @[TeX_( "/xcclreturn{CCE_UPPER}" );@] @=}
        "[:xdigit:]"    {@> @[TeX_( "/xcclreturn{CCE_XDIGIT}" );@] @=}

        "[:^alnum:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_ALNUM}" );@] @=}
        "[:^alpha:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_ALPHA}" );@] @=}
        "[:^blank:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_BLANK}" );@] @=}
        "[:^cntrl:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_CNTRL}" );@] @=}
        "[:^digit:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_DIGIT}" );@] @=}
        "[:^graph:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_GRAPH}" );@] @=}
        "[:^lower:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_LOWER}" );@] @=}
        "[:^print:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_PRINT}" );@] @=}
        "[:^punct:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_PUNCT}" );@] @=}
        "[:^space:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_SPACE}" );@] @=}
        "[:^upper:]"    {@> @[TeX_( "/xcclreturn{CCE_NEG_UPPER}" );@] @=}
        "[:^xdigit:]"   {@> @[TeX_( "/xcclreturn{CCE_NEG_XDIGIT}" );@] @=}
        {CCL_EXPR}      {@> @[TeX_( "/yyfatal{bad character class expression: /the/yytext}" );@] @=}
}

<NUM>{
        [[:digit:]]+    {@> @[TeX_( "/yylexreturnval{NUMBER}" );@] @=}

        ","             {@> @[TeX_( "/yylexreturnchar" );@] @=}
        "}"             {@> @<Finish the repeat pattern@> @=}
        .               {@> @[TeX_( "/yyfatal{bad character inside {}'s}" );@] @=}

        {NL}            {@> @[TeX_( "/yyfatal{missing /nx/}}" );@] @=}
}

@ @<Finish the repeat pattern@>=
    @[TeX_( "/yyBEGIN{SECT2}" );@]@;
    @[TeX_( "/iffllex@@compat" );@]@;
    @[TeX_( "    /yybreak{/yylexreturn{END_REPEAT_POSIX}}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /ifflposix@@compat" );@]@;
    @[TeX_( "        /yybreak@@{/yylexreturn{END_REPEAT_POSIX}}" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yybreak@@{/yylexreturn{END_REPEAT_FLEX}}" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "/yycontinue" );@]@;


@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<PERCENT_BRACE_ACTION>{
  {OPTWS}"%}".*   {@> @[TeX_( "/def/flbracelevel{0}/yylexnext" );@] @=}

   <ACTION>"/*"   {@> @[TeX_( "/yypushstate{COMMENT}/yylexnext" );@] @=}

        <CODEBLOCK,ACTION>{
                "reject"        {@> @[TeX_( "/yylexnext" );@]@=}
                "yymore"        {@> @[TeX_( "/yylexnext" );@]@=}
        }

    {M4QSTART}    {@> @[TeX_( "/yylexnext" );@]@=}
      {M4QEND}    {@> @[TeX_( "/yylexnext" );@]@=}
             .    {@> @[TeX_( "/yylexnext" );@]@=}
          {NL}    {@> @<Process a newline inside a braced group@> @=}
}

@ This actions has been modified to output \prodstyle{'\\n'}.
@<Process a newline inside a braced group@>=
    @[TeX_( "/flinc@@linenum" );@]@;
    @[TeX_( "/ifnum/flbracelevel=/z@@" );@]@;
    @[TeX_( "    /iffldoing@@rule@@action" );@]@;
    @[TeX_( "        /yylexreturnxchar/n" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yylexnext" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "    /fldoing@@rule@@actionfalse" );@]@;
    @[TeX_( "    /fldoing@@codeblockfalse" );@]@;
    @[TeX_( "    /yyBEGIN{SECT2}" );@]@;
    @[TeX_( "/else" );@]@;
    @[TeX_( "    /iffldoing@@codeblock" );@]@;
    @[TeX_( "        /ifflindented@@code" );@]@;
    @[TeX_( "            /fldoing@@rule@@actionfalse" );@]@;
    @[TeX_( "            /fldoing@@codeblockfalse" );@]@;
    @[TeX_( "            /yyBEGIN{SECT2}" );@]@;
    @[TeX_( "        /fi" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "    /yylexnext" );@]@;
    @[TeX_( "/fi" );@]@;

@ @<Patterns for \flex\ lexer@>=
@G(fs2)
/* |reject| and |yymore()| are checked for above, in \flexsnstyle{PERCENT\_BRACE\_ACTION} */
<ACTION>{
        "{"            {@> @[TeX_( "/flinc/flbracelevel/yylexnext" );@] @=}
        "}"            {@> @[TeX_( "/fldec/flbracelevel/yylexnext" );@] @=}
    {M4QSTART}         {@> @[TeX_( "/yylexnext" );@]@=}
    {M4QEND}           {@> @[TeX_( "/yylexnext" );@]@=}
 [^[:alpha:]_{}"'/\n\[\]]+ {@> @[TeX_( "/yylexnext" );@]@=}
    [\[\]]             {@> @[TeX_( "/yylexnext" );@]@=}
        {NAME}         {@> @[TeX_( "/yylexnext" );@]@=}
 "'"([^'\\\n]|\\.)*"'" {@> @[TeX_( "/yylexnext" );@]@=}
        \"             {@> @[TeX_( "/yyBEGIN{ACTION_STRING}/yylexnext" );@]@=}
        {NL}           {@> @<Process a newline inside an action@> @=}
        .              {@> @[TeX_( "/yylexnext" );@]@=}
}

@ This actions has been modified to output \prodstyle{'\\n'}.
@<Process a newline inside an action@>=
    @[TeX_( "/flinc@@linenum" );@]@;
    @[TeX_( "/ifnum/flbracelevel=/z@@" );@]@;
    @[TeX_( "    /iffldoing@@rule@@action" );@]@;
    @[TeX_( "        /yylexreturnxchar/n" );@]@;
    @[TeX_( "    /else" );@]@;
    @[TeX_( "        /yylexnext" );@]@;
    @[TeX_( "    /fi" );@]@;
    @[TeX_( "    /fldoing@@rule@@actionfalse" );@]@;
    @[TeX_( "    /yyBEGIN{SECT2}" );@]@;
    @[TeX_( "/fi" );@]@;

@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<ACTION_STRING>{
 [^"\\\n]+ {@> @[TeX_( "/yylexnext" );@] @=}
       \\. {@> @[TeX_( "/yylexnext" );@] @=}
      {NL} {@> @[TeX_( "/flinc@@linenum/yyBEGIN{ACTION}/yylexnext" );@] @=}
        \" {@> @[TeX_( "/yyBEGIN{ACTION}/yylexnext" );@] @=}
         . {@> @[TeX_( "/yylexnext" );@] @=}
}

<COMMENT,COMMENT_DISCARD,ACTION,ACTION_STRING><<EOF>>   {@> @[TeX_( "/yyfatal{EOF encountered inside an action}" );@] @=}

<EXTENDED_COMMENT,GROUP_WITH_PARAMS,GROUP_MINUS_PARAMS><<EOF>>  {@> @[TeX_( "/yyfatal{EOF encountered inside pattern}" );@] @=}

<SECT2,QUOTE,FIRSTCCL,CCL>{ESCSEQ} {@> @<Process an escaped sequence@> @=}

@ @<Process an escaped sequence@>=
  @[TeX_( "/ifnum/YYSTART=/number/csname flexstate/parsernamespace FIRSTCCL/endcsname/relax" );@]@;
  @[TeX_( "    /yyBEGIN{CCL}" );@]@;
  @[TeX_( "/fi" );@]@;
  @[TeX_( "/RETURNCHAR" );@]@;

@ @<Patterns for \flex\ lexer@>=
@G(fs2)
<SECT3>{
      {M4QSTART} {@> @[TeX_( "/yylexnext" );@] @=}
        {M4QEND} {@> @[TeX_( "/yylexnext" );@] @=}
 [^\[\]\n]*(\n?) {@> @[TeX_( "/yylexnext" );@] @=}
          (.|\n) {@> @[TeX_( "/yylexnext" );@] @=}
         <<EOF>> {@> @[TeX_( "/def/flsectnum{0}/yyterminate" );@] @=}
}

<*>.|\n    {@> @[TeX_( "/yyfatal{bad character: /the/yytext}" );@] @=}

@ @<Auxilary code for \flex\ lexer@>=
void define_all_states( void ) {
  @<Collect state definitions for the \flex\ lexer@>@;
}

@ @<Collect state definitions for the \flex\ lexer@>=
#define _register_name( name ) @[Define_State( #name, name )@]
#include "fil_states.h"
#undef _register_name

@ @<Catchall rule for the bootstrap lexer@>=
@G(fs2)
<*>.      {@> @[TeX_( "/yyerrterminate" );@] @=}

@ The drive expects this function to be defined but the bootstrap
lexer has no need for it. We leave it in to appease the compiler.
@<Auxilary code for the bootstrap \flex\ lexer@>=
void define_all_states( void ) {
  @<Collect state definitions for the bootstrap \flex\ lexer@>@;
}

@ @<Collect state definitions for the bootstrap \flex\ lexer@>=
#define _register_name( name ) @[Define_State( #name, name )@]
    /* The \flexsnstyle{INITIAL} state is generated automatically */
#undef _register_name

