/*
 * $Id: funct1.h,v 1.1 1994/06/17 11:26:29 ralf Exp $
 * History:
 * $Log: funct1.h,v $
 * Revision 1.1  1994/06/17  11:26:29  ralf
 * Initial revision
 *
 */
/*** prototypes of functions in funct1 ***/

#define AST_FORM 100

#define CMD_BOLD 1
#define CMD_ITALIC 2
#define CMD_UNDERLINE 3
#define CMD_CAPS 4
void CmdCharFormat(int);

#define EMPHASIZE 1
void Format(int code);

#define CMD_BEGIN 1
#define CMD_END 2
void CmdBeginEnd(int code);

#define ON 0x8000
#define OFF 0x0000
void Paragraph(int code);

void CmdToday(int code);

void CmdFontSize(int code);

void CmdUmlaute(int code);
void CmdLApostrophChar(int code);
void CmdRApostrophChar(int code);
void CmdSpitzeChar(int code);
void CmdTildeChar(int code);

#define CMD_TEX 1
#define CMD_LATEX 2
#define CMD_SLITEX 3
#define CMD_BIBTEX 4
#define CMD_LATEXE 5
void CmdLogo(int code);

void CmdIgnore(int code);
void CmdLdots(int code);
void CmdEmphasize(int code);

void Environment(int code);
void CmdUnknownEnvir(int code);

#define TITLE_TITLE 1
#define TITLE_AUTHOR 2
#define TITLE_DATE 3
#define TITLE_MAKE 4
void CmdTitle(int code);

void CmdDocumentStyle(int code);

#define SECT_MAXLEVEL 20
#define SECT_PART 1
#define SECT_CHAPT 2
#define SECT_NORM 3
#define SECT_SUB 4
#define SECT_SUBSUB 5
#define SECT_PARA 7
#define SECT_SUBPARA 8

void CmdSection(int code);
void CmdCedillaChar(int code);
void CmdSpecials(int code);
void CmdUSection(int code);
void CmdNSection(int code);
void CmdAllSection(int code, BOOL numbering);

void CmdFootNote(int code);

#define FORM_DOLLAR 2	/* ('$')  */
#define FORM_RND_OPEN 3      /* ('/(') */
#define FORM_ECK_OPEN 4      /* ('/[') */
#define FORM_RND_CLOSE 5      /* ('/)') */
#define FORM_ECK_CLOSE 6      /* ('/]') */
#define FORM_DISPLAY 7      /* ('$$') */
#define BEGIN_DISPLAY 8      /* ('\begin{displaymath}') */
#define BEGIN_MATH 9      /* ('\begin{math}') */
#define ECK_DISPLAY 10      /* ('\[}') */
#define BEGIN_PICTURE 11      /* ('\begin{picture}') */
#define BEGIN_MUSIC 12     /* ('\begin{music}') */


void CmdFormula(int code);
void CmdFigure(int code);

void CmdQuote(int code);
void CmdMulticols(int code);

#define RESET 0
void CmdItem(int code);

void CmdList(int code);

void CmdMbox(int code);

#define F_ROMAN 1
#define F_SLANTED 2
#define F_SANSSERIF 3
#define F_TYPEWRITER 4
#define F_ITALIC 5
#define F_BOLD 6
#define F_RMFAMILY 7
#define F_SFFAMILY 8
#define F_TTFAMILY 9
#define F_SCFAMILY 10
#define F_SMALLCAPS 11
#define F_SYMBOL 12
#define F_SLSHAPE 13
#define F_BFSERIES 14
#define F_UPSHAPE 15
#define F_MDSERIES 16
void CmdSetFont(int code);
void CmdTextSetFont(int code);

void CmdInclude(int code);

void CmdVerb(int code);

void CmdVerbatim(int code);
void CmdIgnoreDef(int code);
void CmdVerse(int code);

void TranslateGerman(void);
void CmdPrintRtf(int code);

void GetParam(char *string, int size);

void GermanPrint(int code);
#define GP_CK 1
#define GP_LDBL 2
#define GP_L 3
#define GP_R 4
#define GP_RDBL 5

void CmdIgnoreLet(int code);

void IgnoreNewCmd(int code);

#define LABEL 1
#define REF 2
#define PAGEREF 3
void CmdLabel(int code);

void ConvertString(char *string);

void CmdPar(int code);

void CmdSkip(int codeskip);
void CmdVspace(int codeskip);

void CmdNoindent(int code);

void DoIndent();

int DimenToTwips(float size, char *unit);

void MakeCheck(int level);
void CmdUsePackage(int code);
void CmdSuperscript(int code);

void CmdFrenchAbbrev(int code);

void CmdPaper(int code);

#define IERF 1
#define IEREF 2
#define IERSF 3
#define IERESF 4
#define IEMEF 5
#define IEMESF 6
#define DEGREE 7
#define NUMERO 8
#define NUMEROS 9
#define CNUMERO 10
#define CNUMEROS 11
#define PRIMO 12
#define SECUNDO 13
#define TERTIO 14
#define QUARTO 15
#define FUP 16
