{$W-,R+,V-,G+}
unit wbibpcx;

interface

Uses
  WinTypes,WinProcs,WObjects,Win31,strings,windos,wbibbmp,lfnunit;


{ Read a PCX file and return a Device-Independent Bitmap }
function  LoadPCXDIB(Name: PChar; var Width, Height: LongInt): THandle;

implementation

type
  TRGBRec = record
    Red,Green,Blue: byte;
  end;
  TPCXHeader = record
    Manufacturer : byte;
    Version      : byte;
    Encoding     : byte;
    BitsPerPixel : byte;
    Xmin,Ymin,Xmax,Ymax: integer;
    HDpi,VDpi    : integer;
    ColorMap     : array[0..15] of TRGBRec;
    Reserved     : byte;
    NPlanes      : byte;
    BytesPerLine : integer;
    PaletteInfo  : integer;
    HScreenSize,VScreenSize: integer;
{    Filler       : array[1..54] of byte;} 
  end;


function LoadPCXDIB(Name: PChar; var Width, Height: LongInt): THandle;
const
  ReadBufSize = 4096;
var
  Header: TPCXHeader;
  P,LineBuffer,ReadBuf: PChar;
  Buf: LongType;
  LineBufSize,LineSize,ReadFrom,TotalBytes,pl,ind,lcount: word;
  i,j: word;
  count,BitmapInfoSize,PaletteSize: word;
  fsize: longint;
  fl: file;
  DIB: THandle;
  BitmapInfo: PBitmapInfo;
  SRec: TLFNSearchRec;
  DC: HDC;
  TrueColor,ok: boolean;
  ch,ch1: byte;

procedure DrawLine(LineBuffer: PChar; Y: integer);
begin
  DrawBitLine(Buf,LineBuffer,LineSize,LineBufSize,Height-Y-1);
end;


procedure TidyUp;
begin
  LFNDispose(fl);
  if DIB<>0 then GlobalUnlock(DIB);
  if P<>Nil then FreeMem(P,TotalBytes);
  if LineBuffer<>Nil then FreeMem(LineBuffer,TotalBytes+2);
  if ReadBuf<>Nil then FreeMem(ReadBuf,ReadBufSize);
end;                { TidyUp }

function NextChar: byte;
begin
  NextChar:=byte(ReadBuf[pl]); inc(pl);
  if (ReadFrom>0) and (pl>=ReadFrom) then
  begin
    BlockRead(fl,ReadBuf^,ReadBufSize,ReadFrom); pl:=0;
  end;
end;

const
  RemapColors: array[0..2] of byte = (2,1,0);

begin
  LoadPCXDIB:=0; Width:=0; Height:=0;
  DIB:=0; LineBuffer:=Nil; ReadBuf:=Nil; P:=Nil; pl:=0;
  BitmapInfoSize:=0; BitmapInfo:=Nil;
  if (Name=Nil) or (Name[0]=#0) then Exit;
  LFNFindFirst(StrPas(Name),faAnyFile,SRec);
  if DosError<>0 then
  begin
    LFNFindClose(SRec); Exit;
  end;
  FSize:=SRec.Size;
  LFNFindClose(Srec);

  LFNNew(fl,false); LFNAssign(fl,StrPas(Name));
  if LFNReset(fl,1)<>0 then
  begin
    TidyUp; Exit;
  end;

  BlockRead(fl,Header,sizeof(Header),ReadFrom);

  { Check if it fits }
  ok:=true;
  ok:=ok and (ReadFrom=sizeof(Header));
  ok:=ok and (Header.NPlanes in [1,3]);   { Only 1 or 3 color planes }
  ok:=ok and (Header.BitsPerPixel<>2);    { Disallow 4 color images  }
  if not ok then
  begin
    TidyUp; Exit;
  end;

  { Palette }
  case Header.BitsPerPixel*Header.NPlanes of
    2: PaletteSize:=4;
    4: PaletteSize:=16;
    8: PaletteSize:=256;
    else PaletteSize:=0;
  end;
  BitmapInfoSize:=Sizeof(TBitmapInfoHeader)+PaletteSize*sizeof(TRGBQUAD);

  Width :=Header.Xmax-Header.XMin+1;
  Height:=Header.Ymax-Header.YMin+1;
{
  logstring('W='+num2str(Width)+',H='+num2str(Height)
     +',BPP='+num2str(Header.BitsPerPixel)
     +',Planes='+num2str(Header.NPlanes)
     +',BPL='+num2str(Header.BytesPerLine));
}
  LineBufSize:=Header.NPlanes*Width;
  TotalBytes:=Header.NPlanes*Header.BytesPerLine;
  GetMem(LineBuffer,TotalBytes+2); FillChar(LineBuffer^,TotalBytes+2,0);
  if Header.NPlanes>1 then GetMem(P,TotalBytes);
  GetMem(ReadBuf,ReadBufSize);
  TrueColor:=(Header.BitsPerPixel=8) and (Header.NPlanes=3)
              and (Header.Version>=5);

  LineSize:=LineBufSize;
  if LineSize mod 4 <> 0 then LineSize:=4*(LineSize div 4)+4;

  DIB:=GlobalAlloc(GHND,BitmapInfoSize+LineSize*(Height+20));
  BitmapInfo:=GlobalLock(DIB);
  Buf.Ptr:=PChar(BitmapInfo)+BitmapInfoSize;

  { Read the image data }
  pl:=0; ReadFrom:=0; Ind:=0; lcount:=0;
  {$I-} seek(fl,128); {$I+}
  if IoResult<>0 then
  begin
    TidyUp; Exit;
  end;

  BlockRead(fl,ReadBuf^,ReadBufSize,ReadFrom); pl:=0;
  repeat
    ch:=NextChar;
    if (ch and $C0) = $C0 then  {RLE}
    begin
      count:=ch and $3F; ch:=NextChar;
      FillChar(LineBuffer[Ind],count,ch);
      Ind:=Ind+count;
    end else                           { Explicit }
    begin
      LineBuffer[Ind]:=char(ch); inc(Ind);
    end;
    if Ind>=TotalBytes then   { Completed a scan line }
    begin
      if TrueColor then    { Reshape the scan line }
      begin
        for j:=0 to Header.NPlanes-1 do
        for i:=0 to Width-1 do
          P[i*Header.NPlanes+j]:=LineBuffer[RemapColors[j]*Width+i];
        DrawLine(P,lcount);
      end else DrawLine(LineBuffer,lcount);
      inc(lcount); Ind:=0;
    end;
  until (ReadFrom=0) or (lcount>=Height);

  FillChar(BitmapInfo^,BitmapInfoSize,0);
  with BitmapInfo^.bmiHeader do
  begin
    biSize         :=sizeof(TBitmapInfoHeader);
    biWidth        :=Width;
    biHeight       :=Height;
    biPlanes       :=1;
    biBitCount     :=Header.BitsPerPixel; 
    biCompression  :=BI_RGB;
    biSizeImage    :=0;
    biXPelsPerMeter:=2000;
    biYPelsPerMeter:=2000;
    biClrUsed      :=0;
    biClrImportant :=0;
  end;

{$UNDEF RPLUS}
{$IFDEF R+}
  {$DEFINE RPLUS}
{$ENDIF}
  {$R-}
  if TrueColor then BitmapInfo^.bmiHeader.biBitCount:=24
  else if (Header.Version>=5) and (Header.NPlanes=1)
     and (Header.BitsPerPixel=8) then   { includes a 256 palette }
  begin
    seek(fl,FSize-3*256-1);
    BlockRead(fl,ReadBuf^,256*3+1);
    if ReadBuf[0]<>#12 then   { not a palette, error }
    begin
      GlobalUnlock(DIB); GlobalFree(DIB); DIB:=0;
      TidyUp; Exit;
    end;
    for i:=0 to 255 do
    with BitmapInfo^.bmiColors[i] do
    begin
      rgbRed  :=byte(ReadBuf[3*i+1]);
      rgbGreen:=byte(ReadBuf[3*i+2]);
      rgbBlue :=byte(ReadBuf[3*i+3]);
      rgbReserved:=0;
    end;
  end else if (Header.NPlanes=1) then { 16 color }
  begin
    for i:=0 to PaletteSize-1 do
    with BitmapInfo^.bmiColors[i] do
    begin
      rgbRed  :=Header.Colormap[i].red;
      rgbGreen:=Header.Colormap[i].Green;
      rgbBlue :=Header.Colormap[i].Blue;
      rgbReserved:=0;
    end;
  end;
{$IFDEF RPLUS}
  {$R+}
  {$UNDEF RPLUS}
{$ENDIF}

  TidyUp;
  LoadPCXDIB:=DIB;
end;                { LoadPCXDIB }



end.
