{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit wbibeden;

Interface

uses
  wobjects, wbibdisp, wbibgui, wbibshow, WinTypes, WinProcs, Strings, rc_id,
  commdlg, windos, ole,
  win31, wbibupdt, rc_strng, wbibstat, wbibabv1,
  wbibole, wbibedhy, wbibedob, wbibbin,
  bibstrg, streams, bibecond, bibvars, bibutil, bib8bit, wc_help, bibtmplt,
  bibfile, wbibsfrm, wbibclip;

type
  SelStr = string[Maxfield+1];
  SelStrPtr = ^SelStr;

  WhichFieldType = record
    fld,Hyper,Obj: integer;
  end;
  WhichFieldPtr = ^WhichFieldType;

  PEntryNameDlg = ^TEntryNameDlg;
  TEntryNameDlg = object(TGetStringDlg)
    Ename: array[0..255] of char;
    Entry: EntryRecPtr;
    constructor init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                MakeAuto: boolean);
    procedure   Auto(var Msg: TMessage); virtual id_first+dl_HeaderAuto;
    procedure   ok(var Msg: TMessage);   virtual id_first+id_ok;
  end;

  PEntryHeaderDlg = ^TEntryHeaderDlg;
  TEntryHeaderDlg = object(TEntryNameDlg)
    constructor init(AParent: PWindowsObject; AEntry: EntryRecPtr);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PWhichFieldsDlg = ^TWhichFieldsDlg;
  TWhichFieldsDlg = object(TResizableDialog)
    etype:      integer;
    Answer:     SelStrPtr;
    JustOne:    boolean;
    Entry:      EntryRecPtr;
    constructor init(AParent: PWindowsObject; Select: SelStrPtr;
                     AEntry: EntryRecPtr; AJustOne: boolean);
    procedure   FixControlPos; virtual;
    procedure   FillUpLBoxes(Default: boolean);
    function    WhichAreSelected: string;
    procedure   UpdateDefs(Default: boolean);
    procedure   SetupWindow; virtual;
    procedure   CBoxMessage(var Msg: TMessage); virtual id_first+dl_WhichCBox;
    procedure   RequiredMsg(var Msg: TMessage); virtual id_first+dl_WhichLBoxReq;
    procedure   OptionalMsg(var Msg: TMessage); virtual id_first+dl_WhichLBoxOpt;
    procedure   IgnoredMsg(var Msg: TMessage);  virtual id_first+dl_WhichLBoxIg;
    procedure   AllSel(var Msg: TMessage);      virtual id_first+dl_WhichAll;
    procedure   ClearSel(var Msg: TMessage);    virtual id_first+dl_WhichNone;
    procedure   DefaultSel(var Msg: TMessage);  virtual id_first+dl_WhichDefault;
    procedure   KeepSel(var Msg: TMessage);     virtual id_first+dl_WhichKeep;
    procedure   Ok(var Msg: TMessage);          virtual id_first+id_Ok;
  end;

  BtnRec = record
    H: HWnd;
    Tleft,Tright: TPoint;
    Height,Width: integer;
  end;

  PEdEnWindow = ^TEdEnWindow;
  TEdEnWindow = object(TResizableDialog)
    Entry: EntryRecPtr;
    EntryName:   PEntryName;
    DisplayArea: PDisplayArea;
    HelpBar,OldHelpBar: PHelpBar;
    FirstTime,Changed,VerifyAutoName: boolean;
    Starting:    longint;
    MenuHelp,PopupHelp: TCollection;
    HFloatingHeader,HFloatingField:   HMenu;
    ModifyFieldInd: integer;
    MenuStringString: array[0..64] of char;
    RestoredCaption,EdObjStr,EdImageStr,EdHyperStr: PChar;
    CopyObjectStr,CopyImageStr,ActivateObjectStr: PChar;
    EditFieldStr,CopyNameStr: PString;
    AccelKeys: TCollection;
    OldExpandStrings,OldExpandIniAbbrevs,OldExpandMacros: boolean;
    OldFirstShowBuf,OldStripExtraBraces,OldResolveHyper: boolean;
    OldResolveObjects,OldOleVerbatim: boolean;
    Hyperlink: PHyperLinkObj;
    ObjToEdit: POleObj;
    constructor  Init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                      Startwith: longint; ShowEmpty: boolean);
    procedure    SetupWindow; virtual;
    procedure    InitMenuHelp;
    procedure    SetupMenu; virtual;
    procedure    CalcSizes; virtual;
    procedure    WmSize(var Msg: TMessage);       virtual wm_first+wm_Size;
    procedure    wmActivate(var Msg: TMessage);   virtual wm_first+wm_activate;
    procedure    Update;
    procedure    bibUpdate(var Msg: TMessage); virtual wm_first+bib_Update;
    procedure    wmInitMenu(var Msg: TMessage);   virtual wm_first+wm_InitMenu;
    procedure    wmMenuSelect(var Msg: TMessage); virtual wm_first+wm_MenuSelect;
    procedure    ArrowKeys(var Msg: TMessage);    virtual wm_first+bib_ArrowKeys;

    procedure EditAHeader(var Msg: TMessage);     virtual cm_First+mi_EdEnFEdit;
    procedure CopyHeader(var Msg: TMessage);      virtual cm_First+mi_EdEnFCopy;
    procedure CopyHeaderEx(var Msg: TMessage);    virtual cm_First+mi_EdEnFECopy;
    procedure MenuStringCopy(var Msg: TMessage);  virtual cm_first+mi_EdEnFString;
    procedure CutName(var Msg: TMessage);         virtual cm_first+mi_EdEnFCutName;
    procedure PasteName(var Msg: TMessage);       virtual cm_first+mi_EdEnFPasteName;
    procedure AutoName(var Msg: TMessage);        virtual cm_first+mi_EdEnFAutoName;
    procedure DeleteName(var Msg: TMessage);      virtual cm_first+mi_EdEnFDelname;

    procedure EditSomething(fld: integer; H:PHyperLinkObj; O:POleObj);
    procedure EditAField(var Msg: TMessage);      virtual cm_First+mi_EdEnFFEdit;
    procedure EditAHyper(var Msg: TMessage);      virtual cm_First+mi_EdEnFFEdHyper;
    procedure EditAnObject(var Msg: TMessage);    virtual cm_First+mi_EdEnEdObj;
    procedure CopyObject(var Msg: TMessage);      virtual cm_first+mi_EdEnCopyObject;
    procedure ActivateObject(var Msg: TMessage);  virtual cm_first+mi_EdEnActObj;
    procedure CopyField(var Msg: TMessage);       virtual cm_First+mi_EdEnFFCopy;
    procedure CopyFieldEx(var Msg: TMessage);     virtual cm_First+mi_EdEnFFCopyEx;
    procedure CutField(var Msg: TMessage);        virtual cm_first+mi_EdEnFFCutField;
    procedure PasteField(var Msg: TMessage);      virtual cm_first+mi_EdEnFFPasteField;
    procedure DeleteField(var Msg: TMessage);     virtual cm_first+mi_EdEnFFDelField;

    procedure ClickedOnField(var Msg: TMessage);
                             virtual wm_first+bib_ClickedOnField;

    procedure GetHeader(var Msg: TMessage); virtual cm_first+mi_EdEntryHeader;
    procedure OneField(var Msg: TMessage);  virtual cm_first+mi_EdField;
    procedure Which(var Msg: TMessage);     virtual cm_first+mi_EdWhich;
    procedure Default(var Msg: TMessage);   virtual cm_first+mi_EdDefault;

    procedure AlmostZeroEntry;
    procedure FieldMove(var Msg: TMessage);    virtual cm_first+mi_EdEditMove;
    procedure FieldCopy(var Msg: TMessage);    virtual cm_first+mi_EdEditCopy;
    procedure FieldErase(var Msg: TMessage);   virtual cm_first+mi_EdEditErase;
    {
    procedure FieldAdd(var Msg: TMessage);     virtual cm_first+mi_EdEditAdd;
    procedure FieldRemove(var Msg: TMessage);  virtual cm_first+mi_EdEditReMove;
    }
    {---}
    procedure CopyEName(var Msg: TMessage);    virtual cm_first+mi_EdEnCopyName;
    procedure CopyENameEx(var Msg: TMessage);  virtual cm_First+mi_EdEnCopyNameEx;
    procedure CopyEnameStr(var Msg: TMessage); virtual cm_First+mi_EdEnCopyNameStr;
    {---}
    procedure CopyEField(var Msg: TMessage);   virtual cm_First+mi_EdEnCopyField;
    procedure CopyEFieldEx(var Msg: TMessage); virtual cm_first+mi_EdEnCopyFieldEx;
    procedure EntryCut(var Msg: TMessage);     virtual cm_first+mi_EdEditCutEntry;
    procedure EntryCopy(var Msg: TMessage);    virtual cm_first+mi_EdEditCopyEntry;
    procedure EntryPaste(var Msg: TMessage);   virtual cm_first+mi_EdEditPasteEntry;
    procedure EntryPasteClip(var Msg: TMessage); virtual cm_first+mi_EdEditPasteClip;
    procedure ClearAll(var Msg: TMessage);     virtual cm_first+mi_EdEditClear;

    procedure ViewMode(var Msg: TMessage);     virtual cm_first+mi_EdView;
    procedure Showformat(var Msg: TMessage);   virtual cm_first+mi_EdShowformat;
    procedure AbbrevMode(var Msg: TMessage);   virtual cm_first+mi_EdExpandAbbrevs;
    procedure BracesMode(var Msg: TMessage);   virtual cm_first+mi_EdStripBraces;
    procedure ResHyper(var Msg: TMessage);     virtual cm_first+mi_EdResolveHyper;
    procedure ResObjects(var Msg: TMessage);   virtual cm_first+mi_EdResolveObjects;
    procedure ResAll(var Msg: TMessage);       virtual cm_first+mi_EdResolveAll;
    procedure ResNone(var Msg: TMessage);      virtual cm_first+mi_EdResolveNone;

    procedure ok(var Msg: TMessage);        virtual id_first+id_ok;     { disabled }
    procedure Cancel(var Msg: TMessage);    virtual id_first+id_cancel; { disabled }
    procedure Quit(var Msg: TMessage);      virtual cm_first+mi_EdQuit;
    procedure Save(var Msg: TMessage);      virtual cm_first+mi_EdSave;
    procedure EditTheFields(Select: SelStr);

    destructor Done; virtual;
  end;


procedure WEditEntry(Entry: EntryRecPtr; WhichField: longint; var Changed: boolean);


Implementation


const
  id_WhichLBox: array[1..3] of integer =
     (dl_WhichLBoxReq, dl_WhichLBoxOpt, dl_WhichLboxIg);

  ChangedFlag = 1000;

  { Various status flags }
  MemExpandStrings   : boolean = false;
  MemExpandIniAbbrevs: boolean = false;
  MemExpandMacros    : boolean = false;
  MemStripExtraBraces: boolean = false;
  MemResolveHyper    : boolean = true;
  MemResolveObjects  : boolean = true;

type
  PManipFieldsDlg = ^TManipFieldsDlg;
  TManipFieldsDlg = object(TBasicDialog)
    FromField,ToField: PInteger;
    MoveField: boolean;
    Entry: EntryRecPtr;
    constructor init(AParent: PWindowsObject; AMoveField: boolean;
                     AEntry: EntryRecPtr; AFrom,Ato: Pinteger);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PEraseFieldsDlg = ^TEraseFieldsDlg;
  TEraseFieldsDlg = object(TBasicDialog)
    Entry: EntryRecPtr;
    FieldList: PString;
    constructor init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                     AFieldList: PString);
    procedure   SetupWindow; virtual;
    procedure   AllBtn(var Msg: TMessage);   virtual id_first+dl_SelectionListAll;
    procedure   ClearBtn(var Msg: TMessage); virtual id_first+dl_SelectionListClear;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
  end;

  PRemoveFieldsDlg = ^TRemoveFieldsDlg;
  TRemoveFieldsDlg = object(TEraseFieldsDlg)
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
  end;

  PAddNewFieldDlg = ^TAddNewFieldDlg;
  TAddNewFieldDlg = object(TGetStringDlg)
    constructor init(AParent: PWindowsObject; ANewName: PChar);
    function CanClose: boolean; virtual;
  end;

procedure CleanupEntry(Entry: EntryRecPtr);
var
  ii,iii: integer;
begin
 if EditOnlyStrings then
 with entry^ do
   begin
    if content[1]='' then
    begin
      nentry:=0;
      index[StringIndex]:=0; BigIndex[StringIndex]:=0;
    end;
  end else
  with entry^ do
  begin
    nentry:=0;
    for iii:=1 to maxfield do
    begin
      if content[iii]<>'' then
      begin
        ii:=0;
        while (ii<fieldlast+1) do
        begin
          Inc(ii);
          if index[ii]=iii then
          begin
            Inc(nentry);
            content[nentry]:=content[iii];
            field[nentry]:=typefield^[ii];
            index[ii]:=nentry;
            ii:=fieldlast+1;
          end;
        end;
      end else
        for ii:=1 to fieldlast do if index[ii]=iii then index[ii]:=0;
    end;
  end;
end;                   { CleanupEntry }

{ TManipFieldsDlg methods }

constructor TManipFieldsDlg.Init(AParent: PWindowsObject; AMoveField: boolean;
                     AEntry: EntryRecPtr; AFrom,Ato: Pinteger);
begin
  TBasicDialog.Init(AParent,PChar(rc_ManipFieldsDlg));
  FromField:=AFrom; ToField:=ATo; Entry:=AEntry;
  MoveField:=AMoveField;
end;

procedure TManipFieldsDlg.SetupWindow;
var
  i: integer;
  F: Pchar;
begin
  TBasicDialog.SetupWindow;
  if MoveField then SetWindowText(HWindow,'Move field...')
  else SetWindowText(HWindow,'Copy field...');
  GetMem(F,256);
  with Entry^ do
  begin
    for i:=1 to nentry do
    begin
      StrPCopy(F,Field[i]);
      SendDlgItemMsg(dl_ManipFieldsFrom,lb_AddString,0,Longint(F));
    end;
    for i:=1 to FieldLast do
    begin
      StrPCopy(F,TypeField^[i]);
      SendDlgItemMsg(dl_ManipFieldsTo,lb_AddString,0,Longint(F));
    end;
  end;
  FreeMem(F,256);
  InitPos;
end;                              { TManipFieldsDlg.SetupWindow }

procedure TManipFieldsDlg.ok(var Msg: TMessage);
var
  i,j,k,l: integer;
begin
  if not CanClose then Exit;
  i:=SendDlgItemMsg(dl_ManipFieldsFrom,lb_GetCurSel,0,0);
  if i=lb_Err then
  begin
    ErrorMessageRC(Str_NoFromFieldSelected,''); Exit;
  end;
  j:=SendDlgItemMsg(dl_ManipFieldsTo,lb_GetCurSel,0,0);
  if j=lb_Err then
  begin
    ErrorMessageRC(Str_NoToFieldSelected,''); Exit;
  end;
  l:=0;
  for k:=1 to MaxField do if entry^.Index[k]=i+1 then l:=k;
  
  if l=j+1 then
  begin
    ErrorMessageRC(Str_FromEqualTo,''); Exit;
  end;
  FromField^:=l;
  ToField^:=j+1;
  EndDlg(id_ok);
end;                               { TManipFieldsDlg.ok }

{ TEraseFields methods }

constructor TEraseFieldsDlg.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                     AFieldList: PString);
begin
  TBasicDialog.Init(AParent,PChar(rc_SelectionListDlg));
  Entry:=AEntry;
  FieldList:=AFieldList;
end;

procedure TEraseFieldsDlg.SetupWindow;
var
  i: integer;
  F: Pchar;
begin
  TBasicDialog.SetupWindow;
  SetWindowText(HWindow,'Erase fields');
  GetMem(F,256);
  with Entry^ do
  for i:=1 to nentry do
  begin
    StrPCopy(F,field[i]);
    SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(F));
  end;
  FreeMem(F,256);
  InitPos;
end;                           { TEraseFieldsDlg.SetupWindow }

procedure TEraseFieldsDlg.AllBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(true),-1);
end;

procedure TEraseFieldsDlg.ClearBtn(var Msg: TMessage);
begin
  SendDlgItemMsg(dl_SelectionListLBox,lb_SetSel,word(false),-1);
end;

procedure TEraseFieldsDlg.ok(var Msg: TMessage);
var
  SelectionBuf: array[1..MaxField+1] of integer;
  Nselected,i,j,k: integer;
begin
  FillChar(SelectionBuf,sizeof(SelectionBuf),0);
  NSelected:=SendDlgItemMsg(dl_SelectionListLBox,lb_GetSelItems,fieldlast,
    Longint(@SelectionBuf));
  FieldList^:='';
  if NSelected<>lb_err then
  for i:=1 to NSelected do with Entry^ do
  begin
    k:=0;
    for j:=1 to FieldLast do if SelectionBuf[i]=index[j]-1 then k:=j;
    FieldList^:=FieldList^+Chr(k);
  end;
  EndDlg(id_ok);
end;                           { TEraseFieldsDlg.ok }

{ TRemoveFieldsDld methods }

procedure TRemoveFieldsDlg.SetupWindow;
var
  i: integer;
  F: Pchar;
begin
  TBasicDialog.SetupWindow;
  SetWindowText(HWindow,'Remove fields');
  GetMem(F,256);
  for i:=OrigFieldLast+1 to FieldLast do
  begin
    StrPCopy(F,typefield^[i]);
    SendDlgItemMsg(dl_SelectionListLBox,lb_AddString,0,longint(F));
  end;
  FreeMem(F,256);
  InitPos;
end;                           { TRemoveFieldsDlg.SetupWindow }

procedure TRemoveFieldsDlg.ok(var Msg: TMessage);
var
  SelectionBuf: array[1..MaxField+1] of integer;
  Nselected,i: integer;
begin
  if not CanClose then Exit;
  FillChar(SelectionBuf,sizeof(SelectionBuf),0);
  NSelected:=SendDlgItemMsg(dl_SelectionListLBox,lb_GetSelItems,fieldlast,
    Longint(@SelectionBuf));
  FieldList^:='';
  if NSelected<>lb_err then
  for i:=1 to NSelected do
    FieldList^:=FieldList^+Chr(SelectionBuf[i]+OrigFieldLast+1);
  EndDlg(id_ok);
end;                           { TRemoveFieldsDlg.ok }

{ TAddNewFieldDlg methods }

constructor TAddNewFieldDlg.init(AParent: PWindowsObject; ANewName: PChar);
begin
  StrPCopy(ANewName,'');
  TGetStringDlg.init(AParent,PChar(rc_NewFieldDlg),'Field name',
    NameForbid,ANewName,false,32);
end;

function TAddNewFieldDlg.CanClose: boolean;
var
  F: array[0..40] of char;
  S: string[40];
  i: integer;
  o_k: boolean;
begin
  CanClose:=false;
  if not TGetStringDlg.CanClose then Exit;
  GetWindowText(HWindow,F,32); S:=StrPas(F); StrLwr(S);
  o_k:=true;
  for i:=1 to FieldLast do
    if typefield^[i]=S then o_k:=false;
  if not o_k then
    ErrorMessageRC(Str_NewFieldExists,s)
  else CanClose:=true;
end;

{ TEntryNameDlg methods }

constructor TEntryNameDlg.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                               MakeAuto: boolean);
var
  S: string;
begin
  Entry:=AEntry;
  if (not EditOnlyStrings) and (Entry^.name='') and MakeAuto then
  begin
    S:=''; AutoLabel(entry,LabelTemplate^,S);
    StrPCopy(Ename,S);
  end else StrPCopy(Ename,entry^.name);
  if EditOnlyStrings then
    TGetStringDlg.Init(AParent,PChar(rc_StringNameDlg),'String name',
                       NameForbid, Ename, true, 50)
  else
    TGetStringDlg.Init(AParent,PChar(rc_EntryNameDlg),'Entry name',
                       NameForbid, Ename, true, 50);
end;                     { TEntryNameDlg.init }

procedure TEntryNameDlg.Auto(var Msg: TMessage);
var
  S: string;
  F: Pchar;
begin
  GetMem(F,256);
  S:=''; AutoLabel(entry,LabelTemplate^,S);
  if S='' then ErrorMessageRC(Str_EmptyTemplate,'')
  else begin
    StrPCopy(F,S);
    SetWindowText(Ebox^.HWindow,F);
  end;
  FreeMem(F,256);
end;                   { TEntryNameDlg.Auto }

procedure TEntryNameDlg.ok(var Msg: TMessage);
begin
  if CanClose then
  begin
    if GetWindowText(EBox^.HWindow,Answer,255)=0 then
      StrPCopy(Answer,'');
    entry^.name:=StrPas(Answer);
    EndDlg(id_OK);
  end;
end;                          { TEntryNameDlg.OK }

{ TEntryHeaderDlg methods }

constructor TEntryHeaderDlg.init(AParent: PWindowsObject; AEntry: EntryRecPtr);
begin
  Entry:=AEntry;
  StrPCopy(Ename,entry^.name);
  if EditOnlyStrings then
    TGetStringDlg.Init(AParent,PChar(rc_StringNameDlg),'String name',
                     NameForbid, Ename, true, 50)
  else
    TGetStringDlg.Init(AParent,PChar(rc_HeaderDlg),'Entry type & name',
                     NameForbid, Ename, true, 50);
  HelpContext:=hc_EditHeader;
end;                    { TEntryHeaderDlg.init }

procedure TEntryHeaderDlg.SetupWindow;
var
  F: array[0..255] of char;
  EtypeInd,i,j: integer;
begin
  TGetStringDlg.SetupWindow;
  EtypeInd:=-1;
  for i:=1 to NumberOfTypes do
  begin
    StrPCopy(F,TypeEntry^[i]);
    j:=SendDlgItemMsg(dl_HeaderCBox,cb_AddString,0,Longint(@F));
    if (entry<>Nil) and (Entry^.EntryType=TypeEntry^[i]) then
      ETypeInd:=j;
  end;
  if EtypeInd>=0 then
    SendDlgItemMsg(dl_HeaderCBox,cb_SetCurSel,ETypeInd,0);
end;                   { TEntryHeaderDlg.SetupWindow }

procedure TEntryHeaderDlg.ok(var Msg: TMessage);
var
  F: array[0..255] of char;
  i: integer;
begin
  if CanClose then
  begin
    if GetWindowText(EBox^.HWindow,Answer,255)=0 then
      StrPCopy(Answer,'');
    entry^.name:=StrPas(Answer);
    i:=SendDlgItemMsg(dl_HeaderCBox,cb_GetCurSel,0,0);
    if i<>cb_Err then
    begin
      SendDlgItemMsg(dl_HeaderCBox,cb_GetLBText,i,longint(@F));
      entry^.entrytype:=StrPas(F);
    end;
    EndDlg(id_OK);
  end;
end;                          { TEntryHeader.OK }

{ TWhichFieldsDlg methods }

constructor TWhichFieldsDlg.init(AParent: PWindowsObject; Select: SelStrPtr;
            AEntry: EntryRecPtr; AJustOne: boolean);
begin
  if AJustOne then
    TResizableDialog.init(AParent,PChar(rc_OneFieldDlg),@OneFieldSize)
  else
    TResizableDialog.init(AParent,PChar(rc_WhichDialog),@WhichFieldsSize);
  Answer:=Select;
  Answer^:='';
  JustOne:=AJustOne;
  Entry:=AEntry;
  if JustOne then HelpContext:=hc_ModifyField
  else HelpContext:=hc_EditWhich;
  ResizeWidth:=false;
end;                              { TWhichFieldsDlg.init }

procedure TWhichFieldsDlg.FillUpLBoxes(Default: boolean);
var
  i,j,Ind: integer;
  F: array[0..255] of char;
  IgnoredFields: array[1..MaxField+1] of boolean;
  n1,n2: byte;
  Def: boolean;
begin
  for i:=1 to 3 do
    SendDlgItemMsg(id_WhichLBox[i],lb_ResetContent,0,0);
  for i:=1 to fieldlast do IgnoredFields[i]:=true;
  n1:=0; n2:=0;
  for i:=1 to required^[etype,0] do
  begin
    j:=required^[etype,i];
    if EnglishInterface or (FieldParams^[abs(j)].AltName=Nil) then
      StrPCopy(F,typefield^[abs(j)])
    else
      StrPCopy(F,FieldParams^[abs(j)].AltName^);
    if (Entry<>Nil) and (Entry^.index[abs(j)]>0) then StrCat(F,'*');
    IgnoredFields[abs(j)]:=false;
    if Default then
      Def:=Pos(Chr(abs(j)),DefEditFields^[etype])>0
    else
      Def:=Pos(Chr(abs(j)),EditFields^[etype])>0;
    if JustOne then def:=false;
    if j>0 then
    begin
      Ind:=SendDlgItemMsg(dl_WhichLBoxReq,lb_AddString,0,Longint(@F));
      SendDlgItemMsg(dl_WhichLBoxReq,lb_SetItemData,Ind,MakeLong(j,0));
      if def then SendDlgItemMsg(dl_WhichLBoxReq,lb_setSel,1,n1);
      inc(n1);
    end else
    begin
      Ind:=SendDlgItemMsg(dl_WhichLBoxOpt,lb_AddString,0,Longint(@F));
      SendDlgItemMsg(dl_WhichLBoxOpt,lb_SetItemData,Ind,MakeLong(abs(j),0));
      if def then SendDlgItemMsg(dl_WhichLBoxOpt,lb_setSel,1,n2);
      inc(n2);
    end;
  end;
  n1:=0;
  for i:=1 to fieldlast do
    if IgnoredFields[i] then
    begin
      if (Entry<>Nil) and (Entry^.index[i]>0) then StrPCopy(F,typefield^[i]+'*')
      else StrPCopy(F,typefield^[i]);
{      StrPCopy(F,typefield^[i]);}
      Ind:=SendDlgItemMsg(dl_WhichLBoxIg,lb_AddString,0,Longint(@F));
      SendDlgItemMsg(dl_WhichLBoxIg,lb_SetItemData,Ind,MakeLong(i,0));
      if Default then
        Def:=Pos(Chr(i),DefEditFields^[etype])>0
      else
        Def:=Pos(Chr(i),EditFields^[etype])>0;
      if Def and not JustOne then SendDlgItemMsg(dl_WhichLBoxIg,lb_setSel,1,n1);
      inc(n1);
    end;
end;                              { TWhichFieldsDlg.FillUpLBoxes }

procedure TWhichFieldsDlg.FixControlPos;
begin
  NewControl(dl_WhichLboxReq,RelTo_Left,RelTo_Size,RelTo_Top,RelTo_Bottom);
  NewControl(dl_WhichLboxOpt,RelTo_Left,RelTo_Size,RelTo_Top,RelTo_Bottom);
  NewControl(dl_WhichLboxIg ,RelTo_Left,RelTo_Size,RelTo_Top,RelTo_Bottom);

  if not JustOne then
  begin
    NewControl(dl_WhichAll,    RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
    NewControl(dl_WhichNone,   RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
    NewControl(dl_WhichDefault,RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
    NewControl(dl_WhichKeep,   RelTo_Left, RelTo_Size,RelTo_Bottom,RelTo_Size);
  end;
end;                                  { TWhichFieldsDlg.FixControlPos }

procedure TWhichFieldsDlg.SetupWindow;
var
  i,j,EtypeInd: integer;
  F: array[0..255] of char;
begin
  TResizableDialog.SetupWindow;
  DisableSysMinimize;
  InitPos;
                            { Combo types box }
  etype:=0;
  EtypeInd:=0;
  for i:=1 to NumberOfTypes do
  begin
    StrPCopy(F,TypeEntry^[i]);
    j:=SendDlgItemMsg(dl_WhichCBox,cb_AddString,0,Longint(@F));
    if (entry<>Nil) and (Entry^.EntryType=TypeEntry^[i]) then
    begin
      etype:=i; ETypeInd:=j;
    end;
  end;
  if etype=0 then etype:=1;
  if etype>0 then
    SendDlgItemMsg(dl_WhichCBox,cb_SetCurSel,ETypeInd,0);
  FillUpLBoxes(false);
end;                        { TWhichFieldsDlg.SetupWindow }

function TWhichFieldsDlg.WhichAreSelected: string;
var
  Buf: array[1..MaxField+1] of integer;
  i,count,id: integer;
  F: array[0..255] of char;
  S: SelStr;
begin
  S:='';
  if JustOne then
  for id:=1 to 3 do
  begin
    i:=SendDlgItemMsg(id_WhichLBox[id],lb_GetCurSel,0,0);
    if i<>lb_Err then
    begin
      {
      SendDlgItemMsg(id_WhichLBox[id],lb_GetText,i,Longint(@F));
      if (StrLen(F)>0) and (F[StrLen(F)-1]='*') then F[StrLen(F)-1]:=#0;
      S:=Chr(FindInFieldList(StrPas(F)));
      }
      S:=Chr(LoWord(SendDlgItemMsg(id_WhichLBox[id],lb_GetItemData,i,0)));
    end;
  end else
  for id:=1 to 3 do
  begin
    count:=SendDlgItemMsg(id_WhichLBox[id],lb_GetSelItems,FieldLast,Longint(@Buf));
    if Count<>LB_ERR then
      for i:=1 to Count do
      begin
        {
        SendDlgItemMsg(id_WhichLBox[id],lb_GetText,Buf[i],Longint(@F));
        if (StrLen(F)>0) and (F[StrLen(F)-1]='*') then F[StrLen(F)-1]:=#0;
        S:=S+Chr(FindInFieldList(StrPas(F)));
        }
        S:=S+Chr(LoWord(SendDlgItemMsg(id_WhichLBox[id],lb_GetItemData,Buf[i],0)));
      end;
  end;
  ChrDel(S,#0);
  WhichAreSelected:=S; 
end;                            { TWhichFieldsDlg.WhichAreSelected }

procedure TWhichFieldsDlg.UpdateDefs(Default: boolean);
begin
  if Default then DefEditFields^[etype]:=WhichAreSelected
  else EditFields^[etype]:=WhichAreSelected;
end;

procedure TWhichFieldsDlg.CBoxMessage(var Msg: TMessage);
var
  F: array[0..63] of char;
  i: integer;
begin
  if Msg.LParamHi = cbn_SelChange then
  begin
    i:=SendDlgItemMsg(dl_WhichCBox,cb_GetCurSel,0,0);
    if i>=0 then
    begin
      UpdateDefs(false);
      SendDlgItemMsg(dl_WhichCBox,cb_GetLbText,i,Longint(@F));
      etype:=FindInETypeList(StrPas(F));
      FillUpLBoxes(false);
    end;
  end;
  DefWndProc(Msg);
end;                            { TWhichFieldsDlg.CBoxMessage }

procedure TWhichFieldsDlg.RequiredMsg(var Msg: TMessage);
begin
  if JustOne and (Msg.lparamHi=lbn_DblClk) then
  begin
    ok(msg); Exit;
  end else if JustOne and (Msg.lparamHi=lbn_SelChange) then
  begin
    SendDlgItemMsg(id_WhichLBox[2],lb_SetCurSel,word(-1),0);
    SendDlgItemMsg(id_WhichLBox[3],lb_SetCurSel,word(-1),0);
  end;
  DefwndProc (Msg);
end;                     { TWhichFieldsDlg.RequiredMsg }

procedure TWhichFieldsDlg.OptionalMsg(var Msg: TMessage);
begin
  if JustOne and (Msg.lparamHi=lbn_DblClk) then
  begin
    ok(msg); Exit;
  end else if JustOne and (Msg.lparamHi=lbn_SelChange) then
  begin
    SendDlgItemMsg(id_WhichLBox[1],lb_SetCurSel,word(-1),0);
    SendDlgItemMsg(id_WhichLBox[3],lb_SetCurSel,word(-1),0);
  end;
  DefwndProc (Msg);
end;                     { TWhichFieldsDlg.OptionalMsg }

procedure TWhichFieldsDlg.IgnoredMsg(var Msg: TMessage);
begin
  if JustOne and (Msg.lparamHi=lbn_DblClk) then
  begin
    ok(Msg); Exit;
  end else if JustOne and (Msg.lparamHi=lbn_SelChange) then
  begin
    SendDlgItemMsg(id_WhichLBox[1],lb_SetCurSel,word(-1),0);
    SendDlgItemMsg(id_WhichLBox[2],lb_SetCurSel,word(-1),0);
  end;
  DefwndProc (Msg);
end;                      { TWhichFieldsDlg.IgnoredMsg }

procedure TWhichFieldsDlg.AllSel(var Msg: TMessage);
var
  i: integer;
begin
  for i:=1 to 3 do
    SendDlgItemMsg(id_WhichLBox[i],lb_SetSel,1,-1);
  DefWndProc(Msg);
end;

procedure TWhichFieldsDlg.ClearSel(var Msg: TMessage);
var
  i: integer;
begin
  for i:=1 to 3 do
    SendDlgItemMsg(id_WhichLBox[i],lb_SetSel,0,-1);
  DefWndProc(Msg);
end;

procedure TWhichFieldsDlg.DefaultSel(var Msg: TMessage);
begin
  FillUpLBoxes(true);
  DefWndProc(Msg);
end;

procedure TWhichFieldsDlg.KeepSel(var Msg: TMessage);
begin
  DefEditFields^[etype]:=WhichAreSelected;
  DefWndProc(Msg);
end;

procedure TWhichFieldsDlg.Ok(var Msg: TMessage);
var
  i: integer;
  F: array[0..255] of char;
begin
  if not JustOne then EditFields^[etype]:=WhichAreSelected;
  Answer^:=WhichAreSelected;
  i:=SendDlgItemMsg(dl_WhichCBox,cb_GetCurSel,0,0);
  if i<>cb_Err then
  begin
    SendDlgItemMsg(dl_WhichCBox,cb_GetLBText,i,longint(@F));
    Entry^.EntryType:=StrPas(F);
  end;
  EndDlg(id_ok);
end;                    { TWhichFieldsDlg.Ok }


{$I wbibefld.inc }    { Editing fields, objects, hyperlinks, insert abbreviations }


{ TEdEnWindow methods }

Var
  ghKbrdHook: HHook;
  KbdHookInst: TFarProc;
  EdEnWindowActive,EdEnMenuActive: boolean;

{$F+}
function TrapKbHook(Code: integer; wParam: Word; lParam: longint): longint; export;
var
  Send,ScanCode: word;
  i: integer;
  CtrlPressed,ShftPressed,arrow: boolean;

begin
  Send:=0; arrow:=false;
  if EdEnMenuActive or (Code<0) or (Code<>HC_ACTION) or
     (lParam and wmChar_BeingReleased<>0) or
     (not EdEnWindowActive) or AmWaiting then
       { key releases, active menu, and the like - ignore }
  else if (wParam=vk_up)   or (wParam=vk_down) or (wParam=vk_Prior) or
          (wParam=vk_Next) or (wParam=vk_Home) or (wParam=vk_End)   then
    Arrow:=not EdEnMenuActive
  else if (lParam and (wmChar_AltPressed or wmChar_KeyWasDown) = 0) then 
  begin            { ALT not pressed, and not a repeat }
    ScanCode:=LoByte(HiWord(lParam));
    CtrlPressed:=GetKeyState(vk_Control)<0;
    ShftPressed:=GetKeyState(vk_Shift)<0;
    if ShftPressed and (wParam=vk_Delete)        then Send:=mi_EdEditCutEntry
    else if (not CtrlPressed) and (wParam=vk_Delete) then Send:=mi_EdEditClear
    else if CtrlPressed and (wParam=vk_Insert)   then Send:=mi_EdEditCopyEntry
    else if ShftPressed and (wParam=vk_Insert)   then Send:=mi_EdEditPasteEntry
    else if wParam=vk_Escape                     then Send:=mi_EdQuit
    else for i:=0 to PEdEnWindow(EdEnWindow)^.AccelKeys.Count-1 do
      with PAccelKey(PEdEnWindow(EdEnWindow)^.AccelKeys.at(i))^ do
        if (SCode=ScanCode) and (Ctrl=CtrlPressed) then Send:=id;
  end;

  if arrow then            { Send arrowkeys command to parent }
  begin
    PostMessage(EdEnWindow^.HWindow,bib_ArrowKeys,wParam,0);
    TrapKbHook:=1
  end else if Send<>0 then { Send wm_Command accelerator msg to parent }
  begin
    PostMessage(EdEnWindow^.HWindow,wm_Command,Send,MakeLong(0,1));
    TrapKbHook:=1
  end else                 { Pass it on to the previous handler }
      TrapKbHook:=CallNextHookEx(ghKbrdHook,Code,wparam,lparam);
end;                           { TrapKbHook }
{$F-}

constructor TEdEnWindow.Init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                             StartWith: longint; ShowEmpty: boolean);
var
  Rect: TRect;
  NewEntry: boolean;
  i: integer;
begin
  if EditOnlyStrings then
    TResizableDialog.init(AParent,PChar(rc_EditStringDlg),@EdEnSize)
  else
    TResizableDialog.init(AParent,PChar(rc_EditEntryDlg),@EdEnSize);

  Entry:=AEntry;
  FirstTime:=true; changed:=false;
  Starting:=StartWith;
  VerifyAutoName:=true;
  EdEnMenuActive:=false;

  NewEntry:=(entry^.nentry=0);
  if NewEntry then
  begin
    ZeroEntry(Entry); Entry^.name:='';
    if EditOnlyStrings then entry^.EntryType:=TypeEntry^[StringTypeInd]
    else entry^.EntryType:=TypeEntry^[1];
    FieldLast:=DefFieldLast;
  end;
  New(HelpBar,init(@Self));
  New(EntryName,init(@Self,false,true,ShowEmpty,false,HelpBar));
  New(DisplayArea,init(@Self,Nil,HelpBar,false));
  HelpContext:=hc_EditEntry;
  StrPCopy(MenuStringString,'');
  RestoredCaption:=Nil;
  EditFieldStr:=Nil; CopyNameStr:=Nil;
  EdObjStr:=Nil; EdImageStr:=Nil;
  EdEnWindowActive:=false;
  EdEnWindow:=@Self;

  OldFirstShowBuf:=FirstShowBuf;

  OldExpandStrings   :=ExpandStrings;
  OldExpandIniAbbrevs:=ExpandIniAbbrevs;
  OldExpandMacros    :=ExpandMacros;
  OldResolveHyper    :=HyperlinkFlags.on;
  OldStripExtraBraces:=StripExtraBraces;
  OldResolveObjects  :=ResolveObjects;

  ExpandStrings      :=MemExpandStrings;
  ExpandIniAbbrevs   :=MemExpandIniAbbrevs;
  ExpandMacros       :=MemExpandMacros;
  HyperlinkFlags.on  :=MemResolveHyper;
  StripExtraBraces   :=MemStripExtraBraces;
  ResolveObjects     :=MemResolveObjects;

  ObjToEdit:=Nil; Hyperlink:=Nil;
  OldOleVerbatim:=OleVerbatim; OleVerbatim:=true;
end;                            { TEdEnWindow.Init }

procedure TEdEnWindow.SetupWindow;
var
  MSg2: TMessage;
  Menu: HMenu;
  i,j: integer;
  F: array[0..64] of char;
  S: string[64];
begin
  TResizableDialog.SetupWindow;
  if UseCtl3d and Win95 and Win95_3d then
     SetWindowLong(HWindow,gwl_Style,
             GetWindowLong(HWindow,gwl_Style) and not DS_3DLOOK);

  Menu:=GetMenu(HWindow);     { Extract the popup menus }
  HFloatingHeader:=GetSubmenu(Menu,0);
  RemoveMenu(Menu,0,mf_ByPosition);
  if not EditOnlyStrings then
  begin
    GetMenuString(HFloatingHeader,mi_EdEnFString,F,64,mf_ByCommand);
    CopyNameStr:=NewStr(StrPas(F));
  end;

  HFloatingField:=GetSubmenu(Menu,0);
  RemoveMenu(Menu,0,mf_ByPosition);
  if not EditOnlyStrings then
  begin
    GetMenuString(HFloatingField,mi_EdEnFFEdit,F,64,mf_ByCommand);
    EditFieldStr:=NewStr(StrPas(F));
    GetMenuString(HFloatingField,mi_EdEnEdObj,F,64,mf_ByCommand);
    EdObjStr:=StrNew(F);
    S:=StrPas(F);
    StrRepl(S,'Object','Image',1,255,255); StrPCopy(F,S);
    EdImageStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_EdEnActObj,F,64,mf_ByCommand);
    ActivateObjectStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_EdEnCopyObject,F,64,mf_ByCommand);
    CopyObjectStr:=StrNew(F);
    S:=StrPas(F);
    StrRepl(S,'o&bject','i&mage',1,255,255); StrPCopy(F,S);
    CopyImageStr:=StrNew(F);
    GetMenuString(HFloatingField,mi_EdEnFFEdHyper,F,64,mf_ByCommand);
    EdHyperStr:=StrNew(F);
  end;

  AccelKeys.init(11,10);
  AccelKeys.Insert(New(PAccelKey,init('q',mi_EdQuit,       false)));
  if EditOnlyStrings then
  begin
    AccelKeys.Insert(New(PAccelKey,init('a',mi_EdEntryHeader,false)));
    AccelKeys.Insert(New(PAccelKey,init('v',mi_EdDefault,    false)));
  end else
  begin
    AccelKeys.Insert(New(PAccelKey,init('h',mi_EdEntryHeader,false)));
    AccelKeys.Insert(New(PAccelKey,init('f',mi_EdField,      false)));
    AccelKeys.Insert(New(PAccelKey,init('w',mi_EdWhich,      false)));
    AccelKeys.Insert(New(PAccelKey,init('d',mi_EdDefault,    false)));
    AccelKeys.Insert(New(PAccelKey,init('v',mi_EdView,       true)));
  end;

  InitMenuHelp;
  SetupMenu;   
  if EditOnlyStrings then SetWindowText(HWindow,'Edit string')
  else SetWindowText(HWindow,'Edit entry');

  if Application^.MakeWindow(HelpBar)=Nil
        then FatalErrorRC(Str_CantCreateChild,'');
  if Application^.MakeWindow(EntryName)=Nil then
    FatalErrorRC(Str_CantCreateChild,'');
  if (Application^.MakeWindow(DisplayArea)=Nil) then
    FatalErrorRC(Str_CantCreateChild,'');
  OldHelpBar:=CurrentHelpBar;
  CurrentHelpBar:=HelpBar;

  { Set keyboard hook for the accelerators }
  KbdHookInst:=MakeProcInstance(@TrapKbHook,HInstance);
  ghKbrdHook:=SetWindowsHookEx(wh_Keyboard,THookProc(KbdHookInst),
                               Hinstance,GetCurrentTask);

  InitPos;
  Update;

  if (Starting<>-1) then
  begin
    FillChar(Msg2,0,sizeof(Msg2));
    ShowWindow(HWindow,sw_show);
    if (Starting=0) or (WhichFieldPtr(Starting)^.fld=0) then
    begin
      ModifyFieldInd:=0; EditAHeader(Msg2);
    end else with WhichFieldPtr(Starting)^ do
    begin
      ModifyFieldInd:=fld;
      if (Hyper<>-1) then
      begin
        UpdateWindow(HWindow);
        HyperLink:=PHyperlinkObj(DisplayArea^.Hyperlinks.at(Hyper));
        EditAHyper(Msg2);
      end else if Obj<>-1 then
      begin
        UpdateWindow(HWindow);
        ObjToEdit:=POleObj(DisplayArea^.Objects.at(Obj));
        if not ObjToEdit^.ok then ObjToEdit:=Nil;
        EditAnObject(Msg2);
      end else EditAField(Msg2);
    end;
  end;
end;                            { TEdEnWindow.SetupWindow }

procedure TEdEnWindow.InitMenuHelp;
var
  H,H1: HMenu;
begin
  if EditOnlyStrings then
  begin
    MenuHelp.init(30,10);
    with MenuHelp do
    begin
  {--Popup menus--}
      {--Header--}  
        Insert(New(PMenuHelpObj,init(mi_EdEnFEdit,      HelpSEdit_Name)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFCopy,      HelpSEdit_PopupCopyName)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFECopy,     HelpSEdit_PopupCopyNameEx)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFCutName,   HelpSEdit_PopupCutName)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFPasteName, HelpSEdit_PopupPasteName)));
      {--Field--}
        Insert(New(PMenuHelpObj,init(mi_EdEnFFEdit,       HelpSEdit_Value)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFCopy,       HelpSEdit_PopupCopyValue)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFCopyEx,     HelpSEdit_PopupCopyValueEx)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFCutField,   HelpSEdit_PopupCutValue)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFPasteField, HelpSEdit_PopupPasteValue)));   
        Insert(New(PMenuHelpObj,init(mi_EdEditPasteClip,  HelpSEdit_PasteStringClip)));
      Insert(New(PMenuHelpObj,init(mi_EdEntryHeader,  HelpSEdit_Name)));
      Insert(New(PMenuHelpObj,init(mi_EdDefault,      HelpSEdit_Value)));
        Insert(New(PMenuHelpObj,init(mi_EdEnCopyName,     HelpSEdit_PopupCopyName)));
        Insert(New(PMenuHelpObj,init(mi_EdEnCopyNameEx,   HelpSEdit_PopupCopyNameEx)));
        Insert(New(PMenuHelpObj,init(mi_EdEnCopyField,    HelpSEdit_PopupCopyValue)));
        Insert(New(PMenuHelpObj,init(mi_EdEnCopyFieldEx,  HelpSEdit_PopupCopyValueEx)));
        Insert(New(PMenuHelpObj,init(mi_EdEditCutEntry,   HelpSEdit_CutString)));
        Insert(New(PMenuHelpObj,init(mi_EdEditCopyEntry,  HelpSEdit_CopyString)));
        Insert(New(PMenuHelpObj,init(mi_EdEditPasteEntry, HelpSEdit_PasteString)));
        Insert(New(PMenuHelpObj,init(mi_EdEditPasteClip,  HelpSEdit_PasteStringClip)));
        Insert(New(PMenuHelpObj,init(mi_EdEditClear,      HelpSEdit_ClearString)));
      Insert(New(PMenuHelpObj,init(mi_EdFinish, HelpEdit_Header)));
      Insert(New(PMenuHelpObj,init(mi_EdSave,   HelpEdit_Next)));
      Insert(New(PMenuHelpObj,init(mi_EdSkip,   HelpEdit_Skip)));
      Insert(New(PMenuHelpObj,init(mi_EdQuit,   HelpEdit_Quit)));
      Insert(New(PMenuHelpObj,init(mi_EdAbort,  HelpEdit_Abort)));
    end;
    PopupHelp.Init(5,10);
    with PopupHelp do
    begin
      H:=GetMenu(HWindow);
      Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'Quit')),HelpEdit_QuitMenu)));
      H:=SearchForMenuItem(H,'edit');
      Insert(New(PMenuHelpObj,Init(Word(H),HelpSEdit_EditMenu)));
      H1:=SearchForMenuItem(H,'copy name');
      Insert(New(PMenuHelpObj,init(H1,HelpSEdit_PopupCopyName)));
      H1:=SearchForMenuItem(H,'copy value');
      Insert(New(PMenuHelpObj,init(H1,HelpSEdit_PopupCopyValue)));
      PopupHelp.Insert(New(PMenuHelpObj,Init(GetSystemMenu(HWindow,false),HelpSys_Menu)));
    end;
  end else                            { Entries }
  begin
    MenuHelp.init(40,10);
    with MenuHelp do
    begin
  {--Popup menus--}
      {--Header--}  
        Insert(New(PMenuHelpObj,init(mi_EdEnFEdit,     HelpMain_PopupEditHeader)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFEdHyper, HelpMain_PopupEditHyper)));
        Insert(New(PMenuHelpObj,init(mi_EdEnEdObj,     HelpMain_PopupEditObject)));
        Insert(New(PMenuHelpObj,init(mi_EdEnActObj,    HelpMain_PopupActObj)));
        Insert(New(PMenuHelpObj,init(mi_EdEnCopyObject,HelpMain_PopupCopyObject)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFCopy,     HelpMain_PopupCopyHeader)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFECopy,    HelpMain_PopupCopyHeaderEx)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFString,   HelpMain_PopupCopyString)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFCutName,  HelpEdit_CutName)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFPasteName,HelpEdit_PasteName)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFAutoName, HelpEdit_AutoName)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFDelName,  HelpEdit_DelName)));
      {--Field--}
        Insert(New(PMenuHelpObj,init(mi_EdEnFFEdit,      HelpMain_PopupEditField)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFCopy,      HelpMain_PopupCopyField)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFCopyEx,    HelpMain_PopupCopyFieldEx)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFCutField,  HelpEdit_CutField)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFPasteField,HelpEdit_PasteField)));
        Insert(New(PMenuHelpObj,init(mi_EdEnFFDelField,  HelpEdit_DelField)));
      Insert(New(PMenuHelpObj,init(mi_EdEntryHeader,  HelpEdit_Header)));
      Insert(New(PMenuHelpObj,init(mi_EdField,        HelpEdit_Field)));
      Insert(New(PMenuHelpObj,init(mi_EdWhich,        HelpEdit_Which)));
      Insert(New(PMenuHelpObj,init(mi_EdDefault,      HelpEdit_Default)));
        Insert(New(PMenuHelpObj,init(mi_EdEditMove,       HelpEdit_MoveField)));
        Insert(New(PMenuHelpObj,init(mi_EdEditCopy,       HelpEdit_CopyField)));
        Insert(New(PMenuHelpObj,init(mi_EdEditErase,      HelpEdit_EraseFields)));
        Insert(New(PMenuHelpObj,init(mi_EdEditAdd,        HelpEdit_AddUndec)));
        Insert(New(PMenuHelpObj,init(mi_EdEditRemove,     HelpEdit_DelUndec)));
        {--Copy header submenu--}
          Insert(New(PMenuHelpObj,init(mi_EdEnCopyName,   HelpMain_PopupCopyHeader)));
          Insert(New(PMenuHelpObj,init(mi_EdEnCopyNameEx, HelpMain_PopupCopyHeaderEx)));
          Insert(New(PMenuHelpObj,init(mi_EdEnCopyNameStr,HelpMain_PopupCopyString)));
        Insert(New(PMenuHelpObj,init(mi_EdEnCopyField,    HelpMain_CopyField)));
        Insert(New(PMenuHelpObj,init(mi_EdEditCutEntry,   HelpEdit_CutEntry)));
        Insert(New(PMenuHelpObj,init(mi_EdEditCopyEntry,  HelpEdit_CopyEntry)));
        Insert(New(PMenuHelpObj,init(mi_EdEditPasteEntry, HelpEdit_PasteEntry)));
        Insert(New(PMenuHelpObj,init(mi_EdEditPasteClip,  HelpMain_PasteEntryClip)));
        Insert(New(PMenuHelpObj,init(mi_EdEditClear,      HelpEdit_ClearEntry)));
      { View menu }
        Insert(New(PMenuHelpObj,init(mi_EdView,          HelpEdit_ViewAll)));
        Insert(New(PMenuHelpObj,init(mi_EdShowformat,    HelpMain_ShowFormat)));
        Insert(New(PMenuHelpObj,init(mi_EdExpandAbbrevs, HelpEdit_ExpandAbbrevs)));
        Insert(New(PMenuHelpObj,init(mi_EdStripBraces,   HelpEdit_HideBraces)));
        Insert(New(PMenuHelpObj,init(mi_EdResolveHyper,  HelpEdit_ResolveHyper)));
        Insert(New(PMenuHelpObj,init(mi_EdResolveObjects,HelpEdit_ResolveObjects)));
        Insert(New(PMenuHelpObj,init(mi_EdResolveAll,    HelpEdit_ResolveAll)));
        Insert(New(PMenuHelpObj,init(mi_EdResolveNone,   HelpEdit_ResolveOff)));
      Insert(New(PMenuHelpObj,init(mi_EdFinish, HelpEdit_Finish)));
      Insert(New(PMenuHelpObj,init(mi_EdSave,   HelpEdit_Next)));
      Insert(New(PMenuHelpObj,init(mi_EdSkip,   HelpEdit_Skip)));
      Insert(New(PMenuHelpObj,init(mi_EdQuit,   HelpEdit_Quit)));
      Insert(New(PMenuHelpObj,init(mi_EdAbort,  HelpEdit_Abort)));
    end;
    PopupHelp.Init(5,10);
    with PopupHelp do
    begin
      H:=GetMenu(HWindow);
      Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'Quit')),HelpEdit_QuitMenu)));
      Insert(New(PMenuHelpObj,Init(Word(SearchForMenuItem(H,'View')),HelpEdit_ViewMenu)));
      H:=SearchForMenuItem(H,'edit');
      Insert(New(PMenuHelpObj,Init(Word(H),HelpEdit_EditMenu)));
      H:=SearchForMenuItem(H,'copy name to clipboard');
      Insert(New(PMenuHelpObj,init(H,HelpMain_CopyHeaderMenu)));
      PopupHelp.Insert(New(PMenuHelpObj,Init(GetSystemMenu(HWindow,false),HelpSys_Menu)));
    end;
  end;
  with MenuHelp do
  begin
    { System menu }
    Insert(New(PMenuHelpObj,init(sc_Restore,  HelpSys_Restore)));
    Insert(New(PMenuHelpObj,init(sc_Move,     HelpSys_Move)));
    Insert(New(PMenuHelpObj,init(sc_Size,     HelpSys_Size)));
    Insert(New(PMenuHelpObj,init(sc_Minimize, HelpSys_Minimize)));
    Insert(New(PMenuHelpObj,init(sc_Maximize, HelpSys_Maximize)));
    Insert(New(PMenuHelpObj,init(sc_TaskList, HelpSys_TaskList)));
    Insert(New(PMenuHelpObj,init(sc_Close,    HelpSys_Close)));
    if SystemMenu_SystemID<>0 then
      Insert(New(PMenuHelpObj,init(SystemMenu_SystemID,HelpSys_System))); 
  end;
end;                        { TEdEnWindow.InitMenuHelp }

procedure TEdEnWindow.SetupMenu;
var
  H: HMenu;
  N: word;
begin
  H:=GetMenu(HWindow);
  N:=GetMenuItemCount(H);
  DeleteMenu(H,N-1,mf_ByPosition);
  DeleteMenu(H,N-2,mf_ByPosition);
  DeleteMenu(H,N-3,mf_ByPosition);
  InsertMenu(H,$FFFF,mf_ByPosition or mf_String,mi_EdSave,'&Save');
  InsertMenu(H,$FFFF,mf_ByPosition or mf_String,mi_EdQuit,'&Quit');
  AccelKeys.Insert(New(PAccelKey,init('s',mi_EdSave, false)));
  AccelKeys.Insert(New(PAccelKey,init(#27,mi_EdQuit, false)));
end;               { TEdEnWindow.SetupMenu }

procedure TEdEnWindow.CalcSizes;
var
  Rect: TRect;
  W,H: integer;
begin
  GetClientRect(HWindow,Rect);
  W:=Rect.right-Rect.left; H:=rect.Bottom-Rect.Top;
  with EntryName^ do
  begin
    MoveWindow(Hwindow,0,0,W,EntryNameHeight,true);
    FirstTime:=false;
  end;
  with DisplayArea^ do
  begin
    MoveWindow(Hwindow,-1,EntryNameHeight,W+2,H-EntryNameHeight-HelpBar^.Height,true);
    FirstTime:=false;
  end;
  HelpBar^.MoveBarTo(W,H);
end;                           { TEdEnWindow.CalcSizes }

procedure TEdEnWindow.WmSize(var Msg: TMessage);
var
  F: array[0..255] of char;
begin
  if Msg.wParam=Size_Minimized then
  begin
    GetWindowText(HWindow,F,255);
    RestoredCaption:=StrNew(F);
    if entry^.name<>'' then
    begin
      StrPCopy(F,StrPas(F)+' - '+Entry^.name);
      SetWindowText(HWindow,F);
    end;
    ShowWindow(HMainW,sw_Hide);
  end else
  begin
    if RestoredCaption<>Nil then
    begin
      SetWindowText(HWindow,RestoredCaption);
      StrDispose(RestoredCaption); RestoredCaption:=Nil;
    end;
    ShowWindow(HMainW,sw_Show);
    if FirstTime then FirstTime:=false
    else CalcSizes;
  end;
end;                      { TEdEnWindow.WmSize }

procedure TEdEnWindow.wmActivate(var Msg: TMessage);
begin
  EdEnWindowActive:=(Msg.wParam<>wa_InActive);
  TResizableDialog.wmActivate(Msg);
end;

procedure TEdEnWindow.Update;
var
  H,Menu: HMenu;
  CanCopy,CanPaste: boolean;
  i,MenuPos: integer;
  tmp: string[64];
  F: array[0..64] of char;
begin
  Menu:=GetMenu(HWindow);

  MenuPos:=-1;
  H:=SearchForMenuItem(Menu,'edit');
  for i:=0 to GetMenuItemCount(H) do
  begin
    GetMenuString(H,i,F,64,mf_ByPosition);
    tmp:=StrPas(F); ChrDel(tmp,'&'); StrLwr(tmp);
    if tmp='copy name' then MenuPos:=i;
  end;
  if MenuPos>-1 then ChangeMenuState(H,-MenuPos,Entry^.name<>'');
  if (entry^.nentry>0) and (CopyNameStr<>Nil) then
  begin
    tmp:=CopyNameStr^;
    StrRepl(tmp,'%s',NameClickMenuString^,1,1,64);
    StrRepl(tmp,'#1',Entry^.name,1,255,255);
    if length(tmp)>60 then tmp:=Copy(tmp,1,56)+'..."';
    StrPCopy(F,tmp);
    ModifyMenu(Menu,mi_EdEnCopyNameStr,mf_ByCommand or mf_String,mi_EdEnCopyNameStr,F);
  end;

  CanCopy:=(entry^.nentry>0);
  CanPaste:=not (ClipboardEmpty or
                            (ClipboardString and not EditOnlyStrings) or
                            (EditOnlyStrings and not ClipboardString));

  ChangeMenuState(Menu,mi_EdEditMove,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdEditCopy,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdEditErase,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdEnCopyField,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdEnCopyFieldEx,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdEditAdd,FieldLast<MaxField);
  ChangeMenuState(Menu,mi_EdEditRemove,FieldLast>OrigFieldLast);
  ChangeMenuState(Menu,mi_EdEditCutEntry,CanCopy);
  ChangeMenuState(Menu,mi_EdEditCopyEntry,CanCopy);
  ChangeMenuState(Menu,mi_EdEditPasteEntry,CanPaste);
  ChangeMenuState(Menu,mi_EdEditClear,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdEditMove,entry^.nentry>0);
  ChangeMenuState(Menu,mi_EdSave,entry^.nentry>0);

  CheckMenu(Menu,mi_EdView,not FirstShowBuf);
  CheckMenu(Menu,mi_EdExpandAbbrevs,ExpandStrings);
  CheckMenu(Menu,mi_EdStripBraces,StripExtraBraces);
  CheckMenu(Menu,mi_EdResolveHyper,HyperlinkFlags.on);
  CheckMenu(Menu,mi_EdResolveObjects,ResolveObjects);

  ChangeMenuState(Menu,mi_EdResolveAll, not (ExpandStrings and
    StripExtraBraces and HyperlinkFlags.on and ResolveObjects));
  ChangeMenuState(Menu,mi_EdResolveNone, (ExpandStrings or
    StripExtraBraces or HyperlinkFlags.on or ResolveObjects));

  DrawMenuBar(HWindow);
  EntryName^.Update; DisplayArea^.Update;
end;                     { TEdEnWindow.Update }

procedure TEdEnWindow.bibUpdate(var Msg: TMessage);
begin Update; end;

procedure TEdEnWindow.wmInitMenu(var Msg: TMessage);
begin
  EdEnMenuActive:=true;
  if IsClipboardFormatAvailable(cf_text) then
    EnableMenuItem(HMenu(Msg.wParam),mi_EdEditPasteClip,mf_ByCommand or mf_Enabled)
  else
    EnableMenuItem(HMenu(Msg.wParam),mi_EdEditPasteClip,mf_ByCommand or mf_Grayed);
end;                  { TEdEnWindow.wmInitMenu }

procedure TEdEnWindow.wmMenuSelect(var Msg: TMessage);
var
  MP: PMenuHelpObj;

function Matches(P: Pointer): boolean; far;
begin
  Matches:=PMenuHelpObj(P)^.m=Msg.wParam;
end;

begin
  if (Msg.lParamLo=word(-1)) and (Msg.lParamHi=0) then
  begin
    HelpBar^.ClearHelpText;
    InvalidateRect(HelpBar^.HWindow,Nil,true);
    EdEnMenuActive:=false;
    UpdateWindow(HelpBar^.HWindow);
  end else if Msg.lParamLo and mf_Separator=0 then
  begin
    if Msg.lParamLo and mf_Popup<>0 then
      MP:=PopupHelp.FirstThat(@Matches)
    else MP:=MenuHelp.FirstThat(@Matches);
    if MP=Nil then HelpBar^.HideHelpText(false,true)
    else begin
      HelpBar^.PutHelpText(MP^.s);
    end;
  end else CurrentHelpBar^.ClearHelpText;
end;                             { TEdEnWindow.wmMenuSelect }

procedure TEdEnWindow.ArrowKeys(var Msg: TMessage);
begin
  case Msg.wParam of
    vk_Down:  DisplayArea^.Scroller^.ScrollBy(0,1);
    vk_Up:    DisplayArea^.Scroller^.ScrollBy(0,-1);
    vk_Next:  DisplayArea^.Scroller^.ScrollBy(0,DisplayArea^.Scroller^.YPage);
    vk_Prior: DisplayArea^.Scroller^.ScrollBy(0,-DisplayArea^.Scroller^.YPage);
    vk_Home:  DisplayArea^.Scroller^.ScrollTo(0,0);
    vk_End:   DisplayArea^.Scroller^.ScrollTo(0,DisplayArea^.Scroller^.YRange);
  end;
end;                              { TPattEditDlg.ArrowKeys }

{ Work methods }

procedure TEdEnWindow.CopyHeader(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,Nil);
end;

procedure TEdEnWindow.CopyHeaderEx(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PCopyToClipDlg,init(@Self,Entry,0)));
end;

procedure TEdEnWindow.MenuStringCopy(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,NameClickMenuString);
end;

procedure TEdEnWindow.EditAHeader(var Msg: TMessage);
begin
  GetHeader(Msg);
end;

procedure TEdEnWindow.CutName(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,Nil);
  Entry^.name:=''; Changed:=true; Update;
end;

procedure TEdEnWindow.PasteName(var Msg: TMessage);
var
  H: THandle;
  F: PChar;
  i: integer;
begin
  if OpenClipboard(HWindow) then
  begin
    H:=GetClipboardData(cf_Text);
    if H<>0 then
    begin
      F:=GlobalLock(H);
      if StrLen(F)<255 then Entry^.name:=StrPas(F)
      else begin
        Move(F^,Entry^.name[1],255); Entry^.name[0]:=#255;
      end;
      GlobalUnlock(H);
      i:=0;
      while i<length(entry^.name) do
      begin
        inc(i);
        if Entry^.name[i] in NameForbid then Entry^.name[0]:=chr(i-1);
      end;
      Changed:=true; Update;
    end;
    CloseClipboard;
  end else ErrorMessageRC(Str_ClipboardAlreadyOpen,'');

end;                            { TEdEnWindow.PasteName }

procedure TEdEnWindow.AutoName(var Msg: TMessage);
var
  S: Pstring;
begin
  New(S);
  S^:=''; AutoLabel(entry,LabelTemplate^,S^);
  if S^='' then ErrorMessageRC(Str_EmptyTemplate,'')
  else begin
    entry^.name:=S^; Changed:=true; Update;
  end;
  Dispose(S);
end;                { TEdEnWindow.AutoName }

procedure TEdEnWindow.DeleteName(var Msg: TMessage);
begin
  if Entry^.name='' then messagebeep(0)
  else begin
    entry^.name:=''; Changed:=true; Update;
  end;
end;           { TEdEnWindow.DeleteName }

procedure TEdEnWindow.CopyField(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,ModifyFieldInd,false,false,Nil);
end;

procedure TEdEnWindow.CopyFieldEx(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PCopyToClipDlg,init(@Self,Entry,ModifyFieldInd)));
end;

procedure TEdEnWindow.EditSomething(fld: integer; H:PHyperLinkObj; O:POleObj);
begin
  if Application^.ExecDialog(New(PEditFieldDlg,
     init(@Self,Chr(fld),H,O,OldExpandStrings,
          OldExpandIniAbbrevs,Entry^.BinList)))>ChangedFlag then
  begin
    changed:=true; Update;
  end;
end;            { TEdEnWindow.EditSomething }

procedure TEdEnWindow.EditAField(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,Nil,Nil); end;

procedure TEdEnWindow.EditAHyper(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,Hyperlink,Nil); end;

procedure TEdEnWindow.EditAnObject(var Msg: TMessage);
begin EditSomething(ModifyFieldInd,Nil,ObjToEdit); end;

procedure TEdEnWindow.CopyObject(var Msg: TMessage);
begin
  if ObjToEdit<>Nil then ObjToEdit^.CopyToClip(HWindow);
end;

procedure TEdEnWindow.ActivateObject(var Msg: TMessage);
var
  i: TOleStatus;
  M: TMSG;
  OleObject: POleObj;
  R: TRect;
  F: array[0..255] of char;
begin
  if ObjToEdit=Nil then Exit;
  repeat
    i:=OleQueryReleaseStatus(ObjToEdit^.O);
    if i = ole_Busy then
    begin
      if GetMessage(M, 0, 0, 0) and not
        ((M.Message>=wm_KeyFirst) and (M.Message<=wm_KeyLast)) and not
        ((M.Message>=wm_MouseFirst) and (M.Message<=wm_MouseLast)) then
      begin
        TranslateMessage(M);
        DispatchMessage(M);
      end;
    end;
  until (i<>Ole_Busy);
  if I=Ole_Error_Object then Exit;
  StrPCopy(F,bibname^);
  OleSetHostNames(ObjToEdit^.O,F,ObjToEdit^.name);
  ObjToEdit^.Activate(DisplayArea,Nil);
end;                   { TEdEnWindow.ActivateObject }

procedure TEdEnWindow.DeleteField(var Msg: TMessage);
begin
  with Entry^ do
  if (ModifyFieldInd>0) and (index[ModifyFieldInd]<>0) then
  begin
    Content[index[ModifyFieldInd]]:='';
    if BigIndex[ModifyFieldInd]>0 then
    begin
      BigFree[BigIndex[ModifyFieldInd]]:=true;
      Blen[BigIndex[ModifyFieldInd]]:=0;
    end;
    index[ModifyFieldInd]:=0; BigIndex[ModifyFieldInd]:=0;
    CleanupEntry(Entry);
    Changed:=true; Update;
  end;
end;                    { TEdEnWindow.DeleteField }

procedure TEdEnWindow.CutField(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,ModifyFieldInd,false,false,Nil);
  DeleteField(Msg);
end;

procedure TEdEnWindow.PasteField(var Msg: TMessage);
var
  Tlen: word;
  S,F: PChar;
  i,ifld,NewBuffer,OrigTLen: word;
  H: THandle;
begin
  if not OpenClipboard(HWindow) then
  begin
    ErrorMessageRC(Str_ClipboardAlreadyOpen,'');
    Exit;
  end;
  H:=GetClipboardData(cf_Text);
  if H=0 then
  begin
    CloseClipboard; Exit;
  end;
  ifld:=ModifyFieldInd;

  F:=GlobalLock(H); OrigTLen:=StrLen(F);
  GetMem(S,OrigTLen+1);

  TLen:=0;
  for i:=0 to OrigTLen-1 do
  begin
    if F[i] in [#0..#32] then
    begin
      if (TLen>0) and (S[TLen-1]<>' ') then
      begin
        S[TLen]:=' '; inc(TLen);
      end;
    end else
    begin
      S[TLen]:=F[i]; inc(TLen);
    end;
  end;
  S[TLen]:=#0;
  GlobalUnlock(H); CloseClipboard;

  if TLen>0 then
  with entry^ do
  begin
    if EditOnlyStrings then
    begin
      if Prog8Bit then Conv28Bit(S^,Tlen,false);
    end else if not EditOnlyStrings then
    begin
      if Prog8Bit then Conv28Bit(S^,Tlen,FieldParams^[ifld].AuthorLike);
      if UseAutoCap and (FieldParams^[ifld].Capitalize) then
      begin
        Capitalize(BigTypePtr(S),word(Tlen),0,1,FieldParams^[ifld].AuthorLike);
      end;
    end;
                                          { Put in place }
    if index[ifld]=0 then         { New field }
    begin
      nentry:=nentry+1;
      index[ifld]:=nentry;
      content[index[ifld]]:='';
      BigIndex[ifld]:=0;
    end;
    if Tlen<256 then content[index[ifld]]:=StrPas(S)
    else begin
      Move(S^,content[index[ifld]][1],255);
      content[index[ifld]][0]:=#255;
    end;
    NewBuffer:=FindBigFree(Entry,false);
    if (Tlen<256) or (MaxNumberBig=0) or
         ((BigIndex[ifld]=0) and (NewBuffer=0)) then
    begin                          { A string }
      if BigIndex[ifld]>0 then
      begin
        BigFree[BigIndex[ifld]]:=true;
        Blen[BigIndex[ifld]]:=0;
        BigIndex[ifld]:=0;
      end;
    end else
    begin                      { A long field }
      if BigIndex[ifld]=0 then
      begin                    { A new long field }
        BigIndex[ifld]:=NewBuffer;
        BigFree[NewBuffer]:=false;
      end;
      Move(S^,Big[BigIndex[ifld]]^,Tlen);
      Blen[BigIndex[ifld]]:=Tlen;
    end;
  end;

  FreeMem(S,OrigTLen+1);
  CleanupEntry(Entry);
  Changed:=true; Update;
end;                              { TEdEnWindow.PasteField }

procedure TEdEnWindow.ClickedOnField(var Msg: TMessage);
var
  MP: longint;
  Ctrl,Shift: boolean;
  tmp: string[64];
  F: array[0..64] of char;
  FldRgn: PFieldRegion;
begin
  ObjToEdit:=Nil; HyperLink:=Nil;
  if Msg.wParam=$FFFF then ModifyFieldInd:=0
  else begin
    FldRgn:=PFieldRegion(DisplayArea^.ShownList.at(Msg.wParam));
    ModifyFieldInd:=FldRgn^.fld;
    if (FldRgn^.Hyperlink<>-1) then
      HyperLink:=PHyperlinkObj(DisplayArea^.Hyperlinks.at(FldRgn^.Hyperlink));
    if (FldRgn^.Obj<>-1) then
    begin
      ObjToEdit:=POleObj(DisplayArea^.Objects.at(FldRgn^.Obj));
      if not ObjToEdit^.ok then ObjToEdit:=Nil;
    end;
  end;
  Msg.Result:=1;
  Shift:=(Msg.lParamHi and mk_Shift   <> 0);
  Ctrl :=(Msg.lParamHi and mk_Control <> 0);
  if Msg.lParamLo=mk_RButton then
  begin
    MP:=GetMessagePos;
    if ModifyFieldInd=0 then        { Header }
    begin
      if (CopyNameStr<>Nil) then
      begin
        tmp:=CopyNameStr^;
        StrRepl(tmp,'%s',NameClickMenuString^,1,1,64);
        StrRepl(tmp,'#1',Entry^.name,1,255,255);
        if length(tmp)>60 then tmp:=Copy(tmp,1,56)+'..."';
        StrPCopy(F,tmp);
        ModifyMenu(HFloatingHeader,mi_EdEnFString,mf_ByCommand or mf_String,
                   mi_EdEnFString,F);
      end;
      ChangeMenuState(HFloatingHeader,mi_EdEnFPasteName,
                                          IsClipboardFormatAvailable(cf_Text));
      ChangeMenuState(HFloatingHeader,mi_EdEnFCopy,   Entry^.name<>'');
      ChangeMenuState(HFloatingHeader,mi_EdEnFECopy,  Entry^.name<>'');
      ChangeMenuState(HFloatingHeader,mi_EdEnFString, Entry^.name<>'');
      ChangeMenuState(HFloatingHeader,mi_EdEnFCutName,Entry^.name<>'');
      ChangeMenuState(HFloatingHeader,mi_EdEnFDelName,Entry^.name<>'');
      TrackPopupMenu(HFloatingHeader,tpm_LeftAlign or tpm_RightButton,
                   LoWord(MP), HiWord(MP), 0, HWindow, Nil);
    end else
    begin
      if EditFieldStr<>Nil then
      begin
        tmp:=EditFieldStr^;
        StrRepl(tmp,'%s',TypeField^[ModifyFieldInd],1,255,255);
        if length(tmp)>60 then tmp:=Copy(tmp,1,56)+'..."';
        StrPCopy(F,tmp);
        ModifyMenu(HFloatingField,mi_EdEnFFEdit,mf_ByCommand or mf_String,
                   mi_EdEnFFEdit,F);
      end;
      if not EditOnlyStrings then
      begin
        RemoveMenu(HFloatingField,mi_EdEnEdObj,     mf_ByCommand);
        RemoveMenu(HFloatingField,mi_EdEnCopyObject,mf_ByCommand);
        RemoveMenu(HFloatingField,mi_EdEnActObj,    mf_ByCommand);
        RemoveMenu(HFloatingField,mi_EdEnFFEdHyper, mf_ByCommand);
        if ObjToEdit<>Nil then
        begin
          if ObjToEdit^.IsGraphic then
          begin
            InsertMenu(HFloatingField,1,mf_ByPosition or mf_String,
                       mi_EdEnEdObj,EdImageStr);
            InsertMenu(HFloatingField,2,mf_ByPosition or mf_String,
                       mi_EdEnCopyObject,CopyImageStr);
          end else
          begin
            InsertMenu(HFloatingField,1,mf_ByPosition or mf_String,
                       mi_EdEnEdObj,EdObjStr);
            InsertMenu(HFloatingField,2,mf_ByPosition or mf_String,
                       mi_EdEnCopyObject,CopyObjectStr);
            InsertMenu(HFloatingField,3,mf_ByPosition or mf_String,
                       mi_EdEnActObj,ActivateObjectStr);
          end;
        end;
        if Hyperlink<>Nil then
        begin
          InsertMenu(HFloatingField,1,mf_ByPosition or mf_String,
                     mi_EdEnFFEdHyper,EdHyperStr);
        end;
      end;
      ChangeMenuState(HFloatingHeader,mi_EdEnFFPasteField,
                                      IsClipboardFormatAvailable(cf_Text));
      TrackPopupMenu(HFloatingField,tpm_LeftAlign or tpm_RightButton,
                     LoWord(MP), HiWord(MP), 0, HWindow, Nil);
    end;
  end else if not (Shift or Ctrl) then
  begin
    if ModifyFieldInd=0 then GetHeader(Msg)
    else EditAField(Msg)
  end else if Shift or Ctrl then
  begin
    if ModifyFieldInd>0 then
      CopyFieldToClip(@Self,Entry,ModifyFieldInd,Shift and Ctrl,false,Nil)
    else
      CopyFieldToClip(@Self,Entry,0,Shift,Ctrl,Nil);
  end;
end;                            { TEdEnWindow.ClickedOnField }

procedure TEdEnWindow.GetHeader(var Msg: TMessage);
var
  o_k: boolean;
begin
  if EditOnlyStrings then
    o_k:=Application^.ExecDialog(New(PEntryNameDlg,Init(@Self,Entry,false)))=id_ok
  else
    o_k:=Application^.ExecDialog(New(PEntryHeaderDlg,Init(@Self,Entry)))=id_ok;
  if o_k then
  begin
    Changed:=true; Update;
  end;
end;                { TEdEnWindow.GetHeader }

procedure TEdEnWindow.OneField(var Msg: TMessage);
var
  Select: SelStr;
begin
  if Application^.ExecDialog(New(PWhichFieldsDlg,
                  Init(@Self,@Select,Entry,true)))=id_ok then
    EditTheFields(Select);
end;

procedure TEdEnWindow.Which(var Msg: TMessage);
var
  Select: SelStr;
begin
  if Application^.ExecDialog(New(PWhichFieldsDlg,
                   Init(@Self,@Select,Entry,false)))=id_ok then
    EditTheFields(Select);
end;

procedure TEdEnWindow.Default(var Msg: TMessage);
var
  Flist: SelStr;
begin
  if Entry<>Nil then
  begin
    if EditOnlyStrings then
    begin
      Flist:=''; Flist:=Chr(StringIndex);
      EditTheFields(Flist);
    end else
    begin
      if EditFields^[FindInETypeList(entry^.EntryType)]='' then
        messagebeep(0)
      else 
        EditTheFields(EditFields^[FindInETypeList(entry^.EntryType)]);
    end;
  end;
end;                                { TEdEnWindow.Default }

procedure TEdEnWindow.AlmostZeroEntry;
var
  ereal, eentry: longint;
begin
  ereal:=entry^.realnum; eentry:=Entry^.entrynum;
  ZeroEntry(Entry);
  Entry^.realnum:=ereal; Entry^.EntryNum:=eentry;
end;

procedure TEdEnWindow.FieldMove(var Msg: TMessage);
var
  FromField,ToField: integer;
begin
  FromField:=0; ToField:=0;
  if Application^.ExecDialog(New(PManipFieldsDlg,Init(@Self,
    true,Entry,@FromField,@ToField)))=id_ok then
  with Entry^ do
  if (index[ToField]=0) or AskIfRC(Str_FieldNotEmpty,typefield^[ToField],'warning',
     'Overwrite','Cancel') then
  begin
    index[ToField]:=Index[FromField];
    BigIndex[ToField]:=BigIndex[FromField];
    Field[index[ToField]]:=TypeField^[ToField];
    Index[FromField]:=0;
    BigIndex[FromField]:=0;
    CleanupEntry(Entry);
    changed:=true; Update;
  end;
end;                              { TEdEnWindow.FieldMove }

procedure TEdEnWindow.FieldCopy(var Msg: TMessage);
var
  FromField,ToField: integer;
begin
  FromField:=0; ToField:=0;
  if Application^.ExecDialog(New(PManipFieldsDlg,Init(@Self,
    false,Entry,@FromField,@ToField)))=id_ok then
  with Entry^ do
  if (index[ToField]=0) or AskIfRC(Str_FieldNotEmpty,typefield^[ToField],'warning',
     'Overwrite','Cancel') then
  begin
    if Index[ToField]=0 then
    begin
      inc(nentry);
      field[nentry]:=typefield^[ToField];
      index[ToField]:=nentry;
    end;
    Content[nentry]:=Content[index[FromField]];
    if BigIndex[ToField]>0 then
    begin
      BigFree[BigIndex[ToField]]:=true;
      Blen[BigIndex[ToField]]:=0;
      BigIndex[ToField]:=0;
    end;
    if BigIndex[FromField]>0 then
    begin
      BigIndex[ToField]:=FindBigFree(Entry,true);
      if BigIndex[ToField]>0 then
      begin
        Blen[BigIndex[ToField]]:=0;
        Move(Big[BigIndex[FromField]]^[1],
                           Big[BigIndex[ToField]]^[1],
                           Blen[BigIndex[FromField]]);
        Blen[BigIndex[ToField]]:= Blen[BigIndex[FromField]];
      end;
    end;
    changed:=true; Update;
  end;
end;                         { TEdEnWindow.FieldCopy }

procedure TEdEnWindow.FieldErase(var Msg: TMessage);
var
  FieldList: string[MaxField+2];
  i,fld: integer;
begin
  FieldList:='';
  if (Application^.ExecDialog(New(PEraseFieldsDlg,
     Init(@Self,Entry,@FieldList)))=id_ok) and (FieldList<>'') then
  begin
    with Entry^ do
    for i:=1 to length(FieldList) do
    begin
      fld:=Ord(FieldList[i]);
      Content[index[fld]]:='';
      if BigIndex[fld]>0 then
      begin
        BigFree[BigIndex[fld]]:=true;
        Blen[BigIndex[fld]]:=0;
      end;
      index[fld]:=0; BigIndex[fld]:=0;
    end;
    CleanupEntry(Entry);
    Changed:=true; Update;
  end;
end;                                { TEdEnWindow.FieldErase }

{ Copy header submenu }

procedure TEdEnWindow.CopyEName(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,Nil);
end;

procedure TEdEnWindow.CopyENameEx(var Msg: TMessage);
begin
  Application^.ExecDialog(New(PCopyToClipDlg,init(@Self,Entry,0)));
end;

procedure TEdEnWindow.CopyENameStr(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,0,false,false,NameClickMenuString);
end;

procedure TEdEnWindow.CopyEField(var Msg: TMessage);
var
  Ind: integer;
  Extended: boolean;
begin
  if Entry^.nentry=0 then Exit;
  if EditOnlyStrings then
    CopyFieldToClip(@Self,Entry,StringIndex,Extended,false,Nil)
  else if Application^.ExecDialog(New(PCopyFieldDlg,
                    init(@Self,Entry,@Ind,@Extended)))=id_ok then
  begin
    CopyFieldToClip(@Self,Entry,Ind,Extended,false,Nil);
  end;
end;                 { TEdEnWindow.CopyEField }

procedure TEdEnWindow.CopyEFieldEx(var Msg: TMessage);
begin
  CopyFieldToClip(@Self,Entry,StringIndex,true,false,Nil);
end;

procedure TEdEnWindow.EntryCut(var Msg: TMessage);
begin
  if entry^.nentry=0   then ErrorMessageRC(Str_EmptyEntry,'')
  else begin
    CleanupBinList(Entry);
    EntryToClipboard(Entry);
    AlmostZeroEntry;
    changed:=false;
    Update;
  end;
end;                 { TEdEnWindow.EntryCut }

procedure TEdEnWindow.EntryCopy(var Msg: TMessage);
begin
  if entry^.nentry=0 then ErrorMessageRC(Str_EmptyEntry,'')
  else begin
    CleanupBinList(Entry);
    EntryToClipboard(Entry); Update;
  end;
end;

procedure TEdEnWindow.EntryPaste(var Msg: TMessage);
begin
  if ClipboardEmpty    then ErrorMessageRC(Str_EmptyClipboard,'')
  else if ClipboardString and not EditOnlyStrings then
            ErrorMessageRC(Str_ClipboardStr,'')
  else if EditOnlyStrings and not ClipboardString then
            ErrorMessageRC(Str_ClipboardEnt,'')
  else begin
    ClipboardToEntry(Entry);
    changed:=true;
    Update;
  end;
end;              { TEdEnWindow.EntryPaste }

procedure TEdEnWindow.EntryPasteClip(var Msg: TMessage);
var
  err: integer;
begin
  err:=WinClipToEntry(Entry,EditOnlyStrings);
  if      Err=ClipErr_NotEntry  then ErrorMessageRC(Str_ClipboardStr,'')
  else if Err=ClipErr_NotString then ErrorMessageRC(Str_ClipboardEnt,'')
  else if Err=ClipErr_CantRead  then ErrorMessageRC(Str_ClipWrongFormat,'')
  else begin
    changed:=true; Update;
  end;
end;              { TEdEnWindow.EntryPaste }

procedure TEdEnWindow.ClearAll(var Msg: TMessage);
begin
  AlmostZeroEntry; changed:=false; Update;
end;

procedure TEdEnWindow.ViewMode(var Msg: TMessage);
begin
  FirstShowBuf:=not FirstShowBuf; Update;
end;

procedure TEdEnWindow.AbbrevMode(var Msg: TMessage);
begin
  ExpandStrings:=not ExpandStrings;
  ExpandIniAbbrevs:=ExpandStrings; ExpandMacros:=ExpandStrings;
  Update;
end;

procedure TEdEnWindow.ShowFormat(var Msg: TMessage);
begin
  if EdShowFormat=Nil then Application^.MakeWindow(
                      New(PEdShowFormatDlg,init(Nil)))
  else SetFocus(EdShowFormat^.HWindow);
end;

procedure TEdEnWindow.ResHyper(var Msg: TMessage);
begin
  HyperlinkFlags.on:=not HyperlinkFlags.on; Update;
end;

procedure TEdEnWindow.BracesMode(var Msg: TMessage);
begin
  StripExtraBraces:=not StripExtraBraces; Update;
end;

procedure TEdEnWindow.ResObjects(var Msg: TMessage);
begin
  ResolveObjects:=not ResolveObjects; Update;
end;

procedure TEdEnWindow.ResAll(var Msg: TMessage);
begin
  ExpandStrings:=true; ExpandIniAbbrevs:=true; ExpandMacros:=true;
  StripExtraBraces:=true;
  HyperlinkFlags.on:=true; ResolveObjects:=true;
  Update;
end;

procedure TEdEnWindow.ResNone(var Msg: TMessage);
begin
  ExpandStrings:=false; ExpandIniAbbrevs:=false; ExpandMacros:=false;
  StripExtraBraces:=false;
  HyperlinkFlags.on:=false; ResolveObjects:=false;
  Update;
end;

procedure TEdEnWindow.Quit(var Msg: TMessage);
begin
  if not changed then EndDlg(id_Cancel)
  else case AskIf3(StringRC(Str_EntryChangedQuit,''),'&Quit','&Save','Cance&l') of
    1: EndDlg(id_Cancel);
    2: Save(Msg);
  end;
end;

procedure TEdEnWindow.Save(var Msg: TMessage);
var
  ReallyQuit: boolean;
begin
  if Changed then
  begin
    CleanupEntry(Entry);
    if Entry^.name<>'' then EndDlg(id_ok)
    else begin
      ReallyQuit:=false;
      if VerifyAutoName then
      begin
        ReallyQuit:=(Application^.ExecDialog(New(PEntryNameDlg,
          Init(@Self,Entry,true)))=id_ok) and (Entry^.name<>'');
      end else
      begin
        AutoLabel(entry,LabelTemplate^,entry^.name);
        ReallyQuit:=(entry^.name<>'');
      end;
      if ReallyQuit then EndDlg(id_ok);
    end;
    CleanupBinList(Entry);
  end else EndDlg(id_cancel);
end;                              { TEdEnWindow.Save }

procedure TEdEnWindow.EditTheFields(Select: SelStr);
begin
  if Select='' then Exit;
  if Application^.ExecDialog(New(PEditFieldDlg,
             init(@Self,Select,Nil,Nil,OldExpandStrings,
                  OldExpandIniAbbrevs,Entry^.BinList)))>ChangedFlag then
  begin
    changed:=true; Update;
  end;
end;

procedure TEdEnWindow.ok(var Msg: TMessage);
begin end;

procedure TEdEnWindow.cancel(var Msg: TMessage);
begin Quit(Msg); end;

destructor TEdEnWindow.Done;
begin
  UnhookWindowsHookEx(ghKbrdHook);
  FreeProcInstance(KbdHookInst);
  MenuHelp.Done; PopupHelp.Done; AccelKeys.Done;
  if HfloatingHeader<>0 then DestroyMenu(HFloatingHeader);
  if HfloatingField<>0  then DestroyMenu(HFloatingField);
  if EditFieldStr<>Nil  then DisposeStr(EditFieldStr);
  if CopyNameStr<>Nil   then DisposeStr(CopyNameStr);
  if EdObjStr<>Nil      then StrDispose(EdObjStr);
  if EdImageStr<>Nil    then StrDispose(EdImageStr);
  CurrentHelpBar:=OldHelpBar;

  MemExpandStrings      :=ExpandStrings;
  MemExpandIniAbbrevs   :=ExpandIniAbbrevs;
  MemExpandMacros       :=ExpandMacros;
  MemResolveHyper       :=HyperlinkFlags.on;
  MemStripExtraBraces   :=StripExtraBraces;
  MemResolveObjects     :=ResolveObjects;

  ExpandStrings    :=OldExpandStrings;
  ExpandIniAbbrevs :=OldExpandIniAbbrevs;
  ExpandMacros     :=OldExpandMacros;
  HyperlinkFlags.on:=OldResolveHyper;
  StripExtraBraces :=OldStripExtraBraces;
  ResolveObjects   :=OldResolveObjects;

  OleVerbatim:=OldOleVerbatim;
  FirstShowBuf:=OldFirstShowBuf;
  EdEnWindow:=Nil;
  TResizableDialog.Done;
end;                      { TEdEnWindow.Done }

{------------------------------------}


procedure WEditEntry(Entry: EntryRecPtr; WhichField: longint; var Changed: boolean);
begin
  Changed:=false;
  if entry^.nentry=0 then
  begin
    ZeroEntry(Entry); Entry^.name:='';
    if EditOnlyStrings then entry^.EntryType:=TypeEntry^[StringTypeInd]
    else entry^.EntryType:=TypeEntry^[1];
    FieldLast:=DefFieldLast;
  end;
  if Entry^.LastField>DefFieldLast then DefFieldLast:=Entry^.LastField;
  FieldLast:=DefFieldLast;

  if Application^.ExecDialog(New(PEdEnWindow,Init(MainW,Entry,WhichField,true)))=id_ok then
  begin
    Changed:=true; UpdateWindow(HMainW);
  end else entry^.nentry:=0;
end;                { WEditEntry }

end.
