{ Include file for DDE/DDEML related functions }

const
  TopicName    : PChar = 'BIBDB';

  WWWOpenURLName       : PChar = 'WWW_OpenURL';
  WWWBeginProgressName : PChar = 'WWW_BeginProgress';
{  WWWMakingProgressName: PChar = 'WWW_MakingProgress';
  WWWEndProgressName   : PChar = 'WWW_EndProgress'; }

  Stat_failure = 1;  Stat_Linked  = 2;   Stat_ReadOnly = 4;
  Stat_Strings = 8;  Stat_Indexed = 16;  Stat_Sorted   = 32;
  Stat_Pattern = 64; Stat_Exists  = 128; Stat_Unix     = 256;

  DdeSys_Topics   = 1;  DdeSys_SysItems  = 2; DdeSys_RtnMsg   = 3;
  DdeSys_Status   = 4;  DdeSys_Formats   = 5; DdeSys_Help     = 6;
  DdeSys_ItemList = 7;  DdeSys_MacroList = 8; DdeSys_PokeList = 9;

type
  PDDEItemID = ^TDDEItemID;
  TDDEItemID = object(TObject)
    id: integer;
    S: Pstring;
    constructor init(aid: integer; AS: string);
    destructor  done; virtual;
  end;

function DdeError(l: word): string;
var
  S: string;
  id: word;
begin
  S:='DDEML error: '; id:=0;
  case l of
    DMLERR_ADVACKTIMEOUT       : id:=DDERR_ADVACKTIMEOUT;
    DMLERR_BUSY                : id:=DDERR_BUSY;
    DMLERR_DATAACKTIMEOUT      : id:=DDERR_DATAACKTIMEOUT;
    DMLERR_DLL_NOT_INITIALIZED : id:=DDERR_DLL_NOT_INITIALIZED;
    DMLERR_EXECACKTIMEOUT      : id:=DDERR_EXECACKTIMEOUT;
    DMLERR_INVALIDPARAMETER    : id:=DDERR_INVALIDPARAMETER;
    DMLERR_MEMORY_ERROR        : id:=DDERR_MEMORY_ERROR;
    DMLERR_NO_CONV_ESTABLISHED : id:=DDERR_NO_CONV_ESTABLISHED;
    DMLERR_NO_ERROR            : id:=DDERR_NO_ERROR;
    DMLERR_NOTPROCESSED        : id:=DDERR_NOTPROCESSED;
    DMLERR_POKEACKTIMEOUT      : id:=DDERR_POKEACKTIMEOUT;
    DMLERR_POSTMSG_FAILED      : id:=DDERR_POSTMSG_FAILED;
    DMLERR_REENTRANCY          : id:=DDERR_REENTRANCY;
    DMLERR_SERVER_DIED         : id:=DDERR_SERVER_DIED;
    DMLERR_UNADVACKTIMEOUT     : id:=DDERR_UNADVACKTIMEOUT;
  end;
  if id=0 then S:=S+num2str(l)
  else S:=S+StringRC(id,'');
  DdeError:=S;
end;                 { DdeError }

constructor TDDEItemID.Init(aid: integer; AS: string);
begin
  id:=Aid;
  StrLwr(AS);
  S:=NewStr(AS);
end;

destructor TDDEItemID.Done;
begin
  DisposeStr(S);
  TObject.Done;
end;

procedure ParseDdeString(F: PChar; var Body, Arg: string);
var
  i: integer;
  Bracket: boolean;
begin
  Body:=''; Arg:='';
  i:=0;
  while (i<StrLen(F)) and (F[i]<>'(') do
  begin
    Body:=Body+F[i]; inc(i);
  end;
  ChrDelL(Body,' '); ChrDelR(Body,' ');
  Bracket:=false;
  if (length(Body)>1) and (Body[1]='[') then
  begin
    Delete(Body,1,1); ChrDelL(Body,' ');
    Bracket:=true;
  end;
  StrLwr(Body);
  if i<StrLen(F) then
  begin
    inc(i);
    while i<StrLen(F) do
    begin
      Arg:=Arg+F[i]; inc(i);
    end;
    ChrDelL(Arg,' '); ChrDelR(Arg,' ');
    if (Arg<>'') and bracket and (Arg[length(arg)]=']') then
       Delete(Arg,length(Arg),1);
    ChrDelR(Arg,' ');
    if (Arg<>'') and (Arg[length(Arg)]=')') then Delete(Arg,length(Arg),1);
    ChrDelR(Arg,' ');
  end;
end;                     { ParseDdeString }

{ Local Function: CallBack Procedure for DDEML }

function CallbackProc(CallType, Fmt: Word; Conv: HConv; HSz1, HSz2: HSZ;
  Data: HDDEData; Data1, Data2: Longint): HDDEData; export;
var
  ThisWindow: PBrowseWindow;  
begin
  CallbackProc := 0;    { See if proved otherwise }
  InputStr^:=''; OutputStr^:=''; CommandStr^:='';

  ThisWindow := PBrowseWindow(MainW);

  case CallType of
    xtyp_WildConnect:
      CallbackProc := ThisWindow^.WildConnect(HSz1, HSz2, Fmt);

    xtyp_Connect:
      if (DialogDepth=0) and (Conv = 0) then
      begin
        if ThisWindow^.MatchTopicAndService(HSz1, HSz2) then CallbackProc := 1;
      end;
{ When a connection is confirmed, record the conversation handle as the
  window's own.
}
    xtyp_Connect_Confirm:
      if ThisWindow^.MatchTopic(Hsz1) then
      begin
        ThisWindow^.ConvHdl := Conv;
        DdeIsActive := true;
      end;

    xtyp_Disconnect:
      begin
        DdeIsActive := false;
        ThisWindow^.ConvHdl := 0; Conv:=0;
      end;

    xtyp_request:
      if ThisWindow^.MatchTopic(Hsz1) then
        CallbackProc:=ThisWindow^.RequestData(Hsz2)
      else if ThisWindow^.MatchSystem(Hsz1) then
        CallbackProc:=ThisWindow^.RequestSysData(Hsz2)
      else if ThisWindow^.MatchWWWVerb(Hsz1) then
        CallbackProc:=ThisWindow^.WWWVerb(Hsz1,Hsz2);

    xtyp_execute:
      if ThisWindow^.MatchTopic(Hsz1) then
        CallbackProc:=ThisWindow^.ExecMacro(Data);

    xtyp_poke:
      if ThisWindow^.MatchTopic(Hsz1) then
        CallbackProc:=ThisWindow^.PokeData(Hsz2,Data)
      else if ThisWindow^.MatchWWWVerb(Hsz1) then
        CallbackProc:=ThisWindow^.WWWVerb(Hsz1,Hsz2);

  end;
end;                           { DDEML Callback function }

function EnumWinCallback(H: HWnd; lParam: longint): bool; export;
var
  F: array[0..255] of char;
  i: longint;
begin
  GetClassName(H,F,255);
  if StrComp(F,BibDBMainWinClass)=0 then   { Its a previous instance }
  begin
    i:=SendMessage(H,bib_GetInstNumber,0,0);
    if i>=InstNumber then InstNumber:=i+1;
  end;
  EnumWinCallback:=true;
end;             { EnumWinCallback }

procedure TBrowseWindow.InitDDE;
var
  i: integer;
  F: array[0..64] of char;
  proc: TFarProc;
  Num: string[10];

procedure InsItem(var T: Tcollection; id: integer);
var
  F: array[0..64] of char;
begin
  LoadString(HInstance,id,@F,63);
  T.Insert(New(PDDEItemID,Init(id,StrPas(F))));
end;

begin
  Inst      := 0;      { Must be zero for first call to DdeInitialize }
  @CallBack := nil;    { MakeProcInstance is called in SetupWindow    }
  ServiceHsz:=0; TopicHsz:=0; SystemHsz:=0; BeginProgressHsz:=0;
{  OpenURLHsz:=0; EndProgressHsz:=0; MakingProgressHsz:=0; }

  { Service name, different for each instance }
  Proc:=MakeProcInstance(@EnumWinCallback,hInstance);
  EnumWindows(Proc,0);
  FreeProcInstance(Proc);
  if InstNumber=0 then Num:=''
  else Num:=Num2str(InstNumber);
  StrPCopy(F,'BIBDB'+Num); 
  ServiceName:=StrNew(F);
{  message(StrPas(ServiceName));}

  DdeItems.init(26,10);
  InsItem(DdeItems,DdeItem_Status);        InsItem(DdeItems,DdeItem_EntryName);
  InsItem(DdeItems,DdeItem_EntryType);     InsItem(DdeItems,DdeItem_EntryNum);
  InsItem(DdeItems,DdeItem_EntryNumAbs);   InsItem(DdeItems,DdeItem_EntryFields);
  InsItem(DdeItems,DdeItem_Field);         InsItem(DdeItems,DdeItem_Template);
  InsItem(DdeItems,DdeItem_FieldList);     InsItem(DdeItems,DdeItem_TypeList);
  InsItem(DdeItems,DdeItem_File);          InsItem(DdeItems,DdeItem_FileList);
  InsItem(DdeItems,DdeItem_FileNum);       InsItem(DdeItems,DdeItem_Count);
  InsItem(DdeItems,DdeItem_LabelTemplate); InsItem(DdeItems,DdeItem_Pattern);
  InsItem(DdeItems,DdeItem_SortMode);      InsItem(DdeItems,DdeItem_Register);
  InsItem(DdeItems,DdeItem_ExportFile);    InsItem(DdeItems,DdeItem_ExportFormat);
  InsItem(DdeItems,DdeItem_ImportFormat);  InsItem(DdeItems,DdeItem_ExportFields);
  InsItem(DdeItems,DdeItem_FileEncoding);  InsItem(DdeItems,DdeItem_DisplayEncoding);
  InsItem(DdeItems,DdeItem_Encodings);     InsItem(DdeItems,DdeItem_Abbreviations);

  DdePokes.init(10,10);
  InsItem(DdePokes,DdePoke_Name);    InsItem(DdePokes,DdePoke_Type);
  InsItem(DdePokes,DdePoke_Field);   InsItem(DdePokes,DdePoke_String);
  InsItem(DdePokes,DdePoke_Pattern); InsItem(DdePokes,DdePoke_SortMode);
  InsItem(DdePokes,DdePoke_Register);

  DdeMacros.Init(60,10);
  InsItem(DdeMacros,DdeMacro_Activate);      InsItem(DdeMacros,DdeMacro_Minimize);
  InsItem(DdeMacros,DdeMacro_Maximize);      InsItem(DdeMacros,DdeMacro_Restore);
  InsItem(DdeMacros,DdeMacro_GotoNext);      InsItem(DdeMacros,DdeMacro_GotoBack);
  InsItem(DdeMacros,DdeMacro_GotoFirst);     InsItem(DdeMacros,DdeMacro_GotoLast);
  InsItem(DdeMacros,DdeMacro_GotoNumber);    InsItem(DdeMacros,DdeMacro_GotoLabel);
  InsItem(DdeMacros,DdeMacro_GotoSearch);    InsItem(DdeMacros,DdeMacro_GotoBookmark);
  InsItem(DdeMacros,DdeMacro_GotoNextTag);   InsItem(DdeMacros,DdeMacro_SetPattern);
  InsItem(DdeMacros,DdeMacro_Link);          InsItem(DdeMacros,DdeMacro_Strings);
  InsItem(DdeMacros,DdeMacro_ReadOnly);	     InsItem(DdeMacros,DdeMacro_Tag);
  InsItem(DdeMacros,DdeMacro_TagAll);        InsItem(DdeMacros,DdeMacro_TagFromTex);
  InsItem(DdeMacros,DdeMacro_SetBookmark);   InsItem(DdeMacros,DdeMacro_SelectFile);
  InsItem(DdeMacros,DdeMacro_OpenFile);      InsItem(DdeMacros,DdeMacro_LoadFile);
  InsItem(DdeMacros,DdeMacro_UnloadFile);    InsItem(DdeMacros,DdeMacro_EraseField);
  InsItem(DdeMacros,DdeMacro_RemoveField);   InsItem(DdeMacros,DdeMacro_ModifyEntry);
  InsItem(DdeMacros,DdeMacro_CopyEntry);     InsItem(DdeMacros,DdeMacro_CutEntry);
  InsItem(DdeMacros,DdeMacro_PasteEntry);    InsItem(DdeMacros,DdeMacro_ReplaceEntry);
  InsItem(DdeMacros,DdeMacro_DeleteEntry);   InsItem(DdeMacros,DdeMacro_DelAllEntries);
  InsItem(DdeMacros,DdeMacro_NewEntry);      InsItem(DdeMacros,DdeMacro_LabelTemplate);
  InsItem(DdeMacros,DdeMacro_DelTagEntries); InsItem(DdeMacros,DdeMacro_AddEntry);
  InsItem(DdeMacros,DdeMacro_Capitalization);InsItem(DdeMacros,DdeMacro_UseIndexFiles);
  InsItem(DdeMacros,DdeMacro_WrapEOF2BOF);   InsItem(DdeMacros,DdeMacro_RetainNulls);
  InsItem(DdeMacros,DdeMacro_SortNewFiles);  InsItem(DdeMacros,DdeMacro_SortedByDefault);
  InsItem(DdeMacros,DdeMacro_AddSort2New);   InsItem(DdeMacros,DdeMacro_AlwaysRead);
  InsItem(DdeMacros,DdeMacro_CheckDup);      InsItem(DdeMacros,DdeMacro_LabelMode);
  InsItem(DdeMacros,DdeMacro_FileFormatOpt); InsItem(DdeMacros,DdeMacro_ImportFormat);
  InsItem(DdeMacros,DdeMacro_ExportFormat);  InsItem(DdeMacros,DdeMacro_ExportFields);
  InsItem(DdeMacros,DdeMacro_ClearExportFile);InsItem(DdeMacros,DdeMacro_ExportFile);
  InsItem(DdeMacros,DdeMacro_Import);        InsItem(DdeMacros,DdeMacro_Export);
  InsItem(DdeMacros,DdeMacro_FileEncoding);  InsItem(DdeMacros,DdeMacro_DisplayEncoding);
  InsItem(DdeMacros,DdeMacro_ExpandStrings); InsItem(DdeMacros,DdeMacro_ExpandAbbrevs);

  DdeSysItems.Init(10,10);
  with DdeSysItems do
  begin
    Insert(New(PDDEItemID,init(DdeSys_Topics,   szddesys_Item_Topics)));
    Insert(New(PDDEItemID,init(DdeSys_SysItems, szddesys_Item_SysItems)));
    Insert(New(PDDEItemID,init(DdeSys_Status,   szddesys_Item_Status)));
    Insert(New(PDDEItemID,init(DdeSys_Formats,  szddesys_Item_Formats)));
    Insert(New(PDDEItemID,init(DdeSys_Help,     szddesys_Item_Help)));
    Insert(New(PDDEItemID,init(DdeSys_ItemList, szdde_Item_ItemList)));
    Insert(New(PDDEItemID,init(DdeSys_MacroList,'TopicMacroList')));
    Insert(New(PDDEItemID,init(DdeSys_PokeList, 'TopicPokeList')));
  end;
  MacroCommand:=false;
end;                                   { TBrowseWindow.InitDDE }

procedure TBrowseWindow.SetupDDE;
var
  o_k: boolean;
begin
  DDEEnabled:=false;
  if EnhancedMode then       { Enable DDE }
  begin
    @CallBack:= MakeProcInstance(@CallBackProc, HInstance);
    o_k:=DdeInitialize(Inst, CallBack, AppClass_Standard or CBF_Fail_Advises
                or CBF_FAIL_SELFCONNECTIONS, 0)<>dmlErr_No_Error;
    if not o_k then
    begin
      ServiceHsz:=0; TopicHsz:=0; SystemHsz:=0; BeginProgressHsz:=0;
{      OpenURLHsz:=0; EndProgressHsz:=0; MakingProgressHsz:=0;}
      ServiceHSz:= DdeCreateStringHandle(Inst, ServiceName, cp_WinAnsi);

      if DdeNameService(Inst, ServiceHSz, 0, dns_Register) = 0 then
      begin
        MessageBox(HWindow,'DDE error', Application^.Name,mb_IconExclamation);
        if ServiceHsz<>0 then DdeFreeStringHandle(Inst, ServiceHsz);
        DdeUninitialize(Inst);
      end else
      begin
        TopicHSz  := DdeCreateStringHandle(Inst, TopicName,      cp_WinAnsi);
        SystemHSz := DdeCreateStringHandle(Inst, SzddeSys_Topic, cp_WinAnsi);
        BeginProgressHSz := DdeCreateStringHandle(Inst,
                                     WWWBeginProgressName,cp_WinAnsi);
        {
        OpenURLHSz:= DdeCreateStringHandle(Inst, URLResultName,  cp_WinAnsi);
        MakingProgressHSz:= DdeCreateStringHandle(Inst,
                                     WWWMakingProgressName,  cp_WinAnsi);
        EndProgressHSz   := DdeCreateStringHandle(Inst,
                                     WWWEndProgressName,  cp_WinAnsi);
        }
        DdeEnabled:=true;
      end;
    end;
  end;
end;                              { TBrowseWindow.SetupDDE }

function TBrowseWindow.Connect(Service,Topic: PChar;
            var ServHsz, TopHsz: Hsz; var ConverHdl: HConv): boolean;
begin
  connect:=false;
  ServHsz:=0; TopHsz:=0; ConverHdl := 0;
  ServHSz:= DdeCreateStringHandle(Inst, Service, cp_WinAnsi);
  TopHSz := DdeCreateStringHandle(Inst, Topic,   cp_WinAnsi);

  if (ServHSz <> 0) and (TopHSz <> 0) then
  begin
    ConverHdl := DdeConnect(Inst, ServHSz, TopHSz, nil);
    if ConverHdl <> 0 then connect:=true;
  end;
end;                        { TBrowseWindow.Connect }

procedure TBrowseWindow.Disconnect(var ServHsz, TopHsz: Hsz;
          var ConverHdl: HConv);
begin
  if ServHSz   <> 0 then DdeFreeStringHandle(Inst, ServHSz);
  if TopHSz    <> 0 then DdeFreeStringHandle(Inst, TopHSz);
  if ConverHdl <> 0 then DdeDisconnect(ConverHdl);
  ServHsz:=0; TopHsz:=0; ConverHdl:=0;
end;                       { TBrowseWindow.Disconnect }

function TBrowseWindow.MatchTopicAndService(Topic, Service: HSz): Boolean;
begin
  MatchTopicAndService:=(DdeCmpStringHandles(ServiceHSz,  Service) = 0) and
    (MatchTopic(Topic) or MatchSystem(Topic) or MatchWWWVerb(Topic));
end;                   { TBrowseWindow.MatchTopicAndService }

function TBrowseWindow.MatchTopic(Topic: HSz): Boolean;
begin
  MatchTopic := DdeCmpStringHandles(TopicHSz, Topic) = 0;
end;

function TBrowseWindow.MatchSystem(Topic: HSz): Boolean;
begin
  MatchSystem := DdeCmpStringHandles(SystemHSz, Topic) = 0;
end;

function TBrowseWindow.MatchWWWVerb(Topic: Hsz): boolean;
begin
{  message(num2str(DdeCmpStringHandles(BeginProgressHsz,Topic)));}
  MatchWWWVerb:=(DdeCmpStringHandles(BeginProgressHsz, Topic) = 0){ or
                (DdeCmpStringHandles(MakingProgressHsz,Topic) = 0) or
                (DdeCmpStringHandles(EndProgressHsz,   Topic) = 0) or
                (DdeCmpStringHandles(OpenURLHsz,       Topic) = 0)};
end;

{ Responds to wildcard connect requests.  These requests are generated
  whenever a client tries to connect to a server with either service or topic
  name set to 0.  If a server detects a wild card match, it returns a
  handle to an array of THSZPair's containing the matching supported Service
  and Topic.
}
function TBrowseWindow.WildConnect(Topic, Service: HSz;
  ClipFmt: Word): HDDEData;
var
  TempPairs: array [0..1] of THSZPair;
  Matched  : Boolean;
begin
  TempPairs[0].hszSvc  := ServiceHSz;
  TempPairs[0].hszTopic:= TopicHSz;
  TempPairs[1].hszSvc  := 0;     { 0-terminate the list }
  TempPairs[1].hszTopic:= 0;

  Matched := False;

  if (Topic= 0) and (Service = 0) then
    Matched := True                    { Complete wildcard }
  else
    if (Topic = 0) and (DdeCmpStringHandles(Service, ServiceHSz) = 0) then
      Matched := True
    else
      if (Service=0) and
        ((DdeCmpStringHandles(Topic, TopicHSz)  = 0) or
         (DdeCmpStringHandles(Topic, SystemHSz) = 0) or
         (DdeCmpStringHandles(Topic, BeginProgressHSz) = 0){ or
         (DdeCmpStringHandles(Topic, MakingProgressHSz)= 0) or
         (DdeCmpStringHandles(Topic, EndProgressHSz)   = 0) or
         (DdeCmpStringHandles(Topic, OpenURLHSz)       = 0)}
         ) then  Matched := True;

  if Matched then
    WildConnect := DdeCreateDataHandle(Inst, @TempPairs, SizeOf(TempPairs),
      0, 0, ClipFmt, 0)
  else
    WildConnect := 0;
end;                           { TBrowseWindow.WildConnect }

function TBrowseWindow.FindDDEItem(var T: TCollection; ItemReq: string): integer;
var
  P: PDDEItemID;

function Matches(P: pointer): boolean; far;
begin
  Matches:=ItemReq=PDDEItemID(P)^.S^;
end;

begin
  StrLwr(ItemReq);
  FindDDEItem:=0; P:=Nil;
  P:=T.FirstThat(@Matches);
  if P<>Nil then FindDDEItem:=P^.id;
end;

function TBrowseWindow.RequestSysData(ItemHsz: Hsz): HDDEData;
var
  Retrn: HDDEData;
  F: PChar;
  ItemReq,tmp: string[64];
  item,i,j,l,Ind,lnum: integer;

procedure ReturnAllItems(var T: TCollection);
var
  llen,ind: word;
  F: PChar;

procedure MeasureItem(P: Pointer); far;
begin
  llen:=llen+length(PDDEItemID(P)^.S^)+1;
end;

procedure AddItem(P: Pointer); far;
var
  j: integer;
begin
  for j:=1 to length(PDDEItemID(P)^.S^) do
  begin
    F[Ind]:=PDDEItemID(P)^.S^[j]; inc(Ind);
  end;
  F[Ind]:=#9; inc(Ind);
end;                   { AddItem }

begin                  { ReturnAllItems }
  F:=Nil; llen:=0; ind:=0;
  T.ForEach(@MeasureItem);
  GetMem(F,llen+1);
  T.ForEach(@AddItem);
  F[ind-1]:=#0;
  Retrn:=DdeCreateDataHandle(Inst,F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
  FreeMem(F,l+1);
end;                  { ReturnAllItems }

procedure Res(S: string);
var
  F: array[0..255] of char;
begin
  StrPCopy(F,S);
  Retrn:=DdeCreateDataHandle(Inst,@F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
end;

begin                            { RequestSysData }
  RequestSysData:=0;
  GetMem(F,256);
  DDEQueryString(Inst,ItemHsz,F,255,cp_WinAnsi);
  Item:=FindDDEItem(DdeSysItems,StrPas(F));
  FreeMem(F,256);
  if item=0 then Exit;

  Retrn:=0;
  case item of
    DdeSys_Formats  : Res(StringRC(DDeSys_FormatsStr,''));
    DdeSys_Topics   : Res(StringRC(DDeSys_TopicsStr,''));
    DdeSys_Help     : Res(StringRC(DDeSys_HelpStr,''));
    DdeSys_Status   : if MacroCommand then Res('Busy') else Res('Ready');
    DdeSys_ItemList : ReturnAllItems(DdeItems);
    DdeSys_MacroList: ReturnAllItems(DdeMacros);
    DdeSys_PokeList : ReturnAllItems(DdePokes);
    DdeSys_SysItems : ReturnAllItems(DdeSysItems);
  end;
  RequestSysData:=Retrn;
end;                             { RequestSysData }

function TBrowseWindow.RequestData(ItemHsz: Hsz): HDDEData;
var
  Retrn: HDDEData;
  Msg: TMessage;
  i,j,Ind,l,num,item,icode: integer;
  F: PChar;
  Lst: ListArrPtr;
  Flg,SpecFlg,WordResult: word;
  FileIsSorted,SendAsNumber,ForceOn,DumpAll: boolean;
  LongResult,llen,llen2: longint;
  tmp: string;
  NulStream: PNulStream;
  RamStream: PRamStream;
  ch: char;
  SortMode: ConfigSortPtr;
  SortPattern: PatRecPtr;
{  Dir,Name,Ext: PString;}
  PSize,FreeSize: word;

procedure Res(S: string);
var
  F: array[0..255] of char;
begin
  StrPCopy(F,S);
  Retrn:=DdeCreateDataHandle(Inst,@F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
end;

begin
  RequestData:=0; NulStream:=Nil; RamStream:=Nil; F:=Nil; Lst:=Nil;
  SortPattern:=Nil; SortMode:=Nil;

  GetMem(F,256);
  DDEQueryString(Inst,ItemHsz,F,255,cp_WinAnsi);
  ParseDdeString(F,CommandStr^,InputStr^);
{  Item:=FindDDEItem(DdeItems,StrPas(F));}
  Item:=FindDDEItem(DdeItems,CommandStr^);
  FreeMem(F,256);
  if item=0 then Exit;

  Retrn:=0;
  MacroCommand:=true;
  FillChar(Msg, sizeof(Msg),0);
  case item of
    Ddeitem_EntryName    : if entry^.nentry>0 then Res(Entry^.name);
    Ddeitem_EntryType    : if entry^.nentry>0 then Res(Entry^.EntryType);
    Ddeitem_EntryNum     : if entry^.nentry>0 then Res(num2str(Entry^.entrynum));
    Ddeitem_EntryNumAbs  : if entry^.nentry>0 then Res(num2str(Entry^.realnum));
    DdeItem_File:
      begin
        i:=CurrentBibFile;
        if InputStr^<>'' then
        begin
          i:=0;
          Val(InputStr^,i,icode);
          if icode<>0 then i:=0;
        end;
        if (i>0) and (i<=MaxBibFiles) then Res(BibFiles^[i].name);
      end;
    DdeItem_FileList:
      begin
        l:=0;
        for i:=1 to MaxBibFiles do l:=l+length(BibFiles^[i].name)+1;
        GetMem(F,l+1);
        ind:=0;
        for i:=1 to MaxBibFiles do
        begin
          for j:=1 to length(BibFiles^[i].name) do
          begin
            F[Ind]:=BibFiles^[i].name[j]; inc(Ind);
          end;
          if i<MaxBibFiles then
          begin
            F[Ind]:=#9; inc(Ind);
          end;
          F[Ind]:=#0;
        end;
        Retrn:=DdeCreateDataHandle(Inst,F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
        FreeMem(F,l+1);
      end;
    DdeItem_FileNum:
      begin
        StrLwr(InputStr^);
        if InputStr^='number' then
        begin
          WordResult:=CurrentBibFile;
          Retrn:=DdeCreateDataHandle(Inst,@WordResult,sizeof(WordResult),0,
                   ItemHsz,cf_Text,0);
        end else  Res(num2str(CurrentBibFile));
      end;
    DdeItem_Count:
      begin
        Count(Msg);
        StrLwr(InputStr^);
        if InputStr^='number' then
        begin
          Val(OutputStr^,WordResult,icode);
          if icode=0 then
          begin
            LongResult:=WordResult;
            Retrn:=DdeCreateDataHandle(Inst,@LongResult,sizeof(LongResult),0,
                   ItemHsz,cf_Text,0);
          end;
        end else Res(OutputStr^);
      end;
    DdeItem_EntryFields:
      if entry^.nentry>0 then with Entry^ do
      begin
        l:=0;
        for i:=1 to nentry do l:=l+length(field[i])+1;
        GetMem(F,l+1);
        ind:=0;
        for i:=1 to nentry do
        begin
          for j:=1 to length(field[i]) do
          begin
            F[Ind]:=Field[i][j]; inc(Ind);
          end;
          if i<nentry then
          begin
            F[Ind]:=#9; inc(Ind);
          end;
          F[Ind]:=#0;
        end;
        Retrn:=DdeCreateDataHandle(Inst,F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
        FreeMem(F,l+1);
      end;
    DdeItem_Field:
      if entry^.nentry>0 then with entry^ do
      begin
        Ind:=FindInFieldList(InputStr^);
        if (Ind>0) and (Index[Ind]>0) and (content[index[Ind]]<>'')
           and (content[index[Ind]]<>#0) then
        begin
          if ExpandMacros and (content[index[ind]][1]='@') then
          begin
            F:=Nil;
            if BigIndex[ind]=0 then
              DecodeAbbrevs(content[index[ind]][2],length(content[index[ind]])-1,
                      F,PSize,FreeSize)
            else
              DecodeAbbrevs(Big[BigIndex[ind]]^[2],Blen[BigIndex[ind]]-1,
                      F,PSize,FreeSize);
            if F<>Nil then
            begin
              Retrn:=DdeCreateDataHandle(Inst,F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
              FreeMem(F,FreeSize);
            end;
          end else if BigIndex[Ind]=0 then
          begin
            GetMem(F,Length(content[Index[Ind]])+1);
            StrPCopy(F,content[Index[Ind]]);
            Retrn:=DdeCreateDataHandle(Inst,F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
            FreeMem(F,length(content[Index[Ind]]));
          end else
          begin
            Big[BigIndex[Ind]]^[Blen[BigIndex[Ind]]+1]:=#0;
            Retrn:=DdeCreateDataHandle(Inst,Big[BigIndex[Ind]],
                  Blen[BigIndex[Ind]]+1,0,ItemHsz,cf_Text,0);
          end;
        end else Res('');
      end;
    DdeItem_Template:
      begin
        PrepareTemplate(InputStr^);
        if InputStr^<>'' then
        begin
          FillTemplate(entry,OutputStr^,InputStr^,
                       VerbatimFormat,true,true);
          Res(OutputStr^);
        end;
      end;
    DdeItem_FieldList, DdeItem_TypeList:
      begin
        if item=DdeItem_FieldList then
        begin
          lst:=TypeField; num:=FieldLast;
        end else
        begin
          Lst:=TypeEntry; num:=NumberOfTypes;
        end;
        l:=0;
        for i:=1 to num do l:=l+length(lst^[i])+1;
        GetMem(F,l+1);
        ind:=0;
        for i:=1 to num do
        begin
          for j:=1 to length(lst^[i]) do
          begin
            F[Ind]:=lst^[i][j]; inc(Ind);
          end;
          if i<num then
          begin
            F[Ind]:=#9; inc(Ind);
          end;
          F[Ind]:=#0;
        end;
        Retrn:=DdeCreateDataHandle(Inst,F,StrLen(F)+1,0,ItemHsz,cf_Text,0);
        FreeMem(F,l+1);
      end;
    DdeItem_Status:
      begin
        Flg:=0;
        if failure         then Flg:=Flg or Stat_Failure;
        if EditOnlyStrings then Flg:=Flg or Stat_Strings;
        if BibFileExists   then Flg:=Flg or Stat_Exists;
        if BibReadOnly     then Flg:=Flg or Stat_ReadOnly;
        if Linked          then Flg:=Flg or Stat_Linked;
        if UnixBib         then Flg:=Flg or Stat_Unix;
        if Pattern^.on     then Flg:=Flg or Stat_Pattern;
        if MakeUseOfIndex(Pattern) then Flg:=Flg or Stat_Indexed;
        if EditOnlyStrings then
          FileIsSorted:=(CurrentSortMode^.StringNameSort<>StrSortOff)
        else FileIsSorted:=CurrentSortMode^.SortingOn;
        if Linked then FileIsSorted:=false;
        if FileIsSorted    then Flg:=Flg or Stat_Sorted;
        icode:=0; SendAsNumber:=false;
        if InputStr^<>'' then
        begin
          StrLwr(InputStr^);
          if copy(InputStr^,1,6)='number' then
          begin
            SendAsNumber:=true;
            Delete(InputStr^,1,7); ChrDelL(InputStr^,' ');
          end;
          if InputStr^<>'' then
          begin
            Val(InputStr^,SpecFlg,icode); Flg:=Flg AND SpecFlg;
          end;
        end;
        if icode=0 then
        begin
          if SendAsNumber then
            Retrn:=DdeCreateDataHandle(Inst,@Flg,sizeof(Word),0,ItemHsz,cf_Text,0)
          else Res(num2str(Flg));
        end;
      end;
    DdeItem_LabelTemplate:
      begin
        DecompTemplate(tmp,LabelTemplate^);
        Res(tmp);
      end;
    DdeItem_Pattern:
      if (not Pattern^.on) or (Pattern^.noper=0) then Res('')
      else begin
        New(NulStream,Init(0)); NulStream^.Seek(0);
        OutputPattern(Pattern,78,false,0,0,0,0,llen,NulStream,'','',false,true);
        llen:=NulStream^.GetSize;
        Dispose(NulStream,Done); NulStream:=Nil;
        if llen<$FFFF-11 then
        begin
          New(RamStream,Init(llen+10));
          if (RamStream<>Nil) and (RamStream^.Status=stOK) then
          begin
            RamStream^.seek(0);
            OutputPattern(Pattern,78,false,0,0,0,0,llen2,RamStream,'','',false,true);
            ch:=#0; RamStream^.write(ch,1);
            Retrn:=DdeCreateDataHandle(Inst,RamStream^.buffer,
                          RamStream^.GetSize,0,ItemHsz,cf_Text,0);
          end;
          if RamStream<>Nil then Dispose(RamStream,Done); RamStream:=Nil;
        end;
      end;
    DdeItem_SortMode:
      begin
        StrLwr(InputStr^);
        SortMode:=Nil;
        New(SortPattern);
        ForceOn:=false;
        if (InputStr^='') or (InputStr^='current') then
        begin
          SortMode:= CurrentSortMode;
          RecallBufferStack(SortPattern^,SortPattPosCur);
        end else if InputStr^='default' then
        begin
          SortMode:= ConfigSortMode;
          RecallBufferStack(SortPattern^,SortPattPosDef);
          ForceOn:=true;
        end else if InputStr^='export' then
        begin
          SortMode:= ExportSortMode;
          RecallBufferStack(SortPattern^,SortPattPosExp);
        end;
        if SortMode<>Nil then
        begin
          New(NulStream,Init(0)); NulStream^.Seek(0);
          WriteSortMode(NulStream,SortMode^,SortPattern,ForceOn,false);
          llen:=NulStream^.GetSize;
          Dispose(NulStream,Done); NulStream:=Nil;
          if llen<$FFFF-11 then
          begin
            RamStream:=Nil;
            New(RamStream,Init(llen+10));
            if (RamStream<>Nil) and (RamStream^.Status=stOK) then
            begin
              RamStream^.seek(0);
              WriteSortMode(RamStream,SortMode^,SortPattern,ForceOn,false);
              ch:=#0; RamStream^.write(ch,1);
              Retrn:=DdeCreateDataHandle(Inst,RamStream^.buffer,
                          RamStream^.GetSize,0,ItemHsz,cf_Text,0);
            end;
            if RamStream<>Nil then Dispose(RamStream,Done); RamStream:=Nil;
          end;
        end;
        Dispose(SortPattern);
      end;
    DdeItem_Register:
      if (length(InputStr^)=1) and
         (InputStr^[1] in ['A'..'Z','a'..'z','0'..'9']) then
      begin
        ch:=UpCase(InputStr^[1]);
        if ch in ['A'..'Z'] then i:=Ord(ch)-Ord('A')
        else if ch in ['0'..'9'] then i:=Ord(ch)-Ord('0')+26;
        RecallBufferStack(tmp[0],MemoryPos+i);
        Res(tmp);
      end;
    DdeItem_ImportFormat,DdeItem_ExportFormat:
      begin
        StrLwr(InputStr^); tmp:='';
        if (InputStr^='*') or (InputStr^='all') then
        begin
          tmp:='BibTeX'#9'Comma'#9'Tib'#9'Refer';
          if Item=DdeItem_ExportFormat then
          for i:=1 to NumUserFormats do
            tmp:=tmp+#9+UserFormatName[FirstUserFormat+i-1]^;
        end else
        begin
          i:=ImportFormat; if Item=DdeItem_ExportFormat then i:=ExportFormat;
          if i=BibTeXFormat then tmp:='BibTeX'
          else if i=CommaDelimited then tmp:='Comma'
          else if i=TibFormat then tmp:='Tib'
          else if i=ReferFormat then tmp:='Refer'
          else tmp:=UserFormatName[i]^;
        end;
        Res(tmp);
      end;
    DdeItem_ExportFile:
      begin
        Res(DumpName^);
      end;
    DdeItem_ExportFields:
      begin
        l:=-1; DumpAll:=DumpUndecFields;
        for i:=1 to OrigFieldLast do
          if DumpFields[i] then l:=l+1+length(TypeField^[i])
          else DumpAll:=false;
        if DumpAll then Res(PattStr_All)
        else begin
          if DumpUndecFields then l:=l+12;
          GetMem(F,l+2); FillChar(F^,l+2,#0); j:=0;
          for i:=1 to OrigFieldLast do
            if DumpFields[i] then
            begin
              tmp:=TypeField^[i]; if j>0 then tmp:='+'+tmp;
              Move(tmp[1],F[j],length(tmp)); j:=j+length(tmp);
            end;
          if DumpUndecFields then
          begin
            tmp:=PattStr_Undec; if j>0 then tmp:='+'+tmp;
            Move(tmp[1],F[j],length(tmp)); j:=j+length(tmp);
          end;
          Retrn:=DdeCreateDataHandle(Inst,F,l+1,0,ItemHsz,cf_Text,0);
          FreeMem(F,l+2);
        end;
      end;
    DdeItem_DisplayEncoding:
      begin
        if Prog8bit then tmp:='8 bit'
        else if Prog7bit then tmp:='7-bit TeX codes'
        else tmp:='none';
        Res(tmp+', '+PEncoding(EncodingsList.at(DispEncoding))^.Name^);
      end;
    DdeItem_FileEncoding:
      begin
        if File8bit then tmp:='8 bit'
        else if File7bit then tmp:='7-bit TeX codes'
        else tmp:='none';
        Res(tmp+', '+PEncoding(EncodingsList.at(FReadEncoding))^.Name^);
      end;
    DdeItem_Encodings:
      begin
        l:=0;
        with EncodingsList do
        for i:=0 to Count-1 do
          l:=l+length(PEncoding(at(i))^.Name^)+1;
        if l=0 then Res('')
        else begin
          GetMem(F,l+2); FillChar(F^,l+2,#0); j:=0;
          with EncodingsList do
          for i:=0 to Count-1 do
          begin
            if i>0 then
            begin
              F[j]:=#9; inc(j);
            end;
            tmp:=PEncoding(at(i))^.Name^;
            move(tmp[1],F[j],length(tmp));
            j:=j+length(tmp);
          end;
          F[j]:=#0;
          Retrn:=DdeCreateDataHandle(Inst,F,l,0,ItemHsz,cf_Text,0);
          FreeMem(F,l+2);
        end;
      end;
    DdeItem_Abbreviations:
      begin
        l:=length(BibAbbrevsFile^)+length(BstAbbrevsFile^)+20;
        GetMem(F,l+2);
        tmp:='off'; if ExpandStrings then tmp:='on';
        if ExpandIniAbbrevs then tmp:=tmp+',on,' else tmp:=tmp+',off,';
        StrPCopy(F,tmp);
        i:=StrLen(F); StrPCopy(F+i,'"'+BstAbbrevsFile^+'",');
        i:=StrLen(F); StrPCopy(F+i,'"'+BibAbbrevsFile^+'"');
        Retrn:=DdeCreateDataHandle(Inst,F,l,0,ItemHsz,cf_Text,0);
        FreeMem(F,l+2);
      end;
  end;
  RequestData:=Retrn;
  MacroCommand:=false;
end;                           { TBrowseWindow.ReturnData }

function TBrowseWindow.PokeData(ItemHsz: Hsz; Data: HDDEData): HDDEData;
var
  Retrn: HDDEData;
  F: PChar;
  item,i,j,WhichSort: integer;
  DataLen: longint;
  S: string;
  IsError,Compress,Balance: boolean;
  Patt: PatRecPtr;
  SortMode: ConfigSortPtr;
  RamStream: PRamStream;
  DummyFile: text;
  ch: char;

procedure KeepSortInfo;
var
  SortPattern: PatRecPtr;
begin
  if EntryModified then Exit;
  SortPattern:=Nil;
  if CurrentSortMode^.SortingOn and (not EditOnlyStrings) then
  begin
    if CurrentSortMode^.SortPatternExists then
    begin
      New(SortPattern);
      RecallBufferStack(SortPattern^,SortPattPosCur);
    end;
    ExtractSortRec(OldSortRec,CurrentSortMode^,SortPattern,Entry);
    if SortPattern<>Nil then Dispose(SortPattern); SortPattern:=Nil;
  end;
  OrigName:=Entry^.name;
end;

procedure ExtractFieldData(Data: HDDEData; var Buf: PChar; var DataLen: longint;
          Compress,Balance: boolean);
var
  F: PChar;
  i,j,dlen: longint;
  wspace, OldWSpace,BareQuote: boolean;
begin
  Buf:=Nil; DLen:=0; DataLen:=0;
  F:=DdeAccessData(Data,@DLen);
  if Compress and (DLen<=$7FFF) then
  begin
    i:=0; Oldwspace:=true;
    while (i<Dlen) and (F[i]<>#0) do
    begin
      Wspace:=(F[i] in [' ',#9,#10]);
      if not ((F[i]=#13) or (WSpace and OldWSpace)) then inc(DataLen);
      inc(i);
      OldWSpace:=WSpace;
    end;
    GetMem(Buf,DataLen+1);
    i:=0; Oldwspace:=true; j:=0;
    while (i<Dlen) and (F[i]<>#0) do
    begin
      Wspace:=(F[i] in [' ',#9,#10]);
      if not ((F[i]=#13) or (WSpace and OldWSpace)) then
      begin
        if Wspace then buf[j]:=' ' else buf[j]:=F[i];
        inc(j);
      end;
      inc(i);
      OldWSpace:=WSpace;
    end;
    if (j>0) and (buf[j-1]=' ') then dec(j);
    buf[j]:=#0;
  end else if not Compress and (DLen<$FFFF) then
  begin
    DataLen:=DLen; GetMem(Buf,DataLen+1);
    Move(F^,Buf^,DataLen); Buf[DataLen]:=#0;
  end;
  DdeUnAccessData(Data);
  if (Buf<>Nil) and balance and
      not okfield(Buf^,StrLen(Buf),0,'','',BareQuote) then
  begin
    FreeMem(Buf,DataLen+1); Buf:=Nil;
  end;
end;                       { ExtractFieldData }

begin
  PokeData:=0; Retrn:=0; Patt:=Nil; F:=Nil;

  GetMem(F,256);
  DDEQueryString(Inst,ItemHsz,F,255,cp_WinAnsi);
  ParseDdeString(F,CommandStr^,InputStr^);
  Item:=FindDDEItem(DdePokes,CommandStr^);
  FreeMem(F,256); F:=Nil;
  if item=0 then Exit;

  compress:=(item=DdePoke_Name) or (item=DdePoke_Type) or
            (item=DdePoke_Field) or (item=DdePoke_String) or
            (item=DdePoke_Register);
  balance:= (item=DdePoke_Name) or (item=DdePoke_Type) or
            (item=DdePoke_Field) or (item=DdePoke_String);

  ExtractFieldData(Data,F,DataLen,Compress,Balance); if F=Nil then Exit;

  if DataLen<255 then S:=StrPas(F)
  else begin
    Move(F^,S[1],255); S[0]:=#255;
  end;

  case item of
    DdePoke_name:
      begin
        IsError:=false;
        for i:=1 to length(S) do if s[i] in NameForbid then IsError:=true;
        if not IsError then
        begin
          KeepSortInfo;
          Entry^.name:=S; Update; Retrn:=DDE_FACK; EntryModified:=true;
        end;
      end;
    DdePoke_Type:
      begin
        StrLwr(S);
        i:=FindInETypeList(S);
        if i>0 then
        begin
          KeepSortInfo;
          Entry^.EntryType:=TypeEntry^[i];
          Update; Retrn:=DDE_FACK; EntryModified:=true;
        end;
      end;
    DdePoke_Field,DdePoke_String:
      begin
        i:=-1; StrLwr(InputStr^);
        if (item=DdePoke_String) and EditOnlyStrings then i:=StringIndex
        else if item=DdePoke_Field then
        begin
          i:=0;
          for j:=1 to FieldLast do if TypeField^[j]=InputStr^ then i:=j;
        end;
        if (i=0) and (FieldLast=MaxField) then i:=-1;
        if i>=0 then KeepSortInfo;
        if i=0 then
        begin
          inc(fieldlast);
          typefield^[fieldlast]:=InputStr^;
          entry^.LastField:=FieldLast;
          DefFieldLast:=FieldLast;
          i:=FieldLast;
        end;
        if i>0 then
        with Entry^ do
        begin
          if Index[i]=0 then
          begin
            inc(nentry);
            field[nentry]:=typefield^[i];
            index[i]:=nentry;
          end;
          Content[index[i]]:=S;
          if BigIndex[i]>0 then
          begin
            BigFree[BigIndex[i]]:=true;
            Blen[BigIndex[i]]:=0;
            BigIndex[i]:=0;
          end;
          if DataLen>255 then
          begin
            BigIndex[i]:=FindBigFree(Entry,true);
            if BigIndex[i]>0 then
            begin
              Move(F^,Big[BigIndex[i]]^[1],DataLen+1);
              Blen[BigIndex[i]]:= DataLen;
            end;
          end;
          CompressEntry;
          Update; Retrn:=DDE_FACK; EntryModified:=true;
        end;
      end;
    DdePoke_Pattern:
      begin
        New(RamStream,UseBuf(F,DataLen)); RamStream^.seek(0);
        if (RamStream<>Nil) and (RamStream^.Status=stOK) then
        begin
          Move(RamStream,InputStr^[1],sizeof(RamStream));
          InputStr^[0]:=#0;
          DealWithPattern(Entry,Pattern,0,true,CPatt_Stream);
          if not failure then
          begin
            Update; Retrn:=DDE_FACK;
          end;
        end;
        if (RamStream<>Nil) then Dispose(RamStream,Done); RamStream:=Nil;
      end;
    DdePoke_SortMode:
      begin
        StrLwr(InputStr^);
        WhichSort:=0;
        if (InputStr^='') or (InputStr^='current') then
        begin
          if not (Linked or BibReadOnly) then WhichSort:=CSortMode_Current;
        end else if InputStr^='default' then
          WhichSort:= CSortMode_Default
        else if InputStr^='export' then
          WhichSort:= CSortMode_Export;
        if WhichSort>0 then
        begin
          RamStream:=Nil; SortMode:=Nil;
          New(RamStream,UseBuf(F,DataLen)); RamStream^.seek(0);
          if (RamStream<>Nil) and (RamStream^.Status=stOK) then
          begin
            New(SortMode); New(Patt);
            LoadSortMode(DummyFile,RamStream,SortMode^,Patt);
            if WhichSort=CSortMode_Default then
            begin
              ConfigSortMode^:=SortMode^;
              PushBufferStack(Patt^,sizeof(PatRec),SortPattModeDef,
                              SortPattPosDef);
            end else if WhichSort=CSortMode_Current then
            begin
              CurrentSortMode^:=SortMode^;
              PushBufferStack(Patt^,sizeof(PatRec),SortPattModeCur,
                              SortPattPosCur);
            end else if WhichSort=CSortMode_Export then
            begin
              ExportSortMode^:=SortMode^;
              PushBufferStack(Patt^,sizeof(PatRec),SortPattModeExp,
                              SortPattPosExp);
            end;
            Dispose(Patt); Dispose(SortMode);
            Update; Retrn:=DDE_FACK;
          end;
          if (RamStream<>Nil) then Dispose(RamStream,Done); RamStream:=Nil;
        end;
      end;
    DdePoke_Register:
      if (length(InputStr^)=1) and
         (InputStr^[1] in ['A'..'Z','a'..'z','0'..'9']) then
      begin
        ch:=UpCase(InputStr^[1]);
        if ch in ['A'..'Z'] then i:=Ord(ch)-Ord('A')
        else if ch in ['0'..'9'] then i:=Ord(ch)-Ord('0')+26;
        PushBufferStack(S,256,MemoryMode,MemoryPos+i);
        Retrn:=DDE_FACK;
      end;
  end;

  FreeMem(F,DataLen+1);
  PokeData:=Retrn;
end;                           { TBrowseWindow.PokeData }

function TBrowseWindow.WWWVerb(Topic,ItemHsz: Hsz): HDDEData;
var
  S: array[0..12] of char;
  l: array[0..1] of word;
  Retrn: HDDEData;
begin
  WWWVerb:=0;
  if DdeCmpStringHandles(BeginProgressHsz,Topic) = 0 then
  begin
{   messagebeep(0);}
    if RetrievingURLDlg<>Nil then
      PostMessage(RetrievingURLDlg^.HWindow,bib_RetrieveURL,1,0);
    WWWBeginProgressOn:=true;
  {
    StrPCopy(S,'0x00000001');
    Retrn:=DDECreateDataHandle(Inst,@S[0],StrLen(S)+1,0,Topic,cf_text,0);
    WWWVerb:=Retrn; 
  end else if DdeCmpStringHandles(EndProgressHsz,Topic) = 0 then 
  begin
    DDEQueryString(Inst,ItemHsz,S,10,cp_WinAnsi);
    Message(StrPas(S));
    WWWVerb:=DDE_FACK;
  }
  end;
end;                       { TBrowseWindow.WWWVerb }

procedure TBrowseWindow.CompressEntry;
var
  ii,iii: integer;
begin
  if EditOnlyStrings then
  with entry^ do
  begin
    if content[1]='' then
    begin
      nentry:=0;
      index[StringIndex]:=0; BigIndex[StringIndex]:=0;
    end;
  end else
  with entry^ do
  begin
    nentry:=0;
    for iii:=1 to maxfield do
    begin
      if content[iii]<>'' then
      begin
        ii:=0;
        while (ii<fieldlast+1) do
        begin
          Inc(ii);
          if index[ii]=iii then
          begin
            Inc(nentry);
            content[nentry]:=content[iii];
            field[nentry]:=typefield^[ii];
            index[ii]:=nentry;
            ii:=fieldlast+1;
          end;
        end;
      end else
        for ii:=1 to fieldlast do if index[ii]=iii then index[ii]:=0;
    end;
  end;
end;                            { TBrowseWindow.CompressEntry }

function TBrowseWindow.ExecMacro(Data: HDDEData): HDDEData;
var
  Msg: TMessage;
  item,i,j,k,icode,nfields,fld,AboutFormat: integer;
  l: longint;
  F: PChar;
  tmp: string;
  Selection: SelectionType;
  EraseFields: array[1..MaxField+1] of integer;
  Ind: byte;
  Equiv,PatOK,o_k,btmp,enc8,enc7: boolean;
  NewSortRec: ^SortRecType;
  SortPattern: PatRecPtr;

procedure ProcessSearchString(var S: string);
var
  och: byte;
  RegExp,CaseSen,Exact,leave: boolean;
  i: integer;
  flag: string; 
begin
  if length(S)<1 then Exit;
  RegExp:=false; CaseSen:=false; Exact:=false;
  leave:=false;
  repeat
    if S[1]='"' then
    begin
      Delete(S,1,1); if S[length(S)]='"' then Delete(S,length(S),1);
      leave:=true;
    end else if Pos(',',S)>0 then
    begin
      i:=Pos(',',S);
      flag:=Copy(S,1,i-1); ChrDel(flag,' '); StrLwr(flag);
      if (flag='regexp') or (flag='regexpon') then RegExp:=true
      else if flag='exact' then Exact:=true
      else if (flag='case') or (flag='caseon') then CaseSen:=true
      else leave:=true;
      if not leave then
      begin
        Delete(S,1,i); ChrDelL(S,' ');
      end;
    end else leave:=true;
  until leave or (S='');
  och:=0;
  if CaseSen then och:=och or CaseSenMatch;
  if RegExp  then och:=Och or RegexpMatch;
  if Exact   then och:=ExactMatch;
  S:=Chr(och)+S;
end;                           { ProcessSearchString }

function WhichFileMode(Sin: string; imp: boolean): byte;
var
  W,Last,i,nf: byte;
  S: string;
begin
  W:=0; nf:=0;
  StrLwr(Sin); ChrDel(Sin,' ');
  if Sin='bibtex' then W:=BibTeXFormat
  else if Pos('comma',Sin)=1 then W:=CommaDelimited
  else if Sin='tib' then W:=TibFormat
  else if Sin='refer' then W:=ReferFormat
  else if not Imp then
  begin
    for i:=FirstUserFormat to FirstUserFormat+NumUserFormats-1 do
    begin
      S:=UserFormatName[i]^; StrLwr(S);
      if Sin=S then
      begin
        W:=i; inc(nf);
      end;
    end;
    if W=0 then
    begin
      nf:=0;
      for i:=FirstUserFormat to FirstUserFormat+NumUserFormats-1 do
      begin
        S:=UserFormatName[i]^; StrLwr(S);
        if Pos(Sin,S)=1 then
        begin
          inc(nf); W:=i;
        end;
      end;
    end;
    if nf<>1 then W:=0;
  end;
  WhichFileMode:=W;
end;                                 { WhichFileMode }

function InsertionPoint(S: string): integer;
var
  i,icode: integer;
  l: longint;
begin
  i:=0;
  if (S='') or (S='here')                              then i:=CIns_AfterCurr
  else if Pos('end',S)+Pos('eof',S)+Pos('last',S)>0    then i:=CIns_EOF
  else if Pos('begin',S)+Pos('bof',S)+Pos('first',S)>0 then i:=CIns_FirstEntry
  else if Pos('insert',S)>0                            then i:=CIns_BeforeCurr
  else begin
    Val(S,l,icode);
    if (icode=0) and (l>0) and (l<=$FFFF)              then i:=CIns_Num;
  end;
  InsertionPoint:=i;
end;

begin
  ExecMacro:=0;

  l:=DDEGetData(Data,Nil,512,0);
  GetMem(F,l+1);
  DDEGetData(Data,F,l,0);
  ParseDdeString(F,CommandStr^,InputStr^);
  Item:=FindDDEItem(DdeMacros,CommandStr^);
  FreeMem(F,l+1);
  if item=0 then Exit;

  FillChar(Msg, sizeof(Msg),0);
  FillChar(Selection,sizeof(Selection),0);
  MacroCommand:=true;
  case item of
    DdeMacro_Activate:
      begin SetFocus(HWindow); ExecMacro:=DDE_FACK; end;
    DdeMacro_Minimize:
      begin ShowWindow(HWindow,sw_minimize); ExecMacro:=DDE_FACK; end;
    DdeMacro_Maximize:
      begin ShowWindow(HWindow,sw_Maximize); ExecMacro:=DDE_FACK; end;
    DdeMacro_Restore:
      begin ShowWindow(HWindow,sw_restore);  ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoNext:
      begin Next(Msg);         ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoBack:
      begin Back(Msg);         ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoFirst:
      begin First(Msg);        ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoLast:
      begin Last(Msg);         ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoNumber:
      begin GotoNum(Msg);      ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoBookmark:
      begin GotoBookmark(Msg); ExecMacro:=DDE_FACK; end;
    DdeMacro_GotoLabel:
      begin
        ProcessSearchString(InputStr^);
        DealWithGoto(Entry,Pattern,0,false,false,false,CGoto_Label);
        Update;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_GotoSearch:
      begin
        ProcessSearchString(InputStr^);
        DealWithGoto(Entry,Pattern,0,false,false,false,CGoto_Search);
        Update;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_SetPattern:
      if InputStr^<>'' then
      begin
        if IsOn(InputStr^) or IsOff(InputStr^) then
        begin
          if Pattern^.on<>IsOn(InputStr^) then
          begin
            DealWithPattern(Entry,Pattern,0,true,CPatt_OnOff); Update;
          end;
        end else
        begin
          DealWithPattern(Entry,Pattern,0,true,CPatt_Macro); Update;
        end;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_Link:
      begin
        if linked <> (item=DdeMacro_Link) then SendToFileRoutine(CFile_Link,0);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_Strings:
      begin
        if EditOnlyStrings <> (not IsOff(InputStr^)) then StringsMode(Msg);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_Tag:
      begin
        if (entry^.realnum>0) and
           (IsTagged(Entry^.realnum,Tags) <> (not IsOff(InputStr^))) then
                   ToggleTag(Msg);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_TagAll:
      begin
        if IsOff(InputStr^) then UntagAll(Msg)
        else TagAll(Msg);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_TagFromTex:
      begin TagTex(Msg);      ExecMacro:=DDE_FACK; end;
    DdeMacro_SetBookmark:
      begin PutBookmark(Msg); ExecMacro:=DDE_FACK; end;
    DdeMacro_ReadOnly:
      begin
        if BibReadOnly <> IsOn(InputStr^) then ToggleReadOnly(Msg);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_OpenFile, DdeMacro_LoadFile:
      begin
        i:=0; j:=Pos(',',InputStr^);
        if j>1 then
        begin
          tmp:=Copy(InputStr^,1,j-1);
          Val(tmp,i,icode);
          if icode=0 then
          begin
            Delete(InputStr^,1,j); ChrDelL(InputStr^,' ');
          end else i:=-99;
        end;
        ChrDelL(InputStr^,' ');
        if (length(InputStr^)>1) and (InputStr^[1] in ['"','''']) and
          (InputStr^[length(InputStr^)] in ['"','''']) then
        begin
          Delete(InputStr^,length(InputStr^),1);
          Delete(InputStr^,1,1);
          ChrDelR(InputStr^,' '); ChrDelL(InputStr^,' ');
        end;
        if InputStr^='' then InputStr^:='*';
        if (i=-1) and (Item=DdeMacro_OpenFile) then
        begin
          Selection[1]:=CFile_Open;
        end else if (i>=0) and (i<=MaxBibFiles) then
        begin
          if i=0 then i:=CurrentBibFile;
          Selection[1]:=CFile_Change; Selection[2]:=i;
          if Item=DdeMacro_OpenFile then Selection[3]:=1;
        end;
        DealWithFiles(Entry,Pattern,Selection); Update;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_SelectFile, DdeMacro_UnloadFile:
      if length(InputStr^)>0 then
      begin
        i:=Ord(InputStr^[1])-Ord('0');
        if (i>0) and (i<=MaxBibFiles) and (BibFiles^[i].name<>'') then
        begin
          if (i<>CurrentBibFile) then
          begin
            if Item=DdeMacro_SelectFile then
            begin
              Selection[1]:=CFile_List-1+i; Selection[2]:=0;
            end else
            begin
              Selection[1]:=CFile_Change; Selection[2]:=i; Selection[3]:=0;
              InputStr^:='';
            end;
            DealWithFiles(Entry,Pattern,Selection); Update;
          end else if Item=DdeMacro_UnloadFile then Failure:=true;
          ExecMacro:=DDE_FACK;
        end;
      end;
    DdeMacro_EraseField,DdeMacro_RemoveField,DdeMacro_NewEntry:
      if (InputStr^<>'') or (item=DdeMacro_NewEntry) then
      begin
        NFields:=0;
        if EditOnlyStrings then
        begin
          NFields:=1; EraseFields[1]:=StringIndex;
        end else if (InputStr^='*') or (Item=DdeMacro_NewEntry) then
        begin
          i:=1; if item=DdeMacro_RemoveField then i:=OrigFieldLast+1;
          for j:=i to FieldLast do EraseFields[j-i+1]:=j;
          NFields:=FieldLast-i+1;
        end else
        begin
          Ind:=1; StrLwr(InputStr^);
          while (Ind>0) and (Ind<length(InputStr^)) and (Nfields<MaxField) do
          begin
            WrdToken(tmp,InputStr^,' ,;',Ind);
            i:=FindInFieldList(tmp);
            if (i<=OrigFieldLast) and (Item=DdeMacro_RemoveField) then i:=0;
            if i>0 then
            begin
              inc(NFields); EraseFields[NFields]:=i;
            end;
          end;
        end;
        for i:=1 to NFields do
        with Entry^ do
        begin
          fld:=EraseFields[i];
          if index[fld]>0 then
          begin
            Content[index[fld]]:='';
            if BigIndex[fld]>0 then
            begin
              BigFree[BigIndex[fld]]:=true;
              Blen[BigIndex[fld]]:=0;
            end;
            index[fld]:=0; BigIndex[fld]:=0;
          end;
          if item=DdeMacro_RemoveField then
          begin
            for j:=fld to MaxField-1 do
            begin
              typefield^[j]:=typefield^[j+1];
              index[j]:=index[j+1];
              BigIndex[j]:=BigIndex[j+1];
            end;
            Dec(FieldLast); LastField:=FieldLast;
            DefFieldLast:=FieldLast;
          end;
        end;
        if item=DdeMacro_NewEntry then Entry^.name:='';
        if NFields>0 then
        begin
          ExecMacro:=DDE_FACK; Update;
        end;
      end;
    DdeMacro_ModifyEntry:
      if EntryModified and (entry^.name<>'') and not (linked or BibReadOnly)
         and (TempDirList^<>'') and BibFileExists then
      begin
        SortPattern:=Nil;
        New(NewSortRec);
        if CurrentSortMode^.SortingOn and (not EditOnlyStrings) then
        begin
          if CurrentSortMode^.SortPatternExists then
          begin
            New(SortPattern);
            RecallBufferStack(SortPattern^,SortPattPosCur);
          end;
          ExtractSortRec(NewSortRec^,CurrentSortMode^,SortPattern,Entry);
          if SortPattern<>Nil then Dispose(SortPattern); SortPattern:=Nil;
        end;
        Equiv:=true;
        if OldSortRec.name<>NewSortRec^.name then Equiv:=false;
        if OldSortRec.Patt<>NewSortRec^.patt then Equiv:=false;
        if Equiv then
          for i:=1 to NSortKeys do
            if OldSortRec.Keys[i]<>NewSortRec^.Keys[i] then Equiv:=false;
        Dispose(NewSortRec); NewSortRec:=Nil;

        BibFileChange(Pattern,Entry,
                      origname,Ac_Replace,Equiv,'',0,2,0,Nil);
        PatternCheck(Entry,Pattern,PatOK,true);
        if not PatOK then Pattern^.on:=false;
        Update; ExecMacro:=DDE_FACK; EntryModified:=false;
      end;
    DdeMacro_AddEntry:
      if EntryModified and (entry^.name<>'') and not (linked or BibReadOnly)
         and (TempDirList^<>'') then
      begin
        i:=InsertionPoint(InputStr^);
        if i>0 then
        begin
          BibFileChange(Pattern,Entry,OrigName,Ac_Add,false,'',0,2,i,Nil);
          if not BibFileExists then BibFileExists:=LFNFileExist(bibname^);
          Update; ExecMacro:=DDE_FACK; EntryModified:=false;
        end;
      end;
    DdeMacro_CopyEntry:
      begin CopyEntry(Msg);    ExecMacro:=DDE_FACK; end;
    DdeMacro_CutEntry:
      begin CutEntry(Msg);     ExecMacro:=DDE_FACK; EntryModified:=false; end;
    DdeMacro_PasteEntry:
      begin PasteEntry(Msg);   ExecMacro:=DDE_FACK; EntryModified:=false; end;
    DdeMacro_ReplaceEntry:
      begin ReplaceEntry(Msg); ExecMacro:=DDE_FACK; EntryModified:=false; end;
    DdeMacro_DeleteEntry:
      begin ClearEntry(Msg);   ExecMacro:=DDE_FACK; EntryModified:=false; end;
    DdeMacro_DelAllEntries:
      begin DelAll(Msg);       ExecMacro:=DDE_FACK; EntryModified:=false; end;
    DdeMacro_DelTagEntries:
      begin DelTagged(Msg);    ExecMacro:=DDE_FACK; EntryModified:=false; end;
    DdeMacro_LabelTemplate:
      begin
        LabelTemplate^:=InputStr^; PrepareTemplate(LabelTemplate^);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_Capitalization:
      begin UseAutoCap:=IsOn(InputStr^);       ExecMacro:=DDE_FACK; end;
    DdeMacro_UseIndexFiles:
      begin
        UseIndexFile:=IsOn(InputStr^);
        CheckForIndexFile(bib,bibname);
        Update; ExecMacro:=DDE_FACK;
      end;
    DdeMacro_WrapEOF2BOF:
      begin WrapEOF2BOF:=IsOn(InputStr^);      ExecMacro:=DDE_FACK; end;
    DdeMacro_RetainNulls:
      begin RetainNullFields:=IsOn(InputStr^); ExecMacro:=DDE_FACK; end;
    DdeMacro_AlwaysRead:
      begin AlwaysRead:=IsOn(InputStr^);       ExecMacro:=DDE_FACK; end;
    DdeMacro_SortNewFiles:
      begin SortNewFiles:=IsOn(InputStr^);     ExecMacro:=DDE_FACK; end;
    DdeMacro_SortedByDefault:
      begin SortedByDefault:=IsOn(InputStr^);  ExecMacro:=DDE_FACK; end;
    DdeMacro_AddSort2New:
      begin
        StrLwr(InputStr^);
        if Pos('all',InputStr^)>0 then AddSort2New:=AddToAllNew
        else if Pos('sort',InputStr^)>0 then AddSort2New:=AddToSortedNew
        else AddSort2New:=AddToNoNew;
      end;
    DdeMacro_CheckDup:
      begin
        StrLwr(InputStr^);
        if (InputStr^='none') or IsOff(InputStr^) then
          CheckDuplicate:=AllowDuplicate
        else if (InputStr^='caseon') or (InputStr^='respectcase') then
          CheckDuplicate:=DuplicateCaseOn
        else if (InputStr^='caseoff') or (InputStr^='ignorecase') or
                                   IsOn(InputStr^) then
          CheckDuplicate:=DuplicateCaseOff
        else if Pos('warn',InputStr^)>0 then CheckDuplicate:=DuplicateCaseWarn;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_LabelMode:
      begin
        StrLwr(InputStr^);
        if (InputStr^='verify') or IsOn(InputStr^) then LabelMode:=VerifyLabelMode
        else if Pos('auto',InputStr^)>0 then LabelMode:=AutoLabelMode
        else LabelMode:=OffLabelMode;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_FileFormatOpt:
      if (InputStr^<>'') and (ChrQty(InputStr^,',')>=2) then
      begin
        AboutFormat:=0;
        Ind:=1; o_k:=true;
        WrdToken(tmp,InputStr^,' ,',Ind); StrLwr(tmp);
        if Pos('bibtex',tmp)>0     then AboutFormat:=BibTeXFormat
        else if Pos('comma',tmp)>0 then AboutFormat:=CommaDelimited
        else if Pos('tib',tmp)>0   then AboutFormat:=TibFormat
        else if Pos('refer',tmp)>0 then AboutFormat:=ReferFormat;
        if AboutFormat<>0 then
        begin
          WrdToken(tmp,InputStr^,' ,',Ind); StrLwr(tmp);
          Delete(InputStr^,1,Ind-1);
          ChrDelL(InputStr^,' '); ChrDelR(InputStr^,' ');
          if Pos('verify',tmp)>0 then
          begin
            if IsOff(InputStr^) or (InputStr^='none') then
                     Verify[AboutFormat]:=VerifyOff
            else if Pos('label',InputStr^)>0 then
                     Verify[AboutFormat]:=VerifyLabel
            else if IsOn(InputStr^) or (InputStr^='entry') or (InputStr^='all') then
                     Verify[AboutFormat]:=VerifyEntry
            else o_k:=false;
          end else if (AboutFormat<>CommaDelimited) and
              (Pos('width',tmp)+Pos('length',tmp)>0) then
          begin
            Val(InputStr^,i,icode);
            if icode=0 then LineWidth[AboutFormat]:=i
            else o_k:=false;
          end else if (AboutFormat in [TibFormat,ReferFormat]) and
              (Pos('label',tmp)>0) then
          begin
            ChrDel(InputStr^,','); ChrDel(InputStr^,' ');
            ChrDel(InputStr^,'%'); ChrDel(InputStr^,';');
            StrUpr(InputStr^);
            if AboutFormat=TibFormat then TibLabels:=InputStr^
            else ReferLabels:=InputStr^;
          end else if (AboutFormat=TibFormat) and (Pos('macro',tmp)>0) then
          begin
            i:=Pos('imp',InputStr^); j:=pos('exp',InputStr^);
            if (i=0) and (j=0) then TibMacros:=NotImpOrExp
            else if i=0 then TibMacros:=ExpOnly
            else if j=0 then TibMacros:=ImpOnly
            else TibMacros:=ImpAndExp;
          end;
        end else o_k:=false;
        if o_k then ExecMacro:=DDE_FACK;
      end;
    DdeMacro_ImportFormat:
      if InputStr^<>'' then
      begin
        i:=WhichFileMode(InputStr^,true);
        if i>0 then
        begin
          ImportFormat:=i; ExecMacro:=DDE_FACK; Update;
        end;
      end;
    DdeMacro_ExportFormat:
      if InputStr^<>'' then
      begin
        i:=WhichFileMode(InputStr^,false);
        if i>0 then
        begin
          ExportFormat:=i; ExecMacro:=DDE_FACK; Update;
        end;
      end;
    DdeMacro_ExportFields:
      if InputStr^<>'' then
      begin
        StrLwr(InputStr^); ChrDel(InputStr^,' ');
        if not (InputStr^[1] in ['+','-']) then
        begin
          for i:=1 to MaxField do DumpFields[i]:=false;
          DumpUndecFields:=false;
        end;
        if InputStr^[1]='*' then
        begin
          Delete(InputStr^,1,1); InputStr^:='_all'+InputStr^;
        end;
        if Copy(InputStr^,1,4)='_all' then
        begin
          for i:=1 to MaxField do DumpFields[i]:=true;
          DumpUndecFields:=true;
          Delete(InputStr^,1,4);
        end else if Copy(InputStr^,1,5)='_none' then Delete(InputStr^,1,5)
        else if not (InputStr^[1] in ['+','-']) then InputStr^:='+'+InputStr^;
        while (length(InputStr^)>1) and (InputStr^[1] in ['+','-']) do
        begin
          btmp:=InputStr^[1]='+'; Delete(InputStr^,1,1);
          tmp:=''; i:=1;
          while (i<=length(InputStr^)) and
                not (InputStr^[i] in ['+','-']) do inc(i);
          tmp:=Copy(InputStr^,1,i-1); Delete(InputStr^,1,i-1);
          if Pos('_undec',tmp)=1 then DumpUndecFields:=btmp
          else begin
            i:=FindInFieldList(tmp);
            if i>0 then DumpFields[i]:=btmp;
          end;
        end;
        for i:=OrigFieldLast+1 to MaxField do DumpFields[i]:=DumpUndecFields;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_ClearExportFile:
      begin
        selection[1]:=CExp_Clear;
        DealWithExport(Entry,Pattern,Selection,Nil);
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_ExportFile:
      begin
        Failure:=false;
        selection[1]:=CExp_New;
        DealWithExport(Entry,Pattern,Selection,Nil);
        if not failure then ExecMacro:=DDE_FACK;
      end;
    DdeMacro_Import:
      if not (BibReadOnly or (EditOnlyStrings and (ImportFormat<>BibTeXFormat)))
             and (InputStr^<>'') then
      begin
        if CurrentSortMode^.SortingOn then Selection[1]:=CIns_Sorted
        else begin
          Ind:=1; WrdToken(tmp,InputStr^,' ,',Ind);
          if Ind>0 then
          begin
            tmp:='';
            WrdToken(tmp,InputStr^,' ,',Ind);
            Selection[1]:=InsertionPoint(tmp);
          end;
        end;
        if Selection[1]<>0 then
        begin
          DealWithImport(Entry,Pattern,Selection);
          ExecMacro:=DDE_FACK; EntryModified:=false;
          Update;
        end;
      end;
    DdeMacro_Export:
      begin
        if ExportSortMode^.SortingOn then Selection[1]:=CIns_Sorted
        else Selection[1]:=InsertionPoint(InputStr^);
        if Selection[1]<>0 then
        begin
          DealWithExport(Entry,Pattern,Selection,Nil);
          ExecMacro:=DDE_FACK; EntryModified:=false;
        end;
      end;
    DdeMacro_FileEncoding,DdeMacro_DisplayEncoding:
      if InputStr^<>'' then
      begin
        StrLwr(InputStr^); ChrDel(InputStr^,' ');
        Ind:=1;
        enc7:=false; enc8:=false; 
        tmp:=''; WrdToken(tmp,InputStr^,',;',Ind);
        if tmp<>'' then
        begin
          if Pos('8',tmp)>0 then enc8:=true
          else if Pos('7',tmp)+Pos('tex',tmp)>0 then enc7:=true;
          if item=DdeMacro_DisplayEncoding then
          begin
            Prog8bit:=enc8; prog7bit:=enc7;
          end else
          begin
            File8bit:=enc8; File7bit:=enc7;
          end;
        end;
        if Ind>0 then
        begin
          tmp:=''; WrdToken(tmp,InputStr^,',;',Ind);
          j:=-1;
          for i:=0 to EncodingsList.Count-1 do
            if tmp=PEncoding(EncodingsList.at(i))^.Name^ then j:=i;
          if j>-1 then
          begin
            if item=DdeMacro_DisplayEncoding then DispEncoding:=j
            else FReadEncoding:=j;
            HighBits(DispEncoding,FReadEncoding,-1);
            ExecMacro:=DDE_FACK;
          end;
        end else ExecMacro:=DDE_FACK;
        LoadStringAbbrevs(StrAbbrevsList,Entry);
        if item=DdeMacro_DisplayEncoding then
        begin
          LoadIniAbbrevs(IniAbbrevsList);
          LoadBibAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
          LoadBstAbbrevs(BSTAbbrevsList,BSTAbbrevsFile^);
        end;
      end;
    DdeMacro_ExpandStrings:
      if InputStr^<>'' then
      begin
        StrLwr(InputStr^);
        ExpandStrings:=IsOn(InputStr^);
        if ExpandStrings then LoadStringAbbrevs(StrAbbrevsList,Entry);
        Update;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_ExpandAbbrevs:
      if InputStr^<>'' then
      begin
        StrLwr(InputStr^);
        ExpandIniAbbrevs:=IsOn(InputStr^);
        if ExpandIniAbbrevs then
        begin
          LoadIniAbbrevs(IniAbbrevsList);
          LoadBIBAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
          LoadBstAbbrevs(BstAbbrevsList,BstAbbrevsFile^);
        end;
        Update;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_SetBibAbbrevs:
      if (InputStr^='') or IsFileName(InputStr^) then
      begin
        BibAbbrevsFile^:=InputStr^;
        LoadBIBAbbrevs(BIBAbbrevsList,BIBAbbrevsFile^,Entry);
        Update;
        ExecMacro:=DDE_FACK;
      end;
    DdeMacro_SetBstAbbrevs:
      if (InputStr^='') or IsFileName(InputStr^) then
      begin
        BstAbbrevsFile^:=InputStr^;
        LoadBstAbbrevs(BstAbbrevsList,BstAbbrevsFile^);
        Update;
        ExecMacro:=DDE_FACK;
      end;
  end;
  MacroCommand:=false;
end;                              { TBrowseWindow.ExecMacro }

procedure TBrowseWindow.CloseDDE;
begin
  DdeSysItems.Done;
  DdeItems.Done;
  DdePokes.Done;
  DdeMacros.Done;

  if ServiceHSz <> 0 then
    DdeFreeStringHandle(Inst, ServiceHSz);
  if TopicHSz <> 0 then
    DdeFreeStringHandle(Inst, TopicHSz);
  if SystemHSz <> 0 then
    DdeFreeStringHandle(Inst, SystemHSz);
  if BeginProgressHSz <> 0 then
    DdeFreeStringHandle(Inst, BeginProgressHSz);
  {
  if MakingProgressHSz <> 0 then
    DdeFreeStringHandle(Inst, MakingProgressHSz);
  if EndProgressHSz <> 0 then
    DdeFreeStringHandle(Inst, EndProgressHSz);
  if OpenURLHSz <> 0 then
    DdeFreeStringHandle(Inst, OpenURLHSz);
  }
  if Inst <> 0 then
    DdeUninitialize(Inst);   { Ignore the return value }
    
  if @CallBack <> nil then
    FreeProcInstance(@CallBack);
end;                               { TBrowseWindow.CloseDDE }
