/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldValueInterpret
implements FieldValueElement {
    private FieldValueElement fieldValueElem;

    public FieldValueInterpret(FieldValueElement fieldValueElement) {
        this.fieldValueElem = fieldValueElement;
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        String string = this.getStringValue(bib2GlsEntry);
        if (string == null) {
            return null;
        }
        TeXParser teXParser = bib2GlsEntry.getResource().getParser();
        return new BibUserString((TeXObject)teXParser.getListener().createString(string));
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        BibValue bibValue = this.fieldValueElem.getValue(bib2GlsEntry);
        if (bibValue == null) {
            return null;
        }
        TeXParser teXParser = bib2GlsEntry.getResource().getParser();
        TeXObjectList teXObjectList = (TeXObjectList)bibValue.expand(teXParser).clone();
        String string = teXObjectList.toString(teXParser);
        return bib2Gls.replaceSpecialChars(bib2Gls.interpret(string, teXObjectList, false));
    }

    public String toString() {
        return String.format("\\INTERPRET{%s}", this.fieldValueElem);
    }
}

