/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Conditional;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.Relational;
import java.io.IOException;

public class FieldStringMatch
implements Conditional {
    protected String value;
    protected FieldValueElement fieldValueElem;
    protected Relational relation;
    protected boolean quoted;
    protected boolean insensitive;

    public FieldStringMatch(FieldValueElement fieldValueElement, Relational relational, String string, boolean bl, boolean bl2) {
        this.fieldValueElem = fieldValueElement;
        this.relation = relational;
        this.value = string;
        this.quoted = bl;
        this.insensitive = bl2;
    }

    @Override
    public boolean booleanValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string = this.fieldValueElem.getStringValue(bib2GlsEntry);
        if (string == null) {
            string = "";
        }
        boolean bl = this.compare(string);
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage(String.format("Entry: %s%nCondition: %s%nValue: \"%s\"%nResult: %s", new Object[]{bib2GlsEntry, this.toString(), string, bl}));
        }
        return bl;
    }

    protected boolean compare(String string) {
        int n = this.insensitive ? string.compareToIgnoreCase(this.value) : string.compareTo(this.value);
        switch (this.relation) {
            case EQUALS: {
                return n == 0;
            }
            case NOT_EQUALS: {
                return n != 0;
            }
            case LT: {
                return n < 0;
            }
            case LE: {
                return n <= 0;
            }
            case GT: {
                return n > 0;
            }
            case GE: {
                return n >= 0;
            }
        }
        throw new AssertionError((Object)("Missing Relational enum " + (Object)((Object)this.relation)));
    }

    public String toString() {
        String string = this.quoted ? String.format("%s %s \"%s\"", new Object[]{this.fieldValueElem, this.relation, this.value}) : String.format("%s %s {%s}", new Object[]{this.fieldValueElem, this.relation, this.value});
        return this.insensitive ? string + "i" : string;
    }
}

