/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsException;
import com.dickimawbooks.bib2gls.Conditional;
import com.dickimawbooks.bib2gls.FieldValueElement;
import com.dickimawbooks.bib2gls.Relational;
import java.io.IOException;

public class FieldNumberMatch
implements Conditional {
    protected Number value;
    protected FieldValueElement fieldValueElem;
    protected Relational relation;

    public FieldNumberMatch(FieldValueElement fieldValueElement, Relational relational, Number number) {
        if (fieldValueElement == null || relational == null || number == null) {
            throw new NullPointerException();
        }
        this.fieldValueElem = fieldValueElement;
        this.relation = relational;
        this.value = number;
    }

    @Override
    public boolean booleanValue(Bib2GlsEntry bib2GlsEntry) throws IOException, Bib2GlsException {
        boolean bl;
        Bib2Gls bib2Gls = bib2GlsEntry.getBib2Gls();
        String string = this.fieldValueElem.getStringValue(bib2GlsEntry);
        if (this.value instanceof Integer) {
            int n = 0;
            int n2 = this.value.intValue();
            if (string == null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        n = (int)Math.round(Double.parseDouble(string));
                    }
                    catch (NumberFormatException numberFormatException2) {
                        // empty catch block
                    }
                }
            }
            bl = this.compare(n, n2);
        } else {
            double d = 0.0;
            double d2 = this.value.doubleValue();
            if (string == null) {
                try {
                    d = Double.parseDouble(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        d = Double.parseDouble(string);
                    }
                    catch (NumberFormatException numberFormatException3) {
                        // empty catch block
                    }
                }
            }
            bl = this.compare(d, d2);
        }
        if (bib2Gls.getDebugLevel() > 0) {
            bib2Gls.logAndPrintMessage(String.format("Entry: %s%nCondition: %s%nValue: \"%s\"%nResult: %s", new Object[]{bib2GlsEntry, this.toString(), string, bl}));
        }
        return bl;
    }

    protected boolean compare(int n, int n2) {
        switch (this.relation) {
            case EQUALS: {
                return n == n2;
            }
            case NOT_EQUALS: {
                return n != n2;
            }
            case LT: {
                return n < n2;
            }
            case LE: {
                return n <= n2;
            }
            case GT: {
                return n > n2;
            }
            case GE: {
                return n >= n2;
            }
        }
        throw new AssertionError((Object)("Missing Relational enum " + (Object)((Object)this.relation)));
    }

    protected boolean compare(double d, double d2) {
        switch (this.relation) {
            case EQUALS: {
                return d == d2;
            }
            case NOT_EQUALS: {
                return d != d2;
            }
            case LT: {
                return d < d2;
            }
            case LE: {
                return d <= d2;
            }
            case GT: {
                return d > d2;
            }
            case GE: {
                return d >= d2;
            }
        }
        throw new AssertionError((Object)("Missing Relational enum " + (Object)((Object)this.relation)));
    }

    public String toString() {
        return String.format("%s %s %s", new Object[]{this.fieldValueElem, this.relation, this.value});
    }
}

