/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public final class CopyOpImage
extends PointOpImage {
    public CopyOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            rasterAccessor2.copyBinaryDataToRaster();
        } else {
            switch (rasterAccessor2.getDataType()) {
                case 0: {
                    this.byteLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 1: 
                case 2: {
                    this.shortLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 3: {
                    this.intLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 4: {
                    this.floatLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 5: {
                    this.doubleLoop(rasterAccessor, rasterAccessor2);
                    break;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Convolve3x3OpImage1"));
                }
            }
            if (rasterAccessor2.isDataCopy()) {
                rasterAccessor2.clampDataArrays();
                rasterAccessor2.copyDataToRaster();
            }
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    byArray3[n13] = byArray4[n12];
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    sArray3[n13] = sArray4[n12];
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray[n8];
            int[] nArray6 = nArray3[n8];
            int n9 = nArray4[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    nArray5[n13] = nArray6[n12];
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    fArray3[n13] = fArray4[n12];
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray2[n8];
            int n10 = nArray[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                int n14 = 0;
                while (n14 < n) {
                    dArray3[n13] = dArray4[n12];
                    n12 += n6;
                    n13 += n4;
                    ++n14;
                }
                n9 += n7;
                n10 += n5;
                ++n11;
            }
            ++n8;
        }
    }
}

