/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.xml.names.ThreddsMetadataElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.ThreddsXmlParserIssue;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.ContributorElementParser;
import thredds.catalog2.xml.parser.stax.CreatorElementParser;
import thredds.catalog2.xml.parser.stax.DatasetNodeElementParserHelper;
import thredds.catalog2.xml.parser.stax.KeyphraseElementParser;
import thredds.catalog2.xml.parser.stax.ProjectElementParser;
import thredds.catalog2.xml.parser.stax.PublisherElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;
import thredds.catalog2.xml.parser.stax.TimeCoverageElementParser;
import thredds.catalog2.xml.parser.stax.VariableGroupElementParser;

class ThreddsMetadataElementParser
extends AbstractElementParser {
    private final DatasetNodeBuilder parentDatasetNodeBuilder;
    private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
    private final boolean inheritedByDescendants;
    private final ThreddsMetadataBuilder selfBuilder;
    private AbstractElementParser delegate = null;
    private final ServiceNameElementParser.Factory serviceNameParserFactory;
    private final DataFormatElementParser.Factory dataFormatParserFactory;
    private final DataTypeElementParser.Factory dataTypeParserFactory;
    private final DateElementParser.Factory dateParserFactory;
    private final AuthorityElementParser.Factory authorityParserFactory;
    private final DocumentationElementParser.Factory documentationParserFactory;
    private final KeyphraseElementParser.Factory keyphraseParserFactory;
    private final ProjectElementParser.Factory projectNameParserFactory;
    private final CreatorElementParser.Factory creatorParserFactory;
    private final PublisherElementParser.Factory publisherParserFactory;
    private final ContributorElementParser.Factory contribParserFactory;
    private final TimeCoverageElementParser.Factory timeCovParserFactory;
    private final VariableGroupElementParser.Factory variableGroupParserFactory;

    private ThreddsMetadataElementParser(QName elementName, ServiceNameElementParser.Factory serviceNameParserFactory, DataFormatElementParser.Factory dataFormatParserFactory, DataTypeElementParser.Factory dataTypeParserFactory, DateElementParser.Factory dateParserFactory, AuthorityElementParser.Factory authorityParserFactory, DocumentationElementParser.Factory documentationParserFactory, KeyphraseElementParser.Factory keyphraseParserFactory, ProjectElementParser.Factory projectNameParserFactory, CreatorElementParser.Factory creatorParserFactory, PublisherElementParser.Factory publisherParserFactory, ContributorElementParser.Factory contribParserFactory, TimeCoverageElementParser.Factory timeCovParserFactory, VariableGroupElementParser.Factory variableGroupParserFactory, XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) {
        super(elementName, reader, builderFactory);
        this.parentDatasetNodeBuilder = parentDatasetNodeBuilder;
        this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
        this.inheritedByDescendants = inheritedByDescendants;
        this.selfBuilder = builderFactory.newThreddsMetadataBuilder();
        this.serviceNameParserFactory = serviceNameParserFactory;
        this.dataFormatParserFactory = dataFormatParserFactory;
        this.dataTypeParserFactory = dataTypeParserFactory;
        this.dateParserFactory = dateParserFactory;
        this.authorityParserFactory = authorityParserFactory;
        this.documentationParserFactory = documentationParserFactory;
        this.keyphraseParserFactory = keyphraseParserFactory;
        this.projectNameParserFactory = projectNameParserFactory;
        this.creatorParserFactory = creatorParserFactory;
        this.publisherParserFactory = publisherParserFactory;
        this.contribParserFactory = contribParserFactory;
        this.variableGroupParserFactory = variableGroupParserFactory;
        this.timeCovParserFactory = timeCovParserFactory;
    }

    boolean isSelfElement(XMLEvent event) {
        return this.delegate.isSelfElement(event);
    }

    ThreddsMetadataBuilder getSelfBuilder() {
        return this.selfBuilder;
    }

    void parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.peekAtNextEventIfStartElement();
        if (this.serviceNameParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.serviceNameParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder, this.parentDatasetNodeElementParserHelper, this.inheritedByDescendants);
        } else if (this.dataFormatParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.dataFormatParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.dataTypeParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.dataTypeParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.dateParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.dateParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.authorityParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.authorityParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder, this.parentDatasetNodeElementParserHelper, this.inheritedByDescendants);
        } else if (this.documentationParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.documentationParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.keyphraseParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.keyphraseParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.projectNameParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.projectNameParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.creatorParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.creatorParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.publisherParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.publisherParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.contribParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.contribParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.timeCovParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.timeCovParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else if (this.variableGroupParserFactory.isEventMyStartElement(startElement)) {
            this.delegate = this.variableGroupParserFactory.getNewParser(this.reader, this.builderFactory, this.selfBuilder);
        } else {
            throw new ThreddsXmlParserException("Not a recognized ThreddsMetadata child element [" + startElement.getName().getLocalPart() + "].");
        }
        this.delegate.parseStartElement();
    }

    void handleChildStartElement() throws ThreddsXmlParserException {
        if (this.delegate == null) {
            throw new IllegalStateException("Proxy delegate is null: " + StaxThreddsXmlParserUtils.getLocationInfo(this.reader));
        }
        this.delegate.handleChildStartElement();
    }

    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        if (this.delegate == null) {
            throw new IllegalStateException("Proxy delegate is null: " + StaxThreddsXmlParserUtils.getLocationInfo(this.reader));
        }
        this.delegate.postProcessingAfterEndElement();
    }

    static class DocumentationElementParser
    extends AbstractElementParser {
        private final ThreddsMetadataBuilder threddsMetadataBuilder;

        private DocumentationElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder) {
            super(elementName, reader, builderFactory);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
        }

        ThreddsBuilder getSelfBuilder() {
            return null;
        }

        void parseStartElement() throws ThreddsXmlParserException {
            StartElement startElement = this.getNextEventIfStartElementIsMine();
            Attribute typeAtt = startElement.getAttributeByName(ThreddsMetadataElementNames.DocumentationElement_Type);
            Attribute xlinkTitleAtt = startElement.getAttributeByName(ThreddsMetadataElementNames.DocumentationElement_XlinkTitle);
            Attribute xlinkExternalRefAtt = startElement.getAttributeByName(ThreddsMetadataElementNames.DocumentationElement_XlinkHref);
            String type = typeAtt != null ? typeAtt.getValue() : null;
            String xlinkTitle = xlinkTitleAtt != null ? xlinkTitleAtt.getValue() : null;
            String xlinkExternalRef = xlinkExternalRefAtt != null ? xlinkExternalRefAtt.getValue() : null;
            String content = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, this.elementName);
            if (xlinkTitle == null && xlinkExternalRef == null) {
                this.threddsMetadataBuilder.addDocumentation(type, content);
                return;
            }
            this.threddsMetadataBuilder.addDocumentation(type, xlinkTitle, xlinkExternalRef);
        }

        void handleChildStartElement() throws ThreddsXmlParserException {
        }

        void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        }

        static class Factory {
            private QName elementName = ThreddsMetadataElementNames.DocumentationElement;

            Factory() {
            }

            boolean isEventMyStartElement(XMLEvent event) {
                return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
            }

            DocumentationElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder parentBuilder) {
                return new DocumentationElementParser(this.elementName, reader, builderFactory, parentBuilder);
            }
        }
    }

    static class AuthorityElementParser
    extends AbstractElementParser {
        private Logger log = LoggerFactory.getLogger(this.getClass());
        private final ThreddsMetadataBuilder threddsMetadataBuilder;
        private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
        private final boolean inheritedByDescendants;
        private String idAuthority;

        private AuthorityElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) {
            super(elementName, reader, builderFactory);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
            this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
            this.inheritedByDescendants = inheritedByDescendants;
        }

        ThreddsBuilder getSelfBuilder() {
            return null;
        }

        void parseStartElement() throws ThreddsXmlParserException {
            this.getNextEventIfStartElementIsMine();
            this.idAuthority = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, this.elementName);
        }

        void handleChildStartElement() throws ThreddsXmlParserException {
        }

        void postProcessingAfterEndElement() throws ThreddsXmlParserException {
            this.parentDatasetNodeElementParserHelper.setIdAuthoritySpecifiedInSelf(this.idAuthority);
            if (this.inheritedByDescendants) {
                this.parentDatasetNodeElementParserHelper.setIdAuthorityToBeInheritedByDescendants(this.idAuthority);
            }
        }

        static class Factory {
            private QName elementName = ThreddsMetadataElementNames.AuthorityElement;

            Factory() {
            }

            boolean isEventMyStartElement(XMLEvent event) {
                return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
            }

            AuthorityElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder parentBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) {
                return new AuthorityElementParser(this.elementName, reader, builderFactory, parentBuilder, parentDatasetNodeElementParserHelper, inheritedByDescendants);
            }
        }
    }

    static class DateElementParser
    extends AbstractElementParser {
        private final ThreddsMetadataBuilder threddsMetadataBuilder;

        private DateElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder) {
            super(elementName, reader, builderFactory);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
        }

        ThreddsBuilder getSelfBuilder() {
            return null;
        }

        void parseStartElement() throws ThreddsXmlParserException {
            StartElement startElement = this.getNextEventIfStartElementIsMine();
            Attribute typeAtt = startElement.getAttributeByName(ThreddsMetadataElementNames.DateElement_Type);
            String typeString = typeAtt != null ? typeAtt.getValue() : null;
            Attribute formatAtt = startElement.getAttributeByName(ThreddsMetadataElementNames.DateElement_Format);
            String formatString = formatAtt != null ? formatAtt.getValue() : null;
            String date = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, this.elementName);
            ThreddsMetadata.DatePointType type = ThreddsMetadata.DatePointType.getTypeForLabel(typeString);
            if (type.equals((Object)ThreddsMetadata.DatePointType.Untyped) || type.equals((Object)ThreddsMetadata.DatePointType.Other)) {
                this.threddsMetadataBuilder.addOtherDatePointBuilder(date, formatString, typeString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.Created)) {
                this.threddsMetadataBuilder.setCreatedDatePointBuilder(date, formatString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.Modified)) {
                this.threddsMetadataBuilder.setModifiedDatePointBuilder(date, formatString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.Valid)) {
                this.threddsMetadataBuilder.setValidDatePointBuilder(date, formatString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.Issued)) {
                this.threddsMetadataBuilder.setIssuedDatePointBuilder(date, formatString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.Available)) {
                this.threddsMetadataBuilder.setAvailableDatePointBuilder(date, formatString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.MetadataCreated)) {
                this.threddsMetadataBuilder.setMetadataCreatedDatePointBuilder(date, formatString);
            } else if (type.equals((Object)ThreddsMetadata.DatePointType.MetadataModified)) {
                this.threddsMetadataBuilder.setMetadataModifiedDatePointBuilder(date, formatString);
            } else {
                String msg = "Unsupported DatePointType [" + typeString + "].";
                ThreddsXmlParserIssue parserIssue = StaxThreddsXmlParserUtils.createIssueForUnexpectedEvent(msg, ThreddsXmlParserIssue.Severity.WARNING, this.reader, startElement);
                this.log.error("parseStartElement(): " + parserIssue.getMessage());
                throw new ThreddsXmlParserException(parserIssue);
            }
        }

        void handleChildStartElement() throws ThreddsXmlParserException {
        }

        void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        }

        static class Factory {
            private QName elementName = ThreddsMetadataElementNames.DateElement;

            Factory() {
            }

            boolean isEventMyStartElement(XMLEvent event) {
                return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
            }

            DateElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder parentBuilder) {
                return new DateElementParser(this.elementName, reader, builderFactory, parentBuilder);
            }
        }
    }

    static class DataTypeElementParser
    extends AbstractElementParser {
        private final ThreddsMetadataBuilder threddsMetadataBuilder;

        private DataTypeElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder) {
            super(elementName, reader, builderFactory);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
        }

        ThreddsBuilder getSelfBuilder() {
            return null;
        }

        void parseStartElement() throws ThreddsXmlParserException {
            StartElement startElement = this.getNextEventIfStartElementIsMine();
            String dataType = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, ThreddsMetadataElementNames.DataTypeElement);
            this.threddsMetadataBuilder.setDataType(dataType);
        }

        void handleChildStartElement() throws ThreddsXmlParserException {
        }

        void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        }

        static class Factory {
            private QName elementName = ThreddsMetadataElementNames.DataTypeElement;

            Factory() {
            }

            boolean isEventMyStartElement(XMLEvent event) {
                return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
            }

            DataTypeElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder parentBuilder) {
                return new DataTypeElementParser(this.elementName, reader, builderFactory, parentBuilder);
            }
        }
    }

    static class DataFormatElementParser
    extends AbstractElementParser {
        private final ThreddsMetadataBuilder threddsMetadataBuilder;

        private DataFormatElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder) {
            super(elementName, reader, builderFactory);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
        }

        ThreddsBuilder getSelfBuilder() {
            return null;
        }

        void parseStartElement() throws ThreddsXmlParserException {
            StartElement startElement = this.getNextEventIfStartElementIsMine();
            String dataFormat = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, ThreddsMetadataElementNames.DataFormatElement);
            this.threddsMetadataBuilder.setDataFormat(dataFormat);
        }

        void handleChildStartElement() throws ThreddsXmlParserException {
        }

        void postProcessingAfterEndElement() throws ThreddsXmlParserException {
        }

        static class Factory {
            private QName elementName = ThreddsMetadataElementNames.DataFormatElement;

            Factory() {
            }

            boolean isEventMyStartElement(XMLEvent event) {
                return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
            }

            DataFormatElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder parentBuilder) {
                return new DataFormatElementParser(this.elementName, reader, builderFactory, parentBuilder);
            }
        }
    }

    static class ServiceNameElementParser
    extends AbstractElementParser {
        private Logger log = LoggerFactory.getLogger(this.getClass());
        private final ThreddsMetadataBuilder threddsMetadataBuilder;
        private final DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper;
        private final boolean inheritedByDescendants;
        private String serviceName;

        private ServiceNameElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) {
            super(elementName, reader, builderFactory);
            this.threddsMetadataBuilder = threddsMetadataBuilder;
            this.parentDatasetNodeElementParserHelper = parentDatasetNodeElementParserHelper;
            this.inheritedByDescendants = inheritedByDescendants;
        }

        ThreddsBuilder getSelfBuilder() {
            return null;
        }

        void parseStartElement() throws ThreddsXmlParserException {
            this.getNextEventIfStartElementIsMine();
            this.serviceName = StaxThreddsXmlParserUtils.getCharacterContent(this.reader, this.elementName);
        }

        void handleChildStartElement() throws ThreddsXmlParserException {
        }

        void postProcessingAfterEndElement() throws ThreddsXmlParserException {
            this.parentDatasetNodeElementParserHelper.setDefaultServiceNameSpecifiedInSelf(this.serviceName);
            if (this.inheritedByDescendants) {
                this.parentDatasetNodeElementParserHelper.setDefaultServiceNameToBeInheritedByDescendants(this.serviceName);
            }
        }

        static class Factory {
            private QName elementName = ThreddsMetadataElementNames.ServiceNameElement;

            Factory() {
            }

            boolean isEventMyStartElement(XMLEvent event) {
                return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
            }

            ServiceNameElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ThreddsMetadataBuilder threddsMetadataBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) {
                return new ServiceNameElementParser(this.elementName, reader, builderFactory, threddsMetadataBuilder, parentDatasetNodeElementParserHelper, inheritedByDescendants);
            }
        }
    }

    static class Factory {
        private final QName elementName = ThreddsMetadataElementNames.ThreddsMetadataElement;
        private final ServiceNameElementParser.Factory serviceNameParserFactory = new ServiceNameElementParser.Factory();
        private final DataFormatElementParser.Factory dataFormatParserFactory = new DataFormatElementParser.Factory();
        private final DataTypeElementParser.Factory dataTypeParserFactory = new DataTypeElementParser.Factory();
        private final DateElementParser.Factory dateParserFactory = new DateElementParser.Factory();
        private final AuthorityElementParser.Factory authorityParserFactory = new AuthorityElementParser.Factory();
        private final DocumentationElementParser.Factory documentationParserFactory = new DocumentationElementParser.Factory();
        private final KeyphraseElementParser.Factory keyphraseParserFactory = new KeyphraseElementParser.Factory();
        private final ProjectElementParser.Factory projectNameParserFactory = new ProjectElementParser.Factory();
        private final CreatorElementParser.Factory creatorParserFactory = new CreatorElementParser.Factory();
        private final PublisherElementParser.Factory publisherParserFactory = new PublisherElementParser.Factory();
        private final ContributorElementParser.Factory contribParserFactory = new ContributorElementParser.Factory();
        private final TimeCoverageElementParser.Factory timeCovParserFactory = new TimeCoverageElementParser.Factory();
        private final VariableGroupElementParser.Factory varGroupParserFactory = new VariableGroupElementParser.Factory();

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            if (this.serviceNameParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.dataFormatParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.dataTypeParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.dateParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.authorityParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.documentationParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.keyphraseParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.projectNameParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.creatorParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.publisherParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.contribParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            if (this.timeCovParserFactory.isEventMyStartElement(event)) {
                return true;
            }
            return this.varGroupParserFactory.isEventMyStartElement(event);
        }

        ThreddsMetadataElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder, DatasetNodeElementParserHelper parentDatasetNodeElementParserHelper, boolean inheritedByDescendants) {
            return new ThreddsMetadataElementParser(this.elementName, this.serviceNameParserFactory, this.dataFormatParserFactory, this.dataTypeParserFactory, this.dateParserFactory, this.authorityParserFactory, this.documentationParserFactory, this.keyphraseParserFactory, this.projectNameParserFactory, this.creatorParserFactory, this.publisherParserFactory, this.contribParserFactory, this.timeCovParserFactory, this.varGroupParserFactory, reader, builderFactory, parentDatasetNodeBuilder, parentDatasetNodeElementParserHelper, inheritedByDescendants);
        }
    }
}

