#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::HitCounterCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. HitCounterCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::HitCounterCodeType

=head1 DESCRIPTION

HitCounterCodeType - Type declaration to be used by other schema.
Indicates whether a hit counter is used for the item's listing page
and, if so, what type.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 NoHitCounter

No hit counter. The number of page views will not be available.



=cut


use constant NoHitCounter => scalar('NoHitCounter');


=head2 HonestyStyle

A basic style hit counter (US only). Non-US sites will return errors if they use HonestyStyle as input, and should use BasicStyle instead.



=cut


use constant HonestyStyle => scalar('HonestyStyle');


=head2 GreenLED

A green LED, computer-style hit counter (US only). Non-US sites will return errors if they use GreenLED as input, and should use RetroStyle instead.



=cut


use constant GreenLED => scalar('GreenLED');


=head2 Hidden

A hidden hit counter (US only). The number of page views will only be available to
the item's seller. For faster "View Item" page loads, use HiddenStyle.



=cut


use constant Hidden => scalar('Hidden');


=head2 BasicStyle

A basic style hit counter.



=cut


use constant BasicStyle => scalar('BasicStyle');


=head2 RetroStyle

A retro, computer-style hit counter.



=cut


use constant RetroStyle => scalar('RetroStyle');


=head2 HiddenStyle

A hidden hit counter. The number of page views will only be available to
the item's seller.



=cut


use constant HiddenStyle => scalar('HiddenStyle');


=head2 CustomCode

Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');







1;   
