use strict;
use warnings;
use Test::More;
use Digest::Groestl qw(groestl_224 groestl_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Groestl->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            groestl_224_hex($data), $digest,
            "groestl_224_hex: $len bits of $msg"
        );
        ok(
            groestl_224($data) eq pack('H*', $digest),
            "groestl_224: $len bits of $msg"
        );
    }

    my $md = Digest::Groestl->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|f2e180fb5947be964cd584e22e496242c6a329c577fc4ce8c36d34c3
00|d9de6a2e385df78bb0de2619c421889520b610a8ded89b13484bc89e
C0|e1d2cc6873a622181898393d55aeedfdb129da83cb65e1abe2ef8a38
C0|175143e7df96559f818b8b5a408447375a7a16149a38cd55f14d3d0f
80|02363d95a32f527e947172f65b79a2441583363af68265edc4585709
48|31e2e0a685ed9a1cf83daf98c59205d9c25a813b38f12a7e6f17c586
50|250319f32bc967de3f48f65ba414ff4e03054e96c788baa5e7404e31
98|b3266376765fb0956384d52656eceb453d778cda84da09341eab9edc
CC|62e367662adf9317154f877fd740c23fc2356080b477dac847be2eb2
9800|eca4d3c335e4e8a539a5e5897cf7c935aca362ac11c20b85109a6145
9D40|09e760f9d248ee18a3547955785d9974fa7e6b6230d0cd2422d74feb
AA80|2bc2342b1f614b9399bf399f0578c1f7ab80ac8862641f6523b35716
9830|b95666f674fb84d0bbe8d6401796bc403113b1b41ed0cd2bab6c1ae1
5030|0a8f4837a4822fa38c425980b7f7ca0aefc179a64e4fd841716f4246
4D24|6823d7d128c24d30617047da4dc9f2969d6aa880cf73759638ba5842
CBDE|6d2df532775ace5ec43b977232c0bc4929d85a78de057eb725aa55a1
41FB|2cd7e4b0f938053442afbf0d5c5f2e50a07f16c252ebf04da2b5cf8a
4FF400|84aa283381fa02edb8103f7caa0117fea93b9bf8a6a5bad71fa3096b
FD0440|190091ee69d33e052fead28d9c2388110b4e1b5c62a4b65962b98886
424D00|995346efd9da4e67e8b67302fce607c1867a245cb340af1947f25981
3FDEE0|558dd6d5464edc0d8686706589bf03a1d23721c88b8620ba3db1693d
335768|ecb8d7b2c352ed5397b2ed5a1c020b918ebea1f71ec2da1a519106af
051E7C|46a0965acd618556968b31a241d12b1c9fcf963b00ec521b9ef41c44
717F8C|d0140879b8eafc9b1bd7d9fd4a643e9056ab9777926c84bf53fd4794
1F877C|1dc3ef787d0d92a2e7b66e28a5bbc14a0f533e3946f3eeecedc001f9
EB35CF80|dbbb6522e5660eefb5ea0a735ae1a37b1d642af794e53c62438526e2
B406C480|c30a209f1b8ee915821f38002d6511b7ad085356f9e0c9051c5932e3
CEE88040|9084508e02ba87db2e3e9b6d97552da61c58c1cae3224845770cc2ce
C584DB70|792ed57b3cd87fa5cf13788a54458e7e01bdc0de1812de68ef42986f
53587BC8|21d5d670d54acbfe118fa6e2592c5313dd8bcd62c1b56d909e7cc1c7
69A305B0|bde37cba3c63e8cb9b4e4f0553655da6d4505fbff83db06d2b41e5b3
C9375ECE|d58091bcb805c88798072670460a7711fa11fe9d357eba7087a8700c
C1ECFDFC|f58e0b2d0ca78de9c71b6b485f4e4911f67b547700adce09601c30a7
8D73E8A280|788fa1c34e7475c5bc26cd2faa94514de75e9db769e0ffe77a22f3bd
06F2522080|f3521b83b5e4ac1c9d6896708868c7ebdad264defaf2a0e8d9d5c1c5
3EF6C36F20|51bb140a3a30fb8d98ca341027c079fa528796aeb413abf24af649ca
0127A1D340|13b618afe14d68cfe0b030bdbe2c162c2eba6a7a27f68519f765d730
6A6AB6C210|b5f282202a34f66259cc3bde9af0edbfdbc258e28ce15722f71a113b
AF3175E160|dbd7e7f7b1bd52bc97e41bb0cc799af87b0bd4c8d45d74365a658bbb
B66609ED86|d5ccb1b7700858af45ddcebc644b572f55628b736ac7d7552440a8e2
21F134AC57|a686ff84e136e28c8533dc40ae59e4849d621a12bbd5a8deab059882
3DC2AADFFC80|8bb114550b05f5e3e61dbecf6cf32ab07781e8da8ac6fdb3129c8ce5
9202736D2240|3ff208fe0830d0fa04f44c07a12b654d0ac8c76ea19dee73f3484cb7
F219BD629820|ab4486bf3a6d87b0c919c0a3ae189449249fb6ea2061b32412e24f92
F3511EE2C4B0|e13c8bdbadcc6417ef63d99010bbec20da5bf69e40ad2631a5048615
3ECAB6BF7720|c49f4cd835761e923b3890142b9fe4e00b39b33c7b47746a6d1e86d3
CD62F688F498|815c29e5a0c7e0818465324dc77ca49a161cc65b20ac49bad256db76
C2CBAA33A9F8|10959881f4ea068dbafca1f13c429113f85700673796d638f425e1df
C6F50BB74E29|60196e0aa139ee723131421598990ca13bf74e8aa60ada1d2e11edbb
79F1B4CCC62A00|b2ef8a3ccac29b3876adc2549f40de9f818bcc67f8f4ebdd9bbeeb3c
