package Image::DCMTK;

use 5.006;
use strict;
use warnings;
use Data::PrintUtils qw(:ALL);
use Getopt::CommandLineExports qw(:ALL);

=head1 NAME

Image::DCMTK - Interface to the DCMTK Dicom Toolkit

=head1 VERSION

Version 0.04

=cut

our $VERSION = '0.04';


=head1 SYNOPSIS

Provides a set of interface functions to the Dicom Toolkit (dcmtk)

In most cases, the Dicom tags are treated as a hash to and from the various functions.

There is an included Dicom Dictionary, but you are free to add your own tags as well




=head1 EXPORT



=head1 SUBROUTINES/METHODS


=cut


BEGIN {
    use Exporter ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);
# set the version for version checking
    $VERSION = 0.04;
    @ISA = qw(Exporter);
    @EXPORT_OK = qw();
    %EXPORT_TAGS = ( ); # eg: TAG => [ qw!name1 name2! ],
    @EXPORT_OK = qw( &openXMLItem &openXMLSequence &makeXMLElement &closeXMLItem &closeXMLSequence
                &returnTagAsXML &parseDCMDump &parseDCMDumpForTagLists &parseDCMDumpForSequences
                &parseDCMXMLDump &parseDCMXMLDumpForTagLists &parseDCMXMLDumpForSequences
                &modifyAnImage
                %dcmtkDicomDictionary %dcmtk360DicomDictionary %reverseDicomDictionary);
    %EXPORT_TAGS = (ALL => [ qw!&openXMLItem &openXMLSequence &makeXMLElement &closeXMLItem &closeXMLSequence
                &returnTagAsXML &parseDCMDump &parseDCMDumpForTagLists &parseDCMDumpForSequences
                &parseDCMXMLDump &parseDCMXMLDumpForTagLists &parseDCMXMLDumpForSequences
                &modifyAnImage
                %dcmtkDicomDictionary %dcmtk360DicomDictionary %reverseDicomDictionary! ], ); # eg: TAG => [ qw!name1 name2! ],
}
#your exported package globals go here,
#as well as any optionally exported functions
#The Dicom Dictionary is parsed with the following perl command to generate the hash:
#perl -ne 'printf ("%72s => { GRP => \"%4s\", ELEM => \"%4s\", VR => \"%2s\", VM => \"%s\", VERSION =>  \"%s\"},\n", $+{name}, $+{grp}, $+{elem}, $+{vr}, $+{vm},  $+{ver} ) if m/\((?<grp>[0-9a-fA-F]{4})\,(?<elem>[0-9a-fA-F]{4})\)\s+(?<vr>\S{2})\s+(?<name>\S+)\s+(?<vm>\S+)\s+(?<ver>\S+)/;'

our %dcmtk360DicomDictionary = (
#                                                    PixelData => {GRP => "7fe0", ELEM => "0010", VR => "OB"},
                                             MetaElementGroupLength => { GRP => "0000", ELEM => "0000", VR => "UL" },

#from dcmtk 3.6.0
                                                      CommandGroupLength => { GRP => "0000", ELEM => "0000", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AffectedSOPClassUID => { GRP => "0000", ELEM => "0002", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RequestedSOPClassUID => { GRP => "0000", ELEM => "0003", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                            CommandField => { GRP => "0000", ELEM => "0100", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                               MessageID => { GRP => "0000", ELEM => "0110", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                               MessageIDBeingRespondedTo => { GRP => "0000", ELEM => "0120", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                         MoveDestination => { GRP => "0000", ELEM => "0600", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Priority => { GRP => "0000", ELEM => "0700", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                             DataSetType => { GRP => "0000", ELEM => "0800", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                                  Status => { GRP => "0000", ELEM => "0900", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                        OffendingElement => { GRP => "0000", ELEM => "0901", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                            ErrorComment => { GRP => "0000", ELEM => "0902", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 ErrorID => { GRP => "0000", ELEM => "0903", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  AffectedSOPInstanceUID => { GRP => "0000", ELEM => "1000", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RequestedSOPInstanceUID => { GRP => "0000", ELEM => "1001", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                             EventTypeID => { GRP => "0000", ELEM => "1002", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 AttributeIdentifierList => { GRP => "0000", ELEM => "1005", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                            ActionTypeID => { GRP => "0000", ELEM => "1008", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                          NumberOfRemainingSubOperations => { GRP => "0000", ELEM => "1020", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                          NumberOfCompletedSubOperations => { GRP => "0000", ELEM => "1021", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                             NumberOfFailedSubOperations => { GRP => "0000", ELEM => "1022", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                            NumberOfWarningSubOperations => { GRP => "0000", ELEM => "1023", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                    MoveOriginatorApplicationEntityTitle => { GRP => "0000", ELEM => "1030", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                                 MoveOriginatorMessageID => { GRP => "0000", ELEM => "1031", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                          FileMetaInformationGroupLength => { GRP => "0002", ELEM => "0000", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                              FileMetaInformationVersion => { GRP => "0002", ELEM => "0001", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                                 MediaStorageSOPClassUID => { GRP => "0002", ELEM => "0002", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                              MediaStorageSOPInstanceUID => { GRP => "0002", ELEM => "0003", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TransferSyntaxUID => { GRP => "0002", ELEM => "0010", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ImplementationClassUID => { GRP => "0002", ELEM => "0012", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                               ImplementationVersionName => { GRP => "0002", ELEM => "0013", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                            SourceApplicationEntityTitle => { GRP => "0002", ELEM => "0016", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                            PrivateInformationCreatorUID => { GRP => "0002", ELEM => "0100", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PrivateInformation => { GRP => "0002", ELEM => "0102", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                                               FileSetID => { GRP => "0004", ELEM => "1130", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 FileSetDescriptorFileID => { GRP => "0004", ELEM => "1141", VR => "CS", VM => "1-8", VERSION =>  "DICOM_2009"},
                             SpecificCharacterSetOfFileSetDescriptorFile => { GRP => "0004", ELEM => "1142", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                 OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity => { GRP => "0004", ELEM => "1200", VR => "up", VM => "1", VERSION =>  "DICOM_2009"},
                  OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity => { GRP => "0004", ELEM => "1202", VR => "up", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FileSetConsistencyFlag => { GRP => "0004", ELEM => "1212", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DirectoryRecordSequence => { GRP => "0004", ELEM => "1220", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          OffsetOfTheNextDirectoryRecord => { GRP => "0004", ELEM => "1400", VR => "up", VM => "1", VERSION =>  "DICOM_2009"},
                                                         RecordInUseFlag => { GRP => "0004", ELEM => "1410", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                             OffsetOfReferencedLowerLevelDirectoryEntity => { GRP => "0004", ELEM => "1420", VR => "up", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DirectoryRecordType => { GRP => "0004", ELEM => "1430", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PrivateRecordUID => { GRP => "0004", ELEM => "1432", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ReferencedFileID => { GRP => "0004", ELEM => "1500", VR => "CS", VM => "1-8", VERSION =>  "DICOM_2009"},
                                             ReferencedSOPClassUIDInFile => { GRP => "0004", ELEM => "1510", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedSOPInstanceUIDInFile => { GRP => "0004", ELEM => "1511", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                       ReferencedTransferSyntaxUIDInFile => { GRP => "0004", ELEM => "1512", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                               ReferencedRelatedGeneralSOPClassUIDInFile => { GRP => "0004", ELEM => "151A", VR => "UI", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    SpecificCharacterSet => { GRP => "0008", ELEM => "0005", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    LanguageCodeSequence => { GRP => "0008", ELEM => "0006", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                               ImageType => { GRP => "0008", ELEM => "0008", VR => "CS", VM => "2-n", VERSION =>  "DICOM_2009"},
                                                    InstanceCreationDate => { GRP => "0008", ELEM => "0012", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                    InstanceCreationTime => { GRP => "0008", ELEM => "0013", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                      InstanceCreatorUID => { GRP => "0008", ELEM => "0014", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                             SOPClassUID => { GRP => "0008", ELEM => "0016", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                          SOPInstanceUID => { GRP => "0008", ELEM => "0018", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                               RelatedGeneralSOPClassUID => { GRP => "0008", ELEM => "001A", VR => "UI", VM => "1-n", VERSION =>  "DICOM_2009"},
                                          OriginalSpecializedSOPClassUID => { GRP => "0008", ELEM => "001B", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                               StudyDate => { GRP => "0008", ELEM => "0020", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                              SeriesDate => { GRP => "0008", ELEM => "0021", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AcquisitionDate => { GRP => "0008", ELEM => "0022", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ContentDate => { GRP => "0008", ELEM => "0023", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AcquisitionDateTime => { GRP => "0008", ELEM => "002A", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                               StudyTime => { GRP => "0008", ELEM => "0030", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                              SeriesTime => { GRP => "0008", ELEM => "0031", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AcquisitionTime => { GRP => "0008", ELEM => "0032", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ContentTime => { GRP => "0008", ELEM => "0033", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AccessionNumber => { GRP => "0008", ELEM => "0050", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                         IssuerOfAccessionNumberSequence => { GRP => "0008", ELEM => "0051", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      QueryRetrieveLevel => { GRP => "0008", ELEM => "0052", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         RetrieveAETitle => { GRP => "0008", ELEM => "0054", VR => "AE", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    InstanceAvailability => { GRP => "0008", ELEM => "0056", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                FailedSOPInstanceUIDList => { GRP => "0008", ELEM => "0058", VR => "UI", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                                Modality => { GRP => "0008", ELEM => "0060", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ModalitiesInStudy => { GRP => "0008", ELEM => "0061", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       SOPClassesInStudy => { GRP => "0008", ELEM => "0062", VR => "UI", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          ConversionType => { GRP => "0008", ELEM => "0064", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PresentationIntentType => { GRP => "0008", ELEM => "0068", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            Manufacturer => { GRP => "0008", ELEM => "0070", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         InstitutionName => { GRP => "0008", ELEM => "0080", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      InstitutionAddress => { GRP => "0008", ELEM => "0081", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                 InstitutionCodeSequence => { GRP => "0008", ELEM => "0082", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ReferringPhysicianName => { GRP => "0008", ELEM => "0090", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferringPhysicianAddress => { GRP => "0008", ELEM => "0092", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                      ReferringPhysicianTelephoneNumbers => { GRP => "0008", ELEM => "0094", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                ReferringPhysicianIdentificationSequence => { GRP => "0008", ELEM => "0096", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                               CodeValue => { GRP => "0008", ELEM => "0100", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CodingSchemeDesignator => { GRP => "0008", ELEM => "0102", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CodingSchemeVersion => { GRP => "0008", ELEM => "0103", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                             CodeMeaning => { GRP => "0008", ELEM => "0104", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         MappingResource => { GRP => "0008", ELEM => "0105", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ContextGroupVersion => { GRP => "0008", ELEM => "0106", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                ContextGroupLocalVersion => { GRP => "0008", ELEM => "0107", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                               ContextGroupExtensionFlag => { GRP => "0008", ELEM => "010B", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         CodingSchemeUID => { GRP => "0008", ELEM => "010C", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                         ContextGroupExtensionCreatorUID => { GRP => "0008", ELEM => "010D", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ContextIdentifier => { GRP => "0008", ELEM => "010F", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                      CodingSchemeIdentificationSequence => { GRP => "0008", ELEM => "0110", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    CodingSchemeRegistry => { GRP => "0008", ELEM => "0112", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CodingSchemeExternalID => { GRP => "0008", ELEM => "0114", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                        CodingSchemeName => { GRP => "0008", ELEM => "0115", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                     CodingSchemeResponsibleOrganization => { GRP => "0008", ELEM => "0116", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ContextUID => { GRP => "0008", ELEM => "0117", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                   TimezoneOffsetFromUTC => { GRP => "0008", ELEM => "0201", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                             StationName => { GRP => "0008", ELEM => "1010", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                        StudyDescription => { GRP => "0008", ELEM => "1030", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ProcedureCodeSequence => { GRP => "0008", ELEM => "1032", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SeriesDescription => { GRP => "0008", ELEM => "103E", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           SeriesDescriptionCodeSequence => { GRP => "0008", ELEM => "103F", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             InstitutionalDepartmentName => { GRP => "0008", ELEM => "1040", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PhysiciansOfRecord => { GRP => "0008", ELEM => "1048", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                                PhysiciansOfRecordIdentificationSequence => { GRP => "0008", ELEM => "1049", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PerformingPhysicianName => { GRP => "0008", ELEM => "1050", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                               PerformingPhysicianIdentificationSequence => { GRP => "0008", ELEM => "1052", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            NameOfPhysiciansReadingStudy => { GRP => "0008", ELEM => "1060", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                            PhysiciansReadingStudyIdentificationSequence => { GRP => "0008", ELEM => "1062", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           OperatorsName => { GRP => "0008", ELEM => "1070", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                                          OperatorIdentificationSequence => { GRP => "0008", ELEM => "1072", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           AdmittingDiagnosesDescription => { GRP => "0008", ELEM => "1080", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                          AdmittingDiagnosesCodeSequence => { GRP => "0008", ELEM => "1084", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ManufacturerModelName => { GRP => "0008", ELEM => "1090", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReferencedStudySequence => { GRP => "0008", ELEM => "1110", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                ReferencedPerformedProcedureStepSequence => { GRP => "0008", ELEM => "1111", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ReferencedSeriesSequence => { GRP => "0008", ELEM => "1115", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferencedPatientSequence => { GRP => "0008", ELEM => "1120", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReferencedVisitSequence => { GRP => "0008", ELEM => "1125", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  ReferencedStereometricInstanceSequence => { GRP => "0008", ELEM => "1134", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              ReferencedWaveformSequence => { GRP => "0008", ELEM => "113A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReferencedImageSequence => { GRP => "0008", ELEM => "1140", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              ReferencedInstanceSequence => { GRP => "0008", ELEM => "114A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                         ReferencedRealWorldValueMappingInstanceSequence => { GRP => "0008", ELEM => "114B", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReferencedSOPClassUID => { GRP => "0008", ELEM => "1150", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                ReferencedSOPInstanceUID => { GRP => "0008", ELEM => "1155", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SOPClassesSupported => { GRP => "0008", ELEM => "115A", VR => "UI", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   ReferencedFrameNumber => { GRP => "0008", ELEM => "1160", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SimpleFrameList => { GRP => "0008", ELEM => "1161", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     CalculatedFrameList => { GRP => "0008", ELEM => "1162", VR => "UL", VM => "3-3n", VERSION =>  "DICOM_2009"},
                                                               TimeRange => { GRP => "0008", ELEM => "1163", VR => "FD", VM => "2", VERSION =>  "DICOM_2009"},
                                                 FrameExtractionSequence => { GRP => "0008", ELEM => "1164", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          MultiFrameSourceSOPInstanceUID => { GRP => "0008", ELEM => "1167", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                          TransactionUID => { GRP => "0008", ELEM => "1195", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                           FailureReason => { GRP => "0008", ELEM => "1197", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                       FailedSOPSequence => { GRP => "0008", ELEM => "1198", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReferencedSOPSequence => { GRP => "0008", ELEM => "1199", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                       StudiesContainingOtherReferencedInstancesSequence => { GRP => "0008", ELEM => "1200", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RelatedSeriesSequence => { GRP => "0008", ELEM => "1250", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   DerivationDescription => { GRP => "0008", ELEM => "2111", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SourceImageSequence => { GRP => "0008", ELEM => "2112", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                               StageName => { GRP => "0008", ELEM => "2120", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                             StageNumber => { GRP => "0008", ELEM => "2122", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          NumberOfStages => { GRP => "0008", ELEM => "2124", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                ViewName => { GRP => "0008", ELEM => "2127", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ViewNumber => { GRP => "0008", ELEM => "2128", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     NumberOfEventTimers => { GRP => "0008", ELEM => "2129", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    NumberOfViewsInStage => { GRP => "0008", ELEM => "212A", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EventElapsedTimes => { GRP => "0008", ELEM => "2130", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         EventTimerNames => { GRP => "0008", ELEM => "2132", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      EventTimerSequence => { GRP => "0008", ELEM => "2133", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         EventTimeOffset => { GRP => "0008", ELEM => "2134", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EventCodeSequence => { GRP => "0008", ELEM => "2135", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                               StartTrim => { GRP => "0008", ELEM => "2142", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                StopTrim => { GRP => "0008", ELEM => "2143", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             RecommendedDisplayFrameRate => { GRP => "0008", ELEM => "2144", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  AnatomicRegionSequence => { GRP => "0008", ELEM => "2218", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          AnatomicRegionModifierSequence => { GRP => "0008", ELEM => "2220", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        PrimaryAnatomicStructureSequence => { GRP => "0008", ELEM => "2228", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  AnatomicStructureSpaceOrRegionSequence => { GRP => "0008", ELEM => "2229", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                PrimaryAnatomicStructureModifierSequence => { GRP => "0008", ELEM => "2230", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         AlternateRepresentationSequence => { GRP => "0008", ELEM => "3001", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     IrradiationEventUID => { GRP => "0008", ELEM => "3010", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                               FrameType => { GRP => "0008", ELEM => "9007", VR => "CS", VM => "4", VERSION =>  "DICOM_2009"},
                                         ReferencedImageEvidenceSequence => { GRP => "0008", ELEM => "9092", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferencedRawDataSequence => { GRP => "0008", ELEM => "9121", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       CreatorVersionUID => { GRP => "0008", ELEM => "9123", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DerivationImageSequence => { GRP => "0008", ELEM => "9124", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             SourceImageEvidenceSequence => { GRP => "0008", ELEM => "9154", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PixelPresentation => { GRP => "0008", ELEM => "9205", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    VolumetricProperties => { GRP => "0008", ELEM => "9206", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         VolumeBasedCalculationTechnique => { GRP => "0008", ELEM => "9207", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ComplexImageComponent => { GRP => "0008", ELEM => "9208", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AcquisitionContrast => { GRP => "0008", ELEM => "9209", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DerivationCodeSequence => { GRP => "0008", ELEM => "9215", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     ReferencedPresentationStateSequence => { GRP => "0008", ELEM => "9237", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencedOtherPlaneSequence => { GRP => "0008", ELEM => "9410", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    FrameDisplaySequence => { GRP => "0008", ELEM => "9458", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      RecommendedDisplayFrameRateInFloat => { GRP => "0008", ELEM => "9459", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SkipFrameRangeFlag => { GRP => "0008", ELEM => "9460", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             PatientName => { GRP => "0010", ELEM => "0010", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                               PatientID => { GRP => "0010", ELEM => "0020", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       IssuerOfPatientID => { GRP => "0010", ELEM => "0021", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         TypeOfPatientID => { GRP => "0010", ELEM => "0022", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                     IssuerOfPatientIDQualifiersSequence => { GRP => "0010", ELEM => "0024", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PatientBirthDate => { GRP => "0010", ELEM => "0030", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PatientBirthTime => { GRP => "0010", ELEM => "0032", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                              PatientSex => { GRP => "0010", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        PatientInsurancePlanCodeSequence => { GRP => "0010", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      PatientPrimaryLanguageCodeSequence => { GRP => "0010", ELEM => "0101", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                              PatientPrimaryLanguageModifierCodeSequence => { GRP => "0010", ELEM => "0102", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         OtherPatientIDs => { GRP => "0010", ELEM => "1000", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       OtherPatientNames => { GRP => "0010", ELEM => "1001", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                 OtherPatientIDsSequence => { GRP => "0010", ELEM => "1002", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PatientBirthName => { GRP => "0010", ELEM => "1005", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                              PatientAge => { GRP => "0010", ELEM => "1010", VR => "AS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             PatientSize => { GRP => "0010", ELEM => "1020", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PatientWeight => { GRP => "0010", ELEM => "1030", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          PatientAddress => { GRP => "0010", ELEM => "1040", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PatientMotherBirthName => { GRP => "0010", ELEM => "1060", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                            MilitaryRank => { GRP => "0010", ELEM => "1080", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         BranchOfService => { GRP => "0010", ELEM => "1081", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                    MedicalRecordLocator => { GRP => "0010", ELEM => "1090", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                           MedicalAlerts => { GRP => "0010", ELEM => "2000", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                               Allergies => { GRP => "0010", ELEM => "2110", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      CountryOfResidence => { GRP => "0010", ELEM => "2150", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RegionOfResidence => { GRP => "0010", ELEM => "2152", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PatientTelephoneNumbers => { GRP => "0010", ELEM => "2154", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                             EthnicGroup => { GRP => "0010", ELEM => "2160", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                              Occupation => { GRP => "0010", ELEM => "2180", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SmokingStatus => { GRP => "0010", ELEM => "21A0", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                AdditionalPatientHistory => { GRP => "0010", ELEM => "21B0", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                         PregnancyStatus => { GRP => "0010", ELEM => "21C0", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                       LastMenstrualDate => { GRP => "0010", ELEM => "21D0", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                              PatientReligiousPreference => { GRP => "0010", ELEM => "21F0", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               PatientSpeciesDescription => { GRP => "0010", ELEM => "2201", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              PatientSpeciesCodeSequence => { GRP => "0010", ELEM => "2202", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PatientSexNeutered => { GRP => "0010", ELEM => "2203", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               AnatomicalOrientationType => { GRP => "0010", ELEM => "2210", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PatientBreedDescription => { GRP => "0010", ELEM => "2292", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                PatientBreedCodeSequence => { GRP => "0010", ELEM => "2293", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               BreedRegistrationSequence => { GRP => "0010", ELEM => "2294", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 BreedRegistrationNumber => { GRP => "0010", ELEM => "2295", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               BreedRegistryCodeSequence => { GRP => "0010", ELEM => "2296", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ResponsiblePerson => { GRP => "0010", ELEM => "2297", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ResponsiblePersonRole => { GRP => "0010", ELEM => "2298", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ResponsibleOrganization => { GRP => "0010", ELEM => "2299", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         PatientComments => { GRP => "0010", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ExaminedBodyThickness => { GRP => "0010", ELEM => "9431", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                ClinicalTrialSponsorName => { GRP => "0012", ELEM => "0010", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ClinicalTrialProtocolID => { GRP => "0012", ELEM => "0020", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               ClinicalTrialProtocolName => { GRP => "0012", ELEM => "0021", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ClinicalTrialSiteID => { GRP => "0012", ELEM => "0030", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ClinicalTrialSiteName => { GRP => "0012", ELEM => "0031", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ClinicalTrialSubjectID => { GRP => "0012", ELEM => "0040", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           ClinicalTrialSubjectReadingID => { GRP => "0012", ELEM => "0042", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                ClinicalTrialTimePointID => { GRP => "0012", ELEM => "0050", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                       ClinicalTrialTimePointDescription => { GRP => "0012", ELEM => "0051", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                     ClinicalTrialCoordinatingCenterName => { GRP => "0012", ELEM => "0060", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PatientIdentityRemoved => { GRP => "0012", ELEM => "0062", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DeidentificationMethod => { GRP => "0012", ELEM => "0063", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                      DeidentificationMethodCodeSequence => { GRP => "0012", ELEM => "0064", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ClinicalTrialSeriesID => { GRP => "0012", ELEM => "0071", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          ClinicalTrialSeriesDescription => { GRP => "0012", ELEM => "0072", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                ClinicalTrialProtocolEthicsCommitteeName => { GRP => "0012", ELEM => "0081", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                      ClinicalTrialProtocolEthicsCommitteeApprovalNumber => { GRP => "0012", ELEM => "0082", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                      ConsentForClinicalTrialUseSequence => { GRP => "0012", ELEM => "0083", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DistributionType => { GRP => "0012", ELEM => "0084", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              ConsentForDistributionFlag => { GRP => "0012", ELEM => "0085", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ContrastBolusAgent => { GRP => "0018", ELEM => "0010", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              ContrastBolusAgentSequence => { GRP => "0018", ELEM => "0012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                ContrastBolusAdministrationRouteSequence => { GRP => "0018", ELEM => "0014", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BodyPartExamined => { GRP => "0018", ELEM => "0015", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ScanningSequence => { GRP => "0018", ELEM => "0020", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SequenceVariant => { GRP => "0018", ELEM => "0021", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                             ScanOptions => { GRP => "0018", ELEM => "0022", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       MRAcquisitionType => { GRP => "0018", ELEM => "0023", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            SequenceName => { GRP => "0018", ELEM => "0024", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                               AngioFlag => { GRP => "0018", ELEM => "0025", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                     InterventionDrugInformationSequence => { GRP => "0018", ELEM => "0026", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                InterventionDrugStopTime => { GRP => "0018", ELEM => "0027", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                    InterventionDrugDose => { GRP => "0018", ELEM => "0028", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            InterventionDrugCodeSequence => { GRP => "0018", ELEM => "0029", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  AdditionalDrugSequence => { GRP => "0018", ELEM => "002A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     Radiopharmaceutical => { GRP => "0018", ELEM => "0031", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                    InterventionDrugName => { GRP => "0018", ELEM => "0034", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               InterventionDrugStartTime => { GRP => "0018", ELEM => "0035", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                    InterventionSequence => { GRP => "0018", ELEM => "0036", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      InterventionStatus => { GRP => "0018", ELEM => "0038", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 InterventionDescription => { GRP => "0018", ELEM => "003A", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                                CineRate => { GRP => "0018", ELEM => "0040", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     InitialCineRunState => { GRP => "0018", ELEM => "0042", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          SliceThickness => { GRP => "0018", ELEM => "0050", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                     KVP => { GRP => "0018", ELEM => "0060", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       CountsAccumulated => { GRP => "0018", ELEM => "0070", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                         AcquisitionTerminationCondition => { GRP => "0018", ELEM => "0071", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EffectiveDuration => { GRP => "0018", ELEM => "0072", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                               AcquisitionStartCondition => { GRP => "0018", ELEM => "0073", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           AcquisitionStartConditionData => { GRP => "0018", ELEM => "0074", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                     AcquisitionTerminationConditionData => { GRP => "0018", ELEM => "0075", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          RepetitionTime => { GRP => "0018", ELEM => "0080", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                EchoTime => { GRP => "0018", ELEM => "0081", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           InversionTime => { GRP => "0018", ELEM => "0082", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        NumberOfAverages => { GRP => "0018", ELEM => "0083", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ImagingFrequency => { GRP => "0018", ELEM => "0084", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ImagedNucleus => { GRP => "0018", ELEM => "0085", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                             EchoNumbers => { GRP => "0018", ELEM => "0086", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   MagneticFieldStrength => { GRP => "0018", ELEM => "0087", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SpacingBetweenSlices => { GRP => "0018", ELEM => "0088", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              NumberOfPhaseEncodingSteps => { GRP => "0018", ELEM => "0089", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DataCollectionDiameter => { GRP => "0018", ELEM => "0090", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         EchoTrainLength => { GRP => "0018", ELEM => "0091", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         PercentSampling => { GRP => "0018", ELEM => "0093", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PercentPhaseFieldOfView => { GRP => "0018", ELEM => "0094", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          PixelBandwidth => { GRP => "0018", ELEM => "0095", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DeviceSerialNumber => { GRP => "0018", ELEM => "1000", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                               DeviceUID => { GRP => "0018", ELEM => "1002", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                                DeviceID => { GRP => "0018", ELEM => "1003", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 PlateID => { GRP => "0018", ELEM => "1004", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                             GeneratorID => { GRP => "0018", ELEM => "1005", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                                  GridID => { GRP => "0018", ELEM => "1006", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                              CassetteID => { GRP => "0018", ELEM => "1007", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                                GantryID => { GRP => "0018", ELEM => "1008", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                SecondaryCaptureDeviceID => { GRP => "0018", ELEM => "1010", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DateOfSecondaryCapture => { GRP => "0018", ELEM => "1012", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TimeOfSecondaryCapture => { GRP => "0018", ELEM => "1014", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                      SecondaryCaptureDeviceManufacturer => { GRP => "0018", ELEM => "1016", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                             SecondaryCaptureDeviceManufacturerModelName => { GRP => "0018", ELEM => "1018", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                  SecondaryCaptureDeviceSoftwareVersions => { GRP => "0018", ELEM => "1019", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                        SoftwareVersions => { GRP => "0018", ELEM => "1020", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                VideoImageFormatAcquired => { GRP => "0018", ELEM => "1022", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                              DigitalImageFormatAcquired => { GRP => "0018", ELEM => "1023", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ProtocolName => { GRP => "0018", ELEM => "1030", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ContrastBolusRoute => { GRP => "0018", ELEM => "1040", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ContrastBolusVolume => { GRP => "0018", ELEM => "1041", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ContrastBolusStartTime => { GRP => "0018", ELEM => "1042", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ContrastBolusStopTime => { GRP => "0018", ELEM => "1043", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ContrastBolusTotalDose => { GRP => "0018", ELEM => "1044", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SyringeCounts => { GRP => "0018", ELEM => "1045", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ContrastFlowRate => { GRP => "0018", ELEM => "1046", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    ContrastFlowDuration => { GRP => "0018", ELEM => "1047", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                 ContrastBolusIngredient => { GRP => "0018", ELEM => "1048", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                    ContrastBolusIngredientConcentration => { GRP => "0018", ELEM => "1049", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SpatialResolution => { GRP => "0018", ELEM => "1050", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             TriggerTime => { GRP => "0018", ELEM => "1060", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     TriggerSourceOrType => { GRP => "0018", ELEM => "1061", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         NominalInterval => { GRP => "0018", ELEM => "1062", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               FrameTime => { GRP => "0018", ELEM => "1063", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CardiacFramingType => { GRP => "0018", ELEM => "1064", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         FrameTimeVector => { GRP => "0018", ELEM => "1065", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                              FrameDelay => { GRP => "0018", ELEM => "1066", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ImageTriggerDelay => { GRP => "0018", ELEM => "1067", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                MultiplexGroupTimeOffset => { GRP => "0018", ELEM => "1068", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TriggerTimeOffset => { GRP => "0018", ELEM => "1069", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SynchronizationTrigger => { GRP => "0018", ELEM => "106A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SynchronizationChannel => { GRP => "0018", ELEM => "106C", VR => "US", VM => "2", VERSION =>  "DICOM_2009"},
                                                   TriggerSamplePosition => { GRP => "0018", ELEM => "106E", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                RadiopharmaceuticalRoute => { GRP => "0018", ELEM => "1070", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               RadiopharmaceuticalVolume => { GRP => "0018", ELEM => "1071", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            RadiopharmaceuticalStartTime => { GRP => "0018", ELEM => "1072", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                             RadiopharmaceuticalStopTime => { GRP => "0018", ELEM => "1073", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RadionuclideTotalDose => { GRP => "0018", ELEM => "1074", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RadionuclideHalfLife => { GRP => "0018", ELEM => "1075", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            RadionuclidePositronFraction => { GRP => "0018", ELEM => "1076", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                     RadiopharmaceuticalSpecificActivity => { GRP => "0018", ELEM => "1077", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        RadiopharmaceuticalStartDateTime => { GRP => "0018", ELEM => "1078", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                         RadiopharmaceuticalStopDateTime => { GRP => "0018", ELEM => "1079", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                       BeatRejectionFlag => { GRP => "0018", ELEM => "1080", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              LowRRValue => { GRP => "0018", ELEM => "1081", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             HighRRValue => { GRP => "0018", ELEM => "1082", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       IntervalsAcquired => { GRP => "0018", ELEM => "1083", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       IntervalsRejected => { GRP => "0018", ELEM => "1084", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            PVCRejection => { GRP => "0018", ELEM => "1085", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                               SkipBeats => { GRP => "0018", ELEM => "1086", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               HeartRate => { GRP => "0018", ELEM => "1088", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   CardiacNumberOfImages => { GRP => "0018", ELEM => "1090", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TriggerWindow => { GRP => "0018", ELEM => "1094", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ReconstructionDiameter => { GRP => "0018", ELEM => "1100", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                DistanceSourceToDetector => { GRP => "0018", ELEM => "1110", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DistanceSourceToPatient => { GRP => "0018", ELEM => "1111", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                EstimatedRadiographicMagnificationFactor => { GRP => "0018", ELEM => "1114", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      GantryDetectorTilt => { GRP => "0018", ELEM => "1120", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      GantryDetectorSlew => { GRP => "0018", ELEM => "1121", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             TableHeight => { GRP => "0018", ELEM => "1130", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TableTraverse => { GRP => "0018", ELEM => "1131", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             TableMotion => { GRP => "0018", ELEM => "1134", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TableVerticalIncrement => { GRP => "0018", ELEM => "1135", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   TableLateralIncrement => { GRP => "0018", ELEM => "1136", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                              TableLongitudinalIncrement => { GRP => "0018", ELEM => "1137", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                              TableAngle => { GRP => "0018", ELEM => "1138", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               TableType => { GRP => "0018", ELEM => "113A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RotationDirection => { GRP => "0018", ELEM => "1140", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          RadialPosition => { GRP => "0018", ELEM => "1142", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                                 ScanArc => { GRP => "0018", ELEM => "1143", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             AngularStep => { GRP => "0018", ELEM => "1144", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CenterOfRotationOffset => { GRP => "0018", ELEM => "1145", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FieldOfViewShape => { GRP => "0018", ELEM => "1147", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   FieldOfViewDimensions => { GRP => "0018", ELEM => "1149", VR => "IS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                            ExposureTime => { GRP => "0018", ELEM => "1150", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         XRayTubeCurrent => { GRP => "0018", ELEM => "1151", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Exposure => { GRP => "0018", ELEM => "1152", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ExposureInuAs => { GRP => "0018", ELEM => "1153", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       AveragePulseWidth => { GRP => "0018", ELEM => "1154", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        RadiationSetting => { GRP => "0018", ELEM => "1155", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RectificationType => { GRP => "0018", ELEM => "1156", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           RadiationMode => { GRP => "0018", ELEM => "115A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                      ImageAndFluoroscopyAreaDoseProduct => { GRP => "0018", ELEM => "115E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              FilterType => { GRP => "0018", ELEM => "1160", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TypeOfFilters => { GRP => "0018", ELEM => "1161", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         IntensifierSize => { GRP => "0018", ELEM => "1162", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ImagerPixelSpacing => { GRP => "0018", ELEM => "1164", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                                    Grid => { GRP => "0018", ELEM => "1166", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          GeneratorPower => { GRP => "0018", ELEM => "1170", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CollimatorGridName => { GRP => "0018", ELEM => "1180", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                          CollimatorType => { GRP => "0018", ELEM => "1181", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           FocalDistance => { GRP => "0018", ELEM => "1182", VR => "IS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                            XFocusCenter => { GRP => "0018", ELEM => "1183", VR => "DS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                            YFocusCenter => { GRP => "0018", ELEM => "1184", VR => "DS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                              FocalSpots => { GRP => "0018", ELEM => "1190", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     AnodeTargetMaterial => { GRP => "0018", ELEM => "1191", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       BodyPartThickness => { GRP => "0018", ELEM => "11A0", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        CompressionForce => { GRP => "0018", ELEM => "11A2", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   DateOfLastCalibration => { GRP => "0018", ELEM => "1200", VR => "DA", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   TimeOfLastCalibration => { GRP => "0018", ELEM => "1201", VR => "TM", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       ConvolutionKernel => { GRP => "0018", ELEM => "1210", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     ActualFrameDuration => { GRP => "0018", ELEM => "1242", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               CountRate => { GRP => "0018", ELEM => "1243", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             PreferredPlaybackSequencing => { GRP => "0018", ELEM => "1244", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ReceiveCoilName => { GRP => "0018", ELEM => "1250", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                        TransmitCoilName => { GRP => "0018", ELEM => "1251", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                               PlateType => { GRP => "0018", ELEM => "1260", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                            PhosphorType => { GRP => "0018", ELEM => "1261", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ScanVelocity => { GRP => "0018", ELEM => "1300", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      WholeBodyTechnique => { GRP => "0018", ELEM => "1301", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                              ScanLength => { GRP => "0018", ELEM => "1302", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       AcquisitionMatrix => { GRP => "0018", ELEM => "1310", VR => "US", VM => "4", VERSION =>  "DICOM_2009"},
                                           InPlanePhaseEncodingDirection => { GRP => "0018", ELEM => "1312", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               FlipAngle => { GRP => "0018", ELEM => "1314", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   VariableFlipAngleFlag => { GRP => "0018", ELEM => "1315", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                     SAR => { GRP => "0018", ELEM => "1316", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                    dBdt => { GRP => "0018", ELEM => "1318", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                  AcquisitionDeviceProcessingDescription => { GRP => "0018", ELEM => "1400", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         AcquisitionDeviceProcessingCode => { GRP => "0018", ELEM => "1401", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CassetteOrientation => { GRP => "0018", ELEM => "1402", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            CassetteSize => { GRP => "0018", ELEM => "1403", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ExposuresOnPlate => { GRP => "0018", ELEM => "1404", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RelativeXRayExposure => { GRP => "0018", ELEM => "1405", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ColumnAngulation => { GRP => "0018", ELEM => "1450", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         TomoLayerHeight => { GRP => "0018", ELEM => "1460", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               TomoAngle => { GRP => "0018", ELEM => "1470", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                TomoTime => { GRP => "0018", ELEM => "1480", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                TomoType => { GRP => "0018", ELEM => "1490", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               TomoClass => { GRP => "0018", ELEM => "1491", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       NumberOfTomosynthesisSourceImages => { GRP => "0018", ELEM => "1495", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PositionerMotion => { GRP => "0018", ELEM => "1500", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          PositionerType => { GRP => "0018", ELEM => "1508", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PositionerPrimaryAngle => { GRP => "0018", ELEM => "1510", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                PositionerSecondaryAngle => { GRP => "0018", ELEM => "1511", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         PositionerPrimaryAngleIncrement => { GRP => "0018", ELEM => "1520", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                       PositionerSecondaryAngleIncrement => { GRP => "0018", ELEM => "1521", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    DetectorPrimaryAngle => { GRP => "0018", ELEM => "1530", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DetectorSecondaryAngle => { GRP => "0018", ELEM => "1531", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ShutterShape => { GRP => "0018", ELEM => "1600", VR => "CS", VM => "1-3", VERSION =>  "DICOM_2009"},
                                                 ShutterLeftVerticalEdge => { GRP => "0018", ELEM => "1602", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                ShutterRightVerticalEdge => { GRP => "0018", ELEM => "1604", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              ShutterUpperHorizontalEdge => { GRP => "0018", ELEM => "1606", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              ShutterLowerHorizontalEdge => { GRP => "0018", ELEM => "1608", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CenterOfCircularShutter => { GRP => "0018", ELEM => "1610", VR => "IS", VM => "2", VERSION =>  "DICOM_2009"},
                                                 RadiusOfCircularShutter => { GRP => "0018", ELEM => "1612", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           VerticesOfThePolygonalShutter => { GRP => "0018", ELEM => "1620", VR => "IS", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                ShutterPresentationValue => { GRP => "0018", ELEM => "1622", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ShutterOverlayGroup => { GRP => "0018", ELEM => "1623", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                     ShutterPresentationColorCIELabValue => { GRP => "0018", ELEM => "1624", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                                         CollimatorShape => { GRP => "0018", ELEM => "1700", VR => "CS", VM => "1-3", VERSION =>  "DICOM_2009"},
                                              CollimatorLeftVerticalEdge => { GRP => "0018", ELEM => "1702", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             CollimatorRightVerticalEdge => { GRP => "0018", ELEM => "1704", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           CollimatorUpperHorizontalEdge => { GRP => "0018", ELEM => "1706", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           CollimatorLowerHorizontalEdge => { GRP => "0018", ELEM => "1708", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              CenterOfCircularCollimator => { GRP => "0018", ELEM => "1710", VR => "IS", VM => "2", VERSION =>  "DICOM_2009"},
                                              RadiusOfCircularCollimator => { GRP => "0018", ELEM => "1712", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                        VerticesOfThePolygonalCollimator => { GRP => "0018", ELEM => "1720", VR => "IS", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                             AcquisitionTimeSynchronized => { GRP => "0018", ELEM => "1800", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              TimeSource => { GRP => "0018", ELEM => "1801", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                TimeDistributionProtocol => { GRP => "0018", ELEM => "1802", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        NTPSourceAddress => { GRP => "0018", ELEM => "1803", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PageNumberVector => { GRP => "0018", ELEM => "2001", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                        FrameLabelVector => { GRP => "0018", ELEM => "2002", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                 FramePrimaryAngleVector => { GRP => "0018", ELEM => "2003", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                               FrameSecondaryAngleVector => { GRP => "0018", ELEM => "2004", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     SliceLocationVector => { GRP => "0018", ELEM => "2005", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                DisplayWindowLabelVector => { GRP => "0018", ELEM => "2006", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                              NominalScannedPixelSpacing => { GRP => "0018", ELEM => "2010", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                      DigitizingDeviceTransportDirection => { GRP => "0018", ELEM => "2020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RotationOfScannedFilm => { GRP => "0018", ELEM => "2030", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         IVUSAcquisition => { GRP => "0018", ELEM => "3100", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        IVUSPullbackRate => { GRP => "0018", ELEM => "3101", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           IVUSGatedRate => { GRP => "0018", ELEM => "3102", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            IVUSPullbackStartFrameNumber => { GRP => "0018", ELEM => "3103", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             IVUSPullbackStopFrameNumber => { GRP => "0018", ELEM => "3104", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            LesionNumber => { GRP => "0018", ELEM => "3105", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                             OutputPower => { GRP => "0018", ELEM => "5000", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          TransducerData => { GRP => "0018", ELEM => "5010", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                              FocusDepth => { GRP => "0018", ELEM => "5012", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ProcessingFunction => { GRP => "0018", ELEM => "5020", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         MechanicalIndex => { GRP => "0018", ELEM => "5022", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BoneThermalIndex => { GRP => "0018", ELEM => "5024", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CranialThermalIndex => { GRP => "0018", ELEM => "5026", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SoftTissueThermalIndex => { GRP => "0018", ELEM => "5027", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                             SoftTissueFocusThermalIndex => { GRP => "0018", ELEM => "5028", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           SoftTissueSurfaceThermalIndex => { GRP => "0018", ELEM => "5029", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DepthOfScanField => { GRP => "0018", ELEM => "5050", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         PatientPosition => { GRP => "0018", ELEM => "5100", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ViewPosition => { GRP => "0018", ELEM => "5101", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                     ProjectionEponymousNameCodeSequence => { GRP => "0018", ELEM => "5104", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             Sensitivity => { GRP => "0018", ELEM => "6000", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                             SequenceOfUltrasoundRegions => { GRP => "0018", ELEM => "6011", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RegionSpatialFormat => { GRP => "0018", ELEM => "6012", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                          RegionDataType => { GRP => "0018", ELEM => "6014", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                             RegionFlags => { GRP => "0018", ELEM => "6016", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RegionLocationMinX0 => { GRP => "0018", ELEM => "6018", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RegionLocationMinY0 => { GRP => "0018", ELEM => "601A", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RegionLocationMaxX1 => { GRP => "0018", ELEM => "601C", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RegionLocationMaxY1 => { GRP => "0018", ELEM => "601E", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ReferencePixelX0 => { GRP => "0018", ELEM => "6020", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ReferencePixelY0 => { GRP => "0018", ELEM => "6022", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PhysicalUnitsXDirection => { GRP => "0018", ELEM => "6024", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PhysicalUnitsYDirection => { GRP => "0018", ELEM => "6026", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencePixelPhysicalValueX => { GRP => "0018", ELEM => "6028", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencePixelPhysicalValueY => { GRP => "0018", ELEM => "602A", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                          PhysicalDeltaX => { GRP => "0018", ELEM => "602C", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                          PhysicalDeltaY => { GRP => "0018", ELEM => "602E", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                     TransducerFrequency => { GRP => "0018", ELEM => "6030", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                          TransducerType => { GRP => "0018", ELEM => "6031", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                PulseRepetitionFrequency => { GRP => "0018", ELEM => "6032", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DopplerCorrectionAngle => { GRP => "0018", ELEM => "6034", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SteeringAngle => { GRP => "0018", ELEM => "6036", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                            DopplerSampleVolumeXPosition => { GRP => "0018", ELEM => "6039", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                            DopplerSampleVolumeYPosition => { GRP => "0018", ELEM => "603B", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        TMLinePositionX0 => { GRP => "0018", ELEM => "603D", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        TMLinePositionY0 => { GRP => "0018", ELEM => "603F", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        TMLinePositionX1 => { GRP => "0018", ELEM => "6041", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        TMLinePositionY1 => { GRP => "0018", ELEM => "6043", VR => "SL", VM => "1", VERSION =>  "DICOM_2009"},
                                              PixelComponentOrganization => { GRP => "0018", ELEM => "6044", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PixelComponentMask => { GRP => "0018", ELEM => "6046", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                PixelComponentRangeStart => { GRP => "0018", ELEM => "6048", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PixelComponentRangeStop => { GRP => "0018", ELEM => "604A", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                             PixelComponentPhysicalUnits => { GRP => "0018", ELEM => "604C", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PixelComponentDataType => { GRP => "0018", ELEM => "604E", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                NumberOfTableBreakPoints => { GRP => "0018", ELEM => "6050", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     TableOfXBreakPoints => { GRP => "0018", ELEM => "6052", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     TableOfYBreakPoints => { GRP => "0018", ELEM => "6054", VR => "FD", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    NumberOfTableEntries => { GRP => "0018", ELEM => "6056", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TableOfPixelValues => { GRP => "0018", ELEM => "6058", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                  TableOfParameterValues => { GRP => "0018", ELEM => "605A", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         RWaveTimeVector => { GRP => "0018", ELEM => "6060", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                           DetectorConditionsNominalFlag => { GRP => "0018", ELEM => "7000", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DetectorTemperature => { GRP => "0018", ELEM => "7001", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            DetectorType => { GRP => "0018", ELEM => "7004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   DetectorConfiguration => { GRP => "0018", ELEM => "7005", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DetectorDescription => { GRP => "0018", ELEM => "7006", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                            DetectorMode => { GRP => "0018", ELEM => "7008", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                              DetectorID => { GRP => "0018", ELEM => "700A", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                           DateOfLastDetectorCalibration => { GRP => "0018", ELEM => "700C", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                           TimeOfLastDetectorCalibration => { GRP => "0018", ELEM => "700E", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                 ExposuresOnDetectorSinceLastCalibration => { GRP => "0018", ELEM => "7010", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                    ExposuresOnDetectorSinceManufactured => { GRP => "0018", ELEM => "7011", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           DetectorTimeSinceLastExposure => { GRP => "0018", ELEM => "7012", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DetectorActiveTime => { GRP => "0018", ELEM => "7014", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                    DetectorActivationOffsetFromExposure => { GRP => "0018", ELEM => "7016", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         DetectorBinning => { GRP => "0018", ELEM => "701A", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                             DetectorElementPhysicalSize => { GRP => "0018", ELEM => "7020", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                  DetectorElementSpacing => { GRP => "0018", ELEM => "7022", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                     DetectorActiveShape => { GRP => "0018", ELEM => "7024", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                DetectorActiveDimensions => { GRP => "0018", ELEM => "7026", VR => "DS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                    DetectorActiveOrigin => { GRP => "0018", ELEM => "7028", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                DetectorManufacturerName => { GRP => "0018", ELEM => "702A", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           DetectorManufacturerModelName => { GRP => "0018", ELEM => "702B", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       FieldOfViewOrigin => { GRP => "0018", ELEM => "7030", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                     FieldOfViewRotation => { GRP => "0018", ELEM => "7032", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                               FieldOfViewHorizontalFlip => { GRP => "0018", ELEM => "7034", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   GridAbsorbingMaterial => { GRP => "0018", ELEM => "7040", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     GridSpacingMaterial => { GRP => "0018", ELEM => "7041", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                           GridThickness => { GRP => "0018", ELEM => "7042", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               GridPitch => { GRP => "0018", ELEM => "7044", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         GridAspectRatio => { GRP => "0018", ELEM => "7046", VR => "IS", VM => "2", VERSION =>  "DICOM_2009"},
                                                              GridPeriod => { GRP => "0018", ELEM => "7048", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       GridFocalDistance => { GRP => "0018", ELEM => "704C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          FilterMaterial => { GRP => "0018", ELEM => "7050", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                  FilterThicknessMinimum => { GRP => "0018", ELEM => "7052", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                  FilterThicknessMaximum => { GRP => "0018", ELEM => "7054", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                             FilterBeamPathLengthMinimum => { GRP => "0018", ELEM => "7056", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                             FilterBeamPathLengthMaximum => { GRP => "0018", ELEM => "7058", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     ExposureControlMode => { GRP => "0018", ELEM => "7060", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ExposureControlModeDescription => { GRP => "0018", ELEM => "7062", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ExposureStatus => { GRP => "0018", ELEM => "7064", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PhototimerSetting => { GRP => "0018", ELEM => "7065", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ExposureTimeInuS => { GRP => "0018", ELEM => "8150", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     XRayTubeCurrentInuA => { GRP => "0018", ELEM => "8151", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContentQualification => { GRP => "0018", ELEM => "9004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PulseSequenceName => { GRP => "0018", ELEM => "9005", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                               MRImagingModifierSequence => { GRP => "0018", ELEM => "9006", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EchoPulseSequence => { GRP => "0018", ELEM => "9008", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       InversionRecovery => { GRP => "0018", ELEM => "9009", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FlowCompensation => { GRP => "0018", ELEM => "9010", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        MultipleSpinEcho => { GRP => "0018", ELEM => "9011", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MultiPlanarExcitation => { GRP => "0018", ELEM => "9012", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PhaseContrast => { GRP => "0018", ELEM => "9014", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TimeOfFlightContrast => { GRP => "0018", ELEM => "9015", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Spoiling => { GRP => "0018", ELEM => "9016", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                SteadyStatePulseSequence => { GRP => "0018", ELEM => "9017", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 EchoPlanarPulseSequence => { GRP => "0018", ELEM => "9018", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TagAngleFirstAxis => { GRP => "0018", ELEM => "9019", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MagnetizationTransfer => { GRP => "0018", ELEM => "9020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           T2Preparation => { GRP => "0018", ELEM => "9021", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      BloodSignalNulling => { GRP => "0018", ELEM => "9022", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SaturationRecovery => { GRP => "0018", ELEM => "9024", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           SpectrallySelectedSuppression => { GRP => "0018", ELEM => "9025", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            SpectrallySelectedExcitation => { GRP => "0018", ELEM => "9026", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SpatialPresaturation => { GRP => "0018", ELEM => "9027", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 Tagging => { GRP => "0018", ELEM => "9028", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       OversamplingPhase => { GRP => "0018", ELEM => "9029", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                TagSpacingFirstDimension => { GRP => "0018", ELEM => "9030", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                               GeometryOfKSpaceTraversal => { GRP => "0018", ELEM => "9032", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                SegmentedKSpaceTraversal => { GRP => "0018", ELEM => "9033", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        RectilinearPhaseEncodeReordering => { GRP => "0018", ELEM => "9034", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            TagThickness => { GRP => "0018", ELEM => "9035", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PartialFourierDirection => { GRP => "0018", ELEM => "9036", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         CardiacSynchronizationTechnique => { GRP => "0018", ELEM => "9037", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             ReceiveCoilManufacturerName => { GRP => "0018", ELEM => "9041", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MRReceiveCoilSequence => { GRP => "0018", ELEM => "9042", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ReceiveCoilType => { GRP => "0018", ELEM => "9043", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   QuadratureReceiveCoil => { GRP => "0018", ELEM => "9044", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             MultiCoilDefinitionSequence => { GRP => "0018", ELEM => "9045", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  MultiCoilConfiguration => { GRP => "0018", ELEM => "9046", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                    MultiCoilElementName => { GRP => "0018", ELEM => "9047", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                    MultiCoilElementUsed => { GRP => "0018", ELEM => "9048", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  MRTransmitCoilSequence => { GRP => "0018", ELEM => "9049", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            TransmitCoilManufacturerName => { GRP => "0018", ELEM => "9050", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                        TransmitCoilType => { GRP => "0018", ELEM => "9051", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SpectralWidth => { GRP => "0018", ELEM => "9052", VR => "FD", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                  ChemicalShiftReference => { GRP => "0018", ELEM => "9053", VR => "FD", VM => "1-2", VERSION =>  "DICOM_2009"},
                                             VolumeLocalizationTechnique => { GRP => "0018", ELEM => "9054", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                     MRAcquisitionFrequencyEncodingSteps => { GRP => "0018", ELEM => "9058", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                              Decoupling => { GRP => "0018", ELEM => "9059", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DecoupledNucleus => { GRP => "0018", ELEM => "9060", VR => "CS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                     DecouplingFrequency => { GRP => "0018", ELEM => "9061", VR => "FD", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                        DecouplingMethod => { GRP => "0018", ELEM => "9062", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        DecouplingChemicalShiftReference => { GRP => "0018", ELEM => "9063", VR => "FD", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                         KSpaceFiltering => { GRP => "0018", ELEM => "9064", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     TimeDomainFiltering => { GRP => "0018", ELEM => "9065", VR => "CS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                       NumberOfZeroFills => { GRP => "0018", ELEM => "9066", VR => "US", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                      BaselineCorrection => { GRP => "0018", ELEM => "9067", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ParallelReductionFactorInPlane => { GRP => "0018", ELEM => "9069", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                              CardiacRRIntervalSpecified => { GRP => "0018", ELEM => "9070", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AcquisitionDuration => { GRP => "0018", ELEM => "9073", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                FrameAcquisitionDateTime => { GRP => "0018", ELEM => "9074", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DiffusionDirectionality => { GRP => "0018", ELEM => "9075", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                      DiffusionGradientDirectionSequence => { GRP => "0018", ELEM => "9076", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ParallelAcquisition => { GRP => "0018", ELEM => "9077", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            ParallelAcquisitionTechnique => { GRP => "0018", ELEM => "9078", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          InversionTimes => { GRP => "0018", ELEM => "9079", VR => "FD", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                MetaboliteMapDescription => { GRP => "0018", ELEM => "9080", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                          PartialFourier => { GRP => "0018", ELEM => "9081", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EffectiveEchoTime => { GRP => "0018", ELEM => "9082", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                               MetaboliteMapCodeSequence => { GRP => "0018", ELEM => "9083", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ChemicalShiftSequence => { GRP => "0018", ELEM => "9084", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CardiacSignalSource => { GRP => "0018", ELEM => "9085", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         DiffusionBValue => { GRP => "0018", ELEM => "9087", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                            DiffusionGradientOrientation => { GRP => "0018", ELEM => "9089", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                               VelocityEncodingDirection => { GRP => "0018", ELEM => "9090", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                            VelocityEncodingMinimumValue => { GRP => "0018", ELEM => "9091", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                              NumberOfKSpaceTrajectories => { GRP => "0018", ELEM => "9093", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                        CoverageOfKSpace => { GRP => "0018", ELEM => "9094", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        SpectroscopyAcquisitionPhaseRows => { GRP => "0018", ELEM => "9095", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TransmitterFrequency => { GRP => "0018", ELEM => "9098", VR => "FD", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                         ResonantNucleus => { GRP => "0018", ELEM => "9100", VR => "CS", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                     FrequencyCorrection => { GRP => "0018", ELEM => "9101", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       MRSpectroscopyFOVGeometrySequence => { GRP => "0018", ELEM => "9103", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SlabThickness => { GRP => "0018", ELEM => "9104", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SlabOrientation => { GRP => "0018", ELEM => "9105", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                                         MidSlabPosition => { GRP => "0018", ELEM => "9106", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                             MRSpatialSaturationSequence => { GRP => "0018", ELEM => "9107", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    MRTimingAndRelatedParametersSequence => { GRP => "0018", ELEM => "9112", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          MREchoSequence => { GRP => "0018", ELEM => "9114", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      MRModifierSequence => { GRP => "0018", ELEM => "9115", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     MRDiffusionSequence => { GRP => "0018", ELEM => "9117", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          CardiacSynchronizationSequence => { GRP => "0018", ELEM => "9118", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      MRAveragesSequence => { GRP => "0018", ELEM => "9119", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MRFOVGeometrySequence => { GRP => "0018", ELEM => "9125", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              VolumeLocalizationSequence => { GRP => "0018", ELEM => "9126", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      SpectroscopyAcquisitionDataColumns => { GRP => "0018", ELEM => "9127", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DiffusionAnisotropyType => { GRP => "0018", ELEM => "9147", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FrameReferenceDateTime => { GRP => "0018", ELEM => "9151", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                 MRMetaboliteMapSequence => { GRP => "0018", ELEM => "9152", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       ParallelReductionFactorOutOfPlane => { GRP => "0018", ELEM => "9155", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                             SpectroscopyAcquisitionOutOfPlanePhaseSteps => { GRP => "0018", ELEM => "9159", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                    ParallelReductionFactorSecondInPlane => { GRP => "0018", ELEM => "9168", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                           CardiacBeatRejectionTechnique => { GRP => "0018", ELEM => "9169", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                  RespiratoryMotionCompensationTechnique => { GRP => "0018", ELEM => "9170", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RespiratorySignalSource => { GRP => "0018", ELEM => "9171", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         BulkMotionCompensationTechnique => { GRP => "0018", ELEM => "9172", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  BulkMotionSignalSource => { GRP => "0018", ELEM => "9173", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ApplicableSafetyStandardAgency => { GRP => "0018", ELEM => "9174", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                     ApplicableSafetyStandardDescription => { GRP => "0018", ELEM => "9175", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                   OperatingModeSequence => { GRP => "0018", ELEM => "9176", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       OperatingModeType => { GRP => "0018", ELEM => "9177", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           OperatingMode => { GRP => "0018", ELEM => "9178", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        SpecificAbsorptionRateDefinition => { GRP => "0018", ELEM => "9179", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      GradientOutputType => { GRP => "0018", ELEM => "9180", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             SpecificAbsorptionRateValue => { GRP => "0018", ELEM => "9181", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                          GradientOutput => { GRP => "0018", ELEM => "9182", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                               FlowCompensationDirection => { GRP => "0018", ELEM => "9183", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            TaggingDelay => { GRP => "0018", ELEM => "9184", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                       RespiratoryMotionCompensationTechniqueDescription => { GRP => "0018", ELEM => "9185", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                               RespiratorySignalSourceID => { GRP => "0018", ELEM => "9186", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                              MRVelocityEncodingSequence => { GRP => "0018", ELEM => "9197", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               FirstOrderPhaseCorrection => { GRP => "0018", ELEM => "9198", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          WaterReferencedPhaseCorrection => { GRP => "0018", ELEM => "9199", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           MRSpectroscopyAcquisitionType => { GRP => "0018", ELEM => "9200", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                RespiratoryCyclePosition => { GRP => "0018", ELEM => "9214", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            VelocityEncodingMaximumValue => { GRP => "0018", ELEM => "9217", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                               TagSpacingSecondDimension => { GRP => "0018", ELEM => "9218", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TagAngleSecondAxis => { GRP => "0018", ELEM => "9219", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                                                FrameAcquisitionDuration => { GRP => "0018", ELEM => "9220", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                MRImageFrameTypeSequence => { GRP => "0018", ELEM => "9226", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         MRSpectroscopyFrameTypeSequence => { GRP => "0018", ELEM => "9227", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  MRAcquisitionPhaseEncodingStepsInPlane => { GRP => "0018", ELEM => "9231", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                               MRAcquisitionPhaseEncodingStepsOutOfPlane => { GRP => "0018", ELEM => "9232", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                     SpectroscopyAcquisitionPhaseColumns => { GRP => "0018", ELEM => "9234", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    CardiacCyclePosition => { GRP => "0018", ELEM => "9236", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          SpecificAbsorptionRateSequence => { GRP => "0018", ELEM => "9239", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RFEchoTrainLength => { GRP => "0018", ELEM => "9240", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 GradientEchoTrainLength => { GRP => "0018", ELEM => "9241", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                               ChemicalShiftMinimumIntegrationLimitInppm => { GRP => "0018", ELEM => "9295", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                               ChemicalShiftMaximumIntegrationLimitInppm => { GRP => "0018", ELEM => "9296", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                               CTAcquisitionTypeSequence => { GRP => "0018", ELEM => "9301", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AcquisitionType => { GRP => "0018", ELEM => "9302", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               TubeAngle => { GRP => "0018", ELEM => "9303", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                            CTAcquisitionDetailsSequence => { GRP => "0018", ELEM => "9304", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          RevolutionTime => { GRP => "0018", ELEM => "9305", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SingleCollimationWidth => { GRP => "0018", ELEM => "9306", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                   TotalCollimationWidth => { GRP => "0018", ELEM => "9307", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CTTableDynamicsSequence => { GRP => "0018", ELEM => "9308", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                              TableSpeed => { GRP => "0018", ELEM => "9309", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TableFeedPerRotation => { GRP => "0018", ELEM => "9310", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SpiralPitchFactor => { GRP => "0018", ELEM => "9311", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CTGeometrySequence => { GRP => "0018", ELEM => "9312", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             DataCollectionCenterPatient => { GRP => "0018", ELEM => "9313", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                                CTReconstructionSequence => { GRP => "0018", ELEM => "9314", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReconstructionAlgorithm => { GRP => "0018", ELEM => "9315", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ConvolutionKernelGroup => { GRP => "0018", ELEM => "9316", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReconstructionFieldOfView => { GRP => "0018", ELEM => "9317", VR => "FD", VM => "2", VERSION =>  "DICOM_2009"},
                                       ReconstructionTargetCenterPatient => { GRP => "0018", ELEM => "9318", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                                     ReconstructionAngle => { GRP => "0018", ELEM => "9319", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ImageFilter => { GRP => "0018", ELEM => "9320", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CTExposureSequence => { GRP => "0018", ELEM => "9321", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              ReconstructionPixelSpacing => { GRP => "0018", ELEM => "9322", VR => "FD", VM => "2", VERSION =>  "DICOM_2009"},
                                                  ExposureModulationType => { GRP => "0018", ELEM => "9323", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     EstimatedDoseSaving => { GRP => "0018", ELEM => "9324", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                   CTXRayDetailsSequence => { GRP => "0018", ELEM => "9325", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CTPositionSequence => { GRP => "0018", ELEM => "9326", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TablePosition => { GRP => "0018", ELEM => "9327", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ExposureTimeInms => { GRP => "0018", ELEM => "9328", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                CTImageFrameTypeSequence => { GRP => "0018", ELEM => "9329", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     XRayTubeCurrentInmA => { GRP => "0018", ELEM => "9330", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ExposureInmAs => { GRP => "0018", ELEM => "9332", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ConstantVolumeFlag => { GRP => "0018", ELEM => "9333", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         FluoroscopyFlag => { GRP => "0018", ELEM => "9334", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                    DistanceSourceToDataCollectionCenter => { GRP => "0018", ELEM => "9335", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                ContrastBolusAgentNumber => { GRP => "0018", ELEM => "9337", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                     ContrastBolusIngredientCodeSequence => { GRP => "0018", ELEM => "9338", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   ContrastAdministrationProfileSequence => { GRP => "0018", ELEM => "9340", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              ContrastBolusUsageSequence => { GRP => "0018", ELEM => "9341", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ContrastBolusAgentAdministered => { GRP => "0018", ELEM => "9342", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              ContrastBolusAgentDetected => { GRP => "0018", ELEM => "9343", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ContrastBolusAgentPhase => { GRP => "0018", ELEM => "9344", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 CTDIvol => { GRP => "0018", ELEM => "9345", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                             CTDIPhantomTypeCodeSequence => { GRP => "0018", ELEM => "9346", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         CalciumScoringMassFactorPatient => { GRP => "0018", ELEM => "9351", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                          CalciumScoringMassFactorDevice => { GRP => "0018", ELEM => "9352", VR => "FL", VM => "3", VERSION =>  "DICOM_2009"},
                                                   EnergyWeightingFactor => { GRP => "0018", ELEM => "9353", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                          CTAdditionalXRaySourceSequence => { GRP => "0018", ELEM => "9360", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      ProjectionPixelCalibrationSequence => { GRP => "0018", ELEM => "9401", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               DistanceSourceToIsocenter => { GRP => "0018", ELEM => "9402", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                DistanceObjectToTableTop => { GRP => "0018", ELEM => "9403", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                        ObjectPixelSpacingInCenterOfBeam => { GRP => "0018", ELEM => "9404", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                              PositionerPositionSequence => { GRP => "0018", ELEM => "9405", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   TablePositionSequence => { GRP => "0018", ELEM => "9406", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CollimatorShapeSequence => { GRP => "0018", ELEM => "9407", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       XAXRFFrameCharacteristicsSequence => { GRP => "0018", ELEM => "9412", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                FrameAcquisitionSequence => { GRP => "0018", ELEM => "9417", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        XRayReceptorType => { GRP => "0018", ELEM => "9420", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 AcquisitionProtocolName => { GRP => "0018", ELEM => "9423", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          AcquisitionProtocolDescription => { GRP => "0018", ELEM => "9424", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                           ContrastBolusIngredientOpaque => { GRP => "0018", ELEM => "9425", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                  DistanceReceptorPlaneToDetectorHousing => { GRP => "0018", ELEM => "9426", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                  IntensifierActiveShape => { GRP => "0018", ELEM => "9427", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             IntensifierActiveDimensions => { GRP => "0018", ELEM => "9428", VR => "FL", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                    PhysicalDetectorSize => { GRP => "0018", ELEM => "9429", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                           PositionOfIsocenterProjection => { GRP => "0018", ELEM => "9430", VR => "US", VM => "2", VERSION =>  "DICOM_2009"},
                                                     FieldOfViewSequence => { GRP => "0018", ELEM => "9432", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FieldOfViewDescription => { GRP => "0018", ELEM => "9433", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                   ExposureControlSensingRegionsSequence => { GRP => "0018", ELEM => "9434", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       ExposureControlSensingRegionShape => { GRP => "0018", ELEM => "9435", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                            ExposureControlSensingRegionLeftVerticalEdge => { GRP => "0018", ELEM => "9436", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                           ExposureControlSensingRegionRightVerticalEdge => { GRP => "0018", ELEM => "9437", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                         ExposureControlSensingRegionUpperHorizontalEdge => { GRP => "0018", ELEM => "9438", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                         ExposureControlSensingRegionLowerHorizontalEdge => { GRP => "0018", ELEM => "9439", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                            CenterOfCircularExposureControlSensingRegion => { GRP => "0018", ELEM => "9440", VR => "SS", VM => "2", VERSION =>  "DICOM_2009"},
                            RadiusOfCircularExposureControlSensingRegion => { GRP => "0018", ELEM => "9441", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                      VerticesOfThePolygonalExposureControlSensingRegion => { GRP => "0018", ELEM => "9442", VR => "SS", VM => "2-n", VERSION =>  "DICOM_2009"},
                                                 ColumnAngulationPatient => { GRP => "0018", ELEM => "9447", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                               BeamAngle => { GRP => "0018", ELEM => "9449", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                         FrameDetectorParametersSequence => { GRP => "0018", ELEM => "9451", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              CalculatedAnatomyThickness => { GRP => "0018", ELEM => "9452", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CalibrationSequence => { GRP => "0018", ELEM => "9455", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ObjectThicknessSequence => { GRP => "0018", ELEM => "9456", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PlaneIdentification => { GRP => "0018", ELEM => "9457", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            FieldOfViewDimensionsInFloat => { GRP => "0018", ELEM => "9461", VR => "FL", VM => "1-2", VERSION =>  "DICOM_2009"},
                                        IsocenterReferenceSystemSequence => { GRP => "0018", ELEM => "9462", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         PositionerIsocenterPrimaryAngle => { GRP => "0018", ELEM => "9463", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                       PositionerIsocenterSecondaryAngle => { GRP => "0018", ELEM => "9464", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                PositionerIsocenterDetectorRotationAngle => { GRP => "0018", ELEM => "9465", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                               TableXPositionToIsocenter => { GRP => "0018", ELEM => "9466", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                               TableYPositionToIsocenter => { GRP => "0018", ELEM => "9467", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                               TableZPositionToIsocenter => { GRP => "0018", ELEM => "9468", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            TableHorizontalRotationAngle => { GRP => "0018", ELEM => "9469", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TableHeadTiltAngle => { GRP => "0018", ELEM => "9470", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TableCradleTiltAngle => { GRP => "0018", ELEM => "9471", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             FrameDisplayShutterSequence => { GRP => "0018", ELEM => "9472", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            AcquiredImageAreaDoseProduct => { GRP => "0018", ELEM => "9473", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                      CArmPositionerTabletopRelationship => { GRP => "0018", ELEM => "9474", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    XRayGeometrySequence => { GRP => "0018", ELEM => "9476", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  IrradiationEventIdentificationSequence => { GRP => "0018", ELEM => "9477", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 XRay3DFrameTypeSequence => { GRP => "0018", ELEM => "9504", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             ContributingSourcesSequence => { GRP => "0018", ELEM => "9506", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               XRay3DAcquisitionSequence => { GRP => "0018", ELEM => "9507", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                PrimaryPositionerScanArc => { GRP => "0018", ELEM => "9508", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              SecondaryPositionerScanArc => { GRP => "0018", ELEM => "9509", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                         PrimaryPositionerScanStartAngle => { GRP => "0018", ELEM => "9510", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                       SecondaryPositionerScanStartAngle => { GRP => "0018", ELEM => "9511", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              PrimaryPositionerIncrement => { GRP => "0018", ELEM => "9514", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            SecondaryPositionerIncrement => { GRP => "0018", ELEM => "9515", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                StartAcquisitionDateTime => { GRP => "0018", ELEM => "9516", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                  EndAcquisitionDateTime => { GRP => "0018", ELEM => "9517", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ApplicationName => { GRP => "0018", ELEM => "9524", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ApplicationVersion => { GRP => "0018", ELEM => "9525", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ApplicationManufacturer => { GRP => "0018", ELEM => "9526", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                           AlgorithmType => { GRP => "0018", ELEM => "9527", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    AlgorithmDescription => { GRP => "0018", ELEM => "9528", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                            XRay3DReconstructionSequence => { GRP => "0018", ELEM => "9530", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReconstructionDescription => { GRP => "0018", ELEM => "9531", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                        PerProjectionAcquisitionSequence => { GRP => "0018", ELEM => "9538", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                DiffusionBMatrixSequence => { GRP => "0018", ELEM => "9601", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiffusionBValueXX => { GRP => "0018", ELEM => "9602", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiffusionBValueXY => { GRP => "0018", ELEM => "9603", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiffusionBValueXZ => { GRP => "0018", ELEM => "9604", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiffusionBValueYY => { GRP => "0018", ELEM => "9605", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiffusionBValueYZ => { GRP => "0018", ELEM => "9606", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiffusionBValueZZ => { GRP => "0018", ELEM => "9607", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DecayCorrectionDateTime => { GRP => "0018", ELEM => "9701", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                   StartDensityThreshold => { GRP => "0018", ELEM => "9715", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                 StartRelativeDensityDifferenceThreshold => { GRP => "0018", ELEM => "9716", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                       StartCardiacTriggerCountThreshold => { GRP => "0018", ELEM => "9717", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                   StartRespiratoryTriggerCountThreshold => { GRP => "0018", ELEM => "9718", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                              TerminationCountsThreshold => { GRP => "0018", ELEM => "9719", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                             TerminationDensityThreshold => { GRP => "0018", ELEM => "9720", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                     TerminationRelativeDensityThreshold => { GRP => "0018", ELEM => "9721", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                TerminationTimeThreshold => { GRP => "0018", ELEM => "9722", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                 TerminationCardiacTriggerCountThreshold => { GRP => "0018", ELEM => "9723", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                             TerminationRespiratoryTriggerCountThreshold => { GRP => "0018", ELEM => "9724", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DetectorGeometry => { GRP => "0018", ELEM => "9725", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            TransverseDetectorSeparation => { GRP => "0018", ELEM => "9726", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                  AxialDetectorDimension => { GRP => "0018", ELEM => "9727", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                          RadiopharmaceuticalAgentNumber => { GRP => "0018", ELEM => "9729", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                             PETFrameAcquisitionSequence => { GRP => "0018", ELEM => "9732", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        PETDetectorMotionDetailsSequence => { GRP => "0018", ELEM => "9733", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                PETTableDynamicsSequence => { GRP => "0018", ELEM => "9734", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PETPositionSequence => { GRP => "0018", ELEM => "9735", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       PETFrameCorrectionFactorsSequence => { GRP => "0018", ELEM => "9736", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        RadiopharmaceuticalUsageSequence => { GRP => "0018", ELEM => "9737", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             AttenuationCorrectionSource => { GRP => "0018", ELEM => "9738", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      NumberOfIterations => { GRP => "0018", ELEM => "9739", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                         NumberOfSubsets => { GRP => "0018", ELEM => "9740", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                               PETReconstructionSequence => { GRP => "0018", ELEM => "9749", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PETFrameTypeSequence => { GRP => "0018", ELEM => "9751", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             TimeOfFlightInformationUsed => { GRP => "0018", ELEM => "9755", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ReconstructionType => { GRP => "0018", ELEM => "9756", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DecayCorrected => { GRP => "0018", ELEM => "9758", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    AttenuationCorrected => { GRP => "0018", ELEM => "9759", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ScatterCorrected => { GRP => "0018", ELEM => "9760", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DeadTimeCorrected => { GRP => "0018", ELEM => "9761", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   GantryMotionCorrected => { GRP => "0018", ELEM => "9762", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PatientMotionCorrected => { GRP => "0018", ELEM => "9763", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         CountLossNormalizationCorrected => { GRP => "0018", ELEM => "9764", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        RandomsCorrected => { GRP => "0018", ELEM => "9765", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       NonUniformRadialSamplingCorrected => { GRP => "0018", ELEM => "9766", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   SensitivityCalibrated => { GRP => "0018", ELEM => "9767", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         DetectorNormalizationCorrection => { GRP => "0018", ELEM => "9768", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           IterativeReconstructionMethod => { GRP => "0018", ELEM => "9769", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                               AttenuationCorrectionTemporalRelationship => { GRP => "0018", ELEM => "9770", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       PatientPhysiologicalStateSequence => { GRP => "0018", ELEM => "9771", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   PatientPhysiologicalStateCodeSequence => { GRP => "0018", ELEM => "9772", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           DepthsOfFocus => { GRP => "0018", ELEM => "9801", VR => "FD", VM => "1-n", VERSION =>  "DICOM_2009"},
                                               ExcludedIntervalsSequence => { GRP => "0018", ELEM => "9803", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ExclusionStartDatetime => { GRP => "0018", ELEM => "9804", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ExclusionDuration => { GRP => "0018", ELEM => "9805", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                              USImageDescriptionSequence => { GRP => "0018", ELEM => "9806", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ImageDataTypeSequence => { GRP => "0018", ELEM => "9807", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                                DataType => { GRP => "0018", ELEM => "9808", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       TransducerScanPatternCodeSequence => { GRP => "0018", ELEM => "9809", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AliasedDataType => { GRP => "0018", ELEM => "980B", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             PositionMeasuringDeviceUsed => { GRP => "0018", ELEM => "980C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          TransducerGeometryCodeSequence => { GRP => "0018", ELEM => "980D", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      TransducerBeamSteeringCodeSequence => { GRP => "0018", ELEM => "980E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       TransducerApplicationCodeSequence => { GRP => "0018", ELEM => "980F", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ContributingEquipmentSequence => { GRP => "0018", ELEM => "A001", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContributionDateTime => { GRP => "0018", ELEM => "A002", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ContributionDescription => { GRP => "0018", ELEM => "A003", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                        StudyInstanceUID => { GRP => "0020", ELEM => "000D", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SeriesInstanceUID => { GRP => "0020", ELEM => "000E", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 StudyID => { GRP => "0020", ELEM => "0010", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                            SeriesNumber => { GRP => "0020", ELEM => "0011", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       AcquisitionNumber => { GRP => "0020", ELEM => "0012", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          InstanceNumber => { GRP => "0020", ELEM => "0013", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ItemNumber => { GRP => "0020", ELEM => "0019", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PatientOrientation => { GRP => "0020", ELEM => "0020", VR => "CS", VM => "2", VERSION =>  "DICOM_2009"},
                                                    ImagePositionPatient => { GRP => "0020", ELEM => "0032", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                 ImageOrientationPatient => { GRP => "0020", ELEM => "0037", VR => "DS", VM => "6", VERSION =>  "DICOM_2009"},
                                                     FrameOfReferenceUID => { GRP => "0020", ELEM => "0052", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                              Laterality => { GRP => "0020", ELEM => "0060", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ImageLaterality => { GRP => "0020", ELEM => "0062", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              TemporalPositionIdentifier => { GRP => "0020", ELEM => "0100", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                               NumberOfTemporalPositions => { GRP => "0020", ELEM => "0105", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TemporalResolution => { GRP => "0020", ELEM => "0110", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                      SynchronizationFrameOfReferenceUID => { GRP => "0020", ELEM => "0200", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                     SOPInstanceUIDOfConcatenationSource => { GRP => "0020", ELEM => "0242", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ImagesInAcquisition => { GRP => "0020", ELEM => "1002", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              PositionReferenceIndicator => { GRP => "0020", ELEM => "1040", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SliceLocation => { GRP => "0020", ELEM => "1041", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           NumberOfPatientRelatedStudies => { GRP => "0020", ELEM => "1200", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                            NumberOfPatientRelatedSeries => { GRP => "0020", ELEM => "1202", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                         NumberOfPatientRelatedInstances => { GRP => "0020", ELEM => "1204", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              NumberOfStudyRelatedSeries => { GRP => "0020", ELEM => "1206", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           NumberOfStudyRelatedInstances => { GRP => "0020", ELEM => "1208", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                          NumberOfSeriesRelatedInstances => { GRP => "0020", ELEM => "1209", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ImageComments => { GRP => "0020", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 StackID => { GRP => "0020", ELEM => "9056", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                   InStackPositionNumber => { GRP => "0020", ELEM => "9057", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    FrameAnatomySequence => { GRP => "0020", ELEM => "9071", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         FrameLaterality => { GRP => "0020", ELEM => "9072", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    FrameContentSequence => { GRP => "0020", ELEM => "9111", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   PlanePositionSequence => { GRP => "0020", ELEM => "9113", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                PlaneOrientationSequence => { GRP => "0020", ELEM => "9116", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   TemporalPositionIndex => { GRP => "0020", ELEM => "9128", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                          NominalCardiacTriggerDelayTime => { GRP => "0020", ELEM => "9153", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FrameAcquisitionNumber => { GRP => "0020", ELEM => "9156", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                    DimensionIndexValues => { GRP => "0020", ELEM => "9157", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                           FrameComments => { GRP => "0020", ELEM => "9158", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ConcatenationUID => { GRP => "0020", ELEM => "9161", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                   InConcatenationNumber => { GRP => "0020", ELEM => "9162", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                              InConcatenationTotalNumber => { GRP => "0020", ELEM => "9163", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                DimensionOrganizationUID => { GRP => "0020", ELEM => "9164", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                   DimensionIndexPointer => { GRP => "0020", ELEM => "9165", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FunctionalGroupPointer => { GRP => "0020", ELEM => "9167", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                            DimensionIndexPrivateCreator => { GRP => "0020", ELEM => "9213", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           DimensionOrganizationSequence => { GRP => "0020", ELEM => "9221", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DimensionIndexSequence => { GRP => "0020", ELEM => "9222", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ConcatenationFrameOffsetNumber => { GRP => "0020", ELEM => "9228", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                           FunctionalGroupPrivateCreator => { GRP => "0020", ELEM => "9238", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         NominalPercentageOfCardiacPhase => { GRP => "0020", ELEM => "9241", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                     NominalPercentageOfRespiratoryPhase => { GRP => "0020", ELEM => "9245", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            StartingRespiratoryAmplitude => { GRP => "0020", ELEM => "9246", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                StartingRespiratoryPhase => { GRP => "0020", ELEM => "9247", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              EndingRespiratoryAmplitude => { GRP => "0020", ELEM => "9248", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                  EndingRespiratoryPhase => { GRP => "0020", ELEM => "9249", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RespiratoryTriggerType => { GRP => "0020", ELEM => "9250", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RRIntervalTimeNominal => { GRP => "0020", ELEM => "9251", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                           ActualCardiacTriggerDelayTime => { GRP => "0020", ELEM => "9252", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                      RespiratorySynchronizationSequence => { GRP => "0020", ELEM => "9253", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RespiratoryIntervalTime => { GRP => "0020", ELEM => "9254", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                      NominalRespiratoryTriggerDelayTime => { GRP => "0020", ELEM => "9255", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                        RespiratoryTriggerDelayThreshold => { GRP => "0020", ELEM => "9256", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                       ActualRespiratoryTriggerDelayTime => { GRP => "0020", ELEM => "9257", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ImagePositionVolume => { GRP => "0020", ELEM => "9301", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                                  ImageOrientationVolume => { GRP => "0020", ELEM => "9302", VR => "FD", VM => "6", VERSION =>  "DICOM_2009"},
                                           UltrasoundAcquisitionGeometry => { GRP => "0020", ELEM => "9307", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ApexPosition => { GRP => "0020", ELEM => "9308", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                         VolumeToTransducerMappingMatrix => { GRP => "0020", ELEM => "9309", VR => "FD", VM => "16", VERSION =>  "DICOM_2009"},
                                              VolumeToTableMappingMatrix => { GRP => "0020", ELEM => "930A", VR => "FD", VM => "16", VERSION =>  "DICOM_2009"},
                                           PatientFrameOfReferenceSource => { GRP => "0020", ELEM => "930C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              TemporalPositionTimeOffset => { GRP => "0020", ELEM => "930D", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                             PlanePositionVolumeSequence => { GRP => "0020", ELEM => "930E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          PlaneOrientationVolumeSequence => { GRP => "0020", ELEM => "930F", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                TemporalPositionSequence => { GRP => "0020", ELEM => "9310", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               DimensionOrganizationType => { GRP => "0020", ELEM => "9311", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               VolumeFrameOfReferenceUID => { GRP => "0020", ELEM => "9312", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                TableFrameOfReferenceUID => { GRP => "0020", ELEM => "9313", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                               DimensionDescriptionLabel => { GRP => "0020", ELEM => "9421", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                       PatientOrientationInFrameSequence => { GRP => "0020", ELEM => "9450", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                              FrameLabel => { GRP => "0020", ELEM => "9453", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                        AcquisitionIndex => { GRP => "0020", ELEM => "9518", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                               ContributingSOPInstancesReferenceSequence => { GRP => "0020", ELEM => "9529", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ReconstructionIndex => { GRP => "0020", ELEM => "9536", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                    LightPathFilterPassThroughWavelength => { GRP => "0022", ELEM => "0001", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 LightPathFilterPassBand => { GRP => "0022", ELEM => "0002", VR => "US", VM => "2", VERSION =>  "DICOM_2009"},
                                    ImagePathFilterPassThroughWavelength => { GRP => "0022", ELEM => "0003", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ImagePathFilterPassBand => { GRP => "0022", ELEM => "0004", VR => "US", VM => "2", VERSION =>  "DICOM_2009"},
                                             PatientEyeMovementCommanded => { GRP => "0022", ELEM => "0005", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                   PatientEyeMovementCommandCodeSequence => { GRP => "0022", ELEM => "0006", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SphericalLensPower => { GRP => "0022", ELEM => "0007", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                       CylinderLensPower => { GRP => "0022", ELEM => "0008", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                            CylinderAxis => { GRP => "0022", ELEM => "0009", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 EmmetropicMagnification => { GRP => "0022", ELEM => "000A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     IntraOcularPressure => { GRP => "0022", ELEM => "000B", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                   HorizontalFieldOfView => { GRP => "0022", ELEM => "000C", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                            PupilDilated => { GRP => "0022", ELEM => "000D", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DegreeOfDilation => { GRP => "0022", ELEM => "000E", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     StereoBaselineAngle => { GRP => "0022", ELEM => "0010", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              StereoBaselineDisplacement => { GRP => "0022", ELEM => "0011", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             StereoHorizontalPixelOffset => { GRP => "0022", ELEM => "0012", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                               StereoVerticalPixelOffset => { GRP => "0022", ELEM => "0013", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                          StereoRotation => { GRP => "0022", ELEM => "0014", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                       AcquisitionDeviceTypeCodeSequence => { GRP => "0022", ELEM => "0015", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            IlluminationTypeCodeSequence => { GRP => "0022", ELEM => "0016", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    LightPathFilterTypeStackCodeSequence => { GRP => "0022", ELEM => "0017", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    ImagePathFilterTypeStackCodeSequence => { GRP => "0022", ELEM => "0018", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      LensesCodeSequence => { GRP => "0022", ELEM => "0019", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ChannelDescriptionCodeSequence => { GRP => "0022", ELEM => "001A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RefractiveStateSequence => { GRP => "0022", ELEM => "001B", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              MydriaticAgentCodeSequence => { GRP => "0022", ELEM => "001C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       RelativeImagePositionCodeSequence => { GRP => "0022", ELEM => "001D", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     StereoPairsSequence => { GRP => "0022", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       LeftImageSequence => { GRP => "0022", ELEM => "0021", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RightImageSequence => { GRP => "0022", ELEM => "0022", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AxialLengthOfTheEye => { GRP => "0022", ELEM => "0030", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                         OphthalmicFrameLocationSequence => { GRP => "0022", ELEM => "0031", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReferenceCoordinates => { GRP => "0022", ELEM => "0032", VR => "FL", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                  DepthSpatialResolution => { GRP => "0022", ELEM => "0035", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                  MaximumDepthDistortion => { GRP => "0022", ELEM => "0036", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              AlongScanSpatialResolution => { GRP => "0022", ELEM => "0037", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              MaximumAlongScanDistortion => { GRP => "0022", ELEM => "0038", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              OphthalmicImageOrientation => { GRP => "0022", ELEM => "0039", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DepthOfTransverseImage => { GRP => "0022", ELEM => "0041", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                MydriaticAgentConcentrationUnitsSequence => { GRP => "0022", ELEM => "0042", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             AcrossScanSpatialResolution => { GRP => "0022", ELEM => "0048", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             MaximumAcrossScanDistortion => { GRP => "0022", ELEM => "0049", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             MydriaticAgentConcentration => { GRP => "0022", ELEM => "004E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  IlluminationWaveLength => { GRP => "0022", ELEM => "0055", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                       IlluminationPower => { GRP => "0022", ELEM => "0056", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                   IlluminationBandwidth => { GRP => "0022", ELEM => "0057", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                  MydriaticAgentSequence => { GRP => "0022", ELEM => "0058", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SamplesPerPixel => { GRP => "0028", ELEM => "0002", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SamplesPerPixelUsed => { GRP => "0028", ELEM => "0003", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                               PhotometricInterpretation => { GRP => "0028", ELEM => "0004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PlanarConfiguration => { GRP => "0028", ELEM => "0006", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                          NumberOfFrames => { GRP => "0028", ELEM => "0008", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   FrameIncrementPointer => { GRP => "0028", ELEM => "0009", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   FrameDimensionPointer => { GRP => "0028", ELEM => "000A", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                                    Rows => { GRP => "0028", ELEM => "0010", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 Columns => { GRP => "0028", ELEM => "0011", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                              UltrasoundColorDataPresent => { GRP => "0028", ELEM => "0014", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                            PixelSpacing => { GRP => "0028", ELEM => "0030", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                              ZoomFactor => { GRP => "0028", ELEM => "0031", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                              ZoomCenter => { GRP => "0028", ELEM => "0032", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                        PixelAspectRatio => { GRP => "0028", ELEM => "0034", VR => "IS", VM => "2", VERSION =>  "DICOM_2009"},
                                                          CorrectedImage => { GRP => "0028", ELEM => "0051", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                           BitsAllocated => { GRP => "0028", ELEM => "0100", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                              BitsStored => { GRP => "0028", ELEM => "0101", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 HighBit => { GRP => "0028", ELEM => "0102", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PixelRepresentation => { GRP => "0028", ELEM => "0103", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 SmallestImagePixelValue => { GRP => "0028", ELEM => "0106", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                  LargestImagePixelValue => { GRP => "0028", ELEM => "0107", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                              SmallestPixelValueInSeries => { GRP => "0028", ELEM => "0108", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                               LargestPixelValueInSeries => { GRP => "0028", ELEM => "0109", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PixelPaddingValue => { GRP => "0028", ELEM => "0120", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PixelPaddingRangeLimit => { GRP => "0028", ELEM => "0121", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                     QualityControlImage => { GRP => "0028", ELEM => "0300", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      BurnedInAnnotation => { GRP => "0028", ELEM => "0301", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             PixelSpacingCalibrationType => { GRP => "0028", ELEM => "0A02", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                      PixelSpacingCalibrationDescription => { GRP => "0028", ELEM => "0A04", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              PixelIntensityRelationship => { GRP => "0028", ELEM => "1040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          PixelIntensityRelationshipSign => { GRP => "0028", ELEM => "1041", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            WindowCenter => { GRP => "0028", ELEM => "1050", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                             WindowWidth => { GRP => "0028", ELEM => "1051", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                        RescaleIntercept => { GRP => "0028", ELEM => "1052", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            RescaleSlope => { GRP => "0028", ELEM => "1053", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             RescaleType => { GRP => "0028", ELEM => "1054", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                            WindowCenterWidthExplanation => { GRP => "0028", ELEM => "1055", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          VOILUTFunction => { GRP => "0028", ELEM => "1056", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RecommendedViewingMode => { GRP => "0028", ELEM => "1090", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                    RedPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1101", VR => "xs", VM => "3", VERSION =>  "DICOM_2009"},
                                  GreenPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1102", VR => "xs", VM => "3", VERSION =>  "DICOM_2009"},
                                   BluePaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1103", VR => "xs", VM => "3", VERSION =>  "DICOM_2009"},
                                  AlphaPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1104", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                              PaletteColorLookupTableUID => { GRP => "0028", ELEM => "1199", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                          RedPaletteColorLookupTableData => { GRP => "0028", ELEM => "1201", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                        GreenPaletteColorLookupTableData => { GRP => "0028", ELEM => "1202", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                         BluePaletteColorLookupTableData => { GRP => "0028", ELEM => "1203", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                        AlphaPaletteColorLookupTableData => { GRP => "0028", ELEM => "1204", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                 SegmentedRedPaletteColorLookupTableData => { GRP => "0028", ELEM => "1221", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                               SegmentedGreenPaletteColorLookupTableData => { GRP => "0028", ELEM => "1222", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                SegmentedBluePaletteColorLookupTableData => { GRP => "0028", ELEM => "1223", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                                    BreastImplantPresent => { GRP => "0028", ELEM => "1300", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             PartialView => { GRP => "0028", ELEM => "1350", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PartialViewDescription => { GRP => "0028", ELEM => "1351", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PartialViewCodeSequence => { GRP => "0028", ELEM => "1352", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               SpatialLocationsPreserved => { GRP => "0028", ELEM => "135A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             DataFrameAssignmentSequence => { GRP => "0028", ELEM => "1401", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DataPathAssignment => { GRP => "0028", ELEM => "1402", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            BitsMappedToColorLookupTable => { GRP => "0028", ELEM => "1403", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                    BlendingLUT1Sequence => { GRP => "0028", ELEM => "1404", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            BlendingLUT1TransferFunction => { GRP => "0028", ELEM => "1405", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  BlendingWeightConstant => { GRP => "0028", ELEM => "1406", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                           BlendingLookupTableDescriptor => { GRP => "0028", ELEM => "1407", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                                 BlendingLookupTableData => { GRP => "0028", ELEM => "1408", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                 EnhancedPaletteColorLookupTableSequence => { GRP => "0028", ELEM => "140B", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    BlendingLUT2Sequence => { GRP => "0028", ELEM => "140C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            BlendingLUT2TransferFunction => { GRP => "0028", ELEM => "140D", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              DataPathID => { GRP => "0028", ELEM => "140E", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RGBLUTTransferFunction => { GRP => "0028", ELEM => "140F", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                AlphaLUTTransferFunction => { GRP => "0028", ELEM => "1410", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ICCProfile => { GRP => "0028", ELEM => "2000", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                                   LossyImageCompression => { GRP => "0028", ELEM => "2110", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              LossyImageCompressionRatio => { GRP => "0028", ELEM => "2112", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                             LossyImageCompressionMethod => { GRP => "0028", ELEM => "2114", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     ModalityLUTSequence => { GRP => "0028", ELEM => "3000", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           LUTDescriptor => { GRP => "0028", ELEM => "3002", VR => "xs", VM => "3", VERSION =>  "DICOM_2009"},
                                                          LUTExplanation => { GRP => "0028", ELEM => "3003", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ModalityLUTType => { GRP => "0028", ELEM => "3004", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 LUTData => { GRP => "0028", ELEM => "3006", VR => "lt", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          VOILUTSequence => { GRP => "0028", ELEM => "3010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SoftcopyVOILUTSequence => { GRP => "0028", ELEM => "3110", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               RepresentativeFrameNumber => { GRP => "0028", ELEM => "6010", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FrameNumbersOfInterest => { GRP => "0028", ELEM => "6020", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                              FrameOfInterestDescription => { GRP => "0028", ELEM => "6022", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     FrameOfInterestType => { GRP => "0028", ELEM => "6023", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                            RWavePointer => { GRP => "0028", ELEM => "6040", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                 MaskSubtractionSequence => { GRP => "0028", ELEM => "6100", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           MaskOperation => { GRP => "0028", ELEM => "6101", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ApplicableFrameRange => { GRP => "0028", ELEM => "6102", VR => "US", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                        MaskFrameNumbers => { GRP => "0028", ELEM => "6110", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                  ContrastFrameAveraging => { GRP => "0028", ELEM => "6112", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                       MaskSubPixelShift => { GRP => "0028", ELEM => "6114", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                                               TIDOffset => { GRP => "0028", ELEM => "6120", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                                                MaskOperationExplanation => { GRP => "0028", ELEM => "6190", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PixelDataProviderURL => { GRP => "0028", ELEM => "7FE0", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                           DataPointRows => { GRP => "0028", ELEM => "9001", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DataPointColumns => { GRP => "0028", ELEM => "9002", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SignalDomainColumns => { GRP => "0028", ELEM => "9003", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DataRepresentation => { GRP => "0028", ELEM => "9108", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   PixelMeasuresSequence => { GRP => "0028", ELEM => "9110", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     FrameVOILUTSequence => { GRP => "0028", ELEM => "9132", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        PixelValueTransformationSequence => { GRP => "0028", ELEM => "9145", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        SignalDomainRows => { GRP => "0028", ELEM => "9235", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DisplayFilterPercentage => { GRP => "0028", ELEM => "9411", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 FramePixelShiftSequence => { GRP => "0028", ELEM => "9415", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SubtractionItemID => { GRP => "0028", ELEM => "9416", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                   PixelIntensityRelationshipLUTSequence => { GRP => "0028", ELEM => "9422", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        FramePixelDataPropertiesSequence => { GRP => "0028", ELEM => "9443", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   GeometricalProperties => { GRP => "0028", ELEM => "9444", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              GeometricMaximumDistortion => { GRP => "0028", ELEM => "9445", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ImageProcessingApplied => { GRP => "0028", ELEM => "9446", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       MaskSelectionMode => { GRP => "0028", ELEM => "9454", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             LUTFunction => { GRP => "0028", ELEM => "9474", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                MaskVisibilityPercentage => { GRP => "0028", ELEM => "9478", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PixelShiftSequence => { GRP => "0028", ELEM => "9501", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                RegionPixelShiftSequence => { GRP => "0028", ELEM => "9502", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     VerticesOfTheRegion => { GRP => "0028", ELEM => "9503", VR => "SS", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                          MultiFramePresentationSequence => { GRP => "0028", ELEM => "9505", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PixelShiftFrameRange => { GRP => "0028", ELEM => "9506", VR => "US", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                           LUTFrameRange => { GRP => "0028", ELEM => "9507", VR => "US", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                           ImageToEquipmentMappingMatrix => { GRP => "0028", ELEM => "9520", VR => "DS", VM => "16", VERSION =>  "DICOM_2009"},
                                 EquipmentCoordinateSystemIdentification => { GRP => "0028", ELEM => "9537", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                               RequestingPhysicianIdentificationSequence => { GRP => "0032", ELEM => "1031", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RequestingPhysician => { GRP => "0032", ELEM => "1032", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RequestingService => { GRP => "0032", ELEM => "1033", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           RequestingServiceCodeSequence => { GRP => "0032", ELEM => "1034", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           RequestedProcedureDescription => { GRP => "0032", ELEM => "1060", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          RequestedProcedureCodeSequence => { GRP => "0032", ELEM => "1064", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RequestedContrastAgent => { GRP => "0032", ELEM => "1070", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedPatientAliasSequence => { GRP => "0038", ELEM => "0004", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           VisitStatusID => { GRP => "0038", ELEM => "0008", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             AdmissionID => { GRP => "0038", ELEM => "0010", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                             IssuerOfAdmissionIDSequence => { GRP => "0038", ELEM => "0014", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RouteOfAdmissions => { GRP => "0038", ELEM => "0016", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                           AdmittingDate => { GRP => "0038", ELEM => "0020", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                           AdmittingTime => { GRP => "0038", ELEM => "0021", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                            SpecialNeeds => { GRP => "0038", ELEM => "0050", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ServiceEpisodeID => { GRP => "0038", ELEM => "0060", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               ServiceEpisodeDescription => { GRP => "0038", ELEM => "0062", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                        IssuerOfServiceEpisodeIDSequence => { GRP => "0038", ELEM => "0064", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              PertinentDocumentsSequence => { GRP => "0038", ELEM => "0100", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CurrentPatientLocation => { GRP => "0038", ELEM => "0300", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                             PatientInstitutionResidence => { GRP => "0038", ELEM => "0400", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                            PatientState => { GRP => "0038", ELEM => "0500", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                               PatientClinicalTrialParticipationSequence => { GRP => "0038", ELEM => "0502", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           VisitComments => { GRP => "0038", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     WaveformOriginality => { GRP => "003A", ELEM => "0004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                NumberOfWaveformChannels => { GRP => "003A", ELEM => "0005", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 NumberOfWaveformSamples => { GRP => "003A", ELEM => "0010", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SamplingFrequency => { GRP => "003A", ELEM => "001A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     MultiplexGroupLabel => { GRP => "003A", ELEM => "0020", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                               ChannelDefinitionSequence => { GRP => "003A", ELEM => "0200", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   WaveformChannelNumber => { GRP => "003A", ELEM => "0202", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ChannelLabel => { GRP => "003A", ELEM => "0203", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ChannelStatus => { GRP => "003A", ELEM => "0205", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   ChannelSourceSequence => { GRP => "003A", ELEM => "0208", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ChannelSourceModifiersSequence => { GRP => "003A", ELEM => "0209", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SourceWaveformSequence => { GRP => "003A", ELEM => "020A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            ChannelDerivationDescription => { GRP => "003A", ELEM => "020C", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ChannelSensitivity => { GRP => "003A", ELEM => "0210", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ChannelSensitivityUnitsSequence => { GRP => "003A", ELEM => "0211", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      ChannelSensitivityCorrectionFactor => { GRP => "003A", ELEM => "0212", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ChannelBaseline => { GRP => "003A", ELEM => "0213", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ChannelTimeSkew => { GRP => "003A", ELEM => "0214", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ChannelSampleSkew => { GRP => "003A", ELEM => "0215", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ChannelOffset => { GRP => "003A", ELEM => "0218", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      WaveformBitsStored => { GRP => "003A", ELEM => "021A", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                      FilterLowFrequency => { GRP => "003A", ELEM => "0220", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     FilterHighFrequency => { GRP => "003A", ELEM => "0221", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    NotchFilterFrequency => { GRP => "003A", ELEM => "0222", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    NotchFilterBandwidth => { GRP => "003A", ELEM => "0223", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                WaveformDataDisplayScale => { GRP => "003A", ELEM => "0230", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                    WaveformDisplayBackgroundCIELabValue => { GRP => "003A", ELEM => "0231", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                       WaveformPresentationGroupSequence => { GRP => "003A", ELEM => "0240", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PresentationGroupNumber => { GRP => "003A", ELEM => "0241", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ChannelDisplaySequence => { GRP => "003A", ELEM => "0242", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    ChannelRecommendedDisplayCIELabValue => { GRP => "003A", ELEM => "0244", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                                         ChannelPosition => { GRP => "003A", ELEM => "0245", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DisplayShadingFlag => { GRP => "003A", ELEM => "0246", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           FractionalChannelDisplayScale => { GRP => "003A", ELEM => "0247", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             AbsoluteChannelDisplayScale => { GRP => "003A", ELEM => "0248", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                         MultiplexedAudioChannelsDescriptionCodeSequence => { GRP => "003A", ELEM => "0300", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ChannelIdentificationCode => { GRP => "003A", ELEM => "0301", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ChannelMode => { GRP => "003A", ELEM => "0302", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ScheduledStationAETitle => { GRP => "0040", ELEM => "0001", VR => "AE", VM => "1-n", VERSION =>  "DICOM_2009"},
                                         ScheduledProcedureStepStartDate => { GRP => "0040", ELEM => "0002", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                         ScheduledProcedureStepStartTime => { GRP => "0040", ELEM => "0003", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                           ScheduledProcedureStepEndDate => { GRP => "0040", ELEM => "0004", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                           ScheduledProcedureStepEndTime => { GRP => "0040", ELEM => "0005", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                        ScheduledPerformingPhysicianName => { GRP => "0040", ELEM => "0006", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                       ScheduledProcedureStepDescription => { GRP => "0040", ELEM => "0007", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           ScheduledProtocolCodeSequence => { GRP => "0040", ELEM => "0008", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ScheduledProcedureStepID => { GRP => "0040", ELEM => "0009", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                       StageCodeSequence => { GRP => "0040", ELEM => "000A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                      ScheduledPerformingPhysicianIdentificationSequence => { GRP => "0040", ELEM => "000B", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ScheduledStationName => { GRP => "0040", ELEM => "0010", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                          ScheduledProcedureStepLocation => { GRP => "0040", ELEM => "0011", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PreMedication => { GRP => "0040", ELEM => "0012", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                            ScheduledProcedureStepStatus => { GRP => "0040", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           OrderPlacerIdentifierSequence => { GRP => "0040", ELEM => "0026", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           OrderFillerIdentifierSequence => { GRP => "0040", ELEM => "0027", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  LocalNamespaceEntityID => { GRP => "0040", ELEM => "0031", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                       UniversalEntityID => { GRP => "0040", ELEM => "0032", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                   UniversalEntityIDType => { GRP => "0040", ELEM => "0033", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      IdentifierTypeCode => { GRP => "0040", ELEM => "0035", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               AssigningFacilitySequence => { GRP => "0040", ELEM => "0036", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       AssigningJurisdictionCodeSequence => { GRP => "0040", ELEM => "0039", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                 AssigningAgencyOrDepartmentCodeSequence => { GRP => "0040", ELEM => "003A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ScheduledProcedureStepSequence => { GRP => "0040", ELEM => "0100", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                          ReferencedNonImageCompositeSOPInstanceSequence => { GRP => "0040", ELEM => "0220", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PerformedStationAETitle => { GRP => "0040", ELEM => "0241", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PerformedStationName => { GRP => "0040", ELEM => "0242", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PerformedLocation => { GRP => "0040", ELEM => "0243", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                         PerformedProcedureStepStartDate => { GRP => "0040", ELEM => "0244", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                         PerformedProcedureStepStartTime => { GRP => "0040", ELEM => "0245", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                           PerformedProcedureStepEndDate => { GRP => "0040", ELEM => "0250", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                           PerformedProcedureStepEndTime => { GRP => "0040", ELEM => "0251", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                            PerformedProcedureStepStatus => { GRP => "0040", ELEM => "0252", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                PerformedProcedureStepID => { GRP => "0040", ELEM => "0253", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                       PerformedProcedureStepDescription => { GRP => "0040", ELEM => "0254", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                       PerformedProcedureTypeDescription => { GRP => "0040", ELEM => "0255", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           PerformedProtocolCodeSequence => { GRP => "0040", ELEM => "0260", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   PerformedProtocolType => { GRP => "0040", ELEM => "0261", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ScheduledStepAttributesSequence => { GRP => "0040", ELEM => "0270", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               RequestAttributesSequence => { GRP => "0040", ELEM => "0275", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     CommentsOnThePerformedProcedureStep => { GRP => "0040", ELEM => "0280", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                 PerformedProcedureStepDiscontinuationReasonCodeSequence => { GRP => "0040", ELEM => "0281", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        QuantitySequence => { GRP => "0040", ELEM => "0293", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Quantity => { GRP => "0040", ELEM => "0294", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  MeasuringUnitsSequence => { GRP => "0040", ELEM => "0295", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     BillingItemSequence => { GRP => "0040", ELEM => "0296", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TotalTimeOfFluoroscopy => { GRP => "0040", ELEM => "0300", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TotalNumberOfExposures => { GRP => "0040", ELEM => "0301", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                            EntranceDose => { GRP => "0040", ELEM => "0302", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ExposedArea => { GRP => "0040", ELEM => "0303", VR => "US", VM => "1-2", VERSION =>  "DICOM_2009"},
                                                DistanceSourceToEntrance => { GRP => "0040", ELEM => "0306", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ExposureDoseSequence => { GRP => "0040", ELEM => "030E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CommentsOnRadiationDose => { GRP => "0040", ELEM => "0310", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                              XRayOutput => { GRP => "0040", ELEM => "0312", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          HalfValueLayer => { GRP => "0040", ELEM => "0314", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               OrganDose => { GRP => "0040", ELEM => "0316", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            OrganExposed => { GRP => "0040", ELEM => "0318", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            BillingProcedureStepSequence => { GRP => "0040", ELEM => "0320", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 FilmConsumptionSequence => { GRP => "0040", ELEM => "0321", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       BillingSuppliesAndDevicesSequence => { GRP => "0040", ELEM => "0324", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PerformedSeriesSequence => { GRP => "0040", ELEM => "0340", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     CommentsOnTheScheduledProcedureStep => { GRP => "0040", ELEM => "0400", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ProtocolContextSequence => { GRP => "0040", ELEM => "0440", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             ContentItemModifierSequence => { GRP => "0040", ELEM => "0441", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ScheduledSpecimenSequence => { GRP => "0040", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ContainerIdentifier => { GRP => "0040", ELEM => "0512", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                  IssuerOfTheContainerIdentifierSequence => { GRP => "0040", ELEM => "0513", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    AlternateContainerIdentifierSequence => { GRP => "0040", ELEM => "0515", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ContainerTypeCodeSequence => { GRP => "0040", ELEM => "0518", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContainerDescription => { GRP => "0040", ELEM => "051A", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              ContainerComponentSequence => { GRP => "0040", ELEM => "0520", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SpecimenIdentifier => { GRP => "0040", ELEM => "0551", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                             SpecimenUID => { GRP => "0040", ELEM => "0554", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                              AcquisitionContextSequence => { GRP => "0040", ELEM => "0555", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           AcquisitionContextDescription => { GRP => "0040", ELEM => "0556", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                             SpecimenDescriptionSequence => { GRP => "0040", ELEM => "0560", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   IssuerOfTheSpecimenIdentifierSequence => { GRP => "0040", ELEM => "0562", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                SpecimenTypeCodeSequence => { GRP => "0040", ELEM => "059A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                SpecimenShortDescription => { GRP => "0040", ELEM => "0600", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                             SpecimenDetailedDescription => { GRP => "0040", ELEM => "0602", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                             SpecimenPreparationSequence => { GRP => "0040", ELEM => "0610", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                              SpecimenPreparationStepContentItemSequence => { GRP => "0040", ELEM => "0612", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                 SpecimenLocalizationContentItemSequence => { GRP => "0040", ELEM => "0620", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     ImageCenterPointCoordinatesSequence => { GRP => "0040", ELEM => "071A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          XOffsetInSlideCoordinateSystem => { GRP => "0040", ELEM => "072A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                          YOffsetInSlideCoordinateSystem => { GRP => "0040", ELEM => "073A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ZOffsetInSlideCoordinateSystem => { GRP => "0040", ELEM => "074A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PixelSpacingSequence => { GRP => "0040", ELEM => "08D8", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        CoordinateSystemAxisCodeSequence => { GRP => "0040", ELEM => "08DA", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            MeasurementUnitsCodeSequence => { GRP => "0040", ELEM => "08EA", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RequestedProcedureID => { GRP => "0040", ELEM => "1001", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReasonForTheRequestedProcedure => { GRP => "0040", ELEM => "1002", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              RequestedProcedurePriority => { GRP => "0040", ELEM => "1003", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                            PatientTransportArrangements => { GRP => "0040", ELEM => "1004", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              RequestedProcedureLocation => { GRP => "0040", ELEM => "1005", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ConfidentialityCode => { GRP => "0040", ELEM => "1008", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ReportingPriority => { GRP => "0040", ELEM => "1009", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                 ReasonForRequestedProcedureCodeSequence => { GRP => "0040", ELEM => "100A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      NamesOfIntendedRecipientsOfResults => { GRP => "0040", ELEM => "1010", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                       IntendedRecipientsOfResultsIdentificationSequence => { GRP => "0040", ELEM => "1011", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                 ReasonForPerformedProcedureCodeSequence => { GRP => "0040", ELEM => "1012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        PersonIdentificationCodeSequence => { GRP => "0040", ELEM => "1101", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PersonAddress => { GRP => "0040", ELEM => "1102", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                  PersonTelephoneNumbers => { GRP => "0040", ELEM => "1103", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                              RequestedProcedureComments => { GRP => "0040", ELEM => "1400", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                        IssueDateOfImagingServiceRequest => { GRP => "0040", ELEM => "2004", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                        IssueTimeOfImagingServiceRequest => { GRP => "0040", ELEM => "2005", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                          OrderEnteredBy => { GRP => "0040", ELEM => "2008", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                    OrderEntererLocation => { GRP => "0040", ELEM => "2009", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                OrderCallbackPhoneNumber => { GRP => "0040", ELEM => "2010", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                  PlacerOrderNumberImagingServiceRequest => { GRP => "0040", ELEM => "2016", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                  FillerOrderNumberImagingServiceRequest => { GRP => "0040", ELEM => "2017", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           ImagingServiceRequestComments => { GRP => "0040", ELEM => "2400", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                       ConfidentialityConstraintOnPatientDataDescription => { GRP => "0040", ELEM => "3001", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                              GeneralPurposeScheduledProcedureStepStatus => { GRP => "0040", ELEM => "4001", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                              GeneralPurposePerformedProcedureStepStatus => { GRP => "0040", ELEM => "4002", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                            GeneralPurposeScheduledProcedureStepPriority => { GRP => "0040", ELEM => "4003", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                             ScheduledProcessingApplicationsCodeSequence => { GRP => "0040", ELEM => "4004", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     ScheduledProcedureStepStartDateTime => { GRP => "0040", ELEM => "4005", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                      MultipleCopiesFlag => { GRP => "0040", ELEM => "4006", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                             PerformedProcessingApplicationsCodeSequence => { GRP => "0040", ELEM => "4007", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              HumanPerformerCodeSequence => { GRP => "0040", ELEM => "4009", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                              ScheduledProcedureStepModificationDateTime => { GRP => "0040", ELEM => "4010", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                              ExpectedCompletionDateTime => { GRP => "0040", ELEM => "4011", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                  ResultingGeneralPurposePerformedProcedureStepsSequence => { GRP => "0040", ELEM => "4015", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                  ReferencedGeneralPurposeScheduledProcedureStepSequence => { GRP => "0040", ELEM => "4016", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ScheduledWorkitemCodeSequence => { GRP => "0040", ELEM => "4018", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           PerformedWorkitemCodeSequence => { GRP => "0040", ELEM => "4019", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   InputAvailabilityFlag => { GRP => "0040", ELEM => "4020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                InputInformationSequence => { GRP => "0040", ELEM => "4021", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             RelevantInformationSequence => { GRP => "0040", ELEM => "4022", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
            ReferencedGeneralPurposeScheduledProcedureStepTransactionUID => { GRP => "0040", ELEM => "4023", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                        ScheduledStationNameCodeSequence => { GRP => "0040", ELEM => "4025", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       ScheduledStationClassCodeSequence => { GRP => "0040", ELEM => "4026", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                          ScheduledStationGeographicLocationCodeSequence => { GRP => "0040", ELEM => "4027", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        PerformedStationNameCodeSequence => { GRP => "0040", ELEM => "4028", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       PerformedStationClassCodeSequence => { GRP => "0040", ELEM => "4029", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                          PerformedStationGeographicLocationCodeSequence => { GRP => "0040", ELEM => "4030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                 RequestedSubsequentWorkitemCodeSequence => { GRP => "0040", ELEM => "4031", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              NonDICOMOutputCodeSequence => { GRP => "0040", ELEM => "4032", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               OutputInformationSequence => { GRP => "0040", ELEM => "4033", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        ScheduledHumanPerformersSequence => { GRP => "0040", ELEM => "4034", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ActualHumanPerformersSequence => { GRP => "0040", ELEM => "4035", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              HumanPerformerOrganization => { GRP => "0040", ELEM => "4036", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      HumanPerformerName => { GRP => "0040", ELEM => "4037", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                         RawDataHandling => { GRP => "0040", ELEM => "4040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EntranceDoseInmGy => { GRP => "0040", ELEM => "8302", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                            ReferencedImageRealWorldValueMappingSequence => { GRP => "0040", ELEM => "9094", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           RealWorldValueMappingSequence => { GRP => "0040", ELEM => "9096", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           PixelValueMappingCodeSequence => { GRP => "0040", ELEM => "9098", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                                LUTLabel => { GRP => "0040", ELEM => "9210", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                           RealWorldValueLastValueMapped => { GRP => "0040", ELEM => "9211", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RealWorldValueLUTData => { GRP => "0040", ELEM => "9212", VR => "FD", VM => "1-n", VERSION =>  "DICOM_2009"},
                                          RealWorldValueFirstValueMapped => { GRP => "0040", ELEM => "9216", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RealWorldValueIntercept => { GRP => "0040", ELEM => "9224", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RealWorldValueSlope => { GRP => "0040", ELEM => "9225", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                        RelationshipType => { GRP => "0040", ELEM => "A010", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   VerifyingOrganization => { GRP => "0040", ELEM => "A027", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                    VerificationDateTime => { GRP => "0040", ELEM => "A030", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ObservationDateTime => { GRP => "0040", ELEM => "A032", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                               ValueType => { GRP => "0040", ELEM => "A040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ConceptNameCodeSequence => { GRP => "0040", ELEM => "A043", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ContinuityOfContent => { GRP => "0040", ELEM => "A050", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               VerifyingObserverSequence => { GRP => "0040", ELEM => "A073", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   VerifyingObserverName => { GRP => "0040", ELEM => "A075", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                  AuthorObserverSequence => { GRP => "0040", ELEM => "A078", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ParticipantSequence => { GRP => "0040", ELEM => "A07A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           CustodialOrganizationSequence => { GRP => "0040", ELEM => "A07C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ParticipationType => { GRP => "0040", ELEM => "A080", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ParticipationDateTime => { GRP => "0040", ELEM => "A082", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ObserverType => { GRP => "0040", ELEM => "A084", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                             VerifyingObserverIdentificationCodeSequence => { GRP => "0040", ELEM => "A088", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              ReferencedWaveformChannels => { GRP => "0040", ELEM => "A0B0", VR => "US", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                                DateTime => { GRP => "0040", ELEM => "A120", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                                    Date => { GRP => "0040", ELEM => "A121", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                                    Time => { GRP => "0040", ELEM => "A122", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                              PersonName => { GRP => "0040", ELEM => "A123", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                                     UID => { GRP => "0040", ELEM => "A124", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TemporalRangeType => { GRP => "0040", ELEM => "A130", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferencedSamplePositions => { GRP => "0040", ELEM => "A132", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                  ReferencedFrameNumbers => { GRP => "0040", ELEM => "A136", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   ReferencedTimeOffsets => { GRP => "0040", ELEM => "A138", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      ReferencedDateTime => { GRP => "0040", ELEM => "A13A", VR => "DT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                               TextValue => { GRP => "0040", ELEM => "A160", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ConceptCodeSequence => { GRP => "0040", ELEM => "A168", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          PurposeOfReferenceCodeSequence => { GRP => "0040", ELEM => "A170", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   AnnotationGroupNumber => { GRP => "0040", ELEM => "A180", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ModifierCodeSequence => { GRP => "0040", ELEM => "A195", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MeasuredValueSequence => { GRP => "0040", ELEM => "A300", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       NumericValueQualifierCodeSequence => { GRP => "0040", ELEM => "A301", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            NumericValue => { GRP => "0040", ELEM => "A30A", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                            PredecessorDocumentsSequence => { GRP => "0040", ELEM => "A360", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferencedRequestSequence => { GRP => "0040", ELEM => "A370", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          PerformedProcedureCodeSequence => { GRP => "0040", ELEM => "A372", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                               CurrentRequestedProcedureEvidenceSequence => { GRP => "0040", ELEM => "A375", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          PertinentOtherEvidenceSequence => { GRP => "0040", ELEM => "A385", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  HL7StructuredDocumentReferenceSequence => { GRP => "0040", ELEM => "A390", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          CompletionFlag => { GRP => "0040", ELEM => "A491", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               CompletionFlagDescription => { GRP => "0040", ELEM => "A492", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                        VerificationFlag => { GRP => "0040", ELEM => "A493", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ArchiveRequested => { GRP => "0040", ELEM => "A494", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         PreliminaryFlag => { GRP => "0040", ELEM => "A496", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ContentTemplateSequence => { GRP => "0040", ELEM => "A504", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              IdenticalDocumentsSequence => { GRP => "0040", ELEM => "A525", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ContentSequence => { GRP => "0040", ELEM => "A730", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              WaveformAnnotationSequence => { GRP => "0040", ELEM => "B020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TemplateIdentifier => { GRP => "0040", ELEM => "DB00", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ReferencedContentItemIdentifier => { GRP => "0040", ELEM => "DB73", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   HL7InstanceIdentifier => { GRP => "0040", ELEM => "E001", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                HL7DocumentEffectiveTime => { GRP => "0040", ELEM => "E004", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                             HL7DocumentTypeCodeSequence => { GRP => "0040", ELEM => "E006", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             RetrieveURI => { GRP => "0040", ELEM => "E010", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RetrieveLocationUID => { GRP => "0040", ELEM => "E011", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                           DocumentTitle => { GRP => "0042", ELEM => "0010", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    EncapsulatedDocument => { GRP => "0042", ELEM => "0011", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                          MIMETypeOfEncapsulatedDocument => { GRP => "0042", ELEM => "0012", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SourceInstanceSequence => { GRP => "0042", ELEM => "0013", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ListOfMIMETypes => { GRP => "0042", ELEM => "0014", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                ProductPackageIdentifier => { GRP => "0044", ELEM => "0001", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                         SubstanceAdministrationApproval => { GRP => "0044", ELEM => "0002", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        ApprovalStatusFurtherDescription => { GRP => "0044", ELEM => "0003", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ApprovalStatusDateTime => { GRP => "0044", ELEM => "0004", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ProductTypeCodeSequence => { GRP => "0044", ELEM => "0007", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ProductName => { GRP => "0044", ELEM => "0008", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      ProductDescription => { GRP => "0044", ELEM => "0009", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ProductLotIdentifier => { GRP => "0044", ELEM => "000A", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               ProductExpirationDateTime => { GRP => "0044", ELEM => "000B", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                         SubstanceAdministrationDateTime => { GRP => "0044", ELEM => "0010", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                            SubstanceAdministrationNotes => { GRP => "0044", ELEM => "0011", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         SubstanceAdministrationDeviceID => { GRP => "0044", ELEM => "0012", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                ProductParameterSequence => { GRP => "0044", ELEM => "0013", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                SubstanceAdministrationParameterSequence => { GRP => "0044", ELEM => "0019", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         LensDescription => { GRP => "0046", ELEM => "0012", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RightLensSequence => { GRP => "0046", ELEM => "0014", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        LeftLensSequence => { GRP => "0046", ELEM => "0015", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       UnspecifiedLateralityLensSequence => { GRP => "0046", ELEM => "0016", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        CylinderSequence => { GRP => "0046", ELEM => "0018", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PrismSequence => { GRP => "0046", ELEM => "0028", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    HorizontalPrismPower => { GRP => "0046", ELEM => "0030", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                     HorizontalPrismBase => { GRP => "0046", ELEM => "0032", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      VerticalPrismPower => { GRP => "0046", ELEM => "0034", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       VerticalPrismBase => { GRP => "0046", ELEM => "0036", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         LensSegmentType => { GRP => "0046", ELEM => "0038", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    OpticalTransmittance => { GRP => "0046", ELEM => "0040", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ChannelWidth => { GRP => "0046", ELEM => "0042", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                               PupilSize => { GRP => "0046", ELEM => "0044", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                             CornealSize => { GRP => "0046", ELEM => "0046", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                          AutorefractionRightEyeSequence => { GRP => "0046", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           AutorefractionLeftEyeSequence => { GRP => "0046", ELEM => "0052", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               DistancePupillaryDistance => { GRP => "0046", ELEM => "0060", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NearPupillaryDistance => { GRP => "0046", ELEM => "0062", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                           IntermediatePupillaryDistance => { GRP => "0046", ELEM => "0063", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                  OtherPupillaryDistance => { GRP => "0046", ELEM => "0064", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                             KeratometryRightEyeSequence => { GRP => "0046", ELEM => "0070", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              KeratometryLeftEyeSequence => { GRP => "0046", ELEM => "0071", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           SteepKeratometricAxisSequence => { GRP => "0046", ELEM => "0074", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RadiusOfCurvature => { GRP => "0046", ELEM => "0075", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                       KeratometricPower => { GRP => "0046", ELEM => "0076", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                        KeratometricAxis => { GRP => "0046", ELEM => "0077", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                            FlatKeratometricAxisSequence => { GRP => "0046", ELEM => "0080", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         BackgroundColor => { GRP => "0046", ELEM => "0092", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Optotype => { GRP => "0046", ELEM => "0094", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    OptotypePresentation => { GRP => "0046", ELEM => "0095", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                    SubjectiveRefractionRightEyeSequence => { GRP => "0046", ELEM => "0097", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     SubjectiveRefractionLeftEyeSequence => { GRP => "0046", ELEM => "0098", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AddNearSequence => { GRP => "0046", ELEM => "0100", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 AddIntermediateSequence => { GRP => "0046", ELEM => "0101", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        AddOtherSequence => { GRP => "0046", ELEM => "0102", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                                AddPower => { GRP => "0046", ELEM => "0104", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ViewingDistance => { GRP => "0046", ELEM => "0106", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                            VisualAcuityTypeCodeSequence => { GRP => "0046", ELEM => "0121", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            VisualAcuityRightEyeSequence => { GRP => "0046", ELEM => "0122", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             VisualAcuityLeftEyeSequence => { GRP => "0046", ELEM => "0123", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        VisualAcuityBothEyesOpenSequence => { GRP => "0046", ELEM => "0124", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ViewingDistanceType => { GRP => "0046", ELEM => "0125", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   VisualAcuityModifiers => { GRP => "0046", ELEM => "0135", VR => "SS", VM => "2", VERSION =>  "DICOM_2009"},
                                                     DecimalVisualAcuity => { GRP => "0046", ELEM => "0137", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                              OptotypeDetailedDefinition => { GRP => "0046", ELEM => "0139", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                ReferencedRefractiveMeasurementsSequence => { GRP => "0046", ELEM => "0145", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             SpherePower => { GRP => "0046", ELEM => "0146", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                           CylinderPower => { GRP => "0046", ELEM => "0147", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                        CalibrationImage => { GRP => "0050", ELEM => "0004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DeviceSequence => { GRP => "0050", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      ContainerComponentTypeCodeSequence => { GRP => "0050", ELEM => "0012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             ContainerComponentThickness => { GRP => "0050", ELEM => "0013", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                            DeviceLength => { GRP => "0050", ELEM => "0014", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ContainerComponentWidth => { GRP => "0050", ELEM => "0015", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DeviceDiameter => { GRP => "0050", ELEM => "0016", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DeviceDiameterUnits => { GRP => "0050", ELEM => "0017", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            DeviceVolume => { GRP => "0050", ELEM => "0018", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     InterMarkerDistance => { GRP => "0050", ELEM => "0019", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              ContainerComponentMaterial => { GRP => "0050", ELEM => "001A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContainerComponentID => { GRP => "0050", ELEM => "001B", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                ContainerComponentLength => { GRP => "0050", ELEM => "001C", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                              ContainerComponentDiameter => { GRP => "0050", ELEM => "001D", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                           ContainerComponentDescription => { GRP => "0050", ELEM => "001E", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DeviceDescription => { GRP => "0050", ELEM => "0020", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      EnergyWindowVector => { GRP => "0054", ELEM => "0010", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   NumberOfEnergyWindows => { GRP => "0054", ELEM => "0011", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                         EnergyWindowInformationSequence => { GRP => "0054", ELEM => "0012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               EnergyWindowRangeSequence => { GRP => "0054", ELEM => "0013", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  EnergyWindowLowerLimit => { GRP => "0054", ELEM => "0014", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  EnergyWindowUpperLimit => { GRP => "0054", ELEM => "0015", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                  RadiopharmaceuticalInformationSequence => { GRP => "0054", ELEM => "0016", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ResidualSyringeCounts => { GRP => "0054", ELEM => "0017", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        EnergyWindowName => { GRP => "0054", ELEM => "0018", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DetectorVector => { GRP => "0054", ELEM => "0020", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       NumberOfDetectors => { GRP => "0054", ELEM => "0021", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                             DetectorInformationSequence => { GRP => "0054", ELEM => "0022", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             PhaseVector => { GRP => "0054", ELEM => "0030", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          NumberOfPhases => { GRP => "0054", ELEM => "0031", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                PhaseInformationSequence => { GRP => "0054", ELEM => "0032", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NumberOfFramesInPhase => { GRP => "0054", ELEM => "0033", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                              PhaseDelay => { GRP => "0054", ELEM => "0036", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PauseBetweenFrames => { GRP => "0054", ELEM => "0038", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PhaseDescription => { GRP => "0054", ELEM => "0039", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          RotationVector => { GRP => "0054", ELEM => "0050", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       NumberOfRotations => { GRP => "0054", ELEM => "0051", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                             RotationInformationSequence => { GRP => "0054", ELEM => "0052", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                NumberOfFramesInRotation => { GRP => "0054", ELEM => "0053", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                        RRIntervalVector => { GRP => "0054", ELEM => "0060", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     NumberOfRRIntervals => { GRP => "0054", ELEM => "0061", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                GatedInformationSequence => { GRP => "0054", ELEM => "0062", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DataInformationSequence => { GRP => "0054", ELEM => "0063", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          TimeSlotVector => { GRP => "0054", ELEM => "0070", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       NumberOfTimeSlots => { GRP => "0054", ELEM => "0071", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                             TimeSlotInformationSequence => { GRP => "0054", ELEM => "0072", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            TimeSlotTime => { GRP => "0054", ELEM => "0073", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             SliceVector => { GRP => "0054", ELEM => "0080", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          NumberOfSlices => { GRP => "0054", ELEM => "0081", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                       AngularViewVector => { GRP => "0054", ELEM => "0090", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         TimeSliceVector => { GRP => "0054", ELEM => "0100", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      NumberOfTimeSlices => { GRP => "0054", ELEM => "0101", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                              StartAngle => { GRP => "0054", ELEM => "0200", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TypeOfDetectorMotion => { GRP => "0054", ELEM => "0202", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TriggerVector => { GRP => "0054", ELEM => "0210", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                 NumberOfTriggersInPhase => { GRP => "0054", ELEM => "0211", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ViewCodeSequence => { GRP => "0054", ELEM => "0220", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ViewModifierCodeSequence => { GRP => "0054", ELEM => "0222", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                RadionuclideCodeSequence => { GRP => "0054", ELEM => "0300", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         AdministrationRouteCodeSequence => { GRP => "0054", ELEM => "0302", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         RadiopharmaceuticalCodeSequence => { GRP => "0054", ELEM => "0304", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CalibrationDataSequence => { GRP => "0054", ELEM => "0306", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      EnergyWindowNumber => { GRP => "0054", ELEM => "0308", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 ImageID => { GRP => "0054", ELEM => "0400", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                          PatientOrientationCodeSequence => { GRP => "0054", ELEM => "0410", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  PatientOrientationModifierCodeSequence => { GRP => "0054", ELEM => "0412", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   PatientGantryRelationshipCodeSequence => { GRP => "0054", ELEM => "0414", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               SliceProgressionDirection => { GRP => "0054", ELEM => "0500", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              SeriesType => { GRP => "0054", ELEM => "1000", VR => "CS", VM => "2", VERSION =>  "DICOM_2009"},
                                                                   Units => { GRP => "0054", ELEM => "1001", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            CountsSource => { GRP => "0054", ELEM => "1002", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ReprojectionMethod => { GRP => "0054", ELEM => "1004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RandomsCorrectionMethod => { GRP => "0054", ELEM => "1100", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             AttenuationCorrectionMethod => { GRP => "0054", ELEM => "1101", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         DecayCorrection => { GRP => "0054", ELEM => "1102", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReconstructionMethod => { GRP => "0054", ELEM => "1103", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                             DetectorLinesOfResponseUsed => { GRP => "0054", ELEM => "1104", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ScatterCorrectionMethod => { GRP => "0054", ELEM => "1105", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         AxialAcceptance => { GRP => "0054", ELEM => "1200", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               AxialMash => { GRP => "0054", ELEM => "1201", VR => "IS", VM => "2", VERSION =>  "DICOM_2009"},
                                                          TransverseMash => { GRP => "0054", ELEM => "1202", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DetectorElementSize => { GRP => "0054", ELEM => "1203", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                  CoincidenceWindowWidth => { GRP => "0054", ELEM => "1210", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SecondaryCountsType => { GRP => "0054", ELEM => "1220", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      FrameReferenceTime => { GRP => "0054", ELEM => "1300", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         PrimaryPromptsCountsAccumulated => { GRP => "0054", ELEM => "1310", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              SecondaryCountsAccumulated => { GRP => "0054", ELEM => "1311", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                  SliceSensitivityFactor => { GRP => "0054", ELEM => "1320", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             DecayFactor => { GRP => "0054", ELEM => "1321", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   DoseCalibrationFactor => { GRP => "0054", ELEM => "1322", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ScatterFractionFactor => { GRP => "0054", ELEM => "1323", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DeadTimeFactor => { GRP => "0054", ELEM => "1324", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ImageIndex => { GRP => "0054", ELEM => "1330", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                       HistogramSequence => { GRP => "0060", ELEM => "3000", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   HistogramNumberOfBins => { GRP => "0060", ELEM => "3002", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  HistogramFirstBinValue => { GRP => "0060", ELEM => "3004", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                   HistogramLastBinValue => { GRP => "0060", ELEM => "3006", VR => "xs", VM => "1", VERSION =>  "DICOM_2009"},
                                                       HistogramBinWidth => { GRP => "0060", ELEM => "3008", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                    HistogramExplanation => { GRP => "0060", ELEM => "3010", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                           HistogramData => { GRP => "0060", ELEM => "3020", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                        SegmentationType => { GRP => "0062", ELEM => "0001", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SegmentSequence => { GRP => "0062", ELEM => "0002", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   SegmentedPropertyCategoryCodeSequence => { GRP => "0062", ELEM => "0003", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SegmentNumber => { GRP => "0062", ELEM => "0004", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                            SegmentLabel => { GRP => "0062", ELEM => "0005", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SegmentDescription => { GRP => "0062", ELEM => "0006", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SegmentAlgorithmType => { GRP => "0062", ELEM => "0008", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SegmentAlgorithmName => { GRP => "0062", ELEM => "0009", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           SegmentIdentificationSequence => { GRP => "0062", ELEM => "000A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReferencedSegmentNumber => { GRP => "0062", ELEM => "000B", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                        RecommendedDisplayGrayscaleValue => { GRP => "0062", ELEM => "000C", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                           RecommendedDisplayCIELabValue => { GRP => "0062", ELEM => "000D", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                                  MaximumFractionalValue => { GRP => "0062", ELEM => "000E", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                       SegmentedPropertyTypeCodeSequence => { GRP => "0062", ELEM => "000F", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              SegmentationFractionalType => { GRP => "0062", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          DeformableRegistrationSequence => { GRP => "0064", ELEM => "0002", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               SourceFrameOfReferenceUID => { GRP => "0064", ELEM => "0003", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                      DeformableRegistrationGridSequence => { GRP => "0064", ELEM => "0005", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          GridDimensions => { GRP => "0064", ELEM => "0007", VR => "UL", VM => "3", VERSION =>  "DICOM_2009"},
                                                          GridResolution => { GRP => "0064", ELEM => "0008", VR => "FD", VM => "3", VERSION =>  "DICOM_2009"},
                                                          VectorGridData => { GRP => "0064", ELEM => "0009", VR => "OF", VM => "1", VERSION =>  "DICOM_2009"},
                                PreDeformationMatrixRegistrationSequence => { GRP => "0064", ELEM => "000F", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                               PostDeformationMatrixRegistrationSequence => { GRP => "0064", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        NumberOfSurfaces => { GRP => "0066", ELEM => "0001", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SurfaceSequence => { GRP => "0066", ELEM => "0002", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SurfaceNumber => { GRP => "0066", ELEM => "0003", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SurfaceComments => { GRP => "0066", ELEM => "0004", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SurfaceProcessing => { GRP => "0066", ELEM => "0009", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SurfaceProcessingRatio => { GRP => "0066", ELEM => "000A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            SurfaceProcessingDescription => { GRP => "0066", ELEM => "000B", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          RecommendedPresentationOpacity => { GRP => "0066", ELEM => "000C", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             RecommendedPresentationType => { GRP => "0066", ELEM => "000D", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            FiniteVolume => { GRP => "0066", ELEM => "000E", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Manifold => { GRP => "0066", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   SurfacePointsSequence => { GRP => "0066", ELEM => "0011", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            SurfacePointsNormalsSequence => { GRP => "0066", ELEM => "0012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           SurfaceMeshPrimitivesSequence => { GRP => "0066", ELEM => "0013", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NumberOfSurfacePoints => { GRP => "0066", ELEM => "0015", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PointCoordinatesData => { GRP => "0066", ELEM => "0016", VR => "OF", VM => "1", VERSION =>  "DICOM_2009"},
                                                   PointPositionAccuracy => { GRP => "0066", ELEM => "0017", VR => "FL", VM => "3", VERSION =>  "DICOM_2009"},
                                                       MeanPointDistance => { GRP => "0066", ELEM => "0018", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    MaximumPointDistance => { GRP => "0066", ELEM => "0019", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            PointsBoundingBoxCoordinates => { GRP => "0066", ELEM => "001A", VR => "FL", VM => "6", VERSION =>  "DICOM_2009"},
                                                          AxisOfRotation => { GRP => "0066", ELEM => "001B", VR => "FL", VM => "3", VERSION =>  "DICOM_2009"},
                                                        CenterOfRotation => { GRP => "0066", ELEM => "001C", VR => "FL", VM => "3", VERSION =>  "DICOM_2009"},
                                                         NumberOfVectors => { GRP => "0066", ELEM => "001E", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    VectorDimensionality => { GRP => "0066", ELEM => "001F", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                          VectorAccuracy => { GRP => "0066", ELEM => "0020", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    VectorCoordinateData => { GRP => "0066", ELEM => "0021", VR => "OF", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TrianglePointIndexList => { GRP => "0066", ELEM => "0023", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                                      EdgePointIndexList => { GRP => "0066", ELEM => "0024", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                                    VertexPointIndexList => { GRP => "0066", ELEM => "0025", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                                   TriangleStripSequence => { GRP => "0066", ELEM => "0026", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     TriangleFanSequence => { GRP => "0066", ELEM => "0027", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            LineSequence => { GRP => "0066", ELEM => "0028", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PrimitivePointIndexList => { GRP => "0066", ELEM => "0029", VR => "OW", VM => "1", VERSION =>  "DICOM_2009"},
                                                            SurfaceCount => { GRP => "0066", ELEM => "002A", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferencedSurfaceSequence => { GRP => "0066", ELEM => "002B", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReferencedSurfaceNumber => { GRP => "0066", ELEM => "002C", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                 SegmentSurfaceGenerationAlgorithmIdentificationSequence => { GRP => "0066", ELEM => "002D", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    SegmentSurfaceSourceInstanceSequence => { GRP => "0066", ELEM => "002E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             AlgorithmFamilyCodeSequence => { GRP => "0066", ELEM => "002F", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               AlgorithmNameCodeSequence => { GRP => "0066", ELEM => "0030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        AlgorithmVersion => { GRP => "0066", ELEM => "0031", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AlgorithmParameters => { GRP => "0066", ELEM => "0032", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                           FacetSequence => { GRP => "0066", ELEM => "0034", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                        SurfaceProcessingAlgorithmIdentificationSequence => { GRP => "0066", ELEM => "0035", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           AlgorithmName => { GRP => "0066", ELEM => "0036", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               GraphicAnnotationSequence => { GRP => "0070", ELEM => "0001", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            GraphicLayer => { GRP => "0070", ELEM => "0002", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              BoundingBoxAnnotationUnits => { GRP => "0070", ELEM => "0003", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              AnchorPointAnnotationUnits => { GRP => "0070", ELEM => "0004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  GraphicAnnotationUnits => { GRP => "0070", ELEM => "0005", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    UnformattedTextValue => { GRP => "0070", ELEM => "0006", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TextObjectSequence => { GRP => "0070", ELEM => "0008", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   GraphicObjectSequence => { GRP => "0070", ELEM => "0009", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            BoundingBoxTopLeftHandCorner => { GRP => "0070", ELEM => "0010", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                        BoundingBoxBottomRightHandCorner => { GRP => "0070", ELEM => "0011", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                  BoundingBoxTextHorizontalJustification => { GRP => "0070", ELEM => "0012", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             AnchorPoint => { GRP => "0070", ELEM => "0014", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                                   AnchorPointVisibility => { GRP => "0070", ELEM => "0015", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       GraphicDimensions => { GRP => "0070", ELEM => "0020", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NumberOfGraphicPoints => { GRP => "0070", ELEM => "0021", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                             GraphicData => { GRP => "0070", ELEM => "0022", VR => "FL", VM => "2-n", VERSION =>  "DICOM_2009"},
                                                             GraphicType => { GRP => "0070", ELEM => "0023", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           GraphicFilled => { GRP => "0070", ELEM => "0024", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ImageHorizontalFlip => { GRP => "0070", ELEM => "0041", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ImageRotation => { GRP => "0070", ELEM => "0042", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                          DisplayedAreaTopLeftHandCorner => { GRP => "0070", ELEM => "0052", VR => "SL", VM => "2", VERSION =>  "DICOM_2009"},
                                      DisplayedAreaBottomRightHandCorner => { GRP => "0070", ELEM => "0053", VR => "SL", VM => "2", VERSION =>  "DICOM_2009"},
                                          DisplayedAreaSelectionSequence => { GRP => "0070", ELEM => "005A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    GraphicLayerSequence => { GRP => "0070", ELEM => "0060", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       GraphicLayerOrder => { GRP => "0070", ELEM => "0062", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                            GraphicLayerRecommendedDisplayGrayscaleValue => { GRP => "0070", ELEM => "0066", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 GraphicLayerDescription => { GRP => "0070", ELEM => "0068", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ContentLabel => { GRP => "0070", ELEM => "0080", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ContentDescription => { GRP => "0070", ELEM => "0081", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                PresentationCreationDate => { GRP => "0070", ELEM => "0082", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                PresentationCreationTime => { GRP => "0070", ELEM => "0083", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ContentCreatorName => { GRP => "0070", ELEM => "0084", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                ContentCreatorIdentificationCodeSequence => { GRP => "0070", ELEM => "0086", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     AlternateContentDescriptionSequence => { GRP => "0070", ELEM => "0087", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PresentationSizeMode => { GRP => "0070", ELEM => "0100", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                PresentationPixelSpacing => { GRP => "0070", ELEM => "0101", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                            PresentationPixelAspectRatio => { GRP => "0070", ELEM => "0102", VR => "IS", VM => "2", VERSION =>  "DICOM_2009"},
                                     PresentationPixelMagnificationRatio => { GRP => "0070", ELEM => "0103", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                               ShapeType => { GRP => "0070", ELEM => "0306", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RegistrationSequence => { GRP => "0070", ELEM => "0308", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              MatrixRegistrationSequence => { GRP => "0070", ELEM => "0309", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          MatrixSequence => { GRP => "0070", ELEM => "030A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                FrameOfReferenceTransformationMatrixType => { GRP => "0070", ELEM => "030C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            RegistrationTypeCodeSequence => { GRP => "0070", ELEM => "030D", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     FiducialDescription => { GRP => "0070", ELEM => "030F", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                      FiducialIdentifier => { GRP => "0070", ELEM => "0310", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                          FiducialIdentifierCodeSequence => { GRP => "0070", ELEM => "0311", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ContourUncertaintyRadius => { GRP => "0070", ELEM => "0312", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                   UsedFiducialsSequence => { GRP => "0070", ELEM => "0314", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          GraphicCoordinatesDataSequence => { GRP => "0070", ELEM => "0318", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             FiducialUID => { GRP => "0070", ELEM => "031A", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                     FiducialSetSequence => { GRP => "0070", ELEM => "031C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FiducialSequence => { GRP => "0070", ELEM => "031E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                               GraphicLayerRecommendedDisplayCIELabValue => { GRP => "0070", ELEM => "0401", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                                        BlendingSequence => { GRP => "0070", ELEM => "0402", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         RelativeOpacity => { GRP => "0070", ELEM => "0403", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                   ReferencedSpatialRegistrationSequence => { GRP => "0070", ELEM => "0404", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BlendingPosition => { GRP => "0070", ELEM => "0405", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     HangingProtocolName => { GRP => "0072", ELEM => "0002", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                              HangingProtocolDescription => { GRP => "0072", ELEM => "0004", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                    HangingProtocolLevel => { GRP => "0072", ELEM => "0006", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  HangingProtocolCreator => { GRP => "0072", ELEM => "0008", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         HangingProtocolCreationDateTime => { GRP => "0072", ELEM => "000A", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                       HangingProtocolDefinitionSequence => { GRP => "0072", ELEM => "000C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                           HangingProtocolUserIdentificationCodeSequence => { GRP => "0072", ELEM => "000E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            HangingProtocolUserGroupName => { GRP => "0072", ELEM => "0010", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           SourceHangingProtocolSequence => { GRP => "0072", ELEM => "0012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                NumberOfPriorsReferenced => { GRP => "0072", ELEM => "0014", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ImageSetsSequence => { GRP => "0072", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ImageSetSelectorSequence => { GRP => "0072", ELEM => "0022", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ImageSetSelectorUsageFlag => { GRP => "0072", ELEM => "0024", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SelectorAttribute => { GRP => "0072", ELEM => "0026", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SelectorValueNumber => { GRP => "0072", ELEM => "0028", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                              TimeBasedImageSetsSequence => { GRP => "0072", ELEM => "0030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ImageSetNumber => { GRP => "0072", ELEM => "0032", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                ImageSetSelectorCategory => { GRP => "0072", ELEM => "0034", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            RelativeTime => { GRP => "0072", ELEM => "0038", VR => "US", VM => "2", VERSION =>  "DICOM_2009"},
                                                       RelativeTimeUnits => { GRP => "0072", ELEM => "003A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      AbstractPriorValue => { GRP => "0072", ELEM => "003C", VR => "SS", VM => "2", VERSION =>  "DICOM_2009"},
                                               AbstractPriorCodeSequence => { GRP => "0072", ELEM => "003E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ImageSetLabel => { GRP => "0072", ELEM => "0040", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SelectorAttributeVR => { GRP => "0072", ELEM => "0050", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 SelectorSequencePointer => { GRP => "0072", ELEM => "0052", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                   SelectorSequencePointerPrivateCreator => { GRP => "0072", ELEM => "0054", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         SelectorAttributePrivateCreator => { GRP => "0072", ELEM => "0056", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SelectorATValue => { GRP => "0072", ELEM => "0060", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorCSValue => { GRP => "0072", ELEM => "0062", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorISValue => { GRP => "0072", ELEM => "0064", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorLOValue => { GRP => "0072", ELEM => "0066", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorLTValue => { GRP => "0072", ELEM => "0068", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SelectorPNValue => { GRP => "0072", ELEM => "006A", VR => "PN", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorSHValue => { GRP => "0072", ELEM => "006C", VR => "SH", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorSTValue => { GRP => "0072", ELEM => "006E", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SelectorUTValue => { GRP => "0072", ELEM => "0070", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SelectorDSValue => { GRP => "0072", ELEM => "0072", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorFDValue => { GRP => "0072", ELEM => "0074", VR => "FD", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorFLValue => { GRP => "0072", ELEM => "0076", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorULValue => { GRP => "0072", ELEM => "0078", VR => "UL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorUSValue => { GRP => "0072", ELEM => "007A", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorSLValue => { GRP => "0072", ELEM => "007C", VR => "SL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                         SelectorSSValue => { GRP => "0072", ELEM => "007E", VR => "SS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                               SelectorCodeSequenceValue => { GRP => "0072", ELEM => "0080", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         NumberOfScreens => { GRP => "0072", ELEM => "0100", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                         NominalScreenDefinitionSequence => { GRP => "0072", ELEM => "0102", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  NumberOfVerticalPixels => { GRP => "0072", ELEM => "0104", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                NumberOfHorizontalPixels => { GRP => "0072", ELEM => "0106", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                       DisplayEnvironmentSpatialPosition => { GRP => "0072", ELEM => "0108", VR => "FD", VM => "4", VERSION =>  "DICOM_2009"},
                                          ScreenMinimumGrayscaleBitDepth => { GRP => "0072", ELEM => "010A", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                              ScreenMinimumColorBitDepth => { GRP => "0072", ELEM => "010C", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                           ApplicationMaximumRepaintTime => { GRP => "0072", ELEM => "010E", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DisplaySetsSequence => { GRP => "0072", ELEM => "0200", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DisplaySetNumber => { GRP => "0072", ELEM => "0202", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                         DisplaySetLabel => { GRP => "0072", ELEM => "0203", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                             DisplaySetPresentationGroup => { GRP => "0072", ELEM => "0204", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                  DisplaySetPresentationGroupDescription => { GRP => "0072", ELEM => "0206", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                              PartialDataDisplayHandling => { GRP => "0072", ELEM => "0208", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           SynchronizedScrollingSequence => { GRP => "0072", ELEM => "0210", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                DisplaySetScrollingGroup => { GRP => "0072", ELEM => "0212", VR => "US", VM => "2-n", VERSION =>  "DICOM_2009"},
                                             NavigationIndicatorSequence => { GRP => "0072", ELEM => "0214", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    NavigationDisplaySet => { GRP => "0072", ELEM => "0216", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReferenceDisplaySets => { GRP => "0072", ELEM => "0218", VR => "US", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                      ImageBoxesSequence => { GRP => "0072", ELEM => "0300", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ImageBoxNumber => { GRP => "0072", ELEM => "0302", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ImageBoxLayoutType => { GRP => "0072", ELEM => "0304", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ImageBoxTileHorizontalDimension => { GRP => "0072", ELEM => "0306", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                           ImageBoxTileVerticalDimension => { GRP => "0072", ELEM => "0308", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ImageBoxScrollDirection => { GRP => "0072", ELEM => "0310", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ImageBoxSmallScrollType => { GRP => "0072", ELEM => "0312", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               ImageBoxSmallScrollAmount => { GRP => "0072", ELEM => "0314", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ImageBoxLargeScrollType => { GRP => "0072", ELEM => "0316", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               ImageBoxLargeScrollAmount => { GRP => "0072", ELEM => "0318", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ImageBoxOverlapPriority => { GRP => "0072", ELEM => "0320", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CineRelativeToRealTime => { GRP => "0072", ELEM => "0330", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                FilterOperationsSequence => { GRP => "0072", ELEM => "0400", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FilterByCategory => { GRP => "0072", ELEM => "0402", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               FilterByAttributePresence => { GRP => "0072", ELEM => "0404", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FilterByOperator => { GRP => "0072", ELEM => "0406", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                  StructuredDisplayBackgroundCIELabValue => { GRP => "0072", ELEM => "0420", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                                EmptyImageBoxCIELabValue => { GRP => "0072", ELEM => "0421", VR => "US", VM => "3", VERSION =>  "DICOM_2009"},
                                       StructuredDisplayImageBoxSequence => { GRP => "0072", ELEM => "0422", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        StructuredDisplayTextBoxSequence => { GRP => "0072", ELEM => "0424", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencedFirstFrameSequence => { GRP => "0072", ELEM => "0427", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         ImageBoxSynchronizationSequence => { GRP => "0072", ELEM => "0430", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                SynchronizedImageBoxList => { GRP => "0072", ELEM => "0432", VR => "US", VM => "2-n", VERSION =>  "DICOM_2009"},
                                                   TypeOfSynchronization => { GRP => "0072", ELEM => "0434", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   BlendingOperationType => { GRP => "0072", ELEM => "0500", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReformattingOperationType => { GRP => "0072", ELEM => "0510", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReformattingThickness => { GRP => "0072", ELEM => "0512", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReformattingInterval => { GRP => "0072", ELEM => "0514", VR => "FD", VM => "1", VERSION =>  "DICOM_2009"},
                               ReformattingOperationInitialViewDirection => { GRP => "0072", ELEM => "0516", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ThreeDRenderingType => { GRP => "0072", ELEM => "0520", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                               SortingOperationsSequence => { GRP => "0072", ELEM => "0600", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          SortByCategory => { GRP => "0072", ELEM => "0602", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        SortingDirection => { GRP => "0072", ELEM => "0604", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            DisplaySetPatientOrientation => { GRP => "0072", ELEM => "0700", VR => "CS", VM => "2", VERSION =>  "DICOM_2009"},
                                                                 VOIType => { GRP => "0072", ELEM => "0702", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         PseudoColorType => { GRP => "0072", ELEM => "0704", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ShowGrayscaleInverted => { GRP => "0072", ELEM => "0706", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ShowImageTrueSizeFlag => { GRP => "0072", ELEM => "0710", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               ShowGraphicAnnotationFlag => { GRP => "0072", ELEM => "0712", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             ShowPatientDemographicsFlag => { GRP => "0072", ELEM => "0714", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           ShowAcquisitionTechniquesFlag => { GRP => "0072", ELEM => "0716", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       DisplaySetHorizontalJustification => { GRP => "0072", ELEM => "0717", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                         DisplaySetVerticalJustification => { GRP => "0072", ELEM => "0718", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               UnifiedProcedureStepState => { GRP => "0074", ELEM => "1000", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                         UnifiedProcedureStepProgressInformationSequence => { GRP => "0074", ELEM => "1002", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            UnifiedProcedureStepProgress => { GRP => "0074", ELEM => "1004", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                 UnifiedProcedureStepProgressDescription => { GRP => "0074", ELEM => "1006", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                           UnifiedProcedureStepCommunicationsURISequence => { GRP => "0074", ELEM => "1008", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ContactURI => { GRP => "0074", ELEM => "100A", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ContactDisplayName => { GRP => "0074", ELEM => "100C", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                   UnifiedProcedureStepDiscontinuationReasonCodeSequence => { GRP => "0074", ELEM => "100E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BeamTaskSequence => { GRP => "0074", ELEM => "1020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            BeamTaskType => { GRP => "0074", ELEM => "1022", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          BeamOrderIndex => { GRP => "0074", ELEM => "1024", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                       DeliveryVerificationImageSequence => { GRP => "0074", ELEM => "1030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 VerificationImageTiming => { GRP => "0074", ELEM => "1032", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DoubleExposureFlag => { GRP => "0074", ELEM => "1034", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DoubleExposureOrdering => { GRP => "0074", ELEM => "1036", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DoubleExposureMeterset => { GRP => "0074", ELEM => "1038", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                DoubleExposureFieldDelta => { GRP => "0074", ELEM => "103A", VR => "DS", VM => "4", VERSION =>  "DICOM_2009"},
                                         RelatedReferenceRTImageSequence => { GRP => "0074", ELEM => "1040", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      GeneralMachineVerificationSequence => { GRP => "0074", ELEM => "1042", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                 ConventionalMachineVerificationSequence => { GRP => "0074", ELEM => "1044", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          IonMachineVerificationSequence => { GRP => "0074", ELEM => "1046", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                FailedAttributesSequence => { GRP => "0074", ELEM => "1048", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            OverriddenAttributesSequence => { GRP => "0074", ELEM => "104A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                            ConventionalControlPointVerificationSequence => { GRP => "0074", ELEM => "104C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     IonControlPointVerificationSequence => { GRP => "0074", ELEM => "104E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             AttributeOccurrenceSequence => { GRP => "0074", ELEM => "1050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              AttributeOccurrencePointer => { GRP => "0074", ELEM => "1052", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                                   AttributeItemSelector => { GRP => "0074", ELEM => "1054", VR => "UL", VM => "1", VERSION =>  "DICOM_2009"},
                                       AttributeOccurrencePrivateCreator => { GRP => "0074", ELEM => "1056", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          ScheduledProcedureStepPriority => { GRP => "0074", ELEM => "1200", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           WorklistLabel => { GRP => "0074", ELEM => "1202", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ProcedureStepLabel => { GRP => "0074", ELEM => "1204", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                   ScheduledProcessingParametersSequence => { GRP => "0074", ELEM => "1210", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   PerformedProcessingParametersSequence => { GRP => "0074", ELEM => "1212", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                          UnifiedProcedureStepPerformedProcedureSequence => { GRP => "0074", ELEM => "1216", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            RelatedProcedureStepSequence => { GRP => "0074", ELEM => "1220", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ProcedureStepRelationshipType => { GRP => "0074", ELEM => "1222", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                            DeletionLock => { GRP => "0074", ELEM => "1230", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                             ReceivingAE => { GRP => "0074", ELEM => "1234", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                                            RequestingAE => { GRP => "0074", ELEM => "1236", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReasonForCancellation => { GRP => "0074", ELEM => "1238", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                               SCPStatus => { GRP => "0074", ELEM => "1242", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SubscriptionListStatus => { GRP => "0074", ELEM => "1244", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                          UnifiedProcedureStepListStatus => { GRP => "0074", ELEM => "1246", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   StorageMediaFileSetID => { GRP => "0088", ELEM => "0130", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                  StorageMediaFileSetUID => { GRP => "0088", ELEM => "0140", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                       IconImageSequence => { GRP => "0088", ELEM => "0200", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SOPInstanceStatus => { GRP => "0100", ELEM => "0410", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                SOPAuthorizationDateTime => { GRP => "0100", ELEM => "0420", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                 SOPAuthorizationComment => { GRP => "0100", ELEM => "0424", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                               AuthorizationEquipmentCertificationNumber => { GRP => "0100", ELEM => "0426", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                             MACIDNumber => { GRP => "0400", ELEM => "0005", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                         MACCalculationTransferSyntaxUID => { GRP => "0400", ELEM => "0010", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                            MACAlgorithm => { GRP => "0400", ELEM => "0015", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DataElementsSigned => { GRP => "0400", ELEM => "0020", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                     DigitalSignatureUID => { GRP => "0400", ELEM => "0100", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                DigitalSignatureDateTime => { GRP => "0400", ELEM => "0105", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                         CertificateType => { GRP => "0400", ELEM => "0110", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CertificateOfSigner => { GRP => "0400", ELEM => "0115", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                                               Signature => { GRP => "0400", ELEM => "0120", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CertifiedTimestampType => { GRP => "0400", ELEM => "0305", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CertifiedTimestamp => { GRP => "0400", ELEM => "0310", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                     DigitalSignaturePurposeCodeSequence => { GRP => "0400", ELEM => "0401", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                      ReferencedDigitalSignatureSequence => { GRP => "0400", ELEM => "0402", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        ReferencedSOPInstanceMACSequence => { GRP => "0400", ELEM => "0403", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                                     MAC => { GRP => "0400", ELEM => "0404", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                             EncryptedAttributesSequence => { GRP => "0400", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                       EncryptedContentTransferSyntaxUID => { GRP => "0400", ELEM => "0510", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                        EncryptedContent => { GRP => "0400", ELEM => "0520", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                              ModifiedAttributesSequence => { GRP => "0400", ELEM => "0550", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              OriginalAttributesSequence => { GRP => "0400", ELEM => "0561", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           AttributeModificationDateTime => { GRP => "0400", ELEM => "0562", VR => "DT", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ModifyingSystem => { GRP => "0400", ELEM => "0563", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SourceOfPreviousValues => { GRP => "0400", ELEM => "0564", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                       ReasonForTheAttributeModification => { GRP => "0400", ELEM => "0565", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          NumberOfCopies => { GRP => "2000", ELEM => "0010", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                            PrinterConfigurationSequence => { GRP => "2000", ELEM => "001E", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PrintPriority => { GRP => "2000", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              MediumType => { GRP => "2000", ELEM => "0030", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         FilmDestination => { GRP => "2000", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FilmSessionLabel => { GRP => "2000", ELEM => "0050", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                        MemoryAllocation => { GRP => "2000", ELEM => "0060", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 MaximumMemoryAllocation => { GRP => "2000", ELEM => "0061", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          MemoryBitDepth => { GRP => "2000", ELEM => "00A0", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PrintingBitDepth => { GRP => "2000", ELEM => "00A1", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                  MediaInstalledSequence => { GRP => "2000", ELEM => "00A2", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             OtherMediaAvailableSequence => { GRP => "2000", ELEM => "00A4", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    SupportedImageDisplayFormatsSequence => { GRP => "2000", ELEM => "00A8", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ReferencedFilmBoxSequence => { GRP => "2000", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ImageDisplayFormat => { GRP => "2010", ELEM => "0010", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                               AnnotationDisplayFormatID => { GRP => "2010", ELEM => "0030", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         FilmOrientation => { GRP => "2010", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              FilmSizeID => { GRP => "2010", ELEM => "0050", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PrinterResolutionID => { GRP => "2010", ELEM => "0052", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              DefaultPrinterResolutionID => { GRP => "2010", ELEM => "0054", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       MagnificationType => { GRP => "2010", ELEM => "0060", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SmoothingType => { GRP => "2010", ELEM => "0080", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                DefaultMagnificationType => { GRP => "2010", ELEM => "00A6", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                        OtherMagnificationTypesAvailable => { GRP => "2010", ELEM => "00A7", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                    DefaultSmoothingType => { GRP => "2010", ELEM => "00A8", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            OtherSmoothingTypesAvailable => { GRP => "2010", ELEM => "00A9", VR => "CS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                           BorderDensity => { GRP => "2010", ELEM => "0100", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       EmptyImageDensity => { GRP => "2010", ELEM => "0110", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              MinDensity => { GRP => "2010", ELEM => "0120", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                              MaxDensity => { GRP => "2010", ELEM => "0130", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                                    Trim => { GRP => "2010", ELEM => "0140", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                ConfigurationInformation => { GRP => "2010", ELEM => "0150", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                     ConfigurationInformationDescription => { GRP => "2010", ELEM => "0152", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                    MaximumCollatedFilms => { GRP => "2010", ELEM => "0154", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            Illumination => { GRP => "2010", ELEM => "015E", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReflectedAmbientLight => { GRP => "2010", ELEM => "0160", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PrinterPixelSpacing => { GRP => "2010", ELEM => "0376", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                           ReferencedFilmSessionSequence => { GRP => "2010", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              ReferencedImageBoxSequence => { GRP => "2010", ELEM => "0510", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                    ReferencedBasicAnnotationBoxSequence => { GRP => "2010", ELEM => "0520", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ImageBoxPosition => { GRP => "2020", ELEM => "0010", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                                Polarity => { GRP => "2020", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RequestedImageSize => { GRP => "2020", ELEM => "0030", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           RequestedDecimateCropBehavior => { GRP => "2020", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RequestedResolutionID => { GRP => "2020", ELEM => "0050", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RequestedImageSizeFlag => { GRP => "2020", ELEM => "00A0", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      DecimateCropResult => { GRP => "2020", ELEM => "00A2", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             BasicGrayscaleImageSequence => { GRP => "2020", ELEM => "0110", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 BasicColorImageSequence => { GRP => "2020", ELEM => "0111", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      AnnotationPosition => { GRP => "2030", ELEM => "0010", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                                              TextString => { GRP => "2030", ELEM => "0020", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PresentationLUTSequence => { GRP => "2050", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PresentationLUTShape => { GRP => "2050", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       ReferencedPresentationLUTSequence => { GRP => "2050", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ExecutionStatus => { GRP => "2100", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ExecutionStatusInfo => { GRP => "2100", ELEM => "0030", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            CreationDate => { GRP => "2100", ELEM => "0040", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                            CreationTime => { GRP => "2100", ELEM => "0050", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                              Originator => { GRP => "2100", ELEM => "0070", VR => "AE", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 OwnerID => { GRP => "2100", ELEM => "0160", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                           NumberOfFilms => { GRP => "2100", ELEM => "0170", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           PrinterStatus => { GRP => "2110", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PrinterStatusInfo => { GRP => "2110", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             PrinterName => { GRP => "2110", ELEM => "0030", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                             LabelUsingInformationExtractedFromInstances => { GRP => "2200", ELEM => "0001", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               LabelText => { GRP => "2200", ELEM => "0002", VR => "UT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     LabelStyleSelection => { GRP => "2200", ELEM => "0003", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        MediaDisposition => { GRP => "2200", ELEM => "0004", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                            BarcodeValue => { GRP => "2200", ELEM => "0005", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BarcodeSymbology => { GRP => "2200", ELEM => "0006", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     AllowMediaSplitting => { GRP => "2200", ELEM => "0007", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  IncludeNonDICOMObjects => { GRP => "2200", ELEM => "0008", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               IncludeDisplayApplication => { GRP => "2200", ELEM => "0009", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                            PreserveCompositeInstancesAfterMediaCreation => { GRP => "2200", ELEM => "000A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       TotalNumberOfPiecesOfMediaCreated => { GRP => "2200", ELEM => "000B", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                        RequestedMediaApplicationProfile => { GRP => "2200", ELEM => "000C", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedStorageMediaSequence => { GRP => "2200", ELEM => "000D", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       FailureAttributes => { GRP => "2200", ELEM => "000E", VR => "AT", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   AllowLossyCompression => { GRP => "2200", ELEM => "000F", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         RequestPriority => { GRP => "2200", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            RTImageLabel => { GRP => "3002", ELEM => "0002", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                             RTImageName => { GRP => "3002", ELEM => "0003", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RTImageDescription => { GRP => "3002", ELEM => "0004", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReportedValuesOrigin => { GRP => "3002", ELEM => "000A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            RTImagePlane => { GRP => "3002", ELEM => "000C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                            XRayImageReceptorTranslation => { GRP => "3002", ELEM => "000D", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                  XRayImageReceptorAngle => { GRP => "3002", ELEM => "000E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RTImageOrientation => { GRP => "3002", ELEM => "0010", VR => "DS", VM => "6", VERSION =>  "DICOM_2009"},
                                                  ImagePlanePixelSpacing => { GRP => "3002", ELEM => "0011", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                         RTImagePosition => { GRP => "3002", ELEM => "0012", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                    RadiationMachineName => { GRP => "3002", ELEM => "0020", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},

                                                     RadiationMachineSAD => { GRP => "3002", ELEM => "0022", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RadiationMachineSSD => { GRP => "3002", ELEM => "0024", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              RTImageSID => { GRP => "3002", ELEM => "0026", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         SourceToReferenceObjectDistance => { GRP => "3002", ELEM => "0028", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          FractionNumber => { GRP => "3002", ELEM => "0029", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ExposureSequence => { GRP => "3002", ELEM => "0030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        MetersetExposure => { GRP => "3002", ELEM => "0032", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DiaphragmPosition => { GRP => "3002", ELEM => "0034", VR => "DS", VM => "4", VERSION =>  "DICOM_2009"},
                                                      FluenceMapSequence => { GRP => "3002", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       FluenceDataSource => { GRP => "3002", ELEM => "0041", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        FluenceDataScale => { GRP => "3002", ELEM => "0042", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              PrimaryFluenceModeSequence => { GRP => "3002", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             FluenceMode => { GRP => "3002", ELEM => "0051", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           FluenceModeID => { GRP => "3002", ELEM => "0052", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 DVHType => { GRP => "3004", ELEM => "0001", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               DoseUnits => { GRP => "3004", ELEM => "0002", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                DoseType => { GRP => "3004", ELEM => "0004", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             DoseComment => { GRP => "3004", ELEM => "0006", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      NormalizationPoint => { GRP => "3004", ELEM => "0008", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                       DoseSummationType => { GRP => "3004", ELEM => "000A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   GridFrameOffsetVector => { GRP => "3004", ELEM => "000C", VR => "DS", VM => "2-n", VERSION =>  "DICOM_2009"},
                                                         DoseGridScaling => { GRP => "3004", ELEM => "000E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RTDoseROISequence => { GRP => "3004", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                               DoseValue => { GRP => "3004", ELEM => "0012", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           TissueHeterogeneityCorrection => { GRP => "3004", ELEM => "0014", VR => "CS", VM => "1-3", VERSION =>  "DICOM_2009"},
                                                   DVHNormalizationPoint => { GRP => "3004", ELEM => "0040", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                               DVHNormalizationDoseValue => { GRP => "3004", ELEM => "0042", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             DVHSequence => { GRP => "3004", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DVHDoseScaling => { GRP => "3004", ELEM => "0052", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DVHVolumeUnits => { GRP => "3004", ELEM => "0054", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         DVHNumberOfBins => { GRP => "3004", ELEM => "0056", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 DVHData => { GRP => "3004", ELEM => "0058", VR => "DS", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                DVHReferencedROISequence => { GRP => "3004", ELEM => "0060", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DVHROIContributionType => { GRP => "3004", ELEM => "0062", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DVHMinimumDose => { GRP => "3004", ELEM => "0070", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          DVHMaximumDose => { GRP => "3004", ELEM => "0072", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             DVHMeanDose => { GRP => "3004", ELEM => "0074", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       StructureSetLabel => { GRP => "3006", ELEM => "0002", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                        StructureSetName => { GRP => "3006", ELEM => "0004", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 StructureSetDescription => { GRP => "3006", ELEM => "0006", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                        StructureSetDate => { GRP => "3006", ELEM => "0008", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                        StructureSetTime => { GRP => "3006", ELEM => "0009", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                      ReferencedFrameOfReferenceSequence => { GRP => "3006", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               RTReferencedStudySequence => { GRP => "3006", ELEM => "0012", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              RTReferencedSeriesSequence => { GRP => "3006", ELEM => "0014", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContourImageSequence => { GRP => "3006", ELEM => "0016", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 StructureSetROISequence => { GRP => "3006", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                               ROINumber => { GRP => "3006", ELEM => "0022", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           ReferencedFrameOfReferenceUID => { GRP => "3006", ELEM => "0024", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 ROIName => { GRP => "3006", ELEM => "0026", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ROIDescription => { GRP => "3006", ELEM => "0028", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ROIDisplayColor => { GRP => "3006", ELEM => "002A", VR => "IS", VM => "3", VERSION =>  "DICOM_2009"},
                                                               ROIVolume => { GRP => "3006", ELEM => "002C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RTRelatedROISequence => { GRP => "3006", ELEM => "0030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RTROIRelationship => { GRP => "3006", ELEM => "0033", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ROIGenerationAlgorithm => { GRP => "3006", ELEM => "0036", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                ROIGenerationDescription => { GRP => "3006", ELEM => "0038", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ROIContourSequence => { GRP => "3006", ELEM => "0039", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ContourSequence => { GRP => "3006", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContourGeometricType => { GRP => "3006", ELEM => "0042", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ContourSlabThickness => { GRP => "3006", ELEM => "0044", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ContourOffsetVector => { GRP => "3006", ELEM => "0045", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                   NumberOfContourPoints => { GRP => "3006", ELEM => "0046", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ContourNumber => { GRP => "3006", ELEM => "0048", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        AttachedContours => { GRP => "3006", ELEM => "0049", VR => "IS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                             ContourData => { GRP => "3006", ELEM => "0050", VR => "DS", VM => "3-3n", VERSION =>  "DICOM_2009"},
                                               RTROIObservationsSequence => { GRP => "3006", ELEM => "0080", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ObservationNumber => { GRP => "3006", ELEM => "0082", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ReferencedROINumber => { GRP => "3006", ELEM => "0084", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ROIObservationLabel => { GRP => "3006", ELEM => "0085", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                         RTROIIdentificationCodeSequence => { GRP => "3006", ELEM => "0086", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               ROIObservationDescription => { GRP => "3006", ELEM => "0088", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                        RelatedRTROIObservationsSequence => { GRP => "3006", ELEM => "00A0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RTROIInterpretedType => { GRP => "3006", ELEM => "00A4", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ROIInterpreter => { GRP => "3006", ELEM => "00A6", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                           ROIPhysicalPropertiesSequence => { GRP => "3006", ELEM => "00B0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ROIPhysicalProperty => { GRP => "3006", ELEM => "00B2", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                ROIPhysicalPropertyValue => { GRP => "3006", ELEM => "00B4", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ROIElementalCompositionSequence => { GRP => "3006", ELEM => "00B6", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     ROIElementalCompositionAtomicNumber => { GRP => "3006", ELEM => "00B7", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                               ROIElementalCompositionAtomicMassFraction => { GRP => "3006", ELEM => "00B8", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                    FrameOfReferenceRelationshipSequence => { GRP => "3006", ELEM => "00C0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                              RelatedFrameOfReferenceUID => { GRP => "3006", ELEM => "00C2", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                      FrameOfReferenceTransformationType => { GRP => "3006", ELEM => "00C4", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                    FrameOfReferenceTransformationMatrix => { GRP => "3006", ELEM => "00C6", VR => "DS", VM => "16", VERSION =>  "DICOM_2009"},
                                   FrameOfReferenceTransformationComment => { GRP => "3006", ELEM => "00C8", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           MeasuredDoseReferenceSequence => { GRP => "3008", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 MeasuredDoseDescription => { GRP => "3008", ELEM => "0012", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                        MeasuredDoseType => { GRP => "3008", ELEM => "0014", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       MeasuredDoseValue => { GRP => "3008", ELEM => "0016", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            TreatmentSessionBeamSequence => { GRP => "3008", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         TreatmentSessionIonBeamSequence => { GRP => "3008", ELEM => "0021", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   CurrentFractionNumber => { GRP => "3008", ELEM => "0022", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                               TreatmentControlPointDate => { GRP => "3008", ELEM => "0024", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                               TreatmentControlPointTime => { GRP => "3008", ELEM => "0025", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                              TreatmentTerminationStatus => { GRP => "3008", ELEM => "002A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                TreatmentTerminationCode => { GRP => "3008", ELEM => "002B", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                             TreatmentVerificationStatus => { GRP => "3008", ELEM => "002C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       ReferencedTreatmentRecordSequence => { GRP => "3008", ELEM => "0030", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                SpecifiedPrimaryMeterset => { GRP => "3008", ELEM => "0032", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              SpecifiedSecondaryMeterset => { GRP => "3008", ELEM => "0033", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                DeliveredPrimaryMeterset => { GRP => "3008", ELEM => "0036", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              DeliveredSecondaryMeterset => { GRP => "3008", ELEM => "0037", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SpecifiedTreatmentTime => { GRP => "3008", ELEM => "003A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DeliveredTreatmentTime => { GRP => "3008", ELEM => "003B", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            ControlPointDeliverySequence => { GRP => "3008", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         IonControlPointDeliverySequence => { GRP => "3008", ELEM => "0041", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SpecifiedMeterset => { GRP => "3008", ELEM => "0042", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DeliveredMeterset => { GRP => "3008", ELEM => "0044", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         MetersetRateSet => { GRP => "3008", ELEM => "0045", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MetersetRateDelivered => { GRP => "3008", ELEM => "0046", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              ScanSpotMetersetsDelivered => { GRP => "3008", ELEM => "0047", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                       DoseRateDelivered => { GRP => "3008", ELEM => "0048", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                         TreatmentSummaryCalculatedDoseReferenceSequence => { GRP => "3008", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           CumulativeDoseToDoseReference => { GRP => "3008", ELEM => "0052", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      FirstTreatmentDate => { GRP => "3008", ELEM => "0054", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                 MostRecentTreatmentDate => { GRP => "3008", ELEM => "0056", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                              NumberOfFractionsDelivered => { GRP => "3008", ELEM => "005A", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        OverrideSequence => { GRP => "3008", ELEM => "0060", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ParameterSequencePointer => { GRP => "3008", ELEM => "0061", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                                OverrideParameterPointer => { GRP => "3008", ELEM => "0062", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ParameterItemIndex => { GRP => "3008", ELEM => "0063", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             MeasuredDoseReferenceNumber => { GRP => "3008", ELEM => "0064", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ParameterPointer => { GRP => "3008", ELEM => "0065", VR => "AT", VM => "1", VERSION =>  "DICOM_2009"},
                                                          OverrideReason => { GRP => "3008", ELEM => "0066", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                              CorrectedParameterSequence => { GRP => "3008", ELEM => "0068", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         CorrectionValue => { GRP => "3008", ELEM => "006A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                         CalculatedDoseReferenceSequence => { GRP => "3008", ELEM => "0070", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           CalculatedDoseReferenceNumber => { GRP => "3008", ELEM => "0072", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                      CalculatedDoseReferenceDescription => { GRP => "3008", ELEM => "0074", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                        CalculatedDoseReferenceDoseValue => { GRP => "3008", ELEM => "0076", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           StartMeterset => { GRP => "3008", ELEM => "0078", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             EndMeterset => { GRP => "3008", ELEM => "007A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                 ReferencedMeasuredDoseReferenceSequence => { GRP => "3008", ELEM => "0080", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   ReferencedMeasuredDoseReferenceNumber => { GRP => "3008", ELEM => "0082", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                               ReferencedCalculatedDoseReferenceSequence => { GRP => "3008", ELEM => "0090", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                 ReferencedCalculatedDoseReferenceNumber => { GRP => "3008", ELEM => "0092", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                     BeamLimitingDeviceLeafPairsSequence => { GRP => "3008", ELEM => "00A0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RecordedWedgeSequence => { GRP => "3008", ELEM => "00B0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             RecordedCompensatorSequence => { GRP => "3008", ELEM => "00C0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RecordedBlockSequence => { GRP => "3008", ELEM => "00D0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                           TreatmentSummaryMeasuredDoseReferenceSequence => { GRP => "3008", ELEM => "00E0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RecordedSnoutSequence => { GRP => "3008", ELEM => "00F0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            RecordedRangeShifterSequence => { GRP => "3008", ELEM => "00F2", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  RecordedLateralSpreadingDeviceSequence => { GRP => "3008", ELEM => "00F4", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          RecordedRangeModulatorSequence => { GRP => "3008", ELEM => "00F6", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RecordedSourceSequence => { GRP => "3008", ELEM => "0100", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SourceSerialNumber => { GRP => "3008", ELEM => "0105", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                TreatmentSessionApplicationSetupSequence => { GRP => "3008", ELEM => "0110", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ApplicationSetupCheck => { GRP => "3008", ELEM => "0116", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                   RecordedBrachyAccessoryDeviceSequence => { GRP => "3008", ELEM => "0120", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                   ReferencedBrachyAccessoryDeviceNumber => { GRP => "3008", ELEM => "0122", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RecordedChannelSequence => { GRP => "3008", ELEM => "0130", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                               SpecifiedChannelTotalTime => { GRP => "3008", ELEM => "0132", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                               DeliveredChannelTotalTime => { GRP => "3008", ELEM => "0134", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 SpecifiedNumberOfPulses => { GRP => "3008", ELEM => "0136", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 DeliveredNumberOfPulses => { GRP => "3008", ELEM => "0138", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                        SpecifiedPulseRepetitionInterval => { GRP => "3008", ELEM => "013A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        DeliveredPulseRepetitionInterval => { GRP => "3008", ELEM => "013C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        RecordedSourceApplicatorSequence => { GRP => "3008", ELEM => "0140", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        ReferencedSourceApplicatorNumber => { GRP => "3008", ELEM => "0142", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           RecordedChannelShieldSequence => { GRP => "3008", ELEM => "0150", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ReferencedChannelShieldNumber => { GRP => "3008", ELEM => "0152", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                     BrachyControlPointDeliveredSequence => { GRP => "3008", ELEM => "0160", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SafePositionExitDate => { GRP => "3008", ELEM => "0162", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SafePositionExitTime => { GRP => "3008", ELEM => "0164", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SafePositionReturnDate => { GRP => "3008", ELEM => "0166", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SafePositionReturnTime => { GRP => "3008", ELEM => "0168", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CurrentTreatmentStatus => { GRP => "3008", ELEM => "0200", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TreatmentStatusComment => { GRP => "3008", ELEM => "0202", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                            FractionGroupSummarySequence => { GRP => "3008", ELEM => "0220", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                ReferencedFractionNumber => { GRP => "3008", ELEM => "0223", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       FractionGroupType => { GRP => "3008", ELEM => "0224", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     BeamStopperPosition => { GRP => "3008", ELEM => "0230", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           FractionStatusSummarySequence => { GRP => "3008", ELEM => "0240", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TreatmentDate => { GRP => "3008", ELEM => "0250", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                           TreatmentTime => { GRP => "3008", ELEM => "0251", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                             RTPlanLabel => { GRP => "300A", ELEM => "0002", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                              RTPlanName => { GRP => "300A", ELEM => "0003", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                       RTPlanDescription => { GRP => "300A", ELEM => "0004", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                              RTPlanDate => { GRP => "300A", ELEM => "0006", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                              RTPlanTime => { GRP => "300A", ELEM => "0007", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TreatmentProtocols => { GRP => "300A", ELEM => "0009", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                              PlanIntent => { GRP => "300A", ELEM => "000A", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          TreatmentSites => { GRP => "300A", ELEM => "000B", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                          RTPlanGeometry => { GRP => "300A", ELEM => "000C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PrescriptionDescription => { GRP => "300A", ELEM => "000E", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                   DoseReferenceSequence => { GRP => "300A", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DoseReferenceNumber => { GRP => "300A", ELEM => "0012", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        DoseReferenceUID => { GRP => "300A", ELEM => "0013", VR => "UI", VM => "1", VERSION =>  "DICOM_2009"},
                                              DoseReferenceStructureType => { GRP => "300A", ELEM => "0014", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NominalBeamEnergyUnit => { GRP => "300A", ELEM => "0015", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                DoseReferenceDescription => { GRP => "300A", ELEM => "0016", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           DoseReferencePointCoordinates => { GRP => "300A", ELEM => "0018", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                        NominalPriorDose => { GRP => "300A", ELEM => "001A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       DoseReferenceType => { GRP => "300A", ELEM => "0020", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ConstraintWeight => { GRP => "300A", ELEM => "0021", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DeliveryWarningDose => { GRP => "300A", ELEM => "0022", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     DeliveryMaximumDose => { GRP => "300A", ELEM => "0023", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TargetMinimumDose => { GRP => "300A", ELEM => "0025", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TargetPrescriptionDose => { GRP => "300A", ELEM => "0026", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TargetMaximumDose => { GRP => "300A", ELEM => "0027", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           TargetUnderdoseVolumeFraction => { GRP => "300A", ELEM => "0028", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                               OrganAtRiskFullVolumeDose => { GRP => "300A", ELEM => "002A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    OrganAtRiskLimitDose => { GRP => "300A", ELEM => "002B", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  OrganAtRiskMaximumDose => { GRP => "300A", ELEM => "002C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                       OrganAtRiskOverdoseVolumeFraction => { GRP => "300A", ELEM => "002D", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ToleranceTableSequence => { GRP => "300A", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ToleranceTableNumber => { GRP => "300A", ELEM => "0042", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ToleranceTableLabel => { GRP => "300A", ELEM => "0043", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                    GantryAngleTolerance => { GRP => "300A", ELEM => "0044", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        BeamLimitingDeviceAngleTolerance => { GRP => "300A", ELEM => "0046", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                     BeamLimitingDeviceToleranceSequence => { GRP => "300A", ELEM => "0048", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                     BeamLimitingDevicePositionTolerance => { GRP => "300A", ELEM => "004A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SnoutPositionTolerance => { GRP => "300A", ELEM => "004B", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            PatientSupportAngleTolerance => { GRP => "300A", ELEM => "004C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         TableTopEccentricAngleTolerance => { GRP => "300A", ELEM => "004E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                             TableTopPitchAngleTolerance => { GRP => "300A", ELEM => "004F", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                              TableTopRollAngleTolerance => { GRP => "300A", ELEM => "0050", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                       TableTopVerticalPositionTolerance => { GRP => "300A", ELEM => "0051", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                   TableTopLongitudinalPositionTolerance => { GRP => "300A", ELEM => "0052", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        TableTopLateralPositionTolerance => { GRP => "300A", ELEM => "0053", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RTPlanRelationship => { GRP => "300A", ELEM => "0055", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   FractionGroupSequence => { GRP => "300A", ELEM => "0070", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     FractionGroupNumber => { GRP => "300A", ELEM => "0071", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                FractionGroupDescription => { GRP => "300A", ELEM => "0072", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                NumberOfFractionsPlanned => { GRP => "300A", ELEM => "0078", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                     NumberOfFractionPatternDigitsPerDay => { GRP => "300A", ELEM => "0079", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                               RepeatFractionCycleLength => { GRP => "300A", ELEM => "007A", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         FractionPattern => { GRP => "300A", ELEM => "007B", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                           NumberOfBeams => { GRP => "300A", ELEM => "0080", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                              BeamDoseSpecificationPoint => { GRP => "300A", ELEM => "0082", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                                BeamDose => { GRP => "300A", ELEM => "0084", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            BeamMeterset => { GRP => "300A", ELEM => "0086", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      BeamDosePointDepth => { GRP => "300A", ELEM => "0088", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            BeamDosePointEquivalentDepth => { GRP => "300A", ELEM => "0089", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BeamDosePointSSD => { GRP => "300A", ELEM => "008A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                         NumberOfBrachyApplicationSetups => { GRP => "300A", ELEM => "00A0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                            BrachyApplicationSetupDoseSpecificationPoint => { GRP => "300A", ELEM => "00A2", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                              BrachyApplicationSetupDose => { GRP => "300A", ELEM => "00A4", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            BeamSequence => { GRP => "300A", ELEM => "00B0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TreatmentMachineName => { GRP => "300A", ELEM => "00B2", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PrimaryDosimeterUnit => { GRP => "300A", ELEM => "00B3", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SourceAxisDistance => { GRP => "300A", ELEM => "00B4", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              BeamLimitingDeviceSequence => { GRP => "300A", ELEM => "00B6", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                RTBeamLimitingDeviceType => { GRP => "300A", ELEM => "00B8", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                      SourceToBeamLimitingDeviceDistance => { GRP => "300A", ELEM => "00BA", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                   IsocenterToBeamLimitingDeviceDistance => { GRP => "300A", ELEM => "00BB", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    NumberOfLeafJawPairs => { GRP => "300A", ELEM => "00BC", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  LeafPositionBoundaries => { GRP => "300A", ELEM => "00BE", VR => "DS", VM => "3-n", VERSION =>  "DICOM_2009"},
                                                              BeamNumber => { GRP => "300A", ELEM => "00C0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                BeamName => { GRP => "300A", ELEM => "00C2", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         BeamDescription => { GRP => "300A", ELEM => "00C3", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                                BeamType => { GRP => "300A", ELEM => "00C4", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           RadiationType => { GRP => "300A", ELEM => "00C6", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   HighDoseTechniqueType => { GRP => "300A", ELEM => "00C7", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReferenceImageNumber => { GRP => "300A", ELEM => "00C8", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                        PlannedVerificationImageSequence => { GRP => "300A", ELEM => "00CA", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                              ImagingDeviceSpecificAcquisitionParameters => { GRP => "300A", ELEM => "00CC", VR => "LO", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                   TreatmentDeliveryType => { GRP => "300A", ELEM => "00CE", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          NumberOfWedges => { GRP => "300A", ELEM => "00D0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           WedgeSequence => { GRP => "300A", ELEM => "00D1", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             WedgeNumber => { GRP => "300A", ELEM => "00D2", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               WedgeType => { GRP => "300A", ELEM => "00D3", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 WedgeID => { GRP => "300A", ELEM => "00D4", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                              WedgeAngle => { GRP => "300A", ELEM => "00D5", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             WedgeFactor => { GRP => "300A", ELEM => "00D6", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                  TotalWedgeTrayWaterEquivalentThickness => { GRP => "300A", ELEM => "00D7", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        WedgeOrientation => { GRP => "300A", ELEM => "00D8", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            IsocenterToWedgeTrayDistance => { GRP => "300A", ELEM => "00D9", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                               SourceToWedgeTrayDistance => { GRP => "300A", ELEM => "00DA", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   WedgeThinEdgePosition => { GRP => "300A", ELEM => "00DB", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 BolusID => { GRP => "300A", ELEM => "00DC", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                        BolusDescription => { GRP => "300A", ELEM => "00DD", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    NumberOfCompensators => { GRP => "300A", ELEM => "00E0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              MaterialID => { GRP => "300A", ELEM => "00E1", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                              TotalCompensatorTrayFactor => { GRP => "300A", ELEM => "00E2", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     CompensatorSequence => { GRP => "300A", ELEM => "00E3", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       CompensatorNumber => { GRP => "300A", ELEM => "00E4", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           CompensatorID => { GRP => "300A", ELEM => "00E5", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                         SourceToCompensatorTrayDistance => { GRP => "300A", ELEM => "00E6", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         CompensatorRows => { GRP => "300A", ELEM => "00E7", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      CompensatorColumns => { GRP => "300A", ELEM => "00E8", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CompensatorPixelSpacing => { GRP => "300A", ELEM => "00E9", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                                     CompensatorPosition => { GRP => "300A", ELEM => "00EA", VR => "DS", VM => "2", VERSION =>  "DICOM_2009"},
                                             CompensatorTransmissionData => { GRP => "300A", ELEM => "00EB", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                CompensatorThicknessData => { GRP => "300A", ELEM => "00EC", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                            NumberOfBoli => { GRP => "300A", ELEM => "00ED", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         CompensatorType => { GRP => "300A", ELEM => "00EE", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          NumberOfBlocks => { GRP => "300A", ELEM => "00F0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    TotalBlockTrayFactor => { GRP => "300A", ELEM => "00F2", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                  TotalBlockTrayWaterEquivalentThickness => { GRP => "300A", ELEM => "00F3", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                           BlockSequence => { GRP => "300A", ELEM => "00F4", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                             BlockTrayID => { GRP => "300A", ELEM => "00F5", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                               SourceToBlockTrayDistance => { GRP => "300A", ELEM => "00F6", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            IsocenterToBlockTrayDistance => { GRP => "300A", ELEM => "00F7", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                               BlockType => { GRP => "300A", ELEM => "00F8", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           AccessoryCode => { GRP => "300A", ELEM => "00F9", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                         BlockDivergence => { GRP => "300A", ELEM => "00FA", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   BlockMountingPosition => { GRP => "300A", ELEM => "00FB", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             BlockNumber => { GRP => "300A", ELEM => "00FC", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               BlockName => { GRP => "300A", ELEM => "00FE", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                          BlockThickness => { GRP => "300A", ELEM => "0100", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       BlockTransmission => { GRP => "300A", ELEM => "0102", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     BlockNumberOfPoints => { GRP => "300A", ELEM => "0104", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                               BlockData => { GRP => "300A", ELEM => "0106", VR => "DS", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                      ApplicatorSequence => { GRP => "300A", ELEM => "0107", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ApplicatorID => { GRP => "300A", ELEM => "0108", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ApplicatorType => { GRP => "300A", ELEM => "0109", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ApplicatorDescription => { GRP => "300A", ELEM => "010A", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                      CumulativeDoseReferenceCoefficient => { GRP => "300A", ELEM => "010C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           FinalCumulativeMetersetWeight => { GRP => "300A", ELEM => "010E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NumberOfControlPoints => { GRP => "300A", ELEM => "0110", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ControlPointSequence => { GRP => "300A", ELEM => "0111", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ControlPointIndex => { GRP => "300A", ELEM => "0112", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       NominalBeamEnergy => { GRP => "300A", ELEM => "0114", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                             DoseRateSet => { GRP => "300A", ELEM => "0115", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   WedgePositionSequence => { GRP => "300A", ELEM => "0116", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           WedgePosition => { GRP => "300A", ELEM => "0118", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                      BeamLimitingDevicePositionSequence => { GRP => "300A", ELEM => "011A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        LeafJawPositions => { GRP => "300A", ELEM => "011C", VR => "DS", VM => "2-2n", VERSION =>  "DICOM_2009"},
                                                             GantryAngle => { GRP => "300A", ELEM => "011E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 GantryRotationDirection => { GRP => "300A", ELEM => "011F", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 BeamLimitingDeviceAngle => { GRP => "300A", ELEM => "0120", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                     BeamLimitingDeviceRotationDirection => { GRP => "300A", ELEM => "0121", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     PatientSupportAngle => { GRP => "300A", ELEM => "0122", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                         PatientSupportRotationDirection => { GRP => "300A", ELEM => "0123", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                           TableTopEccentricAxisDistance => { GRP => "300A", ELEM => "0124", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TableTopEccentricAngle => { GRP => "300A", ELEM => "0125", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                      TableTopEccentricRotationDirection => { GRP => "300A", ELEM => "0126", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                TableTopVerticalPosition => { GRP => "300A", ELEM => "0128", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            TableTopLongitudinalPosition => { GRP => "300A", ELEM => "0129", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 TableTopLateralPosition => { GRP => "300A", ELEM => "012A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       IsocenterPosition => { GRP => "300A", ELEM => "012C", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                       SurfaceEntryPoint => { GRP => "300A", ELEM => "012E", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                 SourceToSurfaceDistance => { GRP => "300A", ELEM => "0130", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                CumulativeMetersetWeight => { GRP => "300A", ELEM => "0134", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TableTopPitchAngle => { GRP => "300A", ELEM => "0140", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                          TableTopPitchRotationDirection => { GRP => "300A", ELEM => "0142", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       TableTopRollAngle => { GRP => "300A", ELEM => "0144", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                           TableTopRollRotationDirection => { GRP => "300A", ELEM => "0146", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       HeadFixationAngle => { GRP => "300A", ELEM => "0148", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                        GantryPitchAngle => { GRP => "300A", ELEM => "014A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            GantryPitchRotationDirection => { GRP => "300A", ELEM => "014C", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               GantryPitchAngleTolerance => { GRP => "300A", ELEM => "014E", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                    PatientSetupSequence => { GRP => "300A", ELEM => "0180", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PatientSetupNumber => { GRP => "300A", ELEM => "0182", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       PatientSetupLabel => { GRP => "300A", ELEM => "0183", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                               PatientAdditionalPosition => { GRP => "300A", ELEM => "0184", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FixationDeviceSequence => { GRP => "300A", ELEM => "0190", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      FixationDeviceType => { GRP => "300A", ELEM => "0192", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     FixationDeviceLabel => { GRP => "300A", ELEM => "0194", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                               FixationDeviceDescription => { GRP => "300A", ELEM => "0196", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                  FixationDevicePosition => { GRP => "300A", ELEM => "0198", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                FixationDevicePitchAngle => { GRP => "300A", ELEM => "0199", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 FixationDeviceRollAngle => { GRP => "300A", ELEM => "019A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ShieldingDeviceSequence => { GRP => "300A", ELEM => "01A0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ShieldingDeviceType => { GRP => "300A", ELEM => "01A2", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ShieldingDeviceLabel => { GRP => "300A", ELEM => "01A4", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                              ShieldingDeviceDescription => { GRP => "300A", ELEM => "01A6", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ShieldingDevicePosition => { GRP => "300A", ELEM => "01A8", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                          SetupTechnique => { GRP => "300A", ELEM => "01B0", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               SetupTechniqueDescription => { GRP => "300A", ELEM => "01B2", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SetupDeviceSequence => { GRP => "300A", ELEM => "01B4", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         SetupDeviceType => { GRP => "300A", ELEM => "01B6", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        SetupDeviceLabel => { GRP => "300A", ELEM => "01B8", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SetupDeviceDescription => { GRP => "300A", ELEM => "01BA", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SetupDeviceParameter => { GRP => "300A", ELEM => "01BC", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                               SetupReferenceDescription => { GRP => "300A", ELEM => "01D0", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                       TableTopVerticalSetupDisplacement => { GRP => "300A", ELEM => "01D2", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                   TableTopLongitudinalSetupDisplacement => { GRP => "300A", ELEM => "01D4", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        TableTopLateralSetupDisplacement => { GRP => "300A", ELEM => "01D6", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                BrachyTreatmentTechnique => { GRP => "300A", ELEM => "0200", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     BrachyTreatmentType => { GRP => "300A", ELEM => "0202", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                TreatmentMachineSequence => { GRP => "300A", ELEM => "0206", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                          SourceSequence => { GRP => "300A", ELEM => "0210", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                            SourceNumber => { GRP => "300A", ELEM => "0212", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              SourceType => { GRP => "300A", ELEM => "0214", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SourceManufacturer => { GRP => "300A", ELEM => "0216", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ActiveSourceDiameter => { GRP => "300A", ELEM => "0218", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      ActiveSourceLength => { GRP => "300A", ELEM => "021A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                     SourceEncapsulationNominalThickness => { GRP => "300A", ELEM => "0222", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                  SourceEncapsulationNominalTransmission => { GRP => "300A", ELEM => "0224", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SourceIsotopeName => { GRP => "300A", ELEM => "0226", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                   SourceIsotopeHalfLife => { GRP => "300A", ELEM => "0228", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     SourceStrengthUnits => { GRP => "300A", ELEM => "0229", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReferenceAirKermaRate => { GRP => "300A", ELEM => "022A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          SourceStrength => { GRP => "300A", ELEM => "022B", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                             SourceStrengthReferenceDate => { GRP => "300A", ELEM => "022C", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                             SourceStrengthReferenceTime => { GRP => "300A", ELEM => "022E", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                ApplicationSetupSequence => { GRP => "300A", ELEM => "0230", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ApplicationSetupType => { GRP => "300A", ELEM => "0232", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ApplicationSetupNumber => { GRP => "300A", ELEM => "0234", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ApplicationSetupName => { GRP => "300A", ELEM => "0236", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                            ApplicationSetupManufacturer => { GRP => "300A", ELEM => "0238", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                          TemplateNumber => { GRP => "300A", ELEM => "0240", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                            TemplateType => { GRP => "300A", ELEM => "0242", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                            TemplateName => { GRP => "300A", ELEM => "0244", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  TotalReferenceAirKerma => { GRP => "300A", ELEM => "0250", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                           BrachyAccessoryDeviceSequence => { GRP => "300A", ELEM => "0260", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                             BrachyAccessoryDeviceNumber => { GRP => "300A", ELEM => "0262", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 BrachyAccessoryDeviceID => { GRP => "300A", ELEM => "0263", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                               BrachyAccessoryDeviceType => { GRP => "300A", ELEM => "0264", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               BrachyAccessoryDeviceName => { GRP => "300A", ELEM => "0266", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                   BrachyAccessoryDeviceNominalThickness => { GRP => "300A", ELEM => "026A", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                BrachyAccessoryDeviceNominalTransmission => { GRP => "300A", ELEM => "026C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ChannelSequence => { GRP => "300A", ELEM => "0280", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ChannelNumber => { GRP => "300A", ELEM => "0282", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                           ChannelLength => { GRP => "300A", ELEM => "0284", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        ChannelTotalTime => { GRP => "300A", ELEM => "0286", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SourceMovementType => { GRP => "300A", ELEM => "0288", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          NumberOfPulses => { GRP => "300A", ELEM => "028A", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 PulseRepetitionInterval => { GRP => "300A", ELEM => "028C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SourceApplicatorNumber => { GRP => "300A", ELEM => "0290", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      SourceApplicatorID => { GRP => "300A", ELEM => "0291", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SourceApplicatorType => { GRP => "300A", ELEM => "0292", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    SourceApplicatorName => { GRP => "300A", ELEM => "0294", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                  SourceApplicatorLength => { GRP => "300A", ELEM => "0296", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                            SourceApplicatorManufacturer => { GRP => "300A", ELEM => "0298", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                    SourceApplicatorWallNominalThickness => { GRP => "300A", ELEM => "029C", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                 SourceApplicatorWallNominalTransmission => { GRP => "300A", ELEM => "029E", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                SourceApplicatorStepSize => { GRP => "300A", ELEM => "02A0", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TransferTubeNumber => { GRP => "300A", ELEM => "02A2", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                      TransferTubeLength => { GRP => "300A", ELEM => "02A4", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ChannelShieldSequence => { GRP => "300A", ELEM => "02B0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ChannelShieldNumber => { GRP => "300A", ELEM => "02B2", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                         ChannelShieldID => { GRP => "300A", ELEM => "02B3", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                       ChannelShieldName => { GRP => "300A", ELEM => "02B4", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                           ChannelShieldNominalThickness => { GRP => "300A", ELEM => "02B8", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                        ChannelShieldNominalTransmission => { GRP => "300A", ELEM => "02BA", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                               FinalCumulativeTimeWeight => { GRP => "300A", ELEM => "02C8", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                              BrachyControlPointSequence => { GRP => "300A", ELEM => "02D0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            ControlPointRelativePosition => { GRP => "300A", ELEM => "02D2", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ControlPoint3DPosition => { GRP => "300A", ELEM => "02D4", VR => "DS", VM => "3", VERSION =>  "DICOM_2009"},
                                                    CumulativeTimeWeight => { GRP => "300A", ELEM => "02D6", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   CompensatorDivergence => { GRP => "300A", ELEM => "02E0", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             CompensatorMountingPosition => { GRP => "300A", ELEM => "02E1", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                             SourceToCompensatorDistance => { GRP => "300A", ELEM => "02E2", VR => "DS", VM => "1-n", VERSION =>  "DICOM_2009"},
                            TotalCompensatorTrayWaterEquivalentThickness => { GRP => "300A", ELEM => "02E3", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                      IsocenterToCompensatorTrayDistance => { GRP => "300A", ELEM => "02E4", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 CompensatorColumnOffset => { GRP => "300A", ELEM => "02E5", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                         IsocenterToCompensatorDistances => { GRP => "300A", ELEM => "02E6", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                   CompensatorRelativeStoppingPowerRatio => { GRP => "300A", ELEM => "02E7", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                          CompensatorMillingToolDiameter => { GRP => "300A", ELEM => "02E8", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                             IonRangeCompensatorSequence => { GRP => "300A", ELEM => "02EA", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  CompensatorDescription => { GRP => "300A", ELEM => "02EB", VR => "LT", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RadiationMassNumber => { GRP => "300A", ELEM => "0302", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   RadiationAtomicNumber => { GRP => "300A", ELEM => "0304", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RadiationChargeState => { GRP => "300A", ELEM => "0306", VR => "SS", VM => "1", VERSION =>  "DICOM_2009"},
                                                                ScanMode => { GRP => "300A", ELEM => "0308", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                              VirtualSourceAxisDistances => { GRP => "300A", ELEM => "030A", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                                           SnoutSequence => { GRP => "300A", ELEM => "030C", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                           SnoutPosition => { GRP => "300A", ELEM => "030D", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                                 SnoutID => { GRP => "300A", ELEM => "030F", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                   NumberOfRangeShifters => { GRP => "300A", ELEM => "0312", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RangeShifterSequence => { GRP => "300A", ELEM => "0314", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RangeShifterNumber => { GRP => "300A", ELEM => "0316", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          RangeShifterID => { GRP => "300A", ELEM => "0318", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                        RangeShifterType => { GRP => "300A", ELEM => "0320", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 RangeShifterDescription => { GRP => "300A", ELEM => "0322", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         NumberOfLateralSpreadingDevices => { GRP => "300A", ELEM => "0330", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                          LateralSpreadingDeviceSequence => { GRP => "300A", ELEM => "0332", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            LateralSpreadingDeviceNumber => { GRP => "300A", ELEM => "0334", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                LateralSpreadingDeviceID => { GRP => "300A", ELEM => "0336", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                              LateralSpreadingDeviceType => { GRP => "300A", ELEM => "0338", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                       LateralSpreadingDeviceDescription => { GRP => "300A", ELEM => "033A", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                          LateralSpreadingDeviceWaterEquivalentThickness => { GRP => "300A", ELEM => "033C", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 NumberOfRangeModulators => { GRP => "300A", ELEM => "0340", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  RangeModulatorSequence => { GRP => "300A", ELEM => "0342", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    RangeModulatorNumber => { GRP => "300A", ELEM => "0344", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        RangeModulatorID => { GRP => "300A", ELEM => "0346", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                      RangeModulatorType => { GRP => "300A", ELEM => "0348", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                               RangeModulatorDescription => { GRP => "300A", ELEM => "034A", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                                 BeamCurrentModulationID => { GRP => "300A", ELEM => "034C", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                                      PatientSupportType => { GRP => "300A", ELEM => "0350", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                        PatientSupportID => { GRP => "300A", ELEM => "0352", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                             PatientSupportAccessoryCode => { GRP => "300A", ELEM => "0354", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                             FixationLightAzimuthalAngle => { GRP => "300A", ELEM => "0356", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                 FixationLightPolarAngle => { GRP => "300A", ELEM => "0358", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                            MetersetRate => { GRP => "300A", ELEM => "035A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                            RangeShifterSettingsSequence => { GRP => "300A", ELEM => "0360", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     RangeShifterSetting => { GRP => "300A", ELEM => "0362", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                                         IsocenterToRangeShifterDistance => { GRP => "300A", ELEM => "0364", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                    RangeShifterWaterEquivalentThickness => { GRP => "300A", ELEM => "0366", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                  LateralSpreadingDeviceSettingsSequence => { GRP => "300A", ELEM => "0370", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           LateralSpreadingDeviceSetting => { GRP => "300A", ELEM => "0372", VR => "LO", VM => "1", VERSION =>  "DICOM_2009"},
                               IsocenterToLateralSpreadingDeviceDistance => { GRP => "300A", ELEM => "0374", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                          RangeModulatorSettingsSequence => { GRP => "300A", ELEM => "0380", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          RangeModulatorGatingStartValue => { GRP => "300A", ELEM => "0382", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                           RangeModulatorGatingStopValue => { GRP => "300A", ELEM => "0384", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                       RangeModulatorGatingStartWaterEquivalentThickness => { GRP => "300A", ELEM => "0386", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                        RangeModulatorGatingStopWaterEquivalentThickness => { GRP => "300A", ELEM => "0388", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                       IsocenterToRangeModulatorDistance => { GRP => "300A", ELEM => "038A", VR => "FL", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ScanSpotTuneID => { GRP => "300A", ELEM => "0390", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                               NumberOfScanSpotPositions => { GRP => "300A", ELEM => "0392", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ScanSpotPositionMap => { GRP => "300A", ELEM => "0394", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                 ScanSpotMetersetWeights => { GRP => "300A", ELEM => "0396", VR => "FL", VM => "1-n", VERSION =>  "DICOM_2009"},
                                                        ScanningSpotSize => { GRP => "300A", ELEM => "0398", VR => "FL", VM => "2", VERSION =>  "DICOM_2009"},
                                                       NumberOfPaintings => { GRP => "300A", ELEM => "039A", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                               IonToleranceTableSequence => { GRP => "300A", ELEM => "03A0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                         IonBeamSequence => { GRP => "300A", ELEM => "03A2", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           IonBeamLimitingDeviceSequence => { GRP => "300A", ELEM => "03A4", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        IonBlockSequence => { GRP => "300A", ELEM => "03A6", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 IonControlPointSequence => { GRP => "300A", ELEM => "03A8", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        IonWedgeSequence => { GRP => "300A", ELEM => "03AA", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                IonWedgePositionSequence => { GRP => "300A", ELEM => "03AC", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencedSetupImageSequence => { GRP => "300A", ELEM => "0401", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                       SetupImageComment => { GRP => "300A", ELEM => "0402", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                           MotionSynchronizationSequence => { GRP => "300A", ELEM => "0410", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ControlPointOrientation => { GRP => "300A", ELEM => "0412", VR => "FL", VM => "3", VERSION =>  "DICOM_2009"},
                                                GeneralAccessorySequence => { GRP => "300A", ELEM => "0420", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                      GeneralAccessoryID => { GRP => "300A", ELEM => "0421", VR => "SH", VM => "1", VERSION =>  "DICOM_2009"},
                                             GeneralAccessoryDescription => { GRP => "300A", ELEM => "0422", VR => "ST", VM => "1", VERSION =>  "DICOM_2009"},
                                                    GeneralAccessoryType => { GRP => "300A", ELEM => "0423", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  GeneralAccessoryNumber => { GRP => "300A", ELEM => "0424", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                ReferencedRTPlanSequence => { GRP => "300C", ELEM => "0002", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ReferencedBeamSequence => { GRP => "300C", ELEM => "0004", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ReferencedBeamNumber => { GRP => "300C", ELEM => "0006", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedReferenceImageNumber => { GRP => "300C", ELEM => "0007", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                           StartCumulativeMetersetWeight => { GRP => "300C", ELEM => "0008", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                             EndCumulativeMetersetWeight => { GRP => "300C", ELEM => "0009", VR => "DS", VM => "1", VERSION =>  "DICOM_2009"},
                                ReferencedBrachyApplicationSetupSequence => { GRP => "300C", ELEM => "000A", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                  ReferencedBrachyApplicationSetupNumber => { GRP => "300C", ELEM => "000C", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ReferencedSourceNumber => { GRP => "300C", ELEM => "000E", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ReferencedFractionGroupSequence => { GRP => "300C", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ReferencedFractionGroupNumber => { GRP => "300C", ELEM => "0022", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                     ReferencedVerificationImageSequence => { GRP => "300C", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        ReferencedReferenceImageSequence => { GRP => "300C", ELEM => "0042", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                         ReferencedDoseReferenceSequence => { GRP => "300C", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                           ReferencedDoseReferenceNumber => { GRP => "300C", ELEM => "0051", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                   BrachyReferencedDoseReferenceSequence => { GRP => "300C", ELEM => "0055", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedStructureSetSequence => { GRP => "300C", ELEM => "0060", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencedPatientSetupNumber => { GRP => "300C", ELEM => "006A", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                  ReferencedDoseSequence => { GRP => "300C", ELEM => "0080", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedToleranceTableNumber => { GRP => "300C", ELEM => "00A0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                 ReferencedBolusSequence => { GRP => "300C", ELEM => "00B0", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReferencedWedgeNumber => { GRP => "300C", ELEM => "00C0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             ReferencedCompensatorNumber => { GRP => "300C", ELEM => "00D0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                   ReferencedBlockNumber => { GRP => "300C", ELEM => "00E0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                             ReferencedControlPointIndex => { GRP => "300C", ELEM => "00F0", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedControlPointSequence => { GRP => "300C", ELEM => "00F2", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        ReferencedStartControlPointIndex => { GRP => "300C", ELEM => "00F4", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                         ReferencedStopControlPointIndex => { GRP => "300C", ELEM => "00F6", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                            ReferencedRangeShifterNumber => { GRP => "300C", ELEM => "0100", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                  ReferencedLateralSpreadingDeviceNumber => { GRP => "300C", ELEM => "0102", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                          ReferencedRangeModulatorNumber => { GRP => "300C", ELEM => "0104", VR => "IS", VM => "1", VERSION =>  "DICOM_2009"},
                                                          ApprovalStatus => { GRP => "300E", ELEM => "0002", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ReviewDate => { GRP => "300E", ELEM => "0004", VR => "DA", VM => "1", VERSION =>  "DICOM_2009"},
                                                              ReviewTime => { GRP => "300E", ELEM => "0005", VR => "TM", VM => "1", VERSION =>  "DICOM_2009"},
                                                            ReviewerName => { GRP => "300E", ELEM => "0008", VR => "PN", VM => "1", VERSION =>  "DICOM_2009"},
                                                   MACParametersSequence => { GRP => "4FFE", ELEM => "0001", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                          SharedFunctionalGroupsSequence => { GRP => "5200", ELEM => "9229", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                        PerFrameFunctionalGroupsSequence => { GRP => "5200", ELEM => "9230", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                        WaveformSequence => { GRP => "5400", ELEM => "0100", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ChannelMinimumValue => { GRP => "5400", ELEM => "0110", VR => "ox", VM => "1", VERSION =>  "DICOM_2009"},
                                                     ChannelMaximumValue => { GRP => "5400", ELEM => "0112", VR => "ox", VM => "1", VERSION =>  "DICOM_2009"},
                                                   WaveformBitsAllocated => { GRP => "5400", ELEM => "1004", VR => "US", VM => "1", VERSION =>  "DICOM_2009"},
                                            WaveformSampleInterpretation => { GRP => "5400", ELEM => "1006", VR => "CS", VM => "1", VERSION =>  "DICOM_2009"},
                                                    WaveformPaddingValue => { GRP => "5400", ELEM => "100A", VR => "ox", VM => "1", VERSION =>  "DICOM_2009"},
                                                            WaveformData => { GRP => "5400", ELEM => "1010", VR => "ox", VM => "1", VERSION =>  "DICOM_2009"},
                                          FirstOrderPhaseCorrectionAngle => { GRP => "5600", ELEM => "0010", VR => "OF", VM => "1", VERSION =>  "DICOM_2009"},
                                                        SpectroscopyData => { GRP => "5600", ELEM => "0020", VR => "OF", VM => "1", VERSION =>  "DICOM_2009"},
                                                               PixelData => { GRP => "7FE0", ELEM => "0010", VR => "ox", VM => "1", VERSION =>  "DICOM_2009"},
                                               DigitalSignaturesSequence => { GRP => "FFFA", ELEM => "FFFA", VR => "SQ", VM => "1", VERSION =>  "DICOM_2009"},
                                                  DataSetTrailingPadding => { GRP => "FFFC", ELEM => "FFFC", VR => "OB", VM => "1", VERSION =>  "DICOM_2009"},
                                                                    Item => { GRP => "FFFE", ELEM => "E000", VR => "na", VM => "1", VERSION =>  "DICOM_2009"},
                                                    ItemDelimitationItem => { GRP => "FFFE", ELEM => "E00D", VR => "na", VM => "1", VERSION =>  "DICOM_2009"},
                                                SequenceDelimitationItem => { GRP => "FFFE", ELEM => "E0DD", VR => "na", VM => "1", VERSION =>  "DICOM_2009"},
                                                       GraphicGroupLabel => { GRP => "0070", ELEM => "0207", VR => "LO", VM => "1", VERSION =>  "Supplement_120"},
                                                 GraphicGroupDescription => { GRP => "0070", ELEM => "0208", VR => "ST", VM => "1", VERSION =>  "Supplement_120"},
                                                 CompoundGraphicSequence => { GRP => "0070", ELEM => "0209", VR => "SQ", VM => "1", VERSION =>  "Supplement_120"},
                                               CompoundGraphicInstanceID => { GRP => "0070", ELEM => "0226", VR => "UL", VM => "1", VERSION =>  "Supplement_120"},
                                                                FontName => { GRP => "0070", ELEM => "0227", VR => "LO", VM => "1", VERSION =>  "Supplement_120"},
                                                            FontNameType => { GRP => "0070", ELEM => "0228", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                             CSSFontName => { GRP => "0070", ELEM => "0229", VR => "LO", VM => "1", VERSION =>  "Supplement_120"},
                                                           RotationAngle => { GRP => "0070", ELEM => "0230", VR => "FD", VM => "1", VERSION =>  "Supplement_120"},
                                                       TextStyleSequence => { GRP => "0070", ELEM => "0231", VR => "SQ", VM => "1", VERSION =>  "Supplement_120"},
                                                       LineStyleSequence => { GRP => "0070", ELEM => "0232", VR => "SQ", VM => "1", VERSION =>  "Supplement_120"},
                                                       FillStyleSequence => { GRP => "0070", ELEM => "0233", VR => "SQ", VM => "1", VERSION =>  "Supplement_120"},
                                                    GraphicGroupSequence => { GRP => "0070", ELEM => "0234", VR => "SQ", VM => "1", VERSION =>  "Supplement_120"},
                                                    TextColorCIELabValue => { GRP => "0070", ELEM => "0241", VR => "US", VM => "3", VERSION =>  "Supplement_120"},
                                                     HorizontalAlignment => { GRP => "0070", ELEM => "0242", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                       VerticalAlignment => { GRP => "0070", ELEM => "0243", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                             ShadowStyle => { GRP => "0070", ELEM => "0244", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                           ShadowOffsetX => { GRP => "0070", ELEM => "0245", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                           ShadowOffsetY => { GRP => "0070", ELEM => "0246", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                  ShadowColorCIELabValue => { GRP => "0070", ELEM => "0247", VR => "US", VM => "3", VERSION =>  "Supplement_120"},
                                                              Underlined => { GRP => "0070", ELEM => "0248", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                                    Bold => { GRP => "0070", ELEM => "0249", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                                  Italic => { GRP => "0070", ELEM => "0250", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                               PatternOnColorCIELabValue => { GRP => "0070", ELEM => "0251", VR => "US", VM => "3", VERSION =>  "Supplement_120"},
                                              PatternOffColorCIELabValue => { GRP => "0070", ELEM => "0252", VR => "US", VM => "3", VERSION =>  "Supplement_120"},
                                                           LineThickness => { GRP => "0070", ELEM => "0253", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                        LineDashingStyle => { GRP => "0070", ELEM => "0254", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                             LinePattern => { GRP => "0070", ELEM => "0255", VR => "UL", VM => "1", VERSION =>  "Supplement_120"},
                                                             FillPattern => { GRP => "0070", ELEM => "0256", VR => "OB", VM => "1", VERSION =>  "Supplement_120"},
                                                                FillMode => { GRP => "0070", ELEM => "0257", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                           ShadowOpacity => { GRP => "0070", ELEM => "0258", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                               GapLength => { GRP => "0070", ELEM => "0261", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                    DiameterOfVisibility => { GRP => "0070", ELEM => "0262", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                           RotationPoint => { GRP => "0070", ELEM => "0273", VR => "FL", VM => "2", VERSION =>  "Supplement_120"},
                                                           TickAlignment => { GRP => "0070", ELEM => "0274", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                           ShowTickLabel => { GRP => "0070", ELEM => "0278", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                      TickLabelAlignment => { GRP => "0070", ELEM => "0279", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                    CompoundGraphicUnits => { GRP => "0070", ELEM => "0282", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                        PatternOnOpacity => { GRP => "0070", ELEM => "0284", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                       PatternOffOpacity => { GRP => "0070", ELEM => "0285", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                      MajorTicksSequence => { GRP => "0070", ELEM => "0287", VR => "SQ", VM => "1", VERSION =>  "Supplement_120"},
                                                            TickPosition => { GRP => "0070", ELEM => "0288", VR => "FL", VM => "1", VERSION =>  "Supplement_120"},
                                                               TickLabel => { GRP => "0070", ELEM => "0289", VR => "SH", VM => "1", VERSION =>  "Supplement_120"},
                                                     CompoundGraphicType => { GRP => "0070", ELEM => "0294", VR => "CS", VM => "1", VERSION =>  "Supplement_120"},
                                                          GraphicGroupID => { GRP => "0070", ELEM => "0295", VR => "UL", VM => "1", VERSION =>  "Supplement_120"},
                                                             ImplantSize => { GRP => "0068", ELEM => "6210", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                                  ImplantTemplateVersion => { GRP => "0068", ELEM => "6221", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                         ReplacedImplantTemplateSequence => { GRP => "0068", ELEM => "6222", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                             ImplantType => { GRP => "0068", ELEM => "6223", VR => "CS", VM => "1", VERSION =>  "Supplement_131"},
                                       DerivationImplantTemplateSequence => { GRP => "0068", ELEM => "6224", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                         OriginalImplantTemplateSequence => { GRP => "0068", ELEM => "6225", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                       EffectiveDateTime => { GRP => "0068", ELEM => "6226", VR => "DT", VM => "1", VERSION =>  "Supplement_131"},
                                            ImplantTargetAnatomySequence => { GRP => "0068", ELEM => "6230", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                     InformationFromManufacturerSequence => { GRP => "0068", ELEM => "6260", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                    NotificationFromManufacturerSequence => { GRP => "0068", ELEM => "6265", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                InformationIssueDateTime => { GRP => "0068", ELEM => "6270", VR => "DT", VM => "1", VERSION =>  "Supplement_131"},
                                                      InformationSummary => { GRP => "0068", ELEM => "6280", VR => "ST", VM => "1", VERSION =>  "Supplement_131"},
                                ImplantRegulatoryDisapprovalCodeSequence => { GRP => "0068", ELEM => "62A0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                         OverallTemplateSpatialTolerance => { GRP => "0068", ELEM => "62A5", VR => "FD", VM => "1", VERSION =>  "Supplement_131"},
                                                    HPGLDocumentSequence => { GRP => "0068", ELEM => "62C0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                          HPGLDocumentID => { GRP => "0068", ELEM => "62D0", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                       HPGLDocumentLabel => { GRP => "0068", ELEM => "62D5", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                             ViewOrientationCodeSequence => { GRP => "0068", ELEM => "62E0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                 ViewOrientationModifier => { GRP => "0068", ELEM => "62F0", VR => "FD", VM => "9", VERSION =>  "Supplement_131"},
                                                     HPGLDocumentScaling => { GRP => "0068", ELEM => "62F2", VR => "FD", VM => "1", VERSION =>  "Supplement_131"},
                                                            HPGLDocument => { GRP => "0068", ELEM => "6300", VR => "OB", VM => "1", VERSION =>  "Supplement_131"},
                                                    HPGLContourPenNumber => { GRP => "0068", ELEM => "6310", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                         HPGLPenSequence => { GRP => "0068", ELEM => "6320", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                           HPGLPenNumber => { GRP => "0068", ELEM => "6330", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                            HPGLPenLabel => { GRP => "0068", ELEM => "6340", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                                      HPGLPenDescription => { GRP => "0068", ELEM => "6345", VR => "ST", VM => "1", VERSION =>  "Supplement_131"},
                                                RecommendedRotationPoint => { GRP => "0068", ELEM => "6346", VR => "FD", VM => "2", VERSION =>  "Supplement_131"},
                                                       BoundingRectangle => { GRP => "0068", ELEM => "6347", VR => "FD", VM => "4", VERSION =>  "Supplement_131"},
                                     ImplantTemplate3DModelSurfaceNumber => { GRP => "0068", ELEM => "6350", VR => "US", VM => "1-n", VERSION =>  "Supplement_131"},
                                         SurfaceModelDescriptionSequence => { GRP => "0068", ELEM => "6360", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                       SurfaceModelLabel => { GRP => "0068", ELEM => "6380", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                               SurfaceModelScalingFactor => { GRP => "0068", ELEM => "6390", VR => "FD", VM => "1", VERSION =>  "Supplement_131"},
                                                   MaterialsCodeSequence => { GRP => "0068", ELEM => "63A0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                            CoatingMaterialsCodeSequence => { GRP => "0068", ELEM => "63A4", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                 ImplantTypeCodeSequence => { GRP => "0068", ELEM => "63A8", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                              FixationMethodCodeSequence => { GRP => "0068", ELEM => "63AC", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                               MatingFeatureSetsSequence => { GRP => "0068", ELEM => "63B0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                      MatingFeatureSetID => { GRP => "0068", ELEM => "63C0", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                   MatingFeatureSetLabel => { GRP => "0068", ELEM => "63D0", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                                   MatingFeatureSequence => { GRP => "0068", ELEM => "63E0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                         MatingFeatureID => { GRP => "0068", ELEM => "63F0", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                    MatingFeatureDegreeOfFreedomSequence => { GRP => "0068", ELEM => "6400", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                       DegreeOfFreedomID => { GRP => "0068", ELEM => "6410", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                     DegreeOfFreedomType => { GRP => "0068", ELEM => "6420", VR => "CS", VM => "1", VERSION =>  "Supplement_131"},
                                    TwoDMatingFeatureCoordinatesSequence => { GRP => "0068", ELEM => "6430", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                ReferencedHPGLDocumentID => { GRP => "0068", ELEM => "6440", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                         TwoDMatingPoint => { GRP => "0068", ELEM => "6450", VR => "FD", VM => "2", VERSION =>  "Supplement_131"},
                                                          TwoDMatingAxes => { GRP => "0068", ELEM => "6460", VR => "FD", VM => "4", VERSION =>  "Supplement_131"},
                                             TwoDDegreeOfFreedomSequence => { GRP => "0068", ELEM => "6470", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                               ThreeDDegreeOfFreedomAxis => { GRP => "0068", ELEM => "6490", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                                                          RangeOfFreedom => { GRP => "0068", ELEM => "64A0", VR => "FD", VM => "2", VERSION =>  "Supplement_131"},
                                                       ThreeDMatingPoint => { GRP => "0068", ELEM => "64C0", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                                                        ThreeDMatingAxes => { GRP => "0068", ELEM => "64D0", VR => "FD", VM => "9", VERSION =>  "Supplement_131"},
                                                 TwoDDegreeOfFreedomAxis => { GRP => "0068", ELEM => "64F0", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                                           PlanningLandmarkPointSequence => { GRP => "0068", ELEM => "6500", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                            PlanningLandmarkLineSequence => { GRP => "0068", ELEM => "6510", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                           PlanningLandmarkPlaneSequence => { GRP => "0068", ELEM => "6520", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                      PlanningLandmarkID => { GRP => "0068", ELEM => "6530", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                             PlanningLandmarkDescription => { GRP => "0068", ELEM => "6540", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                              PlanningLandmarkIdentificationCodeSequence => { GRP => "0068", ELEM => "6545", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                            TwoDPointCoordinatesSequence => { GRP => "0068", ELEM => "6550", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                    TwoDPointCoordinates => { GRP => "0068", ELEM => "6560", VR => "FD", VM => "2", VERSION =>  "Supplement_131"},
                                                  ThreeDPointCoordinates => { GRP => "0068", ELEM => "6590", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                                             TwoDLineCoordinatesSequence => { GRP => "0068", ELEM => "65A0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                     TwoDLineCoordinates => { GRP => "0068", ELEM => "65B0", VR => "FD", VM => "4", VERSION =>  "Supplement_131"},
                                                   ThreeDLineCoordinates => { GRP => "0068", ELEM => "65D0", VR => "FD", VM => "6", VERSION =>  "Supplement_131"},
                                            TwoDPlaneCoordinatesSequence => { GRP => "0068", ELEM => "65E0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                   TwoDPlaneIntersection => { GRP => "0068", ELEM => "65F0", VR => "FD", VM => "4", VERSION =>  "Supplement_131"},
                                                       ThreeDPlaneOrigin => { GRP => "0068", ELEM => "6610", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                                                       ThreeDPlaneNormal => { GRP => "0068", ELEM => "6620", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                                             ImplantAssemblyTemplateName => { GRP => "0076", ELEM => "0001", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                           ImplantAssemblyTemplateIssuer => { GRP => "0076", ELEM => "0003", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                          ImplantAssemblyTemplateVersion => { GRP => "0076", ELEM => "0006", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                 ReplacedImplantAssemblyTemplateSequence => { GRP => "0076", ELEM => "0008", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                             ImplantAssemblyTemplateType => { GRP => "0076", ELEM => "000A", VR => "CS", VM => "1", VERSION =>  "Supplement_131"},
                                 OriginalImplantAssemblyTemplateSequence => { GRP => "0076", ELEM => "000C", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                               DerivationImplantAssemblyTemplateSequence => { GRP => "0076", ELEM => "000E", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                            ImplantAssemblyTemplateTargetAnatomySequence => { GRP => "0076", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                               ProcedureTypeCodeSequence => { GRP => "0076", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                       SurgicalTechnique => { GRP => "0076", ELEM => "0030", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                                  ComponentTypesSequence => { GRP => "0076", ELEM => "0032", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                               ComponentTypeCodeSequence => { GRP => "0076", ELEM => "0034", VR => "CS", VM => "1", VERSION =>  "Supplement_131"},
                                                  ExclusiveComponentType => { GRP => "0076", ELEM => "0036", VR => "CS", VM => "1", VERSION =>  "Supplement_131"},
                                                  MandatoryComponentType => { GRP => "0076", ELEM => "0038", VR => "CS", VM => "1", VERSION =>  "Supplement_131"},
                                                       ComponentSequence => { GRP => "0076", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                             ComponentID => { GRP => "0076", ELEM => "0055", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                               ComponentAssemblySequence => { GRP => "0076", ELEM => "0060", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                                  Component1ReferencedID => { GRP => "0076", ELEM => "0070", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                  Component1ReferencedMatingFeatureSetID => { GRP => "0076", ELEM => "0080", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                     Component1ReferencedMatingFeatureID => { GRP => "0076", ELEM => "0090", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                  Component2ReferencedID => { GRP => "0076", ELEM => "00A0", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                  Component2ReferencedMatingFeatureSetID => { GRP => "0076", ELEM => "00B0", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                     Component2ReferencedMatingFeatureID => { GRP => "0076", ELEM => "00C0", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                                                ImplantTemplateGroupName => { GRP => "0078", ELEM => "0000", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                         ImplantTemplateGroupDescription => { GRP => "0078", ELEM => "0010", VR => "ST", VM => "1", VERSION =>  "Supplement_131"},
                                              ImplantTemplateGroupIssuer => { GRP => "0078", ELEM => "0020", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                             ImplantTemplateGroupVersion => { GRP => "0078", ELEM => "0024", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                                    ReplacedImplantTemplateGroupSequence => { GRP => "0078", ELEM => "0026", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                               ImplantTemplateGroupTargetAnatomySequence => { GRP => "0078", ELEM => "0028", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                     ImplantTemplateGroupMembersSequence => { GRP => "0078", ELEM => "002A", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                            ImplantTemplateGroupMemberID => { GRP => "0078", ELEM => "002E", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                           ThreeDImplantTemplateGroupMemberMatchingPoint => { GRP => "0078", ELEM => "0050", VR => "FD", VM => "3", VERSION =>  "Supplement_131"},
                            ThreeDImplantTemplateGroupMemberMatchingAxes => { GRP => "0078", ELEM => "0060", VR => "FD", VM => "9", VERSION =>  "Supplement_131"},
                 ImplantTemplateGroupMemberMatching2DCoordinatesSequence => { GRP => "0078", ELEM => "0070", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                             TwoDImplantTemplateGroupMemberMatchingPoint => { GRP => "0078", ELEM => "0090", VR => "FD", VM => "2", VERSION =>  "Supplement_131"},
                              TwoDImplantTemplateGroupMemberMatchingAxes => { GRP => "0078", ELEM => "00A0", VR => "FD", VM => "4", VERSION =>  "Supplement_131"},
                          ImplantTemplateGroupVariationDimensionSequence => { GRP => "0078", ELEM => "00B0", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                              ImplantTemplateGroupVariationDimensionName => { GRP => "0078", ELEM => "00B2", VR => "LO", VM => "1", VERSION =>  "Supplement_131"},
                      ImplantTemplateGroupVariationDimensionRankSequence => { GRP => "0078", ELEM => "00B4", VR => "SQ", VM => "1", VERSION =>  "Supplement_131"},
                                  ReferencedImplantTemplateGroupMemberID => { GRP => "0078", ELEM => "00B6", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                              ImplantTemplateGroupVariationDimensionRank => { GRP => "0078", ELEM => "00B8", VR => "US", VM => "1", VERSION =>  "Supplement_131"},
                             OphthalmicAxialMeasurementsRightEyeSequence => { GRP => "0022", ELEM => "1007", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                              OphthalmicAxialMeasurementsLeftEyeSequence => { GRP => "0022", ELEM => "1008", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                   OphthalmicAxialMeasurementsDeviceType => { GRP => "0022", ELEM => "1009", VR => "CS", VM => "1", VERSION =>  "Supplement_144"},
                                   OphthalmicAxialLengthMeasurementsType => { GRP => "0022", ELEM => "1010", VR => "CS", VM => "1", VERSION =>  "Supplement_144"},
                                           OphthalmicAxialLengthSequence => { GRP => "0022", ELEM => "1012", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                   OphthalmicAxialLength => { GRP => "0022", ELEM => "1019", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                                  LensStatusCodeSequence => { GRP => "0022", ELEM => "1024", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                              VitreousStatusCodeSequence => { GRP => "0022", ELEM => "1025", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                  IOLFormulaCodeSequence => { GRP => "0022", ELEM => "1028", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                        IOLFormulaDetail => { GRP => "0022", ELEM => "1029", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                                                        KeratometerIndex => { GRP => "0022", ELEM => "1033", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                               SourceofOphthalmicAxialLengthCodeSequence => { GRP => "0022", ELEM => "1035", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                        TargetRefraction => { GRP => "0022", ELEM => "1037", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                             RefractiveProcedureOccurred => { GRP => "0022", ELEM => "1039", VR => "CS", VM => "1", VERSION =>  "Supplement_144"},
                                       RefractiveSurgeryTypeCodeSequence => { GRP => "0022", ELEM => "1040", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                  OphthalmicUltrasoundMethodCodeSequence => { GRP => "0022", ELEM => "1044", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                               OphthalmicAxialLengthMeasurementsSequence => { GRP => "0022", ELEM => "1050", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                                IOLPower => { GRP => "0022", ELEM => "1053", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                                PredictedRefractiveError => { GRP => "0022", ELEM => "1054", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                           OphthalmicAxialLengthVelocity => { GRP => "0022", ELEM => "1059", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                                   LensStatusDescription => { GRP => "0022", ELEM => "1065", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                                               VitreousStatusDescription => { GRP => "0022", ELEM => "1066", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                                                        IOLPowerSequence => { GRP => "0022", ELEM => "1090", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                    LensConstantSequence => { GRP => "0022", ELEM => "1092", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                         IOLManufacturer => { GRP => "0022", ELEM => "1093", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                                                             ImplantName => { GRP => "0022", ELEM => "1095", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                                  KeratometryMeasurementTypeCodeSequence => { GRP => "0022", ELEM => "1096", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                       ImplantPartNumber => { GRP => "0022", ELEM => "1097", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                           ReferencedOphthalmicAxialMeasurementsSequence => { GRP => "0022", ELEM => "1100", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence => { GRP => "0022", ELEM => "1101", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                      RefractiveErrorBeforeRefractiveSurgeryCodeSequence => { GRP => "0022", ELEM => "1103", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                              IOLPowerForExactEmmetropia => { GRP => "0022", ELEM => "1121", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                        IOLPowerForExactTargetRefraction => { GRP => "0022", ELEM => "1122", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                              AnteriorChamberDepthDefinitionCodeSequence => { GRP => "0022", ELEM => "1125", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                   LensThicknessSequence => { GRP => "0022", ELEM => "1127", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                            AnteriorChamberDepthSequence => { GRP => "0022", ELEM => "1128", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                           LensThickness => { GRP => "0022", ELEM => "1130", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                                    AnteriorChamberDepth => { GRP => "0022", ELEM => "1131", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                                   SourceofLensThicknessDataCodeSequence => { GRP => "0022", ELEM => "1132", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                            SourceofAnteriorChamberDepthDataCodeSequence => { GRP => "0022", ELEM => "1133", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                  SourceofRefractiveMeasurementsSequence => { GRP => "0022", ELEM => "1134", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                              SourceofRefractiveMeasurementsCodeSequence => { GRP => "0022", ELEM => "1135", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                OphthalmicAxialLengthMeasurementModified => { GRP => "0022", ELEM => "1140", VR => "CS", VM => "1", VERSION =>  "Supplement_144"},
                             OphthalmicAxialLengthDataSourceCodeSequence => { GRP => "0022", ELEM => "1150", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                                      SignaltoNoiseRatio => { GRP => "0022", ELEM => "1155", VR => "FL", VM => "1", VERSION =>  "Supplement_144"},
                              OphthalmicAxialLengthDataSourceDescription => { GRP => "0022", ELEM => "1159", VR => "LO", VM => "1", VERSION =>  "Supplement_144"},
                    OphthalmicAxialLengthMeasurementsTotalLengthSequence => { GRP => "0022", ELEM => "1210", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                OphthalmicAxialLengthMeasurementsSegmentalLengthSequence => { GRP => "0022", ELEM => "1211", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                OphthalmicAxialLengthMeasurementsLengthSummationSequence => { GRP => "0022", ELEM => "1212", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                     UltrasoundOphthalmicAxialLengthMeasurementsSequence => { GRP => "0022", ELEM => "1220", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                        OpticalOphthalmicAxialLengthMeasurementsSequence => { GRP => "0022", ELEM => "1225", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                         UltrasoundSelectedOphthalmicAxialLengthSequence => { GRP => "0022", ELEM => "1230", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                        OphthalmicAxialLengthSelectionMethodCodeSequence => { GRP => "0022", ELEM => "1250", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                            OpticalSelectedOphthalmicAxialLengthSequence => { GRP => "0022", ELEM => "1255", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                          SelectedSegmentalOphthalmicAxialLengthSequence => { GRP => "0022", ELEM => "1257", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                              SelectedTotalOphthalmicAxialLengthSequence => { GRP => "0022", ELEM => "1260", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                              OphthalmicAxialLengthQualityMetricSequence => { GRP => "0022", ELEM => "1262", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                      OphthalmicAxialLengthQualityMetricTypeCodeSequence => { GRP => "0022", ELEM => "1265", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                             IntraocularLensCalculationsRightEyeSequence => { GRP => "0022", ELEM => "1300", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                              IntraocularLensCalculationsLeftEyeSequence => { GRP => "0022", ELEM => "1310", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
               ReferencedOphthalmicAxialLengthMeasurementQCImageSequence => { GRP => "0022", ELEM => "1330", VR => "SQ", VM => "1", VERSION =>  "Supplement_144"},
                                            RETIRED_PixelSpacingSequence => { GRP => "0040", ELEM => "08D8", VR => "SQ", VM => "1", VERSION =>  "Supplement_145/retired"},
                                RETIRED_CoordinateSystemAxisCodeSequence => { GRP => "0040", ELEM => "08DA", VR => "SQ", VM => "1", VERSION =>  "Supplement_145/retired"},
                                                       ImagedVolumeWidth => { GRP => "0048", ELEM => "0001", VR => "FL", VM => "1", VERSION =>  "Supplement_145"},
                                                      ImagedVolumeHeight => { GRP => "0048", ELEM => "0002", VR => "FL", VM => "1", VERSION =>  "Supplement_145"},
                                                       ImagedVolumeDepth => { GRP => "0048", ELEM => "0003", VR => "FL", VM => "1", VERSION =>  "Supplement_145"},
                                                 TotalPixelMatrixColumns => { GRP => "0048", ELEM => "0006", VR => "UL", VM => "1", VERSION =>  "Supplement_145"},
                                                    TotalPixelMatrixRows => { GRP => "0048", ELEM => "0007", VR => "UL", VM => "1", VERSION =>  "Supplement_145"},
                                          TotalPixelMatrixOriginSequence => { GRP => "0048", ELEM => "0008", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                                    SpecimenLabelInImage => { GRP => "0048", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "Supplement_145"},
                                                             FocusMethod => { GRP => "0048", ELEM => "0011", VR => "CS", VM => "1", VERSION =>  "Supplement_145"},
                                                    ExtendedDepthOfField => { GRP => "0048", ELEM => "0012", VR => "CS", VM => "1", VERSION =>  "Supplement_145"},
                                                     NumberOfFocalPlanes => { GRP => "0048", ELEM => "0013", VR => "US", VM => "1", VERSION =>  "Supplement_145"},
                                              DistanceBetweenFocalPlanes => { GRP => "0048", ELEM => "0014", VR => "FL", VM => "1", VERSION =>  "Supplement_145"},
                                       RecommendedAbsentPixelCIELabValue => { GRP => "0048", ELEM => "0015", VR => "US", VM => "3", VERSION =>  "Supplement_145"},
                                             IlluminatorTypeCodeSequence => { GRP => "0048", ELEM => "0100", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                                   ImageOrientationSlide => { GRP => "0048", ELEM => "0102", VR => "DS", VM => "6", VERSION =>  "Supplement_145"},
                                                     OpticalPathSequence => { GRP => "0048", ELEM => "0105", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                                   OpticalPathIdentifier => { GRP => "0048", ELEM => "0106", VR => "SH", VM => "1", VERSION =>  "Supplement_145"},
                                                  OpticalPathDescription => { GRP => "0048", ELEM => "0107", VR => "ST", VM => "1", VERSION =>  "Supplement_145"},
                                           IlluminationColorCodeSequence => { GRP => "0048", ELEM => "0108", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                               SpecimenReferenceSequence => { GRP => "0048", ELEM => "0110", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                                      CondenserLensPower => { GRP => "0048", ELEM => "0111", VR => "DS", VM => "1", VERSION =>  "Supplement_145"},
                                                      ObjectiveLensPower => { GRP => "0048", ELEM => "0112", VR => "DS", VM => "1", VERSION =>  "Supplement_145"},
                                          ObjectiveLensNumericalAperture => { GRP => "0048", ELEM => "0113", VR => "DS", VM => "1", VERSION =>  "Supplement_145"},
                                         PaletteColorLookupTableSequence => { GRP => "0048", ELEM => "0120", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                       ReferencedImageNavigationSequence => { GRP => "0048", ELEM => "0200", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                        TopLeftHandCornerOfLocalizerArea => { GRP => "0048", ELEM => "0201", VR => "US", VM => "2", VERSION =>  "Supplement_145"},
                                    BottomRightHandCornerOfLocalizerArea => { GRP => "0048", ELEM => "0202", VR => "US", VM => "2", VERSION =>  "Supplement_145"},
                                       OpticalPathIdentificationSequence => { GRP => "0048", ELEM => "0207", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                              PlanePositionSlideSequence => { GRP => "0048", ELEM => "021A", VR => "SQ", VM => "1", VERSION =>  "Supplement_145"},
                                   ColumnPositionInTotalImagePixelMatrix => { GRP => "0048", ELEM => "021E", VR => "SL", VM => "1", VERSION =>  "Supplement_145"},
                                      RowPositionInTotalImagePixelMatrix => { GRP => "0048", ELEM => "021F", VR => "SL", VM => "1", VERSION =>  "Supplement_145"},
                                               PixelOriginInterpretation => { GRP => "0048", ELEM => "0301", VR => "CS", VM => "1", VERSION =>  "Supplement_145"},
                                             VisualFieldHorizontalExtent => { GRP => "0024", ELEM => "0010", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                               VisualFieldVerticalExtent => { GRP => "0024", ELEM => "0011", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                        VisualFieldShape => { GRP => "0024", ELEM => "0012", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                           ScreeningTestModeCodeSequence => { GRP => "0024", ELEM => "0016", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                MaximumStimulusLuminance => { GRP => "0024", ELEM => "0018", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                     BackgroundLuminance => { GRP => "0024", ELEM => "0020", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                               StimulusColorCodeSequence => { GRP => "0024", ELEM => "0021", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                 BackgroundIlluminationColorCodeSequence => { GRP => "0024", ELEM => "0024", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                            StimulusArea => { GRP => "0024", ELEM => "0025", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                StimulusPresentationTime => { GRP => "0024", ELEM => "0028", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                        FixationSequence => { GRP => "0024", ELEM => "0032", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                          FixationMonitoringCodeSequence => { GRP => "0024", ELEM => "0033", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                           VisualFieldCatchTrialSequence => { GRP => "0024", ELEM => "0034", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                 FixationCheckedQuantity => { GRP => "0024", ELEM => "0035", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                       PatientNotProperlyFixatedQuantity => { GRP => "0024", ELEM => "0036", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                          PresentedVisualStimuliDataFlag => { GRP => "0024", ELEM => "0037", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                   NumberOfVisualStimuli => { GRP => "0024", ELEM => "0038", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                         ExcessiveFixationLossesDataFlag => { GRP => "0024", ELEM => "0039", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                 ExcessiveFixationLosses => { GRP => "0024", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                StimuliRetestingQuantity => { GRP => "0024", ELEM => "0042", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                               CommentsOnPatientPerformanceOfVisualField => { GRP => "0024", ELEM => "0044", VR => "LT", VM => "1", VERSION =>  "Supplement_146"},
                                              FalseNegativesEstimateFlag => { GRP => "0024", ELEM => "0045", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                  FalseNegativesEstimate => { GRP => "0024", ELEM => "0046", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                             NegativeCatchTrialsQuantity => { GRP => "0024", ELEM => "0048", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                                  FalseNegativesQuantity => { GRP => "0024", ELEM => "0050", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                         ExcessiveFalseNegativesDataFlag => { GRP => "0024", ELEM => "0051", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                 ExcessiveFalseNegatives => { GRP => "0024", ELEM => "0052", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                              FalsePositivesEstimateFlag => { GRP => "0024", ELEM => "0053", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                  FalsePositivesEstimate => { GRP => "0024", ELEM => "0054", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                     CatchTrialsDataFlag => { GRP => "0024", ELEM => "0055", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                             PositiveCatchTrialsQuantity => { GRP => "0024", ELEM => "0056", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                                TestPointNormalsDataFlag => { GRP => "0024", ELEM => "0057", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                TestPointNormalsSequence => { GRP => "0024", ELEM => "0058", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                   GlobalDeviationProbabilityNormalsFlag => { GRP => "0024", ELEM => "0059", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                  FalsePositivesQuantity => { GRP => "0024", ELEM => "0060", VR => "US", VM => "1", VERSION =>  "Supplement_146"},
                                         ExcessiveFalsePositivesDataFlag => { GRP => "0024", ELEM => "0061", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                 ExcessiveFalsePositives => { GRP => "0024", ELEM => "0062", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                              VisualFieldTestNormalsFlag => { GRP => "0024", ELEM => "0063", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                  ResultsNormalsSequence => { GRP => "0024", ELEM => "0064", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                       AgeCorrectedSensitivityDeviationAlgorithmSequence => { GRP => "0024", ELEM => "0065", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                               GlobalDeviationFromNormal => { GRP => "0024", ELEM => "0066", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                  GeneralizedDefectSensitivityDeviationAlgorithmSequence => { GRP => "0024", ELEM => "0067", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                            LocalizedDeviationfromNormal => { GRP => "0024", ELEM => "0068", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                             PatientReliabilityIndicator => { GRP => "0024", ELEM => "0069", VR => "LO", VM => "1", VERSION =>  "Supplement_146"},
                                              VisualFieldMeanSensitivity => { GRP => "0024", ELEM => "0070", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                              GlobalDeviationProbability => { GRP => "0024", ELEM => "0071", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                    LocalDeviationProbabilityNormalsFlag => { GRP => "0024", ELEM => "0072", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                           LocalizedDeviationProbability => { GRP => "0024", ELEM => "0073", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                          ShortTermFluctuationCalculated => { GRP => "0024", ELEM => "0074", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                    ShortTermFluctuation => { GRP => "0024", ELEM => "0075", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                               ShortTermFluctuationProbabilityCalculated => { GRP => "0024", ELEM => "0076", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                         ShortTermFluctuationProbability => { GRP => "0024", ELEM => "0077", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                         CorrectedLocalizedDeviationFromNormalCalculated => { GRP => "0024", ELEM => "0078", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                   CorrectedLocalizedDeviationFromNormal => { GRP => "0024", ELEM => "0079", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
              CorrectedLocalizedDeviationFromNormalProbabilityCalculated => { GRP => "0024", ELEM => "0080", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                        CorrectedLocalizedDeviationFromNormalProbability => { GRP => "0024", ELEM => "0081", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                      GlobalDeviationProbabilitySequence => { GRP => "0024", ELEM => "0083", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                   LocalizedDeviationProbabilitySequence => { GRP => "0024", ELEM => "0085", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                               FovealSensitivityMeasured => { GRP => "0024", ELEM => "0086", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                       FovealSensitivity => { GRP => "0024", ELEM => "0087", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                 VisualFieldTestDuration => { GRP => "0024", ELEM => "0088", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                            VisualFieldTestPointSequence => { GRP => "0024", ELEM => "0089", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                         VisualFieldTestPointXCoordinate => { GRP => "0024", ELEM => "0090", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                         VisualFieldTestPointYCoordinate => { GRP => "0024", ELEM => "0091", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                   AgeCorrectedSensitivityDeviationValue => { GRP => "0024", ELEM => "0092", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                         StimulusResults => { GRP => "0024", ELEM => "0093", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                        SensitivityValue => { GRP => "0024", ELEM => "0094", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                      RetestStimulusSeen => { GRP => "0024", ELEM => "0095", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                  RetestSensitivityValue => { GRP => "0024", ELEM => "0096", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                     VisualFieldTestPointNormalsSequence => { GRP => "0024", ELEM => "0097", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                        QuantifiedDefect => { GRP => "0024", ELEM => "0098", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                      GeneralizedDefectCorrectedSensitivityDeviationFlag => { GRP => "0024", ELEM => "0102", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                     GeneralizedDefectCorrectedSensitivityDeviationValue => { GRP => "0024", ELEM => "0103", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
          GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue => { GRP => "0024", ELEM => "0104", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                 MinimumSensitivityValue => { GRP => "0024", ELEM => "0105", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                      BlindSpotLocalized => { GRP => "0024", ELEM => "0106", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                    BlindSpotXCoordinate => { GRP => "0024", ELEM => "0107", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                    BlindSpotYCoordinate => { GRP => "0024", ELEM => "0108", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                         VisualAcuityMeasurementSequence => { GRP => "0024", ELEM => "0110", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                               RefractiveParametersUsedOnPatientSequence => { GRP => "0024", ELEM => "0112", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                   MeasurementLaterality => { GRP => "0024", ELEM => "0113", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                     OphthalmicPatientClinicalInformationLeftEyeSequence => { GRP => "0024", ELEM => "0114", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                    OphthalmicPatientClinicalInformationRightEyeSequence => { GRP => "0024", ELEM => "0115", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                            FovealPointNormativeDataFlag => { GRP => "0024", ELEM => "0117", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                             FovealPointProbabilityValue => { GRP => "0024", ELEM => "0118", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                               ScreeningBaselineMeasured => { GRP => "0024", ELEM => "0120", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                       ScreeningBaselineMeasuredSequence => { GRP => "0024", ELEM => "0122", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                   ScreeningBaselineType => { GRP => "0024", ELEM => "0124", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                  ScreeningBaselineValue => { GRP => "0024", ELEM => "0126", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                         AlgorithmSource => { GRP => "0024", ELEM => "0202", VR => "LO", VM => "1", VERSION =>  "Supplement_146"},
                                                             DataSetName => { GRP => "0024", ELEM => "0306", VR => "LO", VM => "1", VERSION =>  "Supplement_146"},
                                                          DataSetVersion => { GRP => "0024", ELEM => "0307", VR => "LO", VM => "1", VERSION =>  "Supplement_146"},
                                                           DataSetSource => { GRP => "0024", ELEM => "0308", VR => "LO", VM => "1", VERSION =>  "Supplement_146"},
                                                      DataSetDescription => { GRP => "0024", ELEM => "0309", VR => "LO", VM => "1", VERSION =>  "Supplement_146"},
                           VisualFieldTestReliabilityGlobalIndexSequence => { GRP => "0024", ELEM => "0317", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                   VisualFieldGlobalResultsIndexSequence => { GRP => "0024", ELEM => "0320", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                 DataObservationSequence => { GRP => "0024", ELEM => "0325", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                        IndexNormalsFlag => { GRP => "0024", ELEM => "0338", VR => "CS", VM => "1", VERSION =>  "Supplement_146"},
                                                        IndexProbability => { GRP => "0024", ELEM => "0341", VR => "FL", VM => "1", VERSION =>  "Supplement_146"},
                                                IndexProbabilitySequence => { GRP => "0024", ELEM => "0344", VR => "SQ", VM => "1", VERSION =>  "Supplement_146"},
                                                 PatientSizeCodeSequence => { GRP => "0010", ELEM => "1021", VR => "SQ", VM => "1", VERSION =>  "CP_650"},
                                     VelocityEncodingAcquisitionSequence => { GRP => "0018", ELEM => "9092", VR => "SQ", VM => "1", VERSION =>  "CP_988"},
                                              ApplicatorGeometrySequence => { GRP => "300A", ELEM => "0431", VR => "SQ", VM => "1", VERSION =>  "CP_1010"},
                                                 ApplicatorApertureShape => { GRP => "300A", ELEM => "0432", VR => "CS", VM => "1", VERSION =>  "CP_1010"},
                                                       ApplicatorOpening => { GRP => "300A", ELEM => "0433", VR => "FL", VM => "1", VERSION =>  "CP_1010"},
                                                      ApplicatorOpeningX => { GRP => "300A", ELEM => "0434", VR => "FL", VM => "1", VERSION =>  "CP_1010"},
                                                      ApplicatorOpeningY => { GRP => "300A", ELEM => "0435", VR => "FL", VM => "1", VERSION =>  "CP_1010"},
                              SourceToApplicatorMountingPositionDistance => { GRP => "300A", ELEM => "0436", VR => "FL", VM => "1", VERSION =>  "CP_1010"},
                                                           ExposureIndex => { GRP => "0018", ELEM => "1411", VR => "DS", VM => "1", VERSION =>  "CP_1024"},
                                                     TargetExposureIndex => { GRP => "0018", ELEM => "1412", VR => "DS", VM => "1", VERSION =>  "CP_1024"},
                                                          DeviationIndex => { GRP => "0018", ELEM => "1413", VR => "DS", VM => "1", VERSION =>  "CP_1024"},
                                              RETIRED_CommandLengthToEnd => { GRP => "0000", ELEM => "0001", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_CommandRecognitionCode => { GRP => "0000", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_Initiator => { GRP => "0000", ELEM => "0200", VR => "AE", VM => "1", VERSION =>  "DICOM/retired"},
                                                        RETIRED_Receiver => { GRP => "0000", ELEM => "0300", VR => "AE", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_FindLocation => { GRP => "0000", ELEM => "0400", VR => "AE", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_NumberOfMatches => { GRP => "0000", ELEM => "0850", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ResponseSequenceNumber => { GRP => "0000", ELEM => "0860", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_DialogReceiver => { GRP => "0000", ELEM => "4000", VR => "AT", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_TerminalType => { GRP => "0000", ELEM => "4010", VR => "AT", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_MessageSetID => { GRP => "0000", ELEM => "5010", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_EndMessageID => { GRP => "0000", ELEM => "5020", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_DisplayFormat => { GRP => "0000", ELEM => "5110", VR => "AT", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_PagePositionID => { GRP => "0000", ELEM => "5120", VR => "AT", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_TextFormatID => { GRP => "0000", ELEM => "5130", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_NormalReverse => { GRP => "0000", ELEM => "5140", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_AddGrayScale => { GRP => "0000", ELEM => "5150", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                         RETIRED_Borders => { GRP => "0000", ELEM => "5160", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                          RETIRED_Copies => { GRP => "0000", ELEM => "5170", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_CommandMagnificationType => { GRP => "0000", ELEM => "5180", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                           RETIRED_Erase => { GRP => "0000", ELEM => "5190", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                           RETIRED_Print => { GRP => "0000", ELEM => "51A0", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                        RETIRED_Overlays => { GRP => "0000", ELEM => "51B0", VR => "US", VM => "1-n", VERSION =>  "DICOM/retired"},
                                       RETIRED_MRDRDirectoryRecordOffset => { GRP => "0004", ELEM => "1504", VR => "up", VM => "1", VERSION =>  "DICOM/retired"},
                                              RETIRED_NumberOfReferences => { GRP => "0004", ELEM => "1600", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_LengthToEnd => { GRP => "0008", ELEM => "0001", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_RecognitionCode => { GRP => "0008", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_OverlayDate => { GRP => "0008", ELEM => "0024", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_CurveDate => { GRP => "0008", ELEM => "0025", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_OverlayTime => { GRP => "0008", ELEM => "0034", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_CurveTime => { GRP => "0008", ELEM => "0035", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_DataSetType => { GRP => "0008", ELEM => "0040", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_DataSetSubtype => { GRP => "0008", ELEM => "0041", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_NuclearMedicineSeriesType => { GRP => "0008", ELEM => "0042", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_NetworkID => { GRP => "0008", ELEM => "1000", VR => "AE", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_ReferencedResultsSequence => { GRP => "0008", ELEM => "1100", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_ReferencedOverlaySequence => { GRP => "0008", ELEM => "1130", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_ReferencedCurveSequence => { GRP => "0008", ELEM => "1145", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                    RETIRED_LossyImageCompressionRetired => { GRP => "0008", ELEM => "2110", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                              RETIRED_TransducerPosition => { GRP => "0008", ELEM => "2200", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                           RETIRED_TransducerOrientation => { GRP => "0008", ELEM => "2204", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_AnatomicStructure => { GRP => "0008", ELEM => "2208", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_TransducerPositionSequence => { GRP => "0008", ELEM => "2240", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                              RETIRED_TransducerPositionModifierSequence => { GRP => "0008", ELEM => "2242", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_TransducerOrientationSequence => { GRP => "0008", ELEM => "2244", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                           RETIRED_TransducerOrientationModifierSequence => { GRP => "0008", ELEM => "2246", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                 RETIRED_AnatomicStructureSpaceOrRegionCodeSequenceTrial => { GRP => "0008", ELEM => "2251", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                       RETIRED_AnatomicPortalOfEntranceCodeSequenceTrial => { GRP => "0008", ELEM => "2253", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                      RETIRED_AnatomicApproachDirectionCodeSequenceTrial => { GRP => "0008", ELEM => "2255", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                             RETIRED_AnatomicPerspectiveDescriptionTrial => { GRP => "0008", ELEM => "2256", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                            RETIRED_AnatomicPerspectiveCodeSequenceTrial => { GRP => "0008", ELEM => "2257", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
           RETIRED_AnatomicLocationOfExaminingInstrumentDescriptionTrial => { GRP => "0008", ELEM => "2258", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
          RETIRED_AnatomicLocationOfExaminingInstrumentCodeSequenceTrial => { GRP => "0008", ELEM => "2259", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
         RETIRED_AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial => { GRP => "0008", ELEM => "225A", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
              RETIRED_OnAxisBackgroundAnatomicStructureCodeSequenceTrial => { GRP => "0008", ELEM => "225C", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_IdentifyingComments => { GRP => "0008", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_InsurancePlanIdentification => { GRP => "0010", ELEM => "1050", VR => "LO", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                    RETIRED_Radionuclide => { GRP => "0018", ELEM => "0030", VR => "LO", VM => "1-n", VERSION =>  "DICOM/retired"},
                                          RETIRED_EnergyWindowCenterline => { GRP => "0018", ELEM => "0032", VR => "DS", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_EnergyWindowTotalWidth => { GRP => "0018", ELEM => "0033", VR => "DS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                     RETIRED_TherapyType => { GRP => "0018", ELEM => "0037", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                              RETIRED_TherapyDescription => { GRP => "0018", ELEM => "0039", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_HardcopyCreationDeviceID => { GRP => "0018", ELEM => "1011", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_HardcopyDeviceManufacturer => { GRP => "0018", ELEM => "1017", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_HardcopyDeviceSoftwareVersion => { GRP => "0018", ELEM => "101A", VR => "LO", VM => "1-n", VERSION =>  "DICOM/retired"},
                             RETIRED_HardcopyDeviceManufacturerModelName => { GRP => "0018", ELEM => "101B", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_AngularPosition => { GRP => "0018", ELEM => "1141", VR => "DS", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_RotationOffset => { GRP => "0018", ELEM => "1146", VR => "DS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                           RETIRED_UpperLowerPixelValues => { GRP => "0018", ELEM => "1240", VR => "IS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                             RETIRED_AcquisitionComments => { GRP => "0018", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_PostprocessingFunction => { GRP => "0018", ELEM => "5021", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_DynamicRange => { GRP => "0018", ELEM => "5030", VR => "DS", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_TotalGain => { GRP => "0018", ELEM => "5040", VR => "DS", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_ImageTransformationMatrix => { GRP => "0018", ELEM => "5210", VR => "DS", VM => "6", VERSION =>  "DICOM/retired"},
                                          RETIRED_ImageTranslationVector => { GRP => "0018", ELEM => "5212", VR => "DS", VM => "3", VERSION =>  "DICOM/retired"},
                             RETIRED_DopplerSampleVolumeXPositionRetired => { GRP => "0018", ELEM => "6038", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                             RETIRED_DopplerSampleVolumeYPositionRetired => { GRP => "0018", ELEM => "603A", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_TMLinePositionX0Retired => { GRP => "0018", ELEM => "603C", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_TMLinePositionY0Retired => { GRP => "0018", ELEM => "603E", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_TMLinePositionX1Retired => { GRP => "0018", ELEM => "6040", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_TMLinePositionY1Retired => { GRP => "0018", ELEM => "6042", VR => "UL", VM => "1", VERSION =>  "DICOM/retired"},
                           RETIRED_ParallelReductionFactorInPlaneRetired => { GRP => "0018", ELEM => "9096", VR => "FD", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_BulkMotionStatus => { GRP => "0018", ELEM => "9166", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                        RETIRED_ChemicalShiftMinimumIntegrationLimitInHz => { GRP => "0018", ELEM => "9195", VR => "FD", VM => "1", VERSION =>  "DICOM/retired"},
                        RETIRED_ChemicalShiftMaximumIntegrationLimitInHz => { GRP => "0018", ELEM => "9196", VR => "FD", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_IsotopeNumber => { GRP => "0020", ELEM => "0014", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_PhaseNumber => { GRP => "0020", ELEM => "0015", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_IntervalNumber => { GRP => "0020", ELEM => "0016", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_TimeSlotNumber => { GRP => "0020", ELEM => "0017", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_AngleNumber => { GRP => "0020", ELEM => "0018", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_OverlayNumber => { GRP => "0020", ELEM => "0022", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_CurveNumber => { GRP => "0020", ELEM => "0024", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_LUTNumber => { GRP => "0020", ELEM => "0026", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_ImagePosition => { GRP => "0020", ELEM => "0030", VR => "DS", VM => "3", VERSION =>  "DICOM/retired"},
                                                RETIRED_ImageOrientation => { GRP => "0020", ELEM => "0035", VR => "DS", VM => "6", VERSION =>  "DICOM/retired"},
                                                        RETIRED_Location => { GRP => "0020", ELEM => "0050", VR => "DS", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_ImageGeometryType => { GRP => "0020", ELEM => "0070", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_MaskingImage => { GRP => "0020", ELEM => "0080", VR => "CS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                   RETIRED_SeriesInStudy => { GRP => "0020", ELEM => "1000", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_AcquisitionsInSeries => { GRP => "0020", ELEM => "1001", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_ImagesInSeries => { GRP => "0020", ELEM => "1003", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_AcquisitionsInStudy => { GRP => "0020", ELEM => "1004", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_ImagesInStudy => { GRP => "0020", ELEM => "1005", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_Reference => { GRP => "0020", ELEM => "1020", VR => "CS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                               RETIRED_OtherStudyNumbers => { GRP => "0020", ELEM => "1070", VR => "IS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                               RETIRED_ModifyingDeviceID => { GRP => "0020", ELEM => "3401", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_ModifiedImageID => { GRP => "0020", ELEM => "3402", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_ModifiedImageDate => { GRP => "0020", ELEM => "3403", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_ModifyingDeviceManufacturer => { GRP => "0020", ELEM => "3404", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_ModifiedImageTime => { GRP => "0020", ELEM => "3405", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_ModifiedImageDescription => { GRP => "0020", ELEM => "3406", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_OriginalImageIdentification => { GRP => "0020", ELEM => "5000", VR => "AT", VM => "1-n", VERSION =>  "DICOM/retired"},
                         RETIRED_OriginalImageIdentificationNomenclature => { GRP => "0020", ELEM => "5002", VR => "CS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                 RETIRED_ImageDimensions => { GRP => "0028", ELEM => "0005", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                          RETIRED_Planes => { GRP => "0028", ELEM => "0012", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_ImageFormat => { GRP => "0028", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_ManipulatedImage => { GRP => "0028", ELEM => "0050", VR => "LO", VM => "1-n", VERSION =>  "DICOM/retired"},
                                      RETIRED_CompressionRecognitionCode => { GRP => "0028", ELEM => "005F", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_CompressionCode => { GRP => "0028", ELEM => "0060", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                           RETIRED_CompressionOriginator => { GRP => "0028", ELEM => "0061", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_CompressionLabel => { GRP => "0028", ELEM => "0062", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_CompressionDescription => { GRP => "0028", ELEM => "0063", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_CompressionSequence => { GRP => "0028", ELEM => "0065", VR => "CS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                         RETIRED_CompressionStepPointers => { GRP => "0028", ELEM => "0066", VR => "AT", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                  RETIRED_RepeatInterval => { GRP => "0028", ELEM => "0068", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_BitsGrouped => { GRP => "0028", ELEM => "0069", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_PerimeterTable => { GRP => "0028", ELEM => "0070", VR => "US", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                  RETIRED_PerimeterValue => { GRP => "0028", ELEM => "0071", VR => "xs", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_PredictorRows => { GRP => "0028", ELEM => "0080", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_PredictorColumns => { GRP => "0028", ELEM => "0081", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                              RETIRED_PredictorConstants => { GRP => "0028", ELEM => "0082", VR => "US", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                   RETIRED_BlockedPixels => { GRP => "0028", ELEM => "0090", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_BlockRows => { GRP => "0028", ELEM => "0091", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_BlockColumns => { GRP => "0028", ELEM => "0092", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                      RETIRED_RowOverlap => { GRP => "0028", ELEM => "0093", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_ColumnOverlap => { GRP => "0028", ELEM => "0094", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_SmallestValidPixelValue => { GRP => "0028", ELEM => "0104", VR => "xs", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_LargestValidPixelValue => { GRP => "0028", ELEM => "0105", VR => "xs", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_SmallestImagePixelValueInPlane => { GRP => "0028", ELEM => "0110", VR => "xs", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_LargestImagePixelValueInPlane => { GRP => "0028", ELEM => "0111", VR => "xs", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_ImageLocation => { GRP => "0028", ELEM => "0200", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_TransformLabel => { GRP => "0028", ELEM => "0400", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_TransformVersionNumber => { GRP => "0028", ELEM => "0401", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_NumberOfTransformSteps => { GRP => "0028", ELEM => "0402", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_SequenceOfCompressedData => { GRP => "0028", ELEM => "0403", VR => "LO", VM => "1-n", VERSION =>  "DICOM/retired"},
                                           RETIRED_DetailsOfCoefficients => { GRP => "0028", ELEM => "0404", VR => "AT", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                        RETIRED_DCTLabel => { GRP => "0028", ELEM => "0700", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_DataBlockDescription => { GRP => "0028", ELEM => "0701", VR => "CS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                       RETIRED_DataBlock => { GRP => "0028", ELEM => "0702", VR => "AT", VM => "1-n", VERSION =>  "DICOM/retired"},
                                       RETIRED_NormalizationFactorFormat => { GRP => "0028", ELEM => "0710", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_ZonalMapNumberFormat => { GRP => "0028", ELEM => "0720", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_ZonalMapLocation => { GRP => "0028", ELEM => "0721", VR => "AT", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                  RETIRED_ZonalMapFormat => { GRP => "0028", ELEM => "0722", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_AdaptiveMapFormat => { GRP => "0028", ELEM => "0730", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_CodeNumberFormat => { GRP => "0028", ELEM => "0740", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_GrayScale => { GRP => "0028", ELEM => "1080", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_GrayLookupTableDescriptor => { GRP => "0028", ELEM => "1100", VR => "xs", VM => "3", VERSION =>  "DICOM/retired"},
                       RETIRED_LargeRedPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1111", VR => "xs", VM => "4", VERSION =>  "DICOM/retired"},
                     RETIRED_LargeGreenPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1112", VR => "xs", VM => "4", VERSION =>  "DICOM/retired"},
                      RETIRED_LargeBluePaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1113", VR => "xs", VM => "4", VERSION =>  "DICOM/retired"},
                                             RETIRED_GrayLookupTableData => { GRP => "0028", ELEM => "1200", VR => "lt", VM => "1-n", VERSION =>  "DICOM/retired"},
                             RETIRED_LargeRedPaletteColorLookupTableData => { GRP => "0028", ELEM => "1211", VR => "OW", VM => "1", VERSION =>  "DICOM/retired"},
                           RETIRED_LargeGreenPaletteColorLookupTableData => { GRP => "0028", ELEM => "1212", VR => "OW", VM => "1", VERSION =>  "DICOM/retired"},
                            RETIRED_LargeBluePaletteColorLookupTableData => { GRP => "0028", ELEM => "1213", VR => "OW", VM => "1", VERSION =>  "DICOM/retired"},
                                 RETIRED_LargePaletteColorLookupTableUID => { GRP => "0028", ELEM => "1214", VR => "UI", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_ImagePresentationComments => { GRP => "0028", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_BiPlaneAcquisitionSequence => { GRP => "0028", ELEM => "5000", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_MaskPointers => { GRP => "0028", ELEM => "6030", VR => "US", VM => "1-n", VERSION =>  "DICOM/retired"},
                                     RETIRED_LargestMonochromePixelValue => { GRP => "0028", ELEM => "9099", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_StudyStatusID => { GRP => "0032", ELEM => "000A", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_StudyPriorityID => { GRP => "0032", ELEM => "000C", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_StudyIDIssuer => { GRP => "0032", ELEM => "0012", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_StudyVerifiedDate => { GRP => "0032", ELEM => "0032", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                               RETIRED_StudyVerifiedTime => { GRP => "0032", ELEM => "0033", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_StudyReadDate => { GRP => "0032", ELEM => "0034", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_StudyReadTime => { GRP => "0032", ELEM => "0035", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_ScheduledStudyStartDate => { GRP => "0032", ELEM => "1000", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_ScheduledStudyStartTime => { GRP => "0032", ELEM => "1001", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledStudyStopDate => { GRP => "0032", ELEM => "1010", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledStudyStopTime => { GRP => "0032", ELEM => "1011", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledStudyLocation => { GRP => "0032", ELEM => "1020", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_ScheduledStudyLocationAETitle => { GRP => "0032", ELEM => "1021", VR => "AE", VM => "1-n", VERSION =>  "DICOM/retired"},
                                                  RETIRED_ReasonForStudy => { GRP => "0032", ELEM => "1030", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_StudyArrivalDate => { GRP => "0032", ELEM => "1040", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_StudyArrivalTime => { GRP => "0032", ELEM => "1041", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_StudyCompletionDate => { GRP => "0032", ELEM => "1050", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_StudyCompletionTime => { GRP => "0032", ELEM => "1051", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_StudyComponentStatusID => { GRP => "0032", ELEM => "1055", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_StudyComments => { GRP => "0032", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_IssuerOfAdmissionID => { GRP => "0038", ELEM => "0011", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledAdmissionDate => { GRP => "0038", ELEM => "001A", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledAdmissionTime => { GRP => "0038", ELEM => "001B", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledDischargeDate => { GRP => "0038", ELEM => "001C", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_ScheduledDischargeTime => { GRP => "0038", ELEM => "001D", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                            RETIRED_ScheduledPatientInstitutionResidence => { GRP => "0038", ELEM => "001E", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_DischargeDate => { GRP => "0038", ELEM => "0030", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_DischargeTime => { GRP => "0038", ELEM => "0032", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_DischargeDiagnosisDescription => { GRP => "0038", ELEM => "0040", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_DischargeDiagnosisCodeSequence => { GRP => "0038", ELEM => "0044", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_IssuerOfServiceEpisodeID => { GRP => "0038", ELEM => "0061", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_DistanceSourceToSupport => { GRP => "0040", ELEM => "0307", VR => "DS", VM => "1", VERSION =>  "DICOM/retired"},
                                 RETIRED_ReferencedProcedureStepSequence => { GRP => "0040", ELEM => "0330", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_SpecimenAccessionNumber => { GRP => "0040", ELEM => "050A", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_SpecimenSequence => { GRP => "0040", ELEM => "0550", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                RETIRED_SpecimenDescriptionSequenceTrial => { GRP => "0040", ELEM => "0552", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_SpecimenDescriptionTrial => { GRP => "0040", ELEM => "0553", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_SlideIdentifier => { GRP => "0040", ELEM => "06FA", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_VitalStainCodeSequenceTrial => { GRP => "0040", ELEM => "09F8", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_PlacerOrderNumberProcedure => { GRP => "0040", ELEM => "1006", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_FillerOrderNumberProcedure => { GRP => "0040", ELEM => "1007", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                               RETIRED_ReasonForTheImagingServiceRequest => { GRP => "0040", ELEM => "2001", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                   RETIRED_PlacerOrderNumberImagingServiceRequestRetired => { GRP => "0040", ELEM => "2006", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                   RETIRED_FillerOrderNumberImagingServiceRequestRetired => { GRP => "0040", ELEM => "2007", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_EquivalentCDADocumentSequence => { GRP => "0040", ELEM => "A090", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_AddressTrial => { GRP => "0040", ELEM => "A353", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_TelephoneNumberTrial => { GRP => "0040", ELEM => "A354", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_TemplateVersion => { GRP => "0040", ELEM => "DB06", VR => "DT", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_TemplateLocalVersion => { GRP => "0040", ELEM => "DB07", VR => "DT", VM => "1", VERSION =>  "DICOM/retired"},
                                           RETIRED_TemplateExtensionFlag => { GRP => "0040", ELEM => "DB0B", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                RETIRED_TemplateExtensionOrganizationUID => { GRP => "0040", ELEM => "DB0C", VR => "UI", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_TemplateExtensionCreatorUID => { GRP => "0040", ELEM => "DB0D", VR => "UI", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_CountsIncluded => { GRP => "0054", ELEM => "1400", VR => "CS", VM => "1-n", VERSION =>  "DICOM/retired"},
                                          RETIRED_DeadTimeCorrectionFlag => { GRP => "0054", ELEM => "1401", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_ImageRotationRetired => { GRP => "0070", ELEM => "0040", VR => "IS", VM => "1", VERSION =>  "DICOM/retired"},
                             RETIRED_DisplayedAreaTopLeftHandCornerTrial => { GRP => "0070", ELEM => "0050", VR => "US", VM => "2", VERSION =>  "DICOM/retired"},
                         RETIRED_DisplayedAreaBottomRightHandCornerTrial => { GRP => "0070", ELEM => "0051", VR => "US", VM => "2", VERSION =>  "DICOM/retired"},
                          RETIRED_GraphicLayerRecommendedDisplayRGBValue => { GRP => "0070", ELEM => "0067", VR => "US", VM => "3", VERSION =>  "DICOM/retired"},
                                                      RETIRED_TopicTitle => { GRP => "0088", ELEM => "0904", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_TopicSubject => { GRP => "0088", ELEM => "0906", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_TopicAuthor => { GRP => "0088", ELEM => "0910", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_TopicKeywords => { GRP => "0088", ELEM => "0912", VR => "LO", VM => "1-32", VERSION =>  "DICOM/retired"},
                                          RETIRED_ColorImagePrintingFlag => { GRP => "2000", ELEM => "0062", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_CollationFlag => { GRP => "2000", ELEM => "0063", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                  RETIRED_AnnotationFlag => { GRP => "2000", ELEM => "0065", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_ImageOverlayFlag => { GRP => "2000", ELEM => "0067", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_PresentationLUTFlag => { GRP => "2000", ELEM => "0069", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_ImageBoxPresentationLUTFlag => { GRP => "2000", ELEM => "006A", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                   RETIRED_ReferencedStoredPrintSequence => { GRP => "2000", ELEM => "0510", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                               RETIRED_ReferencedImageOverlayBoxSequence => { GRP => "2020", ELEM => "0130", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_ReferencedVOILUTBoxSequence => { GRP => "2020", ELEM => "0140", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_ReferencedOverlayPlaneSequence => { GRP => "2040", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                    RETIRED_ReferencedOverlayPlaneGroups => { GRP => "2040", ELEM => "0011", VR => "US", VM => "1-99", VERSION =>  "DICOM/retired"},
                                        RETIRED_OverlayPixelDataSequence => { GRP => "2040", ELEM => "0020", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_OverlayMagnificationType => { GRP => "2040", ELEM => "0060", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_OverlaySmoothingType => { GRP => "2040", ELEM => "0070", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_OverlayOrImageMagnification => { GRP => "2040", ELEM => "0072", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_MagnifyToNumberOfColumns => { GRP => "2040", ELEM => "0074", VR => "US", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_OverlayForegroundDensity => { GRP => "2040", ELEM => "0080", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_OverlayBackgroundDensity => { GRP => "2040", ELEM => "0082", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_OverlayMode => { GRP => "2040", ELEM => "0090", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_ThresholdDensity => { GRP => "2040", ELEM => "0100", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                               RETIRED_ReferencedImageBoxSequenceRetired => { GRP => "2040", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                                      RETIRED_PrintJobID => { GRP => "2100", ELEM => "0010", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                                   RETIRED_DestinationAE => { GRP => "2100", ELEM => "0140", VR => "AE", VM => "1", VERSION =>  "DICOM/retired"},
                       RETIRED_ReferencedPrintJobSequencePullStoredPrint => { GRP => "2100", ELEM => "0500", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_PrintQueueID => { GRP => "2110", ELEM => "0099", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_QueueStatus => { GRP => "2120", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                     RETIRED_PrintJobDescriptionSequence => { GRP => "2120", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_ReferencedPrintJobSequence => { GRP => "2120", ELEM => "0070", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                             RETIRED_PrintManagementCapabilitiesSequence => { GRP => "2130", ELEM => "0010", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_PrinterCharacteristicsSequence => { GRP => "2130", ELEM => "0015", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_FilmBoxContentSequence => { GRP => "2130", ELEM => "0030", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                         RETIRED_ImageBoxContentSequence => { GRP => "2130", ELEM => "0040", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_AnnotationContentSequence => { GRP => "2130", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_ImageOverlayBoxContentSequence => { GRP => "2130", ELEM => "0060", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_PresentationLUTContentSequence => { GRP => "2130", ELEM => "0080", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                           RETIRED_ProposedStudySequence => { GRP => "2130", ELEM => "00A0", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                           RETIRED_OriginalImageSequence => { GRP => "2130", ELEM => "00C0", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_Arbitrary => { GRP => "4000", ELEM => "0010", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                                                    RETIRED_TextComments => { GRP => "4000", ELEM => "4000", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                                                       RETIRED_ResultsID => { GRP => "4008", ELEM => "0040", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_ResultsIDIssuer => { GRP => "4008", ELEM => "0042", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                RETIRED_ReferencedInterpretationSequence => { GRP => "4008", ELEM => "0050", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_InterpretationRecordedDate => { GRP => "4008", ELEM => "0100", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_InterpretationRecordedTime => { GRP => "4008", ELEM => "0101", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_InterpretationRecorder => { GRP => "4008", ELEM => "0102", VR => "PN", VM => "1", VERSION =>  "DICOM/retired"},
                                        RETIRED_ReferenceToRecordedSound => { GRP => "4008", ELEM => "0103", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                 RETIRED_InterpretationTranscriptionDate => { GRP => "4008", ELEM => "0108", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                 RETIRED_InterpretationTranscriptionTime => { GRP => "4008", ELEM => "0109", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                       RETIRED_InterpretationTranscriber => { GRP => "4008", ELEM => "010A", VR => "PN", VM => "1", VERSION =>  "DICOM/retired"},
                                              RETIRED_InterpretationText => { GRP => "4008", ELEM => "010B", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_InterpretationAuthor => { GRP => "4008", ELEM => "010C", VR => "PN", VM => "1", VERSION =>  "DICOM/retired"},
                                  RETIRED_InterpretationApproverSequence => { GRP => "4008", ELEM => "0111", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_InterpretationApprovalDate => { GRP => "4008", ELEM => "0112", VR => "DA", VM => "1", VERSION =>  "DICOM/retired"},
                                      RETIRED_InterpretationApprovalTime => { GRP => "4008", ELEM => "0113", VR => "TM", VM => "1", VERSION =>  "DICOM/retired"},
                                RETIRED_PhysicianApprovingInterpretation => { GRP => "4008", ELEM => "0114", VR => "PN", VM => "1", VERSION =>  "DICOM/retired"},
                              RETIRED_InterpretationDiagnosisDescription => { GRP => "4008", ELEM => "0115", VR => "LT", VM => "1", VERSION =>  "DICOM/retired"},
                             RETIRED_InterpretationDiagnosisCodeSequence => { GRP => "4008", ELEM => "0117", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                 RETIRED_ResultsDistributionListSequence => { GRP => "4008", ELEM => "0118", VR => "SQ", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_DistributionName => { GRP => "4008", ELEM => "0119", VR => "PN", VM => "1", VERSION =>  "DICOM/retired"},
                                             RETIRED_DistributionAddress => { GRP => "4008", ELEM => "011A", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_InterpretationID => { GRP => "4008", ELEM => "0200", VR => "SH", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_InterpretationIDIssuer => { GRP => "4008", ELEM => "0202", VR => "LO", VM => "1", VERSION =>  "DICOM/retired"},
                                            RETIRED_InterpretationTypeID => { GRP => "4008", ELEM => "0210", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                          RETIRED_InterpretationStatusID => { GRP => "4008", ELEM => "0212", VR => "CS", VM => "1", VERSION =>  "DICOM/retired"},
                                                     RETIRED_Impressions => { GRP => "4008", ELEM => "0300", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                                                 RETIRED_ResultsComments => { GRP => "4008", ELEM => "4000", VR => "ST", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_CoefficientsSDVN => { GRP => "7FE0", ELEM => "0020", VR => "OW", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_CoefficientsSDHN => { GRP => "7FE0", ELEM => "0030", VR => "OW", VM => "1", VERSION =>  "DICOM/retired"},
                                                RETIRED_CoefficientsSDDN => { GRP => "7FE0", ELEM => "0040", VR => "OW", VM => "1", VERSION =>  "DICOM/retired"},
                                        ACR_NEMA_CommandGroupLengthToEnd => { GRP => "0000", ELEM => "0001", VR => "UL", VM => "1", VERSION =>  "ACR/NEMA2"},
                                         ACR_NEMA_CommandRecognitionCode => { GRP => "0000", ELEM => "0010", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                      ACR_NEMA_Initiator => { GRP => "0000", ELEM => "0200", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                       ACR_NEMA_Receiver => { GRP => "0000", ELEM => "0300", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_FindLocation => { GRP => "0000", ELEM => "0400", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                ACR_NEMA_NumberOfMatches => { GRP => "0000", ELEM => "0850", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2"},
                                         ACR_NEMA_ResponseSequenceNumber => { GRP => "0000", ELEM => "0860", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                 ACR_NEMA_DialogReceiver => { GRP => "0000", ELEM => "4000", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_TerminalType => { GRP => "0000", ELEM => "4010", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_MessageSetID => { GRP => "0000", ELEM => "5010", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_EndMessageSet => { GRP => "0000", ELEM => "5020", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_DisplayFormat => { GRP => "0000", ELEM => "5110", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                 ACR_NEMA_PagePositionID => { GRP => "0000", ELEM => "5120", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_TextFormatID => { GRP => "0000", ELEM => "5130", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_NormalReverse => { GRP => "0000", ELEM => "5140", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_AddGrayScale => { GRP => "0000", ELEM => "5150", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                        ACR_NEMA_Borders => { GRP => "0000", ELEM => "5160", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                         ACR_NEMA_Copies => { GRP => "0000", ELEM => "5170", VR => "IS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                              ACR_NEMA_MagnificationType => { GRP => "0000", ELEM => "5180", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                          ACR_NEMA_Erase => { GRP => "0000", ELEM => "5190", VR => "LO", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                                          ACR_NEMA_Print => { GRP => "0000", ELEM => "51A0", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                       ACR_NEMA_Overlays => { GRP => "0000", ELEM => "51B0", VR => "US", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                    ACR_NEMA_IdentifyingGroupLengthToEnd => { GRP => "0008", ELEM => "0001", VR => "UL", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                ACR_NEMA_RecognitionCode => { GRP => "0008", ELEM => "0010", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                 ACR_NEMA_OldDataSetType => { GRP => "0008", ELEM => "0040", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                 ACR_NEMA_DataSetSubtype => { GRP => "0008", ELEM => "0041", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                      ACR_NEMA_NetworkID => { GRP => "0008", ELEM => "1000", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                            ACR_NEMA_IdentifyingComments => { GRP => "0008", ELEM => "4000", VR => "LT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                    ACR_NEMA_InsurancePlanIdentification => { GRP => "0010", ELEM => "1050", VR => "LT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                          ACR_NEMA_UpperLowerPixelValues => { GRP => "0018", ELEM => "1240", VR => "IS", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                            ACR_NEMA_AcquisitionComments => { GRP => "0018", ELEM => "4000", VR => "LT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_DynamicRange => { GRP => "0018", ELEM => "5030", VR => "DS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                      ACR_NEMA_TotalGain => { GRP => "0018", ELEM => "5040", VR => "DS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_ImagePosition => { GRP => "0020", ELEM => "0030", VR => "DS", VM => "3", VERSION =>  "ACR/NEMA2"},
                                               ACR_NEMA_ImageOrientation => { GRP => "0020", ELEM => "0035", VR => "DS", VM => "6", VERSION =>  "ACR/NEMA2"},
                                                       ACR_NEMA_Location => { GRP => "0020", ELEM => "0050", VR => "DS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                              ACR_NEMA_ImageGeometryType => { GRP => "0020", ELEM => "0070", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_MaskingImage => { GRP => "0020", ELEM => "0080", VR => "LO", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                           ACR_NEMA_AcquisitionsInSeries => { GRP => "0020", ELEM => "1001", VR => "IS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                 ACR_NEMA_ImagesInSeries => { GRP => "0020", ELEM => "1003", VR => "IS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_ImagesInStudy => { GRP => "0020", ELEM => "1005", VR => "IS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                      ACR_NEMA_Reference => { GRP => "0020", ELEM => "1020", VR => "LO", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                              ACR_NEMA_ModifyingDeviceID => { GRP => "0020", ELEM => "3401", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                ACR_NEMA_ModifiedImageID => { GRP => "0020", ELEM => "3402", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                              ACR_NEMA_ModifiedImageDate => { GRP => "0020", ELEM => "3403", VR => "DA", VM => "1", VERSION =>  "ACR/NEMA2"},
                                    ACR_NEMA_ModifyingDeviceManufacturer => { GRP => "0020", ELEM => "3404", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                              ACR_NEMA_ModifiedImageTime => { GRP => "0020", ELEM => "3405", VR => "TM", VM => "1", VERSION =>  "ACR/NEMA2"},
                                       ACR_NEMA_ModifiedImageDescription => { GRP => "0020", ELEM => "3406", VR => "LO", VM => "1", VERSION =>  "ACR/NEMA2"},
                                    ACR_NEMA_OriginalImageIdentification => { GRP => "0020", ELEM => "5000", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                        ACR_NEMA_OriginalImageIdentificationNomenclature => { GRP => "0020", ELEM => "5002", VR => "LO", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                                ACR_NEMA_ImageDimensions => { GRP => "0028", ELEM => "0005", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                    ACR_NEMA_ImageFormat => { GRP => "0028", ELEM => "0040", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                               ACR_NEMA_ManipulatedImage => { GRP => "0028", ELEM => "0050", VR => "LO", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                                ACR_NEMA_CompressionCode => { GRP => "0028", ELEM => "0060", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                        ACR_NEMA_SmallestValidPixelValue => { GRP => "0028", ELEM => "0104", VR => "xs", VM => "1", VERSION =>  "ACR/NEMA2"},
                                         ACR_NEMA_LargestValidPixelValue => { GRP => "0028", ELEM => "0105", VR => "xs", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_ImageLocation => { GRP => "0028", ELEM => "0200", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                      ACR_NEMA_GrayScale => { GRP => "0028", ELEM => "1080", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2"},
                                      ACR_NEMA_GrayLookupTableDescriptor => { GRP => "0028", ELEM => "1100", VR => "xs", VM => "3", VERSION =>  "ACR/NEMA2"},
                                            ACR_NEMA_GrayLookupTableData => { GRP => "0028", ELEM => "1200", VR => "xs", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                      ACR_NEMA_ImagePresentationComments => { GRP => "0028", ELEM => "4000", VR => "LT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                                ACR_NEMA_TextGroupLength => { GRP => "4000", ELEM => "0000", VR => "UL", VM => "1", VERSION =>  "ACR/NEMA2"},
                                                  ACR_NEMA_TextArbitrary => { GRP => "4000", ELEM => "0010", VR => "LT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                                   ACR_NEMA_TextComments => { GRP => "4000", ELEM => "4000", VR => "LT", VM => "1-n", VERSION =>  "ACR/NEMA2"},
                                  ACR_NEMA_2C_CompressionRecognitionCode => { GRP => "0028", ELEM => "005F", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                       ACR_NEMA_2C_CompressionOriginator => { GRP => "0028", ELEM => "0061", VR => "SH", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_CompressionLabel => { GRP => "0028", ELEM => "0062", VR => "SH", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                      ACR_NEMA_2C_CompressionDescription => { GRP => "0028", ELEM => "0063", VR => "SH", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                         ACR_NEMA_2C_CompressionSequence => { GRP => "0028", ELEM => "0065", VR => "CS", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                     ACR_NEMA_2C_CompressionStepPointers => { GRP => "0028", ELEM => "0066", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_RepeatInterval => { GRP => "0028", ELEM => "0068", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                                 ACR_NEMA_2C_BitsGrouped => { GRP => "0028", ELEM => "0069", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_PerimeterTable => { GRP => "0028", ELEM => "0070", VR => "US", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_PerimeterValue => { GRP => "0028", ELEM => "0071", VR => "xs", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                               ACR_NEMA_2C_PredictorRows => { GRP => "0028", ELEM => "0080", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_PredictorColumns => { GRP => "0028", ELEM => "0081", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                          ACR_NEMA_2C_PredictorConstants => { GRP => "0028", ELEM => "0082", VR => "US", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                               ACR_NEMA_2C_BlockedPixels => { GRP => "0028", ELEM => "0090", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                                   ACR_NEMA_2C_BlockRows => { GRP => "0028", ELEM => "0091", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                                ACR_NEMA_2C_BlockColumns => { GRP => "0028", ELEM => "0092", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                                  ACR_NEMA_2C_RowOverlap => { GRP => "0028", ELEM => "0093", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                               ACR_NEMA_2C_ColumnOverlap => { GRP => "0028", ELEM => "0094", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_TransformLabel => { GRP => "0028", ELEM => "0400", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                      ACR_NEMA_2C_TransformVersionNumber => { GRP => "0028", ELEM => "0401", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                      ACR_NEMA_2C_NumberOfTransformSteps => { GRP => "0028", ELEM => "0402", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                    ACR_NEMA_2C_SequenceOfCompressedData => { GRP => "0028", ELEM => "0403", VR => "CS", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                       ACR_NEMA_2C_DetailsOfCoefficients => { GRP => "0028", ELEM => "0404", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                 ACR_NEMA_2C_RowsForNthOrderCoefficients => { GRP => "0028", ELEM => "0410", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                              ACR_NEMA_2C_ColumnsForNthOrderCoefficients => { GRP => "0028", ELEM => "0411", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                           ACR_NEMA_2C_CoefficientCoding => { GRP => "0028", ELEM => "0412", VR => "CS", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                   ACR_NEMA_2C_CoefficientCodingPointers => { GRP => "0028", ELEM => "0413", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                                    ACR_NEMA_2C_DCTLabel => { GRP => "0028", ELEM => "0700", VR => "CS", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                        ACR_NEMA_2C_DataBlockDescription => { GRP => "0028", ELEM => "0701", VR => "CS", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                                   ACR_NEMA_2C_DataBlock => { GRP => "0028", ELEM => "0702", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                   ACR_NEMA_2C_NormalizationFactorFormat => { GRP => "0028", ELEM => "0710", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                        ACR_NEMA_2C_ZonalMapNumberFormat => { GRP => "0028", ELEM => "0720", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_ZonalMapLocation => { GRP => "0028", ELEM => "0721", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_ZonalMapFormat => { GRP => "0028", ELEM => "0722", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                           ACR_NEMA_2C_AdaptiveMapFormat => { GRP => "0028", ELEM => "0730", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_CodeNumberFormat => { GRP => "0028", ELEM => "0740", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                                   ACR_NEMA_2C_CodeLabel => { GRP => "0028", ELEM => "0800", VR => "CS", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_NumberOfTables => { GRP => "0028", ELEM => "0802", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                           ACR_NEMA_2C_CodeTableLocation => { GRP => "0028", ELEM => "0803", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                             ACR_NEMA_2C_BitsForCodeWord => { GRP => "0028", ELEM => "0804", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                           ACR_NEMA_2C_ImageDataLocation => { GRP => "0028", ELEM => "0808", VR => "AT", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                        ACR_NEMA_2C_CodeTableGroupLength => { GRP => "1000", ELEM => "0000", VR => "UL", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                               ACR_NEMA_2C_EscapeTriplet => { GRP => "1000", ELEM => "0010", VR => "US", VM => "3", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_RunLengthTriplet => { GRP => "1000", ELEM => "0011", VR => "US", VM => "3", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_HuffmanTableSize => { GRP => "1000", ELEM => "0012", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                         ACR_NEMA_2C_HuffmanTableTriplet => { GRP => "1000", ELEM => "0013", VR => "US", VM => "3", VERSION =>  "ACR/NEMA2C"},
                                              ACR_NEMA_2C_ShiftTableSize => { GRP => "1000", ELEM => "0014", VR => "US", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                           ACR_NEMA_2C_ShiftTableTriplet => { GRP => "1000", ELEM => "0015", VR => "US", VM => "3", VERSION =>  "ACR/NEMA2C"},
                                         ACR_NEMA_2C_ZonalMapGroupLength => { GRP => "1010", ELEM => "0000", VR => "UL", VM => "1", VERSION =>  "ACR/NEMA2C"},
                                                    ACR_NEMA_2C_ZonalMap => { GRP => "1010", ELEM => "0004", VR => "US", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_CoefficientsSDVN => { GRP => "7FE0", ELEM => "0020", VR => "OW", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_CoefficientsSDHN => { GRP => "7FE0", ELEM => "0030", VR => "OW", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
                                            ACR_NEMA_2C_CoefficientsSDDN => { GRP => "7FE0", ELEM => "0040", VR => "OW", VM => "1-n", VERSION =>  "ACR/NEMA2C"},
);



our %dcmtkDicomDictionary = (

# below here is from dcmtk 3.5.4
                                                    CommandGroupLength => { GRP => "0000", ELEM => "0000", VR => "UL" },
                                                   AffectedSOPClassUID => { GRP => "0000", ELEM => "0002", VR => "UI" },
                                                  RequestedSOPClassUID => { GRP => "0000", ELEM => "0003", VR => "UI" },
                                                          CommandField => { GRP => "0000", ELEM => "0100", VR => "US" },
                                                             MessageID => { GRP => "0000", ELEM => "0110", VR => "US" },
                                             MessageIDBeingRespondedTo => { GRP => "0000", ELEM => "0120", VR => "US" },
                                                       MoveDestination => { GRP => "0000", ELEM => "0600", VR => "AE" },
                                                              Priority => { GRP => "0000", ELEM => "0700", VR => "US" },
                                                           DataSetType => { GRP => "0000", ELEM => "0800", VR => "US" },
                                                                Status => { GRP => "0000", ELEM => "0900", VR => "US" },
                                                      OffendingElement => { GRP => "0000", ELEM => "0901", VR => "AT" },
                                                          ErrorComment => { GRP => "0000", ELEM => "0902", VR => "LO" },
                                                               ErrorID => { GRP => "0000", ELEM => "0903", VR => "US" },
                                                AffectedSOPInstanceUID => { GRP => "0000", ELEM => "1000", VR => "UI" },
                                               RequestedSOPInstanceUID => { GRP => "0000", ELEM => "1001", VR => "UI" },
                                                           EventTypeID => { GRP => "0000", ELEM => "1002", VR => "US" },
                                               AttributeIdentifierList => { GRP => "0000", ELEM => "1005", VR => "AT" },
                                                          ActionTypeID => { GRP => "0000", ELEM => "1008", VR => "US" },
                                        NumberOfRemainingSubOperations => { GRP => "0000", ELEM => "1020", VR => "US" },
                                        NumberOfCompletedSubOperations => { GRP => "0000", ELEM => "1021", VR => "US" },
                                           NumberOfFailedSubOperations => { GRP => "0000", ELEM => "1022", VR => "US" },
                                          NumberOfWarningSubOperations => { GRP => "0000", ELEM => "1023", VR => "US" },
                                  MoveOriginatorApplicationEntityTitle => { GRP => "0000", ELEM => "1030", VR => "AE" },
                                               MoveOriginatorMessageID => { GRP => "0000", ELEM => "1031", VR => "US" },
                                        FileMetaInformationGroupLength => { GRP => "0002", ELEM => "0000", VR => "UL" },
                                            FileMetaInformationVersion => { GRP => "0002", ELEM => "0001", VR => "OB" },
                                               MediaStorageSOPClassUID => { GRP => "0002", ELEM => "0002", VR => "UI" },
                                            MediaStorageSOPInstanceUID => { GRP => "0002", ELEM => "0003", VR => "UI" },
                                                     TransferSyntaxUID => { GRP => "0002", ELEM => "0010", VR => "UI" },
                                                ImplementationClassUID => { GRP => "0002", ELEM => "0012", VR => "UI" },
                                             ImplementationVersionName => { GRP => "0002", ELEM => "0013", VR => "SH" },
                                          SourceApplicationEntityTitle => { GRP => "0002", ELEM => "0016", VR => "AE" },
                                          PrivateInformationCreatorUID => { GRP => "0002", ELEM => "0100", VR => "UI" },
                                                    PrivateInformation => { GRP => "0002", ELEM => "0102", VR => "OB" },
                                                             FileSetID => { GRP => "0004", ELEM => "1130", VR => "CS" },
                                               FileSetDescriptorFileID => { GRP => "0004", ELEM => "1141", VR => "CS" },
                           SpecificCharacterSetOfFileSetDescriptorFile => { GRP => "0004", ELEM => "1142", VR => "CS" },
               OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity => { GRP => "0004", ELEM => "1200", VR => "up" },
                OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity => { GRP => "0004", ELEM => "1202", VR => "up" },
                                                FileSetConsistencyFlag => { GRP => "0004", ELEM => "1212", VR => "US" },
                                               DirectoryRecordSequence => { GRP => "0004", ELEM => "1220", VR => "SQ" },
                                        OffsetOfTheNextDirectoryRecord => { GRP => "0004", ELEM => "1400", VR => "up" },
                                                       RecordInUseFlag => { GRP => "0004", ELEM => "1410", VR => "US" },
                           OffsetOfReferencedLowerLevelDirectoryEntity => { GRP => "0004", ELEM => "1420", VR => "up" },
                                                   DirectoryRecordType => { GRP => "0004", ELEM => "1430", VR => "CS" },
                                                      PrivateRecordUID => { GRP => "0004", ELEM => "1432", VR => "UI" },
                                                      ReferencedFileID => { GRP => "0004", ELEM => "1500", VR => "CS" },
                                           ReferencedSOPClassUIDInFile => { GRP => "0004", ELEM => "1510", VR => "UI" },
                                        ReferencedSOPInstanceUIDInFile => { GRP => "0004", ELEM => "1511", VR => "UI" },
                                     ReferencedTransferSyntaxUIDInFile => { GRP => "0004", ELEM => "1512", VR => "UI" },
                             ReferencedRelatedGeneralSOPClassUIDInFile => { GRP => "0004", ELEM => "151A", VR => "UI" },
                                                  SpecificCharacterSet => { GRP => "0008", ELEM => "0005", VR => "CS" },
                                                             ImageType => { GRP => "0008", ELEM => "0008", VR => "CS" },
                                                  InstanceCreationDate => { GRP => "0008", ELEM => "0012", VR => "DA" },
                                                  InstanceCreationTime => { GRP => "0008", ELEM => "0013", VR => "TM" },
                                                    InstanceCreatorUID => { GRP => "0008", ELEM => "0014", VR => "UI" },
                                                           SOPClassUID => { GRP => "0008", ELEM => "0016", VR => "UI" },
                                                        SOPInstanceUID => { GRP => "0008", ELEM => "0018", VR => "UI" },
                                             RelatedGeneralSOPClassUID => { GRP => "0008", ELEM => "001A", VR => "UI" },
                                        OriginalSpecializedSOPClassUID => { GRP => "0008", ELEM => "001B", VR => "UI" },
                                                             StudyDate => { GRP => "0008", ELEM => "0020", VR => "DA" },
                                                            SeriesDate => { GRP => "0008", ELEM => "0021", VR => "DA" },
                                                       AcquisitionDate => { GRP => "0008", ELEM => "0022", VR => "DA" },
                                                           ContentDate => { GRP => "0008", ELEM => "0023", VR => "DA" },
                                                   AcquisitionDateTime => { GRP => "0008", ELEM => "002A", VR => "DT" },
                                                             StudyTime => { GRP => "0008", ELEM => "0030", VR => "TM" },
                                                            SeriesTime => { GRP => "0008", ELEM => "0031", VR => "TM" },
                                                       AcquisitionTime => { GRP => "0008", ELEM => "0032", VR => "TM" },
                                                           ContentTime => { GRP => "0008", ELEM => "0033", VR => "TM" },
                                                       AccessionNumber => { GRP => "0008", ELEM => "0050", VR => "SH" },
                                                    QueryRetrieveLevel => { GRP => "0008", ELEM => "0052", VR => "CS" },
                                                       RetrieveAETitle => { GRP => "0008", ELEM => "0054", VR => "AE" },
                                                  InstanceAvailability => { GRP => "0008", ELEM => "0056", VR => "CS" },
                                              FailedSOPInstanceUIDList => { GRP => "0008", ELEM => "0058", VR => "UI" },
                                                              Modality => { GRP => "0008", ELEM => "0060", VR => "CS" },
                                                     ModalitiesInStudy => { GRP => "0008", ELEM => "0061", VR => "CS" },
                                                     SOPClassesInStudy => { GRP => "0008", ELEM => "0062", VR => "UI" },
                                                        ConversionType => { GRP => "0008", ELEM => "0064", VR => "CS" },
                                                PresentationIntentType => { GRP => "0008", ELEM => "0068", VR => "CS" },
                                                          Manufacturer => { GRP => "0008", ELEM => "0070", VR => "LO" },
                                                       InstitutionName => { GRP => "0008", ELEM => "0080", VR => "LO" },
                                                    InstitutionAddress => { GRP => "0008", ELEM => "0081", VR => "ST" },
                                               InstitutionCodeSequence => { GRP => "0008", ELEM => "0082", VR => "SQ" },
                                               ReferringPhysiciansName => { GRP => "0008", ELEM => "0090", VR => "PN" },
                                            ReferringPhysiciansAddress => { GRP => "0008", ELEM => "0092", VR => "ST" },
                                   ReferringPhysiciansTelephoneNumbers => { GRP => "0008", ELEM => "0094", VR => "SH" },
                              ReferringPhysicianIdentificationSequence => { GRP => "0008", ELEM => "0096", VR => "SQ" },
                                                             CodeValue => { GRP => "0008", ELEM => "0100", VR => "SH" },
                                                CodingSchemeDesignator => { GRP => "0008", ELEM => "0102", VR => "SH" },
                                                   CodingSchemeVersion => { GRP => "0008", ELEM => "0103", VR => "SH" },
                                                           CodeMeaning => { GRP => "0008", ELEM => "0104", VR => "LO" },
                                                       MappingResource => { GRP => "0008", ELEM => "0105", VR => "CS" },
                                                   ContextGroupVersion => { GRP => "0008", ELEM => "0106", VR => "DT" },
                                              ContextGroupLocalVersion => { GRP => "0008", ELEM => "0107", VR => "DT" },
                                             ContextGroupExtensionFlag => { GRP => "0008", ELEM => "010B", VR => "CS" },
                                                       CodingSchemeUID => { GRP => "0008", ELEM => "010C", VR => "UI" },
                                       ContextGroupExtensionCreatorUID => { GRP => "0008", ELEM => "010D", VR => "UI" },
                                                     ContextIdentifier => { GRP => "0008", ELEM => "010F", VR => "CS" },
                                    CodingSchemeIdentificationSequence => { GRP => "0008", ELEM => "0110", VR => "SQ" },
                                                  CodingSchemeRegistry => { GRP => "0008", ELEM => "0112", VR => "LO" },
                                                CodingSchemeExternalID => { GRP => "0008", ELEM => "0114", VR => "ST" },
                                                      CodingSchemeName => { GRP => "0008", ELEM => "0115", VR => "ST" },
                                   CodingSchemeResponsibleOrganization => { GRP => "0008", ELEM => "0116", VR => "ST" },
                                                 TimezoneOffsetFromUTC => { GRP => "0008", ELEM => "0201", VR => "SH" },
                                                           StationName => { GRP => "0008", ELEM => "1010", VR => "SH" },
                                                      StudyDescription => { GRP => "0008", ELEM => "1030", VR => "LO" },
                                                 ProcedureCodeSequence => { GRP => "0008", ELEM => "1032", VR => "SQ" },
                                                     SeriesDescription => { GRP => "0008", ELEM => "103E", VR => "LO" },
                                           InstitutionalDepartmentName => { GRP => "0008", ELEM => "1040", VR => "LO" },
                                                    PhysiciansOfRecord => { GRP => "0008", ELEM => "1048", VR => "PN" },
                              PhysiciansOfRecordIdentificationSequence => { GRP => "0008", ELEM => "1049", VR => "SQ" },
                                              PerformingPhysiciansName => { GRP => "0008", ELEM => "1050", VR => "PN" },
                             PerformingPhysicianIdentificationSequence => { GRP => "0008", ELEM => "1052", VR => "SQ" },
                                          NameOfPhysiciansReadingStudy => { GRP => "0008", ELEM => "1060", VR => "PN" },
                          PhysiciansReadingStudyIdentificationSequence => { GRP => "0008", ELEM => "1062", VR => "SQ" },
                                                         OperatorsName => { GRP => "0008", ELEM => "1070", VR => "PN" },
                                        OperatorIdentificationSequence => { GRP => "0008", ELEM => "1072", VR => "SQ" },
                                         AdmittingDiagnosesDescription => { GRP => "0008", ELEM => "1080", VR => "LO" },
                                        AdmittingDiagnosesCodeSequence => { GRP => "0008", ELEM => "1084", VR => "SQ" },
                                                ManufacturersModelName => { GRP => "0008", ELEM => "1090", VR => "LO" },
                                               ReferencedStudySequence => { GRP => "0008", ELEM => "1110", VR => "SQ" },
                              ReferencedPerformedProcedureStepSequence => { GRP => "0008", ELEM => "1111", VR => "SQ" },
                                              ReferencedSeriesSequence => { GRP => "0008", ELEM => "1115", VR => "SQ" },
                                             ReferencedPatientSequence => { GRP => "0008", ELEM => "1120", VR => "SQ" },
                                               ReferencedVisitSequence => { GRP => "0008", ELEM => "1125", VR => "SQ" },
                                            ReferencedWaveformSequence => { GRP => "0008", ELEM => "113A", VR => "SQ" },
                                               ReferencedImageSequence => { GRP => "0008", ELEM => "1140", VR => "SQ" },
                                            ReferencedInstanceSequence => { GRP => "0008", ELEM => "114A", VR => "SQ" },
                       ReferencedRealWorldValueMappingInstanceSequence => { GRP => "0008", ELEM => "114B", VR => "SQ" },
                                                 ReferencedSOPClassUID => { GRP => "0008", ELEM => "1150", VR => "UI" },
                                              ReferencedSOPInstanceUID => { GRP => "0008", ELEM => "1155", VR => "UI" },
                                                   SOPClassesSupported => { GRP => "0008", ELEM => "115A", VR => "UI" },
                                                 ReferencedFrameNumber => { GRP => "0008", ELEM => "1160", VR => "IS" },
                                                        TransactionUID => { GRP => "0008", ELEM => "1195", VR => "UI" },
                                                         FailureReason => { GRP => "0008", ELEM => "1197", VR => "US" },
                                                     FailedSOPSequence => { GRP => "0008", ELEM => "1198", VR => "SQ" },
                                                 ReferencedSOPSequence => { GRP => "0008", ELEM => "1199", VR => "SQ" },
                     StudiesContainingOtherReferencedInstancesSequence => { GRP => "0008", ELEM => "1200", VR => "SQ" },
                                                 RelatedSeriesSequence => { GRP => "0008", ELEM => "1250", VR => "SQ" },
                                                 DerivationDescription => { GRP => "0008", ELEM => "2111", VR => "ST" },
                                                   SourceImageSequence => { GRP => "0008", ELEM => "2112", VR => "SQ" },
                                                             StageName => { GRP => "0008", ELEM => "2120", VR => "SH" },
                                                           StageNumber => { GRP => "0008", ELEM => "2122", VR => "IS" },
                                                        NumberOfStages => { GRP => "0008", ELEM => "2124", VR => "IS" },
                                                              ViewName => { GRP => "0008", ELEM => "2127", VR => "SH" },
                                                            ViewNumber => { GRP => "0008", ELEM => "2128", VR => "IS" },
                                                   NumberOfEventTimers => { GRP => "0008", ELEM => "2129", VR => "IS" },
                                                  NumberOfViewsInStage => { GRP => "0008", ELEM => "212A", VR => "IS" },
                                                     EventElapsedTimes => { GRP => "0008", ELEM => "2130", VR => "DS" },
                                                       EventTimerNames => { GRP => "0008", ELEM => "2132", VR => "LO" },
                                                             StartTrim => { GRP => "0008", ELEM => "2142", VR => "IS" },
                                                              StopTrim => { GRP => "0008", ELEM => "2143", VR => "IS" },
                                           RecommendedDisplayFrameRate => { GRP => "0008", ELEM => "2144", VR => "IS" },
                                                AnatomicRegionSequence => { GRP => "0008", ELEM => "2218", VR => "SQ" },
                                        AnatomicRegionModifierSequence => { GRP => "0008", ELEM => "2220", VR => "SQ" },
                                      PrimaryAnatomicStructureSequence => { GRP => "0008", ELEM => "2228", VR => "SQ" },
                                AnatomicStructureSpaceOrRegionSequence => { GRP => "0008", ELEM => "2229", VR => "SQ" },
                              PrimaryAnatomicStructureModifierSequence => { GRP => "0008", ELEM => "2230", VR => "SQ" },
                                       AlternateRepresentationSequence => { GRP => "0008", ELEM => "3001", VR => "SQ" },
                                                   IrradiationEventUID => { GRP => "0008", ELEM => "3010", VR => "UI" },
                                                             FrameType => { GRP => "0008", ELEM => "9007", VR => "CS" },
                                       ReferencedImageEvidenceSequence => { GRP => "0008", ELEM => "9092", VR => "SQ" },
                                             ReferencedRawDataSequence => { GRP => "0008", ELEM => "9121", VR => "SQ" },
                                                     CreatorVersionUID => { GRP => "0008", ELEM => "9123", VR => "UI" },
                                               DerivationImageSequence => { GRP => "0008", ELEM => "9124", VR => "SQ" },
                                           SourceImageEvidenceSequence => { GRP => "0008", ELEM => "9154", VR => "SQ" },
                                                     PixelPresentation => { GRP => "0008", ELEM => "9205", VR => "CS" },
                                                  VolumetricProperties => { GRP => "0008", ELEM => "9206", VR => "CS" },
                                       VolumeBasedCalculationTechnique => { GRP => "0008", ELEM => "9207", VR => "CS" },
                                                 ComplexImageComponent => { GRP => "0008", ELEM => "9208", VR => "CS" },
                                                   AcquisitionContrast => { GRP => "0008", ELEM => "9209", VR => "CS" },
                                                DerivationCodeSequence => { GRP => "0008", ELEM => "9215", VR => "SQ" },
                          ReferencedGrayscalePresentationStateSequence => { GRP => "0008", ELEM => "9237", VR => "SQ" },
                                          ReferencedOtherPlaneSequence => { GRP => "0008", ELEM => "9410", VR => "SQ" },
                                                  FrameDisplaySequence => { GRP => "0008", ELEM => "9458", VR => "SQ" },
                                    RecommendedDisplayFrameRateInFloat => { GRP => "0008", ELEM => "9459", VR => "FL" },
                                                    SkipFrameRangeFlag => { GRP => "0008", ELEM => "9460", VR => "CS" },
                                                          PatientsName => { GRP => "0010", ELEM => "0010", VR => "PN" },
                                                             PatientID => { GRP => "0010", ELEM => "0020", VR => "LO" },
                                                     IssuerOfPatientID => { GRP => "0010", ELEM => "0021", VR => "LO" },
                                                       TypeOfPatientID => { GRP => "0010", ELEM => "0022", VR => "CS" },
                                                     PatientsBirthDate => { GRP => "0010", ELEM => "0030", VR => "DA" },
                                                     PatientsBirthTime => { GRP => "0010", ELEM => "0032", VR => "TM" },
                                                           PatientsSex => { GRP => "0010", ELEM => "0040", VR => "CS" },
                                     PatientsInsurancePlanCodeSequence => { GRP => "0010", ELEM => "0050", VR => "SQ" },
                                   PatientsPrimaryLanguageCodeSequence => { GRP => "0010", ELEM => "0101", VR => "SQ" },
                           PatientsPrimaryLanguageCodeModifierSequence => { GRP => "0010", ELEM => "0102", VR => "SQ" },
                                                       OtherPatientIDs => { GRP => "0010", ELEM => "1000", VR => "LO" },
                                                     OtherPatientNames => { GRP => "0010", ELEM => "1001", VR => "PN" },
                                               OtherPatientIDsSequence => { GRP => "0010", ELEM => "1002", VR => "SQ" },
                                                     PatientsBirthName => { GRP => "0010", ELEM => "1005", VR => "PN" },
                                                           PatientsAge => { GRP => "0010", ELEM => "1010", VR => "AS" },
                                                          PatientsSize => { GRP => "0010", ELEM => "1020", VR => "DS" },
                                                        PatientsWeight => { GRP => "0010", ELEM => "1030", VR => "DS" },
                                                       PatientsAddress => { GRP => "0010", ELEM => "1040", VR => "LO" },
                                              PatientsMothersBirthName => { GRP => "0010", ELEM => "1060", VR => "PN" },
                                                          MilitaryRank => { GRP => "0010", ELEM => "1080", VR => "LO" },
                                                       BranchOfService => { GRP => "0010", ELEM => "1081", VR => "LO" },
                                                  MedicalRecordLocator => { GRP => "0010", ELEM => "1090", VR => "LO" },
                                                         MedicalAlerts => { GRP => "0010", ELEM => "2000", VR => "LO" },
                                                             Allergies => { GRP => "0010", ELEM => "2110", VR => "LO" },
                                                    CountryOfResidence => { GRP => "0010", ELEM => "2150", VR => "LO" },
                                                     RegionOfResidence => { GRP => "0010", ELEM => "2152", VR => "LO" },
                                              PatientsTelephoneNumbers => { GRP => "0010", ELEM => "2154", VR => "SH" },
                                                           EthnicGroup => { GRP => "0010", ELEM => "2160", VR => "SH" },
                                                            Occupation => { GRP => "0010", ELEM => "2180", VR => "SH" },
                                                         SmokingStatus => { GRP => "0010", ELEM => "21A0", VR => "CS" },
                                              AdditionalPatientHistory => { GRP => "0010", ELEM => "21B0", VR => "LT" },
                                                       PregnancyStatus => { GRP => "0010", ELEM => "21C0", VR => "US" },
                                                     LastMenstrualDate => { GRP => "0010", ELEM => "21D0", VR => "DA" },
                                           PatientsReligiousPreference => { GRP => "0010", ELEM => "21F0", VR => "LO" },
                                             PatientSpeciesDescription => { GRP => "0010", ELEM => "2201", VR => "LO" },
                                            PatientSpeciesCodeSequence => { GRP => "0010", ELEM => "2202", VR => "SQ" },
                                                   PatientsSexNeutered => { GRP => "0010", ELEM => "2203", VR => "CS" },
                                               PatientBreedDescription => { GRP => "0010", ELEM => "2292", VR => "LO" },
                                              PatientBreedCodeSequence => { GRP => "0010", ELEM => "2293", VR => "SQ" },
                                             BreedRegistrationSequence => { GRP => "0010", ELEM => "2294", VR => "SQ" },
                                               BreedRegistrationNumber => { GRP => "0010", ELEM => "2295", VR => "LO" },
                                             BreedRegistryCodeSequence => { GRP => "0010", ELEM => "2296", VR => "SQ" },
                                                     ResponsiblePerson => { GRP => "0010", ELEM => "2297", VR => "PN" },
                                                 ResponsiblePersonRole => { GRP => "0010", ELEM => "2298", VR => "CS" },
                                               ResponsibleOrganization => { GRP => "0010", ELEM => "2299", VR => "LO" },
                                                       PatientComments => { GRP => "0010", ELEM => "4000", VR => "LT" },
                                                 ExaminedBodyThickness => { GRP => "0010", ELEM => "9431", VR => "FL" },
                                              ClinicalTrialSponsorName => { GRP => "0012", ELEM => "0010", VR => "LO" },
                                               ClinicalTrialProtocolID => { GRP => "0012", ELEM => "0020", VR => "LO" },
                                             ClinicalTrialProtocolName => { GRP => "0012", ELEM => "0021", VR => "LO" },
                                                   ClinicalTrialSiteID => { GRP => "0012", ELEM => "0030", VR => "LO" },
                                                 ClinicalTrialSiteName => { GRP => "0012", ELEM => "0031", VR => "LO" },
                                                ClinicalTrialSubjectID => { GRP => "0012", ELEM => "0040", VR => "LO" },
                                         ClinicalTrialSubjectReadingID => { GRP => "0012", ELEM => "0042", VR => "LO" },
                                              ClinicalTrialTimePointID => { GRP => "0012", ELEM => "0050", VR => "LO" },
                                     ClinicalTrialTimePointDescription => { GRP => "0012", ELEM => "0051", VR => "ST" },
                                   ClinicalTrialCoordinatingCenterName => { GRP => "0012", ELEM => "0060", VR => "LO" },
                                                PatientIdentityRemoved => { GRP => "0012", ELEM => "0062", VR => "CS" },
                                                DeIdentificationMethod => { GRP => "0012", ELEM => "0063", VR => "LO" },
                                    DeIdentificationMethodCodeSequence => { GRP => "0012", ELEM => "0064", VR => "SQ" },
                                                 ClinicalTrialSeriesID => { GRP => "0012", ELEM => "0071", VR => "LO" },
                                        ClinicalTrialSeriesDescription => { GRP => "0012", ELEM => "0072", VR => "LO" },
                                                    ContrastBolusAgent => { GRP => "0018", ELEM => "0010", VR => "LO" },
                                            ContrastBolusAgentSequence => { GRP => "0018", ELEM => "0012", VR => "SQ" },
                              ContrastBolusAdministrationRouteSequence => { GRP => "0018", ELEM => "0014", VR => "SQ" },
                                                      BodyPartExamined => { GRP => "0018", ELEM => "0015", VR => "CS" },
                                                      ScanningSequence => { GRP => "0018", ELEM => "0020", VR => "CS" },
                                                       SequenceVariant => { GRP => "0018", ELEM => "0021", VR => "CS" },
                                                           ScanOptions => { GRP => "0018", ELEM => "0022", VR => "CS" },
                                                     MRAcquisitionType => { GRP => "0018", ELEM => "0023", VR => "CS" },
                                                          SequenceName => { GRP => "0018", ELEM => "0024", VR => "SH" },
                                                             AngioFlag => { GRP => "0018", ELEM => "0025", VR => "CS" },
                                   InterventionDrugInformationSequence => { GRP => "0018", ELEM => "0026", VR => "SQ" },
                                              InterventionDrugStopTime => { GRP => "0018", ELEM => "0027", VR => "TM" },
                                                  InterventionDrugDose => { GRP => "0018", ELEM => "0028", VR => "DS" },
                                              InterventionDrugSequence => { GRP => "0018", ELEM => "0029", VR => "SQ" },
                                                AdditionalDrugSequence => { GRP => "0018", ELEM => "002A", VR => "SQ" },
                                                   Radiopharmaceutical => { GRP => "0018", ELEM => "0031", VR => "LO" },
                                                  InterventionDrugName => { GRP => "0018", ELEM => "0034", VR => "LO" },
                                             InterventionDrugStartTime => { GRP => "0018", ELEM => "0035", VR => "TM" },
                                                  InterventionSequence => { GRP => "0018", ELEM => "0036", VR => "SQ" },
                                                    InterventionStatus => { GRP => "0018", ELEM => "0038", VR => "CS" },
                                               InterventionDescription => { GRP => "0018", ELEM => "003A", VR => "ST" },
                                                              CineRate => { GRP => "0018", ELEM => "0040", VR => "IS" },
                                                        SliceThickness => { GRP => "0018", ELEM => "0050", VR => "DS" },
                                                                   KVP => { GRP => "0018", ELEM => "0060", VR => "DS" },
                                                     CountsAccumulated => { GRP => "0018", ELEM => "0070", VR => "IS" },
                                       AcquisitionTerminationCondition => { GRP => "0018", ELEM => "0071", VR => "CS" },
                                                     EffectiveDuration => { GRP => "0018", ELEM => "0072", VR => "DS" },
                                             AcquisitionStartCondition => { GRP => "0018", ELEM => "0073", VR => "CS" },
                                         AcquisitionStartConditionData => { GRP => "0018", ELEM => "0074", VR => "IS" },
                                   AcquisitionTerminationConditionData => { GRP => "0018", ELEM => "0075", VR => "IS" },
                                                        RepetitionTime => { GRP => "0018", ELEM => "0080", VR => "DS" },
                                                              EchoTime => { GRP => "0018", ELEM => "0081", VR => "DS" },
                                                         InversionTime => { GRP => "0018", ELEM => "0082", VR => "DS" },
                                                      NumberOfAverages => { GRP => "0018", ELEM => "0083", VR => "DS" },
                                                      ImagingFrequency => { GRP => "0018", ELEM => "0084", VR => "DS" },
                                                         ImagedNucleus => { GRP => "0018", ELEM => "0085", VR => "SH" },
                                                           EchoNumbers => { GRP => "0018", ELEM => "0086", VR => "IS" },
                                                 MagneticFieldStrength => { GRP => "0018", ELEM => "0087", VR => "DS" },
                                                  SpacingBetweenSlices => { GRP => "0018", ELEM => "0088", VR => "DS" },
                                            NumberOfPhaseEncodingSteps => { GRP => "0018", ELEM => "0089", VR => "IS" },
                                                DataCollectionDiameter => { GRP => "0018", ELEM => "0090", VR => "DS" },
                                                       EchoTrainLength => { GRP => "0018", ELEM => "0091", VR => "IS" },
                                                       PercentSampling => { GRP => "0018", ELEM => "0093", VR => "DS" },
                                               PercentPhaseFieldOfView => { GRP => "0018", ELEM => "0094", VR => "DS" },
                                                        PixelBandwidth => { GRP => "0018", ELEM => "0095", VR => "DS" },
                                                    DeviceSerialNumber => { GRP => "0018", ELEM => "1000", VR => "LO" },
                                                             DeviceUID => { GRP => "0018", ELEM => "1002", VR => "UI" },
                                                              DeviceID => { GRP => "0018", ELEM => "1003", VR => "LO" },
                                                               PlateID => { GRP => "0018", ELEM => "1004", VR => "LO" },
                                                           GeneratorID => { GRP => "0018", ELEM => "1005", VR => "LO" },
                                                                GridID => { GRP => "0018", ELEM => "1006", VR => "LO" },
                                                            CassetteID => { GRP => "0018", ELEM => "1007", VR => "LO" },
                                                              GantryID => { GRP => "0018", ELEM => "1008", VR => "LO" },
                                              SecondaryCaptureDeviceID => { GRP => "0018", ELEM => "1010", VR => "LO" },
                                                DateOfSecondaryCapture => { GRP => "0018", ELEM => "1012", VR => "DA" },
                                                TimeOfSecondaryCapture => { GRP => "0018", ELEM => "1014", VR => "TM" },
                                   SecondaryCaptureDeviceManufacturers => { GRP => "0018", ELEM => "1016", VR => "LO" },
                          SecondaryCaptureDeviceManufacturersModelName => { GRP => "0018", ELEM => "1018", VR => "LO" },
                                SecondaryCaptureDeviceSoftwareVersions => { GRP => "0018", ELEM => "1019", VR => "LO" },
                                                      SoftwareVersions => { GRP => "0018", ELEM => "1020", VR => "LO" },
                                              VideoImageFormatAcquired => { GRP => "0018", ELEM => "1022", VR => "SH" },
                                            DigitalImageFormatAcquired => { GRP => "0018", ELEM => "1023", VR => "LO" },
                                                          ProtocolName => { GRP => "0018", ELEM => "1030", VR => "LO" },
                                                    ContrastBolusRoute => { GRP => "0018", ELEM => "1040", VR => "LO" },
                                                   ContrastBolusVolume => { GRP => "0018", ELEM => "1041", VR => "DS" },
                                                ContrastBolusStartTime => { GRP => "0018", ELEM => "1042", VR => "TM" },
                                                 ContrastBolusStopTime => { GRP => "0018", ELEM => "1043", VR => "TM" },
                                                ContrastBolusTotalDose => { GRP => "0018", ELEM => "1044", VR => "DS" },
                                                         SyringeCounts => { GRP => "0018", ELEM => "1045", VR => "IS" },
                                                      ContrastFlowRate => { GRP => "0018", ELEM => "1046", VR => "DS" },
                                                  ContrastFlowDuration => { GRP => "0018", ELEM => "1047", VR => "DS" },
                                               ContrastBolusIngredient => { GRP => "0018", ELEM => "1048", VR => "CS" },
                                  ContrastBolusIngredientConcentration => { GRP => "0018", ELEM => "1049", VR => "DS" },
                                                     SpatialResolution => { GRP => "0018", ELEM => "1050", VR => "DS" },
                                                           TriggerTime => { GRP => "0018", ELEM => "1060", VR => "DS" },
                                                   TriggerSourceOrType => { GRP => "0018", ELEM => "1061", VR => "LO" },
                                                       NominalInterval => { GRP => "0018", ELEM => "1062", VR => "IS" },
                                                             FrameTime => { GRP => "0018", ELEM => "1063", VR => "DS" },
                                                    CardiacFramingType => { GRP => "0018", ELEM => "1064", VR => "LO" },
                                                       FrameTimeVector => { GRP => "0018", ELEM => "1065", VR => "DS" },
                                                            FrameDelay => { GRP => "0018", ELEM => "1066", VR => "DS" },
                                                     ImageTriggerDelay => { GRP => "0018", ELEM => "1067", VR => "DS" },
                                              MultiplexGroupTimeOffset => { GRP => "0018", ELEM => "1068", VR => "DS" },
                                                     TriggerTimeOffset => { GRP => "0018", ELEM => "1069", VR => "DS" },
                                                SynchronizationTrigger => { GRP => "0018", ELEM => "106A", VR => "CS" },
                                                SynchronizationChannel => { GRP => "0018", ELEM => "106C", VR => "US" },
                                                 TriggerSamplePosition => { GRP => "0018", ELEM => "106E", VR => "UL" },
                                              RadiopharmaceuticalRoute => { GRP => "0018", ELEM => "1070", VR => "LO" },
                                             RadiopharmaceuticalVolume => { GRP => "0018", ELEM => "1071", VR => "DS" },
                                          RadiopharmaceuticalStartTime => { GRP => "0018", ELEM => "1072", VR => "TM" },
                                           RadiopharmaceuticalStopTime => { GRP => "0018", ELEM => "1073", VR => "TM" },
                                                 RadionuclideTotalDose => { GRP => "0018", ELEM => "1074", VR => "DS" },
                                                  RadionuclideHalfLife => { GRP => "0018", ELEM => "1075", VR => "DS" },
                                          RadionuclidePositronFraction => { GRP => "0018", ELEM => "1076", VR => "DS" },
                                   RadiopharmaceuticalSpecificActivity => { GRP => "0018", ELEM => "1077", VR => "DS" },
                                      RadiopharmaceuticalStartDateTime => { GRP => "0018", ELEM => "1078", VR => "DT" },
                                       RadiopharmaceuticalStopDateTime => { GRP => "0018", ELEM => "1079", VR => "DT" },
                                                     BeatRejectionFlag => { GRP => "0018", ELEM => "1080", VR => "CS" },
                                                            LowRRValue => { GRP => "0018", ELEM => "1081", VR => "IS" },
                                                           HighRRValue => { GRP => "0018", ELEM => "1082", VR => "IS" },
                                                     IntervalsAcquired => { GRP => "0018", ELEM => "1083", VR => "IS" },
                                                     IntervalsRejected => { GRP => "0018", ELEM => "1084", VR => "IS" },
                                                          PVCRejection => { GRP => "0018", ELEM => "1085", VR => "LO" },
                                                             SkipBeats => { GRP => "0018", ELEM => "1086", VR => "IS" },
                                                             HeartRate => { GRP => "0018", ELEM => "1088", VR => "IS" },
                                                 CardiacNumberOfImages => { GRP => "0018", ELEM => "1090", VR => "IS" },
                                                         TriggerWindow => { GRP => "0018", ELEM => "1094", VR => "IS" },
                                                ReconstructionDiameter => { GRP => "0018", ELEM => "1100", VR => "DS" },
                                              DistanceSourceToDetector => { GRP => "0018", ELEM => "1110", VR => "DS" },
                                               DistanceSourceToPatient => { GRP => "0018", ELEM => "1111", VR => "DS" },
                              EstimatedRadiographicMagnificationFactor => { GRP => "0018", ELEM => "1114", VR => "DS" },
                                                    GantryDetectorTilt => { GRP => "0018", ELEM => "1120", VR => "DS" },
                                                    GantryDetectorSlew => { GRP => "0018", ELEM => "1121", VR => "DS" },
                                                           TableHeight => { GRP => "0018", ELEM => "1130", VR => "DS" },
                                                         TableTraverse => { GRP => "0018", ELEM => "1131", VR => "DS" },
                                                           TableMotion => { GRP => "0018", ELEM => "1134", VR => "CS" },
                                                TableVerticalIncrement => { GRP => "0018", ELEM => "1135", VR => "DS" },
                                                 TableLateralIncrement => { GRP => "0018", ELEM => "1136", VR => "DS" },
                                            TableLongitudinalIncrement => { GRP => "0018", ELEM => "1137", VR => "DS" },
                                                            TableAngle => { GRP => "0018", ELEM => "1138", VR => "DS" },
                                                             TableType => { GRP => "0018", ELEM => "113A", VR => "CS" },
                                                     RotationDirection => { GRP => "0018", ELEM => "1140", VR => "CS" },
                                                        RadialPosition => { GRP => "0018", ELEM => "1142", VR => "DS" },
                                                               ScanArc => { GRP => "0018", ELEM => "1143", VR => "DS" },
                                                           AngularStep => { GRP => "0018", ELEM => "1144", VR => "DS" },
                                                CenterOfRotationOffset => { GRP => "0018", ELEM => "1145", VR => "DS" },
                                                      FieldOfViewShape => { GRP => "0018", ELEM => "1147", VR => "CS" },
                                                 FieldOfViewDimensions => { GRP => "0018", ELEM => "1149", VR => "IS" },
                                                          ExposureTime => { GRP => "0018", ELEM => "1150", VR => "IS" },
                                                       XRayTubeCurrent => { GRP => "0018", ELEM => "1151", VR => "IS" },
                                                              Exposure => { GRP => "0018", ELEM => "1152", VR => "IS" },
                                                     ExposureInMicroAs => { GRP => "0018", ELEM => "1153", VR => "IS" },
                                                     AveragePulseWidth => { GRP => "0018", ELEM => "1154", VR => "DS" },
                                                      RadiationSetting => { GRP => "0018", ELEM => "1155", VR => "CS" },
                                                     RectificationType => { GRP => "0018", ELEM => "1156", VR => "CS" },
                                                         RadiationMode => { GRP => "0018", ELEM => "115A", VR => "CS" },
                                    ImageAndFluoroscopyAreaDoseProduct => { GRP => "0018", ELEM => "115E", VR => "DS" },
                                                            FilterType => { GRP => "0018", ELEM => "1160", VR => "SH" },
                                                         TypeOfFilters => { GRP => "0018", ELEM => "1161", VR => "LO" },
                                                       IntensifierSize => { GRP => "0018", ELEM => "1162", VR => "DS" },
                                                    ImagerPixelSpacing => { GRP => "0018", ELEM => "1164", VR => "DS" },
                                                                  Grid => { GRP => "0018", ELEM => "1166", VR => "CS" },
                                                        GeneratorPower => { GRP => "0018", ELEM => "1170", VR => "IS" },
                                                    CollimatorGridName => { GRP => "0018", ELEM => "1180", VR => "SH" },
                                                        CollimatorType => { GRP => "0018", ELEM => "1181", VR => "CS" },
                                                         FocalDistance => { GRP => "0018", ELEM => "1182", VR => "IS" },
                                                          XFocusCenter => { GRP => "0018", ELEM => "1183", VR => "DS" },
                                                          YFocusCenter => { GRP => "0018", ELEM => "1184", VR => "DS" },
                                                            FocalSpots => { GRP => "0018", ELEM => "1190", VR => "DS" },
                                                   AnodeTargetMaterial => { GRP => "0018", ELEM => "1191", VR => "CS" },
                                                     BodyPartThickness => { GRP => "0018", ELEM => "11A0", VR => "DS" },
                                                      CompressionForce => { GRP => "0018", ELEM => "11A2", VR => "DS" },
                                                 DateOfLastCalibration => { GRP => "0018", ELEM => "1200", VR => "DA" },
                                                 TimeOfLastCalibration => { GRP => "0018", ELEM => "1201", VR => "TM" },
                                                     ConvolutionKernel => { GRP => "0018", ELEM => "1210", VR => "SH" },
                                                   ActualFrameDuration => { GRP => "0018", ELEM => "1242", VR => "IS" },
                                                             CountRate => { GRP => "0018", ELEM => "1243", VR => "IS" },
                                           PreferredPlaybackSequencing => { GRP => "0018", ELEM => "1244", VR => "US" },
                                                       ReceiveCoilName => { GRP => "0018", ELEM => "1250", VR => "SH" },
                                                      TransmitCoilName => { GRP => "0018", ELEM => "1251", VR => "SH" },
                                                             PlateType => { GRP => "0018", ELEM => "1260", VR => "SH" },
                                                          PhosphorType => { GRP => "0018", ELEM => "1261", VR => "LO" },
                                                          ScanVelocity => { GRP => "0018", ELEM => "1300", VR => "DS" },
                                                    WholeBodyTechnique => { GRP => "0018", ELEM => "1301", VR => "CS" },
                                                            ScanLength => { GRP => "0018", ELEM => "1302", VR => "IS" },
                                                     AcquisitionMatrix => { GRP => "0018", ELEM => "1310", VR => "US" },
                                         InPlanePhaseEncodingDirection => { GRP => "0018", ELEM => "1312", VR => "CS" },
                                                             FlipAngle => { GRP => "0018", ELEM => "1314", VR => "DS" },
                                                 VariableFlipAngleFlag => { GRP => "0018", ELEM => "1315", VR => "CS" },
                                                                   SAR => { GRP => "0018", ELEM => "1316", VR => "DS" },
                                                                  DBDt => { GRP => "0018", ELEM => "1318", VR => "DS" },
                                AcquisitionDeviceProcessingDescription => { GRP => "0018", ELEM => "1400", VR => "LO" },
                                       AcquisitionDeviceProcessingCode => { GRP => "0018", ELEM => "1401", VR => "LO" },
                                                   CassetteOrientation => { GRP => "0018", ELEM => "1402", VR => "CS" },
                                                          CassetteSize => { GRP => "0018", ELEM => "1403", VR => "CS" },
                                                      ExposuresOnPlate => { GRP => "0018", ELEM => "1404", VR => "US" },
                                                  RelativeXRayExposure => { GRP => "0018", ELEM => "1405", VR => "IS" },
                                                      ColumnAngulation => { GRP => "0018", ELEM => "1450", VR => "DS" },
                                                       TomoLayerHeight => { GRP => "0018", ELEM => "1460", VR => "DS" },
                                                             TomoAngle => { GRP => "0018", ELEM => "1470", VR => "DS" },
                                                              TomoTime => { GRP => "0018", ELEM => "1480", VR => "DS" },
                                                              TomoType => { GRP => "0018", ELEM => "1490", VR => "CS" },
                                                             TomoClass => { GRP => "0018", ELEM => "1491", VR => "CS" },
                                     NumberOfTomosynthesisSourceImages => { GRP => "0018", ELEM => "1495", VR => "IS" },
                                                      PositionerMotion => { GRP => "0018", ELEM => "1500", VR => "CS" },
                                                        PositionerType => { GRP => "0018", ELEM => "1508", VR => "CS" },
                                                PositionerPrimaryAngle => { GRP => "0018", ELEM => "1510", VR => "DS" },
                                              PositionerSecondaryAngle => { GRP => "0018", ELEM => "1511", VR => "DS" },
                                       PositionerPrimaryAngleIncrement => { GRP => "0018", ELEM => "1520", VR => "DS" },
                                     PositionerSecondaryAngleIncrement => { GRP => "0018", ELEM => "1521", VR => "DS" },
                                                  DetectorPrimaryAngle => { GRP => "0018", ELEM => "1530", VR => "DS" },
                                                DetectorSecondaryAngle => { GRP => "0018", ELEM => "1531", VR => "DS" },
                                                          ShutterShape => { GRP => "0018", ELEM => "1600", VR => "CS" },
                                               ShutterLeftVerticalEdge => { GRP => "0018", ELEM => "1602", VR => "IS" },
                                              ShutterRightVerticalEdge => { GRP => "0018", ELEM => "1604", VR => "IS" },
                                            ShutterUpperHorizontalEdge => { GRP => "0018", ELEM => "1606", VR => "IS" },
                                            ShutterLowerHorizontalEdge => { GRP => "0018", ELEM => "1608", VR => "IS" },
                                               CenterOfCircularShutter => { GRP => "0018", ELEM => "1610", VR => "IS" },
                                               RadiusOfCircularShutter => { GRP => "0018", ELEM => "1612", VR => "IS" },
                                         VerticesOfThePolygonalShutter => { GRP => "0018", ELEM => "1620", VR => "IS" },
                                              ShutterPresentationValue => { GRP => "0018", ELEM => "1622", VR => "US" },
                                                   ShutterOverlayGroup => { GRP => "0018", ELEM => "1623", VR => "US" },
                                   ShutterPresentationColorCIELabValue => { GRP => "0018", ELEM => "1624", VR => "US" },
                                                       CollimatorShape => { GRP => "0018", ELEM => "1700", VR => "CS" },
                                            CollimatorLeftVerticalEdge => { GRP => "0018", ELEM => "1702", VR => "IS" },
                                           CollimatorRightVerticalEdge => { GRP => "0018", ELEM => "1704", VR => "IS" },
                                         CollimatorUpperHorizontalEdge => { GRP => "0018", ELEM => "1706", VR => "IS" },
                                         CollimatorLowerHorizontalEdge => { GRP => "0018", ELEM => "1708", VR => "IS" },
                                            CenterOfCircularCollimator => { GRP => "0018", ELEM => "1710", VR => "IS" },
                                            RadiusOfCircularCollimator => { GRP => "0018", ELEM => "1712", VR => "IS" },
                                      VerticesOfThePolygonalCollimator => { GRP => "0018", ELEM => "1720", VR => "IS" },
                                           AcquisitionTimeSynchronized => { GRP => "0018", ELEM => "1800", VR => "CS" },
                                                            TimeSource => { GRP => "0018", ELEM => "1801", VR => "SH" },
                                              TimeDistributionProtocol => { GRP => "0018", ELEM => "1802", VR => "CS" },
                                                      NTPSourceAddress => { GRP => "0018", ELEM => "1803", VR => "LO" },
                                                      PageNumberVector => { GRP => "0018", ELEM => "2001", VR => "IS" },
                                                      FrameLabelVector => { GRP => "0018", ELEM => "2002", VR => "SH" },
                                               FramePrimaryAngleVector => { GRP => "0018", ELEM => "2003", VR => "DS" },
                                             FrameSecondaryAngleVector => { GRP => "0018", ELEM => "2004", VR => "DS" },
                                                   SliceLocationVector => { GRP => "0018", ELEM => "2005", VR => "DS" },
                                              DisplayWindowLabelVector => { GRP => "0018", ELEM => "2006", VR => "SH" },
                                            NominalScannedPixelSpacing => { GRP => "0018", ELEM => "2010", VR => "DS" },
                                    DigitizingDeviceTransportDirection => { GRP => "0018", ELEM => "2020", VR => "CS" },
                                                 RotationOfScannedFilm => { GRP => "0018", ELEM => "2030", VR => "DS" },
                                                       IVUSAcquisition => { GRP => "0018", ELEM => "3100", VR => "CS" },
                                                      IVUSPullbackRate => { GRP => "0018", ELEM => "3101", VR => "DS" },
                                                         IVUSGatedRate => { GRP => "0018", ELEM => "3102", VR => "DS" },
                                          IVUSPullbackStartFrameNumber => { GRP => "0018", ELEM => "3103", VR => "IS" },
                                           IVUSPullbackStopFrameNumber => { GRP => "0018", ELEM => "3104", VR => "IS" },
                                                          LesionNumber => { GRP => "0018", ELEM => "3105", VR => "IS" },
                                                           OutputPower => { GRP => "0018", ELEM => "5000", VR => "SH" },
                                                        TransducerData => { GRP => "0018", ELEM => "5010", VR => "LO" },
                                                            FocusDepth => { GRP => "0018", ELEM => "5012", VR => "DS" },
                                                    ProcessingFunction => { GRP => "0018", ELEM => "5020", VR => "LO" },
                                                       MechanicalIndex => { GRP => "0018", ELEM => "5022", VR => "DS" },
                                                      BoneThermalIndex => { GRP => "0018", ELEM => "5024", VR => "DS" },
                                                   CranialThermalIndex => { GRP => "0018", ELEM => "5026", VR => "DS" },
                                                SoftTissueThermalIndex => { GRP => "0018", ELEM => "5027", VR => "DS" },
                                           SoftTissueFocusThermalIndex => { GRP => "0018", ELEM => "5028", VR => "DS" },
                                         SoftTissueSurfaceThermalIndex => { GRP => "0018", ELEM => "5029", VR => "DS" },
                                                      DepthOfScanField => { GRP => "0018", ELEM => "5050", VR => "IS" },
                                                       PatientPosition => { GRP => "0018", ELEM => "5100", VR => "CS" },
                                                          ViewPosition => { GRP => "0018", ELEM => "5101", VR => "CS" },
                                   ProjectionEponymousNameCodeSequence => { GRP => "0018", ELEM => "5104", VR => "SQ" },
                                                           Sensitivity => { GRP => "0018", ELEM => "6000", VR => "DS" },
                                           SequenceOfUltrasoundRegions => { GRP => "0018", ELEM => "6011", VR => "SQ" },
                                                   RegionSpatialFormat => { GRP => "0018", ELEM => "6012", VR => "US" },
                                                        RegionDataType => { GRP => "0018", ELEM => "6014", VR => "US" },
                                                           RegionFlags => { GRP => "0018", ELEM => "6016", VR => "UL" },
                                                   RegionLocationMinX0 => { GRP => "0018", ELEM => "6018", VR => "UL" },
                                                   RegionLocationMinY0 => { GRP => "0018", ELEM => "601A", VR => "UL" },
                                                   RegionLocationMaxX1 => { GRP => "0018", ELEM => "601C", VR => "UL" },
                                                   RegionLocationMaxY1 => { GRP => "0018", ELEM => "601E", VR => "UL" },
                                                      ReferencePixelX0 => { GRP => "0018", ELEM => "6020", VR => "SL" },
                                                      ReferencePixelY0 => { GRP => "0018", ELEM => "6022", VR => "SL" },
                                               PhysicalUnitsXDirection => { GRP => "0018", ELEM => "6024", VR => "US" },
                                               PhysicalUnitsYDirection => { GRP => "0018", ELEM => "6026", VR => "US" },
                                          ReferencePixelPhysicalValueX => { GRP => "0018", ELEM => "6028", VR => "FD" },
                                          ReferencePixelPhysicalValueY => { GRP => "0018", ELEM => "602A", VR => "FD" },
                                                        PhysicalDeltaX => { GRP => "0018", ELEM => "602C", VR => "FD" },
                                                        PhysicalDeltaY => { GRP => "0018", ELEM => "602E", VR => "FD" },
                                                   TransducerFrequency => { GRP => "0018", ELEM => "6030", VR => "UL" },
                                                        TransducerType => { GRP => "0018", ELEM => "6031", VR => "CS" },
                                              PulseRepetitionFrequency => { GRP => "0018", ELEM => "6032", VR => "UL" },
                                                DopplerCorrectionAngle => { GRP => "0018", ELEM => "6034", VR => "FD" },
                                                         SteeringAngle => { GRP => "0018", ELEM => "6036", VR => "FD" },
                                          DopplerSampleVolumeXPosition => { GRP => "0018", ELEM => "6039", VR => "SL" },
                                          DopplerSampleVolumeYPosition => { GRP => "0018", ELEM => "603B", VR => "SL" },
                                                      TMLinePositionX0 => { GRP => "0018", ELEM => "603D", VR => "SL" },
                                                      TMLinePositionY0 => { GRP => "0018", ELEM => "603F", VR => "SL" },
                                                      TMLinePositionX1 => { GRP => "0018", ELEM => "6041", VR => "SL" },
                                                      TMLinePositionY1 => { GRP => "0018", ELEM => "6043", VR => "SL" },
                                            PixelComponentOrganization => { GRP => "0018", ELEM => "6044", VR => "US" },
                                                    PixelComponentMask => { GRP => "0018", ELEM => "6046", VR => "UL" },
                                              PixelComponentRangeStart => { GRP => "0018", ELEM => "6048", VR => "UL" },
                                               PixelComponentRangeStop => { GRP => "0018", ELEM => "604A", VR => "UL" },
                                           PixelComponentPhysicalUnits => { GRP => "0018", ELEM => "604C", VR => "US" },
                                                PixelComponentDataType => { GRP => "0018", ELEM => "604E", VR => "US" },
                                              NumberOfTableBreakPoints => { GRP => "0018", ELEM => "6050", VR => "UL" },
                                                   TableOfXBreakPoints => { GRP => "0018", ELEM => "6052", VR => "UL" },
                                                   TableOfYBreakPoints => { GRP => "0018", ELEM => "6054", VR => "FD" },
                                                  NumberOfTableEntries => { GRP => "0018", ELEM => "6056", VR => "UL" },
                                                    TableOfPixelValues => { GRP => "0018", ELEM => "6058", VR => "UL" },
                                                TableOfParameterValues => { GRP => "0018", ELEM => "605A", VR => "FL" },
                                                       RWaveTimeVector => { GRP => "0018", ELEM => "6060", VR => "FL" },
                                         DetectorConditionsNominalFlag => { GRP => "0018", ELEM => "7000", VR => "CS" },
                                                   DetectorTemperature => { GRP => "0018", ELEM => "7001", VR => "DS" },
                                                          DetectorType => { GRP => "0018", ELEM => "7004", VR => "CS" },
                                                 DetectorConfiguration => { GRP => "0018", ELEM => "7005", VR => "CS" },
                                                   DetectorDescription => { GRP => "0018", ELEM => "7006", VR => "LT" },
                                                          DetectorMode => { GRP => "0018", ELEM => "7008", VR => "LT" },
                                                            DetectorID => { GRP => "0018", ELEM => "700A", VR => "SH" },
                                         DateOfLastDetectorCalibration => { GRP => "0018", ELEM => "700C", VR => "DA" },
                                         TimeOfLastDetectorCalibration => { GRP => "0018", ELEM => "700E", VR => "TM" },
                               ExposuresOnDetectorSinceLastCalibration => { GRP => "0018", ELEM => "7010", VR => "IS" },
                                  ExposuresOnDetectorSinceManufactured => { GRP => "0018", ELEM => "7011", VR => "IS" },
                                         DetectorTimeSinceLastExposure => { GRP => "0018", ELEM => "7012", VR => "DS" },
                                                    DetectorActiveTime => { GRP => "0018", ELEM => "7014", VR => "DS" },
                                  DetectorActivationOffsetFromExposure => { GRP => "0018", ELEM => "7016", VR => "DS" },
                                                       DetectorBinning => { GRP => "0018", ELEM => "701A", VR => "DS" },
                                           DetectorElementPhysicalSize => { GRP => "0018", ELEM => "7020", VR => "DS" },
                                                DetectorElementSpacing => { GRP => "0018", ELEM => "7022", VR => "DS" },
                                                   DetectorActiveShape => { GRP => "0018", ELEM => "7024", VR => "CS" },
                                              DetectorActiveDimensions => { GRP => "0018", ELEM => "7026", VR => "DS" },
                                                  DetectorActiveOrigin => { GRP => "0018", ELEM => "7028", VR => "DS" },
                                              DetectorManufacturerName => { GRP => "0018", ELEM => "702A", VR => "LO" },
                                        DetectorManufacturersModelName => { GRP => "0018", ELEM => "702B", VR => "LO" },
                                                     FieldOfViewOrigin => { GRP => "0018", ELEM => "7030", VR => "DS" },
                                                   FieldOfViewRotation => { GRP => "0018", ELEM => "7032", VR => "DS" },
                                             FieldOfViewHorizontalFlip => { GRP => "0018", ELEM => "7034", VR => "CS" },
                                                 GridAbsorbingMaterial => { GRP => "0018", ELEM => "7040", VR => "LT" },
                                                   GridSpacingMaterial => { GRP => "0018", ELEM => "7041", VR => "LT" },
                                                         GridThickness => { GRP => "0018", ELEM => "7042", VR => "DS" },
                                                             GridPitch => { GRP => "0018", ELEM => "7044", VR => "DS" },
                                                       GridAspectRatio => { GRP => "0018", ELEM => "7046", VR => "IS" },
                                                            GridPeriod => { GRP => "0018", ELEM => "7048", VR => "DS" },
                                                     GridFocalDistance => { GRP => "0018", ELEM => "704C", VR => "DS" },
                                                        FilterMaterial => { GRP => "0018", ELEM => "7050", VR => "CS" },
                                                FilterThicknessMinimum => { GRP => "0018", ELEM => "7052", VR => "DS" },
                                                FilterThicknessMaximum => { GRP => "0018", ELEM => "7054", VR => "DS" },
                                                   ExposureControlMode => { GRP => "0018", ELEM => "7060", VR => "CS" },
                                        ExposureControlModeDescription => { GRP => "0018", ELEM => "7062", VR => "LT" },
                                                        ExposureStatus => { GRP => "0018", ELEM => "7064", VR => "CS" },
                                                     PhototimerSetting => { GRP => "0018", ELEM => "7065", VR => "DS" },
                                                  ExposureTimeInMicroS => { GRP => "0018", ELEM => "8150", VR => "DS" },
                                               XRayTubeCurrentInMicroA => { GRP => "0018", ELEM => "8151", VR => "DS" },
                                                  ContentQualification => { GRP => "0018", ELEM => "9004", VR => "CS" },
                                                     PulseSequenceName => { GRP => "0018", ELEM => "9005", VR => "SH" },
                                             MRImagingModifierSequence => { GRP => "0018", ELEM => "9006", VR => "SQ" },
                                                     EchoPulseSequence => { GRP => "0018", ELEM => "9008", VR => "CS" },
                                                     InversionRecovery => { GRP => "0018", ELEM => "9009", VR => "CS" },
                                                      FlowCompensation => { GRP => "0018", ELEM => "9010", VR => "CS" },
                                                      MultipleSpinEcho => { GRP => "0018", ELEM => "9011", VR => "CS" },
                                                 MultiPlanarExcitation => { GRP => "0018", ELEM => "9012", VR => "CS" },
                                                         PhaseContrast => { GRP => "0018", ELEM => "9014", VR => "CS" },
                                                  TimeOfFlightContrast => { GRP => "0018", ELEM => "9015", VR => "CS" },
                                                              Spoiling => { GRP => "0018", ELEM => "9016", VR => "CS" },
                                              SteadyStatePulseSequence => { GRP => "0018", ELEM => "9017", VR => "CS" },
                                               EchoPlanarPulseSequence => { GRP => "0018", ELEM => "9018", VR => "CS" },
                                                     TagAngleFirstAxis => { GRP => "0018", ELEM => "9019", VR => "FD" },
                                                 MagnetizationTransfer => { GRP => "0018", ELEM => "9020", VR => "CS" },
                                                         T2Preparation => { GRP => "0018", ELEM => "9021", VR => "CS" },
                                                    BloodSignalNulling => { GRP => "0018", ELEM => "9022", VR => "CS" },
                                                    SaturationRecovery => { GRP => "0018", ELEM => "9024", VR => "CS" },
                                         SpectrallySelectedSuppression => { GRP => "0018", ELEM => "9025", VR => "CS" },
                                          SpectrallySelectedExcitation => { GRP => "0018", ELEM => "9026", VR => "CS" },
                                                  SpatialPreSaturation => { GRP => "0018", ELEM => "9027", VR => "CS" },
                                                               Tagging => { GRP => "0018", ELEM => "9028", VR => "CS" },
                                                     OversamplingPhase => { GRP => "0018", ELEM => "9029", VR => "CS" },
                                              TagSpacingFirstDimension => { GRP => "0018", ELEM => "9030", VR => "FD" },
                                             GeometryOfKSpaceTraversal => { GRP => "0018", ELEM => "9032", VR => "CS" },
                                              SegmentedKSpaceTraversal => { GRP => "0018", ELEM => "9033", VR => "CS" },
                                      RectilinearPhaseEncodeReordering => { GRP => "0018", ELEM => "9034", VR => "CS" },
                                                          TagThickness => { GRP => "0018", ELEM => "9035", VR => "FD" },
                                               PartialFourierDirection => { GRP => "0018", ELEM => "9036", VR => "CS" },
                                       CardiacSynchronizationTechnique => { GRP => "0018", ELEM => "9037", VR => "CS" },
                                           ReceiveCoilManufacturerName => { GRP => "0018", ELEM => "9041", VR => "LO" },
                                                 MRReceiveCoilSequence => { GRP => "0018", ELEM => "9042", VR => "SQ" },
                                                       ReceiveCoilType => { GRP => "0018", ELEM => "9043", VR => "CS" },
                                                 QuadratureReceiveCoil => { GRP => "0018", ELEM => "9044", VR => "CS" },
                                           MultiCoilDefinitionSequence => { GRP => "0018", ELEM => "9045", VR => "SQ" },
                                                MultiCoilConfiguration => { GRP => "0018", ELEM => "9046", VR => "LO" },
                                                  MultiCoilElementName => { GRP => "0018", ELEM => "9047", VR => "SH" },
                                                  MultiCoilElementUsed => { GRP => "0018", ELEM => "9048", VR => "CS" },
                                                MRTransmitCoilSequence => { GRP => "0018", ELEM => "9049", VR => "SQ" },
                                          TransmitCoilManufacturerName => { GRP => "0018", ELEM => "9050", VR => "LO" },
                                                      TransmitCoilType => { GRP => "0018", ELEM => "9051", VR => "CS" },
                                                         SpectralWidth => { GRP => "0018", ELEM => "9052", VR => "FD" },
                                                ChemicalShiftReference => { GRP => "0018", ELEM => "9053", VR => "FD" },
                                           VolumeLocalizationTechnique => { GRP => "0018", ELEM => "9054", VR => "CS" },
                                   MRAcquisitionFrequencyEncodingSteps => { GRP => "0018", ELEM => "9058", VR => "US" },
                                                            DeCoupling => { GRP => "0018", ELEM => "9059", VR => "CS" },
                                                      DeCoupledNucleus => { GRP => "0018", ELEM => "9060", VR => "CS" },
                                                   DeCouplingFrequency => { GRP => "0018", ELEM => "9061", VR => "FD" },
                                                      DeCouplingMethod => { GRP => "0018", ELEM => "9062", VR => "CS" },
                                      DeCouplingChemicalShiftReference => { GRP => "0018", ELEM => "9063", VR => "FD" },
                                                       KSpaceFiltering => { GRP => "0018", ELEM => "9064", VR => "CS" },
                                                   TimeDomainFiltering => { GRP => "0018", ELEM => "9065", VR => "CS" },
                                                     NumberOfZeroFills => { GRP => "0018", ELEM => "9066", VR => "US" },
                                                    BaselineCorrection => { GRP => "0018", ELEM => "9067", VR => "CS" },
                                        ParallelReductionFactorInPlane => { GRP => "0018", ELEM => "9069", VR => "FD" },
                                            CardiacRRIntervalSpecified => { GRP => "0018", ELEM => "9070", VR => "FD" },
                                                   AcquisitionDuration => { GRP => "0018", ELEM => "9073", VR => "FD" },
                                              FrameAcquisitionDateTime => { GRP => "0018", ELEM => "9074", VR => "DT" },
                                               DiffusionDirectionality => { GRP => "0018", ELEM => "9075", VR => "CS" },
                                    DiffusionGradientDirectionSequence => { GRP => "0018", ELEM => "9076", VR => "SQ" },
                                                   ParallelAcquisition => { GRP => "0018", ELEM => "9077", VR => "CS" },
                                          ParallelAcquisitionTechnique => { GRP => "0018", ELEM => "9078", VR => "CS" },
                                                        InversionTimes => { GRP => "0018", ELEM => "9079", VR => "FD" },
                                              MetaboliteMapDescription => { GRP => "0018", ELEM => "9080", VR => "ST" },
                                                        PartialFourier => { GRP => "0018", ELEM => "9081", VR => "CS" },
                                                     EffectiveEchoTime => { GRP => "0018", ELEM => "9082", VR => "FD" },
                                             MetaboliteMapCodeSequence => { GRP => "0018", ELEM => "9083", VR => "SQ" },
                                                 ChemicalShiftSequence => { GRP => "0018", ELEM => "9084", VR => "SQ" },
                                                   CardiacSignalSource => { GRP => "0018", ELEM => "9085", VR => "CS" },
                                                       DiffusionBValue => { GRP => "0018", ELEM => "9087", VR => "FD" },
                                          DiffusionGradientOrientation => { GRP => "0018", ELEM => "9089", VR => "FD" },
                                             VelocityEncodingDirection => { GRP => "0018", ELEM => "9090", VR => "FD" },
                                          VelocityEncodingMinimumValue => { GRP => "0018", ELEM => "9091", VR => "FD" },
                                            NumberOfKSpaceTrajectories => { GRP => "0018", ELEM => "9093", VR => "US" },
                                                      CoverageOfKSpace => { GRP => "0018", ELEM => "9094", VR => "CS" },
                                      SpectroscopyAcquisitionPhaseRows => { GRP => "0018", ELEM => "9095", VR => "UL" },
                                                  TransmitterFrequency => { GRP => "0018", ELEM => "9098", VR => "FD" },
                                                       ResonantNucleus => { GRP => "0018", ELEM => "9100", VR => "CS" },
                                                   FrequencyCorrection => { GRP => "0018", ELEM => "9101", VR => "CS" },
                                     MRSpectroscopyFOVGeometrySequence => { GRP => "0018", ELEM => "9103", VR => "SQ" },
                                                         SlabThickness => { GRP => "0018", ELEM => "9104", VR => "FD" },
                                                       SlabOrientation => { GRP => "0018", ELEM => "9105", VR => "FD" },
                                                       MidSlabPosition => { GRP => "0018", ELEM => "9106", VR => "FD" },
                                           MRSpatialSaturationSequence => { GRP => "0018", ELEM => "9107", VR => "SQ" },
                                  MRTimingAndRelatedParametersSequence => { GRP => "0018", ELEM => "9112", VR => "SQ" },
                                                        MREchoSequence => { GRP => "0018", ELEM => "9114", VR => "SQ" },
                                                    MRModifierSequence => { GRP => "0018", ELEM => "9115", VR => "SQ" },
                                                   MRDiffusionSequence => { GRP => "0018", ELEM => "9117", VR => "SQ" },
                                        CardiacSynchronizationSequence => { GRP => "0018", ELEM => "9118", VR => "SQ" },
                                                    MRAveragesSequence => { GRP => "0018", ELEM => "9119", VR => "SQ" },
                                                 MRFOVGeometrySequence => { GRP => "0018", ELEM => "9125", VR => "SQ" },
                                            VolumeLocalizationSequence => { GRP => "0018", ELEM => "9126", VR => "SQ" },
                                    SpectroscopyAcquisitionDataColumns => { GRP => "0018", ELEM => "9127", VR => "UL" },
                                               DiffusionAnisotropyType => { GRP => "0018", ELEM => "9147", VR => "CS" },
                                                FrameReferenceDateTime => { GRP => "0018", ELEM => "9151", VR => "DT" },
                                               MRMetaboliteMapSequence => { GRP => "0018", ELEM => "9152", VR => "SQ" },
                                     ParallelReductionFactorOutOfPlane => { GRP => "0018", ELEM => "9155", VR => "FD" },
                           SpectroscopyAcquisitionOutOfPlanePhaseSteps => { GRP => "0018", ELEM => "9159", VR => "UL" },
                                  ParallelReductionFactorSecondInPlane => { GRP => "0018", ELEM => "9168", VR => "FD" },
                                         CardiacBeatRejectionTechnique => { GRP => "0018", ELEM => "9169", VR => "CS" },
                                RespiratoryMotionCompensationTechnique => { GRP => "0018", ELEM => "9170", VR => "CS" },
                                               RespiratorySignalSource => { GRP => "0018", ELEM => "9171", VR => "CS" },
                                       BulkMotionCompensationTechnique => { GRP => "0018", ELEM => "9172", VR => "CS" },
                                                BulkMotionSignalSource => { GRP => "0018", ELEM => "9173", VR => "CS" },
                                        ApplicableSafetyStandardAgency => { GRP => "0018", ELEM => "9174", VR => "CS" },
                                   ApplicableSafetyStandardDescription => { GRP => "0018", ELEM => "9175", VR => "LO" },
                                                 OperatingModeSequence => { GRP => "0018", ELEM => "9176", VR => "SQ" },
                                                     OperatingModeType => { GRP => "0018", ELEM => "9177", VR => "CS" },
                                                         OperatingMode => { GRP => "0018", ELEM => "9178", VR => "CS" },
                                      SpecificAbsorptionRateDefinition => { GRP => "0018", ELEM => "9179", VR => "CS" },
                                                    GradientOutputType => { GRP => "0018", ELEM => "9180", VR => "CS" },
                                           SpecificAbsorptionRateValue => { GRP => "0018", ELEM => "9181", VR => "FD" },
                                                        GradientOutput => { GRP => "0018", ELEM => "9182", VR => "FD" },
                                             FlowCompensationDirection => { GRP => "0018", ELEM => "9183", VR => "CS" },
                                                          TaggingDelay => { GRP => "0018", ELEM => "9184", VR => "FD" },
                     RespiratoryMotionCompensationTechniqueDescription => { GRP => "0018", ELEM => "9185", VR => "ST" },
                                             RespiratorySignalSourceID => { GRP => "0018", ELEM => "9186", VR => "SH" },
                                            MRVelocityEncodingSequence => { GRP => "0018", ELEM => "9197", VR => "SQ" },
                                             FirstOrderPhaseCorrection => { GRP => "0018", ELEM => "9198", VR => "CS" },
                                        WaterReferencedPhaseCorrection => { GRP => "0018", ELEM => "9199", VR => "CS" },
                                         MRSpectroscopyAcquisitionType => { GRP => "0018", ELEM => "9200", VR => "CS" },
                                              RespiratoryCyclePosition => { GRP => "0018", ELEM => "9214", VR => "CS" },
                                          VelocityEncodingMaximumValue => { GRP => "0018", ELEM => "9217", VR => "FD" },
                                             TagSpacingSecondDimension => { GRP => "0018", ELEM => "9218", VR => "FD" },
                                                    TagAngleSecondAxis => { GRP => "0018", ELEM => "9219", VR => "SS" },
                                              FrameAcquisitionDuration => { GRP => "0018", ELEM => "9220", VR => "FD" },
                                              MRImageFrameTypeSequence => { GRP => "0018", ELEM => "9226", VR => "SQ" },
                                       MRSpectroscopyFrameTypeSequence => { GRP => "0018", ELEM => "9227", VR => "SQ" },
                                MRAcquisitionPhaseEncodingStepsInPlane => { GRP => "0018", ELEM => "9231", VR => "US" },
                             MRAcquisitionPhaseEncodingStepsOutOfPlane => { GRP => "0018", ELEM => "9232", VR => "US" },
                                   SpectroscopyAcquisitionPhaseColumns => { GRP => "0018", ELEM => "9234", VR => "UL" },
                                                  CardiacCyclePosition => { GRP => "0018", ELEM => "9236", VR => "CS" },
                                        SpecificAbsorptionRateSequence => { GRP => "0018", ELEM => "9239", VR => "SQ" },
                                                     RFEchoTrainLength => { GRP => "0018", ELEM => "9240", VR => "US" },
                                               GradientEchoTrainLength => { GRP => "0018", ELEM => "9241", VR => "US" },
                            ChemicalShiftsMinimumIntegrationLimitInPpm => { GRP => "0018", ELEM => "9295", VR => "FD" },
                            ChemicalShiftsMaximumIntegrationLimitInPpm => { GRP => "0018", ELEM => "9296", VR => "FD" },
                                             CTAcquisitionTypeSequence => { GRP => "0018", ELEM => "9301", VR => "SQ" },
                                                       AcquisitionType => { GRP => "0018", ELEM => "9302", VR => "CS" },
                                                             TubeAngle => { GRP => "0018", ELEM => "9303", VR => "FD" },
                                          CTAcquisitionDetailsSequence => { GRP => "0018", ELEM => "9304", VR => "SQ" },
                                                        RevolutionTime => { GRP => "0018", ELEM => "9305", VR => "FD" },
                                                SingleCollimationWidth => { GRP => "0018", ELEM => "9306", VR => "FD" },
                                                 TotalCollimationWidth => { GRP => "0018", ELEM => "9307", VR => "FD" },
                                               CTTableDynamicsSequence => { GRP => "0018", ELEM => "9308", VR => "SQ" },
                                                            TableSpeed => { GRP => "0018", ELEM => "9309", VR => "FD" },
                                                  TableFeedPerRotation => { GRP => "0018", ELEM => "9310", VR => "FD" },
                                                     SpiralPitchFactor => { GRP => "0018", ELEM => "9311", VR => "FD" },
                                                    CTGeometrySequence => { GRP => "0018", ELEM => "9312", VR => "SQ" },
                                           DataCollectionCenterPatient => { GRP => "0018", ELEM => "9313", VR => "FD" },
                                              CTReconstructionSequence => { GRP => "0018", ELEM => "9314", VR => "SQ" },
                                               ReconstructionAlgorithm => { GRP => "0018", ELEM => "9315", VR => "CS" },
                                                ConvolutionKernelGroup => { GRP => "0018", ELEM => "9316", VR => "CS" },
                                             ReconstructionFieldOfView => { GRP => "0018", ELEM => "9317", VR => "FD" },
                                     ReconstructionTargetCenterPatient => { GRP => "0018", ELEM => "9318", VR => "FD" },
                                                   ReconstructionAngle => { GRP => "0018", ELEM => "9319", VR => "FD" },
                                                           ImageFilter => { GRP => "0018", ELEM => "9320", VR => "SH" },
                                                    CTExposureSequence => { GRP => "0018", ELEM => "9321", VR => "SQ" },
                                            ReconstructionPixelSpacing => { GRP => "0018", ELEM => "9322", VR => "FD" },
                                                ExposureModulationType => { GRP => "0018", ELEM => "9323", VR => "CS" },
                                                   EstimatedDoseSaving => { GRP => "0018", ELEM => "9324", VR => "FD" },
                                                 CTXRayDetailsSequence => { GRP => "0018", ELEM => "9325", VR => "SQ" },
                                                    CTPositionSequence => { GRP => "0018", ELEM => "9326", VR => "SQ" },
                                                         TablePosition => { GRP => "0018", ELEM => "9327", VR => "FD" },
                                                      ExposureTimeInMs => { GRP => "0018", ELEM => "9328", VR => "FD" },
                                              CTImageFrameTypeSequence => { GRP => "0018", ELEM => "9329", VR => "SQ" },
                                                   XRayTubeCurrentInMA => { GRP => "0018", ELEM => "9330", VR => "FD" },
                                                         ExposureInMAs => { GRP => "0018", ELEM => "9332", VR => "FD" },
                                                    ConstantVolumeFlag => { GRP => "0018", ELEM => "9333", VR => "CS" },
                                                       FluoroscopyFlag => { GRP => "0018", ELEM => "9334", VR => "CS" },
                                  DistanceSourceToDataCollectionCenter => { GRP => "0018", ELEM => "9335", VR => "FD" },
                                              ContrastBolusAgentNumber => { GRP => "0018", ELEM => "9337", VR => "US" },
                                   ContrastBolusIngredientCodeSequence => { GRP => "0018", ELEM => "9338", VR => "SQ" },
                                 ContrastAdministrationProfileSequence => { GRP => "0018", ELEM => "9340", VR => "SQ" },
                                            ContrastBolusUsageSequence => { GRP => "0018", ELEM => "9341", VR => "SQ" },
                                        ContrastBolusAgentAdministered => { GRP => "0018", ELEM => "9342", VR => "CS" },
                                            ContrastBolusAgentDetected => { GRP => "0018", ELEM => "9343", VR => "CS" },
                                               ContrastBolusAgentPhase => { GRP => "0018", ELEM => "9344", VR => "CS" },
                                                               CTDIvol => { GRP => "0018", ELEM => "9345", VR => "FD" },
                                           CTDIPhantomTypeCodeSequence => { GRP => "0018", ELEM => "9346", VR => "SQ" },
                                       CalciumScoringMassFactorPatient => { GRP => "0018", ELEM => "9351", VR => "FL" },
                                        CalciumScoringMassFactorDevice => { GRP => "0018", ELEM => "9352", VR => "FL" },
                                        CTAdditionalXRaySourceSequence => { GRP => "0018", ELEM => "9360", VR => "SQ" },
                                    ProjectionPixelCalibrationSequence => { GRP => "0018", ELEM => "9401", VR => "SQ" },
                                             DistanceSourceToIsocenter => { GRP => "0018", ELEM => "9402", VR => "FL" },
                                              DistanceObjectToTableTop => { GRP => "0018", ELEM => "9403", VR => "FL" },
                                      ObjectPixelSpacingInCenterOfBeam => { GRP => "0018", ELEM => "9404", VR => "FL" },
                                            PositionerPositionSequence => { GRP => "0018", ELEM => "9405", VR => "SQ" },
                                                 TablePositionSequence => { GRP => "0018", ELEM => "9406", VR => "SQ" },
                                               CollimatorShapeSequence => { GRP => "0018", ELEM => "9407", VR => "SQ" },
                                     XAXRFFrameCharacteristicsSequence => { GRP => "0018", ELEM => "9412", VR => "SQ" },
                                              FrameAcquisitionSequence => { GRP => "0018", ELEM => "9417", VR => "SQ" },
                                                      XRayReceptorType => { GRP => "0018", ELEM => "9420", VR => "CS" },
                                               AcquisitionProtocolName => { GRP => "0018", ELEM => "9423", VR => "LO" },
                                        AcquisitionProtocolDescription => { GRP => "0018", ELEM => "9424", VR => "LT" },
                                         ContrastBolusIngredientOpaque => { GRP => "0018", ELEM => "9425", VR => "CS" },
                                DistanceReceptorPlaneToDetectorHousing => { GRP => "0018", ELEM => "9426", VR => "FL" },
                                                IntensifierActiveShape => { GRP => "0018", ELEM => "9427", VR => "CS" },
                                           IntensifierActiveDimensions => { GRP => "0018", ELEM => "9428", VR => "FL" },
                                                  PhysicalDetectorSize => { GRP => "0018", ELEM => "9429", VR => "FL" },
                                         PositionOfIsocenterProjection => { GRP => "0018", ELEM => "9430", VR => "US" },
                                                   FieldOfViewSequence => { GRP => "0018", ELEM => "9432", VR => "SQ" },
                                                FieldOfViewDescription => { GRP => "0018", ELEM => "9433", VR => "LO" },
                                 ExposureControlSensingRegionsSequence => { GRP => "0018", ELEM => "9434", VR => "SQ" },
                                     ExposureControlSensingRegionShape => { GRP => "0018", ELEM => "9435", VR => "CS" },
                          ExposureControlSensingRegionLeftVerticalEdge => { GRP => "0018", ELEM => "9436", VR => "SS" },
                         ExposureControlSensingRegionRightVerticalEdge => { GRP => "0018", ELEM => "9437", VR => "SS" },
                       ExposureControlSensingRegionUpperHorizontalEdge => { GRP => "0018", ELEM => "9438", VR => "SS" },
                       ExposureControlSensingRegionLowerHorizontalEdge => { GRP => "0018", ELEM => "9439", VR => "SS" },
                          CenterOfCircularExposureControlSensingRegion => { GRP => "0018", ELEM => "9440", VR => "SS" },
                          RadiusOfCircularExposureControlSensingRegion => { GRP => "0018", ELEM => "9441", VR => "US" },
                    VerticesOfThePolygonalExposureControlSensingRegion => { GRP => "0018", ELEM => "9442", VR => "SS" },
                                               ColumnAngulationPatient => { GRP => "0018", ELEM => "9447", VR => "FL" },
                                                             BeamAngle => { GRP => "0018", ELEM => "9449", VR => "FL" },
                                       FrameDetectorParametersSequence => { GRP => "0018", ELEM => "9451", VR => "SQ" },
                                            CalculatedAnatomyThickness => { GRP => "0018", ELEM => "9452", VR => "FL" },
                                                   CalibrationSequence => { GRP => "0018", ELEM => "9455", VR => "SQ" },
                                               ObjectThicknessSequence => { GRP => "0018", ELEM => "9456", VR => "SQ" },
                                                   PlaneIdentification => { GRP => "0018", ELEM => "9457", VR => "CS" },
                                          FieldOfViewDimensionsInFloat => { GRP => "0018", ELEM => "9461", VR => "FL" },
                                      IsocenterReferenceSystemSequence => { GRP => "0018", ELEM => "9462", VR => "SQ" },
                                       PositionerIsocenterPrimaryAngle => { GRP => "0018", ELEM => "9463", VR => "FL" },
                                     PositionerIsocenterSecondaryAngle => { GRP => "0018", ELEM => "9464", VR => "FL" },
                              PositionerIsocenterDetectorRotationAngle => { GRP => "0018", ELEM => "9465", VR => "FL" },
                                             TableXPositionToIsocenter => { GRP => "0018", ELEM => "9466", VR => "FL" },
                                             TableYPositionToIsocenter => { GRP => "0018", ELEM => "9467", VR => "FL" },
                                             TableZPositionToIsocenter => { GRP => "0018", ELEM => "9468", VR => "FL" },
                                          TableHorizontalRotationAngle => { GRP => "0018", ELEM => "9469", VR => "FL" },
                                                    TableHeadTiltAngle => { GRP => "0018", ELEM => "9470", VR => "FL" },
                                                  TableCradleTiltAngle => { GRP => "0018", ELEM => "9471", VR => "FL" },
                                           FrameDisplayShutterSequence => { GRP => "0018", ELEM => "9472", VR => "SQ" },
                                          AcquiredImageAreaDoseProduct => { GRP => "0018", ELEM => "9473", VR => "FL" },
                                    CArmPositionerTabletopRelationship => { GRP => "0018", ELEM => "9474", VR => "CS" },
                                                  XRayGeometrySequence => { GRP => "0018", ELEM => "9476", VR => "SQ" },
                                IrradiationEventIdentificationSequence => { GRP => "0018", ELEM => "9477", VR => "SQ" },
                                               XRay3DFrameTypeSequence => { GRP => "0018", ELEM => "9504", VR => "SQ" },
                                           ContributingSourcesSequence => { GRP => "0018", ELEM => "9506", VR => "SQ" },
                                             XRay3DAcquisitionSequence => { GRP => "0018", ELEM => "9507", VR => "SQ" },
                                              PrimaryPositionerScanArc => { GRP => "0018", ELEM => "9508", VR => "FL" },
                                            SecondaryPositionerScanArc => { GRP => "0018", ELEM => "9509", VR => "FL" },
                                       PrimaryPositionerScanStartAngle => { GRP => "0018", ELEM => "9510", VR => "FL" },
                                     SecondaryPositionerScanStartAngle => { GRP => "0018", ELEM => "9511", VR => "FL" },
                                            PrimaryPositionerIncrement => { GRP => "0018", ELEM => "9514", VR => "FL" },
                                          SecondaryPositionerIncrement => { GRP => "0018", ELEM => "9515", VR => "FL" },
                                              StartAcquisitionDateTime => { GRP => "0018", ELEM => "9516", VR => "DT" },
                                                EndAcquisitionDateTime => { GRP => "0018", ELEM => "9517", VR => "DT" },
                                                       ApplicationName => { GRP => "0018", ELEM => "9524", VR => "LO" },
                                                    ApplicationVersion => { GRP => "0018", ELEM => "9525", VR => "LO" },
                                               ApplicationManufacturer => { GRP => "0018", ELEM => "9526", VR => "LO" },
                                                         AlgorithmType => { GRP => "0018", ELEM => "9527", VR => "CS" },
                                                  AlgorithmDescription => { GRP => "0018", ELEM => "9528", VR => "LO" },
                                          XRay3DReconstructionSequence => { GRP => "0018", ELEM => "9530", VR => "SQ" },
                                             ReconstructionDescription => { GRP => "0018", ELEM => "9531", VR => "LO" },
                                      PerProjectionAcquisitionSequence => { GRP => "0018", ELEM => "9538", VR => "SQ" },
                                              DiffusionBMatrixSequence => { GRP => "0018", ELEM => "9601", VR => "SQ" },
                                                     DiffusionBValueXX => { GRP => "0018", ELEM => "9602", VR => "FD" },
                                                     DiffusionBValueXY => { GRP => "0018", ELEM => "9603", VR => "FD" },
                                                     DiffusionBValueXZ => { GRP => "0018", ELEM => "9604", VR => "FD" },
                                                     DiffusionBValueYY => { GRP => "0018", ELEM => "9605", VR => "FD" },
                                                     DiffusionBValueYZ => { GRP => "0018", ELEM => "9606", VR => "FD" },
                                                     DiffusionBValueZZ => { GRP => "0018", ELEM => "9607", VR => "FD" },
                                         ContributingEquipmentSequence => { GRP => "0018", ELEM => "A001", VR => "SQ" },
                                                  ContributionDateTime => { GRP => "0018", ELEM => "A002", VR => "DT" },
                                               ContributionDescription => { GRP => "0018", ELEM => "A003", VR => "ST" },
                                                      StudyInstanceUID => { GRP => "0020", ELEM => "000D", VR => "UI" },
                                                     SeriesInstanceUID => { GRP => "0020", ELEM => "000E", VR => "UI" },
                                                               StudyID => { GRP => "0020", ELEM => "0010", VR => "SH" },
                                                          SeriesNumber => { GRP => "0020", ELEM => "0011", VR => "IS" },
                                                     AcquisitionNumber => { GRP => "0020", ELEM => "0012", VR => "IS" },
                                                        InstanceNumber => { GRP => "0020", ELEM => "0013", VR => "IS" },
                                                            ItemNumber => { GRP => "0020", ELEM => "0019", VR => "IS" },
                                                    PatientOrientation => { GRP => "0020", ELEM => "0020", VR => "CS" },
                                                  ImagePositionPatient => { GRP => "0020", ELEM => "0032", VR => "DS" },
                                               ImageOrientationPatient => { GRP => "0020", ELEM => "0037", VR => "DS" },
                                                   FrameOfReferenceUID => { GRP => "0020", ELEM => "0052", VR => "UI" },
                                                            Laterality => { GRP => "0020", ELEM => "0060", VR => "CS" },
                                                       ImageLaterality => { GRP => "0020", ELEM => "0062", VR => "CS" },
                                            TemporalPositionIdentifier => { GRP => "0020", ELEM => "0100", VR => "IS" },
                                             NumberOfTemporalPositions => { GRP => "0020", ELEM => "0105", VR => "IS" },
                                                    TemporalResolution => { GRP => "0020", ELEM => "0110", VR => "DS" },
                                    SynchronizationFrameOfReferenceUID => { GRP => "0020", ELEM => "0200", VR => "UI" },
                                                   ImagesInAcquisition => { GRP => "0020", ELEM => "1002", VR => "IS" },
                                            PositionReferenceIndicator => { GRP => "0020", ELEM => "1040", VR => "LO" },
                                                         SliceLocation => { GRP => "0020", ELEM => "1041", VR => "DS" },
                                         NumberOfPatientRelatedStudies => { GRP => "0020", ELEM => "1200", VR => "IS" },
                                          NumberOfPatientRelatedSeries => { GRP => "0020", ELEM => "1202", VR => "IS" },
                                       NumberOfPatientRelatedInstances => { GRP => "0020", ELEM => "1204", VR => "IS" },
                                            NumberOfStudyRelatedSeries => { GRP => "0020", ELEM => "1206", VR => "IS" },
                                         NumberOfStudyRelatedInstances => { GRP => "0020", ELEM => "1208", VR => "IS" },
                                        NumberOfSeriesRelatedInstances => { GRP => "0020", ELEM => "1209", VR => "IS" },
                                                         ImageComments => { GRP => "0020", ELEM => "4000", VR => "LT" },
                                                               StackID => { GRP => "0020", ELEM => "9056", VR => "SH" },
                                                 InStackPositionNumber => { GRP => "0020", ELEM => "9057", VR => "UL" },
                                                  FrameAnatomySequence => { GRP => "0020", ELEM => "9071", VR => "SQ" },
                                                       FrameLaterality => { GRP => "0020", ELEM => "9072", VR => "CS" },
                                                  FrameContentSequence => { GRP => "0020", ELEM => "9111", VR => "SQ" },
                                                 PlanePositionSequence => { GRP => "0020", ELEM => "9113", VR => "SQ" },
                                              PlaneOrientationSequence => { GRP => "0020", ELEM => "9116", VR => "SQ" },
                                                 TemporalPositionIndex => { GRP => "0020", ELEM => "9128", VR => "UL" },
                                        NominalCardiacTriggerDelayTime => { GRP => "0020", ELEM => "9153", VR => "FD" },
                                                FrameAcquisitionNumber => { GRP => "0020", ELEM => "9156", VR => "US" },
                                                  DimensionIndexValues => { GRP => "0020", ELEM => "9157", VR => "UL" },
                                                         FrameComments => { GRP => "0020", ELEM => "9158", VR => "LT" },
                                                      ConcatenationUID => { GRP => "0020", ELEM => "9161", VR => "UI" },
                                                 InConcatenationNumber => { GRP => "0020", ELEM => "9162", VR => "US" },
                                            InConcatenationTotalNumber => { GRP => "0020", ELEM => "9163", VR => "US" },
                                              DimensionOrganizationUID => { GRP => "0020", ELEM => "9164", VR => "UI" },
                                                 DimensionIndexPointer => { GRP => "0020", ELEM => "9165", VR => "AT" },
                                                FunctionalGroupPointer => { GRP => "0020", ELEM => "9167", VR => "AT" },
                                          DimensionIndexPrivateCreator => { GRP => "0020", ELEM => "9213", VR => "LO" },
                                         DimensionOrganizationSequence => { GRP => "0020", ELEM => "9221", VR => "SQ" },
                                                DimensionIndexSequence => { GRP => "0020", ELEM => "9222", VR => "SQ" },
                                        ConcatenationFrameOffsetNumber => { GRP => "0020", ELEM => "9228", VR => "UL" },
                                         FunctionalGroupPrivateCreator => { GRP => "0020", ELEM => "9238", VR => "LO" },
                                       NominalPercentageOfCardiacPhase => { GRP => "0020", ELEM => "9241", VR => "FL" },
                                   NominalPercentageOfRespiratoryPhase => { GRP => "0020", ELEM => "9245", VR => "FL" },
                                          StartingRespiratoryAmplitude => { GRP => "0020", ELEM => "9246", VR => "FL" },
                                              StartingRespiratoryPhase => { GRP => "0020", ELEM => "9247", VR => "CS" },
                                            EndingRespiratoryAmplitude => { GRP => "0020", ELEM => "9248", VR => "FL" },
                                                EndingRespiratoryPhase => { GRP => "0020", ELEM => "9249", VR => "CS" },
                                                RespiratoryTriggerType => { GRP => "0020", ELEM => "9250", VR => "CS" },
                                                 RRIntervalTimeNominal => { GRP => "0020", ELEM => "9251", VR => "FD" },
                                         ActualCardiacTriggerDelayTime => { GRP => "0020", ELEM => "9252", VR => "FD" },
                                    RespiratorySynchronizationSequence => { GRP => "0020", ELEM => "9253", VR => "SQ" },
                                               RespiratoryIntervalTime => { GRP => "0020", ELEM => "9254", VR => "FD" },
                                    NominalRespiratoryTriggerDelayTime => { GRP => "0020", ELEM => "9255", VR => "FD" },
                                      RespiratoryTriggerDelayThreshold => { GRP => "0020", ELEM => "9256", VR => "FD" },
                                     ActualRespiratoryTriggerDelayTime => { GRP => "0020", ELEM => "9257", VR => "FD" },
                                             DimensionDescriptionLabel => { GRP => "0020", ELEM => "9421", VR => "LO" },
                                     PatientOrientationInFrameSequence => { GRP => "0020", ELEM => "9450", VR => "SQ" },
                                                            FrameLabel => { GRP => "0020", ELEM => "9453", VR => "LO" },
                                                      AcquisitionIndex => { GRP => "0020", ELEM => "9518", VR => "US" },
                             ContributingSOPInstancesReferenceSequence => { GRP => "0020", ELEM => "9529", VR => "SQ" },
                                                   ReconstructionIndex => { GRP => "0020", ELEM => "9536", VR => "US" },
                                  LightPathFilterPassThroughWavelength => { GRP => "0022", ELEM => "0001", VR => "US" },
                                               LightPathFilterPassBand => { GRP => "0022", ELEM => "0002", VR => "US" },
                                  ImagePathFilterPassThroughWavelength => { GRP => "0022", ELEM => "0003", VR => "US" },
                                               ImagePathFilterPassBand => { GRP => "0022", ELEM => "0004", VR => "US" },
                                           PatientEyeMovementCommanded => { GRP => "0022", ELEM => "0005", VR => "CS" },
                                 PatientEyeMovementCommandCodeSequence => { GRP => "0022", ELEM => "0006", VR => "SQ" },
                                                    SphericalLensPower => { GRP => "0022", ELEM => "0007", VR => "FL" },
                                                     CylinderLensPower => { GRP => "0022", ELEM => "0008", VR => "FL" },
                                                          CylinderAxis => { GRP => "0022", ELEM => "0009", VR => "FL" },
                                               EmmetropicMagnification => { GRP => "0022", ELEM => "000A", VR => "FL" },
                                                   IntraOcularPressure => { GRP => "0022", ELEM => "000B", VR => "FL" },
                                                 HorizontalFieldOfView => { GRP => "0022", ELEM => "000C", VR => "FL" },
                                                          PupilDilated => { GRP => "0022", ELEM => "000D", VR => "CS" },
                                                      DegreeOfDilation => { GRP => "0022", ELEM => "000E", VR => "FL" },
                                                   StereoBaselineAngle => { GRP => "0022", ELEM => "0010", VR => "FL" },
                                            StereoBaselineDisplacement => { GRP => "0022", ELEM => "0011", VR => "FL" },
                                           StereoHorizontalPixelOffset => { GRP => "0022", ELEM => "0012", VR => "FL" },
                                             StereoVerticalPixelOffset => { GRP => "0022", ELEM => "0013", VR => "FL" },
                                                        StereoRotation => { GRP => "0022", ELEM => "0014", VR => "FL" },
                                     AcquisitionDeviceTypeCodeSequence => { GRP => "0022", ELEM => "0015", VR => "SQ" },
                                          IlluminationTypeCodeSequence => { GRP => "0022", ELEM => "0016", VR => "SQ" },
                                  LightPathFilterTypeStackCodeSequence => { GRP => "0022", ELEM => "0017", VR => "SQ" },
                                  ImagePathFilterTypeStackCodeSequence => { GRP => "0022", ELEM => "0018", VR => "SQ" },
                                                    LensesCodeSequence => { GRP => "0022", ELEM => "0019", VR => "SQ" },
                                        ChannelDescriptionCodeSequence => { GRP => "0022", ELEM => "001A", VR => "SQ" },
                                               RefractiveStateSequence => { GRP => "0022", ELEM => "001B", VR => "SQ" },
                                            MydriaticAgentCodeSequence => { GRP => "0022", ELEM => "001C", VR => "SQ" },
                                     RelativeImagePositionCodeSequence => { GRP => "0022", ELEM => "001D", VR => "SQ" },
                                                   StereoPairsSequence => { GRP => "0022", ELEM => "0020", VR => "SQ" },
                                                     LeftImageSequence => { GRP => "0022", ELEM => "0021", VR => "SQ" },
                                                    RightImageSequence => { GRP => "0022", ELEM => "0022", VR => "SQ" },
                                                   AxialLengthOfTheEye => { GRP => "0022", ELEM => "0030", VR => "FL" },
                                       OphthalmicFrameLocationSequence => { GRP => "0022", ELEM => "0031", VR => "SQ" },
                                                  ReferenceCoordinates => { GRP => "0022", ELEM => "0032", VR => "FL" },
                                                DepthSpatialResolution => { GRP => "0022", ELEM => "0035", VR => "FL" },
                                                MaximumDepthDistortion => { GRP => "0022", ELEM => "0036", VR => "FL" },
                                            AlongScanSpatialResolution => { GRP => "0022", ELEM => "0037", VR => "FL" },
                                            MaximumAlongScanDistortion => { GRP => "0022", ELEM => "0038", VR => "FL" },
                                            OphthalmicImageOrientation => { GRP => "0022", ELEM => "0039", VR => "CS" },
                                                DepthOfTransverseImage => { GRP => "0022", ELEM => "0041", VR => "FL" },
                              MydriaticAgentConcentrationUnitsSequence => { GRP => "0022", ELEM => "0042", VR => "SQ" },
                                           AcrossScanSpatialResolution => { GRP => "0022", ELEM => "0048", VR => "FL" },
                                           MaximumAcrossScanDistortion => { GRP => "0022", ELEM => "0049", VR => "FL" },
                                           MydriaticAgentConcentration => { GRP => "0022", ELEM => "004E", VR => "DS" },
                                                IlluminationWaveLength => { GRP => "0022", ELEM => "0055", VR => "FL" },
                                                     IlluminationPower => { GRP => "0022", ELEM => "0056", VR => "FL" },
                                                 IlluminationBandwidth => { GRP => "0022", ELEM => "0057", VR => "FL" },
                                                MydriaticAgentSequence => { GRP => "0022", ELEM => "0058", VR => "SQ" },
                                                       SamplesPerPixel => { GRP => "0028", ELEM => "0002", VR => "US" },
                                                   SamplesPerPixelUsed => { GRP => "0028", ELEM => "0003", VR => "US" },
                                             PhotometricInterpretation => { GRP => "0028", ELEM => "0004", VR => "CS" },
                                                   PlanarConfiguration => { GRP => "0028", ELEM => "0006", VR => "US" },
                                                        NumberOfFrames => { GRP => "0028", ELEM => "0008", VR => "IS" },
                                                 FrameIncrementPointer => { GRP => "0028", ELEM => "0009", VR => "AT" },
                                                 FrameDimensionPointer => { GRP => "0028", ELEM => "000A", VR => "AT" },
                                                                  Rows => { GRP => "0028", ELEM => "0010", VR => "US" },
                                                               Columns => { GRP => "0028", ELEM => "0011", VR => "US" },
                                            UltrasoundColorDataPresent => { GRP => "0028", ELEM => "0014", VR => "US" },
                                                          PixelSpacing => { GRP => "0028", ELEM => "0030", VR => "DS" },
                                                            ZoomFactor => { GRP => "0028", ELEM => "0031", VR => "DS" },
                                                            ZoomCenter => { GRP => "0028", ELEM => "0032", VR => "DS" },
                                                      PixelAspectRatio => { GRP => "0028", ELEM => "0034", VR => "IS" },
                                                        CorrectedImage => { GRP => "0028", ELEM => "0051", VR => "CS" },
                                                         BitsAllocated => { GRP => "0028", ELEM => "0100", VR => "US" },
                                                            BitsStored => { GRP => "0028", ELEM => "0101", VR => "US" },
                                                               HighBit => { GRP => "0028", ELEM => "0102", VR => "US" },
                                                   PixelRepresentation => { GRP => "0028", ELEM => "0103", VR => "US" },
                                               SmallestImagePixelValue => { GRP => "0028", ELEM => "0106", VR => "xs" },
                                                LargestImagePixelValue => { GRP => "0028", ELEM => "0107", VR => "xs" },
                                            SmallestPixelValueInSeries => { GRP => "0028", ELEM => "0108", VR => "xs" },
                                             LargestPixelValueInSeries => { GRP => "0028", ELEM => "0109", VR => "xs" },
                                                     PixelPaddingValue => { GRP => "0028", ELEM => "0120", VR => "xs" },
                                                PixelPaddingRangeLimit => { GRP => "0028", ELEM => "0121", VR => "xs" },
                                                   QualityControlImage => { GRP => "0028", ELEM => "0300", VR => "CS" },
                                                    BurnedInAnnotation => { GRP => "0028", ELEM => "0301", VR => "CS" },
                                           PixelSpacingCalibrationType => { GRP => "0028", ELEM => "0A02", VR => "CS" },
                                    PixelSpacingCalibrationDescription => { GRP => "0028", ELEM => "0A04", VR => "LO" },
                                            PixelIntensityRelationship => { GRP => "0028", ELEM => "1040", VR => "CS" },
                                        PixelIntensityRelationshipSign => { GRP => "0028", ELEM => "1041", VR => "SS" },
                                                          WindowCenter => { GRP => "0028", ELEM => "1050", VR => "DS" },
                                                           WindowWidth => { GRP => "0028", ELEM => "1051", VR => "DS" },
                                                      RescaleIntercept => { GRP => "0028", ELEM => "1052", VR => "DS" },
                                                          RescaleSlope => { GRP => "0028", ELEM => "1053", VR => "DS" },
                                                           RescaleType => { GRP => "0028", ELEM => "1054", VR => "LO" },
                                          WindowCenterWidthExplanation => { GRP => "0028", ELEM => "1055", VR => "LO" },
                                                        VOILUTFunction => { GRP => "0028", ELEM => "1056", VR => "CS" },
                                                RecommendedViewingMode => { GRP => "0028", ELEM => "1090", VR => "CS" },
                                  RedPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1101", VR => "xs" },
                                GreenPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1102", VR => "xs" },
                                 BluePaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1103", VR => "xs" },
                                            PaletteColorLookupTableUID => { GRP => "0028", ELEM => "1199", VR => "UI" },
                                        RedPaletteColorLookupTableData => { GRP => "0028", ELEM => "1201", VR => "OW" },
                                      GreenPaletteColorLookupTableData => { GRP => "0028", ELEM => "1202", VR => "OW" },
                                       BluePaletteColorLookupTableData => { GRP => "0028", ELEM => "1203", VR => "OW" },
                               SegmentedRedPaletteColorLookupTableData => { GRP => "0028", ELEM => "1221", VR => "OW" },
                             SegmentedGreenPaletteColorLookupTableData => { GRP => "0028", ELEM => "1222", VR => "OW" },
                              SegmentedBluePaletteColorLookupTableData => { GRP => "0028", ELEM => "1223", VR => "OW" },
                                                        ImplantPresent => { GRP => "0028", ELEM => "1300", VR => "CS" },
                                                           PartialView => { GRP => "0028", ELEM => "1350", VR => "CS" },
                                                PartialViewDescription => { GRP => "0028", ELEM => "1351", VR => "ST" },
                                               PartialViewCodeSequence => { GRP => "0028", ELEM => "1352", VR => "SQ" },
                                             SpatialLocationsPreserved => { GRP => "0028", ELEM => "135A", VR => "CS" },
                                                            ICCProfile => { GRP => "0028", ELEM => "2000", VR => "OB" },
                                                 LossyImageCompression => { GRP => "0028", ELEM => "2110", VR => "CS" },
                                            LossyImageCompressionRatio => { GRP => "0028", ELEM => "2112", VR => "DS" },
                                           LossyImageCompressionMethod => { GRP => "0028", ELEM => "2114", VR => "CS" },
                                                   ModalityLUTSequence => { GRP => "0028", ELEM => "3000", VR => "SQ" },
                                                         LUTDescriptor => { GRP => "0028", ELEM => "3002", VR => "xs" },
                                                        LUTExplanation => { GRP => "0028", ELEM => "3003", VR => "LO" },
                                                       ModalityLUTType => { GRP => "0028", ELEM => "3004", VR => "LO" },
                                                               LUTData => { GRP => "0028", ELEM => "3006", VR => "lt" },
                                                        VOILUTSequence => { GRP => "0028", ELEM => "3010", VR => "SQ" },
                                                SoftcopyVOILUTSequence => { GRP => "0028", ELEM => "3110", VR => "SQ" },
                                             RepresentativeFrameNumber => { GRP => "0028", ELEM => "6010", VR => "US" },
                                             FrameNumbersOfInterestFOI => { GRP => "0028", ELEM => "6020", VR => "US" },
                                           FramesOfInterestDescription => { GRP => "0028", ELEM => "6022", VR => "LO" },
                                                   FrameOfInterestType => { GRP => "0028", ELEM => "6023", VR => "CS" },
                                                          RWavePointer => { GRP => "0028", ELEM => "6040", VR => "US" },
                                               MaskSubtractionSequence => { GRP => "0028", ELEM => "6100", VR => "SQ" },
                                                         MaskOperation => { GRP => "0028", ELEM => "6101", VR => "CS" },
                                                  ApplicableFrameRange => { GRP => "0028", ELEM => "6102", VR => "US" },
                                                      MaskFrameNumbers => { GRP => "0028", ELEM => "6110", VR => "US" },
                                                ContrastFrameAveraging => { GRP => "0028", ELEM => "6112", VR => "US" },
                                                     MaskSubPixelShift => { GRP => "0028", ELEM => "6114", VR => "FL" },
                                                             TIDOffset => { GRP => "0028", ELEM => "6120", VR => "SS" },
                                              MaskOperationExplanation => { GRP => "0028", ELEM => "6190", VR => "ST" },
                                                  PixelDataProviderURL => { GRP => "0028", ELEM => "7FE0", VR => "UT" },
                                                         DataPointRows => { GRP => "0028", ELEM => "9001", VR => "UL" },
                                                      DataPointColumns => { GRP => "0028", ELEM => "9002", VR => "UL" },
                                                   SignalDomainColumns => { GRP => "0028", ELEM => "9003", VR => "CS" },
                                                    DataRepresentation => { GRP => "0028", ELEM => "9108", VR => "CS" },
                                                 PixelMeasuresSequence => { GRP => "0028", ELEM => "9110", VR => "SQ" },
                                                   FrameVOILUTSequence => { GRP => "0028", ELEM => "9132", VR => "SQ" },
                                      PixelValueTransformationSequence => { GRP => "0028", ELEM => "9145", VR => "SQ" },
                                                      SignalDomainRows => { GRP => "0028", ELEM => "9235", VR => "CS" },
                                               DisplayFilterPercentage => { GRP => "0028", ELEM => "9411", VR => "FL" },
                                               FramePixelShiftSequence => { GRP => "0028", ELEM => "9415", VR => "SQ" },
                                                     SubtractionItemID => { GRP => "0028", ELEM => "9416", VR => "US" },
                                 PixelIntensityRelationshipLUTSequence => { GRP => "0028", ELEM => "9422", VR => "SQ" },
                                      FramePixelDataPropertiesSequence => { GRP => "0028", ELEM => "9443", VR => "SQ" },
                                                 GeometricalProperties => { GRP => "0028", ELEM => "9444", VR => "CS" },
                                            GeometricMaximumDistortion => { GRP => "0028", ELEM => "9445", VR => "FL" },
                                                ImageProcessingApplied => { GRP => "0028", ELEM => "9446", VR => "CS" },
                                                     MaskSelectionMode => { GRP => "0028", ELEM => "9454", VR => "CS" },
                                                           LUTFunction => { GRP => "0028", ELEM => "9474", VR => "CS" },
                                         ImageToEquipmentMappingMatrix => { GRP => "0028", ELEM => "9520", VR => "DS" },
                               EquipmentCoordinateSystemIdentification => { GRP => "0028", ELEM => "9537", VR => "CS" },
                             RequestingPhysicianIdentificationSequence => { GRP => "0032", ELEM => "1031", VR => "SQ" },
                                                   RequestingPhysician => { GRP => "0032", ELEM => "1032", VR => "PN" },
                                                     RequestingService => { GRP => "0032", ELEM => "1033", VR => "LO" },
                                         RequestedProcedureDescription => { GRP => "0032", ELEM => "1060", VR => "LO" },
                                        RequestedProcedureCodeSequence => { GRP => "0032", ELEM => "1064", VR => "SQ" },
                                                RequestedContrastAgent => { GRP => "0032", ELEM => "1070", VR => "LO" },
                                        ReferencedPatientAliasSequence => { GRP => "0038", ELEM => "0004", VR => "SQ" },
                                                         VisitStatusID => { GRP => "0038", ELEM => "0008", VR => "CS" },
                                                           AdmissionID => { GRP => "0038", ELEM => "0010", VR => "LO" },
                                                   IssuerOfAdmissionID => { GRP => "0038", ELEM => "0011", VR => "LO" },
                                                     RouteOfAdmissions => { GRP => "0038", ELEM => "0016", VR => "LO" },
                                                         AdmittingDate => { GRP => "0038", ELEM => "0020", VR => "DA" },
                                                         AdmittingTime => { GRP => "0038", ELEM => "0021", VR => "TM" },
                                                          SpecialNeeds => { GRP => "0038", ELEM => "0050", VR => "LO" },
                                                      ServiceEpisodeID => { GRP => "0038", ELEM => "0060", VR => "LO" },
                                              IssuerOfServiceEpisodeID => { GRP => "0038", ELEM => "0061", VR => "LO" },
                                             ServiceEpisodeDescription => { GRP => "0038", ELEM => "0062", VR => "LO" },
                                            PertinentDocumentsSequence => { GRP => "0038", ELEM => "0100", VR => "SQ" },
                                                CurrentPatientLocation => { GRP => "0038", ELEM => "0300", VR => "LO" },
                                          PatientsInstitutionResidence => { GRP => "0038", ELEM => "0400", VR => "LO" },
                                                          PatientState => { GRP => "0038", ELEM => "0500", VR => "LO" },
                             PatientClinicalTrialParticipationSequence => { GRP => "0038", ELEM => "0502", VR => "SQ" },
                                                         VisitComments => { GRP => "0038", ELEM => "4000", VR => "LT" },
                                                   WaveformOriginality => { GRP => "003A", ELEM => "0004", VR => "CS" },
                                              NumberOfWaveformChannels => { GRP => "003A", ELEM => "0005", VR => "US" },
                                               NumberOfWaveformSamples => { GRP => "003A", ELEM => "0010", VR => "UL" },
                                                     SamplingFrequency => { GRP => "003A", ELEM => "001A", VR => "DS" },
                                                   MultiplexGroupLabel => { GRP => "003A", ELEM => "0020", VR => "SH" },
                                             ChannelDefinitionSequence => { GRP => "003A", ELEM => "0200", VR => "SQ" },
                                                 WaveformChannelNumber => { GRP => "003A", ELEM => "0202", VR => "IS" },
                                                          ChannelLabel => { GRP => "003A", ELEM => "0203", VR => "SH" },
                                                         ChannelStatus => { GRP => "003A", ELEM => "0205", VR => "CS" },
                                                 ChannelSourceSequence => { GRP => "003A", ELEM => "0208", VR => "SQ" },
                                        ChannelSourceModifiersSequence => { GRP => "003A", ELEM => "0209", VR => "SQ" },
                                                SourceWaveformSequence => { GRP => "003A", ELEM => "020A", VR => "SQ" },
                                          ChannelDerivationDescription => { GRP => "003A", ELEM => "020C", VR => "LO" },
                                                    ChannelSensitivity => { GRP => "003A", ELEM => "0210", VR => "DS" },
                                       ChannelSensitivityUnitsSequence => { GRP => "003A", ELEM => "0211", VR => "SQ" },
                                    ChannelSensitivityCorrectionFactor => { GRP => "003A", ELEM => "0212", VR => "DS" },
                                                       ChannelBaseline => { GRP => "003A", ELEM => "0213", VR => "DS" },
                                                       ChannelTimeSkew => { GRP => "003A", ELEM => "0214", VR => "DS" },
                                                     ChannelSampleSkew => { GRP => "003A", ELEM => "0215", VR => "DS" },
                                                         ChannelOffset => { GRP => "003A", ELEM => "0218", VR => "DS" },
                                                    WaveformBitsStored => { GRP => "003A", ELEM => "021A", VR => "US" },
                                                    FilterLowFrequency => { GRP => "003A", ELEM => "0220", VR => "DS" },
                                                   FilterHighFrequency => { GRP => "003A", ELEM => "0221", VR => "DS" },
                                                  NotchFilterFrequency => { GRP => "003A", ELEM => "0222", VR => "DS" },
                                                  NotchFilterBandwidth => { GRP => "003A", ELEM => "0223", VR => "DS" },
                                              WaveformDataDisplayScale => { GRP => "003A", ELEM => "0230", VR => "FL" },
                                  WaveformDisplayBackgroundCIELabValue => { GRP => "003A", ELEM => "0231", VR => "US" },
                                     WaveformPresentationGroupSequence => { GRP => "003A", ELEM => "0240", VR => "SQ" },
                                               PresentationGroupNumber => { GRP => "003A", ELEM => "0241", VR => "US" },
                                                ChannelDisplaySequence => { GRP => "003A", ELEM => "0242", VR => "SQ" },
                                  ChannelRecommendedDisplayCIELabValue => { GRP => "003A", ELEM => "0244", VR => "US" },
                                                       ChannelPosition => { GRP => "003A", ELEM => "0245", VR => "FL" },
                                                    DisplayShadingFlag => { GRP => "003A", ELEM => "0246", VR => "CS" },
                                         FractionalChannelDisplayScale => { GRP => "003A", ELEM => "0247", VR => "FL" },
                                           AbsoluteChannelDisplayScale => { GRP => "003A", ELEM => "0248", VR => "FL" },
                       MultiplexedAudioChannelsDescriptionCodeSequence => { GRP => "003A", ELEM => "0300", VR => "SQ" },
                                             ChannelIdentificationCode => { GRP => "003A", ELEM => "0301", VR => "IS" },
                                                           ChannelMode => { GRP => "003A", ELEM => "0302", VR => "CS" },
                                               ScheduledStationAETitle => { GRP => "0040", ELEM => "0001", VR => "AE" },
                                       ScheduledProcedureStepStartDate => { GRP => "0040", ELEM => "0002", VR => "DA" },
                                       ScheduledProcedureStepStartTime => { GRP => "0040", ELEM => "0003", VR => "TM" },
                                         ScheduledProcedureStepEndDate => { GRP => "0040", ELEM => "0004", VR => "DA" },
                                         ScheduledProcedureStepEndTime => { GRP => "0040", ELEM => "0005", VR => "TM" },
                                     ScheduledPerformingPhysiciansName => { GRP => "0040", ELEM => "0006", VR => "PN" },
                                     ScheduledProcedureStepDescription => { GRP => "0040", ELEM => "0007", VR => "LO" },
                                         ScheduledProtocolCodeSequence => { GRP => "0040", ELEM => "0008", VR => "SQ" },
                                              ScheduledProcedureStepID => { GRP => "0040", ELEM => "0009", VR => "SH" },
                                                     StageCodeSequence => { GRP => "0040", ELEM => "000A", VR => "SQ" },
                    ScheduledPerformingPhysicianIdentificationSequence => { GRP => "0040", ELEM => "000B", VR => "SQ" },
                                                  ScheduledStationName => { GRP => "0040", ELEM => "0010", VR => "SH" },
                                        ScheduledProcedureStepLocation => { GRP => "0040", ELEM => "0011", VR => "SH" },
                                                         PreMedication => { GRP => "0040", ELEM => "0012", VR => "LO" },
                                          ScheduledProcedureStepStatus => { GRP => "0040", ELEM => "0020", VR => "CS" },
                                        ScheduledProcedureStepSequence => { GRP => "0040", ELEM => "0100", VR => "SQ" },
                        ReferencedNonImageCompositeSOPInstanceSequence => { GRP => "0040", ELEM => "0220", VR => "SQ" },
                                               PerformedStationAETitle => { GRP => "0040", ELEM => "0241", VR => "AE" },
                                                  PerformedStationName => { GRP => "0040", ELEM => "0242", VR => "SH" },
                                                     PerformedLocation => { GRP => "0040", ELEM => "0243", VR => "SH" },
                                       PerformedProcedureStepStartDate => { GRP => "0040", ELEM => "0244", VR => "DA" },
                                       PerformedProcedureStepStartTime => { GRP => "0040", ELEM => "0245", VR => "TM" },
                                         PerformedProcedureStepEndDate => { GRP => "0040", ELEM => "0250", VR => "DA" },
                                         PerformedProcedureStepEndTime => { GRP => "0040", ELEM => "0251", VR => "TM" },
                                          PerformedProcedureStepStatus => { GRP => "0040", ELEM => "0252", VR => "CS" },
                                              PerformedProcedureStepID => { GRP => "0040", ELEM => "0253", VR => "SH" },
                                     PerformedProcedureStepDescription => { GRP => "0040", ELEM => "0254", VR => "LO" },
                                     PerformedProcedureTypeDescription => { GRP => "0040", ELEM => "0255", VR => "LO" },
                                         PerformedProtocolCodeSequence => { GRP => "0040", ELEM => "0260", VR => "SQ" },
                                       ScheduledStepAttributesSequence => { GRP => "0040", ELEM => "0270", VR => "SQ" },
                                             RequestAttributesSequence => { GRP => "0040", ELEM => "0275", VR => "SQ" },
                                   CommentsOnThePerformedProcedureStep => { GRP => "0040", ELEM => "0280", VR => "ST" },
               PerformedProcedureStepDiscontinuationReasonCodeSequence => { GRP => "0040", ELEM => "0281", VR => "SQ" },
                                                      QuantitySequence => { GRP => "0040", ELEM => "0293", VR => "SQ" },
                                                              Quantity => { GRP => "0040", ELEM => "0294", VR => "DS" },
                                                MeasuringUnitsSequence => { GRP => "0040", ELEM => "0295", VR => "SQ" },
                                                   BillingItemSequence => { GRP => "0040", ELEM => "0296", VR => "SQ" },
                                                TotalTimeOfFluoroscopy => { GRP => "0040", ELEM => "0300", VR => "US" },
                                                TotalNumberOfExposures => { GRP => "0040", ELEM => "0301", VR => "US" },
                                                          EntranceDose => { GRP => "0040", ELEM => "0302", VR => "US" },
                                                           ExposedArea => { GRP => "0040", ELEM => "0303", VR => "US" },
                                              DistanceSourceToEntrance => { GRP => "0040", ELEM => "0306", VR => "DS" },
                                                  ExposureDoseSequence => { GRP => "0040", ELEM => "030E", VR => "SQ" },
                                               CommentsOnRadiationDose => { GRP => "0040", ELEM => "0310", VR => "ST" },
                                                            XRayOutput => { GRP => "0040", ELEM => "0312", VR => "DS" },
                                                        HalfValueLayer => { GRP => "0040", ELEM => "0314", VR => "DS" },
                                                             OrganDose => { GRP => "0040", ELEM => "0316", VR => "DS" },
                                                          OrganExposed => { GRP => "0040", ELEM => "0318", VR => "CS" },
                                          BillingProcedureStepSequence => { GRP => "0040", ELEM => "0320", VR => "SQ" },
                                               FilmConsumptionSequence => { GRP => "0040", ELEM => "0321", VR => "SQ" },
                                     BillingSuppliesAndDevicesSequence => { GRP => "0040", ELEM => "0324", VR => "SQ" },
                                               PerformedSeriesSequence => { GRP => "0040", ELEM => "0340", VR => "SQ" },
                                   CommentsOnTheScheduledProcedureStep => { GRP => "0040", ELEM => "0400", VR => "LT" },
                                               ProtocolContextSequence => { GRP => "0040", ELEM => "0440", VR => "SQ" },
                                           ContentItemModifierSequence => { GRP => "0040", ELEM => "0441", VR => "SQ" },
                                               SpecimenAccessionNumber => { GRP => "0040", ELEM => "050A", VR => "LO" },
                                                      SpecimenSequence => { GRP => "0040", ELEM => "0550", VR => "SQ" },
                                                    SpecimenIdentifier => { GRP => "0040", ELEM => "0551", VR => "LO" },
                                            AcquisitionContextSequence => { GRP => "0040", ELEM => "0555", VR => "SQ" },
                                         AcquisitionContextDescription => { GRP => "0040", ELEM => "0556", VR => "ST" },
                                              SpecimenTypeCodeSequence => { GRP => "0040", ELEM => "059A", VR => "SQ" },
                                                       SlideIdentifier => { GRP => "0040", ELEM => "06FA", VR => "LO" },
                                   ImageCenterPointCoordinatesSequence => { GRP => "0040", ELEM => "071A", VR => "SQ" },
                                        XOffsetInSlideCoordinateSystem => { GRP => "0040", ELEM => "072A", VR => "DS" },
                                        YOffsetInSlideCoordinateSystem => { GRP => "0040", ELEM => "073A", VR => "DS" },
                                        ZOffsetInSlideCoordinateSystem => { GRP => "0040", ELEM => "074A", VR => "DS" },
                                                  PixelSpacingSequence => { GRP => "0040", ELEM => "08D8", VR => "SQ" },
                                      CoordinateSystemAxisCodeSequence => { GRP => "0040", ELEM => "08DA", VR => "SQ" },
                                          MeasurementUnitsCodeSequence => { GRP => "0040", ELEM => "08EA", VR => "SQ" },
                                                  RequestedProcedureID => { GRP => "0040", ELEM => "1001", VR => "SH" },
                                        ReasonForTheRequestedProcedure => { GRP => "0040", ELEM => "1002", VR => "LO" },
                                            RequestedProcedurePriority => { GRP => "0040", ELEM => "1003", VR => "SH" },
                                          PatientTransportArrangements => { GRP => "0040", ELEM => "1004", VR => "LO" },
                                            RequestedProcedureLocation => { GRP => "0040", ELEM => "1005", VR => "LO" },
                                                   ConfidentialityCode => { GRP => "0040", ELEM => "1008", VR => "LO" },
                                                     ReportingPriority => { GRP => "0040", ELEM => "1009", VR => "SH" },
                               ReasonForRequestedProcedureCodeSequence => { GRP => "0040", ELEM => "100A", VR => "SQ" },
                                    NamesOfIntendedRecipientsOfResults => { GRP => "0040", ELEM => "1010", VR => "PN" },
                     IntendedRecipientsOfResultsIdentificationSequence => { GRP => "0040", ELEM => "1011", VR => "SQ" },
                                      PersonIdentificationCodeSequence => { GRP => "0040", ELEM => "1101", VR => "SQ" },
                                                        PersonsAddress => { GRP => "0040", ELEM => "1102", VR => "ST" },
                                               PersonsTelephoneNumbers => { GRP => "0040", ELEM => "1103", VR => "LO" },
                                            RequestedProcedureComments => { GRP => "0040", ELEM => "1400", VR => "LT" },
                                      IssueDateOfImagingServiceRequest => { GRP => "0040", ELEM => "2004", VR => "DA" },
                                      IssueTimeOfImagingServiceRequest => { GRP => "0040", ELEM => "2005", VR => "TM" },
                                                        OrderEnteredBy => { GRP => "0040", ELEM => "2008", VR => "PN" },
                                                 OrderEnterersLocation => { GRP => "0040", ELEM => "2009", VR => "SH" },
                                              OrderCallbackPhoneNumber => { GRP => "0040", ELEM => "2010", VR => "SH" },
                                PlacerOrderNumberImagingServiceRequest => { GRP => "0040", ELEM => "2016", VR => "LO" },
                                FillerOrderNumberImagingServiceRequest => { GRP => "0040", ELEM => "2017", VR => "LO" },
                                         ImagingServiceRequestComments => { GRP => "0040", ELEM => "2400", VR => "LT" },
                     ConfidentialityConstraintOnPatientDataDescription => { GRP => "0040", ELEM => "3001", VR => "LO" },
                            GeneralPurposeScheduledProcedureStepStatus => { GRP => "0040", ELEM => "4001", VR => "CS" },
                            GeneralPurposePerformedProcedureStepStatus => { GRP => "0040", ELEM => "4002", VR => "CS" },
                          GeneralPurposeScheduledProcedureStepPriority => { GRP => "0040", ELEM => "4003", VR => "CS" },
                           ScheduledProcessingApplicationsCodeSequence => { GRP => "0040", ELEM => "4004", VR => "SQ" },
                                ScheduledProcedureStepStartDateAndTime => { GRP => "0040", ELEM => "4005", VR => "DT" },
                                                    MultipleCopiesFlag => { GRP => "0040", ELEM => "4006", VR => "CS" },
                           PerformedProcessingApplicationsCodeSequence => { GRP => "0040", ELEM => "4007", VR => "SQ" },
                                            HumanPerformerCodeSequence => { GRP => "0040", ELEM => "4009", VR => "SQ" },
                         ScheduledProcedureStepModificationDateAndTime => { GRP => "0040", ELEM => "4010", VR => "DT" },
                                         ExpectedCompletionDateAndTime => { GRP => "0040", ELEM => "4011", VR => "DT" },
                ResultingGeneralPurposePerformedProcedureStepsSequence => { GRP => "0040", ELEM => "4015", VR => "SQ" },
                ReferencedGeneralPurposeScheduledProcedureStepSequence => { GRP => "0040", ELEM => "4016", VR => "SQ" },
                                         ScheduledWorkitemCodeSequence => { GRP => "0040", ELEM => "4018", VR => "SQ" },
                                         PerformedWorkitemCodeSequence => { GRP => "0040", ELEM => "4019", VR => "SQ" },
                                                 InputAvailabilityFlag => { GRP => "0040", ELEM => "4020", VR => "CS" },
                                              InputInformationSequence => { GRP => "0040", ELEM => "4021", VR => "SQ" },
                                           RelevantInformationSequence => { GRP => "0040", ELEM => "4022", VR => "SQ" },
          ReferencedGeneralPurposeScheduledProcedureStepTransactionUID => { GRP => "0040", ELEM => "4023", VR => "UI" },
                                      ScheduledStationNameCodeSequence => { GRP => "0040", ELEM => "4025", VR => "SQ" },
                                     ScheduledStationClassCodeSequence => { GRP => "0040", ELEM => "4026", VR => "SQ" },
                        ScheduledStationGeographicLocationCodeSequence => { GRP => "0040", ELEM => "4027", VR => "SQ" },
                                      PerformedStationNameCodeSequence => { GRP => "0040", ELEM => "4028", VR => "SQ" },
                                     PerformedStationClassCodeSequence => { GRP => "0040", ELEM => "4029", VR => "SQ" },
                        PerformedStationGeographicLocationCodeSequence => { GRP => "0040", ELEM => "4030", VR => "SQ" },
                               RequestedSubsequentWorkitemCodeSequence => { GRP => "0040", ELEM => "4031", VR => "SQ" },
                                            NonDICOMOutputCodeSequence => { GRP => "0040", ELEM => "4032", VR => "SQ" },
                                             OutputInformationSequence => { GRP => "0040", ELEM => "4033", VR => "SQ" },
                                      ScheduledHumanPerformersSequence => { GRP => "0040", ELEM => "4034", VR => "SQ" },
                                         ActualHumanPerformersSequence => { GRP => "0040", ELEM => "4035", VR => "SQ" },
                                           HumanPerformersOrganization => { GRP => "0040", ELEM => "4036", VR => "LO" },
                                                   HumanPerformersName => { GRP => "0040", ELEM => "4037", VR => "PN" },
                                                     EntranceDoseInMGy => { GRP => "0040", ELEM => "8302", VR => "DS" },
                          ReferencedImageRealWorldValueMappingSequence => { GRP => "0040", ELEM => "9094", VR => "SQ" },
                                         RealWorldValueMappingSequence => { GRP => "0040", ELEM => "9096", VR => "SQ" },
                                         PixelValueMappingCodeSequence => { GRP => "0040", ELEM => "9098", VR => "SQ" },
                                                              LUTLabel => { GRP => "0040", ELEM => "9210", VR => "SH" },
                                         RealWorldValueLastValueMapped => { GRP => "0040", ELEM => "9211", VR => "xs" },
                                                 RealWorldValueLUTData => { GRP => "0040", ELEM => "9212", VR => "FD" },
                                        RealWorldValueFirstValueMapped => { GRP => "0040", ELEM => "9216", VR => "xs" },
                                               RealWorldValueIntercept => { GRP => "0040", ELEM => "9224", VR => "FD" },
                                                   RealWorldValueSlope => { GRP => "0040", ELEM => "9225", VR => "FD" },
                                                      RelationshipType => { GRP => "0040", ELEM => "A010", VR => "CS" },
                                                 VerifyingOrganization => { GRP => "0040", ELEM => "A027", VR => "LO" },
                                                  VerificationDateTime => { GRP => "0040", ELEM => "A030", VR => "DT" },
                                                   ObservationDateTime => { GRP => "0040", ELEM => "A032", VR => "DT" },
                                                             ValueType => { GRP => "0040", ELEM => "A040", VR => "CS" },
                                               ConceptNameCodeSequence => { GRP => "0040", ELEM => "A043", VR => "SQ" },
                                                   ContinuityOfContent => { GRP => "0040", ELEM => "A050", VR => "CS" },
                                             VerifyingObserverSequence => { GRP => "0040", ELEM => "A073", VR => "SQ" },
                                                 VerifyingObserverName => { GRP => "0040", ELEM => "A075", VR => "PN" },
                                                AuthorObserverSequence => { GRP => "0040", ELEM => "A078", VR => "SQ" },
                                                   ParticipantSequence => { GRP => "0040", ELEM => "A07A", VR => "SQ" },
                                         CustodialOrganizationSequence => { GRP => "0040", ELEM => "A07C", VR => "SQ" },
                                                     ParticipationType => { GRP => "0040", ELEM => "A080", VR => "CS" },
                                                 ParticipationDateTime => { GRP => "0040", ELEM => "A082", VR => "DT" },
                                                          ObserverType => { GRP => "0040", ELEM => "A084", VR => "CS" },
                           VerifyingObserverIdentificationCodeSequence => { GRP => "0040", ELEM => "A088", VR => "SQ" },
                                            ReferencedWaveformChannels => { GRP => "0040", ELEM => "A0B0", VR => "US" },
                                                              DateTime => { GRP => "0040", ELEM => "A120", VR => "DT" },
                                                                  Date => { GRP => "0040", ELEM => "A121", VR => "DA" },
                                                                  Time => { GRP => "0040", ELEM => "A122", VR => "TM" },
                                                            PersonName => { GRP => "0040", ELEM => "A123", VR => "PN" },
                                                                   UID => { GRP => "0040", ELEM => "A124", VR => "UI" },
                                                     TemporalRangeType => { GRP => "0040", ELEM => "A130", VR => "CS" },
                                             ReferencedSamplePositions => { GRP => "0040", ELEM => "A132", VR => "UL" },
                                                ReferencedFrameNumbers => { GRP => "0040", ELEM => "A136", VR => "US" },
                                                 ReferencedTimeOffsets => { GRP => "0040", ELEM => "A138", VR => "DS" },
                                                    ReferencedDateTime => { GRP => "0040", ELEM => "A13A", VR => "DT" },
                                                             TextValue => { GRP => "0040", ELEM => "A160", VR => "UT" },
                                                   ConceptCodeSequence => { GRP => "0040", ELEM => "A168", VR => "SQ" },
                                        PurposeOfReferenceCodeSequence => { GRP => "0040", ELEM => "A170", VR => "SQ" },
                                                 AnnotationGroupNumber => { GRP => "0040", ELEM => "A180", VR => "US" },
                                                  ModifierCodeSequence => { GRP => "0040", ELEM => "A195", VR => "SQ" },
                                                 MeasuredValueSequence => { GRP => "0040", ELEM => "A300", VR => "SQ" },
                                     NumericValueQualifierCodeSequence => { GRP => "0040", ELEM => "A301", VR => "SQ" },
                                                          NumericValue => { GRP => "0040", ELEM => "A30A", VR => "DS" },
                                          PredecessorDocumentsSequence => { GRP => "0040", ELEM => "A360", VR => "SQ" },
                                             ReferencedRequestSequence => { GRP => "0040", ELEM => "A370", VR => "SQ" },
                                        PerformedProcedureCodeSequence => { GRP => "0040", ELEM => "A372", VR => "SQ" },
                             CurrentRequestedProcedureEvidenceSequence => { GRP => "0040", ELEM => "A375", VR => "SQ" },
                                        PertinentOtherEvidenceSequence => { GRP => "0040", ELEM => "A385", VR => "SQ" },
                                HL7StructuredDocumentReferenceSequence => { GRP => "0040", ELEM => "A390", VR => "SQ" },
                                                        CompletionFlag => { GRP => "0040", ELEM => "A491", VR => "CS" },
                                             CompletionFlagDescription => { GRP => "0040", ELEM => "A492", VR => "LO" },
                                                      VerificationFlag => { GRP => "0040", ELEM => "A493", VR => "CS" },
                                                      ArchiveRequested => { GRP => "0040", ELEM => "A494", VR => "CS" },
                                               ContentTemplateSequence => { GRP => "0040", ELEM => "A504", VR => "SQ" },
                                            IdenticalDocumentsSequence => { GRP => "0040", ELEM => "A525", VR => "SQ" },
                                                       ContentSequence => { GRP => "0040", ELEM => "A730", VR => "SQ" },
                                            WaveformAnnotationSequence => { GRP => "0040", ELEM => "B020", VR => "SQ" },
                                                    TemplateIdentifier => { GRP => "0040", ELEM => "DB00", VR => "CS" },
                                       ReferencedContentItemIdentifier => { GRP => "0040", ELEM => "DB73", VR => "UL" },
                                                 HL7InstanceIdentifier => { GRP => "0040", ELEM => "E001", VR => "ST" },
                                              HL7DocumentEffectiveTime => { GRP => "0040", ELEM => "E004", VR => "DT" },
                                           HL7DocumentTypeCodeSequence => { GRP => "0040", ELEM => "E006", VR => "SQ" },
                                                           RetrieveURI => { GRP => "0040", ELEM => "E010", VR => "UT" },
                                                         DocumentTitle => { GRP => "0042", ELEM => "0010", VR => "ST" },
                                                  EncapsulatedDocument => { GRP => "0042", ELEM => "0011", VR => "OB" },
                                        MIMETypeOfEncapsulatedDocument => { GRP => "0042", ELEM => "0012", VR => "LO" },
                                                SourceInstanceSequence => { GRP => "0042", ELEM => "0013", VR => "SQ" },
                                                       ListOfMIMETypes => { GRP => "0042", ELEM => "0014", VR => "LO" },
                                              ProductPackageIdentifier => { GRP => "0044", ELEM => "0001", VR => "ST" },
                                       SubstanceAdministrationApproval => { GRP => "0044", ELEM => "0002", VR => "CS" },
                                      ApprovalStatusFurtherDescription => { GRP => "0044", ELEM => "0003", VR => "LT" },
                                                ApprovalStatusDateTime => { GRP => "0044", ELEM => "0004", VR => "DT" },
                                               ProductTypeCodeSequence => { GRP => "0044", ELEM => "0007", VR => "SQ" },
                                                           ProductName => { GRP => "0044", ELEM => "0008", VR => "LO" },
                                                    ProductDescription => { GRP => "0044", ELEM => "0009", VR => "LT" },
                                                  ProductLotIdentifier => { GRP => "0044", ELEM => "000A", VR => "LO" },
                                             ProductExpirationDateTime => { GRP => "0044", ELEM => "000B", VR => "DT" },
                                       SubstanceAdministrationDateTime => { GRP => "0044", ELEM => "0010", VR => "DT" },
                                          SubstanceAdministrationNotes => { GRP => "0044", ELEM => "0011", VR => "LO" },
                                       SubstanceAdministrationDeviceID => { GRP => "0044", ELEM => "0012", VR => "LO" },
                                              ProductParameterSequence => { GRP => "0044", ELEM => "0013", VR => "SQ" },
                              SubstanceAdministrationParameterSequence => { GRP => "0044", ELEM => "0019", VR => "SQ" },
                                                      CalibrationImage => { GRP => "0050", ELEM => "0004", VR => "CS" },
                                                        DeviceSequence => { GRP => "0050", ELEM => "0010", VR => "SQ" },
                                                          DeviceLength => { GRP => "0050", ELEM => "0014", VR => "DS" },
                                                        DeviceDiameter => { GRP => "0050", ELEM => "0016", VR => "DS" },
                                                   DeviceDiameterUnits => { GRP => "0050", ELEM => "0017", VR => "CS" },
                                                          DeviceVolume => { GRP => "0050", ELEM => "0018", VR => "DS" },
                                                   IntermarkerDistance => { GRP => "0050", ELEM => "0019", VR => "DS" },
                                                     DeviceDescription => { GRP => "0050", ELEM => "0020", VR => "LO" },
                                                    EnergyWindowVector => { GRP => "0054", ELEM => "0010", VR => "US" },
                                                 NumberOfEnergyWindows => { GRP => "0054", ELEM => "0011", VR => "US" },
                                       EnergyWindowInformationSequence => { GRP => "0054", ELEM => "0012", VR => "SQ" },
                                             EnergyWindowRangeSequence => { GRP => "0054", ELEM => "0013", VR => "SQ" },
                                                EnergyWindowLowerLimit => { GRP => "0054", ELEM => "0014", VR => "DS" },
                                                EnergyWindowUpperLimit => { GRP => "0054", ELEM => "0015", VR => "DS" },
                                RadiopharmaceuticalInformationSequence => { GRP => "0054", ELEM => "0016", VR => "SQ" },
                                                 ResidualSyringeCounts => { GRP => "0054", ELEM => "0017", VR => "IS" },
                                                      EnergyWindowName => { GRP => "0054", ELEM => "0018", VR => "SH" },
                                                        DetectorVector => { GRP => "0054", ELEM => "0020", VR => "US" },
                                                     NumberOfDetectors => { GRP => "0054", ELEM => "0021", VR => "US" },
                                           DetectorInformationSequence => { GRP => "0054", ELEM => "0022", VR => "SQ" },
                                                           PhaseVector => { GRP => "0054", ELEM => "0030", VR => "US" },
                                                        NumberOfPhases => { GRP => "0054", ELEM => "0031", VR => "US" },
                                              PhaseInformationSequence => { GRP => "0054", ELEM => "0032", VR => "SQ" },
                                                 NumberOfFramesInPhase => { GRP => "0054", ELEM => "0033", VR => "US" },
                                                            PhaseDelay => { GRP => "0054", ELEM => "0036", VR => "IS" },
                                                    PauseBetweenFrames => { GRP => "0054", ELEM => "0038", VR => "IS" },
                                                      PhaseDescription => { GRP => "0054", ELEM => "0039", VR => "CS" },
                                                        RotationVector => { GRP => "0054", ELEM => "0050", VR => "US" },
                                                     NumberOfRotations => { GRP => "0054", ELEM => "0051", VR => "US" },
                                           RotationInformationSequence => { GRP => "0054", ELEM => "0052", VR => "SQ" },
                                              NumberOfFramesInRotation => { GRP => "0054", ELEM => "0053", VR => "US" },
                                                      RRIntervalVector => { GRP => "0054", ELEM => "0060", VR => "US" },
                                                   NumberOfRRIntervals => { GRP => "0054", ELEM => "0061", VR => "US" },
                                              GatedInformationSequence => { GRP => "0054", ELEM => "0062", VR => "SQ" },
                                               DataInformationSequence => { GRP => "0054", ELEM => "0063", VR => "SQ" },
                                                        TimeSlotVector => { GRP => "0054", ELEM => "0070", VR => "US" },
                                                     NumberOfTimeSlots => { GRP => "0054", ELEM => "0071", VR => "US" },
                                           TimeSlotInformationSequence => { GRP => "0054", ELEM => "0072", VR => "SQ" },
                                                          TimeSlotTime => { GRP => "0054", ELEM => "0073", VR => "DS" },
                                                           SliceVector => { GRP => "0054", ELEM => "0080", VR => "US" },
                                                        NumberOfSlices => { GRP => "0054", ELEM => "0081", VR => "US" },
                                                     AngularViewVector => { GRP => "0054", ELEM => "0090", VR => "US" },
                                                       TimeSliceVector => { GRP => "0054", ELEM => "0100", VR => "US" },
                                                    NumberOfTimeSlices => { GRP => "0054", ELEM => "0101", VR => "US" },
                                                            StartAngle => { GRP => "0054", ELEM => "0200", VR => "DS" },
                                                  TypeOfDetectorMotion => { GRP => "0054", ELEM => "0202", VR => "CS" },
                                                         TriggerVector => { GRP => "0054", ELEM => "0210", VR => "IS" },
                                               NumberOfTriggersInPhase => { GRP => "0054", ELEM => "0211", VR => "US" },
                                                      ViewCodeSequence => { GRP => "0054", ELEM => "0220", VR => "SQ" },
                                              ViewModifierCodeSequence => { GRP => "0054", ELEM => "0222", VR => "SQ" },
                                              RadionuclideCodeSequence => { GRP => "0054", ELEM => "0300", VR => "SQ" },
                                       AdministrationRouteCodeSequence => { GRP => "0054", ELEM => "0302", VR => "SQ" },
                                       RadiopharmaceuticalCodeSequence => { GRP => "0054", ELEM => "0304", VR => "SQ" },
                                               CalibrationDataSequence => { GRP => "0054", ELEM => "0306", VR => "SQ" },
                                                    EnergyWindowNumber => { GRP => "0054", ELEM => "0308", VR => "US" },
                                                               ImageID => { GRP => "0054", ELEM => "0400", VR => "SH" },
                                        PatientOrientationCodeSequence => { GRP => "0054", ELEM => "0410", VR => "SQ" },
                                PatientOrientationModifierCodeSequence => { GRP => "0054", ELEM => "0412", VR => "SQ" },
                                 PatientGantryRelationshipCodeSequence => { GRP => "0054", ELEM => "0414", VR => "SQ" },
                                             SliceProgressionDirection => { GRP => "0054", ELEM => "0500", VR => "CS" },
                                                            SeriesType => { GRP => "0054", ELEM => "1000", VR => "CS" },
                                                                 Units => { GRP => "0054", ELEM => "1001", VR => "CS" },
                                                          CountsSource => { GRP => "0054", ELEM => "1002", VR => "CS" },
                                                    ReprojectionMethod => { GRP => "0054", ELEM => "1004", VR => "CS" },
                                               RandomsCorrectionMethod => { GRP => "0054", ELEM => "1100", VR => "CS" },
                                           AttenuationCorrectionMethod => { GRP => "0054", ELEM => "1101", VR => "LO" },
                                                       DecayCorrection => { GRP => "0054", ELEM => "1102", VR => "CS" },
                                                  ReconstructionMethod => { GRP => "0054", ELEM => "1103", VR => "LO" },
                                           DetectorLinesOfResponseUsed => { GRP => "0054", ELEM => "1104", VR => "LO" },
                                               ScatterCorrectionMethod => { GRP => "0054", ELEM => "1105", VR => "LO" },
                                                       AxialAcceptance => { GRP => "0054", ELEM => "1200", VR => "DS" },
                                                             AxialMash => { GRP => "0054", ELEM => "1201", VR => "IS" },
                                                        TransverseMash => { GRP => "0054", ELEM => "1202", VR => "IS" },
                                                   DetectorElementSize => { GRP => "0054", ELEM => "1203", VR => "DS" },
                                                CoincidenceWindowWidth => { GRP => "0054", ELEM => "1210", VR => "DS" },
                                                   SecondaryCountsType => { GRP => "0054", ELEM => "1220", VR => "CS" },
                                                    FrameReferenceTime => { GRP => "0054", ELEM => "1300", VR => "DS" },
                                       PrimaryPromptsCountsAccumulated => { GRP => "0054", ELEM => "1310", VR => "IS" },
                                            SecondaryCountsAccumulated => { GRP => "0054", ELEM => "1311", VR => "IS" },
                                                SliceSensitivityFactor => { GRP => "0054", ELEM => "1320", VR => "DS" },
                                                           DecayFactor => { GRP => "0054", ELEM => "1321", VR => "DS" },
                                                 DoseCalibrationFactor => { GRP => "0054", ELEM => "1322", VR => "DS" },
                                                 ScatterFractionFactor => { GRP => "0054", ELEM => "1323", VR => "DS" },
                                                        DeadTimeFactor => { GRP => "0054", ELEM => "1324", VR => "DS" },
                                                            ImageIndex => { GRP => "0054", ELEM => "1330", VR => "US" },
                                                     HistogramSequence => { GRP => "0060", ELEM => "3000", VR => "SQ" },
                                                 HistogramNumberOfBins => { GRP => "0060", ELEM => "3002", VR => "US" },
                                                HistogramFirstBinValue => { GRP => "0060", ELEM => "3004", VR => "xs" },
                                                 HistogramLastBinValue => { GRP => "0060", ELEM => "3006", VR => "xs" },
                                                     HistogramBinWidth => { GRP => "0060", ELEM => "3008", VR => "US" },
                                                  HistogramExplanation => { GRP => "0060", ELEM => "3010", VR => "LO" },
                                                         HistogramData => { GRP => "0060", ELEM => "3020", VR => "UL" },
                                                      SegmentationType => { GRP => "0062", ELEM => "0001", VR => "CS" },
                                                       SegmentSequence => { GRP => "0062", ELEM => "0002", VR => "SQ" },
                                 SegmentedPropertyCategoryCodeSequence => { GRP => "0062", ELEM => "0003", VR => "SQ" },
                                                         SegmentNumber => { GRP => "0062", ELEM => "0004", VR => "US" },
                                                          SegmentLabel => { GRP => "0062", ELEM => "0005", VR => "LO" },
                                                    SegmentDescription => { GRP => "0062", ELEM => "0006", VR => "ST" },
                                                  SegmentAlgorithmType => { GRP => "0062", ELEM => "0008", VR => "CS" },
                                                  SegmentAlgorithmName => { GRP => "0062", ELEM => "0009", VR => "LO" },
                                         SegmentIdentificationSequence => { GRP => "0062", ELEM => "000A", VR => "SQ" },
                                               ReferencedSegmentNumber => { GRP => "0062", ELEM => "000B", VR => "US" },
                                      RecommendedDisplayGrayscaleValue => { GRP => "0062", ELEM => "000C", VR => "US" },
                                         RecommendedDisplayCIELabValue => { GRP => "0062", ELEM => "000D", VR => "US" },
                                                MaximumFractionalValue => { GRP => "0062", ELEM => "000E", VR => "US" },
                                     SegmentedPropertyTypeCodeSequence => { GRP => "0062", ELEM => "000F", VR => "SQ" },
                                            SegmentationFractionalType => { GRP => "0062", ELEM => "0010", VR => "CS" },
                                        DeformableRegistrationSequence => { GRP => "0064", ELEM => "0002", VR => "SQ" },
                                             SourceFrameOfReferenceUID => { GRP => "0064", ELEM => "0003", VR => "UI" },
                                    DeformableRegistrationGridSequence => { GRP => "0064", ELEM => "0005", VR => "SQ" },
                                                        GridDimensions => { GRP => "0064", ELEM => "0007", VR => "UL" },
                                                        GridResolution => { GRP => "0064", ELEM => "0008", VR => "FD" },
                                                        VectorGridData => { GRP => "0064", ELEM => "0009", VR => "OF" },
                              PreDeformationMatrixRegistrationSequence => { GRP => "0064", ELEM => "000F", VR => "SQ" },
                             PostDeformationMatrixRegistrationSequence => { GRP => "0064", ELEM => "0010", VR => "SQ" },
                                             GraphicAnnotationSequence => { GRP => "0070", ELEM => "0001", VR => "SQ" },
                                                          GraphicLayer => { GRP => "0070", ELEM => "0002", VR => "CS" },
                                            BoundingBoxAnnotationUnits => { GRP => "0070", ELEM => "0003", VR => "CS" },
                                            AnchorPointAnnotationUnits => { GRP => "0070", ELEM => "0004", VR => "CS" },
                                                GraphicAnnotationUnits => { GRP => "0070", ELEM => "0005", VR => "CS" },
                                                  UnformattedTextValue => { GRP => "0070", ELEM => "0006", VR => "ST" },
                                                    TextObjectSequence => { GRP => "0070", ELEM => "0008", VR => "SQ" },
                                                 GraphicObjectSequence => { GRP => "0070", ELEM => "0009", VR => "SQ" },
                                          BoundingBoxTopLeftHandCorner => { GRP => "0070", ELEM => "0010", VR => "FL" },
                                      BoundingBoxBottomRightHandCorner => { GRP => "0070", ELEM => "0011", VR => "FL" },
                                BoundingBoxTextHorizontalJustification => { GRP => "0070", ELEM => "0012", VR => "CS" },
                                                           AnchorPoint => { GRP => "0070", ELEM => "0014", VR => "FL" },
                                                 AnchorPointVisibility => { GRP => "0070", ELEM => "0015", VR => "CS" },
                                                     GraphicDimensions => { GRP => "0070", ELEM => "0020", VR => "US" },
                                                 NumberOfGraphicPoints => { GRP => "0070", ELEM => "0021", VR => "US" },
                                                           GraphicData => { GRP => "0070", ELEM => "0022", VR => "FL" },
                                                           GraphicType => { GRP => "0070", ELEM => "0023", VR => "CS" },
                                                         GraphicFilled => { GRP => "0070", ELEM => "0024", VR => "CS" },
                                                   ImageHorizontalFlip => { GRP => "0070", ELEM => "0041", VR => "CS" },
                                                         ImageRotation => { GRP => "0070", ELEM => "0042", VR => "US" },
                                        DisplayedAreaTopLeftHandCorner => { GRP => "0070", ELEM => "0052", VR => "SL" },
                                    DisplayedAreaBottomRightHandCorner => { GRP => "0070", ELEM => "0053", VR => "SL" },
                                        DisplayedAreaSelectionSequence => { GRP => "0070", ELEM => "005A", VR => "SQ" },
                                                  GraphicLayerSequence => { GRP => "0070", ELEM => "0060", VR => "SQ" },
                                                     GraphicLayerOrder => { GRP => "0070", ELEM => "0062", VR => "IS" },
                          GraphicLayerRecommendedDisplayGrayscaleValue => { GRP => "0070", ELEM => "0066", VR => "US" },
                                               GraphicLayerDescription => { GRP => "0070", ELEM => "0068", VR => "LO" },
                                                          ContentLabel => { GRP => "0070", ELEM => "0080", VR => "CS" },
                                                    ContentDescription => { GRP => "0070", ELEM => "0081", VR => "LO" },
                                              PresentationCreationDate => { GRP => "0070", ELEM => "0082", VR => "DA" },
                                              PresentationCreationTime => { GRP => "0070", ELEM => "0083", VR => "TM" },
                                                   ContentCreatorsName => { GRP => "0070", ELEM => "0084", VR => "PN" },
                             ContentCreatorsIdentificationCodeSequence => { GRP => "0070", ELEM => "0086", VR => "SQ" },
                                                  PresentationSizeMode => { GRP => "0070", ELEM => "0100", VR => "CS" },
                                              PresentationPixelSpacing => { GRP => "0070", ELEM => "0101", VR => "DS" },
                                          PresentationPixelAspectRatio => { GRP => "0070", ELEM => "0102", VR => "IS" },
                                   PresentationPixelMagnificationRatio => { GRP => "0070", ELEM => "0103", VR => "FL" },
                                                             ShapeType => { GRP => "0070", ELEM => "0306", VR => "CS" },
                                                  RegistrationSequence => { GRP => "0070", ELEM => "0308", VR => "SQ" },
                                            MatrixRegistrationSequence => { GRP => "0070", ELEM => "0309", VR => "SQ" },
                                                        MatrixSequence => { GRP => "0070", ELEM => "030A", VR => "SQ" },
                              FrameOfReferenceTransformationMatrixType => { GRP => "0070", ELEM => "030C", VR => "CS" },
                                          RegistrationTypeCodeSequence => { GRP => "0070", ELEM => "030D", VR => "SQ" },
                                                   FiducialDescription => { GRP => "0070", ELEM => "030F", VR => "ST" },
                                                    FiducialIdentifier => { GRP => "0070", ELEM => "0310", VR => "SH" },
                                        FiducialIdentifierCodeSequence => { GRP => "0070", ELEM => "0311", VR => "SQ" },
                                              ContourUncertaintyRadius => { GRP => "0070", ELEM => "0312", VR => "FD" },
                                                 UsedFiducialsSequence => { GRP => "0070", ELEM => "0314", VR => "SQ" },
                                        GraphicCoordinatesDataSequence => { GRP => "0070", ELEM => "0318", VR => "SQ" },
                                                           FiducialUID => { GRP => "0070", ELEM => "031A", VR => "UI" },
                                                   FiducialSetSequence => { GRP => "0070", ELEM => "031C", VR => "SQ" },
                                                      FiducialSequence => { GRP => "0070", ELEM => "031E", VR => "SQ" },
                             GraphicLayerRecommendedDisplayCIELabValue => { GRP => "0070", ELEM => "0401", VR => "US" },
                                                      BlendingSequence => { GRP => "0070", ELEM => "0402", VR => "SQ" },
                                                       RelativeOpacity => { GRP => "0070", ELEM => "0403", VR => "FL" },
                                 ReferencedSpatialRegistrationSequence => { GRP => "0070", ELEM => "0404", VR => "SQ" },
                                                      BlendingPosition => { GRP => "0070", ELEM => "0405", VR => "CS" },
                                                   HangingProtocolName => { GRP => "0072", ELEM => "0002", VR => "SH" },
                                            HangingProtocolDescription => { GRP => "0072", ELEM => "0004", VR => "LO" },
                                                  HangingProtocolLevel => { GRP => "0072", ELEM => "0006", VR => "CS" },
                                                HangingProtocolCreator => { GRP => "0072", ELEM => "0008", VR => "LO" },
                                       HangingProtocolCreationDateTime => { GRP => "0072", ELEM => "000A", VR => "DT" },
                                     HangingProtocolDefinitionSequence => { GRP => "0072", ELEM => "000C", VR => "SQ" },
                         HangingProtocolUserIdentificationCodeSequence => { GRP => "0072", ELEM => "000E", VR => "SQ" },
                                          HangingProtocolUserGroupName => { GRP => "0072", ELEM => "0010", VR => "LO" },
                                         SourceHangingProtocolSequence => { GRP => "0072", ELEM => "0012", VR => "SQ" },
                                              NumberOfPriorsReferenced => { GRP => "0072", ELEM => "0014", VR => "US" },
                                                     ImageSetsSequence => { GRP => "0072", ELEM => "0020", VR => "SQ" },
                                              ImageSetSelectorSequence => { GRP => "0072", ELEM => "0022", VR => "SQ" },
                                             ImageSetSelectorUsageFlag => { GRP => "0072", ELEM => "0024", VR => "CS" },
                                                     SelectorAttribute => { GRP => "0072", ELEM => "0026", VR => "AT" },
                                                   SelectorValueNumber => { GRP => "0072", ELEM => "0028", VR => "US" },
                                            TimeBasedImageSetsSequence => { GRP => "0072", ELEM => "0030", VR => "SQ" },
                                                        ImageSetNumber => { GRP => "0072", ELEM => "0032", VR => "US" },
                                              ImageSetSelectorCategory => { GRP => "0072", ELEM => "0034", VR => "CS" },
                                                          RelativeTime => { GRP => "0072", ELEM => "0038", VR => "US" },
                                                     RelativeTimeUnits => { GRP => "0072", ELEM => "003A", VR => "CS" },
                                                    AbstractPriorValue => { GRP => "0072", ELEM => "003C", VR => "SS" },
                                             AbstractPriorCodeSequence => { GRP => "0072", ELEM => "003E", VR => "SQ" },
                                                         ImageSetLabel => { GRP => "0072", ELEM => "0040", VR => "LO" },
                                                   SelectorAttributeVR => { GRP => "0072", ELEM => "0050", VR => "CS" },
                                               SelectorSequencePointer => { GRP => "0072", ELEM => "0052", VR => "AT" },
                                 SelectorSequencePointerPrivateCreator => { GRP => "0072", ELEM => "0054", VR => "LO" },
                                       SelectorAttributePrivateCreator => { GRP => "0072", ELEM => "0056", VR => "LO" },
                                                       SelectorATValue => { GRP => "0072", ELEM => "0060", VR => "AT" },
                                                       SelectorCSValue => { GRP => "0072", ELEM => "0062", VR => "CS" },
                                                       SelectorISValue => { GRP => "0072", ELEM => "0064", VR => "IS" },
                                                       SelectorLOValue => { GRP => "0072", ELEM => "0066", VR => "LO" },
                                                       SelectorLTValue => { GRP => "0072", ELEM => "0068", VR => "LT" },
                                                       SelectorPNValue => { GRP => "0072", ELEM => "006A", VR => "PN" },
                                                       SelectorSHValue => { GRP => "0072", ELEM => "006C", VR => "SH" },
                                                       SelectorSTValue => { GRP => "0072", ELEM => "006E", VR => "ST" },
                                                       SelectorUTValue => { GRP => "0072", ELEM => "0070", VR => "UT" },
                                                       SelectorDSValue => { GRP => "0072", ELEM => "0072", VR => "DS" },
                                                       SelectorFDValue => { GRP => "0072", ELEM => "0074", VR => "FD" },
                                                       SelectorFLValue => { GRP => "0072", ELEM => "0076", VR => "FL" },
                                                       SelectorULValue => { GRP => "0072", ELEM => "0078", VR => "UL" },
                                                       SelectorUSValue => { GRP => "0072", ELEM => "007A", VR => "US" },
                                                       SelectorSLValue => { GRP => "0072", ELEM => "007C", VR => "SL" },
                                                       SelectorSSValue => { GRP => "0072", ELEM => "007E", VR => "SS" },
                                             SelectorCodeSequenceValue => { GRP => "0072", ELEM => "0080", VR => "SQ" },
                                                       NumberOfScreens => { GRP => "0072", ELEM => "0100", VR => "US" },
                                       NominalScreenDefinitionSequence => { GRP => "0072", ELEM => "0102", VR => "SQ" },
                                                NumberOfVerticalPixels => { GRP => "0072", ELEM => "0104", VR => "US" },
                                              NumberOfHorizontalPixels => { GRP => "0072", ELEM => "0106", VR => "US" },
                                     DisplayEnvironmentSpatialPosition => { GRP => "0072", ELEM => "0108", VR => "FD" },
                                        ScreenMinimumGrayscaleBitDepth => { GRP => "0072", ELEM => "010A", VR => "US" },
                                            ScreenMinimumColorBitDepth => { GRP => "0072", ELEM => "010C", VR => "US" },
                                         ApplicationMaximumRepaintTime => { GRP => "0072", ELEM => "010E", VR => "US" },
                                                   DisplaySetsSequence => { GRP => "0072", ELEM => "0200", VR => "SQ" },
                                                      DisplaySetNumber => { GRP => "0072", ELEM => "0202", VR => "US" },
                                                       DisplaySetLabel => { GRP => "0072", ELEM => "0203", VR => "LO" },
                                           DisplaySetPresentationGroup => { GRP => "0072", ELEM => "0204", VR => "US" },
                                DisplaySetPresentationGroupDescription => { GRP => "0072", ELEM => "0206", VR => "LO" },
                                            PartialDataDisplayHandling => { GRP => "0072", ELEM => "0208", VR => "CS" },
                                         SynchronizedScrollingSequence => { GRP => "0072", ELEM => "0210", VR => "SQ" },
                                              DisplaySetScrollingGroup => { GRP => "0072", ELEM => "0212", VR => "US" },
                                           NavigationIndicatorSequence => { GRP => "0072", ELEM => "0214", VR => "SQ" },
                                                  NavigationDisplaySet => { GRP => "0072", ELEM => "0216", VR => "US" },
                                                  ReferenceDisplaySets => { GRP => "0072", ELEM => "0218", VR => "US" },
                                                    ImageBoxesSequence => { GRP => "0072", ELEM => "0300", VR => "SQ" },
                                                        ImageBoxNumber => { GRP => "0072", ELEM => "0302", VR => "US" },
                                                    ImageBoxLayoutType => { GRP => "0072", ELEM => "0304", VR => "CS" },
                                       ImageBoxTileHorizontalDimension => { GRP => "0072", ELEM => "0306", VR => "US" },
                                         ImageBoxTileVerticalDimension => { GRP => "0072", ELEM => "0308", VR => "US" },
                                               ImageBoxScrollDirection => { GRP => "0072", ELEM => "0310", VR => "CS" },
                                               ImageBoxSmallScrollType => { GRP => "0072", ELEM => "0312", VR => "CS" },
                                             ImageBoxSmallScrollAmount => { GRP => "0072", ELEM => "0314", VR => "US" },
                                               ImageBoxLargeScrollType => { GRP => "0072", ELEM => "0316", VR => "CS" },
                                             ImageBoxLargeScrollAmount => { GRP => "0072", ELEM => "0318", VR => "US" },
                                               ImageBoxOverlapPriority => { GRP => "0072", ELEM => "0320", VR => "US" },
                                                CineRelativeToRealTime => { GRP => "0072", ELEM => "0330", VR => "FD" },
                                              FilterOperationsSequence => { GRP => "0072", ELEM => "0400", VR => "SQ" },
                                                      FilterByCategory => { GRP => "0072", ELEM => "0402", VR => "CS" },
                                             FilterByAttributePresence => { GRP => "0072", ELEM => "0404", VR => "CS" },
                                                      FilterByOperator => { GRP => "0072", ELEM => "0406", VR => "CS" },
                                                 BlendingOperationType => { GRP => "0072", ELEM => "0500", VR => "CS" },
                                             ReformattingOperationType => { GRP => "0072", ELEM => "0510", VR => "CS" },
                                                 ReformattingThickness => { GRP => "0072", ELEM => "0512", VR => "FD" },
                                                  ReformattingInterval => { GRP => "0072", ELEM => "0514", VR => "FD" },
                             ReformattingOperationInitialViewDirection => { GRP => "0072", ELEM => "0516", VR => "CS" },
# starts with '3'                                      3DRenderingType => { GRP => "0072", ELEM => "0520", VR => "CS" },
                                             SortingOperationsSequence => { GRP => "0072", ELEM => "0600", VR => "SQ" },
                                                        SortByCategory => { GRP => "0072", ELEM => "0602", VR => "CS" },
                                                      SortingDirection => { GRP => "0072", ELEM => "0604", VR => "CS" },
                                          DisplaySetPatientOrientation => { GRP => "0072", ELEM => "0700", VR => "CS" },
                                                               VOIType => { GRP => "0072", ELEM => "0702", VR => "CS" },
                                                       PseudoColorType => { GRP => "0072", ELEM => "0704", VR => "CS" },
                                                 ShowGrayscaleInverted => { GRP => "0072", ELEM => "0706", VR => "CS" },
                                                 ShowImageTrueSizeFlag => { GRP => "0072", ELEM => "0710", VR => "CS" },
                                             ShowGraphicAnnotationFlag => { GRP => "0072", ELEM => "0712", VR => "CS" },
                                           ShowPatientDemographicsFlag => { GRP => "0072", ELEM => "0714", VR => "CS" },
                                         ShowAcquisitionTechniquesFlag => { GRP => "0072", ELEM => "0716", VR => "CS" },
                                     DisplaySetHorizontalJustification => { GRP => "0072", ELEM => "0717", VR => "CS" },
                                       DisplaySetVerticalJustification => { GRP => "0072", ELEM => "0718", VR => "CS" },
                                             UnifiedProcedureStepState => { GRP => "0074", ELEM => "1000", VR => "CS" },
                                        UPSProgressInformationSequence => { GRP => "0074", ELEM => "1002", VR => "SQ" },
                                          UnifiedProcedureStepProgress => { GRP => "0074", ELEM => "1004", VR => "DS" },
                               UnifiedProcedureStepProgressDescription => { GRP => "0074", ELEM => "1006", VR => "ST" },
                         UnifiedProcedureStepCommunicationsURISequence => { GRP => "0074", ELEM => "1008", VR => "SQ" },
                                                            ContactURI => { GRP => "0074", ELEM => "100A", VR => "ST" },
                                                    ContactDisplayName => { GRP => "0074", ELEM => "100C", VR => "LO" },
                 UnifiedProcedureStepDiscontinuationReasonCodeSequence => { GRP => "0074", ELEM => "100E", VR => "SQ" },
                                                      BeamTaskSequence => { GRP => "0074", ELEM => "1020", VR => "SQ" },
                                                          BeamTaskType => { GRP => "0074", ELEM => "1022", VR => "CS" },
                                                        BeamOrderIndex => { GRP => "0074", ELEM => "1024", VR => "IS" },
                                     DeliveryVerificationImageSequence => { GRP => "0074", ELEM => "1030", VR => "SQ" },
                                               VerificationImageTiming => { GRP => "0074", ELEM => "1032", VR => "CS" },
                                                    DoubleExposureFlag => { GRP => "0074", ELEM => "1034", VR => "CS" },
                                                DoubleExposureOrdering => { GRP => "0074", ELEM => "1036", VR => "CS" },
                                                DoubleExposureMeterset => { GRP => "0074", ELEM => "1038", VR => "DS" },
                                              DoubleExposureFieldDelta => { GRP => "0074", ELEM => "103A", VR => "DS" },
                                       RelatedReferenceRTImageSequence => { GRP => "0074", ELEM => "1040", VR => "SQ" },
                                    GeneralMachineVerificationSequence => { GRP => "0074", ELEM => "1042", VR => "SQ" },
                               ConventionalMachineVerificationSequence => { GRP => "0074", ELEM => "1044", VR => "SQ" },
                                        IonMachineVerificationSequence => { GRP => "0074", ELEM => "1046", VR => "SQ" },
                                              FailedAttributesSequence => { GRP => "0074", ELEM => "1048", VR => "SQ" },
                                          OverriddenAttributesSequence => { GRP => "0074", ELEM => "104A", VR => "SQ" },
                          ConventionalControlPointVerificationSequence => { GRP => "0074", ELEM => "104C", VR => "SQ" },
                                   IonControlPointVerificationSequence => { GRP => "0074", ELEM => "104E", VR => "SQ" },
                                           AttributeOccurrenceSequence => { GRP => "0074", ELEM => "1050", VR => "SQ" },
                                            AttributeOccurrencePointer => { GRP => "0074", ELEM => "1052", VR => "AT" },
                                                 AttributeItemSelector => { GRP => "0074", ELEM => "1054", VR => "UL" },
                                     AttributeOccurrencePrivateCreator => { GRP => "0074", ELEM => "1056", VR => "LO" },
                                        ScheduledProcedureStepPriority => { GRP => "0074", ELEM => "1200", VR => "CS" },
                                                         WorklistLabel => { GRP => "0074", ELEM => "1202", VR => "LO" },
                                                    ProcedureStepLabel => { GRP => "0074", ELEM => "1204", VR => "LO" },
                                 ScheduledProcessingParametersSequence => { GRP => "0074", ELEM => "1210", VR => "SQ" },
                                 PerformedProcessingParametersSequence => { GRP => "0074", ELEM => "1212", VR => "SQ" },
                                         UPSPerformedProcedureSequence => { GRP => "0074", ELEM => "1216", VR => "SQ" },
                                          RelatedProcedureStepSequence => { GRP => "0074", ELEM => "1220", VR => "SQ" },
                                         ProcedureStepRelationshipType => { GRP => "0074", ELEM => "1222", VR => "LO" },
                                                          DeletionLock => { GRP => "0074", ELEM => "1230", VR => "LO" },
                                                           ReceivingAE => { GRP => "0074", ELEM => "1234", VR => "AE" },
                                                          RequestingAE => { GRP => "0074", ELEM => "1236", VR => "AE" },
                                                 ReasonForCancellation => { GRP => "0074", ELEM => "1238", VR => "LT" },
                                                             SCPStatus => { GRP => "0074", ELEM => "1242", VR => "CS" },
                                                SubscriptionListStatus => { GRP => "0074", ELEM => "1244", VR => "CS" },
                                                         UPSListStatus => { GRP => "0074", ELEM => "1246", VR => "CS" },
                                                 StorageMediaFileSetID => { GRP => "0088", ELEM => "0130", VR => "SH" },
                                                StorageMediaFileSetUID => { GRP => "0088", ELEM => "0140", VR => "UI" },
                                                     IconImageSequence => { GRP => "0088", ELEM => "0200", VR => "SQ" },
                                                     SOPInstanceStatus => { GRP => "0100", ELEM => "0410", VR => "CS" },
                                           SOPAuthorizationDateAndTime => { GRP => "0100", ELEM => "0420", VR => "DT" },
                                               SOPAuthorizationComment => { GRP => "0100", ELEM => "0424", VR => "LT" },
                             AuthorizationEquipmentCertificationNumber => { GRP => "0100", ELEM => "0426", VR => "LO" },
                                                           MACIDNumber => { GRP => "0400", ELEM => "0005", VR => "US" },
                                       MACCalculationTransferSyntaxUID => { GRP => "0400", ELEM => "0010", VR => "UI" },
                                                          MACAlgorithm => { GRP => "0400", ELEM => "0015", VR => "CS" },
                                                    DataElementsSigned => { GRP => "0400", ELEM => "0020", VR => "AT" },
                                                   DigitalSignatureUID => { GRP => "0400", ELEM => "0100", VR => "UI" },
                                              DigitalSignatureDateTime => { GRP => "0400", ELEM => "0105", VR => "DT" },
                                                       CertificateType => { GRP => "0400", ELEM => "0110", VR => "CS" },
                                                   CertificateOfSigner => { GRP => "0400", ELEM => "0115", VR => "OB" },
                                                             Signature => { GRP => "0400", ELEM => "0120", VR => "OB" },
                                                CertifiedTimestampType => { GRP => "0400", ELEM => "0305", VR => "CS" },
                                                    CertifiedTimestamp => { GRP => "0400", ELEM => "0310", VR => "OB" },
                                   DigitalSignaturePurposeCodeSequence => { GRP => "0400", ELEM => "0401", VR => "SQ" },
                                    ReferencedDigitalSignatureSequence => { GRP => "0400", ELEM => "0402", VR => "SQ" },
                                      ReferencedSOPInstanceMACSequence => { GRP => "0400", ELEM => "0403", VR => "SQ" },
                                                                   MAC => { GRP => "0400", ELEM => "0404", VR => "OB" },
                                           EncryptedAttributesSequence => { GRP => "0400", ELEM => "0500", VR => "SQ" },
                                     EncryptedContentTransferSyntaxUID => { GRP => "0400", ELEM => "0510", VR => "UI" },
                                                      EncryptedContent => { GRP => "0400", ELEM => "0520", VR => "OB" },
                                            ModifiedAttributesSequence => { GRP => "0400", ELEM => "0550", VR => "SQ" },
                                            OriginalAttributesSequence => { GRP => "0400", ELEM => "0561", VR => "SQ" },
                                         AttributeModificationDateTime => { GRP => "0400", ELEM => "0562", VR => "DT" },
                                                       ModifyingSystem => { GRP => "0400", ELEM => "0563", VR => "LO" },
                                                SourceOfPreviousValues => { GRP => "0400", ELEM => "0564", VR => "LO" },
                                     ReasonForTheAttributeModification => { GRP => "0400", ELEM => "0565", VR => "CS" },
                                                        NumberOfCopies => { GRP => "2000", ELEM => "0010", VR => "IS" },
                                          PrinterConfigurationSequence => { GRP => "2000", ELEM => "001E", VR => "SQ" },
                                                         PrintPriority => { GRP => "2000", ELEM => "0020", VR => "CS" },
                                                            MediumType => { GRP => "2000", ELEM => "0030", VR => "CS" },
                                                       FilmDestination => { GRP => "2000", ELEM => "0040", VR => "CS" },
                                                      FilmSessionLabel => { GRP => "2000", ELEM => "0050", VR => "LO" },
                                                      MemoryAllocation => { GRP => "2000", ELEM => "0060", VR => "IS" },
                                               MaximumMemoryAllocation => { GRP => "2000", ELEM => "0061", VR => "IS" },
                                                        MemoryBitDepth => { GRP => "2000", ELEM => "00A0", VR => "US" },
                                                      PrintingBitDepth => { GRP => "2000", ELEM => "00A1", VR => "US" },
                                                MediaInstalledSequence => { GRP => "2000", ELEM => "00A2", VR => "SQ" },
                                           OtherMediaAvailableSequence => { GRP => "2000", ELEM => "00A4", VR => "SQ" },
                                  SupportedImageDisplayFormatsSequence => { GRP => "2000", ELEM => "00A8", VR => "SQ" },
                                             ReferencedFilmBoxSequence => { GRP => "2000", ELEM => "0500", VR => "SQ" },
                                                    ImageDisplayFormat => { GRP => "2010", ELEM => "0010", VR => "ST" },
                                             AnnotationDisplayFormatID => { GRP => "2010", ELEM => "0030", VR => "CS" },
                                                       FilmOrientation => { GRP => "2010", ELEM => "0040", VR => "CS" },
                                                            FilmSizeID => { GRP => "2010", ELEM => "0050", VR => "CS" },
                                                   PrinterResolutionID => { GRP => "2010", ELEM => "0052", VR => "CS" },
                                            DefaultPrinterResolutionID => { GRP => "2010", ELEM => "0054", VR => "CS" },
                                                     MagnificationType => { GRP => "2010", ELEM => "0060", VR => "CS" },
                                                         SmoothingType => { GRP => "2010", ELEM => "0080", VR => "CS" },
                                              DefaultMagnificationType => { GRP => "2010", ELEM => "00A6", VR => "CS" },
                                      OtherMagnificationTypesAvailable => { GRP => "2010", ELEM => "00A7", VR => "CS" },
                                                  DefaultSmoothingType => { GRP => "2010", ELEM => "00A8", VR => "CS" },
                                          OtherSmoothingTypesAvailable => { GRP => "2010", ELEM => "00A9", VR => "CS" },
                                                         BorderDensity => { GRP => "2010", ELEM => "0100", VR => "CS" },
                                                     EmptyImageDensity => { GRP => "2010", ELEM => "0110", VR => "CS" },
                                                            MinDensity => { GRP => "2010", ELEM => "0120", VR => "US" },
                                                            MaxDensity => { GRP => "2010", ELEM => "0130", VR => "US" },
                                                                  Trim => { GRP => "2010", ELEM => "0140", VR => "CS" },
                                              ConfigurationInformation => { GRP => "2010", ELEM => "0150", VR => "ST" },
                                   ConfigurationInformationDescription => { GRP => "2010", ELEM => "0152", VR => "LT" },
                                                  MaximumCollatedFilms => { GRP => "2010", ELEM => "0154", VR => "IS" },
                                                          Illumination => { GRP => "2010", ELEM => "015E", VR => "US" },
                                                 ReflectedAmbientLight => { GRP => "2010", ELEM => "0160", VR => "US" },
                                                   PrinterPixelSpacing => { GRP => "2010", ELEM => "0376", VR => "DS" },
                                         ReferencedFilmSessionSequence => { GRP => "2010", ELEM => "0500", VR => "SQ" },
                                            ReferencedImageBoxSequence => { GRP => "2010", ELEM => "0510", VR => "SQ" },
                                  ReferencedBasicAnnotationBoxSequence => { GRP => "2010", ELEM => "0520", VR => "SQ" },
                                                      ImageBoxPosition => { GRP => "2020", ELEM => "0010", VR => "US" },
                                                              Polarity => { GRP => "2020", ELEM => "0020", VR => "CS" },
                                                    RequestedImageSize => { GRP => "2020", ELEM => "0030", VR => "DS" },
                                         RequestedDecimateCropBehavior => { GRP => "2020", ELEM => "0040", VR => "CS" },
                                                 RequestedResolutionID => { GRP => "2020", ELEM => "0050", VR => "CS" },
                                                RequestedImageSizeFlag => { GRP => "2020", ELEM => "00A0", VR => "CS" },
                                                    DecimateCropResult => { GRP => "2020", ELEM => "00A2", VR => "CS" },
                                           BasicGrayscaleImageSequence => { GRP => "2020", ELEM => "0110", VR => "SQ" },
                                               BasicColorImageSequence => { GRP => "2020", ELEM => "0111", VR => "SQ" },
                                                    AnnotationPosition => { GRP => "2030", ELEM => "0010", VR => "US" },
                                                            TextString => { GRP => "2030", ELEM => "0020", VR => "LO" },
                                               PresentationLUTSequence => { GRP => "2050", ELEM => "0010", VR => "SQ" },
                                                  PresentationLUTShape => { GRP => "2050", ELEM => "0020", VR => "CS" },
                                     ReferencedPresentationLUTSequence => { GRP => "2050", ELEM => "0500", VR => "SQ" },
                                                       ExecutionStatus => { GRP => "2100", ELEM => "0020", VR => "CS" },
                                                   ExecutionStatusInfo => { GRP => "2100", ELEM => "0030", VR => "CS" },
                                                          CreationDate => { GRP => "2100", ELEM => "0040", VR => "DA" },
                                                          CreationTime => { GRP => "2100", ELEM => "0050", VR => "TM" },
                                                            Originator => { GRP => "2100", ELEM => "0070", VR => "AE" },
                                                               OwnerID => { GRP => "2100", ELEM => "0160", VR => "SH" },
                                                         NumberOfFilms => { GRP => "2100", ELEM => "0170", VR => "IS" },
                                                         PrinterStatus => { GRP => "2110", ELEM => "0010", VR => "CS" },
                                                     PrinterStatusInfo => { GRP => "2110", ELEM => "0020", VR => "CS" },
                                                           PrinterName => { GRP => "2110", ELEM => "0030", VR => "LO" },
                           LabelUsingInformationExtractedFromInstances => { GRP => "2200", ELEM => "0001", VR => "CS" },
                                                             LabelText => { GRP => "2200", ELEM => "0002", VR => "UT" },
                                                   LabelStyleSelection => { GRP => "2200", ELEM => "0003", VR => "CS" },
                                                      MediaDisposition => { GRP => "2200", ELEM => "0004", VR => "LT" },
                                                          BarcodeValue => { GRP => "2200", ELEM => "0005", VR => "LT" },
                                                      BarcodeSymbology => { GRP => "2200", ELEM => "0006", VR => "CS" },
                                                   AllowMediaSplitting => { GRP => "2200", ELEM => "0007", VR => "CS" },
                                                IncludeNonDICOMObjects => { GRP => "2200", ELEM => "0008", VR => "CS" },
                                             IncludeDisplayApplication => { GRP => "2200", ELEM => "0009", VR => "CS" },
                          PreserveCompositeInstancesAfterMediaCreation => { GRP => "2200", ELEM => "000A", VR => "CS" },
                                     TotalNumberOfPiecesOfMediaCreated => { GRP => "2200", ELEM => "000B", VR => "US" },
                                      RequestedMediaApplicationProfile => { GRP => "2200", ELEM => "000C", VR => "LO" },
                                        ReferencedStorageMediaSequence => { GRP => "2200", ELEM => "000D", VR => "SQ" },
                                                     FailureAttributes => { GRP => "2200", ELEM => "000E", VR => "AT" },
                                                 AllowLossyCompression => { GRP => "2200", ELEM => "000F", VR => "CS" },
                                                       RequestPriority => { GRP => "2200", ELEM => "0020", VR => "CS" },
                                                          RTImageLabel => { GRP => "3002", ELEM => "0002", VR => "SH" },
                                                           RTImageName => { GRP => "3002", ELEM => "0003", VR => "LO" },
                                                    RTImageDescription => { GRP => "3002", ELEM => "0004", VR => "ST" },
                                                  ReportedValuesOrigin => { GRP => "3002", ELEM => "000A", VR => "CS" },
                                                          RTImagePlane => { GRP => "3002", ELEM => "000C", VR => "CS" },
                                          XRayImageReceptorTranslation => { GRP => "3002", ELEM => "000D", VR => "DS" },
                                                XRayImageReceptorAngle => { GRP => "3002", ELEM => "000E", VR => "DS" },
                                                    RTImageOrientation => { GRP => "3002", ELEM => "0010", VR => "DS" },
                                                ImagePlanePixelSpacing => { GRP => "3002", ELEM => "0011", VR => "DS" },
                                                       RTImagePosition => { GRP => "3002", ELEM => "0012", VR => "DS" },
                                                  RadiationMachineName => { GRP => "3002", ELEM => "0020", VR => "SH" },
                                                   RadiationMachineSAD => { GRP => "3002", ELEM => "0022", VR => "DS" },
                                                   RadiationMachineSSD => { GRP => "3002", ELEM => "0024", VR => "DS" },
                                                            RTImageSID => { GRP => "3002", ELEM => "0026", VR => "DS" },
                                       SourceToReferenceObjectDistance => { GRP => "3002", ELEM => "0028", VR => "DS" },
                                                        FractionNumber => { GRP => "3002", ELEM => "0029", VR => "IS" },
                                                      ExposureSequence => { GRP => "3002", ELEM => "0030", VR => "SQ" },
                                                      MetersetExposure => { GRP => "3002", ELEM => "0032", VR => "DS" },
                                                     DiaphragmPosition => { GRP => "3002", ELEM => "0034", VR => "DS" },
                                                    FluenceMapSequence => { GRP => "3002", ELEM => "0040", VR => "SQ" },
                                                     FluenceDataSource => { GRP => "3002", ELEM => "0041", VR => "CS" },
                                                      FluenceDataScale => { GRP => "3002", ELEM => "0042", VR => "DS" },
                                                               DVHType => { GRP => "3004", ELEM => "0001", VR => "CS" },
                                                             DoseUnits => { GRP => "3004", ELEM => "0002", VR => "CS" },
                                                              DoseType => { GRP => "3004", ELEM => "0004", VR => "CS" },
                                                           DoseComment => { GRP => "3004", ELEM => "0006", VR => "LO" },
                                                    NormalizationPoint => { GRP => "3004", ELEM => "0008", VR => "DS" },
                                                     DoseSummationType => { GRP => "3004", ELEM => "000A", VR => "CS" },
                                                 GridFrameOffsetVector => { GRP => "3004", ELEM => "000C", VR => "DS" },
                                                       DoseGridScaling => { GRP => "3004", ELEM => "000E", VR => "DS" },
                                                     RTDoseROISequence => { GRP => "3004", ELEM => "0010", VR => "SQ" },
                                                             DoseValue => { GRP => "3004", ELEM => "0012", VR => "DS" },
                                         TissueHeterogeneityCorrection => { GRP => "3004", ELEM => "0014", VR => "CS" },
                                                 DVHNormalizationPoint => { GRP => "3004", ELEM => "0040", VR => "DS" },
                                             DVHNormalizationDoseValue => { GRP => "3004", ELEM => "0042", VR => "DS" },
                                                           DVHSequence => { GRP => "3004", ELEM => "0050", VR => "SQ" },
                                                        DVHDoseScaling => { GRP => "3004", ELEM => "0052", VR => "DS" },
                                                        DVHVolumeUnits => { GRP => "3004", ELEM => "0054", VR => "CS" },
                                                       DVHNumberOfBins => { GRP => "3004", ELEM => "0056", VR => "IS" },
                                                               DVHData => { GRP => "3004", ELEM => "0058", VR => "DS" },
                                              DVHReferencedROISequence => { GRP => "3004", ELEM => "0060", VR => "SQ" },
                                                DVHROIContributionType => { GRP => "3004", ELEM => "0062", VR => "CS" },
                                                        DVHMinimumDose => { GRP => "3004", ELEM => "0070", VR => "DS" },
                                                        DVHMaximumDose => { GRP => "3004", ELEM => "0072", VR => "DS" },
                                                           DVHMeanDose => { GRP => "3004", ELEM => "0074", VR => "DS" },
                                                     StructureSetLabel => { GRP => "3006", ELEM => "0002", VR => "SH" },
                                                      StructureSetName => { GRP => "3006", ELEM => "0004", VR => "LO" },
                                               StructureSetDescription => { GRP => "3006", ELEM => "0006", VR => "ST" },
                                                      StructureSetDate => { GRP => "3006", ELEM => "0008", VR => "DA" },
                                                      StructureSetTime => { GRP => "3006", ELEM => "0009", VR => "TM" },
                                    ReferencedFrameOfReferenceSequence => { GRP => "3006", ELEM => "0010", VR => "SQ" },
                                             RTReferencedStudySequence => { GRP => "3006", ELEM => "0012", VR => "SQ" },
                                            RTReferencedSeriesSequence => { GRP => "3006", ELEM => "0014", VR => "SQ" },
                                                  ContourImageSequence => { GRP => "3006", ELEM => "0016", VR => "SQ" },
                                               StructureSetROISequence => { GRP => "3006", ELEM => "0020", VR => "SQ" },
                                                             ROINumber => { GRP => "3006", ELEM => "0022", VR => "IS" },
                                         ReferencedFrameOfReferenceUID => { GRP => "3006", ELEM => "0024", VR => "UI" },
                                                               ROIName => { GRP => "3006", ELEM => "0026", VR => "LO" },
                                                        ROIDescription => { GRP => "3006", ELEM => "0028", VR => "ST" },
                                                       ROIDisplayColor => { GRP => "3006", ELEM => "002A", VR => "IS" },
                                                             ROIVolume => { GRP => "3006", ELEM => "002C", VR => "DS" },
                                                  RTRelatedROISequence => { GRP => "3006", ELEM => "0030", VR => "SQ" },
                                                     RTROIRelationship => { GRP => "3006", ELEM => "0033", VR => "CS" },
                                                ROIGenerationAlgorithm => { GRP => "3006", ELEM => "0036", VR => "CS" },
                                              ROIGenerationDescription => { GRP => "3006", ELEM => "0038", VR => "LO" },
                                                    ROIContourSequence => { GRP => "3006", ELEM => "0039", VR => "SQ" },
                                                       ContourSequence => { GRP => "3006", ELEM => "0040", VR => "SQ" },
                                                  ContourGeometricType => { GRP => "3006", ELEM => "0042", VR => "CS" },
                                                  ContourSlabThickness => { GRP => "3006", ELEM => "0044", VR => "DS" },
                                                   ContourOffsetVector => { GRP => "3006", ELEM => "0045", VR => "DS" },
                                                 NumberOfContourPoints => { GRP => "3006", ELEM => "0046", VR => "IS" },
                                                         ContourNumber => { GRP => "3006", ELEM => "0048", VR => "IS" },
                                                      AttachedContours => { GRP => "3006", ELEM => "0049", VR => "IS" },
                                                           ContourData => { GRP => "3006", ELEM => "0050", VR => "DS" },
                                             RTROIObservationsSequence => { GRP => "3006", ELEM => "0080", VR => "SQ" },
                                                     ObservationNumber => { GRP => "3006", ELEM => "0082", VR => "IS" },
                                                   ReferencedROINumber => { GRP => "3006", ELEM => "0084", VR => "IS" },
                                                   ROIObservationLabel => { GRP => "3006", ELEM => "0085", VR => "SH" },
                                       RTROIIdentificationCodeSequence => { GRP => "3006", ELEM => "0086", VR => "SQ" },
                                             ROIObservationDescription => { GRP => "3006", ELEM => "0088", VR => "ST" },
                                      RelatedRTROIObservationsSequence => { GRP => "3006", ELEM => "00A0", VR => "SQ" },
                                                  RTROIInterpretedType => { GRP => "3006", ELEM => "00A4", VR => "CS" },
                                                        ROIInterpreter => { GRP => "3006", ELEM => "00A6", VR => "PN" },
                                         ROIPhysicalPropertiesSequence => { GRP => "3006", ELEM => "00B0", VR => "SQ" },
                                                   ROIPhysicalProperty => { GRP => "3006", ELEM => "00B2", VR => "CS" },
                                              ROIPhysicalPropertyValue => { GRP => "3006", ELEM => "00B4", VR => "DS" },
                                       ROIElementalCompositionSequence => { GRP => "3006", ELEM => "00B6", VR => "SQ" },
                                   ROIElementalCompositionAtomicNumber => { GRP => "3006", ELEM => "00B7", VR => "US" },
                             ROIElementalCompositionAtomicMassFraction => { GRP => "3006", ELEM => "00B8", VR => "FL" },
                                  FrameOfReferenceRelationshipSequence => { GRP => "3006", ELEM => "00C0", VR => "SQ" },
                                            RelatedFrameOfReferenceUID => { GRP => "3006", ELEM => "00C2", VR => "UI" },
                                    FrameOfReferenceTransformationType => { GRP => "3006", ELEM => "00C4", VR => "CS" },
                                  FrameOfReferenceTransformationMatrix => { GRP => "3006", ELEM => "00C6", VR => "DS" },
                                 FrameOfReferenceTransformationComment => { GRP => "3006", ELEM => "00C8", VR => "LO" },
                                         MeasuredDoseReferenceSequence => { GRP => "3008", ELEM => "0010", VR => "SQ" },
                                               MeasuredDoseDescription => { GRP => "3008", ELEM => "0012", VR => "ST" },
                                                      MeasuredDoseType => { GRP => "3008", ELEM => "0014", VR => "CS" },
                                                     MeasuredDoseValue => { GRP => "3008", ELEM => "0016", VR => "DS" },
                                          TreatmentSessionBeamSequence => { GRP => "3008", ELEM => "0020", VR => "SQ" },
                                       TreatmentSessionIonBeamSequence => { GRP => "3008", ELEM => "0021", VR => "SQ" },
                                                 CurrentFractionNumber => { GRP => "3008", ELEM => "0022", VR => "IS" },
                                             TreatmentControlPointDate => { GRP => "3008", ELEM => "0024", VR => "DA" },
                                             TreatmentControlPointTime => { GRP => "3008", ELEM => "0025", VR => "TM" },
                                            TreatmentTerminationStatus => { GRP => "3008", ELEM => "002A", VR => "CS" },
                                              TreatmentTerminationCode => { GRP => "3008", ELEM => "002B", VR => "SH" },
                                           TreatmentVerificationStatus => { GRP => "3008", ELEM => "002C", VR => "CS" },
                                     ReferencedTreatmentRecordSequence => { GRP => "3008", ELEM => "0030", VR => "SQ" },
                                              SpecifiedPrimaryMeterset => { GRP => "3008", ELEM => "0032", VR => "DS" },
                                            SpecifiedSecondaryMeterset => { GRP => "3008", ELEM => "0033", VR => "DS" },
                                              DeliveredPrimaryMeterset => { GRP => "3008", ELEM => "0036", VR => "DS" },
                                            DeliveredSecondaryMeterset => { GRP => "3008", ELEM => "0037", VR => "DS" },
                                                SpecifiedTreatmentTime => { GRP => "3008", ELEM => "003A", VR => "DS" },
                                                DeliveredTreatmentTime => { GRP => "3008", ELEM => "003B", VR => "DS" },
                                          ControlPointDeliverySequence => { GRP => "3008", ELEM => "0040", VR => "SQ" },
                                       IonControlPointDeliverySequence => { GRP => "3008", ELEM => "0041", VR => "SQ" },
                                                     SpecifiedMeterset => { GRP => "3008", ELEM => "0042", VR => "DS" },
                                                     DeliveredMeterset => { GRP => "3008", ELEM => "0044", VR => "DS" },
                                                       MetersetRateSet => { GRP => "3008", ELEM => "0045", VR => "FL" },
                                                 MetersetRateDelivered => { GRP => "3008", ELEM => "0046", VR => "FL" },
                                            ScanSpotMetersetsDelivered => { GRP => "3008", ELEM => "0047", VR => "FL" },
                                                     DoseRateDelivered => { GRP => "3008", ELEM => "0048", VR => "DS" },
                       TreatmentSummaryCalculatedDoseReferenceSequence => { GRP => "3008", ELEM => "0050", VR => "SQ" },
                                         CumulativeDoseToDoseReference => { GRP => "3008", ELEM => "0052", VR => "DS" },
                                                    FirstTreatmentDate => { GRP => "3008", ELEM => "0054", VR => "DA" },
                                               MostRecentTreatmentDate => { GRP => "3008", ELEM => "0056", VR => "DA" },
                                            NumberOfFractionsDelivered => { GRP => "3008", ELEM => "005A", VR => "IS" },
                                                      OverrideSequence => { GRP => "3008", ELEM => "0060", VR => "SQ" },
                                              ParameterSequencePointer => { GRP => "3008", ELEM => "0061", VR => "AT" },
                                              OverrideParameterPointer => { GRP => "3008", ELEM => "0062", VR => "AT" },
                                                    ParameterItemIndex => { GRP => "3008", ELEM => "0063", VR => "IS" },
                                           MeasuredDoseReferenceNumber => { GRP => "3008", ELEM => "0064", VR => "IS" },
                                                      ParameterPointer => { GRP => "3008", ELEM => "0065", VR => "AT" },
                                                        OverrideReason => { GRP => "3008", ELEM => "0066", VR => "ST" },
                                            CorrectedParameterSequence => { GRP => "3008", ELEM => "0068", VR => "SQ" },
                                                       CorrectionValue => { GRP => "3008", ELEM => "006A", VR => "FL" },
                                       CalculatedDoseReferenceSequence => { GRP => "3008", ELEM => "0070", VR => "SQ" },
                                         CalculatedDoseReferenceNumber => { GRP => "3008", ELEM => "0072", VR => "IS" },
                                    CalculatedDoseReferenceDescription => { GRP => "3008", ELEM => "0074", VR => "ST" },
                                      CalculatedDoseReferenceDoseValue => { GRP => "3008", ELEM => "0076", VR => "DS" },
                                                         StartMeterset => { GRP => "3008", ELEM => "0078", VR => "DS" },
                                                           EndMeterset => { GRP => "3008", ELEM => "007A", VR => "DS" },
                               ReferencedMeasuredDoseReferenceSequence => { GRP => "3008", ELEM => "0080", VR => "SQ" },
                                 ReferencedMeasuredDoseReferenceNumber => { GRP => "3008", ELEM => "0082", VR => "IS" },
                             ReferencedCalculatedDoseReferenceSequence => { GRP => "3008", ELEM => "0090", VR => "SQ" },
                               ReferencedCalculatedDoseReferenceNumber => { GRP => "3008", ELEM => "0092", VR => "IS" },
                                   BeamLimitingDeviceLeafPairsSequence => { GRP => "3008", ELEM => "00A0", VR => "SQ" },
                                                 RecordedWedgeSequence => { GRP => "3008", ELEM => "00B0", VR => "SQ" },
                                           RecordedCompensatorSequence => { GRP => "3008", ELEM => "00C0", VR => "SQ" },
                                                 RecordedBlockSequence => { GRP => "3008", ELEM => "00D0", VR => "SQ" },
                         TreatmentSummaryMeasuredDoseReferenceSequence => { GRP => "3008", ELEM => "00E0", VR => "SQ" },
                                                 RecordedSnoutSequence => { GRP => "3008", ELEM => "00F0", VR => "SQ" },
                                          RecordedRangeShifterSequence => { GRP => "3008", ELEM => "00F2", VR => "SQ" },
                                RecordedLateralSpreadingDeviceSequence => { GRP => "3008", ELEM => "00F4", VR => "SQ" },
                                        RecordedRangeModulatorSequence => { GRP => "3008", ELEM => "00F6", VR => "SQ" },
                                                RecordedSourceSequence => { GRP => "3008", ELEM => "0100", VR => "SQ" },
                                                    SourceSerialNumber => { GRP => "3008", ELEM => "0105", VR => "LO" },
                              TreatmentSessionApplicationSetupSequence => { GRP => "3008", ELEM => "0110", VR => "SQ" },
                                                 ApplicationSetupCheck => { GRP => "3008", ELEM => "0116", VR => "CS" },
                                 RecordedBrachyAccessoryDeviceSequence => { GRP => "3008", ELEM => "0120", VR => "SQ" },
                                 ReferencedBrachyAccessoryDeviceNumber => { GRP => "3008", ELEM => "0122", VR => "IS" },
                                               RecordedChannelSequence => { GRP => "3008", ELEM => "0130", VR => "SQ" },
                                             SpecifiedChannelTotalTime => { GRP => "3008", ELEM => "0132", VR => "DS" },
                                             DeliveredChannelTotalTime => { GRP => "3008", ELEM => "0134", VR => "DS" },
                                               SpecifiedNumberOfPulses => { GRP => "3008", ELEM => "0136", VR => "IS" },
                                               DeliveredNumberOfPulses => { GRP => "3008", ELEM => "0138", VR => "IS" },
                                      SpecifiedPulseRepetitionInterval => { GRP => "3008", ELEM => "013A", VR => "DS" },
                                      DeliveredPulseRepetitionInterval => { GRP => "3008", ELEM => "013C", VR => "DS" },
                                      RecordedSourceApplicatorSequence => { GRP => "3008", ELEM => "0140", VR => "SQ" },
                                      ReferencedSourceApplicatorNumber => { GRP => "3008", ELEM => "0142", VR => "IS" },
                                         RecordedChannelShieldSequence => { GRP => "3008", ELEM => "0150", VR => "SQ" },
                                         ReferencedChannelShieldNumber => { GRP => "3008", ELEM => "0152", VR => "IS" },
                                   BrachyControlPointDeliveredSequence => { GRP => "3008", ELEM => "0160", VR => "SQ" },
                                                  SafePositionExitDate => { GRP => "3008", ELEM => "0162", VR => "DA" },
                                                  SafePositionExitTime => { GRP => "3008", ELEM => "0164", VR => "TM" },
                                                SafePositionReturnDate => { GRP => "3008", ELEM => "0166", VR => "DA" },
                                                SafePositionReturnTime => { GRP => "3008", ELEM => "0168", VR => "TM" },
                                                CurrentTreatmentStatus => { GRP => "3008", ELEM => "0200", VR => "CS" },
                                                TreatmentStatusComment => { GRP => "3008", ELEM => "0202", VR => "ST" },
                                          FractionGroupSummarySequence => { GRP => "3008", ELEM => "0220", VR => "SQ" },
                                              ReferencedFractionNumber => { GRP => "3008", ELEM => "0223", VR => "IS" },
                                                     FractionGroupType => { GRP => "3008", ELEM => "0224", VR => "CS" },
                                                   BeamStopperPosition => { GRP => "3008", ELEM => "0230", VR => "CS" },
                                         FractionStatusSummarySequence => { GRP => "3008", ELEM => "0240", VR => "SQ" },
                                                         TreatmentDate => { GRP => "3008", ELEM => "0250", VR => "DA" },
                                                         TreatmentTime => { GRP => "3008", ELEM => "0251", VR => "TM" },
                                                           RTPlanLabel => { GRP => "300A", ELEM => "0002", VR => "SH" },
                                                            RTPlanName => { GRP => "300A", ELEM => "0003", VR => "LO" },
                                                     RTPlanDescription => { GRP => "300A", ELEM => "0004", VR => "ST" },
                                                            RTPlanDate => { GRP => "300A", ELEM => "0006", VR => "DA" },
                                                            RTPlanTime => { GRP => "300A", ELEM => "0007", VR => "TM" },
                                                    TreatmentProtocols => { GRP => "300A", ELEM => "0009", VR => "LO" },
                                                            PlanIntent => { GRP => "300A", ELEM => "000A", VR => "CS" },
                                                        TreatmentSites => { GRP => "300A", ELEM => "000B", VR => "LO" },
                                                        RTPlanGeometry => { GRP => "300A", ELEM => "000C", VR => "CS" },
                                               PrescriptionDescription => { GRP => "300A", ELEM => "000E", VR => "ST" },
                                                 DoseReferenceSequence => { GRP => "300A", ELEM => "0010", VR => "SQ" },
                                                   DoseReferenceNumber => { GRP => "300A", ELEM => "0012", VR => "IS" },
                                                      DoseReferenceUID => { GRP => "300A", ELEM => "0013", VR => "UI" },
                                            DoseReferenceStructureType => { GRP => "300A", ELEM => "0014", VR => "CS" },
                                                 NominalBeamEnergyUnit => { GRP => "300A", ELEM => "0015", VR => "CS" },
                                              DoseReferenceDescription => { GRP => "300A", ELEM => "0016", VR => "LO" },
                                         DoseReferencePointCoordinates => { GRP => "300A", ELEM => "0018", VR => "DS" },
                                                      NominalPriorDose => { GRP => "300A", ELEM => "001A", VR => "DS" },
                                                     DoseReferenceType => { GRP => "300A", ELEM => "0020", VR => "CS" },
                                                      ConstraintWeight => { GRP => "300A", ELEM => "0021", VR => "DS" },
                                                   DeliveryWarningDose => { GRP => "300A", ELEM => "0022", VR => "DS" },
                                                   DeliveryMaximumDose => { GRP => "300A", ELEM => "0023", VR => "DS" },
                                                     TargetMinimumDose => { GRP => "300A", ELEM => "0025", VR => "DS" },
                                                TargetPrescriptionDose => { GRP => "300A", ELEM => "0026", VR => "DS" },
                                                     TargetMaximumDose => { GRP => "300A", ELEM => "0027", VR => "DS" },
                                         TargetUnderdoseVolumeFraction => { GRP => "300A", ELEM => "0028", VR => "DS" },
                                             OrganAtRiskFullVolumeDose => { GRP => "300A", ELEM => "002A", VR => "DS" },
                                                  OrganAtRiskLimitDose => { GRP => "300A", ELEM => "002B", VR => "DS" },
                                                OrganAtRiskMaximumDose => { GRP => "300A", ELEM => "002C", VR => "DS" },
                                     OrganAtRiskOverdoseVolumeFraction => { GRP => "300A", ELEM => "002D", VR => "DS" },
                                                ToleranceTableSequence => { GRP => "300A", ELEM => "0040", VR => "SQ" },
                                                  ToleranceTableNumber => { GRP => "300A", ELEM => "0042", VR => "IS" },
                                                   ToleranceTableLabel => { GRP => "300A", ELEM => "0043", VR => "SH" },
                                                  GantryAngleTolerance => { GRP => "300A", ELEM => "0044", VR => "DS" },
                                      BeamLimitingDeviceAngleTolerance => { GRP => "300A", ELEM => "0046", VR => "DS" },
                                   BeamLimitingDeviceToleranceSequence => { GRP => "300A", ELEM => "0048", VR => "SQ" },
                                   BeamLimitingDevicePositionTolerance => { GRP => "300A", ELEM => "004A", VR => "DS" },
                                                SnoutPositionTolerance => { GRP => "300A", ELEM => "004B", VR => "FL" },
                                          PatientSupportAngleTolerance => { GRP => "300A", ELEM => "004C", VR => "DS" },
                                       TableTopEccentricAngleTolerance => { GRP => "300A", ELEM => "004E", VR => "DS" },
                                           TableTopPitchAngleTolerance => { GRP => "300A", ELEM => "004F", VR => "FL" },
                                            TableTopRollAngleTolerance => { GRP => "300A", ELEM => "0050", VR => "FL" },
                                     TableTopVerticalPositionTolerance => { GRP => "300A", ELEM => "0051", VR => "DS" },
                                 TableTopLongitudinalPositionTolerance => { GRP => "300A", ELEM => "0052", VR => "DS" },
                                      TableTopLateralPositionTolerance => { GRP => "300A", ELEM => "0053", VR => "DS" },
                                                    RTPlanRelationship => { GRP => "300A", ELEM => "0055", VR => "CS" },
                                                 FractionGroupSequence => { GRP => "300A", ELEM => "0070", VR => "SQ" },
                                                   FractionGroupNumber => { GRP => "300A", ELEM => "0071", VR => "IS" },
                                              FractionGroupDescription => { GRP => "300A", ELEM => "0072", VR => "LO" },
                                              NumberOfFractionsPlanned => { GRP => "300A", ELEM => "0078", VR => "IS" },
                                   NumberOfFractionPatternDigitsPerDay => { GRP => "300A", ELEM => "0079", VR => "IS" },
                                             RepeatFractionCycleLength => { GRP => "300A", ELEM => "007A", VR => "IS" },
                                                       FractionPattern => { GRP => "300A", ELEM => "007B", VR => "LT" },
                                                         NumberOfBeams => { GRP => "300A", ELEM => "0080", VR => "IS" },
                                            BeamDoseSpecificationPoint => { GRP => "300A", ELEM => "0082", VR => "DS" },
                                                              BeamDose => { GRP => "300A", ELEM => "0084", VR => "DS" },
                                                          BeamMeterset => { GRP => "300A", ELEM => "0086", VR => "DS" },
                                                    BeamDosePointDepth => { GRP => "300A", ELEM => "0088", VR => "FL" },
                                          BeamDosePointEquivalentDepth => { GRP => "300A", ELEM => "0089", VR => "FL" },
                                                      BeamDosePointSSD => { GRP => "300A", ELEM => "008A", VR => "FL" },
                                       NumberOfBrachyApplicationSetups => { GRP => "300A", ELEM => "00A0", VR => "IS" },
                          BrachyApplicationSetupDoseSpecificationPoint => { GRP => "300A", ELEM => "00A2", VR => "DS" },
                                            BrachyApplicationSetupDose => { GRP => "300A", ELEM => "00A4", VR => "DS" },
                                                          BeamSequence => { GRP => "300A", ELEM => "00B0", VR => "SQ" },
                                                  TreatmentMachineName => { GRP => "300A", ELEM => "00B2", VR => "SH" },
                                                  PrimaryDosimeterUnit => { GRP => "300A", ELEM => "00B3", VR => "CS" },
                                                    SourceAxisDistance => { GRP => "300A", ELEM => "00B4", VR => "DS" },
                                            BeamLimitingDeviceSequence => { GRP => "300A", ELEM => "00B6", VR => "SQ" },
                                              RTBeamLimitingDeviceType => { GRP => "300A", ELEM => "00B8", VR => "CS" },
                                    SourceToBeamLimitingDeviceDistance => { GRP => "300A", ELEM => "00BA", VR => "DS" },
                                 IsocenterToBeamLimitingDeviceDistance => { GRP => "300A", ELEM => "00BB", VR => "FL" },
                                                  NumberOfLeafJawPairs => { GRP => "300A", ELEM => "00BC", VR => "IS" },
                                                LeafPositionBoundaries => { GRP => "300A", ELEM => "00BE", VR => "DS" },
                                                            BeamNumber => { GRP => "300A", ELEM => "00C0", VR => "IS" },
                                                              BeamName => { GRP => "300A", ELEM => "00C2", VR => "LO" },
                                                       BeamDescription => { GRP => "300A", ELEM => "00C3", VR => "ST" },
                                                              BeamType => { GRP => "300A", ELEM => "00C4", VR => "CS" },
                                                         RadiationType => { GRP => "300A", ELEM => "00C6", VR => "CS" },
                                                 HighDoseTechniqueType => { GRP => "300A", ELEM => "00C7", VR => "CS" },
                                                  ReferenceImageNumber => { GRP => "300A", ELEM => "00C8", VR => "IS" },
                                      PlannedVerificationImageSequence => { GRP => "300A", ELEM => "00CA", VR => "SQ" },
                            ImagingDeviceSpecificAcquisitionParameters => { GRP => "300A", ELEM => "00CC", VR => "LO" },
                                                 TreatmentDeliveryType => { GRP => "300A", ELEM => "00CE", VR => "CS" },
                                                        NumberOfWedges => { GRP => "300A", ELEM => "00D0", VR => "IS" },
                                                         WedgeSequence => { GRP => "300A", ELEM => "00D1", VR => "SQ" },
                                                           WedgeNumber => { GRP => "300A", ELEM => "00D2", VR => "IS" },
                                                             WedgeType => { GRP => "300A", ELEM => "00D3", VR => "CS" },
                                                               WedgeID => { GRP => "300A", ELEM => "00D4", VR => "SH" },
                                                            WedgeAngle => { GRP => "300A", ELEM => "00D5", VR => "IS" },
                                                           WedgeFactor => { GRP => "300A", ELEM => "00D6", VR => "DS" },
                                TotalWedgeTrayWaterEquivalentThickness => { GRP => "300A", ELEM => "00D7", VR => "FL" },
                                                      WedgeOrientation => { GRP => "300A", ELEM => "00D8", VR => "DS" },
                                          IsocenterToWedgeTrayDistance => { GRP => "300A", ELEM => "00D9", VR => "FL" },
                                             SourceToWedgeTrayDistance => { GRP => "300A", ELEM => "00DA", VR => "DS" },
                                                 WedgeThinEdgePosition => { GRP => "300A", ELEM => "00DB", VR => "FL" },
                                                               BolusID => { GRP => "300A", ELEM => "00DC", VR => "SH" },
                                                      BolusDescription => { GRP => "300A", ELEM => "00DD", VR => "ST" },
                                                  NumberOfCompensators => { GRP => "300A", ELEM => "00E0", VR => "IS" },
                                                            MaterialID => { GRP => "300A", ELEM => "00E1", VR => "SH" },
                                            TotalCompensatorTrayFactor => { GRP => "300A", ELEM => "00E2", VR => "DS" },
                                                   CompensatorSequence => { GRP => "300A", ELEM => "00E3", VR => "SQ" },
                                                     CompensatorNumber => { GRP => "300A", ELEM => "00E4", VR => "IS" },
                                                         CompensatorID => { GRP => "300A", ELEM => "00E5", VR => "SH" },
                                       SourceToCompensatorTrayDistance => { GRP => "300A", ELEM => "00E6", VR => "DS" },
                                                       CompensatorRows => { GRP => "300A", ELEM => "00E7", VR => "IS" },
                                                    CompensatorColumns => { GRP => "300A", ELEM => "00E8", VR => "IS" },
                                               CompensatorPixelSpacing => { GRP => "300A", ELEM => "00E9", VR => "DS" },
                                                   CompensatorPosition => { GRP => "300A", ELEM => "00EA", VR => "DS" },
                                           CompensatorTransmissionData => { GRP => "300A", ELEM => "00EB", VR => "DS" },
                                              CompensatorThicknessData => { GRP => "300A", ELEM => "00EC", VR => "DS" },
                                                          NumberOfBoli => { GRP => "300A", ELEM => "00ED", VR => "IS" },
                                                       CompensatorType => { GRP => "300A", ELEM => "00EE", VR => "CS" },
                                                        NumberOfBlocks => { GRP => "300A", ELEM => "00F0", VR => "IS" },
                                                  TotalBlockTrayFactor => { GRP => "300A", ELEM => "00F2", VR => "DS" },
                                TotalBlockTrayWaterEquivalentThickness => { GRP => "300A", ELEM => "00F3", VR => "FL" },
                                                         BlockSequence => { GRP => "300A", ELEM => "00F4", VR => "SQ" },
                                                           BlockTrayID => { GRP => "300A", ELEM => "00F5", VR => "SH" },
                                             SourceToBlockTrayDistance => { GRP => "300A", ELEM => "00F6", VR => "DS" },
                                          IsocenterToBlockTrayDistance => { GRP => "300A", ELEM => "00F7", VR => "FL" },
                                                             BlockType => { GRP => "300A", ELEM => "00F8", VR => "CS" },
                                                         AccessoryCode => { GRP => "300A", ELEM => "00F9", VR => "LO" },
                                                       BlockDivergence => { GRP => "300A", ELEM => "00FA", VR => "CS" },
                                                 BlockMountingPosition => { GRP => "300A", ELEM => "00FB", VR => "CS" },
                                                           BlockNumber => { GRP => "300A", ELEM => "00FC", VR => "IS" },
                                                             BlockName => { GRP => "300A", ELEM => "00FE", VR => "LO" },
                                                        BlockThickness => { GRP => "300A", ELEM => "0100", VR => "DS" },
                                                     BlockTransmission => { GRP => "300A", ELEM => "0102", VR => "DS" },
                                                   BlockNumberOfPoints => { GRP => "300A", ELEM => "0104", VR => "IS" },
                                                             BlockData => { GRP => "300A", ELEM => "0106", VR => "DS" },
                                                    ApplicatorSequence => { GRP => "300A", ELEM => "0107", VR => "SQ" },
                                                          ApplicatorID => { GRP => "300A", ELEM => "0108", VR => "SH" },
                                                        ApplicatorType => { GRP => "300A", ELEM => "0109", VR => "CS" },
                                                 ApplicatorDescription => { GRP => "300A", ELEM => "010A", VR => "LO" },
                                    CumulativeDoseReferenceCoefficient => { GRP => "300A", ELEM => "010C", VR => "DS" },
                                         FinalCumulativeMetersetWeight => { GRP => "300A", ELEM => "010E", VR => "DS" },
                                                 NumberOfControlPoints => { GRP => "300A", ELEM => "0110", VR => "IS" },
                                                  ControlPointSequence => { GRP => "300A", ELEM => "0111", VR => "SQ" },
                                                     ControlPointIndex => { GRP => "300A", ELEM => "0112", VR => "IS" },
                                                     NominalBeamEnergy => { GRP => "300A", ELEM => "0114", VR => "DS" },
                                                           DoseRateSet => { GRP => "300A", ELEM => "0115", VR => "DS" },
                                                 WedgePositionSequence => { GRP => "300A", ELEM => "0116", VR => "SQ" },
                                                         WedgePosition => { GRP => "300A", ELEM => "0118", VR => "CS" },
                                    BeamLimitingDevicePositionSequence => { GRP => "300A", ELEM => "011A", VR => "SQ" },
                                                      LeafJawPositions => { GRP => "300A", ELEM => "011C", VR => "DS" },
                                                           GantryAngle => { GRP => "300A", ELEM => "011E", VR => "DS" },
                                               GantryRotationDirection => { GRP => "300A", ELEM => "011F", VR => "CS" },
                                               BeamLimitingDeviceAngle => { GRP => "300A", ELEM => "0120", VR => "DS" },
                                   BeamLimitingDeviceRotationDirection => { GRP => "300A", ELEM => "0121", VR => "CS" },
                                                   PatientSupportAngle => { GRP => "300A", ELEM => "0122", VR => "DS" },
                                       PatientSupportRotationDirection => { GRP => "300A", ELEM => "0123", VR => "CS" },
                                         TableTopEccentricAxisDistance => { GRP => "300A", ELEM => "0124", VR => "DS" },
                                                TableTopEccentricAngle => { GRP => "300A", ELEM => "0125", VR => "DS" },
                                    TableTopEccentricRotationDirection => { GRP => "300A", ELEM => "0126", VR => "CS" },
                                              TableTopVerticalPosition => { GRP => "300A", ELEM => "0128", VR => "DS" },
                                          TableTopLongitudinalPosition => { GRP => "300A", ELEM => "0129", VR => "DS" },
                                               TableTopLateralPosition => { GRP => "300A", ELEM => "012A", VR => "DS" },
                                                     IsocenterPosition => { GRP => "300A", ELEM => "012C", VR => "DS" },
                                                     SurfaceEntryPoint => { GRP => "300A", ELEM => "012E", VR => "DS" },
                                               SourceToSurfaceDistance => { GRP => "300A", ELEM => "0130", VR => "DS" },
                                              CumulativeMetersetWeight => { GRP => "300A", ELEM => "0134", VR => "DS" },
                                                    TableTopPitchAngle => { GRP => "300A", ELEM => "0140", VR => "FL" },
                                        TableTopPitchRotationDirection => { GRP => "300A", ELEM => "0142", VR => "CS" },
                                                     TableTopRollAngle => { GRP => "300A", ELEM => "0144", VR => "FL" },
                                         TableTopRollRotationDirection => { GRP => "300A", ELEM => "0146", VR => "CS" },
                                                     HeadFixationAngle => { GRP => "300A", ELEM => "0148", VR => "FL" },
                                                      GantryPitchAngle => { GRP => "300A", ELEM => "014A", VR => "FL" },
                                          GantryPitchRotationDirection => { GRP => "300A", ELEM => "014C", VR => "CS" },
                                             GantryPitchAngleTolerance => { GRP => "300A", ELEM => "014E", VR => "FL" },
                                                  PatientSetupSequence => { GRP => "300A", ELEM => "0180", VR => "SQ" },
                                                    PatientSetupNumber => { GRP => "300A", ELEM => "0182", VR => "IS" },
                                                     PatientSetupLabel => { GRP => "300A", ELEM => "0183", VR => "LO" },
                                             PatientAdditionalPosition => { GRP => "300A", ELEM => "0184", VR => "LO" },
                                                FixationDeviceSequence => { GRP => "300A", ELEM => "0190", VR => "SQ" },
                                                    FixationDeviceType => { GRP => "300A", ELEM => "0192", VR => "CS" },
                                                   FixationDeviceLabel => { GRP => "300A", ELEM => "0194", VR => "SH" },
                                             FixationDeviceDescription => { GRP => "300A", ELEM => "0196", VR => "ST" },
                                                FixationDevicePosition => { GRP => "300A", ELEM => "0198", VR => "SH" },
                                              FixationDevicePitchAngle => { GRP => "300A", ELEM => "0199", VR => "FL" },
                                               FixationDeviceRollAngle => { GRP => "300A", ELEM => "019A", VR => "FL" },
                                               ShieldingDeviceSequence => { GRP => "300A", ELEM => "01A0", VR => "SQ" },
                                                   ShieldingDeviceType => { GRP => "300A", ELEM => "01A2", VR => "CS" },
                                                  ShieldingDeviceLabel => { GRP => "300A", ELEM => "01A4", VR => "SH" },
                                            ShieldingDeviceDescription => { GRP => "300A", ELEM => "01A6", VR => "ST" },
                                               ShieldingDevicePosition => { GRP => "300A", ELEM => "01A8", VR => "SH" },
                                                        SetupTechnique => { GRP => "300A", ELEM => "01B0", VR => "CS" },
                                             SetupTechniqueDescription => { GRP => "300A", ELEM => "01B2", VR => "ST" },
                                                   SetupDeviceSequence => { GRP => "300A", ELEM => "01B4", VR => "SQ" },
                                                       SetupDeviceType => { GRP => "300A", ELEM => "01B6", VR => "CS" },
                                                      SetupDeviceLabel => { GRP => "300A", ELEM => "01B8", VR => "SH" },
                                                SetupDeviceDescription => { GRP => "300A", ELEM => "01BA", VR => "ST" },
                                                  SetupDeviceParameter => { GRP => "300A", ELEM => "01BC", VR => "DS" },
                                             SetupReferenceDescription => { GRP => "300A", ELEM => "01D0", VR => "ST" },
                                     TableTopVerticalSetupDisplacement => { GRP => "300A", ELEM => "01D2", VR => "DS" },
                                 TableTopLongitudinalSetupDisplacement => { GRP => "300A", ELEM => "01D4", VR => "DS" },
                                      TableTopLateralSetupDisplacement => { GRP => "300A", ELEM => "01D6", VR => "DS" },
                                              BrachyTreatmentTechnique => { GRP => "300A", ELEM => "0200", VR => "CS" },
                                                   BrachyTreatmentType => { GRP => "300A", ELEM => "0202", VR => "CS" },
                                              TreatmentMachineSequence => { GRP => "300A", ELEM => "0206", VR => "SQ" },
                                                        SourceSequence => { GRP => "300A", ELEM => "0210", VR => "SQ" },
                                                          SourceNumber => { GRP => "300A", ELEM => "0212", VR => "IS" },
                                                            SourceType => { GRP => "300A", ELEM => "0214", VR => "CS" },
                                                    SourceManufacturer => { GRP => "300A", ELEM => "0216", VR => "LO" },
                                                  ActiveSourceDiameter => { GRP => "300A", ELEM => "0218", VR => "DS" },
                                                    ActiveSourceLength => { GRP => "300A", ELEM => "021A", VR => "DS" },
                                   SourceEncapsulationNominalThickness => { GRP => "300A", ELEM => "0222", VR => "DS" },
                                SourceEncapsulationNominalTransmission => { GRP => "300A", ELEM => "0224", VR => "DS" },
                                                     SourceIsotopeName => { GRP => "300A", ELEM => "0226", VR => "LO" },
                                                 SourceIsotopeHalfLife => { GRP => "300A", ELEM => "0228", VR => "DS" },
                                                   SourceStrengthUnits => { GRP => "300A", ELEM => "0229", VR => "CS" },
                                                 ReferenceAirKermaRate => { GRP => "300A", ELEM => "022A", VR => "DS" },
                                                        SourceStrength => { GRP => "300A", ELEM => "022B", VR => "DS" },
                                           SourceStrengthReferenceDate => { GRP => "300A", ELEM => "022C", VR => "DA" },
                                           SourceStrengthReferenceTime => { GRP => "300A", ELEM => "022E", VR => "TM" },
                                              ApplicationSetupSequence => { GRP => "300A", ELEM => "0230", VR => "SQ" },
                                                  ApplicationSetupType => { GRP => "300A", ELEM => "0232", VR => "CS" },
                                                ApplicationSetupNumber => { GRP => "300A", ELEM => "0234", VR => "IS" },
                                                  ApplicationSetupName => { GRP => "300A", ELEM => "0236", VR => "LO" },
                                          ApplicationSetupManufacturer => { GRP => "300A", ELEM => "0238", VR => "LO" },
                                                        TemplateNumber => { GRP => "300A", ELEM => "0240", VR => "IS" },
                                                          TemplateType => { GRP => "300A", ELEM => "0242", VR => "SH" },
                                                          TemplateName => { GRP => "300A", ELEM => "0244", VR => "LO" },
                                                TotalReferenceAirKerma => { GRP => "300A", ELEM => "0250", VR => "DS" },
                                         BrachyAccessoryDeviceSequence => { GRP => "300A", ELEM => "0260", VR => "SQ" },
                                           BrachyAccessoryDeviceNumber => { GRP => "300A", ELEM => "0262", VR => "IS" },
                                               BrachyAccessoryDeviceID => { GRP => "300A", ELEM => "0263", VR => "SH" },
                                             BrachyAccessoryDeviceType => { GRP => "300A", ELEM => "0264", VR => "CS" },
                                             BrachyAccessoryDeviceName => { GRP => "300A", ELEM => "0266", VR => "LO" },
                                 BrachyAccessoryDeviceNominalThickness => { GRP => "300A", ELEM => "026A", VR => "DS" },
                              BrachyAccessoryDeviceNominalTransmission => { GRP => "300A", ELEM => "026C", VR => "DS" },
                                                       ChannelSequence => { GRP => "300A", ELEM => "0280", VR => "SQ" },
                                                         ChannelNumber => { GRP => "300A", ELEM => "0282", VR => "IS" },
                                                         ChannelLength => { GRP => "300A", ELEM => "0284", VR => "DS" },
                                                      ChannelTotalTime => { GRP => "300A", ELEM => "0286", VR => "DS" },
                                                    SourceMovementType => { GRP => "300A", ELEM => "0288", VR => "CS" },
                                                        NumberOfPulses => { GRP => "300A", ELEM => "028A", VR => "IS" },
                                               PulseRepetitionInterval => { GRP => "300A", ELEM => "028C", VR => "DS" },
                                                SourceApplicatorNumber => { GRP => "300A", ELEM => "0290", VR => "IS" },
                                                    SourceApplicatorID => { GRP => "300A", ELEM => "0291", VR => "SH" },
                                                  SourceApplicatorType => { GRP => "300A", ELEM => "0292", VR => "CS" },
                                                  SourceApplicatorName => { GRP => "300A", ELEM => "0294", VR => "LO" },
                                                SourceApplicatorLength => { GRP => "300A", ELEM => "0296", VR => "DS" },
                                          SourceApplicatorManufacturer => { GRP => "300A", ELEM => "0298", VR => "LO" },
                                  SourceApplicatorWallNominalThickness => { GRP => "300A", ELEM => "029C", VR => "DS" },
                               SourceApplicatorWallNominalTransmission => { GRP => "300A", ELEM => "029E", VR => "DS" },
                                              SourceApplicatorStepSize => { GRP => "300A", ELEM => "02A0", VR => "DS" },
                                                    TransferTubeNumber => { GRP => "300A", ELEM => "02A2", VR => "IS" },
                                                    TransferTubeLength => { GRP => "300A", ELEM => "02A4", VR => "DS" },
                                                 ChannelShieldSequence => { GRP => "300A", ELEM => "02B0", VR => "SQ" },
                                                   ChannelShieldNumber => { GRP => "300A", ELEM => "02B2", VR => "IS" },
                                                       ChannelShieldID => { GRP => "300A", ELEM => "02B3", VR => "SH" },
                                                     ChannelShieldName => { GRP => "300A", ELEM => "02B4", VR => "LO" },
                                         ChannelShieldNominalThickness => { GRP => "300A", ELEM => "02B8", VR => "DS" },
                                      ChannelShieldNominalTransmission => { GRP => "300A", ELEM => "02BA", VR => "DS" },
                                             FinalCumulativeTimeWeight => { GRP => "300A", ELEM => "02C8", VR => "DS" },
                                            BrachyControlPointSequence => { GRP => "300A", ELEM => "02D0", VR => "SQ" },
                                          ControlPointRelativePosition => { GRP => "300A", ELEM => "02D2", VR => "DS" },
                                                ControlPoint3DPosition => { GRP => "300A", ELEM => "02D4", VR => "DS" },
                                                  CumulativeTimeWeight => { GRP => "300A", ELEM => "02D6", VR => "DS" },
                                                 CompensatorDivergence => { GRP => "300A", ELEM => "02E0", VR => "CS" },
                                           CompensatorMountingPosition => { GRP => "300A", ELEM => "02E1", VR => "CS" },
                                           SourceToCompensatorDistance => { GRP => "300A", ELEM => "02E2", VR => "DS" },
                          TotalCompensatorTrayWaterEquivalentThickness => { GRP => "300A", ELEM => "02E3", VR => "FL" },
                                    IsocenterToCompensatorTrayDistance => { GRP => "300A", ELEM => "02E4", VR => "FL" },
                                               CompensatorColumnOffset => { GRP => "300A", ELEM => "02E5", VR => "FL" },
                                       IsocenterToCompensatorDistances => { GRP => "300A", ELEM => "02E6", VR => "FL" },
                                 CompensatorRelativeStoppingPowerRatio => { GRP => "300A", ELEM => "02E7", VR => "FL" },
                                        CompensatorMillingToolDiameter => { GRP => "300A", ELEM => "02E8", VR => "FL" },
                                           IonRangeCompensatorSequence => { GRP => "300A", ELEM => "02EA", VR => "SQ" },
                                                CompensatorDescription => { GRP => "300A", ELEM => "02EB", VR => "LT" },
                                                   RadiationMassNumber => { GRP => "300A", ELEM => "0302", VR => "IS" },
                                                 RadiationAtomicNumber => { GRP => "300A", ELEM => "0304", VR => "IS" },
                                                  RadiationChargeState => { GRP => "300A", ELEM => "0306", VR => "SS" },
                                                              ScanMode => { GRP => "300A", ELEM => "0308", VR => "CS" },
                                            VirtualSourceAxisDistances => { GRP => "300A", ELEM => "030A", VR => "FL" },
                                                         SnoutSequence => { GRP => "300A", ELEM => "030C", VR => "SQ" },
                                                         SnoutPosition => { GRP => "300A", ELEM => "030D", VR => "FL" },
                                                               SnoutID => { GRP => "300A", ELEM => "030F", VR => "SH" },
                                                 NumberOfRangeShifters => { GRP => "300A", ELEM => "0312", VR => "IS" },
                                                  RangeShifterSequence => { GRP => "300A", ELEM => "0314", VR => "SQ" },
                                                    RangeShifterNumber => { GRP => "300A", ELEM => "0316", VR => "IS" },
                                                        RangeShifterID => { GRP => "300A", ELEM => "0318", VR => "SH" },
                                                      RangeShifterType => { GRP => "300A", ELEM => "0320", VR => "CS" },
                                               RangeShifterDescription => { GRP => "300A", ELEM => "0322", VR => "LO" },
                                       NumberOfLateralSpreadingDevices => { GRP => "300A", ELEM => "0330", VR => "IS" },
                                        LateralSpreadingDeviceSequence => { GRP => "300A", ELEM => "0332", VR => "SQ" },
                                          LateralSpreadingDeviceNumber => { GRP => "300A", ELEM => "0334", VR => "IS" },
                                              LateralSpreadingDeviceID => { GRP => "300A", ELEM => "0336", VR => "SH" },
                                            LateralSpreadingDeviceType => { GRP => "300A", ELEM => "0338", VR => "CS" },
                                     LateralSpreadingDeviceDescription => { GRP => "300A", ELEM => "033A", VR => "LO" },
                        LateralSpreadingDeviceWaterEquivalentThickness => { GRP => "300A", ELEM => "033C", VR => "FL" },
                                               NumberOfRangeModulators => { GRP => "300A", ELEM => "0340", VR => "IS" },
                                                RangeModulatorSequence => { GRP => "300A", ELEM => "0342", VR => "SQ" },
                                                  RangeModulatorNumber => { GRP => "300A", ELEM => "0344", VR => "IS" },
                                                      RangeModulatorID => { GRP => "300A", ELEM => "0346", VR => "SH" },
                                                    RangeModulatorType => { GRP => "300A", ELEM => "0348", VR => "CS" },
                                             RangeModulatorDescription => { GRP => "300A", ELEM => "034A", VR => "LO" },
                                               BeamCurrentModulationID => { GRP => "300A", ELEM => "034C", VR => "SH" },
                                                    PatientSupportType => { GRP => "300A", ELEM => "0350", VR => "CS" },
                                                      PatientSupportID => { GRP => "300A", ELEM => "0352", VR => "SH" },
                                           PatientSupportAccessoryCode => { GRP => "300A", ELEM => "0354", VR => "LO" },
                                           FixationLightAzimuthalAngle => { GRP => "300A", ELEM => "0356", VR => "FL" },
                                               FixationLightPolarAngle => { GRP => "300A", ELEM => "0358", VR => "FL" },
                                                          MetersetRate => { GRP => "300A", ELEM => "035A", VR => "FL" },
                                          RangeShifterSettingsSequence => { GRP => "300A", ELEM => "0360", VR => "SQ" },
                                                   RangeShifterSetting => { GRP => "300A", ELEM => "0362", VR => "LO" },
                                       IsocenterToRangeShifterDistance => { GRP => "300A", ELEM => "0364", VR => "FL" },
                                  RangeShifterWaterEquivalentThickness => { GRP => "300A", ELEM => "0366", VR => "FL" },
                                LateralSpreadingDeviceSettingsSequence => { GRP => "300A", ELEM => "0370", VR => "SQ" },
                                         LateralSpreadingDeviceSetting => { GRP => "300A", ELEM => "0372", VR => "LO" },
                             IsocenterToLateralSpreadingDeviceDistance => { GRP => "300A", ELEM => "0374", VR => "FL" },
                                        RangeModulatorSettingsSequence => { GRP => "300A", ELEM => "0380", VR => "SQ" },
                                        RangeModulatorGatingStartValue => { GRP => "300A", ELEM => "0382", VR => "FL" },
                                         RangeModulatorGatingStopValue => { GRP => "300A", ELEM => "0384", VR => "FL" },
                     RangeModulatorGatingStartWaterEquivalentThickness => { GRP => "300A", ELEM => "0386", VR => "FL" },
                      RangeModulatorGatingStopWaterEquivalentThickness => { GRP => "300A", ELEM => "0388", VR => "FL" },
                                     IsocenterToRangeModulatorDistance => { GRP => "300A", ELEM => "038A", VR => "FL" },
                                                        ScanSpotTuneID => { GRP => "300A", ELEM => "0390", VR => "SH" },
                                             NumberOfScanSpotPositions => { GRP => "300A", ELEM => "0392", VR => "IS" },
                                                   ScanSpotPositionMap => { GRP => "300A", ELEM => "0394", VR => "FL" },
                                               ScanSpotMetersetWeights => { GRP => "300A", ELEM => "0396", VR => "FL" },
                                                      ScanningSpotSize => { GRP => "300A", ELEM => "0398", VR => "FL" },
                                                     NumberOfPaintings => { GRP => "300A", ELEM => "039A", VR => "IS" },
                                             IonToleranceTableSequence => { GRP => "300A", ELEM => "03A0", VR => "SQ" },
                                                       IonBeamSequence => { GRP => "300A", ELEM => "03A2", VR => "SQ" },
                                         IonBeamLimitingDeviceSequence => { GRP => "300A", ELEM => "03A4", VR => "SQ" },
                                                      IonBlockSequence => { GRP => "300A", ELEM => "03A6", VR => "SQ" },
                                               IonControlPointSequence => { GRP => "300A", ELEM => "03A8", VR => "SQ" },
                                                      IonWedgeSequence => { GRP => "300A", ELEM => "03AA", VR => "SQ" },
                                              IonWedgePositionSequence => { GRP => "300A", ELEM => "03AC", VR => "SQ" },
                                          ReferencedSetupImageSequence => { GRP => "300A", ELEM => "0401", VR => "SQ" },
                                                     SetupImageComment => { GRP => "300A", ELEM => "0402", VR => "ST" },
                                         MotionSynchronizationSequence => { GRP => "300A", ELEM => "0410", VR => "SQ" },
                                               ControlPointOrientation => { GRP => "300A", ELEM => "0412", VR => "FL" },
                                              GeneralAccessorySequence => { GRP => "300A", ELEM => "0420", VR => "SQ" },
                                                    GeneralAccessoryID => { GRP => "300A", ELEM => "0421", VR => "CS" },
                                           GeneralAccessoryDescription => { GRP => "300A", ELEM => "0422", VR => "ST" },
                                                  GeneralAccessoryType => { GRP => "300A", ELEM => "0423", VR => "SH" },
                                                GeneralAccessoryNumber => { GRP => "300A", ELEM => "0424", VR => "IS" },
                                              ReferencedRTPlanSequence => { GRP => "300C", ELEM => "0002", VR => "SQ" },
                                                ReferencedBeamSequence => { GRP => "300C", ELEM => "0004", VR => "SQ" },
                                                  ReferencedBeamNumber => { GRP => "300C", ELEM => "0006", VR => "IS" },
                                        ReferencedReferenceImageNumber => { GRP => "300C", ELEM => "0007", VR => "IS" },
                                         StartCumulativeMetersetWeight => { GRP => "300C", ELEM => "0008", VR => "DS" },
                                           EndCumulativeMetersetWeight => { GRP => "300C", ELEM => "0009", VR => "DS" },
                              ReferencedBrachyApplicationSetupSequence => { GRP => "300C", ELEM => "000A", VR => "SQ" },
                                ReferencedBrachyApplicationSetupNumber => { GRP => "300C", ELEM => "000C", VR => "IS" },
                                                ReferencedSourceNumber => { GRP => "300C", ELEM => "000E", VR => "IS" },
                                       ReferencedFractionGroupSequence => { GRP => "300C", ELEM => "0020", VR => "SQ" },
                                         ReferencedFractionGroupNumber => { GRP => "300C", ELEM => "0022", VR => "IS" },
                                   ReferencedVerificationImageSequence => { GRP => "300C", ELEM => "0040", VR => "SQ" },
                                      ReferencedReferenceImageSequence => { GRP => "300C", ELEM => "0042", VR => "SQ" },
                                       ReferencedDoseReferenceSequence => { GRP => "300C", ELEM => "0050", VR => "SQ" },
                                         ReferencedDoseReferenceNumber => { GRP => "300C", ELEM => "0051", VR => "IS" },
                                 BrachyReferencedDoseReferenceSequence => { GRP => "300C", ELEM => "0055", VR => "SQ" },
                                        ReferencedStructureSetSequence => { GRP => "300C", ELEM => "0060", VR => "SQ" },
                                          ReferencedPatientSetupNumber => { GRP => "300C", ELEM => "006A", VR => "IS" },
                                                ReferencedDoseSequence => { GRP => "300C", ELEM => "0080", VR => "SQ" },
                                        ReferencedToleranceTableNumber => { GRP => "300C", ELEM => "00A0", VR => "IS" },
                                               ReferencedBolusSequence => { GRP => "300C", ELEM => "00B0", VR => "SQ" },
                                                 ReferencedWedgeNumber => { GRP => "300C", ELEM => "00C0", VR => "IS" },
                                           ReferencedCompensatorNumber => { GRP => "300C", ELEM => "00D0", VR => "IS" },
                                                 ReferencedBlockNumber => { GRP => "300C", ELEM => "00E0", VR => "IS" },
                                           ReferencedControlPointIndex => { GRP => "300C", ELEM => "00F0", VR => "IS" },
                                        ReferencedControlPointSequence => { GRP => "300C", ELEM => "00F2", VR => "SQ" },
                                      ReferencedStartControlPointIndex => { GRP => "300C", ELEM => "00F4", VR => "IS" },
                                       ReferencedStopControlPointIndex => { GRP => "300C", ELEM => "00F6", VR => "IS" },
                                          ReferencedRangeShifterNumber => { GRP => "300C", ELEM => "0100", VR => "IS" },
                                ReferencedLateralSpreadingDeviceNumber => { GRP => "300C", ELEM => "0102", VR => "IS" },
                                        ReferencedRangeModulatorNumber => { GRP => "300C", ELEM => "0104", VR => "IS" },
                                                        ApprovalStatus => { GRP => "300E", ELEM => "0002", VR => "CS" },
                                                            ReviewDate => { GRP => "300E", ELEM => "0004", VR => "DA" },
                                                            ReviewTime => { GRP => "300E", ELEM => "0005", VR => "TM" },
                                                          ReviewerName => { GRP => "300E", ELEM => "0008", VR => "PN" },
                                                 MACParametersSequence => { GRP => "4FFE", ELEM => "0001", VR => "SQ" },
                                        SharedFunctionalGroupsSequence => { GRP => "5200", ELEM => "9229", VR => "SQ" },
                                      PerFrameFunctionalGroupsSequence => { GRP => "5200", ELEM => "9230", VR => "SQ" },
                                                      WaveformSequence => { GRP => "5400", ELEM => "0100", VR => "SQ" },
                                                   ChannelMinimumValue => { GRP => "5400", ELEM => "0110", VR => "ox" },
                                                   ChannelMaximumValue => { GRP => "5400", ELEM => "0112", VR => "ox" },
                                                 WaveformBitsAllocated => { GRP => "5400", ELEM => "1004", VR => "US" },
                                          WaveformSampleInterpretation => { GRP => "5400", ELEM => "1006", VR => "CS" },
                                                  WaveformPaddingValue => { GRP => "5400", ELEM => "100A", VR => "ox" },
                                                          WaveformData => { GRP => "5400", ELEM => "1010", VR => "ox" },
                                        FirstOrderPhaseCorrectionAngle => { GRP => "5600", ELEM => "0010", VR => "OF" },
                                                      SpectroscopyData => { GRP => "5600", ELEM => "0020", VR => "OF" },
                                                             PixelData => { GRP => "7FE0", ELEM => "0010", VR => "ox" },
                                             DigitalSignaturesSequence => { GRP => "FFFA", ELEM => "FFFA", VR => "SQ" },
                                                DataSetTrailingPadding => { GRP => "FFFC", ELEM => "FFFC", VR => "OB" },
                                                                  Item => { GRP => "FFFE", ELEM => "E000", VR => "na" },
                                                  ItemDelimitationItem => { GRP => "FFFE", ELEM => "E00D", VR => "na" },
                                              SequenceDelimitationItem => { GRP => "FFFE", ELEM => "E0DD", VR => "na" },
                                                    EventTimerSequence => { GRP => "0008", ELEM => "2133", VR => "SQ" },
                                                       EventTimeOffset => { GRP => "0008", ELEM => "2134", VR => "FD" },
                                                     EventCodeSequence => { GRP => "0008", ELEM => "2135", VR => "SQ" },
                                                         DepthsOfFocus => { GRP => "0018", ELEM => "9801", VR => "FD" },
                                             ExcludedIntervalsSequence => { GRP => "0018", ELEM => "9803", VR => "SQ" },
                                                ExclusionStartDateTime => { GRP => "0018", ELEM => "9804", VR => "DT" },
                                                     ExclusionDuration => { GRP => "0018", ELEM => "9805", VR => "FD" },
                                            USImageDescriptionSequence => { GRP => "0018", ELEM => "9806", VR => "SQ" },
                                                 ImageDataTypeSequence => { GRP => "0018", ELEM => "9807", VR => "SQ" },
                                                              DataType => { GRP => "0018", ELEM => "9808", VR => "CS" },
                                     TransducerScanPatternCodeSequence => { GRP => "0018", ELEM => "9809", VR => "SQ" },
                                                       AliasedDataType => { GRP => "0018", ELEM => "980B", VR => "CS" },
                                           PositionMeasuringDeviceUsed => { GRP => "0018", ELEM => "980C", VR => "CS" },
                                        TransducerGeometryCodeSequence => { GRP => "0018", ELEM => "980D", VR => "SQ" },
                                    TransducerBeamSteeringCodeSequence => { GRP => "0018", ELEM => "980E", VR => "SQ" },
                                     TransducerApplicationCodeSequence => { GRP => "0018", ELEM => "980F", VR => "SQ" },
                                                   ImagePositionVolume => { GRP => "0020", ELEM => "9301", VR => "FD" },
                                                ImageOrientationVolume => { GRP => "0020", ELEM => "9302", VR => "FD" },
                                         UltrasoundAcquisitionGeometry => { GRP => "0020", ELEM => "9307", VR => "CS" },
                                                          ApexPosition => { GRP => "0020", ELEM => "9308", VR => "FD" },
                                       VolumeToTransducerMappingMatrix => { GRP => "0020", ELEM => "9309", VR => "FD" },
                                            VolumeToTableMappingMatrix => { GRP => "0020", ELEM => "930A", VR => "FD" },
                                         PatientFrameOfReferenceSource => { GRP => "0020", ELEM => "930C", VR => "CS" },
                                            TemporalPositionTimeOffset => { GRP => "0020", ELEM => "930D", VR => "FD" },
                                           PlanePositionVolumeSequence => { GRP => "0020", ELEM => "930E", VR => "SQ" },
                                        PlaneOrientationVolumeSequence => { GRP => "0020", ELEM => "930F", VR => "SQ" },
                                              TemporalPositionSequence => { GRP => "0020", ELEM => "9310", VR => "SQ" },
                                             DimensionOrganizationType => { GRP => "0020", ELEM => "9311", VR => "CS" },
                                             VolumeFrameOfReferenceUID => { GRP => "0020", ELEM => "9312", VR => "UI" },
                                              TableFrameOfReferenceUID => { GRP => "0020", ELEM => "9313", VR => "UI" },
                                AlphaPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1104", VR => "US" },
                                      AlphaPaletteColorLookupTableData => { GRP => "0028", ELEM => "1204", VR => "OW" },
                                           DataFrameAssignmentSequence => { GRP => "0028", ELEM => "1401", VR => "SQ" },
                                                    DataPathAssignment => { GRP => "0028", ELEM => "1402", VR => "CS" },
                                          BitsMappedToColorLookupTable => { GRP => "0028", ELEM => "1403", VR => "US" },
                                                  BlendingLUT1Sequence => { GRP => "0028", ELEM => "1404", VR => "SQ" },
                                          BlendingLUT1TransferFunction => { GRP => "0028", ELEM => "1405", VR => "CS" },
                                                BlendingWeightConstant => { GRP => "0028", ELEM => "1406", VR => "FD" },
                                         BlendingLookupTableDescriptor => { GRP => "0028", ELEM => "1407", VR => "US" },
                                               BlendingLookupTableData => { GRP => "0028", ELEM => "1408", VR => "OW" },
                               EnhancedPaletteColorLookupTableSequence => { GRP => "0028", ELEM => "140B", VR => "SQ" },
                                                  BlendingLUT2Sequence => { GRP => "0028", ELEM => "140C", VR => "SQ" },
                                          BlendingLUT2TransferFunction => { GRP => "0028", ELEM => "140D", VR => "CS" },
                                                            DataPathID => { GRP => "0028", ELEM => "140E", VR => "CS" },
                                                RGBLUTTransferFunction => { GRP => "0028", ELEM => "140F", VR => "CS" },
                                              AlphaLUTTransferFunction => { GRP => "0028", ELEM => "1410", VR => "CS" },
                                                 PerformedProtocolType => { GRP => "0040", ELEM => "0261", VR => "CS" },
                                     RETIRED_MRDRDirectoryRecordOffset => { GRP => "0004", ELEM => "1504", VR => "up" },
                                            RETIRED_NumberOfReferences => { GRP => "0004", ELEM => "1600", VR => "UL" },
                                                   RETIRED_OverlayDate => { GRP => "0008", ELEM => "0024", VR => "DA" },
                                                     RETIRED_CurveDate => { GRP => "0008", ELEM => "0025", VR => "DA" },
                                                   RETIRED_OverlayTime => { GRP => "0008", ELEM => "0034", VR => "TM" },
                                                     RETIRED_CurveTime => { GRP => "0008", ELEM => "0035", VR => "TM" },
                                     RETIRED_NuclearMedicineSeriesType => { GRP => "0008", ELEM => "0042", VR => "CS" },
                                     RETIRED_ReferencedResultsSequence => { GRP => "0008", ELEM => "1100", VR => "SQ" },
                                     RETIRED_ReferencedOverlaySequence => { GRP => "0008", ELEM => "1130", VR => "SQ" },
                                       RETIRED_ReferencedCurveSequence => { GRP => "0008", ELEM => "1145", VR => "SQ" },
                                  RETIRED_LossyImageCompressionRetired => { GRP => "0008", ELEM => "2110", VR => "CS" },
                                            RETIRED_TransducerPosition => { GRP => "0008", ELEM => "2200", VR => "CS" },
                                         RETIRED_TransducerOrientation => { GRP => "0008", ELEM => "2204", VR => "CS" },
                                             RETIRED_AnatomicStructure => { GRP => "0008", ELEM => "2208", VR => "CS" },
                                    RETIRED_TransducerPositionSequence => { GRP => "0008", ELEM => "2240", VR => "SQ" },
                            RETIRED_TransducerPositionModifierSequence => { GRP => "0008", ELEM => "2242", VR => "SQ" },
                                 RETIRED_TransducerOrientationSequence => { GRP => "0008", ELEM => "2244", VR => "SQ" },
                         RETIRED_TransducerOrientationModifierSequence => { GRP => "0008", ELEM => "2246", VR => "SQ" },
               RETIRED_AnatomicStructureSpaceOrRegionCodeSequenceTrial => { GRP => "0008", ELEM => "2251", VR => "SQ" },
                     RETIRED_AnatomicPortalOfEntranceCodeSequenceTrial => { GRP => "0008", ELEM => "2253", VR => "SQ" },
                    RETIRED_AnatomicApproachDirectionCodeSequenceTrial => { GRP => "0008", ELEM => "2255", VR => "SQ" },
                           RETIRED_AnatomicPerspectiveDescriptionTrial => { GRP => "0008", ELEM => "2256", VR => "ST" },
                          RETIRED_AnatomicPerspectiveCodeSequenceTrial => { GRP => "0008", ELEM => "2257", VR => "SQ" },
         RETIRED_AnatomicLocationOfExaminingInstrumentDescriptionTrial => { GRP => "0008", ELEM => "2258", VR => "ST" },
        RETIRED_AnatomicLocationOfExaminingInstrumentCodeSequenceTrial => { GRP => "0008", ELEM => "2259", VR => "SQ" },
       RETIRED_AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial => { GRP => "0008", ELEM => "225A", VR => "SQ" },
            RETIRED_OnAxisBackgroundAnatomicStructureCodeSequenceTrial => { GRP => "0008", ELEM => "225C", VR => "SQ" },
                                                  RETIRED_Radionuclide => { GRP => "0018", ELEM => "0030", VR => "LO" },
                                        RETIRED_EnergyWindowCenterline => { GRP => "0018", ELEM => "0032", VR => "DS" },
                                        RETIRED_EnergyWindowTotalWidth => { GRP => "0018", ELEM => "0033", VR => "DS" },
                                                   RETIRED_TherapyType => { GRP => "0018", ELEM => "0037", VR => "CS" },
                                            RETIRED_TherapyDescription => { GRP => "0018", ELEM => "0039", VR => "CS" },
                                      RETIRED_HardcopyCreationDeviceID => { GRP => "0018", ELEM => "1011", VR => "LO" },
                                    RETIRED_HardcopyDeviceManufacturer => { GRP => "0018", ELEM => "1017", VR => "LO" },
                                 RETIRED_HardcopyDeviceSoftwareVersion => { GRP => "0018", ELEM => "101A", VR => "LO" },
                          RETIRED_HardcopyDeviceManufacturersModelName => { GRP => "0018", ELEM => "101B", VR => "LO" },
                                               RETIRED_AngularPosition => { GRP => "0018", ELEM => "1141", VR => "DS" },
                                                RETIRED_RotationOffset => { GRP => "0018", ELEM => "1146", VR => "DS" },
                                        RETIRED_PostprocessingFunction => { GRP => "0018", ELEM => "5021", VR => "LO" },
                                     RETIRED_ImageTransformationMatrix => { GRP => "0018", ELEM => "5210", VR => "DS" },
                                        RETIRED_ImageTranslationVector => { GRP => "0018", ELEM => "5212", VR => "DS" },
                           RETIRED_DopplerSampleVolumeXPositionRetired => { GRP => "0018", ELEM => "6038", VR => "UL" },
                           RETIRED_DopplerSampleVolumeYPositionRetired => { GRP => "0018", ELEM => "603A", VR => "UL" },
                                       RETIRED_TMLinePositionX0Retired => { GRP => "0018", ELEM => "603C", VR => "UL" },
                                       RETIRED_TMLinePositionY0Retired => { GRP => "0018", ELEM => "603E", VR => "UL" },
                                       RETIRED_TMLinePositionX1Retired => { GRP => "0018", ELEM => "6040", VR => "UL" },
                                       RETIRED_TMLinePositionY1Retired => { GRP => "0018", ELEM => "6042", VR => "UL" },
                         RETIRED_ParallelReductionFactorInPlaneRetired => { GRP => "0018", ELEM => "9096", VR => "FD" },
                                              RETIRED_BulkMotionStatus => { GRP => "0018", ELEM => "9166", VR => "CS" },
                     RETIRED_ChemicalShiftsMinimumIntegrationLimitInHz => { GRP => "0018", ELEM => "9195", VR => "FD" },
                     RETIRED_ChemicalShiftsMaximumIntegrationLimitInHz => { GRP => "0018", ELEM => "9196", VR => "FD" },
                  RETIRED_Attribute00189445UsedInadvertentlyInAProduct => { GRP => "0018", ELEM => "9445", VR => "UN" },
                                                 RETIRED_IsotopeNumber => { GRP => "0020", ELEM => "0014", VR => "IS" },
                                                   RETIRED_PhaseNumber => { GRP => "0020", ELEM => "0015", VR => "IS" },
                                                RETIRED_IntervalNumber => { GRP => "0020", ELEM => "0016", VR => "IS" },
                                                RETIRED_TimeSlotNumber => { GRP => "0020", ELEM => "0017", VR => "IS" },
                                                   RETIRED_AngleNumber => { GRP => "0020", ELEM => "0018", VR => "IS" },
                                                 RETIRED_OverlayNumber => { GRP => "0020", ELEM => "0022", VR => "IS" },
                                                   RETIRED_CurveNumber => { GRP => "0020", ELEM => "0024", VR => "IS" },
                                             RETIRED_LookupTableNumber => { GRP => "0020", ELEM => "0026", VR => "IS" },
                                                 RETIRED_SeriesInStudy => { GRP => "0020", ELEM => "1000", VR => "IS" },
                                           RETIRED_AcquisitionsInStudy => { GRP => "0020", ELEM => "1004", VR => "IS" },
                                             RETIRED_OtherStudyNumbers => { GRP => "0020", ELEM => "1070", VR => "IS" },
                                                        RETIRED_Planes => { GRP => "0028", ELEM => "0012", VR => "US" },
                  RETIRED_Attribute00280020UsedInadvertentlyInAProduct => { GRP => "0028", ELEM => "0020", VR => "UN" },
                                RETIRED_SmallestImagePixelValueInPlane => { GRP => "0028", ELEM => "0110", VR => "xs" },
                                 RETIRED_LargestImagePixelValueInPlane => { GRP => "0028", ELEM => "0111", VR => "xs" },
                     RETIRED_LargeRedPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1111", VR => "xs" },
                   RETIRED_LargeGreenPaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1112", VR => "xs" },
                    RETIRED_LargeBluePaletteColorLookupTableDescriptor => { GRP => "0028", ELEM => "1113", VR => "xs" },
                           RETIRED_LargeRedPaletteColorLookupTableData => { GRP => "0028", ELEM => "1211", VR => "OW" },
                         RETIRED_LargeGreenPaletteColorLookupTableData => { GRP => "0028", ELEM => "1212", VR => "OW" },
                          RETIRED_LargeBluePaletteColorLookupTableData => { GRP => "0028", ELEM => "1213", VR => "OW" },
                               RETIRED_LargePaletteColorLookupTableUID => { GRP => "0028", ELEM => "1214", VR => "UI" },
                                    RETIRED_BiPlaneAcquisitionSequence => { GRP => "0028", ELEM => "5000", VR => "SQ" },
                                                  RETIRED_MaskPointers => { GRP => "0028", ELEM => "6030", VR => "US" },
                                   RETIRED_LargestMonochromePixelValue => { GRP => "0028", ELEM => "9099", VR => "US" },
                                                 RETIRED_StudyStatusID => { GRP => "0032", ELEM => "000A", VR => "CS" },
                                               RETIRED_StudyPriorityID => { GRP => "0032", ELEM => "000C", VR => "CS" },
                                                 RETIRED_StudyIDIssuer => { GRP => "0032", ELEM => "0012", VR => "LO" },
                                             RETIRED_StudyVerifiedDate => { GRP => "0032", ELEM => "0032", VR => "DA" },
                                             RETIRED_StudyVerifiedTime => { GRP => "0032", ELEM => "0033", VR => "TM" },
                                                 RETIRED_StudyReadDate => { GRP => "0032", ELEM => "0034", VR => "DA" },
                                                 RETIRED_StudyReadTime => { GRP => "0032", ELEM => "0035", VR => "TM" },
                                       RETIRED_ScheduledStudyStartDate => { GRP => "0032", ELEM => "1000", VR => "DA" },
                                       RETIRED_ScheduledStudyStartTime => { GRP => "0032", ELEM => "1001", VR => "TM" },
                                        RETIRED_ScheduledStudyStopDate => { GRP => "0032", ELEM => "1010", VR => "DA" },
                                        RETIRED_ScheduledStudyStopTime => { GRP => "0032", ELEM => "1011", VR => "TM" },
                                        RETIRED_ScheduledStudyLocation => { GRP => "0032", ELEM => "1020", VR => "LO" },
                                 RETIRED_ScheduledStudyLocationAETitle => { GRP => "0032", ELEM => "1021", VR => "AE" },
                                                RETIRED_ReasonForStudy => { GRP => "0032", ELEM => "1030", VR => "LO" },
                                              RETIRED_StudyArrivalDate => { GRP => "0032", ELEM => "1040", VR => "DA" },
                                              RETIRED_StudyArrivalTime => { GRP => "0032", ELEM => "1041", VR => "TM" },
                                           RETIRED_StudyCompletionDate => { GRP => "0032", ELEM => "1050", VR => "DA" },
                                           RETIRED_StudyCompletionTime => { GRP => "0032", ELEM => "1051", VR => "TM" },
                                        RETIRED_StudyComponentStatusID => { GRP => "0032", ELEM => "1055", VR => "CS" },
                                                 RETIRED_StudyComments => { GRP => "0032", ELEM => "4000", VR => "LT" },
                                        RETIRED_ScheduledAdmissionDate => { GRP => "0038", ELEM => "001A", VR => "DA" },
                                        RETIRED_ScheduledAdmissionTime => { GRP => "0038", ELEM => "001B", VR => "TM" },
                                        RETIRED_ScheduledDischargeDate => { GRP => "0038", ELEM => "001C", VR => "DA" },
                                        RETIRED_ScheduledDischargeTime => { GRP => "0038", ELEM => "001D", VR => "TM" },
                          RETIRED_ScheduledPatientInstitutionResidence => { GRP => "0038", ELEM => "001E", VR => "LO" },
                                                 RETIRED_DischargeDate => { GRP => "0038", ELEM => "0030", VR => "DA" },
                                                 RETIRED_DischargeTime => { GRP => "0038", ELEM => "0032", VR => "TM" },
                                 RETIRED_DischargeDiagnosisDescription => { GRP => "0038", ELEM => "0040", VR => "LO" },
                                RETIRED_DischargeDiagnosisCodeSequence => { GRP => "0038", ELEM => "0044", VR => "SQ" },
                                       RETIRED_DistanceSourceToSupport => { GRP => "0040", ELEM => "0307", VR => "DS" },
                               RETIRED_ReferencedProcedureStepSequence => { GRP => "0040", ELEM => "0330", VR => "SQ" },
                              RETIRED_SpecimenDescriptionSequenceTrial => { GRP => "0040", ELEM => "0552", VR => "SQ" },
                                      RETIRED_SpecimenDescriptionTrial => { GRP => "0040", ELEM => "0553", VR => "ST" },
                                   RETIRED_VitalStainCodeSequenceTrial => { GRP => "0040", ELEM => "09F8", VR => "SQ" },
                                    RETIRED_PlacerOrderNumberProcedure => { GRP => "0040", ELEM => "1006", VR => "SH" },
                                    RETIRED_FillerOrderNumberProcedure => { GRP => "0040", ELEM => "1007", VR => "SH" },
                             RETIRED_ReasonForTheImagingServiceRequest => { GRP => "0040", ELEM => "2001", VR => "LO" },
                 RETIRED_PlacerOrderNumberImagingServiceRequestRetired => { GRP => "0040", ELEM => "2006", VR => "SH" },
                 RETIRED_FillerOrderNumberImagingServiceRequestRetired => { GRP => "0040", ELEM => "2007", VR => "SH" },
                                 RETIRED_EquivalentCDADocumentSequence => { GRP => "0040", ELEM => "A090", VR => "SQ" },
                                                  RETIRED_AddressTrial => { GRP => "0040", ELEM => "A353", VR => "ST" },
                                          RETIRED_TelephoneNumberTrial => { GRP => "0040", ELEM => "A354", VR => "LO" },
                                               RETIRED_TemplateVersion => { GRP => "0040", ELEM => "DB06", VR => "DT" },
                                          RETIRED_TemplateLocalVersion => { GRP => "0040", ELEM => "DB07", VR => "DT" },
                                         RETIRED_TemplateExtensionFlag => { GRP => "0040", ELEM => "DB0B", VR => "CS" },
                              RETIRED_TemplateExtensionOrganizationUID => { GRP => "0040", ELEM => "DB0C", VR => "UI" },
                                   RETIRED_TemplateExtensionCreatorUID => { GRP => "0040", ELEM => "DB0D", VR => "UI" },
                                                RETIRED_CountsIncluded => { GRP => "0054", ELEM => "1400", VR => "CS" },
                                        RETIRED_DeadTimeCorrectionFlag => { GRP => "0054", ELEM => "1401", VR => "CS" },
                                          RETIRED_ImageRotationRetired => { GRP => "0070", ELEM => "0040", VR => "IS" },
                           RETIRED_DisplayedAreaTopLeftHandCornerTrial => { GRP => "0070", ELEM => "0050", VR => "US" },
                       RETIRED_DisplayedAreaBottomRightHandCornerTrial => { GRP => "0070", ELEM => "0051", VR => "US" },
                        RETIRED_GraphicLayerRecommendedDisplayRGBValue => { GRP => "0070", ELEM => "0067", VR => "US" },
                                                    RETIRED_TopicTitle => { GRP => "0088", ELEM => "0904", VR => "LO" },
                                                  RETIRED_TopicSubject => { GRP => "0088", ELEM => "0906", VR => "ST" },
                                                   RETIRED_TopicAuthor => { GRP => "0088", ELEM => "0910", VR => "LO" },
                                                 RETIRED_TopicKeywords => { GRP => "0088", ELEM => "0912", VR => "LO" },
                                        RETIRED_ColorImagePrintingFlag => { GRP => "2000", ELEM => "0062", VR => "CS" },
                                                 RETIRED_CollationFlag => { GRP => "2000", ELEM => "0063", VR => "CS" },
                                                RETIRED_AnnotationFlag => { GRP => "2000", ELEM => "0065", VR => "CS" },
                                              RETIRED_ImageOverlayFlag => { GRP => "2000", ELEM => "0067", VR => "CS" },
                                           RETIRED_PresentationLUTFlag => { GRP => "2000", ELEM => "0069", VR => "CS" },
                                   RETIRED_ImageBoxPresentationLUTFlag => { GRP => "2000", ELEM => "006A", VR => "CS" },
                                 RETIRED_ReferencedStoredPrintSequence => { GRP => "2000", ELEM => "0510", VR => "SQ" },
                             RETIRED_ReferencedImageOverlayBoxSequence => { GRP => "2020", ELEM => "0130", VR => "SQ" },
                                   RETIRED_ReferencedVOILUTBoxSequence => { GRP => "2020", ELEM => "0140", VR => "SQ" },
                                RETIRED_ReferencedOverlayPlaneSequence => { GRP => "2040", ELEM => "0010", VR => "SQ" },
                                  RETIRED_ReferencedOverlayPlaneGroups => { GRP => "2040", ELEM => "0011", VR => "US" },
                                      RETIRED_OverlayPixelDataSequence => { GRP => "2040", ELEM => "0020", VR => "SQ" },
                                      RETIRED_OverlayMagnificationType => { GRP => "2040", ELEM => "0060", VR => "CS" },
                                          RETIRED_OverlaySmoothingType => { GRP => "2040", ELEM => "0070", VR => "CS" },
                                   RETIRED_OverlayOrImageMagnification => { GRP => "2040", ELEM => "0072", VR => "CS" },
                                      RETIRED_MagnifyToNumberOfColumns => { GRP => "2040", ELEM => "0074", VR => "US" },
                                      RETIRED_OverlayForegroundDensity => { GRP => "2040", ELEM => "0080", VR => "CS" },
                                      RETIRED_OverlayBackgroundDensity => { GRP => "2040", ELEM => "0082", VR => "CS" },
                                                   RETIRED_OverlayMode => { GRP => "2040", ELEM => "0090", VR => "CS" },
                                              RETIRED_ThresholdDensity => { GRP => "2040", ELEM => "0100", VR => "CS" },
                             RETIRED_ReferencedImageBoxSequenceRetired => { GRP => "2040", ELEM => "0500", VR => "SQ" },
                                                    RETIRED_PrintJobID => { GRP => "2100", ELEM => "0010", VR => "SH" },
                                                 RETIRED_DestinationAE => { GRP => "2100", ELEM => "0140", VR => "AE" },
                     RETIRED_ReferencedPrintJobSequencePullStoredPrint => { GRP => "2100", ELEM => "0500", VR => "SQ" },
                                                  RETIRED_PrintQueueID => { GRP => "2110", ELEM => "0099", VR => "SH" },
                                                   RETIRED_QueueStatus => { GRP => "2120", ELEM => "0010", VR => "CS" },
                                   RETIRED_PrintJobDescriptionSequence => { GRP => "2120", ELEM => "0050", VR => "SQ" },
                                    RETIRED_ReferencedPrintJobSequence => { GRP => "2120", ELEM => "0070", VR => "SQ" },
                           RETIRED_PrintManagementCapabilitiesSequence => { GRP => "2130", ELEM => "0010", VR => "SQ" },
                                RETIRED_PrinterCharacteristicsSequence => { GRP => "2130", ELEM => "0015", VR => "SQ" },
                                        RETIRED_FilmBoxContentSequence => { GRP => "2130", ELEM => "0030", VR => "SQ" },
                                       RETIRED_ImageBoxContentSequence => { GRP => "2130", ELEM => "0040", VR => "SQ" },
                                     RETIRED_AnnotationContentSequence => { GRP => "2130", ELEM => "0050", VR => "SQ" },
                                RETIRED_ImageOverlayBoxContentSequence => { GRP => "2130", ELEM => "0060", VR => "SQ" },
                                RETIRED_PresentationLUTContentSequence => { GRP => "2130", ELEM => "0080", VR => "SQ" },
                                         RETIRED_ProposedStudySequence => { GRP => "2130", ELEM => "00A0", VR => "SQ" },
                                         RETIRED_OriginalImageSequence => { GRP => "2130", ELEM => "00C0", VR => "SQ" },
                                                     RETIRED_ResultsID => { GRP => "4008", ELEM => "0040", VR => "SH" },
                                               RETIRED_ResultsIDIssuer => { GRP => "4008", ELEM => "0042", VR => "LO" },
                              RETIRED_ReferencedInterpretationSequence => { GRP => "4008", ELEM => "0050", VR => "SQ" },
                                    RETIRED_InterpretationRecordedDate => { GRP => "4008", ELEM => "0100", VR => "DA" },
                                    RETIRED_InterpretationRecordedTime => { GRP => "4008", ELEM => "0101", VR => "TM" },
                                        RETIRED_InterpretationRecorder => { GRP => "4008", ELEM => "0102", VR => "PN" },
                                      RETIRED_ReferenceToRecordedSound => { GRP => "4008", ELEM => "0103", VR => "LO" },
                               RETIRED_InterpretationTranscriptionDate => { GRP => "4008", ELEM => "0108", VR => "DA" },
                               RETIRED_InterpretationTranscriptionTime => { GRP => "4008", ELEM => "0109", VR => "TM" },
                                     RETIRED_InterpretationTranscriber => { GRP => "4008", ELEM => "010A", VR => "PN" },
                                            RETIRED_InterpretationText => { GRP => "4008", ELEM => "010B", VR => "ST" },
                                          RETIRED_InterpretationAuthor => { GRP => "4008", ELEM => "010C", VR => "PN" },
                                RETIRED_InterpretationApproverSequence => { GRP => "4008", ELEM => "0111", VR => "SQ" },
                                    RETIRED_InterpretationApprovalDate => { GRP => "4008", ELEM => "0112", VR => "DA" },
                                    RETIRED_InterpretationApprovalTime => { GRP => "4008", ELEM => "0113", VR => "TM" },
                              RETIRED_PhysicianApprovingInterpretation => { GRP => "4008", ELEM => "0114", VR => "PN" },
                            RETIRED_InterpretationDiagnosisDescription => { GRP => "4008", ELEM => "0115", VR => "LT" },
                           RETIRED_InterpretationDiagnosisCodeSequence => { GRP => "4008", ELEM => "0117", VR => "SQ" },
                               RETIRED_ResultsDistributionListSequence => { GRP => "4008", ELEM => "0118", VR => "SQ" },
                                              RETIRED_DistributionName => { GRP => "4008", ELEM => "0119", VR => "PN" },
                                           RETIRED_DistributionAddress => { GRP => "4008", ELEM => "011A", VR => "LO" },
                                              RETIRED_InterpretationID => { GRP => "4008", ELEM => "0200", VR => "SH" },
                                        RETIRED_InterpretationIDIssuer => { GRP => "4008", ELEM => "0202", VR => "LO" },
                                          RETIRED_InterpretationTypeID => { GRP => "4008", ELEM => "0210", VR => "CS" },
                                        RETIRED_InterpretationStatusID => { GRP => "4008", ELEM => "0212", VR => "CS" },
                                                   RETIRED_Impressions => { GRP => "4008", ELEM => "0300", VR => "ST" },
                                               RETIRED_ResultsComments => { GRP => "4008", ELEM => "4000", VR => "ST" },
                                      ACR_NEMA_CommandGroupLengthToEnd => { GRP => "0000", ELEM => "0001", VR => "UL" },
                                       ACR_NEMA_CommandRecognitionCode => { GRP => "0000", ELEM => "0010", VR => "CS" },
                                                    ACR_NEMA_Initiator => { GRP => "0000", ELEM => "0200", VR => "LO" },
                                                     ACR_NEMA_Receiver => { GRP => "0000", ELEM => "0300", VR => "LO" },
                                                 ACR_NEMA_FindLocation => { GRP => "0000", ELEM => "0400", VR => "LO" },
                                              ACR_NEMA_NumberOfMatches => { GRP => "0000", ELEM => "0850", VR => "US" },
                                       ACR_NEMA_ResponseSequenceNumber => { GRP => "0000", ELEM => "0860", VR => "US" },
                                               ACR_NEMA_DialogReceiver => { GRP => "0000", ELEM => "4000", VR => "LO" },
                                                 ACR_NEMA_TerminalType => { GRP => "0000", ELEM => "4010", VR => "LO" },
                                                 ACR_NEMA_MessageSetID => { GRP => "0000", ELEM => "5010", VR => "LO" },
                                                ACR_NEMA_EndMessageSet => { GRP => "0000", ELEM => "5020", VR => "LO" },
                                                ACR_NEMA_DisplayFormat => { GRP => "0000", ELEM => "5110", VR => "LO" },
                                               ACR_NEMA_PagePositionID => { GRP => "0000", ELEM => "5120", VR => "LO" },
                                                 ACR_NEMA_TextFormatID => { GRP => "0000", ELEM => "5130", VR => "LO" },
                                                ACR_NEMA_NormalReverse => { GRP => "0000", ELEM => "5140", VR => "CS" },
                                                 ACR_NEMA_AddGrayScale => { GRP => "0000", ELEM => "5150", VR => "CS" },
                                                      ACR_NEMA_Borders => { GRP => "0000", ELEM => "5160", VR => "CS" },
                                                       ACR_NEMA_Copies => { GRP => "0000", ELEM => "5170", VR => "IS" },
                                            ACR_NEMA_MagnificationType => { GRP => "0000", ELEM => "5180", VR => "LO" },
                                                        ACR_NEMA_Erase => { GRP => "0000", ELEM => "5190", VR => "LO" },
                                                        ACR_NEMA_Print => { GRP => "0000", ELEM => "51A0", VR => "CS" },
                                                     ACR_NEMA_Overlays => { GRP => "0000", ELEM => "51B0", VR => "US" },
                                  ACR_NEMA_IdentifyingGroupLengthToEnd => { GRP => "0008", ELEM => "0001", VR => "UL" },
                                              ACR_NEMA_RecognitionCode => { GRP => "0008", ELEM => "0010", VR => "LO" },
                                               ACR_NEMA_OldDataSetType => { GRP => "0008", ELEM => "0040", VR => "US" },
                                               ACR_NEMA_DataSetSubtype => { GRP => "0008", ELEM => "0041", VR => "LO" },
                                                    ACR_NEMA_NetworkID => { GRP => "0008", ELEM => "1000", VR => "LO" },
                                          ACR_NEMA_IdentifyingComments => { GRP => "0008", ELEM => "4000", VR => "LT" },
                                  ACR_NEMA_InsurancePlanIdentification => { GRP => "0010", ELEM => "1050", VR => "LT" },
                                        ACR_NEMA_UpperLowerPixelValues => { GRP => "0018", ELEM => "1240", VR => "IS" },
                                          ACR_NEMA_AcquisitionComments => { GRP => "0018", ELEM => "4000", VR => "LT" },
                                                 ACR_NEMA_DynamicRange => { GRP => "0018", ELEM => "5030", VR => "DS" },
                                                    ACR_NEMA_TotalGain => { GRP => "0018", ELEM => "5040", VR => "DS" },
                                                ACR_NEMA_ImagePosition => { GRP => "0020", ELEM => "0030", VR => "DS" },
                                             ACR_NEMA_ImageOrientation => { GRP => "0020", ELEM => "0035", VR => "DS" },
                                                     ACR_NEMA_Location => { GRP => "0020", ELEM => "0050", VR => "DS" },
                                            ACR_NEMA_ImageGeometryType => { GRP => "0020", ELEM => "0070", VR => "LO" },
                                                 ACR_NEMA_MaskingImage => { GRP => "0020", ELEM => "0080", VR => "LO" },
                                         ACR_NEMA_AcquisitionsInSeries => { GRP => "0020", ELEM => "1001", VR => "IS" },
                                               ACR_NEMA_ImagesInSeries => { GRP => "0020", ELEM => "1003", VR => "IS" },
                                                ACR_NEMA_ImagesInStudy => { GRP => "0020", ELEM => "1005", VR => "IS" },
                                                    ACR_NEMA_Reference => { GRP => "0020", ELEM => "1020", VR => "LO" },
                                            ACR_NEMA_ModifyingDeviceID => { GRP => "0020", ELEM => "3401", VR => "LO" },
                                              ACR_NEMA_ModifiedImageID => { GRP => "0020", ELEM => "3402", VR => "LO" },
                                            ACR_NEMA_ModifiedImageDate => { GRP => "0020", ELEM => "3403", VR => "DA" },
                                  ACR_NEMA_ModifyingDeviceManufacturer => { GRP => "0020", ELEM => "3404", VR => "LO" },
                                            ACR_NEMA_ModifiedImageTime => { GRP => "0020", ELEM => "3405", VR => "TM" },
                                     ACR_NEMA_ModifiedImageDescription => { GRP => "0020", ELEM => "3406", VR => "LO" },
                                  ACR_NEMA_OriginalImageIdentification => { GRP => "0020", ELEM => "5000", VR => "AT" },
                      ACR_NEMA_OriginalImageIdentificationNomenclature => { GRP => "0020", ELEM => "5002", VR => "LO" },
                                              ACR_NEMA_ImageDimensions => { GRP => "0028", ELEM => "0005", VR => "US" },
                                                  ACR_NEMA_ImageFormat => { GRP => "0028", ELEM => "0040", VR => "CS" },
                                             ACR_NEMA_ManipulatedImage => { GRP => "0028", ELEM => "0050", VR => "LO" },
                                              ACR_NEMA_CompressionCode => { GRP => "0028", ELEM => "0060", VR => "CS" },
                                      ACR_NEMA_SmallestValidPixelValue => { GRP => "0028", ELEM => "0104", VR => "xs" },
                                       ACR_NEMA_LargestValidPixelValue => { GRP => "0028", ELEM => "0105", VR => "xs" },
                                                ACR_NEMA_ImageLocation => { GRP => "0028", ELEM => "0200", VR => "US" },
                                                    ACR_NEMA_GrayScale => { GRP => "0028", ELEM => "1080", VR => "CS" },
                                    ACR_NEMA_GrayLookupTableDescriptor => { GRP => "0028", ELEM => "1100", VR => "xs" },
                                          ACR_NEMA_GrayLookupTableData => { GRP => "0028", ELEM => "1200", VR => "xs" },
                                    ACR_NEMA_ImagePresentationComments => { GRP => "0028", ELEM => "4000", VR => "LT" },
                                              ACR_NEMA_TextGroupLength => { GRP => "4000", ELEM => "0000", VR => "UL" },
                                                ACR_NEMA_TextArbitrary => { GRP => "4000", ELEM => "0010", VR => "LT" },
                                                 ACR_NEMA_TextComments => { GRP => "4000", ELEM => "4000", VR => "LT" },
                                ACR_NEMA_2C_CompressionRecognitionCode => { GRP => "0028", ELEM => "005F", VR => "CS" },
                                     ACR_NEMA_2C_CompressionOriginator => { GRP => "0028", ELEM => "0061", VR => "SH" },
                                          ACR_NEMA_2C_CompressionLabel => { GRP => "0028", ELEM => "0062", VR => "SH" },
                                    ACR_NEMA_2C_CompressionDescription => { GRP => "0028", ELEM => "0063", VR => "SH" },
                                       ACR_NEMA_2C_CompressionSequence => { GRP => "0028", ELEM => "0065", VR => "CS" },
                                   ACR_NEMA_2C_CompressionStepPointers => { GRP => "0028", ELEM => "0066", VR => "AT" },
                                            ACR_NEMA_2C_RepeatInterval => { GRP => "0028", ELEM => "0068", VR => "US" },
                                               ACR_NEMA_2C_BitsGrouped => { GRP => "0028", ELEM => "0069", VR => "US" },
                                            ACR_NEMA_2C_PerimeterTable => { GRP => "0028", ELEM => "0070", VR => "US" },
                                            ACR_NEMA_2C_PerimeterValue => { GRP => "0028", ELEM => "0071", VR => "xs" },
                                             ACR_NEMA_2C_PredictorRows => { GRP => "0028", ELEM => "0080", VR => "US" },
                                          ACR_NEMA_2C_PredictorColumns => { GRP => "0028", ELEM => "0081", VR => "US" },
                                        ACR_NEMA_2C_PredictorConstants => { GRP => "0028", ELEM => "0082", VR => "US" },
                                             ACR_NEMA_2C_BlockedPixels => { GRP => "0028", ELEM => "0090", VR => "CS" },
                                                 ACR_NEMA_2C_BlockRows => { GRP => "0028", ELEM => "0091", VR => "US" },
                                              ACR_NEMA_2C_BlockColumns => { GRP => "0028", ELEM => "0092", VR => "US" },
                                                ACR_NEMA_2C_RowOverlap => { GRP => "0028", ELEM => "0093", VR => "US" },
                                             ACR_NEMA_2C_ColumnOverlap => { GRP => "0028", ELEM => "0094", VR => "US" },
                                            ACR_NEMA_2C_TransformLabel => { GRP => "0028", ELEM => "0400", VR => "CS" },
                                    ACR_NEMA_2C_TransformVersionNumber => { GRP => "0028", ELEM => "0401", VR => "CS" },
                                    ACR_NEMA_2C_NumberOfTransformSteps => { GRP => "0028", ELEM => "0402", VR => "US" },
                                  ACR_NEMA_2C_SequenceOfCompressedData => { GRP => "0028", ELEM => "0403", VR => "CS" },
                                     ACR_NEMA_2C_DetailsOfCoefficients => { GRP => "0028", ELEM => "0404", VR => "AT" },
                               ACR_NEMA_2C_RowsForNthOrderCoefficients => { GRP => "0028", ELEM => "0410", VR => "US" },
                            ACR_NEMA_2C_ColumnsForNthOrderCoefficients => { GRP => "0028", ELEM => "0411", VR => "US" },
                                         ACR_NEMA_2C_CoefficientCoding => { GRP => "0028", ELEM => "0412", VR => "CS" },
                                 ACR_NEMA_2C_CoefficientCodingPointers => { GRP => "0028", ELEM => "0413", VR => "AT" },
                                                  ACR_NEMA_2C_DCTLabel => { GRP => "0028", ELEM => "0700", VR => "CS" },
                                      ACR_NEMA_2C_DataBlockDescription => { GRP => "0028", ELEM => "0701", VR => "CS" },
                                                 ACR_NEMA_2C_DataBlock => { GRP => "0028", ELEM => "0702", VR => "AT" },
                                 ACR_NEMA_2C_NormalizationFactorFormat => { GRP => "0028", ELEM => "0710", VR => "US" },
                                      ACR_NEMA_2C_ZonalMapNumberFormat => { GRP => "0028", ELEM => "0720", VR => "US" },
                                          ACR_NEMA_2C_ZonalMapLocation => { GRP => "0028", ELEM => "0721", VR => "AT" },
                                            ACR_NEMA_2C_ZonalMapFormat => { GRP => "0028", ELEM => "0722", VR => "US" },
                                         ACR_NEMA_2C_AdaptiveMapFormat => { GRP => "0028", ELEM => "0730", VR => "US" },
                                          ACR_NEMA_2C_CodeNumberFormat => { GRP => "0028", ELEM => "0740", VR => "US" },
                                                 ACR_NEMA_2C_CodeLabel => { GRP => "0028", ELEM => "0800", VR => "CS" },
                                            ACR_NEMA_2C_NumberOfTables => { GRP => "0028", ELEM => "0802", VR => "US" },
                                         ACR_NEMA_2C_CodeTableLocation => { GRP => "0028", ELEM => "0803", VR => "AT" },
                                           ACR_NEMA_2C_BitsForCodeWord => { GRP => "0028", ELEM => "0804", VR => "US" },
                                         ACR_NEMA_2C_ImageDataLocation => { GRP => "0028", ELEM => "0808", VR => "AT" },
                                      ACR_NEMA_2C_CodeTableGroupLength => { GRP => "1000", ELEM => "0000", VR => "UL" },
                                             ACR_NEMA_2C_EscapeTriplet => { GRP => "1000", ELEM => "0010", VR => "US" },
                                          ACR_NEMA_2C_RunLengthTriplet => { GRP => "1000", ELEM => "0011", VR => "US" },
                                          ACR_NEMA_2C_HuffmanTableSize => { GRP => "1000", ELEM => "0012", VR => "US" },
                                       ACR_NEMA_2C_HuffmanTableTriplet => { GRP => "1000", ELEM => "0013", VR => "US" },
                                            ACR_NEMA_2C_ShiftTableSize => { GRP => "1000", ELEM => "0014", VR => "US" },
                                         ACR_NEMA_2C_ShiftTableTriplet => { GRP => "1000", ELEM => "0015", VR => "US" },
                                       ACR_NEMA_2C_ZonalMapGroupLength => { GRP => "1010", ELEM => "0000", VR => "UL" },
                                                  ACR_NEMA_2C_ZonalMap => { GRP => "1010", ELEM => "0004", VR => "US" },
                                          ACR_NEMA_2C_CoefficientsSDVN => { GRP => "7FE0", ELEM => "0020", VR => "OW" },
                                          ACR_NEMA_2C_CoefficientsSDHN => { GRP => "7FE0", ELEM => "0030", VR => "OW" },
                                          ACR_NEMA_2C_CoefficientsSDDN => { GRP => "7FE0", ELEM => "0040", VR => "OW" },
%dcmtk360DicomDictionary,
);

our %reverseDicomDictionary;
sub import
{
    my @ExporterList = ();
    my %h;
    while (my $x = shift)
    {
        push @ExporterList, $x unless $x =~ m/ADDITIONAL_TAGS/;
        $h{ADDITIONAL_TAGS} = shift if $x =~ m/ADDITIONAL_TAGS/;
    }
    %dcmtkDicomDictionary = (%dcmtkDicomDictionary, %{$h{ADDITIONAL_TAGS}}) if defined $h{ADDITIONAL_TAGS};    
    while (my ($dcm_dict_name, $entryref) = each %dcmtkDicomDictionary) {
        my $key = $entryref->{GRP} . $entryref->{ELEM};
        my $valRef = {DCM_DICT_NAME => $dcm_dict_name, VR => $entryref->{VR} };
        if (defined $Image::DCMTK::reverseDicomDictionary{$key} )
        {
            #duplicate keys, prefer unadorned to "ACR_NEMA" to "RETIRED"
            if ($dcm_dict_name =~ m/^RETIRED/)
            {
                # can't be prefered
            }
            elsif ($dcm_dict_name =~ m/^ACR_NEMA/)
            {
                # only beats RETIRED
                $Image::DCMTK::reverseDicomDictionary{$key} = $valRef if $Image::DCMTK::reverseDicomDictionary{$key}->{ DCM_DICT_NAME } =~ m/^RETIRED/;
            }
            else
            {
                # always wins, hope it isn't colliding with another tag
                $Image::DCMTK::reverseDicomDictionary{$key} = $valRef;
            }
        }
        else
        {
            $Image::DCMTK::reverseDicomDictionary{$key} = $valRef;
        }
    };
    Image::DCMTK->export_to_level(1, @ExporterList); 
}

# exported package globals go here


# TODO these command lines do not exist here!, they are from Getopt::CommandLineExports!!!
my %cmdLines = (
    makeXMLElement                  => [qw/GRP=s ELEM=s VR=s VM=i LEN=i DCM_DICT_NAME=s NAME=s VALUE=s BINARY=s/],
    returnTagAsXML                  => [qw/GRP=s ELEM=s VR=s VM=i LEN=i DCM_DICT_NAME=s NAME=s VALUE=s BINARY=s LEN=i CARDINALITY=i/],
    openXMLItem                     => [qw/LEN=i CARDINALITY=i/],
    openXMLSequence                 => [qw/GRP=s ELEM=s VR=s VM=i LEN=i DCM_DICT_NAME=s NAME=s CARDINALITY=i/],
    closeXMLItem                    => [qw//],
    closeXMLSequence                => [qw//],
    parseDCMDump                    => [qw/DCM_DUMP=s@ REGULAR_EXPRESSION=s DCM_TAGS_REQUESTED=s@/],
    parseDCMDumpForSequences        => [qw/DCM_DUMP=s@ REGULAR_EXPRESSION=s DCM_SEQUENCES_REQUESTED=s@/],
    parseDCMDumpForTagLists         => [qw/DCM_DUMP=s@ REGULAR_EXPRESSION=s DCM_TAGS_REQUESTED=s@/],
    parseDCMXMLDump                    => [qw/DCM_DUMP=s@ REGULAR_EXPRESSION=s DCM_TAGS_REQUESTED=s@/],
    parseDCMXMLDumpForSequences        => [qw/DCM_DUMP=s@ REGULAR_EXPRESSION=s DCM_SEQUENCES_REQUESTED=s@/],
    parseDCMXMLDumpForTagLists         => [qw/DCM_DUMP=s@ REGULAR_EXPRESSION=s DCM_TAGS_REQUESTED=s@/],
    modifyAnImage                   => [qw/SOURCE_FILENAME=s DESTINATION_FILENAME=s TAG_CHANGE_LINE=s/],
);

=head2 returnTagAsXML

Return an XML formatted string version of a given DICOM tag

You may use either a Group and Element type tag or a DICOM Dictionary Common Name (PatientID for example)

This function really just calls open/closeXMLSequence open/closeXMLItem or makeXMLElement as needed

=cut

sub returnTagAsXML
{
    my %h = (
        GRP => undef,
        ELEM => undef,
        VR => undef,
        VM => 1,
        NAME => "None",
        DCM_DICT_NAME => undef,
        VALUE => undef,
        BINARY => undef,
        CARDINALITY => 1,
        LEN => 10,
        (   parseArgs \@_, @{$Image::DCMTK::cmdLines{returnTagAsXML}}),
    );
    @h{ keys %{$Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}}}, 'NAME' } = (values %{$Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}}}, $h{DCM_DICT_NAME}) if defined $h{DCM_DICT_NAME} and defined $Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}};
    return openXMLSequence (\%h)    if ( $h{ VR }   eq 'SQ' );
    return closeXMLSequence()       if ( $h{ ELEM } eq 'E0DD' and $h{ GRP } eq 'FFFE');
    return openXMLItem(\%h)         if ( $h{ ELEM } eq 'E000' and $h{ GRP } eq 'FFFE');
    return closeXMLItem()           if ( $h{ ELEM } eq 'E00D' and $h{ GRP } eq 'FFFE');
    return makeXMLElement(\%h);
}

=head2 makeXMLElement

Return an XML formatted string version of a given "normal" DICOM tag (not a Item or a Sequence structure)

=cut

sub makeXMLElement
{
    my %h = (
        GRP => undef,
        ELEM => undef,
        VR => undef,
        VM => 1,
        LEN => undef,
        NAME => "None",
        DCM_DICT_NAME => undef,
        VALUE => undef,
        BINARY => undef,
        (   parseArgs \@_, @{$Image::DCMTK::cmdLines{makeXMLElement}}),
    );
    return if  defined $h{DCM_DICT_NAME} and not defined $Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}};
#    print formatHash \%h if not defined $h{LEN} and not defined $h{VALUE};
    $h{LEN} = length $h{VALUE} if not defined $h{LEN};
    my $binField = defined $h{BINARY} ? qq! binary="yes"! : qq!!;
    @h{ keys %{$Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}}}, 'NAME' } = (values %{$Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}}}, $h{DCM_DICT_NAME}) if defined $h{DCM_DICT_NAME} and defined $Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}};
#    print formatHash \%h if not defined $h{NAME};
#	print "Possibly Private Tag: Clearing NAME\n" if not defined $h{NAME};
	$h{NAME} = "" if not defined $h{NAME};
	return if ( $h{ VR }   eq 'SQ'  or  ( $h{ ELEM } eq 'E0DD' and $h{ GRP } eq 'FFFE') or ( $h{ ELEM } eq 'E000' and $h{ GRP } eq 'FFFE') or ( $h{ ELEM } eq 'E00D' and $h{ GRP } eq 'FFFE') );
    return if not defined $h{VALUE};
    return qq!<element tag="$h{GRP},$h{ELEM}" vr="$h{VR}" vm="$h{VM}" len="0" name="$h{NAME}"$binField></element>! if $h{VALUE} eq 'no value available';
    return qq!<element tag="$h{GRP},$h{ELEM}" vr="$h{VR}" vm="$h{VM}" len="$h{LEN}" name="$h{NAME}"$binField>$h{VALUE}</element>! if $h{VALUE} ne 'no value available';
}

=head2 openXMLItem

Return an XML formatted string of the DICOM "Open Item" tag

=cut

sub openXMLItem
{
    my %h = (
        CARDINALITY => 1,
        LEN => 10,
        (   parseArgs \@_, @{$Image::DCMTK::cmdLines{openXMLItem}}),
    );
    return qq'<item card="$h{CARDINALITY}" len="$h{LEN}">';
}

=head2 closeXMLItem

Return an XML formatted string of the DICOM "Close Item" tag

=cut


sub closeXMLItem
{
    return qq'</item>';
}

=head2 openXMLSequence

Return an XML formatted string of an DICOM "Open Sequence" tag

=cut

sub openXMLSequence
{
    my %h = (
        GRP => undef,
        ELEM => undef,
        VR => "SQ",
        CARDINALITY => 1,
        LEN => 10,
        DCM_DICT_NAME => undef,
        NAME => "None",
        (   parseArgs \@_, @{$Image::DCMTK::cmdLines{openXMLSequence}}),
    );
    @h{ keys %{$Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}}}, 'NAME' } = (values %{$Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}}}, $h{DCM_DICT_NAME}) if defined $h{DCM_DICT_NAME} and defined $Image::DCMTK::dcmtkDicomDictionary{$h{DCM_DICT_NAME}};
    return qq'<sequence tag="$h{GRP},$h{ELEM}" vr="$h{VR}" card="$h{CARDINALITY}" len="$h{LEN}" name="$h{NAME}">';
}

=head2 closeXMLSequence

Return an XML formatted string of an DICOM "Close Sequence" tag

=cut

sub closeXMLSequence
{
    return qq'</sequence>';
}

=head2 parseDCMXMLDumpForTagLists


=cut

sub parseDCMXMLDumpForTagLists
{
    my %h = (
#        DCM_DUMP    => undef,
#        DCM_TAGS_REQUESTED => undef,
        REGULAR_EXPRESSION => q%<(?'item'item).*card=\"(?'card'[0-9]+)\".*len=\"(?'len'[0-9]+)\"|<(?'sequence'sequence).*tag=\"(?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\".*vr=\"(?'vr'[a-zA-Z\?][a-zA-Z\?])\".*card=\"(?'card'[0-9]+)\".*len=\"(?'len'[0-9]+)\"|<(?'endsequence'\/sequence)|<(?'enditem'\/item)|<(?'element'element).*tag=\"(?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\".*vr=\"(?'vr'[a-zA-Z\?][a-zA-Z\?])\".*\>(?'value'.*)\<%,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{parseDCMXMLDumpForTagLists}}),
    );
    my @DCMHash;
    my $dcmDumpOrdinal = 0;
    my %reqTags = map {$_ => 1 } @{$h{DCM_TAGS_REQUESTED}};
    my %recognizedTags;
    my @sequenceNames;
    foreach my $line (@{$h{DCM_DUMP}})
    {
        $line =~ qr/$h{REGULAR_EXPRESSION}/;
        my $group;
        my $elem;
        my $vr;
        my $value;
        $group = uc($+{ group })    if defined $+{ group };
        $group = 'FFFE'             if defined $+{ item } or defined $+{ endsequence } or defined $+{ enditem };
        $elem = uc($+{ elem })      if defined $+{ elem };
        $elem = 'E000'              if defined $+{ item };
        $elem = 'E00D'              if defined $+{ enditem };
        $elem = 'E0DD'              if defined $+{ endsequence };
        $vr = uc($+{ vr })          if defined $+{ vr };
        $vr = 'IT'                  if defined $+{ item };
        $vr = 'UN'                  if defined $+{ enditem } or defined $+{ endsequence };
        $value = $+{ value }        if defined $+{ value };
        $value = $+{ card }         if defined $+{ card };
        $value = 'EndItem'          if defined $+{ enditem };
        $value = 'EndSeq'           if defined $+{ endsequence };
        next if not defined $group; # skip if unrecognized XML (like <data-set>, etc)
        next if ( uc($group) eq 'FFFC' and uc($elem) eq 'FFFC' );
        next if ( uc($group) eq '7FE0' and uc($elem) eq '0010' ); #skip pixel data
        my $name = $Image::DCMTK::reverseDicomDictionary{ $group .  $elem }->{DCM_DICT_NAME};
        $name = "PrivateTag" if not defined $name;
        push @sequenceNames, $name if $vr eq 'SQ';
        pop @sequenceNames if (uc($group) eq 'FFFE' and uc($elem) eq 'E0DD');
        my $nameWithSeq = join (".", (@sequenceNames, $name) ) if $vr ne 'SQ';
        $nameWithSeq = join (".", (@sequenceNames) ) if $vr eq 'SQ';
        push @{$recognizedTags{$nameWithSeq}}, $value if defined $reqTags{$nameWithSeq};
        push @DCMHash,
            {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $nameWithSeq,
            };
        $dcmDumpOrdinal += 1;
    }
    return {DCM_TAGS => \@DCMHash, RECOGNIZED_TAGS => \%recognizedTags };
};

=head2 parseDCMXMLDumpForSequences


=cut


sub parseDCMXMLDumpForSequences
{
    my %h = (
#        DCM_DUMP    => undef,
#        DCM_SEQUENCES_REQUESTED => undef,
        REGULAR_EXPRESSION => q%<(?'item'item).*card=\"(?'card'[0-9]+)\".*len=\"(?'len'[0-9]+)\"|<(?'sequence'sequence).*tag=\"(?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\".*vr=\"(?'vr'[a-zA-Z\?][a-zA-Z\?])\".*card=\"(?'card'[0-9]+)\".*len=\"(?'len'[0-9]+)\"|<(?'endsequence'\/sequence)|<(?'enditem'\/item)|<(?'element'element).*tag=\"(?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\".*vr=\"(?'vr'[a-zA-Z\?][a-zA-Z\?])\".*\>(?'value'.*)\<%,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{parseDCMXMLDumpForSequences}}),
    );
    my @DCMHash;
    my $dcmDumpOrdinal = 0;
    my %reqTags = map {$_ => 1 } @{$h{DCM_SEQUENCES_REQUESTED}};
    my %recognizedSequences;
    my $foundASeq;
    my $seqDepth = 0;
    my $sequenceName;
    foreach my $line (@{$h{DCM_DUMP}})
    {
        $line =~ qr/$h{REGULAR_EXPRESSION}/;
        my $group;
        my $elem;
        my $vr;
        my $value;
        $group = $+{ group }    if defined $+{ group };
        $group = 'FFFE'         if defined $+{ item } or defined $+{ endsequence } or defined $+{ enditem };
        $elem = $+{ elem }      if defined $+{ elem };
        $elem = 'E000'          if defined $+{ item };
        $elem = 'E00D'          if defined $+{ enditem };
        $elem = 'E0DD'          if defined $+{ endsequence };
        $vr = $+{ vr }          if defined $+{ vr };
        $vr = 'IT'              if defined $+{ item };
        $vr = 'UN'              if defined $+{ enditem } or defined $+{ endsequence };
        $value = $+{ value }    if defined $+{ value };
        $value = $+{ card }     if defined $+{ card };
        $value = 'EndItem'      if defined $+{ enditem };
        $value = 'EndSeq'       if defined $+{ endsequence };
        next if not defined $group; # skip if unrecognized XML (like <data-set>, etc)
        next if ( uc($group) eq 'FFFC' and uc($elem) eq 'FFFC' );
        next if ( uc($group) eq '7FE0' and uc($elem) eq '0010' ); #skip pixel data
        my $name = $Image::DCMTK::reverseDicomDictionary{ $group .  $elem }->{DCM_DICT_NAME};
        $name = "PrivateTag" if not defined $name;
        push @DCMHash,
            {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $name,
            };
        if (defined $reqTags{$name} and not defined $foundASeq)
        {
            $foundASeq = 'yes';
            $sequenceName = $name;
            ++$seqDepth;
            push @{$recognizedSequences{$sequenceName}},
                {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $name,
                    };
            $dcmDumpOrdinal += 1;
            next;
        }
        if (defined $foundASeq)
        {
            push @{$recognizedSequences{$sequenceName}},
                {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $name,
                    };
            --$seqDepth if (uc($group) eq 'FFFE' and uc($elem) eq 'E0DD');
            undef $foundASeq if $seqDepth == 0;
            ++$seqDepth if uc($vr) eq 'SQ';
        }
        $dcmDumpOrdinal += 1;
    }
    return {DCM_TAGS => \@DCMHash, RECOGNIZED_SEQUENCES => \%recognizedSequences };
};

=head2 parseDCMXMLDump


=cut

sub parseDCMXMLDump
{
    my %h = (
#        DCM_DUMP    => undef,
#        DCM_TAGS_REQUESTED => undef,
        REGULAR_EXPRESSION => q%<(?'item'item).*card=\"(?'card'[0-9]+)\".*len=\"(?'len'[0-9]+)\"|<(?'sequence'sequence).*tag=\"(?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\".*vr=\"(?'vr'[a-zA-Z\?][a-zA-Z\?])\".*card=\"(?'card'[0-9]+)\".*len=\"(?'len'[0-9]+)\"|<(?'endsequence'\/sequence)|<(?'enditem'\/item)|<(?'element'element).*tag=\"(?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\".*vr=\"(?'vr'[a-zA-Z\?][a-zA-Z\?])\".*\>(?'value'.*)\<%,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{parseDCMXMLDump}}),
    );
    my $retref = parseDCMXMLDumpForTagLists \%h;
    my %recognizedTags;
    while (my ($key, $val) = each  %{ $retref->{ RECOGNIZED_TAGS }} )
    {
        $recognizedTags{$key} = @{$val}[0] if defined @{$val}[0];
    }
    return {DCM_TAGS =>  $retref->{ DCM_TAGS }, RECOGNIZED_TAGS => \%recognizedTags };
};

=head2 parseDCMDumpForSequences


=cut


sub parseDCMDumpForSequences
{
    my %h = (
#        DCM_DUMP    => undef,
#        DCM_SEQUENCES_REQUESTED => undef,
         REGULAR_EXPRESSION => q%^\s*\((?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\)\s*(?'vr'[a-zA-Z\?][a-zA-Z\?])\s*\[?\(?(?'value'.*)\)?\]?.*?$%,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{parseDCMDumpForSequences}}),
    );
    my @filteredDCMDump;
    my @DCMHash;
    my $dcmDumpOrdinal = 0;
    my %reqTags = map {$_ => 1 } @{$h{DCM_SEQUENCES_REQUESTED}};
    my %recognizedSequences;
    my $foundASeq;
    my $seqDepth = 0;
    my $sequenceName;
    #needed to handle embeded new lines
    foreach my $line (@{$h{DCM_DUMP}})
    {
        $line =~ s/#.*?//;
        if ($line =~ /\s*\([0-9a-fA-F]{4}\,[0-9a-fA-F]{4}\)/ )
        {
            push @filteredDCMDump, $line;
        }
        else
        {
            my $newline = pop @filteredDCMDump;
            $newline =~ s/\r//g                         if defined $newline;
            $newline =~ s/\n//g                         if defined $newline;
            $newline = $newline . "&#13;&#10;" . $line  if defined $newline;
            push @filteredDCMDump, $newline             if defined $newline;
        }
    }
    foreach my $line (@filteredDCMDump)
    {
        $line =~ qr/$h{REGULAR_EXPRESSION}/;
        my $group = $+{ group };
        my $elem = $+{ elem };
        my $vr = $+{ vr };
        my $value = $+{ value };
        $value =~ s/\)\s*$//;
        $value =~ s/\]\s*$//;
        $value =~ s/\s+$//;
        my $name = $Image::DCMTK::reverseDicomDictionary{ $group .  $elem }->{DCM_DICT_NAME};
        $name = "PrivateTag" if not defined $name;
        push @DCMHash,
            {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $name,
            };
        if (defined $reqTags{$name} and not defined $foundASeq)
        {
            $foundASeq = 'yes';
            $sequenceName = $name;
            ++$seqDepth;
            push @{$recognizedSequences{$sequenceName}},
                {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $name,
                    };
            $dcmDumpOrdinal += 1;
            next;
        }
        if (defined $foundASeq)
        {
            push @{$recognizedSequences{$sequenceName}},
                {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $name,
                    };
            --$seqDepth if (uc($group) eq 'FFFE' and uc($elem) eq 'E0DD');
            undef $foundASeq if $seqDepth == 0;
            ++$seqDepth if uc($vr) eq 'SQ';
        }
        $dcmDumpOrdinal += 1;
    }
    return {DCM_TAGS => \@DCMHash, RECOGNIZED_SEQUENCES => \%recognizedSequences };
};

=head2 parseDCMDumpForTagLists


=cut

sub parseDCMDumpForTagLists
{
    my %h = (
#        DCM_DUMP    => undef,
#        DCM_TAGS_REQUESTED => undef,
         REGULAR_EXPRESSION => q%^\s*\((?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\)\s*(?'vr'[a-zA-Z\?][a-zA-Z\?])\s*\[?\(?(?'value'.*)\)?\]?.*?$%,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{parseDCMDumpForTagLists}}),
    );
    my @filteredDCMDump;
    my @DCMHash;
    my $dcmDumpOrdinal = 0;
    my %reqTags = map {$_ => 1 } @{$h{DCM_TAGS_REQUESTED}};
    my %recognizedTags;
    my @sequenceNames;
    #needed to handle embeded new lines
    foreach my $line (@{$h{DCM_DUMP}})
    {
        $line =~ s/#[^\)\]]*?$//;
        if ($line =~ /\s*\([0-9a-fA-F]{4}\,[0-9a-fA-F]{4}\)/ )
        {
            push @filteredDCMDump, $line;
        }
        elsif ($line =~ /^\s*$/)
        {
        }
        else
        {
            my $newline = pop @filteredDCMDump;
            $newline =~ s/\r//g                         if defined $newline;
            $newline =~ s/\n//g                         if defined $newline;
            $newline = $newline . "&#13;&#10;" . $line  if defined $newline;
            push @filteredDCMDump, $newline             if defined $newline;
        }
    }
    foreach my $line (@filteredDCMDump)
    {
        $line =~ qr/$h{REGULAR_EXPRESSION}/;
        my $group = uc($+{ group });
        my $elem = uc($+{ elem });
        my $vr = $+{ vr };
        my $value = $+{ value };
        next if not defined $value;
        $value =~ s/\)\s*$//;
        $value =~ s/\]\s*$//;
        $value =~ s/\s+$//;
        my $name = $Image::DCMTK::reverseDicomDictionary{ $group .  $elem }->{DCM_DICT_NAME};
        $name = "PrivateTag" if not defined $name;

        push @sequenceNames, $name if $vr eq 'SQ';
        pop @sequenceNames if (uc($group) eq 'FFFE' and uc($elem) eq 'E0DD');
        my $nameWithSeq = join (".", (@sequenceNames, $name) ) if $vr ne 'SQ';
        $nameWithSeq = join (".", (@sequenceNames) ) if $vr eq 'SQ';
        push @{$recognizedTags{$nameWithSeq}}, $value if defined $reqTags{$nameWithSeq};
        push @DCMHash,
            {
            ORDINAL => $dcmDumpOrdinal,
            GRP     => $group,
            ELEM    => $elem,
            VR      => $vr,
            VALUE   => $value,
            NAME    => $nameWithSeq,
            };
        $dcmDumpOrdinal += 1;
    }

    return {DCM_TAGS => \@DCMHash, RECOGNIZED_TAGS => \%recognizedTags };
};

=head2 parseDCMDump


=cut

sub parseDCMDump
{
    my %h = (
#        DCM_DUMP    => undef,
#        DCM_TAGS_REQUESTED => undef,
         REGULAR_EXPRESSION => q%^\s*\((?'group'[0-9a-fA-F]{4})\,(?'elem'[0-9a-fA-F]{4})\)\s*(?'vr'[a-zA-Z\?][a-zA-Z\?])\s*\[?\(?(?'value'.*)\)?\]?.*?$%,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{parseDCMDump}}),
    );
    my $retref = parseDCMDumpForTagLists \%h;
    my %recognizedTags;
    while (my ($key, $val) = each  %{ $retref->{ RECOGNIZED_TAGS }} )
    {
        $recognizedTags{$key} = @{$val}[0] if defined @{$val}[0];
    }
    return {DCM_TAGS =>  $retref->{ DCM_TAGS }, RECOGNIZED_TAGS => \%recognizedTags };
};

=head2 modifyAnImage


=cut

sub modifyAnImage
{
    my %h = (
#        SOURCE_FILENAME    => undef,
#        DESTINATION_FILENAME    => undef,
#        TAG_CHANGE_LINE => undef,
        DEBUG => 0,
        ( parseArgs \@_, @{$Image::DCMTK::cmdLines{modifyAnImage}}),
    );
    my $inFilename    = $h{SOURCE_FILENAME};
    my $outFilename   = $h{DESTINATION_FILENAME};
    my $tagChangeLine = $h{TAG_CHANGE_LINE};
    qx%cp -p $inFilename $outFilename% if ( $inFilename ne $outFilename );
    my $commandLine = qq(dcmodify -m "${tagChangeLine}" ${outFilename});
    print "$commandLine \n" if $h{DEBUG};
    my @results = qx/$commandLine/;
    if ($? > 0)
    {
        $commandLine = qq(dcmodify -i "${tagChangeLine}" ${outFilename});
        print "$commandLine \n" if $h{DEBUG};
        @results = qx/$commandLine/;
    }
    my $bakfile = ${outFilename} . ".bak";
    qx[rm -f ${bakfile}] if ( -e ${bakfile} );
    return @results;
}


=head1 AUTHOR

Robert Haxton, C<< <robert.haxton at gmail.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<bug-dcmtk-dicomtags at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Image-DCMTK>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.




=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Image::DCMTK


You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Image-DCMTK>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Image-DCMTK>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Image-DCMTK>

=item * Search CPAN

L<http://search.cpan.org/dist/Image-DCMTK/>

=item * Code Repository

L<https://code.google.com/p/Image-DCMTK/>

=back


=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2008-2012 Robert Haxton.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut

1; # End of Image::DCMTK
