#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Include Windows.h.
#   - Cast to silence warning.
#   - Fixup includes.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/uuid_time.c	Sun Jan 14 15:29:18 2024
+++ ulib/uuid/uuid_time.c	Sun Jan 14 15:30:20 2024
@@ -34,21 +34,9 @@
  * %End-Header%
  */
 
-#include "config.h"
+#include "uuconfig.h"
+#include "uuid/uuidP.h"
 
-#include <stdio.h>
-#ifdef HAVE_UNISTD_H
-#include <unistd.h>
-#endif
-#include <stdlib.h>
-#include <sys/types.h>
-#ifdef HAVE_SYS_TIME_H
-#include <sys/time.h>
-#endif
-#include <time.h>
-
-#include "uuidP.h"
-
 time_t myuuid_time(const myuuid_t uu, struct timeval *ret_tv)
 {
 	struct timeval		tv;
@@ -62,7 +50,7 @@
 	clock_reg = uuid.time_low | ((myuint64_t) high << 32);
 
 	clock_reg -= (((myuint64_t) 0x01B21DD2) << 32) + 0x13814000;
-	tv.tv_sec = clock_reg / 10000000;
+	tv.tv_sec = (long)(clock_reg / 10000000);
 	tv.tv_usec = (clock_reg % 10000000) / 10;
 
 	if (ret_tv)

