package API::MailboxOrg::API::Utils;

# ABSTRACT: MailboxOrg::API::Utils

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int InstanceOf ArrayRef);
use API::MailboxOrg::Types qw(HashRefRestricted Boolean);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.2'; # VERSION

my %validators = (
    'validator' => validation_for(
        params => {
            value => { type => Str, optional => 0 },
            type  => { type => Enum[qw(hostname domain mailhost mail account pass pass2 memo user contextid name)], optional => 0 },

        },
    ),

);


sub validator ($self, %params) {
    my $validator = $validators{'validator'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'utils.validator', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Utils - MailboxOrg::API::Utils

=head1 VERSION

version 1.0.2

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 validator

Performs a validation

Parameters:

=over 4

=item * value

=item * type

=back

returns: boolean

    $api->utils->validator(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
