package Data::Password::zxcvbn::AdjacencyGraph::French;
use strict;
use warnings;
# VERSION
# ABSTRACT: adjacency graphs for common French keyboards

=head1 DESCRIPTION

This is a data file used by L<<
C<Data::Password::zxcvbn::Match::Spatial> >>, and is generated by the
L<<
C<build-keyboard-adjacency-graphs>|https://bitbucket.org/broadbean/p5-data-password-zxcvbn-french/src/master/maint/build-keyboard-adjacency-graphs
>> program when building the distribution.


=cut

our %graphs = (
  'azerty' => {
    'average_degree' => '4.6046511627907',
    'keys' => {
      '!' => [
        ':/',
        'mM',
        '%%',
        undef,
        undef,
        undef,
      ],
      '"' => [
        '~2',
        undef,
        undef,
        '\'4',
        'eE',
        'zZ',
      ],
      '$' => [
        undef,
        '+=',
        undef,
        undef,
        '**',
        '%%',
      ],
      '%' => [
        'mM',
        undef,
        '$$',
        '**',
        undef,
        '!!',
      ],
      '&' => [
        undef,
        undef,
        undef,
        '~2',
        'aA',
        undef,
      ],
      '\'' => [
        '"3',
        undef,
        undef,
        '(5',
        'rR',
        'eE',
      ],
      '(' => [
        '\'4',
        undef,
        undef,
        '-6',
        'tT',
        'rR',
      ],
      ')' => [
        '@0',
        undef,
        undef,
        '+=',
        undef,
        'pP',
      ],
      '*' => [
        '%%',
        '$$',
        undef,
        undef,
        undef,
        undef,
      ],
      '+' => [
        ')]',
        undef,
        undef,
        undef,
        '$$',
        undef,
      ],
      ',' => [
        'nN',
        'jJ',
        'kK',
        ';.',
        undef,
        undef,
      ],
      '-' => [
        '(5',
        undef,
        undef,
        '`7',
        'yY',
        'tT',
      ],
      '.' => [
        ',?',
        'kK',
        'lL',
        ':/',
        undef,
        undef,
      ],
      '/' => [
        ';.',
        'lL',
        'mM',
        '!!',
        undef,
        undef,
      ],
      '0' => [
        '^9',
        undef,
        undef,
        ')]',
        'pP',
        'oO',
      ],
      '1' => [
        undef,
        undef,
        undef,
        '~2',
        'aA',
        undef,
      ],
      '2' => [
        '&1',
        undef,
        undef,
        '"3',
        'zZ',
        'aA',
      ],
      '3' => [
        '~2',
        undef,
        undef,
        '\'4',
        'eE',
        'zZ',
      ],
      '4' => [
        '"3',
        undef,
        undef,
        '(5',
        'rR',
        'eE',
      ],
      '5' => [
        '\'4',
        undef,
        undef,
        '-6',
        'tT',
        'rR',
      ],
      '6' => [
        '(5',
        undef,
        undef,
        '`7',
        'yY',
        'tT',
      ],
      '7' => [
        '-6',
        undef,
        undef,
        '_8',
        'uU',
        'yY',
      ],
      '8' => [
        '`7',
        undef,
        undef,
        '^9',
        'iI',
        'uU',
      ],
      '9' => [
        '_8',
        undef,
        undef,
        '@0',
        'oO',
        'iI',
      ],
      ':' => [
        ';.',
        'lL',
        'mM',
        '!!',
        undef,
        undef,
      ],
      ';' => [
        ',?',
        'kK',
        'lL',
        ':/',
        undef,
        undef,
      ],
      '=' => [
        ')]',
        undef,
        undef,
        undef,
        '$$',
        undef,
      ],
      '?' => [
        'nN',
        'jJ',
        'kK',
        ';.',
        undef,
        undef,
      ],
      '@' => [
        '^9',
        undef,
        undef,
        ')]',
        'pP',
        'oO',
      ],
      'A' => [
        undef,
        '&1',
        '~2',
        'zZ',
        'qQ',
        undef,
      ],
      'B' => [
        'vV',
        'gG',
        'hH',
        'nN',
        undef,
        undef,
      ],
      'C' => [
        'xX',
        'dD',
        'fF',
        'vV',
        undef,
        undef,
      ],
      'D' => [
        'sS',
        'eE',
        'rR',
        'fF',
        'cC',
        'xX',
      ],
      'E' => [
        'zZ',
        '"3',
        '\'4',
        'rR',
        'dD',
        'sS',
      ],
      'F' => [
        'dD',
        'rR',
        'tT',
        'gG',
        'vV',
        'cC',
      ],
      'G' => [
        'fF',
        'tT',
        'yY',
        'hH',
        'bB',
        'vV',
      ],
      'H' => [
        'gG',
        'yY',
        'uU',
        'jJ',
        'nN',
        'bB',
      ],
      'I' => [
        'uU',
        '_8',
        '^9',
        'oO',
        'kK',
        'jJ',
      ],
      'J' => [
        'hH',
        'uU',
        'iI',
        'kK',
        ',?',
        'nN',
      ],
      'K' => [
        'jJ',
        'iI',
        'oO',
        'lL',
        ';.',
        ',?',
      ],
      'L' => [
        'kK',
        'oO',
        'pP',
        'mM',
        ':/',
        ';.',
      ],
      'M' => [
        'lL',
        'pP',
        undef,
        '%%',
        '!!',
        ':/',
      ],
      'N' => [
        'bB',
        'hH',
        'jJ',
        ',?',
        undef,
        undef,
      ],
      'O' => [
        'iI',
        '^9',
        '@0',
        'pP',
        'lL',
        'kK',
      ],
      'P' => [
        'oO',
        '@0',
        ')]',
        undef,
        'mM',
        'lL',
      ],
      'Q' => [
        undef,
        'aA',
        'zZ',
        'sS',
        'wW',
        undef,
      ],
      'R' => [
        'eE',
        '\'4',
        '(5',
        'tT',
        'fF',
        'dD',
      ],
      'S' => [
        'qQ',
        'zZ',
        'eE',
        'dD',
        'xX',
        'wW',
      ],
      'T' => [
        'rR',
        '(5',
        '-6',
        'yY',
        'gG',
        'fF',
      ],
      'U' => [
        'yY',
        '`7',
        '_8',
        'iI',
        'jJ',
        'hH',
      ],
      'V' => [
        'cC',
        'fF',
        'gG',
        'bB',
        undef,
        undef,
      ],
      'W' => [
        undef,
        'qQ',
        'sS',
        'xX',
        undef,
        undef,
      ],
      'X' => [
        'wW',
        'sS',
        'dD',
        'cC',
        undef,
        undef,
      ],
      'Y' => [
        'tT',
        '-6',
        '`7',
        'uU',
        'hH',
        'gG',
      ],
      'Z' => [
        'aA',
        '~2',
        '"3',
        'eE',
        'sS',
        'qQ',
      ],
      ']' => [
        '@0',
        undef,
        undef,
        '+=',
        undef,
        'pP',
      ],
      '^' => [
        '_8',
        undef,
        undef,
        '@0',
        'oO',
        'iI',
      ],
      '_' => [
        '`7',
        undef,
        undef,
        '^9',
        'iI',
        'uU',
      ],
      '`' => [
        '-6',
        undef,
        undef,
        '_8',
        'uU',
        'yY',
      ],
      'a' => [
        undef,
        '&1',
        '~2',
        'zZ',
        'qQ',
        undef,
      ],
      'b' => [
        'vV',
        'gG',
        'hH',
        'nN',
        undef,
        undef,
      ],
      'c' => [
        'xX',
        'dD',
        'fF',
        'vV',
        undef,
        undef,
      ],
      'd' => [
        'sS',
        'eE',
        'rR',
        'fF',
        'cC',
        'xX',
      ],
      'e' => [
        'zZ',
        '"3',
        '\'4',
        'rR',
        'dD',
        'sS',
      ],
      'f' => [
        'dD',
        'rR',
        'tT',
        'gG',
        'vV',
        'cC',
      ],
      'g' => [
        'fF',
        'tT',
        'yY',
        'hH',
        'bB',
        'vV',
      ],
      'h' => [
        'gG',
        'yY',
        'uU',
        'jJ',
        'nN',
        'bB',
      ],
      'i' => [
        'uU',
        '_8',
        '^9',
        'oO',
        'kK',
        'jJ',
      ],
      'j' => [
        'hH',
        'uU',
        'iI',
        'kK',
        ',?',
        'nN',
      ],
      'k' => [
        'jJ',
        'iI',
        'oO',
        'lL',
        ';.',
        ',?',
      ],
      'l' => [
        'kK',
        'oO',
        'pP',
        'mM',
        ':/',
        ';.',
      ],
      'm' => [
        'lL',
        'pP',
        undef,
        '%%',
        '!!',
        ':/',
      ],
      'n' => [
        'bB',
        'hH',
        'jJ',
        ',?',
        undef,
        undef,
      ],
      'o' => [
        'iI',
        '^9',
        '@0',
        'pP',
        'lL',
        'kK',
      ],
      'p' => [
        'oO',
        '@0',
        ')]',
        undef,
        'mM',
        'lL',
      ],
      'q' => [
        undef,
        'aA',
        'zZ',
        'sS',
        'wW',
        undef,
      ],
      'r' => [
        'eE',
        '\'4',
        '(5',
        'tT',
        'fF',
        'dD',
      ],
      's' => [
        'qQ',
        'zZ',
        'eE',
        'dD',
        'xX',
        'wW',
      ],
      't' => [
        'rR',
        '(5',
        '-6',
        'yY',
        'gG',
        'fF',
      ],
      'u' => [
        'yY',
        '`7',
        '_8',
        'iI',
        'jJ',
        'hH',
      ],
      'v' => [
        'cC',
        'fF',
        'gG',
        'bB',
        undef,
        undef,
      ],
      'w' => [
        undef,
        'qQ',
        'sS',
        'xX',
        undef,
        undef,
      ],
      'x' => [
        'wW',
        'sS',
        'dD',
        'cC',
        undef,
        undef,
      ],
      'y' => [
        'tT',
        '-6',
        '`7',
        'uU',
        'hH',
        'gG',
      ],
      'z' => [
        'aA',
        '~2',
        '"3',
        'eE',
        'sS',
        'qQ',
      ],
      '~' => [
        '&1',
        undef,
        undef,
        '"3',
        'zZ',
        'aA',
      ],
    },
    'starting_positions' => 86,
  },
)
;

1;
