#! /usr/bin/perl -w
################################################################################
#
# while.t (Test the PML while and until functions)
#
################################################################################
#
# Includes
#
################################################################################
use strict;
use Test;
################################################################################
#
# Setup
#
################################################################################
BEGIN {
	plan test => 15
} use PML;
################################################################################
#
# Start
#
################################################################################
my ($parser, @code, $output);

$parser = new PML;
@code = <DATA>;
$parser->parse(\@code); ok(1);
$output = $parser->execute;

foreach (1..14) {
	if ($output =~ /$_/) {
		ok(1);
	} else {
		ok(0);
	}
}
################################################################################
#                              END-OF-SCRIPT                                   #
################################################################################
__END__
# This is PML for Testing
@set('x', 1)
#
@while(${x}) {
${x}
@perl{++$v{x} == 8 and $v{x} = 0; undef}
}
#
@set('y', 8)
@until(${x}) {
${y}
@perl {++$v{y} == 15 and $v{x} = 1; undef}
}
