use strict;
use FileHandle;
use Crypt::SHAVS;
use Digest::SHA qw(sha384);

my ($vectors, $check) = ("vec$$.tmp", "chk$$.tmp");
END { 1 while unlink ($vectors, $check) }

my $numtests = 0;
my $fh = FileHandle->new($vectors, "w");
while (<DATA>) { print $fh $_; $numtests++ if /^MD\s*=/ }  close($fh);

$fh = FileHandle->new($check, "w+");
my $stdout = select($fh);
Crypt::SHAVS->new(\&sha384)->check($vectors);
select($stdout);

my $testnum = 1;
print "1..$numtests\n";
$fh->seek(0, 0);
while (<$fh>) {
	print "not " unless /OK\s*$/;
	print "ok ", $testnum++, "\n";
}
close($fh);

__DATA__
#  CAVS 11.0
#  "SHA-384 LongMsg" information 
#  SHA-384 tests are configured for BYTE oriented implementations
#  Generated on Tue Mar 15 08:23:40 2011

[L = 48]

Len = 1816
Msg = 62c6a169b9be02b3d7b471a964fc0bcc72b480d26aecb2ed460b7f50016ddaf04c51218783f3aadfdff5a04ded030d7b3fb7376b61ba30b90e2da921a4470740d63fb99fa16cc8ed81abaf8ce4016e50df81da832070372c24a80890aa3a26fa675710b8fb718266249d496f313c55d0bada101f8f56eeccee4345a8f98f60a36662cfda794900d12f9414fcbdfdeb85388a814996b47e24d5c8086e7a8edcc53d299d0d033e6bb60c58b83d6e8b57f6c258d6081dd10eb942fdf8ec157ec3e75371235a8196eb9d22b1de3a2d30c2abbe0db7650cf6c7159bacbe29b3a93c92100508
MD = 0730e184e7795575569f87030260bb8e54498e0e5d096b18285e988d245b6f3486d1f2447d5f85bcbe59d5689fc49425

Len = 2608
Msg = ffd67890ff77f344ad4f067df2f4ff1db8f541c7a2bd9ae9fabad0faebbf7d00f0a71d568c3c66ac3c57d84faa4894ab2377710e4b4c4dae0f4da1eedc8658dd0e2ee2ffac8784515206f2876eb41f98afd4547cbbc68034212bcf0c8e4a7d1d43b3ed15c621f53bd8a57cada80148ec4652119b5af3da84169d81dc69d394c8767d662044d36272b77ca04abff7b6b0cf3bd1f3919a04a5d8ebdfe7d6e844e78fd576a68d6373ffd5d384e51b5e12ec32d5bb0ac685a59f4d5d12b43b533580750345310999cfe91cf2500624fe03a65769f86a627a667b5f3b42cb01da109e124ffa48203f1f3873202d35429f32e8263eaf9bce42ef40f5cc96b591467d464d00bd743a1b0af4c1a743fbdd0846b9879e092371a5e7f6f65937f9515e23820e60b83bbff73926f0cdb9df5d02e82262cf2e8cb26af6a64c2a4d1fabecab593db510281799
MD = 1396fea95ce0c1c1c224b50a07dd7197f1d62b993c7fe9e1cc1a56101920d4b0fecef587fbcd56b854c8c9da95132f02

Len = 3400
Msg = be105a6c585a766aa1f290b632219ff864ea6674b5e3f9846d447d46813e2f92b78ea82f0b515f46511a6f161d429aeae07f8e4853b8686c191877f5a06242dd4884ccaec76e16f3cc24e6ede212c78897a1518dde07aa19b3634d4efd090a48b81a4e535359a55b57397da44a3b2dbbd37636ac1f77c875824c88bb62dc90bc517ab78579b913643d81bda11d62d469da29c50bdbb1c967d0fcafa29582db1f59c98fabff3669f8c4232d4d2332c57bf6e08613dd5db5d6e39b4a6d5fa4f35b19325c2fae79aefe36485610235007da6cc3022cec2295ac0550e18388eae156d9dba8784e2aea5ed917be53e767a26c87fcc0bfcfa870d07b43fd4cd8fbacfae1ecfaeea7f12600f6b9ef7c351d9f1b8eb048324f984e2a909d253017805c2d788edbf9807469ccd45571f5d61a05cec80a23ef349a37a28b86e2970c20fad9e7e8d201a35ebbaabd14ca249207dc6d7e2fd85c46553420b325bbe980848de57724676ed6552482f71e8473308c2ddff94aefe34c724c8c52a3388e3b541d396d6722a8e201ad3ccb9a26497a50ff0e7e81f1eb109888ceae27e1ef0537b3bd14dc8c178f0c5dc081
MD = 39cf9206d78cfb437000b100661753181b5f262b539c208b442e7a022cd3234c58751621ff0ee9e9d3607174e36aaa88

Len = 4192
Msg = b41ef4a2b31d3a47a5e8386925fb90fbe980ca2cf6ba34e814a3eca280d43b51e2a624b87e973debaeefbe0f90a3d861fc79487ab96d2bd1f0531481e0bf5c4cd422b9e05235125a969b92093fc2fc74470a3e9e382948889dce1ef8b7842c7972d9dba397c0619c4335dddf981fa33cb27ad420ddb533170559338f6eec55dfa515b088b601d1ba9f04c61a058476c2261334890fdb93850e3f7bcf6bbf7c86531c631715bd0bbb91527641ecb71c0d891b8361356110dba2c61d3f17c54c7765381ad81dbfb7a7006515dcb7813e25c5dbec2eb9105320a8384268dac56ab9c4aefd5436ce7c87d687ca73cdaa8413c09b957a02b0045c08db11d01d89815456c93612c9b10262fafdbd8f96fa95de64a3a6cc7809cb98aaf8b30146d7375105d0ea9a3c31f240541217b77a391a8e973a48ad83e24edb76d64f83bf7834b7b80a4475f916f429cc0d0074e12eba2c43a9a2a48b05382d54bf0edcee34218e57c0692a6628af264a359f4d33a21ebf4f39de39f8382f962cf918963dd2a6dfc93b8441ed2ecc3eb6d41dcad85dee4fa32f21f43244db1fe6cd9438131c6ab1f8c0bb43f5f2f27af830a1733927d1e527d6965ea1f1e6cf6a83aa4bd7d8160ccb9a36b7e53acae0f89154d1bcc86f87c37562feae06f5afa0638456f3cf51f82a0f1e2527cffc7b9f415e6bca0771405f53b05cbf4db3c570b547e1cec9c47efd699b1522792f50d387e6c9
MD = 0f8ff0eee8ffdefb8b3151b7664ce9dcaaaf3f7af0b1e290ee49ba211b67863f63fa71202a534c0c42444a52bebf6c62
