/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.Bucket;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryHelloCommand;
import org.couchbase.mock.memcached.protocol.BinaryHelloResponse;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class HelloCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        if (server.getBucket().getType() != Bucket.BucketType.COUCHBASE) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.NOT_SUPPORTED));
        }
        BinaryHelloCommand hcmd = (BinaryHelloCommand)cmd;
        client.setSupportedFeatures(hcmd.getFeatures());
        boolean[] featuresSparse = client.getSupportedFeatures();
        int numFeatures = 0;
        for (boolean b : featuresSparse) {
            if (!b) continue;
            ++numFeatures;
        }
        int outIndex = 0;
        int[] featuresArray = new int[numFeatures];
        for (int i = 0; i < featuresSparse.length; ++i) {
            if (!featuresSparse[i]) continue;
            featuresArray[outIndex++] = i;
        }
        client.sendResponse(new BinaryHelloResponse(hcmd, featuresArray));
    }
}

