/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.wkt;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.Characters;

public abstract class FirstKeywordPeek {
    protected static final int REJECT = 0;
    protected static final int ACCEPT = 1;
    protected static final int IGNORE = 2;
    static final int READ_AHEAD_LIMIT = 2048;
    protected static final char COMMENT = '#';
    protected final int maxLength;

    public FirstKeywordPeek(int n) {
        this.maxLength = n;
    }

    private static int nextAfterSpaces(ByteBuffer byteBuffer, Reader reader) throws IOException {
        int n;
        if (byteBuffer != null) {
            while (byteBuffer.hasRemaining()) {
                char c = (char)byteBuffer.get();
                if (Character.isWhitespace(c)) continue;
                return c;
            }
            return -1;
        }
        while ((n = IOUtilities.readCodePoint(reader)) >= 0 && Character.isWhitespace(n)) {
        }
        return n;
    }

    private static void toEndOfLine(ByteBuffer byteBuffer, Reader reader) throws IOException {
        int n;
        do {
            if (byteBuffer != null) {
                if (!byteBuffer.hasRemaining()) break;
                n = (char)byteBuffer.get();
                continue;
            }
            n = IOUtilities.readCodePoint(reader);
            if (n < 0) break;
        } while (!Characters.isLineOrParagraphSeparator(n));
    }

    protected int isKeywordChar(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n == 95 ? 1 : 0;
    }

    public final ProbeResult probeContent(StorageConnector storageConnector) throws DataStoreException {
        char[] cArray = null;
        int n = 0;
        try {
            int n2;
            Reader reader;
            ByteBuffer byteBuffer = storageConnector.getStorageAs(ByteBuffer.class);
            if (byteBuffer != null) {
                byteBuffer.mark();
                reader = null;
            } else {
                reader = storageConnector.getStorageAs(Reader.class);
                if (reader == null) {
                    return ProbeResult.UNSUPPORTED_STORAGE;
                }
                reader.mark(2048);
            }
            while ((n2 = FirstKeywordPeek.nextAfterSpaces(byteBuffer, reader)) == 35) {
                FirstKeywordPeek.toEndOfLine(byteBuffer, reader);
            }
            int n3 = this.isKeywordChar(n2);
            if (n3 >= 1) {
                cArray = new char[this.maxLength];
                do {
                    if (n3 != 1) continue;
                    if (n >= cArray.length) {
                        n = 0;
                        break;
                    }
                    cArray[n++] = (char)n2;
                } while ((n3 = this.isKeywordChar(n2 = byteBuffer == null ? IOUtilities.readCodePoint(reader) : (byteBuffer.hasRemaining() ? (int)byteBuffer.get() : -1))) >= 1);
                if (Character.isWhitespace(n2)) {
                    n2 = FirstKeywordPeek.nextAfterSpaces(byteBuffer, reader);
                }
                if (!this.isPostKeyword(n2)) {
                    n = 0;
                }
            }
            if (byteBuffer != null) {
                byteBuffer.reset();
            } else {
                reader.reset();
            }
            if (n2 < 0) {
                return ProbeResult.INSUFFICIENT_BYTES;
            }
        }
        catch (IOException iOException) {
            throw new DataStoreException(iOException);
        }
        return this.forKeyword(cArray, n);
    }

    protected abstract boolean isPostKeyword(int var1);

    protected abstract ProbeResult forKeyword(char[] var1, int var2);
}

